% estimation of cross-spectra.
%
%            c=crosspec(x,y,m,method)
%
% m is the lag window size;  method is the window type which
% can be 'bartlett', 'hamming', or 'hanning' (other windows
% can be constructed by the user). If method is unspecified
% a bartlett window is used.
% frequencies are calculated at 128 equally
% spaced points between 0 and 2*pi-2*pi/128.
function c=crosspec(x,y,m,method)
omega=0:2*pi/128:2*pi-2*pi/128;
if nargin==3, 
method='bartlett'; 
end
C=crosscov(x,y,m).*feval(method,2*m+1);
c=(C'*exp(-i*(-m:m)'*omega))';
