%plotEH.m

function plotEH(data,vars,slope,use_yields,shock_extract)

[nimp,temp,temp]=size(data);
[nvars,temp]=size(vars);

if shock_extract == 1;
    if slope == 0;
        poslong = nvars+1;     %long rate is first in Uhlig-VAR on level
        if use_yields == 2;
            posspread = 2*nvars+4;  %spread is second-to-last since inferred from long rate and ffr; last element is FEV share of spread
        else
            posspread = nvars+2;    %spread is second in Uhlig-VAR on level
        end    
    elseif slope == 1;
        posspread = nvars+1;     %spread is first in Uhlig-Var on spread
        if use_yields == 2
            poslong = 2*nvars+4;    %long rate is second-to-last since inferred from spread and ffr; last element is FEV share of long rate
        else
            poslong = nvars+2;        %long rate is second in Uhlig-VAR on spread
        end
    end  
    
elseif shock_extract == 2 || shock_extract == 3;
    if slope == 0
        if use_yields == 2
            posspread = 2*nvars+4;    %spread is second-to-last since inferred from long rate and ffr; last element is FEV share of spread
            poslong = 2*nvars;     %long rate is last variable in news-VAR or current-tfp-VAR if spread is inferred from long rate and ffr
        else
            posspread = 2*nvars;        %spread is last variable in Sims-VAR or current TFP VAR
            poslong = 2*nvars-1;        %long rate is second to last variable in Sims-VAR or current TFP VAR
        end
    elseif slope == 1
        if use_yields == 2
            poslong = 2*nvars+4;    %long rate is second-to-last since inferred from spread and ffr; last element is FEV share of long rate
            posspread = 2*nvars;     %spread is last variable in news-VAR or current-tfp-VAR if long rate is inferred from spread and ffr
        else
            poslong = 2*nvars;        %long rate is last variable in Sims-VAR or current TFP VAR
            posspread = 2*nvars-1;    %spread is second to last variable in Sims-VAR or current TFP VAR
        end

    end
end



%figure for 1st shock
h=figure('Color',[0.9412 0.9412 0.9412],'Position',[1 1 800-100 600-100],'Name','Long rates, EH and term premium');
figure(h); 

subplot(211);   plot(1:nimp,data(:,posspread,1),'b.-','LineWidth',1.5); hold on;
                plot(data(:,2*nvars+2,1),'r--','LineWidth',1.5); 
                plot(data(:,2*nvars+3,1),'g','LineWidth',1.5);
                plot(1:nimp,zeros(nimp),'k:');
                legend('Spread','Term premium','Spread implied by EH');
                ylabel('percent','FontSize',12)
                xlabel('quarters','FontSize',12)
%                 axis([0 nimp -0.4 0.6])
                hold off; 
                
subplot(212);   plot(1:nimp,data(:,poslong,1),'b.-','LineWidth',1.5); hold on;
                plot(data(:,2*nvars+2,1),'r--','LineWidth',1.5);
                plot(data(:,2*nvars+1,1),'g','LineWidth',1.5);
                plot(1:nimp,zeros(nimp),'k:');
                legend('Long rate','Term premium','Long rate implied by EH');
                ylabel('percent','FontSize',12)
                xlabel('quarters','FontSize',12)
                hold off;
     
