%plotFEV.m

function plotFEV(data,vars,slope,use_yields,shock_extract)

[nimp,temp,temp]=size(data);
[nvars,temp]=size(vars);

% Reordering of variables; XX only works for plots of most important shock; i.e. ndecomp = 1
if shock_extract == 1;
    if (use_yields == 1 | use_yields ==3) && slope == 1
        data(:,1:nvars,:) = data(:,[1 3:nvars 2],:); %reorder long-bond yield / level (which is in 2nd position here) last to keep same order across specifications
        vars = [vars([1 3:end],:); vars(2,:)];
        N = nvars;
    elseif (use_yields == 2 && slope == 0 );
        data(:,nvars+1,:) = data(:,end,:);  %temporarily put spread VDdec1 as additional variable after all VDdec1s
        vars = [vars; 'Spread  (5-year - Fedfunds)'];
        pos(nvars+1) = nvars+1;
        N = nvars+1;
    elseif (use_yields == 2 && slope == 1);
        data(:,nvars+1,:) = data(:,end,:);  %temporarily put long rate VDdec1 as additional variable after all VDdec1s 
        vars = [vars; '     5-year bond yield     '];
        pos(nvars+1) = nvars+1;
        N = nvars+1;
    else
        N = nvars;
    end
elseif shock_extract == 2 | shock_extract == 3;
    if use_yields == 1 | use_yields == 3;
        data(:,1:nvars-1,:) = data(:,[nvars-1 1:nvars-2],:); %reorder so that spread, resp long-bond yield is in first panel
        vars = [vars(end-1,:); vars(1:end-2,:); vars(end,:)];
        N = nvars;
    elseif (use_yields == 2 && slope == 0 );
        data(:,1:nvars,:) = data(:,[nvars 1:nvars-1],:); %reorder so that long-bond yield is in first panel
        vars = [vars(end,:); vars(1:end-1,:)];
        data(:,nvars+1,:) = data(:,end,:);  %temporarily put spread VDdec1 as additional variable after all VDdec1s
        vars = [vars; 'Spread  (5-year - Fedfunds)'];
        pos(nvars+1) = nvars+1;
        N = nvars+1;
    elseif (use_yields == 2 && slope == 1);
        data(:,1:nvars,:) = data(:,[nvars 1:nvars-1],:); %reorder so that spread is in first panel
        vars = [vars(end,:); vars(1:end-1,:)];
        data(:,nvars+1,:) = data(:,end,:);  %temporarily put long rate VDdec1 as additional variable after all VDdec1s 
        vars = [vars; '     5-year bond yield     '];
        N = nvars+1;
    else
        N = nvars;
    end
else
    N = nvars;
end

R=round(N/2);

    h=figure('Color',[0.9412 0.9412 0.9412],'Position',[1 1 800-100 600-100],'Name','Variance decomposition for 1st shock');
    figure(h); 
    for n=1:N;
        subplot(R,2,n);             if ndims(data)==3;   %if available, plot confidence bands
                                        grpyat = [(1:nimp)' data(1:nimp,n,2); (nimp:-1:1)' data(nimp:-1:1,n,3)];
                                        patch(grpyat(:,1),grpyat(:,2),[0.7 0.7 0.7],'edgecolor',[0.65 0.65 0.65]);
                                    end
                                    hold on;
                                    plot(1:nimp,data(:,n,1),'k-'); 
                                    plot(1:nimp,.5*ones(nimp),':k')
                                    title(num2str(vars(n,:)),'FontSize',14)
                                    ylabel('fraction of FEV explained','FontSize',12)
                                    xlabel('quarters','FontSize',12)
                                    axis([0 nimp 0 1]);
                                    hold off;
    end
    