%plotIRF.m

function plotIRF(data,vars,slope,use_yields,shock_extract)

[nvars,temp]=size(vars);

% Reordering of variables; XX only works for plots of most important shock; i.e. nshock = 1
if shock_extract == 1;
    if (use_yields == 1 | use_yields == 3) && slope == 1;
        data(:,nvars+1:2*nvars,:) = data(:,[nvars+1 nvars+3:2*nvars nvars+2],:); %reorder long-bond yield last to keep same order across specifications
        vars = [vars([1 3:end],:); vars(2,:)];
        N = nvars;
    elseif (use_yields == 2 && slope == 0 );
        data(:,2*nvars+1,:) = data(:,end-1,:);  %temporarily put spread IRF as additional variable before all IRFs in VAR; spread is ordered second to last
        vars = [vars; 'Spread  (5-year - Fedfunds)'];
        N = nvars+1;
    elseif (use_yields == 2 && slope == 1);
        data(:,2*nvars+1,:) = data(:,end-1,:);  %temporarily put long rate IRF as additional variable after all IRFs in VAR; long yield is ordered second to last
        vars = [vars; '     5-year bond yield     '];
        N = nvars+1;
    else
        N = nvars;
    end
    
elseif shock_extract == 2 | shock_extract == 3;
    if  (use_yields == 1 | use_yields == 3);
        data(:,nvars+1:2*nvars-1,:) = data(:,[2*nvars-1 nvars+1:2*nvars-2],:); %reorder so that spread, respectively long-bond yield is in first panel
        vars = [vars(end-1,:); vars(1:end-2,:); vars(end,:)];
        N = nvars;
    elseif (use_yields == 2 && slope == 0 );
        data(:,nvars+1:2*nvars,:) = data(:,[2*nvars nvars+1:2*nvars-1],:); %reorder so that long-bond yield is in first panel
        vars = [vars(end,:); vars(1:end-1,:)];
        data(:,2*nvars+1,:) = data(:,end-1,:);  %temporarily put spread IRF as additional variable after all IRFs
        vars = [vars; 'Spread  (5-year - Fedfunds)'];
        pos(nvars+1) = nvars+1;
        N = nvars+1;
    elseif (use_yields == 2 && slope == 1);
        data(:,nvars+1:2*nvars,:) = data(:,[2*nvars nvars+1:2*nvars-1],:); %reorder so that spread is in first panel
        vars = [vars(end,:); vars(1:end-1,:)];
        data(:,2*nvars+1,:) = data(:,end-1,:);  %temporarily put long rate IRF as additional variable after all IRF 
        vars = [vars; '     5-year bond yield     '];
        pos(nvars+1) = nvars+1;
        N = nvars+1;
    else
        N = nvars;
    end
else
    N = nvars;
end

[nimp,temp,temp]=size(data);
R=round(N/2);

% bounds for small VAR
% ylow =  [-.5 -.5 -0.1 -1  -1   -1];
% yhigh = [1   1   1.4 0.5 0.5 0.5];

% bounds for large VAR
% ylow =  [-.5 -0.5 -0.1 -.5 -2   -2  -1  -1    -1];
% yhigh = [1     1   1.4  1   2.5 2.5  0.5  0.5  0.5];

    %figure for 1st shock
    h=figure('Color',[0.9412 0.9412 0.9412],'Position',[1 1 800-100 600-100],'Name','IRFs to 1st shock');
    figure(h);  
    for n=1:N;
        subplot(R,2,n);             if ndims(data)==3;   %if available, plot confidence bands
                                        grpyat = [(1:nimp)' data(1:nimp,nvars+n,2); (nimp:-1:1)' data(nimp:-1:1,nvars+n,3)];
                                        patch(grpyat(:,1),grpyat(:,2),[0.7 0.7 0.7],'edgecolor',[0.65 0.65 0.65]); 
                                    end
                                    hold on;
                                    plot(1:nimp,data(:,nvars+n,1),'k-');%,'LineWidth',2);
                                    plot(1:nimp,zeros(nimp),':k');
                                    title(num2str(vars(n,:)),'FontSize',14) %'FontWeight','bold',
                                    ylabel('percent','FontSize',12)
                                    xlabel('quarters','FontSize',12)
                                    axis tight
%                                     axis([0 nimp ylow(n) yhigh(n) ]);                                    
                                    hold off;
    end
