%shockcomparison.m

%This program compares extracted shocks from different identifications
%
%Andr Kurmann; last modified December 2012

clear all
close all

load('vslope');  %load first shock series (as saved from output of KurmannOtrok_main.m)
shock1=vmed1;
load('vnews');    %load second shock series (as saved from output of KurmannOtrok_main.m)
shock2=vmed1;
           
corrcoef(shock1,shock2)

esty1=1959;     % First Year for estimation     (max sample: 1960:1 - 2005:2)
estq1=2;        % First quarter for estimation  (***for certain series only***)
esty2=2005;     % Last Year for estimation 
estq2=2;        % Last quarter for estimation

T=max(size(shock1));
date=1:T;
quarter=1/4;
date=quarter*date+esty1+(estq1+3)*quarter;  %adjust with +3 so that with 4 lags less, first obs is 1960:2

plot(date,shock2,'-k','LineWidth',2); hold on;
plot(date,shock1,'r-.','LineWidth',2); 
plot(date,zeros(T),':k')
legend('news shock','slope shock')
ylabel('percent','FontSize',12)
xlabel('date','FontSize',12)
axis tight
hold off;


