function [y] = trilvec(x)

% x is a symmetric matrix of the form:
%      x = [ 1,...
%            2, 3,...
%            4, 5, 6,...
%            7, 8, 9, 10 ]';
% Then y = trilvec(x) is the vector consisting only of the diagonal and
% lower triangular elements of x:
% y =   1 
%       2 
%       3 
%       4 
%       5 
%       6 
%       7 
%       8 
%       9 
%      10 

n = size(x,1);
n2 = size(x,2);

if n~=n2
    error('Input matrix not symmetric')
end

y = []; for i = 1:n; y = [y  ; x(i,1:i)']; end
