function [beta,V_beta,sigma] = tsprior_ols(y_t,x_t,x,M,K,p,tau)

% OLS estimates of VAR from training sample of size tau

ZSZ = 0;
ZSY = 0;
for i = 1:tau
    zhat1 = x_t((i-1)*M+1:i*M,:);
    yhat1 = y_t(i,:);        
    ZSZ = ZSZ + zhat1'*zhat1;
    ZSY = ZSY + zhat1'*yhat1';    
end

beta = ZSZ\ZSY;
% x = x(1:tau,:);
% y_t = y_t(1:tau,:);
% beta = inv(x'*x)*(x'*y_t);
% beta = beta(:);

% bbtemp = beta(M+1:K);  % get the draw of B(t) at time i=1,...,T  (exclude intercept)
% splace = 0;
% big = 0;
% for ii = 1:p                                          
%     for iii = 1:M   
%         big(iii,(ii-1)*M+1:ii*M) = bbtemp(splace+1:splace+M,1)';
%         splace = splace + M;       
%     end
% end
% biga = [beta(1:M,:)' ; big'];
% sigma = (y_t(1:tau,:)-x(1:tau,:)*biga)'*(y_t(1:tau,:)-x(1:tau,:)*biga)./(tau-p+1);

sse2 = 0;
for i = 1:tau
    sse2 = sse2 + (y_t(i,:)'-x_t((i-1)*M+1:i*M,:)*beta)*(y_t(i,:)'-x_t((i-1)*M+1:i*M,:)*beta)';        
end

sigma = sse2/(tau-p+1);

ZSZ = 0;
ZSY = 0;
for i = 1:tau
    zhat1 = x_t((i-1)*M+1:i*M,:);    
    ZSZ = ZSZ + (zhat1'/sigma)*zhat1;  
end

V_beta = inv(ZSZ);
 



