
function [beta_0_prmean,beta_0_prvar,n_0,S_0,SIGMA_0,y_t,x_t,yearlab,t] = tvpvarprior(y_t,Y,x_t,x,ylag,M,K,p,t,tau,yearlab,alpha_bar,gamma,prior)


if prior == 1
    [beta_pr1,beta_pr2,Sigma_0] = tsprior_ols(y_t,x_t,x,M,K,p,tau); 
    y_t = y_t(tau+1:end,:);
    x_t = x_t(tau*M+1:end,:);
    t = t-tau;
    yearlab = yearlab(p+tau+1:end);
elseif prior == 2   
    y_t = y_t(tau+1:end,:);
    ylag = ylag(tau+1:end,:);
    x_t = x_t(tau*M+1:end,:);
    t = t-tau;
    yearlab = yearlab(p+tau+1:end);
    [beta_pr1,beta_pr2,Sigma_0] = Minn_prior_LITT(y_t,ylag,alpha_bar,gamma,M,p,K,t);
elseif prior == 3       
    [beta_pr1,beta_pr2] = Minn_prior_KOOP(alpha_bar,gamma,M,p,K);
    Sigma_0 = cov(Y(1:40,:));
    y_t = y_t(tau+1:end,:);    
    x_t = x_t(tau*M+1:end,:);
    yearlab = yearlab(p+tau+1:end);
    t = t-tau;
elseif prior == 4          
    A_prior = [zeros(1,M); 0*eye(M); zeros((p-1)*M,M)]';
    beta_pr1 = sparse(A_prior(:));
    beta_pr2 = tight*eye(K);
    Sigma_0 = cov(y_t)*1e-3;%*eye(M);
    y_t = y_t(tau+1:end,:);    
    x_t = x_t(tau*M+1:end,:);
    yearlab = yearlab(p+tau+1:end);
    t = t-tau;
end

% beta_t ~ N(beta_0_prmean, beta_0_prvar)
beta_0_prmean = beta_pr1;
beta_0_prvar = beta_pr2;

% SIGMA_t ~ IW(n_0, S_0)
n_0 = (M+2);
S_0 = 1e-4*eye(M);
SIGMA_0 = Sigma_0;%symmetric(S_0)./(n_0-M-1);