



% Main figure 1
M = 7; % number subplots
j = [1,2,6,3,4,5,7]; % index in irf data that will be plotted
nhor = 40;
figure1 = figure('Color',[1 1 1]);
set(gcf,'units','normalized','outerposition',[0 0 1 1]);
load May19_85Q1_15Q1_fig1_MaxSnews_irf
newshock = irf.newshock_median;
newshocklowalt = irf.newshock_low;
newshockhighalt = irf.newshock_high;
names = irf.names;
names{6,1} = 'Inventories';
names{7,1} = 'S&P 500';
for i=1:(M)
    subplot(2,4,i)  
    shadedplot(1:nhor,newshocklowalt(j(i),:),newshockhighalt(j(i),:),[0.4,0.4,0.4],[0.4,0.4,0.4]);
    hold all
    plot(squeeze(newshock(j(i),:))','k','Linewidth',2);
%     plot(squeeze(newshocklowalt(j(i),:))','--k','Linewidth',1.5);
%     plot(squeeze(newshockhighalt(j(i),:))','--k','Linewidth',1.5);
    xlim([1 nhor])
    grid on
    xlabel(['quarters'])
    title([cell2mat(names(j(i)))], 'FontSize', 16)
end
set(gcf, 'Renderer', 'opengl')
set(figure1,'Units','Inches');
pos = get(figure1,'Position');
set(figure1,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
saveas(gcf, ['Fig_1_85Q1_15Q1_May19.fig'] )
% print(figure1,'Fig_1_85Q1_15Q1_May19','-dpdf','-r0')
print(figure1,'Fig_1_85Q1_15Q1_May19','-depsc','-r0')
% print(figure1,'Fig_1_85Q1_15Q1_May19','-djpeg','-r0')







% Figures with Inventories in different sectors (for appendix)
clear

M = 3; % number subplots
j = 6; % index in irf data that will be plotted
nhor = 40;
figure1 = figure('Color',[1 1 1]);
set(gcf,'units','normalized','outerposition',[0 0 1 1]);
for i=1:(M)
    if i == 1
        load May19_92Q1_15Q1_businvt_retail_MaxSnews_irf
    elseif i == 2
        load May19_92Q1_15Q1_businvt_wholes_MaxSnews_irf
    elseif i==3
        load May19_92Q1_15Q1_businvt_manuf_MaxSnews_irf
    end
    newshock = irf.newshock_median;
    newshocklowalt = irf.newshock_low;
    newshockhighalt = irf.newshock_high;
    names = irf.names;

    subplot(round((M)/2),3,i)  
    shadedplot(1:nhor,newshocklowalt(j,:),newshockhighalt(j,:),[0.4,0.4,0.4],[0.4,0.4,0.4]);
    hold all
    plot(squeeze(newshock(j,:))','k','Linewidth',2);
    xlim([1 nhor])
    grid on
    xlabel(['quarters'])
    title([cell2mat(names(j))], 'FontSize', 16)
end
% save figure
set(gcf, 'Renderer', 'opengl')
set(figure1,'Units','Inches');
pos = get(figure1,'Position');
set(figure1,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
print(figure1,'Fig_businvt_sectors_92Q1_15Q1_May19','-depsc','-r0')
 




% Figures with different Inventory types in manufacturing sector (for appendix)
clear
M = 2; % number subplots
j = 6; % index in irf data that will be plotted
nhor = 40;
figure1 = figure('Color',[1 1 1]);
set(gcf,'units','normalized','outerposition',[0 0 1 1]);
for i=1:(M)
    if i == 1
        load May19_92Q1_15Q1_businvt_manuf_fg_MaxSnews_irf
    elseif i == 2
        load May19_92Q1_15Q1_businvt_manuf_rm_MaxSnews_irf
    end
    newshock = irf.newshock_median;
    newshocklowalt = irf.newshock_low;
    newshockhighalt = irf.newshock_high;
    names = irf.names;

    subplot(round((M)/2),2,i)  
    shadedplot(1:nhor,newshocklowalt(j,:),newshockhighalt(j,:),[0.4,0.4,0.4],[0.4,0.4,0.4]);
    hold all
    plot(squeeze(newshock(j,:))','k','Linewidth',2);
    xlim([1 nhor])
    grid on
    xlabel(['quarters'])
    title([cell2mat(names(j))], 'FontSize', 16)
end
% save figure
set(gcf, 'Renderer', 'opengl')
set(figure1,'Units','Inches');
pos = get(figure1,'Position');
set(figure1,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
print(figure1,'Fig_businvt_types_92Q1_15Q1_May19','-depsc','-r0')













 % Figures with ICC measures
clear

M = 4; % number subplots
j = 3; % index in irf data that will be plotted
nhor = 40;
figure1 = figure('Color',[1 1 1]);
set(gcf,'units','normalized','outerposition',[0 0 1 1]);
for i=1:(M)
    if i == 1
        load May19_85Q1_15Q1_iccGordon_MaxSnews_irf
    elseif i == 2
        load May19_85Q1_15Q1_iccOJ_MaxSnews_irf
    elseif i==3
        load May19_85Q1_15Q1_iccMPEG_MaxSnews_irf
    elseif i==4
        load May19_85Q1_15Q1_iccGLS_MaxSnews_irf
    end
    newshock = irf.newshock_median;
    newshocklowalt = irf.newshock_low;
    newshockhighalt = irf.newshock_high;
    names = irf.names;

    subplot(round((M)/2),4,i)  
    shadedplot(1:nhor,newshocklowalt(j,:),newshockhighalt(j,:),[0.4,0.4,0.4],[0.4,0.4,0.4]);
    hold all
    plot(squeeze(newshock(j,:))','k','Linewidth',2);
    xlim([1 nhor])
    grid on
    xlabel(['quarters'])
    title([cell2mat(names(j))], 'FontSize', 16)
end
set(gcf, 'Renderer', 'opengl')
set(figure1,'Units','Inches');
pos = get(figure1,'Position');
set(figure1,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
saveas(gcf, ['Fig_icc_85Q1_15Q1_May19.fig'] )
% print(figure1,'Fig_1_85Q1_15Q1_May19','-dpdf','-r0')
print(figure1,'Fig_icc_85Q1_15Q1_May19','-depsc','-r0')



% Figures with ECC
clear

M=1;
j1 = 1; % index in irf data that will be plotted in one column
j2 = 6; % index in irf data that will be plotted in one column
j3 = 3; % index in irf data that will be plotted in one column
nhor = 40;
figure1 = figure('Color',[1 1 1]);
set(gcf,'units','normalized','outerposition',[0 0 1 1]);
for i=1:(M)
%     if i==1
        load May19_85Q1_15Q1_ecc_MaxSnews_irf
%     elseif i==2
%         load May19_85Q1_15Q1_dcc_MaxSnews_irf
%     end

    newshock = irf.newshock_median;
    newshocklowalt = irf.newshock_low;
    newshockhighalt = irf.newshock_high;
    names = irf.names;
    names{6,1} = 'Inventories';
    if i==1
    subplot(3,3,1)  
    shadedplot(1:nhor,newshocklowalt(j1,:),newshockhighalt(j1,:),[0.4,0.4,0.4],[0.4,0.4,0.4]);
    hold all
    plot(squeeze(newshock(j1,:))','k','Linewidth',2);
    xlim([1 nhor])
    grid on
    xlabel(['quarters'])
    title([cell2mat(names(j1))], 'FontSize', 16)
    
    subplot(3,3,2)  
    shadedplot(1:nhor,newshocklowalt(j2,:),newshockhighalt(j2,:),[0.4,0.4,0.4],[0.4,0.4,0.4]);
    hold all
    plot(squeeze(newshock(j2,:))','k','Linewidth',2);
    xlim([1 nhor])
    grid on
    xlabel(['quarters'])
    title([cell2mat(names(j2))], 'FontSize', 16)
    
    subplot(3,3,3)  
    shadedplot(1:nhor,newshocklowalt(j3,:),newshockhighalt(j3,:),[0.4,0.4,0.4],[0.4,0.4,0.4]);
    hold all
    plot(squeeze(newshock(j3,:))','k','Linewidth',2);
    xlim([1 nhor])
    grid on
    xlabel(['quarters'])
    title([cell2mat(names(j3))], 'FontSize', 16)
    
    elseif i ==2 
        
    subplot(3,3,4)  
    shadedplot(1:nhor,newshocklowalt(j1,:),newshockhighalt(j1,:),[0.4,0.4,0.4],[0.4,0.4,0.4]);
    hold all
    plot(squeeze(newshock(j1,:))','k','Linewidth',2);
    xlim([1 nhor])
    grid on
    xlabel(['quarters'])
    title([cell2mat(names(j1))], 'FontSize', 16)
    
    subplot(3,3,5)  
    shadedplot(1:nhor,newshocklowalt(j2,:),newshockhighalt(j2,:),[0.4,0.4,0.4],[0.4,0.4,0.4]);
    hold all
    plot(squeeze(newshock(j2,:))','k','Linewidth',2);
    xlim([1 nhor])
    grid on
    xlabel(['quarters'])
    title([cell2mat(names(j2))], 'FontSize', 16)
    
    subplot(3,3,6)  
    shadedplot(1:nhor,newshocklowalt(j3,:),newshockhighalt(j3,:),[0.4,0.4,0.4],[0.4,0.4,0.4]);
    hold all
    plot(squeeze(newshock(j3,:))','k','Linewidth',2);
    xlim([1 nhor])
    grid on
    xlabel(['quarters'])
    title([cell2mat(names(j3))], 'FontSize', 16)
    end
end
set(gcf, 'Renderer', 'opengl')
set(figure1,'Units','Inches');
pos = get(figure1,'Position');
set(figure1,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
saveas(gcf, ['Fig_ecc_85Q1_15Q1_May19.fig'] )
% print(figure1,'Fig_1_85Q1_15Q1_May19','-dpdf','-r0')
print(figure1,'Fig_ecc_85Q1_15Q1_May19','-depsc','-r0')




% Figures with DCC
clear

M=1;
j1 = 1; % index in irf data that will be plotted in one column
j2 = 6; % index in irf data that will be plotted in one column
j3 = 3; % index in irf data that will be plotted in one column
nhor = 40;
figure1 = figure('Color',[1 1 1]);
set(gcf,'units','normalized','outerposition',[0 0 1 1]);
for i=1:(M)
%     if i==1
%         load May19_85Q1_15Q1_ecc_MaxSnews_irf
%     elseif i==2
         load May19_85Q1_15Q1_dcc_MaxSnews_irf
         
%     end

    newshock = irf.newshock_median;
    newshocklowalt = irf.newshock_low;
    newshockhighalt = irf.newshock_high;
    names = irf.names;
    names{6,1} = 'Inventories';
    if i==1
    subplot(3,3,1)  
    shadedplot(1:nhor,newshocklowalt(j1,:),newshockhighalt(j1,:),[0.4,0.4,0.4],[0.4,0.4,0.4]);
    hold all
    plot(squeeze(newshock(j1,:))','k','Linewidth',2);
    xlim([1 nhor])
    grid on
    xlabel(['quarters'])
    title([cell2mat(names(j1))], 'FontSize', 16)
    
    subplot(3,3,2)  
    shadedplot(1:nhor,newshocklowalt(j2,:),newshockhighalt(j2,:),[0.4,0.4,0.4],[0.4,0.4,0.4]);
    hold all
    plot(squeeze(newshock(j2,:))','k','Linewidth',2);
    xlim([1 nhor])
    grid on
    xlabel(['quarters'])
    title([cell2mat(names(j2))], 'FontSize', 16)
    
    subplot(3,3,3)  
    shadedplot(1:nhor,newshocklowalt(j3,:),newshockhighalt(j3,:),[0.4,0.4,0.4],[0.4,0.4,0.4]);
    hold all
    plot(squeeze(newshock(j3,:))','k','Linewidth',2);
    xlim([1 nhor])
    grid on
    xlabel(['quarters'])
    title([cell2mat(names(j3))], 'FontSize', 16)
    
    elseif i ==2 
        
    subplot(3,3,4)  
    shadedplot(1:nhor,newshocklowalt(j1,:),newshockhighalt(j1,:),[0.4,0.4,0.4],[0.4,0.4,0.4]);
    hold all
    plot(squeeze(newshock(j1,:))','k','Linewidth',2);
    xlim([1 nhor])
    grid on
    xlabel(['quarters'])
    title([cell2mat(names(j1))], 'FontSize', 16)
    
    subplot(3,3,5)  
    shadedplot(1:nhor,newshocklowalt(j2,:),newshockhighalt(j2,:),[0.4,0.4,0.4],[0.4,0.4,0.4]);
    hold all
    plot(squeeze(newshock(j2,:))','k','Linewidth',2);
    xlim([1 nhor])
    grid on
    xlabel(['quarters'])
    title([cell2mat(names(j2))], 'FontSize', 16)
    
    subplot(3,3,6)  
    shadedplot(1:nhor,newshocklowalt(j3,:),newshockhighalt(j3,:),[0.4,0.4,0.4],[0.4,0.4,0.4]);
    hold all
    plot(squeeze(newshock(j3,:))','k','Linewidth',2);
    xlim([1 nhor])
    grid on
    xlabel(['quarters'])
    title([cell2mat(names(j3))], 'FontSize', 16)
    end
end
set(gcf, 'Renderer', 'opengl')
set(figure1,'Units','Inches');
pos = get(figure1,'Position');
set(figure1,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
saveas(gcf, ['Fig_dcc_85Q1_15Q1_May19.fig'] )
% print(figure1,'Fig_1_85Q1_15Q1_May19','-dpdf','-r0')
print(figure1,'Fig_dcc_85Q1_15Q1_May19','-depsc','-r0')





 % Figures with different MC measures for main body
clear

M = 4; % number subplots
j = 3; % index in irf data that will be plotted
nhor = 40;
figure1 = figure('Color',[1 1 1]);
set(gcf,'units','normalized','outerposition',[0 0 1 1]);
for i=1:(M)
    if i == 1
        load May19_85Q1_15Q1_mcCD_NR1_MaxSnews_irf
    elseif i == 2
        load May19_85Q1_15Q1_mcCD_NR2_MaxSnews_irf
    elseif i==3
        load May19_85Q1_15Q1_mcCES_NR1_MaxSnews_irf
     elseif i==4
        load May19_85Q1_15Q1_mcCES_NR2_MaxSnews_irf
    end
    newshock = irf.newshock_median;
    newshocklowalt = irf.newshock_low;
    newshockhighalt = irf.newshock_high;
    names = irf.names;

    subplot(round((M)/2),4,i)  
    shadedplot(1:nhor,newshocklowalt(j,:),newshockhighalt(j,:),[0.4,0.4,0.4],[0.4,0.4,0.4]);
    hold all
    plot(squeeze(newshock(j,:))','k','Linewidth',2);
    xlim([1 nhor])
    grid on
    xlabel(['quarters'])
    title([cell2mat(names(j))], 'FontSize', 16)
end
set(gcf, 'Renderer', 'opengl')
set(figure1,'Units','Inches');
pos = get(figure1,'Position');
set(figure1,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
saveas(gcf, ['Fig_mc_85Q1_15Q1_May19_new.fig'] )
% print(figure1,'Fig_1_85Q1_15Q1_May19','-dpdf','-r0')
print(figure1,'Fig_mc_85Q1_15Q1_May19_new','-depsc','-r0')
 
 
 
 




% Figure with real baa bond yield
M = 7; % number subplots
j = [1,2,3,4,5,6,7]; % index in irf data that will be plotted
nhor = 40;
figure1 = figure('Color',[1 1 1]);
set(gcf,'units','normalized','outerposition',[0 0 1 1]);
load May19_85Q1_15Q1_baa_MaxSnews_irf
newshock = irf.newshock_median;
newshocklowalt = irf.newshock_low;
newshockhighalt = irf.newshock_high;
names = irf.names;
names{6,1} = 'Inventories';
names{7,1} = 'S&P 500';
for i=1:(M)
    subplot(2,4,i)  
    shadedplot(1:nhor,newshocklowalt(j(i),:),newshockhighalt(j(i),:),[0.4,0.4,0.4],[0.4,0.4,0.4]);
    hold all
    plot(squeeze(newshock(j(i),:))','k','Linewidth',2);
%     plot(squeeze(newshocklowalt(j(i),:))','--k','Linewidth',1.5);
%     plot(squeeze(newshockhighalt(j(i),:))','--k','Linewidth',1.5);
    xlim([1 nhor])
    grid on
    xlabel(['quarters'])
    title([cell2mat(names(j(i)))], 'FontSize', 16)
end
set(gcf, 'Renderer', 'opengl')
set(figure1,'Units','Inches');
pos = get(figure1,'Position');
set(figure1,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
saveas(gcf, ['Fig_baa_85Q1_15Q1_May19.fig'] )
% print(figure1,'Fig_baa_85Q1_15Q1_May19','-dpdf','-r0')
print(figure1,'Fig_baa_85Q1_15Q1_May19','-depsc','-r0')
% print(figure1,'Fig_baa_85Q1_15Q1_May19','-djpeg','-r0')










