/*********************************************PAULO MAIO*****************************************
******************************************AR(1) PROCESS******************************************

INPUTS:
Y: (Tx1) vector of observations

OUTPUTS:
B: (2x1) vector of parameter estimates
AR2: adjusted R^2
SE_B: (2x1) vector of (OLS) standard errors of the parameter estimates
TSTAT_B: (2x1) vector of (OLS) t-ratios of the parameter estimates
EHAT: ((T-1)x1) vector of residuals
*************************************************************************************************/



PROC (5)=AR1PM(Y);
     LOCAL AUX1,YY,T,X,K,B,EHAT,R2,AR2,S2,AVCOV_B,AVAR_B,SE_B,TSTAT_B;

AUX1=LAGN(Y,1);
AUX1=TRIMR(AUX1,1,0);
YY=TRIMR(Y,1,0);
T=ROWS(YY);

X=ONES(T,1)~AUX1;
K=COLS(X);
B=INVPD(X'X)*X'YY;
EHAT=YY-X*B;
R2=1-(EHAT'EHAT)/((YY-MEANC(YY))'(YY-MEANC(YY)));
AR2=1-(1-R2)*((T-1)/(T-K));
S2=(EHAT'EHAT)/(T-K);
AVCOV_B=S2*INVPD(X'X);
AVAR_B=DIAG(AVCOV_B);
SE_B=SQRT(AVAR_B);
TSTAT_B=B./SE_B;

RETP (B,AR2,SE_B,TSTAT_B,EHAT);
   ENDP; 
