/*********************************************PAULO MAIO*****************************************
**********************************************LONG-HORIZON REGRESSIONS***************************

INPUTS:
Y: ((T+Q)x1) vector of observations for the endogenous variable
X: ((T+Q)x(K-1)) matrix of observations for the K-1 predictors
Q: (Mx1) vector of forecasting horizons; q=(1,...,H)'; if M=1, there is only one regression

OUTPUTS:
BH: OLS estimates of the predictive slopes (Mx(K-1))
T_W: White t-statistics (Mx(K-1))
PV_W: White p-values (Mx(K-1))
T_NW: Newey-West t-statistics with h-1 lags (Mx(K-1))
PV_NW: Newey-West p-values (Mx(K-1))
T_HH: Hansen-Hodrick t-statistics (Mx(K-1))
PV_HH: Hansen-Hodrick p-values (Mx(K-1))
T_H: Hodrick t-statistics (Mx(K-1))
PV_H: Hodrick p-values (Mx(K-1))
T_R: Reverse regression t-statistics (Mx(K-1))
PV_R: Reverse regression p-values (Mx(K-1))
T_HJ: Hjalmarsson t-statistics (Mx(K-1))
PV_HJ: Hjalmarsson p-values (Mx(K-1))
R2H: R^2 estimates (Mx1)
AR2H: Adjusted R^2 estimates (Mx1)
EHAT1: residuals by imposing the null of zero slopes at h=1 (Tx1)

*************************************************************************************************/

proc (16)=LHRNEW(Y,Q,X);

     LOCAL aux1,aux2,Y1,X1,EHAT1,bh,t_w,pv_w,t_nw,pv_nw,t_hh,pv_hh,t_h,pv_h,t_r,pv_r,t_hj,pv_hj,r2h,ar2h,m,h,XH,T,K,yh,aux3,D,B,EHAT,G,R2,AR2,S_W,AVCOVB_W,SEB_W,TSTATB_W,
PVALUES_W,SUM,J,G_J,G_L,GAMMA_J,S_NW,AVCOVB_NW,SEB_NW,TSTATB_NW,PVALUES_NW,S_HH,AVCOVB_HH,SEB_HH,TSTATB_HH,PVALUES_HH,SX,ESX,S_H,AVCOVB_H,SEB_H,TSTATB_H,PVALUES_H,
YR,DR,BR,EHATR,GR,S_WR,AVCOVB_WR,SEB_WR,TSTATB_WR,PVALUES_WR,S2,AVCOVB_HJ,SEB_HJ,TSTATB_HJ,PVALUES_HJ;

aux1=rows(q);
aux2=rows(x);

Y1=Y[2:aux2,1];
EHAT1=Y1-meanc(Y1);
X1=ones(aux2,1)~X;

bh=zeros(aux1,cols(x));
t_w=zeros(aux1,cols(x));
pv_w=zeros(aux1,cols(x));
t_nw=zeros(aux1,cols(x));
pv_nw=zeros(aux1,cols(x));
t_hh=zeros(aux1,cols(x));
pv_hh=zeros(aux1,cols(x));
t_h=zeros(aux1,cols(x));
pv_h=zeros(aux1,cols(x));
t_r=zeros(aux1,cols(x));
pv_r=zeros(aux1,cols(x));
t_hj=zeros(aux1,cols(x));
pv_hj=zeros(aux1,cols(x));
r2h=zeros(aux1,1);
ar2h=zeros(aux1,1);

M=1;
DO WHILE M<=aux1;

h=q[m,1]; 
XH=X[1:aux2-h,.];
T=rows(XH); 
XH=ONES(T,1)~XH;
K=COLS(XH); 

   yh = zeros(aux2,1); /* overlapping lhs variable */
      j = 1;
      do while j<=h;
         aux3 = shiftr(y',-j,0)';
         yh = yh+aux3;
      j = j+1;
      endo;
   yh = trimr(yh,0,h);

D=(1/T).*XH'XH;
B=INVPD(D)*((1/T).*XH'YH); /* OLS estimator */
EHAT=YH-XH*B; /* residuals */
G=XH.*EHAT; /* Auxiliary matrix used in the computation of S */

R2=1-((EHAT-MEANC(EHAT))'(EHAT-MEANC(EHAT)))/((YH-MEANC(YH))'(YH-MEANC(YH))); /* R^2 */
AR2=1-(1-R2)*((T-1)/(T-K+1)); /* Adjusted R^2 */


/******************************************************************************************
 White (heteroskedasticity-robust) standard errors 
******************************************************************************************/

S_W=(1/T).*G'G;
AVCOVB_W=(1/T).*(INVPD(D)*S_W*INVPD(D));  
SEB_W=SQRT(DIAG(AVCOVB_W));
TSTATB_W=B./SEB_W;
PVALUES_W=2*CDFNC(ABS(TSTATB_W));

/******************************************************************************************
 Newey-West standard errors 
******************************************************************************************/

SUM=ZEROS(K,K); 
   J=1;
   DO WHILE J<=H-1;
      G_J=LAGN(G,J);
      G_L=TRIMR(G,J,0);              
      G_J=TRIMR(G_J,J,0);   
      GAMMA_J=(1/T).*G_L'G_J+(1/T).*G_J'G_L;
      SUM=SUM+(1-J/H).*GAMMA_J;                   
   J=J+1;
   ENDO;

S_NW=S_W+SUM;
AVCOVB_NW=(1/T).*(INVPD(D)*S_NW*INVPD(D));
SEB_NW=SQRT(DIAG(AVCOVB_NW));
TSTATB_NW=B./SEB_NW;
PVALUES_NW=2*CDFNC(ABS(TSTATB_NW));

/******************************************************************************************
 Hansen-Hodrick standard errors 
******************************************************************************************/

SUM=ZEROS(K,K); 
   IF H-1>0;
      J=1;
      DO WHILE J<=H-1;
         G_J=LAGN(G,J);
         G_L=TRIMR(G,J,0);              
         G_J=TRIMR(G_J,J,0);   
         GAMMA_J=(1/T).*G_L'G_J+(1/T).*G_J'G_L;
         SUM=SUM+GAMMA_J; 
      J=J+1;
      ENDO;
   ELSE;
      SUM=ZEROS(K,K); 
   ENDIF;

   IF EIG(S_W+SUM)>=0; 
      S_HH=S_W+SUM;
   ELSE;      /* if S is not positive definite, use Newey-west estimate */
      SUM=ZEROS(K,K); 
      J=1;
      DO WHILE J<=H-1;
         G_J=LAGN(G,J);
         G_L=TRIMR(G,J,0);              
         G_J=TRIMR(G_J,J,0);   
         GAMMA_J=(1/T).*G_L'G_J+(1/T).*G_J'G_L;
         SUM=SUM+(1-J/H).*GAMMA_J;                   
      J=J+1;
      ENDO;

      S_HH=S_W+SUM;
   ENDIF;

AVCOVB_HH=(1/T).*(INVPD(D)*S_HH*INVPD(D));
SEB_HH=SQRT(DIAG(AVCOVB_HH));
TSTATB_HH=B./SEB_HH;
PVALUES_HH=2*CDFNC(ABS(TSTATB_HH));

/******************************************************************************************
 Hodrick standard errors 
******************************************************************************************/

SX=MA_SUM(X1,h-1);
SX=TRIMR(SX,0,1);

ESX=TRIMR(EHAT1,h-1,0).*SX;
S_H=(1/T).*ESX'ESX;
AVCOVB_H=(1/T).*(INVPD(D)*S_H*INVPD(D));
SEB_H=SQRT(DIAG(AVCOVB_H));
TSTATB_H=B./SEB_H;
PVALUES_H=2*CDFNC(ABS(TSTATB_H));

/******************************************************************************************
 Reverse regression standard errors
******************************************************************************************/

YR=TRIMR(Y1,h-1,0);
DR=(1/T).*SX'SX;
BR=INVPD(DR)*((1/T).*SX'YR); /* OLS estimator */
EHATR=YR-SX*BR; /* residuals */
GR=SX.*EHATR; /* Auxiliary matrix used in the computation of S */

S_WR=(1/T).*GR'GR;
AVCOVB_WR=(1/T).*(INVPD(DR)*S_WR*INVPD(DR));  
SEB_WR=SQRT(DIAG(AVCOVB_WR));
TSTATB_WR=BR./SEB_WR;
PVALUES_WR=2*CDFNC(ABS(TSTATB_WR));

/******************************************************************************************
 Hjalmarsson standard errors 
******************************************************************************************/

S2=(EHAT'EHAT)/T;
AVCOVB_HJ=S2*INVPD(XH'XH);
SEB_HJ=SQRT(DIAG(AVCOVB_HJ));
TSTATB_HJ=(B./SEB_HJ)/(SQRT(H));
PVALUES_HJ=2*CDFNC(ABS(TSTATB_HJ));

/****************************Outputs*********************************************/

bh[m,.]=b[2:K,1]';
t_w[m,.]=TSTATB_W[2:K,1]';
pv_w[m,.]=PVALUES_W[2:K,1]';
t_nw[m,.]=TSTATB_NW[2:K,1]';
pv_nw[m,.]=PVALUES_NW[2:K,1]';
t_hh[m,.]=TSTATB_HH[2:K,1]';
pv_hh[m,.]=PVALUES_HH[2:K,1]';
t_h[m,.]=TSTATB_H[2:K,1]';
pv_h[m,.]=PVALUES_H[2:K,1]';
t_r[m,.]=TSTATB_WR[2:K,1]';
pv_r[m,.]=PVALUES_WR[2:K,1]';
t_hj[m,.]=TSTATB_HJ[2:K,1]';
pv_hj[m,.]=PVALUES_HJ[2:K,1]';
r2h[m,.]=r2;
ar2h[m,.]=ar2;

M=M+1;
ENDO;


RETP (bh,t_w,pv_w,t_nw,pv_nw,t_hh,pv_hh,t_h,pv_h,t_r,pv_r,t_hj,pv_hj,r2h,ar2h,ehat1);

   ENDP; 
