
/*********************************************PAULO MAIO*****************************************
************************************Out-of-sample predictability analysis************************

The restricted model is a regression nested in the unrestricted model

INPUTS:
Y: (Tx1) vector of observations for the predicted variable
XX: (Txk) matrix of observations for the predictors
TIN: in-sample period
Q: forecasting horizon
K1: first K1 predictors associated with the restricted model

OUTPUTS:
R2OOS: OOS R^2
MSEF: McCracken (2007) F-statistic
ENC: Clark and McCracken (2001) encompassing test statistic
TSTATB_NWA: Clark and West (2007) t-statistic
*************************************************************************************************/


PROC (4)=OOS_LHR1(Y,XX,TIN,Q,K1);

   LOCAL T,EHATU,EHATR,EHATUR,I,SUM,J,AUX_Y,Y_I,Y_AUX,XX_AUX,BU,YHATU_I,BR,YHATR_I,MSEU,MSER,R2OOS,MSEF,ENC,FHAT,
TA,BA,EHATA,SEB_WA,SEB_NWA,TSTATB_WA,TSTATB_NWA,PVALUES_WA,PVALUES_NWA,R2A,AR2A;

T=ROWS(Y);
EHATU=ZEROS(T-Q+1-TIN,1);
EHATR=ZEROS(T-Q+1-TIN,1);
EHATUR=ZEROS(T-Q+1-TIN,1);

I=TIN+1;
DO WHILE I<=T-Q+1;

   SUM=0;  
   J=0;
   DO WHILE J<=Q-1;
      AUX_Y=Y[I+J,1];
      SUM=SUM+AUX_Y;                 
   J=J+1;
   ENDO;

   Y_I=SUM;

   Y_AUX=Y[1:I-1,1];
   XX_AUX=XX[1:I-1,.];

   BU=OOS_PREDU(Y_AUX,XX_AUX,Q); /* parameter estimates from unrestricted model */
   YHATU_I=(1~XX[I-1,.])*BU;
   EHATU[I-TIN,1]=Y_I-YHATU_I;/* forecasting errors from unrestricted model */

   BR=OOS_PREDU(Y_AUX,XX_AUX[.,1:k1],Q); /* parameter estimates from restricted model */
   YHATR_I=(1~XX[I-1,1:k1])*BR;
   EHATR[I-TIN,1]=Y_I-YHATR_I;/* forecasting errors from restricted model */
   EHATUR[I-TIN,1]=YHATR_I-YHATU_I; /* difference in forecats from both models */

I=I+1;
ENDO;

MSEU=EHATU'EHATU;
MSER=EHATR'EHATR;

R2OOS=1-(MSEU/MSER);
MSEF=(T-Q+1-TIN)*((MSER-MSEU)/MSEU);
ENC=(T-Q+1-TIN)*((MSER-EHATR'EHATU)/MSEU);

FHAT=EHATR.^2-EHATU.^2+EHATUR.^2; /* auxiliary variable for the CW test */

{TA,BA,EHATA,SEB_WA,SEB_NWA,TSTATB_WA,TSTATB_NWA,PVALUES_WA,PVALUES_NWA,R2A,AR2A}=OLSGMMPM(FHAT,ONES(T-Q+1-TIN,1),Q,0); /* regressing FHAT on a constant */

   RETP (R2OOS,MSEF,ENC,TSTATB_NWA);
   ENDP;
