
/*********************************************PAULO MAIO*****************************************
************************************Out-of-sample predictability analysis************************

Same as OOS_LHR1.PRC, with the following differences:
1. The slope estimate of the last predictor is constrained to be non-negative
2. The single metric is R^2

INPUTS:
Y: (Tx1) vector of observations for the predicted variable
XX: (Txk) matrix of observations for the predictors
TIN: in-sample period
Q: forecasting horizon
K1: first K1 predictors associated with the restricted model

OUTPUTS:
R2OOS: Constrained OOS R^2
COUNT: Number of OOS regressions in which the slope estimate is negative (i.e., the constraint is binding)

*************************************************************************************************/


PROC (2)=OOS_LHR1A(Y,XX,TIN,Q,K1);

   LOCAL T,EHATU,EHATR,COUNT,I,SUM,J,AUX_Y,Y_I,Y_AUX,XX_AUX,BU,COUNT_I,YHATU_I,BR,YHATR_I,MSEU,MSER,R2OOS;

T=ROWS(Y);
EHATU=ZEROS(T-Q+1-TIN,1);
EHATR=ZEROS(T-Q+1-TIN,1);
COUNT=0;

I=TIN+1;
DO WHILE I<=T-Q+1;

   SUM=0;  
   J=0;
   DO WHILE J<=Q-1;
      AUX_Y=Y[I+J,1];
      SUM=SUM+AUX_Y;                 
   J=J+1;
   ENDO;

   Y_I=SUM;

   Y_AUX=Y[1:I-1,1];
   XX_AUX=XX[1:I-1,.];

   BU=OOS_PREDU(Y_AUX,XX_AUX,Q); /* parameter estimates from unrestricted model */

   COUNT_I=0;

   IF BU[4,1]<0;
      COUNT_I=1;
      BU[4,1]=0; 
   ENDIF;

   YHATU_I=(1~XX[I-1,.])*BU;
   EHATU[I-TIN,1]=Y_I-YHATU_I;/* forecasting errors from unrestricted model */

   BR=OOS_PREDU(Y_AUX,XX_AUX[.,1:k1],Q); /* parameter estimates from restricted model */
   YHATR_I=(1~XX[I-1,1:k1])*BR;
   EHATR[I-TIN,1]=Y_I-YHATR_I;/* forecasting errors from restricted model */
  
COUNT=COUNT+COUNT_I;

I=I+1;
ENDO;

MSEU=EHATU'EHATU;
MSER=EHATR'EHATR;

R2OOS=1-(MSEU/MSER);

   RETP (R2OOS,COUNT);
   ENDP;
