/*********************************************PAULO MAIO*****************************************
***********************Out-of-sample predictability analysis: auxiliary regressions**************
Should be used jointly with OOS_LHR.PRC. Estimation of the unrestricted predictive regression.

INPUTS:
YY: (Tx1) vector of observations for the predicted variable
XX: (Txk) matrix of observations for the predictors
Q: forecasting horizon

OUTPUTS:
B: ((K+1)x1) vector of parameter estimates
*************************************************************************************************/


PROC (1)=OOS_PREDU(YY,XX,Q);

   LOCAL T,SUM,J,RM_J,Y,X,D,B;

T=ROWS(YY); 

SUM=ZEROS(T,1);  

J=0;
DO WHILE J<=Q-1;
   RM_J=SHIFTR(YY',J,0)';
   SUM=SUM+RM_J;                 
J=J+1;
ENDO;

Y=TRIMR(SUM,Q,0);
T=ROWS(Y); 

X=LAGN(XX,Q);
X=TRIMR(X,Q,0);
X=ONES(T,1)~X;
D=(1/(T)).*X'X;
B=INVPD(D)*((1/T).*X'Y);

   RETP (B);
   ENDP;