/*********************************************PAULO MAIO*****************************************
**********************************************Restricted VAR(1) estimation***********************

Estimates a VAR(1) with only one lagged dependent variable

INPUTS:
YY: (TxN) matrix of VAR state variables
XX: variable that serves as regressor (Tx1)
Q_NW: Newey-West lags

OUTPUTS:
T: number of usable observations in the VAR
N: number of variables in the VAR 
R2: (Nx1) vector of R^2
AR2: (Nx1) vector of adjusted R^2
B: (2NX1) stacked vector of coefficient estimates (including the intercept)
BETA: (NX2) matrix of coefficient estimates
T_BETA: (NX2) matrix of Newey-West t-ratios
P_BETA: (NX2) matrix of Newey-West p-values
AVCOVB_NW: (2Nx2N) covariance matrix of coefficient estimates
VCOV_EHAT: (NXN) covariance of VAR residuals


*************************************************************************************************/


PROC(10)=VAR_REST(YY,XX,Q_NW);

LOCAL T,N,X,K,Y,Z,D,B,EHAT,EPSLON,AUX1,AUX2,R2,AR2,G,S_W,S_NW,J,GAMMA_J,AVCOVB_NW,SEB_NW,TSTATB_NW,PVALUES_NW,
BETA,T_BETA,P_BETA,VCOV_EHAT;

YY=LAGN(YY,-1);
YY=TRIMR(YY,0,1);
XX=TRIMR(XX,0,1);
T=ROWS(YY);/* number of observations*/
X=ONES(T,1)~XX; /* Number of forecasting variables (including a constant) */
K=COLS(X);
N=COLS(YY); /* N is the number of variables in the VAR  */

Y=RESHAPE(YY',1,N*T)';
Z=EYE(N).*.X; /* data matrix of the regressors (NTxNK) */
D=(1/T).*(EYE(N).*.(X'X)); /* D matrix; equal to dgT(b)/db (NKxNK) */
B=(EYE(N).*.(INVPD(X'X)*X'))*Y; /* Simplified formula (applied to this case) for GMM estimator (NKx1) */
EHAT=Y-Z*B; /* stacked vector with residuals (NTx1) */
EPSLON=RESHAPE(EHAT,N,T); /* Auxiliar matrix. Transforms the vector of residuals into a matrix,
where each column corresponds to the t th observation, t =1,...,T (NxT) */

VCOV_EHAT=VCXS(EPSLON');

AUX1=(EPSLON'-MEANC(EPSLON')')'(EPSLON'-MEANC(EPSLON')');
AUX2=(YY-MEANC(YY)')'(YY-MEANC(YY)');
R2=1-DIAG(AUX1)./DIAG(AUX2);
AR2=ONES(N,1)-(ONES(N,1)-R2).*((T-1)/(T-K));

G=(EPSLON')*~X;

S_W=(1/T).*G'G;

S_NW=ZEROS(N*K,N*K); 
   J=1;
   DO WHILE J<=Q_NW-1;
      GAMMA_J=(1/T).*G[1:T-J,.]'G[1+J:T,.]+(1/T).*G[1+J:T,.]'G[1:T-J,.];
      S_NW=S_NW+(1-J/Q_NW).*GAMMA_J;                   
   J=J+1;
   ENDO;
S_NW=S_W+S_NW;

AVCOVB_NW=(1/T).*(INVPD(D)*S_NW*INVPD(D));
SEB_NW=SQRT(DIAG(AVCOVB_NW));
TSTATB_NW=B./SEB_NW;
PVALUES_NW=2*CDFNC(ABS(TSTATB_NW));

BETA=RESHAPE(B,N,K);
T_BETA=RESHAPE(TSTATB_NW,N,K);
P_BETA=RESHAPE(PVALUES_NW,N,K);

RETP(T,N,R2,AR2,B,BETA,T_BETA,P_BETA,AVCOVB_NW,VCOV_EHAT);
ENDP;
