/*********************************************PAULO MAIO*****************************************
******************************************annual series***************************************

This procedure transforms monthly data into annual data. The December observation of each year is 
kept as the annual observation

INPUTS:
Y: (TxN) data matrix (monthly frequency). the sample must include complete years (e.g., the sample cannot start in February or end in November) 

OUTPUTS:
na: number of variables
ta: number of quarterly observations (equal to T/12)
ya: (TAxN) data matrix (annual frequency)
*************************************************************************************************/

proc(3)=yearly(y);

local t,n,aux1,aux2,aux3,aux4,ya,ta,na;

/*********************************************/

t=rows(y);
n=cols(y);
aux1=zeros(11,1)|1;
aux2=t/12;
aux3=ones(aux2,1);
aux4=aux3.*.aux1;
ya=selif(y,aux4);
ta=rows(ya);
na=cols(ya);

retp (na,ta,ya);
endp;
 

