/*********************************************PAULO MAIO*****************************************
******************************UNIVARIATE OLS WITH GMM-BASED STANDARD ERRORS**********************

INPUTS:
Y: (Tx1) matrix of endogenous variable
XX: (TxK) matrix of regressors 
Q_NW: Bartlett Kernel bandwidth for Newey-West standard errors
DC: indicator variable (=1 if intercept is included)

OUTPUTS:
T: number of observations
B: (Kx1) or ((K+1)x1) vector of parameter estimates (including the intercept)
EHAT: (Tx1) vector of residuals
SEB_W: White standard errors (Kx1)
SEB_NW: Newey-West standard errors (Kx1)
TSTATB_W: White t-ratios (Kx1)
TSTATB_NW: Newey-West t-ratios (Kx1)
PVALUES_W: White p-values (Kx1)
PVALUES_NW: Newey-West p-values (Kx1)
R2: R^2
AR2: adjusted R^2

*************************************************************************************************/


proc (11)=OLSGMMPM(Y,XX,Q_NW,DC);

     LOCAL T,X,K,D,B,EHAT,G,R2,AR2,S_W,AVCOVB_W,SEB_W,TSTATB_W,PVALUES_W,SUM,J,G_J,G_L,GAMMA_J,S_NW,AVCOVB_NW,SEB_NW,TSTATB_NW,PVALUES_NW;

T=ROWS(XX); /* number of usable observations */

IF DC==1;
   X=ONES(T,1)~XX; /* intercept */
ELSE;
   X=XX; /* no intercept */
ENDIF;

K=COLS(X); /* Number of right hand side variables (including a constant) */

D=(1/T).*X'X;
B=INV(D)*((1/T).*X'Y); /* OLS estimator */
EHAT=Y-X*B; /* residuals */
G=X.*EHAT; /* Auxiliary matrix used in the computation of S */

R2=1-((EHAT-MEANC(EHAT))'(EHAT-MEANC(EHAT)))/((Y-MEANC(Y))'(Y-MEANC(Y))); /* R^2 */
AR2=1-(1-R2)*((T-1)/(T-K)); /* Adjusted R^2 */


/******************************************************************************************
 White (heteroskedasticity-robust) standard errors 
******************************************************************************************/

S_W=(1/T).*G'G;
AVCOVB_W=(1/T).*(INV(D)*S_W*INV(D));  /*AVCOVB_W=(1/T).*(INVPD(D'W_I*D)*D'W_I*S_W*W_I*D*INVPD(D'W_I*D)) provides the same results*/
SEB_W=SQRT(DIAG(AVCOVB_W));
TSTATB_W=B./SEB_W;
PVALUES_W=2*CDFNC(ABS(TSTATB_W));

/******************************************************************************************
 Newey-West standard errors 
******************************************************************************************/

SUM=ZEROS(K,K); 
   J=1;
   DO WHILE J<=minc((Q_NW-1)|rows(G)-1);
      G_J=LAGN(G,J);
      G_L=TRIMR(G,J,0);              
      G_J=TRIMR(G_J,J,0);   
      GAMMA_J=(1/T).*G_L'G_J+(1/T).*G_J'G_L;
      SUM=SUM+(1-J/Q_NW).*GAMMA_J;                   
   J=J+1;
   ENDO;

S_NW=S_W+SUM;
AVCOVB_NW=(1/T).*(INV(D)*S_NW*INV(D));
SEB_NW=SQRT(DIAG(AVCOVB_NW));
TSTATB_NW=B./SEB_NW;
PVALUES_NW=2*CDFNC(ABS(TSTATB_NW));

RETP (T,B,EHAT,SEB_W,SEB_NW,TSTATB_W,TSTATB_NW,PVALUES_W,PVALUES_NW,R2,AR2);
   ENDP; 
