% Replication files for Kurt (2024) "Asymmetric Effects of Monetary Policy on Firms"
%
% The code is based on the Gertler, M. and P. Karadi (AEJ Macro, 2014) "Monetary Policy
% Surprises, Credit Costs and Economic Activity" external instrument SVAR code, modified to 
% extract the monetary policy shocks using Cholesky Decomposition.


% This file Iimports time-series data of extended VAR data. Note the labels and variables of column 11-13 has
% been changed with EBP_OA, EMP and DEBTTOGDP variables.  

% VAR
DATASET_VAR.TSERIES=csvread('../data/VAR_data4_2019q4.csv',1,0);          

DATASET_VAR.LABEL   = {'YEAR','MONTH','LCPI','LIP','FF','GS1','GS2','CM5YR','CM10YR','CM5F5','EBP_OA'};
DATASET_VAR.VALUE   = [   1,     2,      3,     4,   5 ,  6  ,  7  ,   8   ,    9   ,  10   ,  11];

DATASET_VAR.LABEL   = [DATASET_VAR.LABEL,{'EMP','DEBTTOGDP', 'FF_EXP1YR'}];
DATASET_VAR.VALUE   = [DATASET_VAR.VALUE,        12     ,   13        ,      14 ];
 
% % 
% % Creates a mapping between labels and values
DATASET_VAR.MAP = containers.Map(DATASET_VAR.LABEL,DATASET_VAR.VALUE);
% 
%Factors
DATASET_FACTORS.TSERIES=csvread('../data/factor_data.csv',1,0);        
DATASET_FACTORS.LABEL   = {'YEAR','MONTH','MP1_TC','FF4_TC','ED2_TC','ED3_TC','ED4_TC'};
DATASET_FACTORS.VALUE   = [   1,     2   ,  3    ,    4   ,    5   ,   6    ,  7     ];

% % 
% % Creates a mapping between labels and values
DATASET_FACTORS.MAP = containers.Map(DATASET_FACTORS.LABEL,DATASET_FACTORS.VALUE);
% 
save('../data/DATASET4_2019q4.mat','DATASET_VAR','DATASET_FACTORS');
