
set more off
pause off
set level 90
graph set window fontface "Times New Roman"
cap log close
log using "${mainpath}/Log/Baseline/Full Baseline LP_$response.log", replace

sort gvkeyn qdate

*drop if Trim_SalesGrowth == 1 // extra trim for robustness (app figure b4)


if "$response" == "realppentq"  | "$response" == "logppentq" {

gen Trim_ppentq = .
sort qdate
cap drop Thres*
by qdate: egen Threshold99 = pctile(ppentq) if ppentq ! = ., p(99)
by qdate: egen Threshold1 = pctile(ppentq) if ppentq ! = ., p(1)

replace Trim_ppentq = 1 if ppentq > Threshold99 & ppentq ! = .
replace Trim_ppentq = 1 if ppentq < Threshold1 & ppentq ! = .

cap drop Threshold*

by qdate: egen Threshold99 = pctile(drealppentq) if drealppentq ! = ., p(99)
by qdate: egen Threshold1 = pctile(drealppentq) if drealppentq ! = ., p(1)

}

sort gvkeyn qdate

set more off

global HORIZON  = 20 

by gvkeyn : gen firmlife = _N

global LAGS =  4 

cap drop f*
cap drop lag*

*global controls DebtGrowth RealAssetGrowth dloggdp // d$response  

***  robustness controls v1: DebtGrowth RealAssetGrowth dloggdp //
***  robustness controls v2: DebtGrowth RealAssetGrowth dloggdp d$response //


if "$response" == "invratio" {
	
drop if cyear < 1986 

global rscalelabelmainx "yscale(r(-1.5 1)) ylabel(-1.5(0.5)1, labsize(large))" 

}

if "$response" == "realppentq" {
global rscalelabelmainx "yscale(r(-4 4)) ylabel(-4(2)4, labsize(large))" 

}

if "$response" == "logrealcapx" {
global rscalelabelmainx "yscale(r(-22 15)) ylabel(-20(10)10, labsize(large))" 
global rscalelabelmainx2 "yscale(r(-2 2)) ylabel(-2(0.5)2, labsize(large))" 

drop if cyear < 1986
}

if "$response" == "rlcapx_gva" {
global rscalelabelmainx "yscale(r(-15 10)) ylabel(-15(5)10, labsize(large))" 

}

if "$response" == "lnRealSales" {

global rscalelabelmainx "yscale(r(-6 3)) ylabel(-6(2)2, labsize(large))" 

}


if "$response" == "lnempC"  {

global rscalelabelmainx "yscale(r(-3 1)) ylabel(-3(1)1, labsize(large))" 

global rscalelabelmainx_gdp "yscale(r(-5 12)) ylabel(-5(5)10, labsize(large))" 

}

if "$response" == "logppentq" {

global rscalelabelmainx "yscale(r(-4 4)) ylabel(-4(2)4, labsize(large))" 

}

sort gvkeyn qdate


foreach y in $response {
	
	if "$response" != "realppentq" {

	forvalues h=0/${HORIZON} {
		
		qui: by gvkeyn: gen f`h'`y' =  F`h'.`y' - L.`y'
	}
	}
	
	if "$response" == "realppentq" {

	forvalues h=0/${HORIZON} {
		
		qui: by gvkeyn: gen f`h'`y' =  (F`h'.`y' - L.`y')/L.`y'
	}
	}
}


foreach y in $instrument {

	forvalues h=18/${HORIZON} {
		
		qui: by gvkeyn: gen f`h'`y' =  F`h'.`y' - L.`y'
		
	}
}


foreach y in $policy_variable {
		
	forvalues h=0/${HORIZON} {
		
		qui: gen f`h'`y' = F`h'.`y' - L.`y'
		
	}	
}


foreach y in $controls {	
		

	forvalues i=1/${LAGS} {
		
		qui: gen lag`i'`y' = L`i'.`y'
		global lagsAll ${lagsAll} lag`i'`y'
				
	}
}


sort gvkeyn qdate
cap drop horizon
gen horizon = _n - 1 if _n<= $HORIZON + 1

*
cap drop firmtag
egen firmtag = tag(gvkeyn) 
count if firmtag 


*********
*** GENERATING THE EMPTY VARIABLES TO STORE COEFFICIENTS AND STD ERRORS
*********	

	foreach y in $response {	
	forval k = 1/$nq {
	
	gen ir`k'_`y'_IV = .
	gen se`k'_`y'_IV = .
	
	gen ir`k'_`y'_IVp = .
	gen ir`k'_`y'_IVn = .
	gen se`k'_`y'_IVp = .
	gen se`k'_`y'_IVn = .

	
	}
	}
	

cap drop samp2

reg f${HORIZON}${instrument} ${instrument}
gen samp2 = e(sample)


timer clear
timer on 1


/*
ivreghdfe f10ln* $lagsAll Trend (c.${npolicy_variable} c.${ppolicy_variable} = c.${ninstrument} c.${pinstrument}) if samp == 1, cluster(qdate gvkeyn) absorb(gvkeyn) bw(16)
test gs1dn + gs1dp = 0 
*/


/*
ivreghdfe f10in* $lagsAll Trend (c.${npolicy_variable} c.${ppolicy_variable} = c.${ninstrument} c.${pinstrument}) if samp == 1, cluster(qdate gvkeyn) absorb(gvkeyn) bw(16)  

*/



* I - BASELINE 
foreach y in $response {

	forv h = 0/$HORIZON {


ivreghdfe f`h'`y' $lagsAll Trend (c.${npolicy_variable} c.${ppolicy_variable} = c.${ninstrument} c.${pinstrument}) if samp == 1, cluster(qdate gvkeyn) absorb(gvkeyn) bw(16) 

	
replace ir1_`y'_IVp =  _b[${ppolicy_variable}] if horizon==`h'  
replace se1_`y'_IVp =  _se[${ppolicy_variable}] if horizon==`h' 

replace ir1_`y'_IVn =  _b[${npolicy_variable}] if horizon==`h' 
replace se1_`y'_IVn =  _se[${npolicy_variable}] if horizon==`h'  


	}
}

	
**** GRAPHING IMPULSE RESPONSES 

capture drop horizon
capture drop zero

gen horizon = _n - 1 
* zero line
gen zero = 0 if _n <= $HORIZON +1

* Create confidence bands
scalar sig1 = 0.05
scalar sig2 = 0.1

capture drop up*
capture drop dn*
	
	
**** IMPULSE RESPONSES FOR IV **** 

foreach y in $response {
	forval k = 1/$nq {

local PLOTH = ${HORIZON} // + 1

gen up`k'_`y'_IVp = ir`k'_`y'_IVp + invnormal(1-sig2/2)*se`k'_`y'_IVp if (inrange(horizon,0,`PLOTH'))
gen dn`k'_`y'_IVp = ir`k'_`y'_IVp - invnormal(1-sig2/2)*se`k'_`y'_IVp if (inrange(horizon,0,`PLOTH'))

graph twoway (rarea up`k'_`y'_IVp dn`k'_`y'_IVp horizon, ${rscalelabelmainx}  fcolor(gs13) lcolor(white) lpattern(solid))  ///
	(scatter ir`k'_`y'_IVp horizon, ${rscalelabelmainx} connect(1) lcolor(dknavy) lwidth(medthick) msymbol(o) msize(medium) mcolor(blue)) ///
	(line zero horizon, lcolor(black)) if inrange(horizon,0,`PLOTH'), ///
	ytitle("`: variable label `y'' ", size(large)) xtitle("Horizon (Quarters)", size(large)) xlab(0 4 8 12 16 20, labsize(large)) ///
	graphregion(color(white)) plotregion(color(white)) legend(off) name(IV_`y'_`k',replace)  ///
	
graph export "${mainpath}/Figures/IR/Micro LPs/ir_IV_`y'_`k'_${capx}_${pinstrument}_${ppolicy_variable}_${HORIZON}.pdf", replace 
}
}


foreach y in $response {
	forval k = 1/$nq {
	
local PLOTH = ${HORIZON} // + 1

gen up`k'_`y'_IVn = ir`k'_`y'_IVn + invnormal(1-sig2/2)*se`k'_`y'_IVn if (inrange(horizon,0,`PLOTH'))
gen dn`k'_`y'_IVn = ir`k'_`y'_IVn - invnormal(1-sig2/2)*se`k'_`y'_IVn if (inrange(horizon,0,`PLOTH'))

graph twoway (rarea up`k'_`y'_IVn dn`k'_`y'_IVn horizon, ${rscalelabelmainx} fcolor(gs13) lcolor(white) lpattern(solid)) ///
	(scatter ir`k'_`y'_IVn horizon, ${rscalelabelmainx} connect(1) lcolor(dknavy) lwidth(medthick) msymbol(o) msize(medium) mcolor(blue)) ///
	(line zero horizon, lcolor(black)) if inrange(horizon,0,`PLOTH'), ///
	ytitle("`: variable label `y'' ", size(large)) xtitle("Horizon (Quarters)", size(large)) xlab(0 4 8 12 16 20, labsize(large)) ///
	graphregion(color(white)) plotregion(color(white)) legend(off) name(IV_`y'_`k',replace)  ///
	
graph export "${mainpath}/Figures/IR/Micro LPs/ir_IV_`y'_`k'_${capx}_${ninstrument}_${npolicy_variable}_${HORIZON}.pdf", replace 
}
}
