
set more off
pause off
set level 90

graph set window fontface "Times New Roman"
log using "${mainpath}/Log/Baseline/Table Baseline LP_$response.log", replace

sort gvkeyn qdate

if "$response" == "realppentq"  | "$response" == "logppentq" {

gen Trim_ppentq = .
sort qdate
by qdate: egen Threshold99 = pctile(ppentq) if ppentq ! = ., p(99)
by qdate: egen Threshold1 = pctile(ppentq) if ppentq ! = ., p(1)

replace Trim_ppentq = 1 if ppentq > Threshold99 & ppentq ! = .
replace Trim_ppentq = 1 if ppentq < Threshold1 & ppentq ! = .

cap drop Threshold*

by qdate: egen Threshold99 = pctile(drealppentq) if drealppentq ! = ., p(99)
by qdate: egen Threshold1 = pctile(drealppentq) if drealppentq ! = ., p(1)

}

sort gvkeyn qdate

global HORIZON  = 20 

by gvkeyn : gen firmlife = _N

global LAGS =  4 

cap drop f*
cap drop lag*

global controls // DebtGrowth RealAssetGrowth dloggdp d$response //  

***  robustness controls v1: DebtGrowth RealAssetGrowth dloggdp //

if "$response" == "invratio" {
	
drop if cyear < 1986 

global rscalelabelmainx "yscale(r(-2 1.5)) ylabel(-2(1)1, labsize(large))" 

}

if "$response" == "realppentq" {
	
global rscalelabelmainx "yscale(r(-4 4)) ylabel(-4(2)4, labsize(large))" 

}

if "$response" == "logrealcapx" {
global rscalelabelmainx "yscale(r(-22 15)) ylabel(-20(10)10, labsize(large))" 
global rscalelabelmainx2 "yscale(r(-2 2)) ylabel(-2(0.5)2, labsize(large))" 

drop if cyear < 1986
}


if "$response" == "rlcapx_gva" {
global rscalelabelmainx "yscale(r(-15 10)) ylabel(-15(5)10, labsize(large))" 
}


if "$response" == "lnRealSales" {

global rscalelabelmainx "yscale(r(-6 4)) ylabel(-6(2)4, labsize(large))" 

}
*/

if "$response" == "lnempC"  {

global rscalelabelmainx "yscale(r(-3 1)) ylabel(-3(1)1, labsize(large))" 

}

if "$response" == "logppentq" {

global rscalelabelmainx "yscale(r(-4 4)) ylabel(-4(2)4, labsize(large))" 

}

sort gvkeyn qdate


foreach y in $response {
	
	forvalues h=0/${HORIZON} {
		
		qui: by gvkeyn: gen f`h'`y' =  F`h'.`y' - L.`y'
	}
	
}

* this is used for common sample only.
foreach y in $instrument {

	forvalues h=18/${HORIZON} {
		
		qui: by gvkeyn: gen f`h'`y' =  F`h'.`y' - L.`y'
		
	}
}


foreach y in $policy_variable {
		
	forvalues h=0/${HORIZON} {
		
		qui: gen f`h'`y' = F`h'.`y' - L.`y'
		
	}	
}


foreach y in $controls {	
		

	forvalues i=1/${LAGS} {
		
		qui: gen lag`i'`y' = L`i'.`y'
		global lagsAll ${lagsAll} lag`i'`y'
				
	}
}

sort gvkeyn qdate
cap drop horizon
gen horizon = _n - 1 if _n<= $HORIZON + 1


*********
*** GENERATING VARIABLES TO STORE COEFFICIENTS AND STD ERRORS
*********


	foreach y in $response {	
	forval k = 1/$nq {
	
	
	gen ir`k'_`y'_IV = .
	gen se`k'_`y'_IV = .
	
	gen ir`k'_`y'_IVp = .
	gen ir`k'_`y'_IVn = .
	gen se`k'_`y'_IVp = .
	gen se`k'_`y'_IVn = .
	
	}
	}
	

cap drop samp2

reg f${HORIZON}${instrument} ${instrument}
gen samp2 = e(sample)


**********
*** THE REGRESSIONS 
**********

/*
****** Hypothesis Testing
ivreghdfe f10ln* $lagsAll Trend (c.${npolicy_variable} c.${ppolicy_variable} = c.${ninstrument} c.${pinstrument}) if samp == 1, cluster(qdate gvkeyn) absorb(gvkeyn) bw(16)
test gs1dn + gs1dp = 0 //
stop
*/

/*
ivreghdfe f10in* $lagsAll Trend (c.${npolicy_variable} c.${ppolicy_variable} = c.${ninstrument} c.${pinstrument}) if samp == 1, cluster(qdate gvkeyn) absorb(gvkeyn) bw(16) 
test gs1dn + gs1dp = 0 
stop
*/


foreach y in $response {

foreach h in 0 4 8 10 12 16  {  // 

ivreghdfe f`h'`y' $lagsAll Trend (c.${npolicy_variable} c.${ppolicy_variable} = c.${ninstrument} c.${pinstrument}) if samp == 1, cluster(qdate gvkeyn) absorb(gvkeyn) bw(16)
 
ereturn display // needed for ivreg2

matrix rtable`h'=r(table)
matrix list rtable`h'

}
}

stop


*test gs1dn + gs1dp = 0 


capture program drop make_stars
program define       make_stars, rclass
if `1' > .1 {
return local star ""
}
if `1' > .05  & `1' <= .1 {
return local star "*"
}
if `1' > .01  & `1' <= .05 {
return local star "**"
}
if `1' < .01 {
return local star "***"
}
end

/*

matrix rtablebase`h'=r(table)
matrix list rtablebase`h'

foreach y in $response {


foreach h in 0 4 8 10 12 16 { // 10

local       h`h'_b_n  = string(rtable`h'[1,1], "%6.2f" )
local       h`h'_low_n = string(rtable`h'[5,1], "%6.2f" )
local       h`h'_up_n = string(rtable`h'[6,1], "%6.2f" )

local       h`h'_p_n_1=  rtable`h'[4,1] 
make_stars `h`h'_p_n_1'
local       h`h'_s_n_1 `r(star)'


local       h`h'_b_p  = string(rtable`h'[1,2], "%6.2f" )
local       h`h'_low_p = string(rtable`h'[5,2], "%6.2f" )
local       h`h'_up_p = string(rtable`h'[6,2], "%6.2f" )

local       h`h'_p_p_1=       rtable`h'[4,2] 
make_stars `h`h'_p_p_1'
local       h`h'_s_p_1 `r(star)'


}


capture file close file_write
file open          file_write using "${mainpath}/Tables/IRF_TableC12_`y'_BaselineFigs.tex", write replace
file write         file_write ///
"\begin{table}[!htb]"                 	 											   _n ///
"\caption{`y' Response to Asymmetric Effects of Monetary Policy}"    _n ///
"\label{tab:example}"              													   _n ///
"\centering"                                                                           _n ///
"\footnotesize" 			 														   _n ///
"\begin{threeparttable}"                                                  			   _n ///
"\begin{tabularx}{0.98\linewidth}{l|lYYYYYY}"                                          _n ///
"\hline \hline"				              					 			               _n ///
"& & h_{0} & h_{4} & h_{8} & h_{10} & h_{12} & h_{16}  \\"                             _n ///
"\hline "		   		              					 			                   _n ///
"  Var1        & \beta^{+}              &  ""`h0_b_p'`h0_s_p_1' ""     &  ""`h4_b_p'`h4_s_p_1'""    &  ""`h8_b_p'`h8_s_p_1' ""  & ""`h10_b_p'`h10_s_p_1'""  &  ""`h12_b_p'`h12_s_p_1'"" &  ""`h16_b_p'`h16_s_p_1'"" \\"      _n ///
"        &         & (""`h0_low_p',  `h0_up_p'     "")  & (""`h4_low_p' , `h4_up_p'"") & (""`h8_low_p' ,  `h8_up_p'"") & (""`h10_low_p' ,  `h10_up_p'"") & (""`h12_low_p' ,  `h12_up_p'"") & (""`h16_low_p' ,  `h16_up_p'"")  \\" _n ///
"  & \beta^{-}      &  "" `h0_b_n'`h0_s_n_1' ""   &      ""`h4_b_n'`h4_s_n_1' ""   &      ""`h8_b_n'`h8_s_n_1'"" &   ""`h10_b_n'`h10_s_n_1'"" &   ""`h12_b_n'`h12_s_n_1'"" &   ""`h16_b_n'`h16_s_n_1'""  \\" _n ///
"         &         & (""`h0_low_n',  `h0_up_n'     "")  & (""`h4_low_n'  ,  `h4_up_n'"")   & (""`h8_low_n'  ,  `h8_up_n'"")  &   (""`h10_low_n'  ,  `h10_up_n'"")  & (""`h12_low_n'  ,  `h12_up_n'"") & (""`h16_low_n'  ,  `h16_up_n'"")    \\" _n ///
"\hline"  _n ///
"\hline \hline"				              					 			               _n ///
"\end{tabularx}" 																	   _n ///
"\end{threeparttable}" 																   _n ///
"\end{table}"																													
file close file_write

}
