set more off
pause off
clear
macro drop _all
set seed 1073741823
graph set window fontface "Times New Roman"

cd ""

global mainpath "/Users/ekurt/Desktop/MP ASYM/Stata"

use "${mainpath}/Data/Quarter_LP_Ready3_REGS.dta",clear

gen logRealAsset = log(atq/(gva_pindex/100))*100

count if sumnageflag > 0 

drop if sumnageflag > 0 
global ncat = 2
cap drop cate_var
gen cate_var = .
replace cate_var = 1 if inrange(age,0,20) 
replace cate_var = 2 if age > 20 & age !=. 

/*
keep if cate_var == 1 | cate_var ==2 

cap drop firmtag
egen firmtag = tag(gvkeyn)  
count if firmtag 
*/

capture macro drop nq
global nq = ${ncat}

rename GK_New2019 Extracted_MPShockE

label var Extracted_MPShockE "MP Shock (GK extended)"
 
sort gvkeyn cyear cquarter
xtset gvkeyn qdate


capture drop shock_var*
capture drop group_var*

cap drop posit* negat*
gen positives = Extracted_MPShockE if gs1d > 0 & gs1d !=.
gen negatives = Extracted_MPShockE if gs1d < 0 & gs1d !=.

replace positives = 0 if positives ==.
replace negatives = 0 if negatives ==.

gen logTotEmp = log(TotEmp)*100

* ================================================================

**** RESPONSE VARIABLE, POLICY VARIABLE AND INSTRUMENT INTERACTIONS.

* ================================================================

global dependent   lnempC // lnRealSales invratio   // // 

foreach y in $dependent {

preserve
capture macro drop response
global response `y' //  lnempC // invratio //  lnRealSales //    

sort gvkeyn qdate
by gvkeyn: gen d$response = $response - L.$response


capture macro drop folder
global folder "Het_single/age"  // 

capture macro drop policy_variable
global policy_variable gs1d  

capture macro drop ppolicy_variable
global ppolicy_variable gs1dp  

capture macro drop pnolicy_variable
global npolicy_variable gs1dn   

capture macro drop instrument
global instrument Extracted_MPShockE 

capture macro drop ninstrument
global ninstrument negatives 

capture macro drop pinstrument
global pinstrument positives 

drop if DebtAssetRatio < 0
drop if LiquidityRatio < 0
drop if saleq < 0
drop if invratio < 0

sort gvkeyn qdate

drop if cyear < 1980
drop if cyear == 1980 & cquarter ==1 
drop if cyear == 1980 & cquarter ==2

drop if cyear >= 2020

do "${mainpath}/Do/HETEROGENEITY/82A.LP_Asym_IV_Table_Age.do" 

capture macro drop $response
restore
}
