
set more off
pause off
clear
macro drop _all

graph set window fontface "Times New Roman"

cd ""
global mainpath "/Users/ekurt/Desktop/MP ASYM/Stata"

use "${mainpath}/Data/Quarter_LP_Ready3_REGS.dta",clear

gen logRealAsset = log(atq/(gva_pindex/100))*100

count if spcsrc ==""

global ncat = 2
cap drop cate_var
gen cate_var = .
replace cate_var = 1 if spcsrc == "B-" | spcsrc == "C" | spcsrc == "D"  // low rating
replace cate_var = 2 if spcsrc == "A" | spcsrc == "A+" | spcsrc == "A-" | spcsrc == "B+" | spcsrc == "B" // high rating


capture macro drop nq
global nq = ${ncat}

rename GK_New2019 Extracted_MPShockE

label var Extracted_MPShockE "MP Shock (GK extended)"
 
sort gvkeyn cyear cquarter
xtset gvkeyn qdate

capture drop shock_var*
capture drop group_var*

cap drop posit* negat*
gen positives = Extracted_MPShockE if gs1d > 0 & gs1d !=.
gen negatives = Extracted_MPShockE if gs1d < 0 & gs1d !=.

replace positives = 0 if positives ==.
replace negatives = 0 if negatives ==.

gen logTotEmp = log(TotEmp)*100


global dependent  lnempC // lnRealSales invratio    

foreach y in $dependent {

preserve
capture macro drop response
global response `y'  

sort gvkeyn qdate
by gvkeyn: gen d$response = $response - L.$response

capture macro drop folder
global folder "Het_single/credit rating"  // 

capture macro drop policy_variable
global policy_variable gs1d  

capture macro drop ppolicy_variable
global ppolicy_variable gs1dp   

capture macro drop pnolicy_variable
global npolicy_variable gs1dn  

capture macro drop instrument
global instrument Extracted_MPShockE  

capture macro drop ninstrument
global ninstrument negatives 

capture macro drop pinstrument
global pinstrument positives 
 
capture macro drop groupvar
capture macro drop shock_interact
capture macro drop mrate_interact
capture macro drop itc_interact
capture macro drop helpvar

global groupvar group_var
global shock_interactp pi_var* 
global shock_interactn ni_var* 
global mrate_interactp mainx_pvar 
global mrate_interactn mainx_nvar 
global itc_interact dITC_var
global helpvar rank_var 

capture macro drop var
global var "TI"

drop if DebtAssetRatio < 0
drop if LiquidityRatio < 0
drop if saleq < 0
drop if invratio < 0

sort gvkeyn qdate

drop if cyear < 1980
drop if cyear == 1980 & cquarter ==1 
drop if cyear == 1980 & cquarter ==2

drop if cyear >= 2020

do "${mainpath}/Do/HETEROGENEITY/82A.LP_Asym_IV_Table_CreditRating.do" 

capture macro drop $response
restore
}

