set more off
pause off
clear
macro drop _all
graph set window fontface "Times New Roman"
cd ""

global mainpath "/Users/ekurt/Desktop/MP ASYM/Stata"

use "${mainpath}/Data/Quarter_LP_Ready3_REGS.dta",clear

gen logRealAsset = log(atq/(gva_pindex/100))*100

capture macro drop nq
cap drop var1
global ncat = 3 
gen var1 =  DebtAssetRatio  

sort gvkeyn qdate
capture drop lag_var1
bysort gvkeyn: gen lag_var1 = var1[_n-1]

*
cap drop cate_var
gen cate_var =.


local startYear 1979 

local endYear 2019 

 foreach ii of num `startYear'/`endYear' {
                sort gvkeyn cyear
                fastxtile cat_temp = lag_var1 if cyear == `ii', nq($ncat)
                replace cate_var = cat_temp if cyear == `ii'
                drop cat_temp
}

sort gvkeyn cyear
fastxtile cat_temp = lag_var1, nq($ncat)
replace cate_var = cat_temp
drop cat_temp


capture macro drop nq
global nq = ${ncat}


rename GK_New2019 Extracted_MPShockE

label var Extracted_MPShockE "MP Shock (GK extended)"
 
sort gvkeyn cyear cquarter
xtset gvkeyn qdate


capture drop shock_var*
capture drop group_var*


cap drop posit* negat*
gen positives = Extracted_MPShockE if gs1d > 0 & gs1d !=.
gen negatives = Extracted_MPShockE if gs1d < 0 & gs1d !=.

replace positives = 0 if positives ==.
replace negatives = 0 if negatives ==.

gen logTotEmp = log(TotEmp)*100

* ================================================================

**** RESPONSE VARIABLE, POLICY VARIABLE AND INSTRUMENT INTERACTIONS.

* ================================================================


global dependent lnempC lnRealSales invratio //     //     

foreach y in $dependent {

preserve
capture macro drop response
global response `y' //   lnRealSales //   invratio //  lnempC //   

sort gvkeyn qdate
by gvkeyn: gen d$response = $response - L.$response

capture macro drop folder
global folder "Het_single/leverage"  // 

capture macro drop policy_variable
global policy_variable gs1d  

capture macro drop ppolicy_variable
global ppolicy_variable gs1dp  

capture macro drop pnolicy_variable
global npolicy_variable gs1dn  

capture macro drop instrument
global instrument Extracted_MPShockE 

capture macro drop ninstrument
global ninstrument negatives  

capture macro drop pinstrument
global pinstrument positives 


drop if DebtAssetRatio < 0
drop if LiquidityRatio < 0
drop if saleq < 0
drop if invratio < 0


sort gvkeyn qdate

drop if cyear < 1980
drop if cyear == 1980 & cquarter ==1 
drop if cyear == 1980 & cquarter ==2


drop if cyear >= 2020


do "${mainpath}/Do/HETEROGENEITY/82A.LP_Asym_IV_TableCat3.do" 

capture macro drop $response
restore
}

*capture macro drop $folder

