
set more off
pause off
set level 90

graph set window fontface "Times New Roman"
cap log close

sort gvkeyn qdate

if "$response" == "realppentq"  | "$response" == "logppentq" {

gen Trim_ppentq = .
sort qdate
by qdate: egen Threshold99 = pctile(ppentq) if ppentq ! = ., p(99)
by qdate: egen Threshold1 = pctile(ppentq) if ppentq ! = ., p(1)

replace Trim_ppentq = 1 if ppentq > Threshold99 & ppentq ! = .
replace Trim_ppentq = 1 if ppentq < Threshold1 & ppentq ! = .

cap drop Threshold*

by qdate: egen Threshold99 = pctile(drealppentq) if drealppentq ! = ., p(99)
by qdate: egen Threshold1 = pctile(drealppentq) if drealppentq ! = ., p(1)

drop if Trim_ppentq == 1  // deneme wo this.

}

sort gvkeyn qdate

set more off

global HORIZON  = 20 

by gvkeyn : gen firmlife = _N

global LAGS =  4

cap drop f*
cap drop lag*

if "$response" == "invratio" {
global rscalelabelmainx "yscale(r(-1.2 0.6)) ylabel(-1(0.5)0.5, labsize(large))" 
global rscalelabelmainx2 "yscale(r(-0.2 0.2)) ylabel(-0.2(0.1)0.2, labsize(large))" 

*drop if cyear < 1986 

gen capxq2 = capxq
bysort gvkeyn: replace capxq2 = inv_lom if cyear <= 1983 & capxq ==. & inv_lom !=. // FILL TILL 1984
bysort gvkeyn: replace invratio = capxq2 * 100 / ppentLag if invratio ==. & cyear <= 1983
*/

}


if "$response" == "realppentq" {
*global rscalelabelmainx "yscale(r(-1 1)) ylabel(-1(0.5)1, labsize(large))" 
global rscalelabelmainx "yscale(r(-10 5)) ylabel(-10(5)5, labsize(large))" 


}

if "$response" == "logrealcapx" {
global rscalelabelmainx "yscale(r(-16 10)) ylabel(-15(5)10, labsize(large))" 
global rscalelabelmainx2 "yscale(r(-2 2)) ylabel(-2(0.5)2, labsize(large))" 

}

if "$response" == "lnRealSales" {

global rscalelabelmainx "yscale(r(-6 3)) ylabel(-6(2)2, labsize(large))" 

}
*/

if "$response" == "lnempC"  {

global rscalelabelmainx "yscale(r(-2.3 1.3)) ylabel(-2(1)1, labsize(large))" 

global rscalelabelmainx_gdp "yscale(r(-5 12)) ylabel(-5(5)10, labsize(large))" 

}

if "$response" == "logppentq" {

global rscalelabelmainx "yscale(r(-4 4)) ylabel(-4(2)4, labsize(large))" 

}


sort gvkeyn qdate


foreach y in $response {
	
	forvalues h=0/${HORIZON} {
		
		qui: by gvkeyn: gen f`h'`y' =  F`h'.`y' - L.`y'
	}
	}



foreach y in $instrument {

	forvalues h=18/${HORIZON} {
		
		qui: by gvkeyn: gen f`h'`y' =  F`h'.`y' - L.`y'
		
	}
}


foreach y in $policy_variable {
		
	forvalues h=0/${HORIZON} {
		
		qui: gen f`h'`y' = F`h'.`y' - L.`y'
		
	}	
}


foreach y in $controls {	
		
	forvalues i=1/${LAGS} {
		
		qui: gen lag`i'`y' = L`i'.`y'
		global lagsAll ${lagsAll} lag`i'`y'
				
	}
}


sort gvkeyn qdate
gen horizon = _n - 1 if _n<= $HORIZON + 1

cap drop firmtag
egen firmtag = tag(gvkeyn) 
count if firmtag 


*********
*** GENERATING THE EMPTY VARIABLES TO STORE COEFFICIENTS AND STD ERRORS
*********
	

	foreach y in $response {	
	forval k = 1/$nq {
	
	gen ir`k'_`y'_IV = .
	gen se`k'_`y'_IV = .
	
	gen ir`k'_`y'_IVp = .
	gen ir`k'_`y'_IVn = .
	gen se`k'_`y'_IVp = .
	gen se`k'_`y'_IVn = .
	
	gen ir`k'_`y'_IVp2 = .
	gen ir`k'_`y'_IVn2 = .
	gen se`k'_`y'_IVp2 = .
	gen se`k'_`y'_IVn2 = .
	
	gen ir`k'_`y'_IVp2_dgdp_neg = .
	gen ir`k'_`y'_IVn2_dgdp_neg = .
	gen se`k'_`y'_IVp2_dgdp_neg = .
	gen se`k'_`y'_IVn2_dgdp_neg = .
	
	gen ir`k'_`y'_IVp2_dgdp_pos = .
	gen ir`k'_`y'_IVn2_dgdp_pos = .
	gen se`k'_`y'_IVp2_dgdp_pos = .
	gen se`k'_`y'_IVn2_dgdp_pos = .

	}
	}	
	

reg f${HORIZON}${instrument} ${instrument}
gen samp2 = e(sample)


gen dum2001 = 0
replace dum2001 = 1 if cyear == 2001 

gen dum2008 = 0
replace dum2008 = 1 if cyear == 2008

gen dum1981 = 0
replace dum1981 = 1 if cyear == 1981


* BUSINESS CYCLE INTERACTIONS

cap drop pos_dloggdp
cap drop neg_dloggdp
gen pos_dloggdp = dloggdp if dloggdp >0   & USRECM == 1
gen neg_dloggdp = dloggdp if dloggdp <0   & USRECM == 1
replace pos_dloggdp = 0 if pos_dloggdp ==.
replace neg_dloggdp = 0 if neg_dloggdp ==.


* generate sign-dependent business cycle dummies 
cap drop pos_dgdp_dum
gen pos_dgdp_dum = 0
replace pos_dgdp_dum = 1 if pos_dloggdp !=0

cap drop neg_dgdp_dum
gen neg_dgdp_dum = 0
replace neg_dgdp_dum = 1 if neg_dloggdp !=0


ivreghdfe f10lnemp Trend (c.${npolicy_variable} c.${ppolicy_variable} = c.${ninstrument} c.${pinstrument}) if samp == 1, cluster(qdate gvkeyn) absorb(gvkeyn) bw(16)



foreach y in $response {

foreach h in 10 {  //  0 4 8 10 12 16

ivreghdfe f`h'`y'  Trend (c.${npolicy_variable} c.${ppolicy_variable} = c.${ninstrument} c.${pinstrument}) if samp == 1, cluster(qdate gvkeyn) absorb(gvkeyn) bw(16)
 
*$lagsAll 
ereturn display // needed for ivreg2

matrix rtablebase`h'=r(table)
matrix list rtablebase`h'

}
}
*/


foreach y in $response {

foreach h in 10  {  // 0 4 8 10 12 16 

ivreghdfe f`h'`y'  Trend  c.pos_dloggdp c.neg_dloggdp  (c.${npolicy_variable}  c.${npolicy_variable}#c.pos_dloggdp c.${npolicy_variable}#c.neg_dloggdp ///
c.${ppolicy_variable} c.${ppolicy_variable}#c.pos_dloggdp c.${ppolicy_variable}#c.neg_dloggdp ///
 = c.${ninstrument} c.${ninstrument}#c.pos_dloggdp c.${ninstrument}#c.neg_dloggdp c.${pinstrument} c.${pinstrument}#c.pos_dloggdp ///
 c.${pinstrument}#c.neg_dloggdp) if samp == 1,  cluster(gvkeyn qdate) absorb(gvkeyn) bw(16)
 
*$lagsAll 

ereturn display // needed for ivreg2

matrix rtable`h'=r(table)
matrix list rtable`h'

}
}


capture program drop make_stars
program define       make_stars, rclass
if `1' > .1 {
return local star ""
}
if `1' > .05  & `1' <= .1 {
return local star "*"
}
if `1' > .01  & `1' <= .05 {
return local star "**"
}
if `1' < .01 {
return local star "***"
}
end


foreach y in $response {

foreach h in 10  { //   0 4 8 10 12 16 

matrix list rtable`h' 

local       h`h'_b_n  = string(rtable`h'[1,1], "%6.2f" )
local       h`h'_se_n = string(rtable`h'[2,1], "%6.2f" )

local       h`h'_p_n=  rtable`h'[4,1] 
make_stars `h`h'_p_n'
local       h`h'_s_n `r(star)'

*** gdp interactions
local       h`h'_b_n_posgdp  = string(rtable`h'[1,2], "%6.2f" )
local       h`h'_se_n_posgdp = string(rtable`h'[2,2], "%6.2f" )

local       h`h'_p_n_posgdp =  rtable`h'[4,2] 
make_stars `h`h'_p_n_posgdp'
local       h`h'_s_n_posgdp `r(star)'

local       h`h'_b_n_neggdp  = string(rtable`h'[1,3], "%6.2f" )
local       h`h'_se_n_neggdp = string(rtable`h'[2,3], "%6.2f" )

local       h`h'_p_n_neggdp =  rtable`h'[4,3] 
make_stars `h`h'_p_n_neggdp'
local       h`h'_s_n_neggdp `r(star)'


local       h`h'_b_p  = string(rtable`h'[1,4], "%6.2f" )
local       h`h'_se_p = string(rtable`h'[2,4], "%6.2f" )

local       h`h'_p_p=  rtable`h'[4,4] 
make_stars `h`h'_p_p'
local       h`h'_s_p `r(star)'


*** gdp interactions
local       h`h'_b_p_posgdp  = string(rtable`h'[1,6], "%6.2f" )
local       h`h'_se_p_posgdp = string(rtable`h'[2,6], "%6.2f" )

local       h`h'_p_p_posgdp =  rtable`h'[4,6] 
make_stars `h`h'_p_p_posgdp'
local       h`h'_s_p_posgdp `r(star)'

local       h`h'_b_p_neggdp  = string(rtable`h'[1,5], "%6.2f" )
local       h`h'_se_p_neggdp = string(rtable`h'[2,5], "%6.2f" )

local       h`h'_p_p_neggdp =  rtable`h'[4,5] 
make_stars `h`h'_p_p_neggdp'
local       h`h'_s_p_neggdp `r(star)'

}


*

foreach y in $response {
	
foreach h in 10  { //    0 4 8 10 12 16

matrix list rtablebase`h'

local       h`h'_b_n_bas  = string(rtablebase`h'[1,1], "%6.2f" )
local       h`h'_se_n_bas = string(rtablebase`h'[2,1], "%6.2f" )

local       h`h'_p_n_bas=  rtablebase`h'[4,1] 
make_stars `h`h'_p_n_bas'
local       h`h'_s_n_bas `r(star)'


local       h`h'_b_p_bas  = string(rtablebase`h'[1,2], "%6.2f" )
local       h`h'_se_p_bas = string(rtablebase`h'[2,2], "%6.2f" )

local       h`h'_p_p_bas=  rtablebase`h'[4,2] 
make_stars `h`h'_p_p_bas'
local       h`h'_s_p_bas `r(star)'

}
}		

	
*** LATEX TABLE 
capture file close file_write
file open          file_write using "${mainpath}/Tables/BusinessCycle/IRF_Table_BC_${response}_H10.tex", write replace
file write         file_write ///
"\begin{table}[!htb]"                 	 											   _n ///
"\caption{\textsc{Asymmetric Effects of Monetary Policy and Business Cycle}}"          _n ///
"\label{tab:example}"              													   _n ///
"\centering"                                                                           _n ///
"\setstretch{1.1}"                                                                     _n ///
"\footnotesize" 			 														   _n ///
"\begin{threeparttable}"                                                  			   _n ///
"\begin{tabularx}{0.98\linewidth}{|l|YYYYYYYY}"                                        _n ///
"\hline "		   		              					 			                   _n ///
" & \beta^{+}_{Baseline} & \beta^{+} &  \gamma^{+,+}    &  \gamma^{+,-} &  \beta^{-}_{Baseline}   &  \beta^{-} &  \gamma^{-,+}    &  \gamma^{-,-} \\ " _n ///
" ${response} & ""`h10_b_p_bas'`h10_s_p_bas'""  & ""`h10_b_p'`h10_s_p'"" & ""`h10_b_p_posgdp'`h10_s_p_posgdp'"" & ""`h10_b_p_neggdp'`h10_s_p_neggdp'"" & ""`h10_b_n_bas'`h10_s_n_bas'"" & ""`h10_b_n'`h10_s_n'"" & ""`h10_b_n_posgdp'`h10_s_n_posgdp'"" & ""`h10_b_n_neggdp'`h10_s_n_neggdp'"" \\"                                               _n ///
"\hline "		   		              					 			                   _n ///
"   &  (""`h10_se_p_bas'"") &  (""`h10_se_p'"") & (""`h10_se_p_posgdp'"") & (""`h10_se_p_neggdp'"") & (""`h10_se_n_bas'"") & (""`h10_se_n' "") & (""`h10_se_n_posgdp'"")  & (""`h10_se_n_neggdp'"") \\"                           _n ///
"\hline "		   		              					 			                   _n ///
"\end{tabularx}" 															           _n ///	
"\hline "		   		              					 			                   _n ///																
"\end{threeparttable}" 																   _n ///
"\end{table}"																													
file close file_write

}
	
