* This do file produces Figure B.5.

*rescaling changes for desciptive graphs. PRODUCES FIG B.5.
cap drop gs1dp_scaled
cap drop gs1dn_scaled
gen gs1dp_scaled = gs1dp/4
gen gs1dn_scaled = gs1dn/4

label var qdate "Date"
label var gs1dp_scaled "Increases in one-year treasury rate"
label var gs1dn_scaled "Decreases in one-year treasury rate"

replace USRECM = 4*USRECM if USRECM !=0

*** summary stats

sum gs1dp_scaled if USRECM ==0, det 
sum gs1dp_scaled if USRECM ==4, det 

label var USRECM "NBER Business Cycle Dates"

sort qdate

twoway  (area USRECM qdate, color(gs14)) (scatter gs1dp_scaled qdate if gs1dp !=0, xlabel(80(20)230) graphregion(color(white)) msize(vsmall))
graph export "${mainpath}/Figures/Descriptive/MP Shocks_bySize_Positives.png", replace 

replace USRECM = -1*USRECM if USRECM !=0

twoway  (area USRECM qdate, color(gs14)) (scatter gs1dn_scaled qdate if gs1dn !=0, xlabel(80(20)230) graphregion(color(white)) msize(vsmall))
graph export "${mainpath}/Figures/Descriptive/MP Shocks_bySize_Negatives.png", replace 

sum gs1dn_scaled if USRECM ==0, det // off bc. mean 
sum gs1dn_scaled if USRECM ==-4, det // on bc mean 
*/
