function y=func_2sectors_SS(x,bet,alph1,alph2,f1,f2,Pibar,theta,ppsi,sigm,chi)

% exp(x(1)) = P1/P;
% exp(x(2)) = P2/P;
% exp(x(3)) = Y;

y = zeros(3,1);

Lam1powered = alph1/(1-(1-alph1)*Pibar^(theta*(1-ppsi)-1))*exp(x(1))^(1-theta*(1-ppsi));
Lam2powered = alph2/(1-(1-alph2)*Pibar^(theta*(1-ppsi)-1))*exp(x(2))^(1-theta*(1-ppsi));
Lam         = (f1*Lam1powered + f2*Lam2powered)^(1/(1-theta*(1-ppsi)));

S1 = alph1/(1-(1-alph1)/Pibar)*exp(x(1));
S2 = alph2/(1-(1-alph2)/Pibar)*exp(x(2));

y(1) = Lam - (1-ppsi) - ppsi*(f1*S1 + f2*S2);

Z11 = Lam^(theta*(1-ppsi))*exp(x(3)*(1-sigm))/(1-bet*(1-alph1)*Pibar^(theta*(1-ppsi)-1));
Z21 = exp(x(3)*(1-sigm))/(1-bet*(1-alph1)/Pibar);
Z31 = Lam^(2*theta*(1-ppsi))*exp(x(3)*2)/(1-bet*(1-alph1)*Pibar^(2*theta*(1-ppsi)));
Z41 = Lam^(theta*(1-ppsi))*exp(x(3)*2)/(1-bet*(1-alph1)*Pibar^(theta*(1-ppsi)));

y(2) = Z11*exp(x(1)) + ppsi/(theta*(1-ppsi)-1)*Z21*exp(x(1)*(1+theta*(1-ppsi))) - theta*chi/(theta*(1-ppsi)-1)*Z31*exp(x(1)*(-theta*(1-ppsi))) + theta*chi*ppsi/(theta*(1-ppsi)-1)*Z41;

Z12 = Lam^(theta*(1-ppsi))*exp(x(3)*(1-sigm))/(1-bet*(1-alph2)*Pibar^(theta*(1-ppsi)-1));
Z22 = exp(x(3)*(1-sigm))/(1-bet*(1-alph2)/Pibar);
Z32 = Lam^(2*theta*(1-ppsi))*exp(x(3)*2)/(1-bet*(1-alph2)*Pibar^(2*theta*(1-ppsi)));
Z42 = Lam^(theta*(1-ppsi))*exp(x(3)*2)/(1-bet*(1-alph2)*Pibar^(theta*(1-ppsi)));

y(3) = Z12*exp(x(2)) + ppsi/(theta*(1-ppsi)-1)*Z22*exp(x(2)*(1+theta*(1-ppsi))) - theta*chi/(theta*(1-ppsi)-1)*Z32*exp(x(2)*(-theta*(1-ppsi))) + theta*chi*ppsi/(theta*(1-ppsi)-1)*Z42;
