function gensysin = model_defn_J002(x)
% defines gensys input. 
% CES and zero/positive trend inflation
%
% Input
%   x           : a vector of parameter values
%
% Output
%   gensysin    : a structure with the following fields
%                 G0, G1, Psi, Pi, C0
%                 which are standard gensys input.
% 

% The solution takes the form:  x(t) = G1 * x(t-1) + impact * e(t)
%                               y(t) = zmat * x(t) + C
%                               e(t) ~ N(0,SDX*SDX')

% endogenous variables: y, i, pi, pR1, pR2, d1, d2, pR1L1, pR2L1

% -------------------------------------------------------------------------
%  variables
% -------------------------------------------------------------------------

y     = 1;
i     = 2;
p     = 3;
pR1   = 4;
pR2   = 5;
ps1   = 6;
ps2   = 7;
z11   = 8;
z31   = 9;
z12   = 10;
z32   = 11;

NY    = 11;

% -------------------------------------------------------------------------
% innovations
% -------------------------------------------------------------------------

% none
NX   = 0;

% -------------------------------------------------------------------------
% expectational errors
% -------------------------------------------------------------------------

NETA = 5;

% -------------------------------------------------------------------------
% parameters
% -------------------------------------------------------------------------

alph1  = x(1);
alph2  = x(2);
f1     = x(3);
f2     = x(4);
Pibar  = x(5);
phipi  = x(6);
phiy   = x(7);
rhoi   = x(8);
phigy  = x(9);
varphi = x(10);
bet    = x(11);
theta  = x(12);
chi    = x(13);
sigm   = x(14);

% -------------------------------------------------------------------------
% fixed parameters and functions of parameters
% -------------------------------------------------------------------------

%g1   = (1-(1-alph1)*Pibar^(theta-1))*(1-bet*(1-alph1)*Pibar^(theta*(1+varphi)))/((1-alph1)*Pibar^(theta-1));
%g2   = (1-(1-alph2)*Pibar^(theta-1))*(1-bet*(1-alph2)*Pibar^(theta*(1+varphi)))/((1-alph2)*Pibar^(theta-1));
%omg  = (sigm+varphi)/(1+theta*varphi);

Ybar =        f1*alph1/(1-(1-alph1)*Pibar^(theta-1))*((1-bet*(1-alph1)*Pibar^(theta-1))/(1-bet*(1-alph1)*Pibar^(theta*(1+varphi))))^((1-theta)/(1+theta*varphi));
Ybar = Ybar + f2*alph2/(1-(1-alph2)*Pibar^(theta-1))*((1-bet*(1-alph2)*Pibar^(theta-1))/(1-bet*(1-alph2)*Pibar^(theta*(1+varphi))))^((1-theta)/(1+theta*varphi));
Ybar = (theta*chi/(theta-1))^(-1/(sigm+varphi))*Ybar^((1+theta*varphi)/((sigm+varphi)*(theta-1)));

Z11  = Ybar^(1-sigm)/(1-bet*(1-alph1)*Pibar^(theta-1));
Z31  = Ybar^(1+varphi)/(1-bet*(1-alph1)*Pibar^(theta*(1+varphi)));

Z12  = Ybar^(1-sigm)/(1-bet*(1-alph2)*Pibar^(theta-1));
Z32  = Ybar^(1+varphi)/(1-bet*(1-alph2)*Pibar^(theta*(1+varphi)));

Ps1  = (theta*chi/(theta-1)*Z31/Z11)^(1/(1+theta*varphi));
Ps2  = (theta*chi/(theta-1)*Z32/Z12)^(1/(1+theta*varphi));

PRP1 = (alph1/(1-(1-alph1)*Pibar^(theta-1)))^(1/(1-theta))*Ps1;
PRP2 = (alph2/(1-(1-alph2)*Pibar^(theta-1)))^(1/(1-theta))*Ps2;

% -------------------------------------------------------------------------
% System Matrices 
% -------------------------------------------------------------------------

GAM0    = zeros(NY,NY) ;
GAM1    = zeros(NY,NY) ;
PSI     = zeros(NY,NX) ;
PPI     = zeros(NY,NETA) ;
C       = zeros(NY,1) ;

% eq1: consumption Euler equation

GAM0(1,y) = -1;
GAM0(1,p) = -1/sigm;

GAM1(1,y) = -1;
GAM1(1,i) = -1/sigm;

PPI(1,1)  = 1;

% eq2: aggregation of the sectoral price level

GAM0(2,pR1)  = f1*PRP1^(1-theta);
GAM0(2,pR2)  = f2*PRP2^(1-theta);

% eq3: sectoral price level 1

GAM0(3,pR1)  = 1;
GAM0(3,p)    = (1-alph1)*Pibar^(theta-1);
GAM0(3,ps1)  = -(1-(1-alph1)*Pibar^(theta-1));

GAM1(3,pR1)  = (1-alph1)*Pibar^(theta-1);

% eq4: sectoral price level 2

GAM0(4,pR2)  = 1;
GAM0(4,p)    = (1-alph2)*Pibar^(theta-1);
GAM0(4,ps2)  = -(1-(1-alph2)*Pibar^(theta-1));

GAM1(4,pR2)  = (1-alph2)*Pibar^(theta-1);

% eq5: z11

GAM0(5,z11)  = -bet*(1-alph1)*Pibar^(theta-1);
GAM0(5,p)    = -bet*(1-alph1)*Pibar^(theta-1)*(theta-1);

GAM1(5,z11)  = -1;
GAM1(5,y)    = (1-bet*(1-alph1)*Pibar^(theta-1))*(1-sigm);

PPI(5,2)     = 1;

% eq6: z31

GAM0(6,z31)  = -bet*(1-alph1)*Pibar^(theta*(1+varphi));
GAM0(6,p)    = -bet*(1-alph1)*Pibar^(theta*(1+varphi))*theta*(1+varphi);

GAM1(6,z31)  = -1;
GAM1(6,y)    = (1-bet*(1-alph1)*Pibar^(theta*(1+varphi)))*(1+varphi);
%GAM1(6,a)    = -(1-bet*(1-alph1)*Pibar^(theta*(1+varphi)))*(1+varphi);

PPI(6,3)     = 1;

% eq7: FOC 1

GAM0(7,z11)  = 1;
GAM0(7,ps1)  = 1+theta*varphi;
GAM0(7,z31)  = -1;

% eq8: z12

GAM0(8,z12)  = -bet*(1-alph2)*Pibar^(theta-1);
GAM0(8,p)    = -bet*(1-alph2)*Pibar^(theta-1)*(theta-1);

GAM1(8,z12)  = -1;
GAM1(8,y)    = (1-bet*(1-alph2)*Pibar^(theta-1))*(1-sigm);

PPI(8,4)     = 1;

% eq9: z32

GAM0(9,z32)  = -bet*(1-alph2)*Pibar^(theta*(1+varphi));
GAM0(9,p)    = -bet*(1-alph2)*Pibar^(theta*(1+varphi))*theta*(1+varphi);

GAM1(9,z32)  = -1;
GAM1(9,y)    = (1-bet*(1-alph2)*Pibar^(theta*(1+varphi)))*(1+varphi);
%GAM1(9,a)    = -(1-bet*(1-alph1)*Pibar^(theta*(1+varphi)))*(1+varphi);

PPI(9,5)     = 1;

% eq10: FOC 2

GAM0(10,z12)  = 1;
GAM0(10,ps2)  = 1+theta*varphi;
GAM0(10,z32)  = -1;

% eq11: monetary policy

GAM0(11,i)     = 1;
GAM0(11,p)     = -(1-rhoi)*phipi;
GAM0(11,y)     = -(1-rhoi)*(phiy+phigy);

GAM1(11,i)     = rhoi;
GAM1(11,y)     = -(1-rhoi)*phigy;

%% return
gensysin = struct('G0',GAM0,'G1',GAM1,'Psi',PSI,'Pi',PPI,'C0',C);