% Determinacy/indeterminacy boundaries for two-sector NK model
% CES, zero/positive trend inflation
% WYP, December 2020

% housekeeping

clear;
clc;

% change the following to your path to gensys
addpath('../../../../gensys')

filenm  = 'nokink_trend_inflation_2s_boundary';

% parameter values

alpha1s = [0.5; 0.4; 0.3; 0.2; 0.1];
alpha2s = [0.5; 0.6; 0.7; 0.8; 0.9];

f1s     = [0.5; 0.7; 0.3];
f2s     = [0.5; 0.3; 0.7];

varphis = [1;0];

%% zero trend inflation

Pibars  = 1.^(1/4);

alpha1n = length(alpha1s);
f1n     = length(f1s);
varphin = length(varphis);
Pibarn  = length(Pibars);

theta   = 10;
bet     = 0.99;
chi     = 8;
sigm    = 1;

ppsi    = 0;

phipis  = 0:0.001:2;
phiyinc = 0.001; phiys   = 0:phiyinc:2; 

phipin  = length(phipis);
phiyn   = length(phiys);

% iteration

detchk = nan(phipin,phiyn,alpha1n,f1n,varphin,Pibarn);
bnds   = cell(phipin,alpha1n,f1n,varphin,Pibarn);

tic;

for ind1=1:alpha1n

    alph1  = alpha1s(ind1);
    alph2  = alpha2s(ind1);

    disp(' ')
    fprintf('alpha1: %8.4f, alpha2: %8.4f... (%i/%i)\n',alph1,alph2,ind1,alpha1n);
    
for ind2=1:f1n

    f1     = f1s(ind2);
    f2     = f2s(ind2);

    fprintf('f1: %8.4f, f2: %8.4f... (%i/%i)\n',f1,f2,ind2,f1n);
    
for ind3=1:varphin

    varphi = varphis(ind3);
    
    fprintf('varphi: %8.4f... (%i/%i)\n',varphi,ind3,varphin);

for ind4=1:Pibarn

    Pibar  = Pibars(ind4);
    fprintf('Pibar (annualized): %8.4f... (%i/%i)\n',Pibar^4,ind4,Pibarn);

    upper_Pibar = (1/bet/(1-min(alph1,alph2)))^(1/theta/(1-ppsi)/(1+varphi));
    if (ppsi<=1 && Pibar > upper_Pibar)
        continue;
    end
tic
    parfor ind5=1:phipin
%    for ind5=1:phipin

        phipi  = phipis(ind5);
        
        detchk0 = [];
        bnd0    = [];
        
    for ind6=1:phiyn

        gout    = struct('G1',[],'C',[],'impact',[],'gev',[],'eu',[]);

        phiy   = phiys(ind6);

        % alph1  = x(1);
        % alph2  = x(2);
        % f1     = x(3);
        % f2     = x(4);
        % Pibar  = x(5);
        % phipi  = x(6);
        % phiy   = x(7);
        % rhoi   = x(8);
        % phigy  = x(9);
        % varphi = x(10);
        % bet    = x(11);
        % theta  = x(12);
        % chi    = x(13);
        % sigm   = x(14);
        
        x = [   alph1;
                alph2;
                f1;
                f2;
                Pibar;
                phipi;
                phiy;
                0; % rhoi
                0; % phigy
                varphi;
                bet;
                theta;
                chi;
                sigm];
            
        gensysin = model_defn_J002(x);

        G1  = gensysin.G0\gensysin.G1;
        PSI = gensysin.G0\gensysin.Psi;
        PI  = gensysin.G0\gensysin.Pi;
        [gout.G1,gout.C,gout.impact,gout.gev,gout.eu] = rfsys(G1,gensysin.C0,PSI,PI,1 + 1e-8,true);

        if (gout.eu(1))
            
            detchk(ind5,ind6,ind1,ind2,ind3,ind4) = gout.eu(2);
            
            if (~isempty(detchk0))
                if (detchk0~=gout.eu(2))
                    bnd0 = [bnd0; phiy-0.5*phiyinc];
                    detchk0 = gout.eu(2);
                end
            else
                detchk0 = gout.eu(2);
            end
            
        else
            warning('Non existence!')
            fprintf('alpha1: %8.4f, alpha2: %8.4f, f1: %8.4f, f2: %8.4f, varphi: %8.4f, Pibar: %8.4f\n',alph1,alph2,f1,f2,varphi,Pibar)
            fprintf('phipi: %8.4f, phiy: %8.4f\n',phipi,phiy)
        end
        
    end
    
        bnds{ind5,ind1,ind2,ind3,ind4} = bnd0;
    
    end
toc    
end
end
end
end

detchk1 = detchk;
bnds1   = bnds;
phipis1 = phipis;
phiys1  = phiys;

%% positive trend inflation

Pibars  = [1.001; 1.03; 1.06].^(1/4);
Pibarn  = length(Pibars);

phipis  = 0:0.005:50;
phiyinc = 0.005; phiys   = 0:phiyinc:5; 

phipin  = length(phipis);
phiyn   = length(phiys);

% iteration

detchk = nan(phipin,phiyn,alpha1n,f1n,varphin,Pibarn);
bnds   = cell(phipin,alpha1n,f1n,varphin,Pibarn);

tic;

for ind1=1:alpha1n

    alph1  = alpha1s(ind1);
    alph2  = alpha2s(ind1);

    disp(' ')
    fprintf('alpha1: %8.4f, alpha2: %8.4f... (%i/%i)\n',alph1,alph2,ind1,alpha1n);
    
for ind2=1:f1n

    f1     = f1s(ind2);
    f2     = f2s(ind2);

    fprintf('f1: %8.4f, f2: %8.4f... (%i/%i)\n',f1,f2,ind2,f1n);
    
for ind3=1:varphin

    varphi = varphis(ind3);
    
    fprintf('varphi: %8.4f... (%i/%i)\n',varphi,ind3,varphin);

for ind4=1:Pibarn

    Pibar  = Pibars(ind4);
    fprintf('Pibar (annualized): %8.4f... (%i/%i)\n',Pibar^4,ind4,Pibarn);

    upper_Pibar = (1/bet/(1-min(alph1,alph2)))^(1/theta/(1-ppsi)/(1+varphi));
    if (ppsi<=1 && Pibar > upper_Pibar)
        continue;
    end

    parfor ind5=1:phipin

        phipi  = phipis(ind5);
        
        detchk0 = [];
        bnd0    = [];
        
    for ind6=1:phiyn

        gout    = struct('G1',[],'C',[],'impact',[],'gev',[],'eu',[]);

        phiy   = phiys(ind6);

        % alph1  = x(1);
        % alph2  = x(2);
        % f1     = x(3);
        % f2     = x(4);
        % Pibar  = x(5);
        % phipi  = x(6);
        % phiy   = x(7);
        % rhoi   = x(8);
        % phigy  = x(9);
        % varphi = x(10);
        % bet    = x(11);
        % theta  = x(12);
        % chi    = x(13);
        % sigm   = x(14);
        
        x = [   alph1;
                alph2;
                f1;
                f2;
                Pibar;
                phipi;
                phiy;
                0; % rhoi
                0; % phigy
                varphi;
                bet;
                theta;
                chi;
                sigm];
            
        gensysin = model_defn_J002(x);

        G1  = gensysin.G0\gensysin.G1;
        PSI = gensysin.G0\gensysin.Psi;
        PI  = gensysin.G0\gensysin.Pi;
        [gout.G1,gout.C,gout.impact,gout.gev,gout.eu] = rfsys(G1,gensysin.C0,PSI,PI,1 + 1e-8,true);

        if (gout.eu(1))
            
            detchk(ind5,ind6,ind1,ind2,ind3,ind4) = gout.eu(2);
            
            if (~isempty(detchk0))
                if (detchk0~=gout.eu(2))
                    bnd0 = [bnd0; phiy-0.5*phiyinc];
                    detchk0 = gout.eu(2);
                end
            else
                detchk0 = gout.eu(2);
            end
            
        else
            warning('Non existence!')
            fprintf('alpha1: %8.4f, alpha2: %8.4f, f1: %8.4f, f2: %8.4f, varphi: %8.4f, Pibar: %8.4f\n',alph1,alph2,f1,f2,varphi,Pibar)
            fprintf('phipi: %8.4f, phiy: %8.4f\n',phipi,phiy)
        end
        
    end
    
        bnds{ind5,ind1,ind2,ind3,ind4} = bnd0;
    
    end
    
end
end
end
end

detchk2 = detchk;
bnds2   = bnds;
phipis2 = phipis;
phiys2  = phiys;

save([filenm '.mat'],'detchk1','bnds1','phipis1','phiys1','detchk2','bnds2','phipis2','phiys2','-v7.3')

toc;

% graph 1

h1 = figure;

phipin = length(phipis1);

ys1 = [];
for indi=1:phipin
    tmp = bnds1{indi,1,1,1,1};
    ys1 = [ys1; [repmat(phipis1(indi),length(tmp),1) tmp]]; 
end
[ys1(:,2), sidx] = sort(ys1(:,2));
ys1(:,1) = ys1(sidx,1);

ys2 = [];
for indi=1:phipin
    tmp = bnds1{indi,2,1,1,1};
    ys2 = [ys2; [repmat(phipis1(indi),length(tmp),1) tmp]]; 
end
[ys2(:,2), sidx] = sort(ys2(:,2));
ys2(:,1) = ys2(sidx,1);

ys3 = [];
for indi=1:phipin
    tmp = bnds1{indi,3,1,1,1};
    ys3 = [ys3; [repmat(phipis1(indi),length(tmp),1) tmp]]; 
end
[ys3(:,2), sidx] = sort(ys3(:,2));
ys3(:,1) = ys3(sidx,1);

ys4 = [];
for indi=1:phipin
    tmp = bnds1{indi,4,1,1,1};
    ys4 = [ys4; [repmat(phipis1(indi),length(tmp),1) tmp]]; 
end
[ys4(:,2), sidx] = sort(ys4(:,2));
ys4(:,1) = ys4(sidx,1);

ys5 = [];
for indi=1:phipin
    tmp = bnds1{indi,5,1,1,1};
    ys5 = [ys5; [repmat(phipis1(indi),length(tmp),1) tmp]]; 
end
[ys5(:,2), sidx] = sort(ys5(:,2));
ys5(:,1) = ys5(sidx,1);

subplot(1,2,1)
plot(ys1(:,1),ys1(:,2),'LineWidth',3)
line(ys2(:,1),ys2(:,2),'LineWidth',1,'LineStyle','--','Color',[0.8500 0.3250 0.0980])
line(ys3(:,1),ys3(:,2),'LineWidth',1,'LineStyle',':','Color',[0.9290 0.6940 0.1250])
line(ys4(:,1),ys4(:,2),'LineWidth',1,'LineStyle','-.','Color',[0.4940 0.1840 0.5560])
line(ys5(:,1),ys5(:,2),'LineWidth',1,'LineStyle','-','Color',[0.4660 0.6740 0.1880])
xlim([0 2])
ylim([0 2])
title('(a) Varying price change frequencies','FontName','Times New Roman','FontSize',10)
xlabel('\phi_{\pi}')
ylabel('\phi_{y}')

legend({'$(\alpha_{1},\alpha_{2}) = (0.5,0.5)$',...
        '$\phantom{(\alpha_{1},\alpha_{2}) = }(0.4,0.6)$',...
        '$\phantom{(\alpha_{1},\alpha_{2}) = }(0.3,0.7)$',...
        '$\phantom{(\alpha_{1},\alpha_{2}) = }(0.2,0.8)$',...
        '$\phantom{(\alpha_{1},\alpha_{2}) = }(0.1,0.9)$'},'Interpreter','latex','Location','NorthEast','FontName','Times New Roman','FontSize',9)
legend('boxoff')

ys1 = [];
for indi=1:phipin
    tmp = bnds1{indi,3,3,1,1};
    ys1 = [ys1; [repmat(phipis1(indi),length(tmp),1) tmp]]; 
end
[ys1(:,2), sidx] = sort(ys1(:,2));
ys1(:,1) = ys1(sidx,1);

ys2 = [];
for indi=1:phipin
    tmp = bnds1{indi,3,2,1,1};
    ys2 = [ys2; [repmat(phipis1(indi),length(tmp),1) tmp]]; 
end
[ys2(:,2), sidx] = sort(ys2(:,2));
ys2(:,1) = ys2(sidx,1);

ys3 = [];
for indi=1:phipin
    tmp = bnds1{indi,3,1,1,1};
    ys3 = [ys3; [repmat(phipis1(indi),length(tmp),1) tmp]]; 
end
[ys3(:,2), sidx] = sort(ys3(:,2));
ys3(:,1) = ys3(sidx,1);

ys4 = [];
for indi=1:phipin
    tmp = bnds1{indi,3,4,1,1};
    ys4 = [ys4; [repmat(phipis1(indi),length(tmp),1) tmp]]; 
end
[ys4(:,2), sidx] = sort(ys4(:,2));
ys4(:,1) = ys4(sidx,1);

ys5 = [];
for indi=1:phipin
    tmp = bnds1{indi,3,5,1,1};
    ys5 = [ys5; [repmat(phipis1(indi),length(tmp),1) tmp]]; 
end
[ys5(:,2), sidx] = sort(ys5(:,2));
ys5(:,1) = ys5(sidx,1);

subplot(1,2,2)
plot(ys1(:,1),ys1(:,2),'LineWidth',3)
line(ys2(:,1),ys2(:,2),'LineWidth',1,'LineStyle','--','Color',[0.8500 0.3250 0.0980])
line(ys3(:,1),ys3(:,2),'LineWidth',1,'LineStyle',':','Color',[0.9290 0.6940 0.1250])
line(ys4(:,1),ys4(:,2),'LineWidth',1,'LineStyle','-.','Color',[0.4940 0.1840 0.5560])
line(ys5(:,1),ys5(:,2),'LineWidth',1,'LineStyle','-','Color',[0.4660 0.6740 0.1880])
xlim([0 2])
ylim([0 2])
title('(b) Varying sector sizes','FontName','Times New Roman','FontSize',10)
xlabel('\phi_{\pi}')
ylabel('\phi_{y}')

legend({'$(f_{1},f_{2}) = (0.1,0.9)$',...
        '$\phantom{(f_{1},f_{2}) = }(0.3,0.7)$',...
        '$\phantom{(f_{1},f_{2}) = }(0.5,0.5)$',...
        '$\phantom{(f_{1},f_{2}) = }(0.7,0.3)$',...
        '$\phantom{(f_{1},f_{2}) = }(0.9,0.1)$'},'Interpreter','latex','Location','NorthEast','FontName','Times New Roman','FontSize',9)
legend('boxoff')

h1.PaperSize = [21 29.7/4];
h1.PaperUnits = 'centimeters';
h1.PaperPosition = [0 0 1.5*21 1.5*29.7/4];

print 'graph_nokink_zero_trend_inflation_2s_boundary'.eps -depsc2