function gensysin = model_defn_J002(x)
% defines gensys input. 
% non-CES and positive trend inflation
%
% Input
%   x           : a vector of parameter values
%
% Output
%   gensysin    : a structure with the following fields
%                 G0, G1, Psi, Pi, C0
%                 which are standard gensys input.
% 

% The solution takes the form:  x(t) = G1 * x(t-1) + impact * e(t)
%                               y(t) = zmat * x(t) + C
%                               e(t) ~ N(0,SDX*SDX')

% endogenous variables

% -------------------------------------------------------------------------
%  variables
% -------------------------------------------------------------------------

y     = 1;
i     = 2;
p     = 3;
lam   = 4;
lam1  = 5;
lam2  = 6;
ps1   = 7;
ps2   = 8;
s1    = 9;
s2    = 10;
z11   = 11;
z21   = 12;
z31   = 13;
z41   = 14;
z12   = 15;
z22   = 16;
z32   = 17;
z42   = 18;

NY    = 18;

% -------------------------------------------------------------------------
% innovations
% -------------------------------------------------------------------------

% none
NX   = 0;

% -------------------------------------------------------------------------
% expectational errors
% -------------------------------------------------------------------------

NETA = 9;

% -------------------------------------------------------------------------
% parameters
% -------------------------------------------------------------------------

alph1  = x(1);
alph2  = x(2);
f1     = x(3);
f2     = x(4);
Pibar  = x(5);
phipi  = x(6);
phiy   = x(7);
rhoi   = x(8);
phigy  = x(9);
varphi = x(10);
bet    = x(11);
theta  = x(12);
chi    = x(13);
sigm   = x(14);
ppsi   = x(15);
PsP1   = x(16);
PsP2   = x(17);
Ybar   = x(18);

% -------------------------------------------------------------------------
% fixed parameters and functions of parameters
% -------------------------------------------------------------------------

%g1   = (1-(1-alph1)*Pibar^(theta-1))*(1-bet*(1-alph1)*Pibar^(theta*(1+varphi)))/((1-alph1)*Pibar^(theta-1));
%g2   = (1-(1-alph2)*Pibar^(theta-1))*(1-bet*(1-alph2)*Pibar^(theta*(1+varphi)))/((1-alph2)*Pibar^(theta-1));
%omg  = (sigm+varphi)/(1+theta*varphi);

Lam1powered   = alph1/(1-(1-alph1)*Pibar^(theta*(1-ppsi)-1))*PsP1^(1-theta*(1-ppsi));
%Lam1bar       = Lam1powered^(1/(1-theta*(1-ppsi)));
Lam2powered   = alph2/(1-(1-alph2)*Pibar^(theta*(1-ppsi)-1))*PsP2^(1-theta*(1-ppsi));
%Lam2bar       = Lam2powered^(1/(1-theta*(1-ppsi)));
Lampowered    = f1*Lam1powered + f2*Lam2powered;
Lambar        = Lampowered^(1/(1-theta*(1-ppsi)));

S1bar         = alph1/(1-(1-alph1)/Pibar)*PsP1;
S2bar         = alph2/(1-(1-alph2)/Pibar)*PsP2;
%Sbar          = f1*S1bar + f2*S2bar;

Z11bar        = Lambar^(theta*(1-ppsi))*Ybar^(1-sigm)/(1-bet*(1-alph1)*Pibar^(theta*(1-ppsi)-1));
Z21bar        = Ybar^(1-sigm)/(1-bet*(1-alph1)/Pibar);
Z31bar        = Lambar^(2*theta*(1-ppsi))*Ybar^2/(1-bet*(1-alph1)*Pibar^(2*theta*(1-ppsi)));
Z41bar        = Lambar^(theta*(1-ppsi))*Ybar^2/(1-bet*(1-alph1)*Pibar^(theta*(1-ppsi)));

Z12bar        = Lambar^(theta*(1-ppsi))*Ybar^(1-sigm)/(1-bet*(1-alph2)*Pibar^(theta*(1-ppsi)-1));
Z22bar        = Ybar^(1-sigm)/(1-bet*(1-alph2)/Pibar);
Z32bar        = Lambar^(2*theta*(1-ppsi))*Ybar^2/(1-bet*(1-alph2)*Pibar^(2*theta*(1-ppsi)));
Z42bar        = Lambar^(theta*(1-ppsi))*Ybar^2/(1-bet*(1-alph2)*Pibar^(theta*(1-ppsi)));

% -------------------------------------------------------------------------
% System Matrices 
% -------------------------------------------------------------------------

GAM0    = zeros(NY,NY) ;
GAM1    = zeros(NY,NY) ;
PSI     = zeros(NY,NX) ;
PPI     = zeros(NY,NETA) ;
C       = zeros(NY,1) ;

% eq1: consumption Euler equation

GAM0(1,y) = -1;
GAM0(1,p) = -1/sigm;

GAM1(1,y) = -1;
GAM1(1,i) = -1/sigm;

PPI(1,1)  = 1;

% eq2: evolution of the aggregate price level

GAM0(2,lam)  = 1;
GAM0(2,lam1) = -f1*(Lam1powered/Lampowered);
GAM0(2,lam2) = -f2*(Lam2powered/Lampowered);

% eq3: evolution of the sectoral price level 1

GAM0(3,lam1) = 1;
GAM0(3,p)    = (1-alph1)*Pibar^(theta*(1-ppsi)-1);
GAM0(3,ps1)  = -(1-(1-alph1)*Pibar^(theta*(1-ppsi)-1));

GAM1(3,lam1) = (1-alph1)*Pibar^(theta*(1-ppsi)-1);

% eq4: evolution of the sectoral price level 2

GAM0(4,lam2) = 1;
GAM0(4,p)    = (1-alph2)*Pibar^(theta*(1-ppsi)-1);
GAM0(4,ps2)  = -(1-(1-alph2)*Pibar^(theta*(1-ppsi)-1));

GAM1(4,lam2) = (1-alph2)*Pibar^(theta*(1-ppsi)-1);

% eq5: price dispersion - aggregate price level

GAM0(5,lam)  = 1;
GAM0(5,s1)   = -ppsi*f1*S1bar/Lambar;
GAM0(5,s2)   = -ppsi*f2*S2bar/Lambar;

% eq6: sectoral price dispersion 1

GAM0(6,s1)   = 1;
GAM0(6,p)    = (1-alph1)/Pibar;
GAM0(6,ps1)  = -(1-(1-alph1)/Pibar);

GAM1(6,s1)   = (1-alph1)/Pibar;

% eq7: sectoral price dispersion 2

GAM0(7,s2)   = 1;
GAM0(7,p)    = (1-alph2)/Pibar;
GAM0(7,ps2)  = -(1-(1-alph2)/Pibar);

GAM1(7,s2)   = (1-alph2)/Pibar;

% eq8: z11

GAM0(8,z11)  = -bet*(1-alph1)*Pibar^(theta*(1-ppsi)-1);
GAM0(8,p)    = -bet*(1-alph1)*Pibar^(theta*(1-ppsi)-1)*(theta*(1-ppsi)-1);

GAM1(8,z11)  = -1;
GAM1(8,lam)  = (1-bet*(1-alph1)*Pibar^(theta*(1-ppsi)-1))*theta*(1-ppsi);
GAM1(8,y)    = (1-bet*(1-alph1)*Pibar^(theta*(1-ppsi)-1))*(1-sigm);

PPI(8,2)  = 1;

% eq9: z21

GAM0(9,z21)  = -bet*(1-alph1)/Pibar;
GAM0(9,p)    = bet*(1-alph1)/Pibar;

GAM1(9,z21)  = -1;
GAM1(9,y)    = (1-bet*(1-alph1)/Pibar)*(1-sigm);

PPI(9,3)  = 1;

% eq10: z31

GAM0(10,z31) = -bet*(1-alph1)*Pibar^(2*theta*(1-ppsi));
GAM0(10,p)   = -bet*(1-alph1)*Pibar^(2*theta*(1-ppsi))*2*theta*(1-ppsi);

GAM1(10,z31) = -1;
GAM1(10,lam) = (1-bet*(1-alph1)*Pibar^(2*theta*(1-ppsi)))*2*theta*(1-ppsi);
GAM1(10,y)   = (1-bet*(1-alph1)*Pibar^(2*theta*(1-ppsi)))*2;

PPI(10,4)  = 1;

% eq11: z41

GAM0(11,z41) = -bet*(1-alph1)*Pibar^(theta*(1-ppsi));
GAM0(11,p)   = -bet*(1-alph1)*Pibar^(theta*(1-ppsi))*theta*(1-ppsi);

GAM1(11,z41) = -1;
GAM1(11,lam) = (1-bet*(1-alph1)*Pibar^(theta*(1-ppsi)))*theta*(1-ppsi);
GAM1(11,y)   = (1-bet*(1-alph1)*Pibar^(theta*(1-ppsi)))*2;

PPI(11,5)  = 1;

% eq12: FOC 1

GAM0(12,z11) = (theta*(1-ppsi)-1)*Z11bar*PsP1;
GAM0(12,z21) = ppsi*Z21bar*PsP1^(theta*(1-ppsi)+1);
GAM0(12,z31) = -theta*chi*Z31bar*PsP1^(-theta*(1-ppsi));
GAM0(12,z41) = theta*chi*ppsi*Z41bar;

GAM0(12,ps1) = GAM0(12,z11) + GAM0(12,z21)*(theta*(1-ppsi)+1) - GAM0(12,z31)*theta*(1-ppsi);

% eq13: z12

GAM0(13,z12)  = -bet*(1-alph2)*Pibar^(theta*(1-ppsi)-1);
GAM0(13,p)    = -bet*(1-alph2)*Pibar^(theta*(1-ppsi)-1)*(theta*(1-ppsi)-1);

GAM1(13,z12)  = -1;
GAM1(13,lam)  = (1-bet*(1-alph2)*Pibar^(theta*(1-ppsi)-1))*theta*(1-ppsi);
GAM1(13,y)    = (1-bet*(1-alph2)*Pibar^(theta*(1-ppsi)-1))*(1-sigm);

PPI(13,6)  = 1;

% eq14: z22

GAM0(14,z22)  = -bet*(1-alph2)/Pibar;
GAM0(14,p)    = bet*(1-alph2)/Pibar;

GAM1(14,z22)  = -1;
GAM1(14,y)    = (1-bet*(1-alph2)/Pibar)*(1-sigm);

PPI(14,7)  = 1;

% eq15: z32

GAM0(15,z32) = -bet*(1-alph2)*Pibar^(2*theta*(1-ppsi));
GAM0(15,p)   = -bet*(1-alph2)*Pibar^(2*theta*(1-ppsi))*2*theta*(1-ppsi);

GAM1(15,z32) = -1;
GAM1(15,lam) = (1-bet*(1-alph2)*Pibar^(2*theta*(1-ppsi)))*2*theta*(1-ppsi);
GAM1(15,y)   = (1-bet*(1-alph2)*Pibar^(2*theta*(1-ppsi)))*2;

PPI(15,8)  = 1;

% eq16: z42

GAM0(16,z42) = -bet*(1-alph2)*Pibar^(theta*(1-ppsi));
GAM0(16,p)   = -bet*(1-alph2)*Pibar^(theta*(1-ppsi))*theta*(1-ppsi);

GAM1(16,z42) = -1;
GAM1(16,lam) = (1-bet*(1-alph2)*Pibar^(theta*(1-ppsi)))*theta*(1-ppsi);
GAM1(16,y)   = (1-bet*(1-alph2)*Pibar^(theta*(1-ppsi)))*2;

PPI(16,9)  = 1;

% eq17: FOC 2

GAM0(17,z12) = (theta*(1-ppsi)-1)*Z12bar*PsP1;
GAM0(17,z22) = ppsi*Z22bar*PsP2^(theta*(1-ppsi)+1);
GAM0(17,z32) = -theta*chi*Z32bar*PsP2^(-theta*(1-ppsi));
GAM0(17,z42) = theta*chi*ppsi*Z42bar;

GAM0(17,ps2) = GAM0(17,z12) + GAM0(17,z22)*(theta*(1-ppsi)+1) - GAM0(17,z32)*theta*(1-ppsi);

% eq18: monetary policy

GAM0(18,i)     = 1;
GAM0(18,p)     = -(1-rhoi)*phipi;
GAM0(18,y)     = -(1-rhoi)*(phiy+phigy);

GAM1(18,i)     = rhoi;
GAM1(18,y)     = -(1-rhoi)*phigy;

%% return
gensysin = struct('G0',GAM0,'G1',GAM1,'Psi',PSI,'Pi',PPI,'C0',C);