% steady states for the 2-sector NK model, CES, trend inflation
% WYP, November 2020

clear;
clc;

% parameters

alpha1s = [0.5; 0.4; 0.3; 0.2; 0.1];
alpha2s = [0.5; 0.6; 0.7; 0.8; 0.9];

f1s     = [0.5; 0.3; 0.1; 0.7; 0.9];
f2s     = [0.5; 0.7; 0.9; 0.3; 0.1];

varphis = [0.5; 1; 3];

Pibars  = [1:0.001:1.06].^(1/4);

alpha1n = length(alpha1s);
f1n     = length(f1s);
varphin = length(varphis);
Pibarn  = length(Pibars);

theta = 10;
bet   = 0.99;
chi   = 8;
sigm  = 1;

% initialize

Ybars   = nan(alpha1n,f1n,varphin,Pibarn);
Hbars   = nan(alpha1n,f1n,varphin,Pibarn);
Ps1s    = nan(alpha1n,f1n,varphin,Pibarn);
Ps2s    = nan(alpha1n,f1n,varphin,Pibarn);
PRP1s   = nan(alpha1n,f1n,varphin,Pibarn);
PRP2s   = nan(alpha1n,f1n,varphin,Pibarn);
D1s     = nan(alpha1n,f1n,varphin,Pibarn);
D2s     = nan(alpha1n,f1n,varphin,Pibarn);
Ds      = nan(alpha1n,f1n,varphin,Pibarn);
MC1s    = nan(alpha1n,f1n,varphin,Pibarn);
MC2s    = nan(alpha1n,f1n,varphin,Pibarn);
MCs     = nan(alpha1n,f1n,varphin,Pibarn);
MKUPs   = nan(alpha1n,f1n,varphin,Pibarn);
LRSLPs  = nan(alpha1n,f1n,varphin,Pibarn);
LRSLPCFs = nan(alpha1n,varphin,Pibarn);
Psk1    = nan(201,2,alpha1n,f1n,varphin,Pibarn);
Psk2    = nan(201,2,alpha1n,f1n,varphin,Pibarn);
Ysk1    = nan(201,alpha1n,f1n,varphin,Pibarn);
Ysk2    = nan(201,alpha1n,f1n,varphin,Pibarn);

% compute

for ind1=1:alpha1n
for ind4=1:f1n
for ind2=1:varphin
for ind3=1:Pibarn

    alph1 = alpha1s(ind1);
    alph2 = alpha2s(ind1);
    f1    = f1s(ind4);
    f2    = f2s(ind4);
    Pibar = Pibars(ind3);
    varphi = varphis(ind2);

    Pibarbnd = (1/bet/(1-min(alph1,alph2)))^(1/theta/(1+varphi));
    if (Pibar > Pibarbnd)
        continue
    end

    Ybar =        f1*alph1/(1-(1-alph1)*Pibar^(theta-1))*((1-bet*(1-alph1)*Pibar^(theta-1))/(1-bet*(1-alph1)*Pibar^(theta*(1+varphi))))^((1-theta)/(1+theta*varphi));
    Ybar = Ybar + f2*alph2/(1-(1-alph2)*Pibar^(theta-1))*((1-bet*(1-alph2)*Pibar^(theta-1))/(1-bet*(1-alph2)*Pibar^(theta*(1+varphi))))^((1-theta)/(1+theta*varphi));
    Ybar = (theta*chi/(theta-1))^(-1/(sigm+varphi))*Ybar^((1+theta*varphi)/((sigm+varphi)*(theta-1)));

    Z11  = Ybar^(1-sigm)/(1-bet*(1-alph1)*Pibar^(theta-1));
    Z31  = Ybar^(1+varphi)/(1-bet*(1-alph1)*Pibar^(theta*(1+varphi)));

    Z12  = Ybar^(1-sigm)/(1-bet*(1-alph2)*Pibar^(theta-1));
    Z32  = Ybar^(1+varphi)/(1-bet*(1-alph2)*Pibar^(theta*(1+varphi)));

    Ps1  = (theta*chi/(theta-1)*Z31/Z11)^(1/(1+theta*varphi));
    Ps2  = (theta*chi/(theta-1)*Z32/Z12)^(1/(1+theta*varphi));

    PRP1 = (alph1/(1-(1-alph1)*Pibar^(theta-1)))^(1/(1-theta))*Ps1;
    PRP2 = (alph2/(1-(1-alph2)*Pibar^(theta-1)))^(1/(1-theta))*Ps2;

    D1   = alph1/(1-(1-alph1)*Pibar^theta)*Ps1^(-theta);
    D2   = alph2/(1-(1-alph2)*Pibar^theta)*Ps2^(-theta);
    D    = f1*D1 + f2*D2;

    g1   = (1-(1-alph1)*Pibar^(theta-1))*(1-bet*(1-alph1)*Pibar^(theta*(1+varphi)))/((1-alph1)*Pibar^(theta-1));
    g2   = (1-(1-alph2)*Pibar^(theta-1))*(1-bet*(1-alph2)*Pibar^(theta*(1+varphi)))/((1-alph2)*Pibar^(theta-1));
    omg  = (sigm+varphi)/(1+theta*varphi);
    LRSLP =         f1*PRP1^(1-theta)/g1*((1-bet*(1-alph1)*Pibar^(theta*(1+varphi))) + bet/(1+theta*varphi)*(1-(1-alph1)*Pibar^(theta-1))*((theta-1)-theta*(1+varphi)*Pibar^(1+theta*varphi)+(1+theta*varphi)*bet*(1-alph1)*Pibar^(theta*(1+varphi)))/(1-bet*(1-alph1)*Pibar^(theta-1)));
    LRSLP = LRSLP + f2*PRP2^(1-theta)/g2*((1-bet*(1-alph2)*Pibar^(theta*(1+varphi))) + bet/(1+theta*varphi)*(1-(1-alph2)*Pibar^(theta-1))*((theta-1)-theta*(1+varphi)*Pibar^(1+theta*varphi)+(1+theta*varphi)*bet*(1-alph2)*Pibar^(theta*(1+varphi)))/(1-bet*(1-alph2)*Pibar^(theta-1)));
    LRSLP = LRSLP/omg;

    LRSLPCF = 1 - bet*Pibar^(1+theta*varphi);
    LRSLPCF = LRSLPCF - f1*PRP1^(1-theta)*bet*(Pibar^(1+theta*varphi)-1)*(1-(1-alph1)*Pibar^(theta-1))/(1-bet*(1-alph1)*Pibar^(theta-1));
    LRSLPCF = LRSLPCF - f2*PRP2^(1-theta)*bet*(Pibar^(1+theta*varphi)-1)*(1-(1-alph2)*Pibar^(theta-1))/(1-bet*(1-alph2)*Pibar^(theta-1));
    LRSLPCF = LRSLPCF/omg/(f1*PRP1^(1-theta)*g1+f2*PRP2^(1-theta)*g2);
    
    for indk=0:200
        Psk1(indk+1,1,ind1,ind4,ind2,ind3) = Ps1/(Pibar^indk);
        Psk1(indk+1,2,ind1,ind4,ind2,ind3) = alph1*(1-alph1)^indk*f1;
        Ysk1(indk+1,ind1,ind4,ind2,ind3)   = (Ps1/(Pibar^indk))^(-theta)*Ybar;
        Psk2(indk+1,1,ind1,ind4,ind2,ind3) = Ps2/(Pibar^indk);
        Psk2(indk+1,2,ind1,ind4,ind2,ind3) = alph2*(1-alph2)^indk*f2;
        Ysk2(indk+1,ind1,ind4,ind2,ind3)   = (Ps2/(Pibar^indk))^(-theta)*Ybar; 
    end
    
    MC1  = chi*alph1/(1-(1-alph1)*Pibar^(theta*varphi))*(Ps1)^(-theta*varphi)*Ybar^(sigm+varphi);
    MC2  = chi*alph2/(1-(1-alph2)*Pibar^(theta*varphi))*(Ps2)^(-theta*varphi)*Ybar^(sigm+varphi);
    MC   = f1*MC1 + f2*MC2;

    MKUP = 1/MC;

    H1   = alph1/(1-(1-alph1)*Pibar^theta)*(Ps1)^(-theta)*Ybar;
    H2   = alph2/(1-(1-alph2)*Pibar^theta)*(Ps2)^(-theta)*Ybar;
    Hbar = f1*H1 + f2*H2;

    Ybars(ind1,ind4,ind2,ind3)   = Ybar;
    Hbars(ind1,ind4,ind2,ind3)   = Hbar;
    Ps1s(ind1,ind4,ind2,ind3)    = Ps1;
    Ps2s(ind1,ind4,ind2,ind3)    = Ps2;
    PRP1s(ind1,ind4,ind2,ind3)   = PRP1;
    PRP2s(ind1,ind4,ind2,ind3)   = PRP2;
    D1s(ind1,ind4,ind2,ind3)     = D1;
    D2s(ind1,ind4,ind2,ind3)     = D2;
    Ds(ind1,ind4,ind2,ind3)      = D;
    MC1s(ind1,ind4,ind2,ind3)    = MC1;
    MC2s(ind1,ind4,ind2,ind3)    = MC2;
    MCs(ind1,ind4,ind2,ind3)     = MC;
    MKUPs(ind1,ind4,ind2,ind3)   = MKUP;
    LRSLPs(ind1,ind4,ind2,ind3)  = LRSLP;
    LRSLPCFs(ind1,ind4,ind2,ind3) = LRSLPCF;

end
end
end
end

save('LRSLPs.mat','LRSLPs','LRSLPCFs','alpha1s','alpha2s','f1s','f2s','varphis','Pibars','Psk1','Ysk1','Psk2','Ysk2');

%% Report labor supply in SS

fprintf('SS labor supply: %8.4f\n',Hbars(1,1,2,1))
fprintf('when alpha1: %8.4f\n',alpha1s(1))
fprintf('     alpha2: %8.4f\n',1-alpha1s(1))
fprintf('     f1    : %8.4f\n',f1s(1))
fprintf('     f2    : %8.4f\n',f2s(1))
fprintf('     varphi: %8.4f\n',varphis(2))
fprintf('     Pibar:  %8.4f\n',Pibars(1))

%% figures

h1=figure;

% output

xs  = (Pibars.^4-1)*100;
ys1 = Ybars(1,1,2,:);
ys2 = Ybars(2,1,2,:);
ys3 = Ybars(3,1,2,:);
ys4 = Ybars(4,1,2,:);
ys5 = Ybars(5,1,2,:);

subplot(2,4,1)
plot(xs,ys1(:),'LineWidth',3)
line(xs,ys2(:),'LineWidth',1,'LineStyle','--','Color',[0.8500 0.3250 0.0980])
line(xs,ys3(:),'LineWidth',1,'LineStyle',':','Color',[0.9290 0.6940 0.1250])
line(xs,ys4(:),'LineWidth',1,'LineStyle','-.','Color',[0.4940 0.1840 0.5560])
line(xs,ys5(:),'LineWidth',1,'LineStyle','-','Color',[0.4660 0.6740 0.1880])
xlim([min(xs) max(xs)])
%ylim([0 1])
title('(a-1) Output','FontName','Times New Roman','FontSize',10)
xlabel('Trend inflation','FontName','Times New Roman','FontSize',10)

% distortion factor

xs  = (Pibars.^4-1)*100;
ys1 = Ds(1,1,2,:);
ys2 = Ds(2,1,2,:);
ys3 = Ds(3,1,2,:);
ys4 = Ds(4,1,2,:);
ys5 = Ds(5,1,2,:);

subplot(2,4,2)
plot(xs,ys1(:),'LineWidth',3)
line(xs,ys2(:),'LineWidth',1,'LineStyle','--','Color',[0.8500 0.3250 0.0980])
line(xs,ys3(:),'LineWidth',1,'LineStyle',':','Color',[0.9290 0.6940 0.1250])
line(xs,ys4(:),'LineWidth',1,'LineStyle','-.','Color',[0.4940 0.1840 0.5560])
line(xs,ys5(:),'LineWidth',1,'LineStyle','-','Color',[0.4660 0.6740 0.1880])
xlim([min(xs) max(xs)])
%ylim([0 1])
title('(a-2) Distortion factor','FontName','Times New Roman','FontSize',10)

% average markup

xs  = (Pibars.^4-1)*100;
ys1 = MKUPs(1,1,2,:);
ys2 = MKUPs(2,1,2,:);
ys3 = MKUPs(3,1,2,:);
ys4 = MKUPs(4,1,2,:);
ys5 = MKUPs(5,1,2,:);

subplot(2,4,3)
plot(xs,ys1(:),'LineWidth',3)
line(xs,ys2(:),'LineWidth',1,'LineStyle','--','Color',[0.8500 0.3250 0.0980])
line(xs,ys3(:),'LineWidth',1,'LineStyle',':','Color',[0.9290 0.6940 0.1250])
line(xs,ys4(:),'LineWidth',1,'LineStyle','-.','Color',[0.4940 0.1840 0.5560])
line(xs,ys5(:),'LineWidth',1,'LineStyle','-','Color',[0.4660 0.6740 0.1880])
xlim([min(xs) max(xs)])
%ylim([0 1])
title('(a-3) Average markups','FontName','Times New Roman','FontSize',10)

% Slope of LR NKPC

xs  = (Pibars.^4-1)*100;
ys1 = LRSLPs(1,1,2,:);
ys2 = LRSLPs(2,1,2,:);
ys3 = LRSLPs(3,1,2,:);
ys4 = LRSLPs(4,1,2,:);
ys5 = LRSLPs(5,1,2,:);

subplot(2,4,4)
plot(xs,ys1(:),'LineWidth',3)
line(xs,ys2(:),'LineWidth',1,'LineStyle','--','Color',[0.8500 0.3250 0.0980])
line(xs,ys3(:),'LineWidth',1,'LineStyle',':','Color',[0.9290 0.6940 0.1250])
line(xs,ys4(:),'LineWidth',1,'LineStyle','-.','Color',[0.4940 0.1840 0.5560])
line(xs,ys5(:),'LineWidth',1,'LineStyle','-','Color',[0.4660 0.6740 0.1880])
xlim([min(xs) max(xs)])
ylim([-500 1])
title('(a-4) LR trade-off','FontName','Times New Roman','FontSize',10)

% output (zoomed in)

xs  = (Pibars.^4-1)*100;
ys1 = Ybars(1,1,2,:);
ys2 = Ybars(2,1,2,:);
ys3 = Ybars(3,1,2,:);
ys4 = Ybars(4,1,2,:);
ys5 = Ybars(5,1,2,:);

subplot(2,4,5)
plot(xs,ys1(:),'LineWidth',3)
line(xs,ys2(:),'LineWidth',1,'LineStyle','--','Color',[0.8500 0.3250 0.0980])
line(xs,ys3(:),'LineWidth',1,'LineStyle',':','Color',[0.9290 0.6940 0.1250])
line(xs,ys4(:),'LineWidth',1,'LineStyle','-.','Color',[0.4940 0.1840 0.5560])
line(xs,ys5(:),'LineWidth',1,'LineStyle','-','Color',[0.4660 0.6740 0.1880])
xlim([0 1])
ylim([0.3352 0.3358])
xlabel('Trend inflation','FontName','Times New Roman','FontSize',10)
title('(b-1) Output (zoomed in)','FontName','Times New Roman','FontSize',10)

% distortion factor (zoomed in)

xs  = (Pibars.^4-1)*100;
ys1 = Ds(1,1,2,:);
ys2 = Ds(2,1,2,:);
ys3 = Ds(3,1,2,:);
ys4 = Ds(4,1,2,:);
ys5 = Ds(5,1,2,:);

subplot(2,4,6)
plot(xs,ys1(:),'LineWidth',3)
line(xs,ys2(:),'LineWidth',1,'LineStyle','--','Color',[0.8500 0.3250 0.0980])
line(xs,ys3(:),'LineWidth',1,'LineStyle',':','Color',[0.9290 0.6940 0.1250])
line(xs,ys4(:),'LineWidth',1,'LineStyle','-.','Color',[0.4940 0.1840 0.5560])
line(xs,ys5(:),'LineWidth',1,'LineStyle','-','Color',[0.4660 0.6740 0.1880])
xlim([0 1])
ylim([0.9998 1.0002])
title('(b-2) Distortion factor (zoomed in)','FontName','Times New Roman','FontSize',10)

% average markup (zoomed in)

xs  = (Pibars.^4-1)*100;
ys1 = MKUPs(1,1,2,:);
ys2 = MKUPs(2,1,2,:);
ys3 = MKUPs(3,1,2,:);
ys4 = MKUPs(4,1,2,:);
ys5 = MKUPs(5,1,2,:);

subplot(2,4,7)
plot(xs,ys1(:),'LineWidth',3)
line(xs,ys2(:),'LineWidth',1,'LineStyle','--','Color',[0.8500 0.3250 0.0980])
line(xs,ys3(:),'LineWidth',1,'LineStyle',':','Color',[0.9290 0.6940 0.1250])
line(xs,ys4(:),'LineWidth',1,'LineStyle','-.','Color',[0.4940 0.1840 0.5560])
line(xs,ys5(:),'LineWidth',1,'LineStyle','-','Color',[0.4660 0.6740 0.1880])
xlim([0 1])
ylim([1.1095 1.112])
title('(b-3) Average markups (zoomed in)','FontName','Times New Roman','FontSize',10)

% Slope of LR NKPC (zoomed in)

xs  = (Pibars.^4-1)*100;
ys1 = LRSLPs(1,1,2,:);
ys2 = LRSLPs(2,1,2,:);
ys3 = LRSLPs(3,1,2,:);
ys4 = LRSLPs(4,1,2,:);
ys5 = LRSLPs(5,1,2,:);

subplot(2,4,8)
plot(xs,ys1(:),'LineWidth',3)
line(xs,ys2(:),'LineWidth',1,'LineStyle','--','Color',[0.8500 0.3250 0.0980])
line(xs,ys3(:),'LineWidth',1,'LineStyle',':','Color',[0.9290 0.6940 0.1250])
line(xs,ys4(:),'LineWidth',1,'LineStyle','-.','Color',[0.4940 0.1840 0.5560])
line(xs,ys5(:),'LineWidth',1,'LineStyle','-','Color',[0.4660 0.6740 0.1880])
line(xs,0*xs,'LineWidth',0.5,'LineStyle','-','Color',[0.1 0.1 0.1])
xlim([0 1])
ylim([-3 3])
title('(b-4) LR trade-off (zoomed in)','FontName','Times New Roman','FontSize',10)

legend({'$(\alpha_{1},\alpha_{2}) = (0.5,0.5)$',...
        '$\phantom{(\alpha_{1},\alpha_{2}) = }(0.4,0.6)$',...
        '$\phantom{(\alpha_{1},\alpha_{2}) = }(0.3,0.7)$',...
        '$\phantom{(\alpha_{1},\alpha_{2}) = }(0.2,0.1)$',...
        '$\phantom{(\alpha_{1},\alpha_{2}) = }(0.1,0.9)$'},'Interpreter','latex','Location','NorthEast','FontName','Times New Roman','FontSize',10)
legend('boxoff')
    
h1.PaperSize = [21 29.7/2];
h1.PaperUnits = 'centimeters';
h1.PaperPosition = [0 0 1.5*21 1.5*29.7/2];

print graph_nokink_2s_SS.eps -depsc2

%% figures

h1=figure;

% output (zoomed in)

xs  = (Pibars.^4-1)*100;
ys1 = Ybars(1,1,2,:);
ys2 = Ybars(2,1,2,:);
ys3 = Ybars(3,1,2,:);
ys4 = Ybars(4,1,2,:);
ys5 = Ybars(5,1,2,:);

subplot(1,3,1)
plot(xs,ys1(:),'LineWidth',3)
line(xs,ys2(:),'LineWidth',1,'LineStyle','--','Color',[0.8500 0.3250 0.0980])
line(xs,ys3(:),'LineWidth',1,'LineStyle',':','Color',[0.9290 0.6940 0.1250])
line(xs,ys4(:),'LineWidth',1,'LineStyle','-.','Color',[0.4940 0.1840 0.5560])
line(xs,ys5(:),'LineWidth',1,'LineStyle','-','Color',[0.4660 0.6740 0.1880])
xlim([0 1])
ylim([0.3352 0.3358])
xlabel('Trend inflation','FontName','Times New Roman','FontSize',12)
title({'(a) Output',''},'FontName','Times New Roman','FontSize',12)

% Slope of LR NKPC (zoomed in)

xs  = (Pibars.^4-1)*100;
ys1 = LRSLPs(1,1,2,:);
ys2 = LRSLPs(2,1,2,:);
ys3 = LRSLPs(3,1,2,:);
ys4 = LRSLPs(4,1,2,:);
ys5 = LRSLPs(5,1,2,:);

subplot(1,3,2)
plot(xs,ys1(:),'LineWidth',3)
line(xs,ys2(:),'LineWidth',1,'LineStyle','--','Color',[0.8500 0.3250 0.0980])
line(xs,ys3(:),'LineWidth',1,'LineStyle',':','Color',[0.9290 0.6940 0.1250])
line(xs,ys4(:),'LineWidth',1,'LineStyle','-.','Color',[0.4940 0.1840 0.5560])
line(xs,ys5(:),'LineWidth',1,'LineStyle','-','Color',[0.4660 0.6740 0.1880])
line(xs,0*xs,'LineWidth',0.5,'LineStyle','-','Color',[0.1 0.1 0.1])
xlim([0 1])
ylim([-3 3])
xlabel('Trend inflation','FontName','Times New Roman','FontSize',12)
title({'(b) LR trade-off',''},'FontName','Times New Roman','FontSize',12)

legend({'$(\alpha_{1},\alpha_{2}) = (0.5,0.5)$',...
        '$\phantom{(\alpha_{1},\alpha_{2}) = }(0.4,0.6)$',...
        '$\phantom{(\alpha_{1},\alpha_{2}) = }(0.3,0.7)$',...
        '$\phantom{(\alpha_{1},\alpha_{2}) = }(0.2,0.1)$',...
        '$\phantom{(\alpha_{1},\alpha_{2}) = }(0.1,0.9)$'},'Interpreter','latex','Location','NorthEast','FontName','Times New Roman','FontSize',11)
legend('boxoff')

% Slope of LR NKPC

xs  = (Pibars.^4-1)*100;
ys1 = LRSLPCFs(1,1,2,:);
ys2 = LRSLPCFs(2,1,2,:);
ys3 = LRSLPCFs(3,1,2,:);
ys4 = LRSLPCFs(4,1,2,:);
ys5 = LRSLPCFs(5,1,2,:);

subplot(1,3,3)
plot(xs,ys1(:),'LineWidth',3)
line(xs,ys2(:),'LineWidth',1,'LineStyle','--','Color',[0.8500 0.3250 0.0980])
line(xs,ys3(:),'LineWidth',1,'LineStyle',':','Color',[0.9290 0.6940 0.1250])
line(xs,ys4(:),'LineWidth',1,'LineStyle','-.','Color',[0.4940 0.1840 0.5560])
line(xs,ys5(:),'LineWidth',1,'LineStyle','-','Color',[0.4660 0.6740 0.1880])
line(xs,0*xs,'LineWidth',0.5,'LineStyle','-','Color',[0.1 0.1 0.1])
xlim([0 1])
ylim([-3 3])
xlabel('Trend inflation','FontName','Times New Roman','FontSize',12)
title({'(c) LR trade-off',' with the sectoral prices shut down'},'FontName','Times New Roman','FontSize',12)
    
h1.PaperSize = [21 29.7/4];
h1.PaperUnits = 'centimeters';
h1.PaperPosition = [0 0 1.5*21 1.5*29.7/4];

print graph_nokink_2s_SS_outputslope.eps -depsc2