% steady states for the 2-sector NK model, non-CES, trend inflation
% WYP, July 2020

clear;
clc

options = optimoptions('fsolve','FunctionTolerance',1e-12,'OptimalityTolerance',1e-12);

syms Sy Si Sp Slam Sps1 Ss1 Slam1 Sz11 Sz21 Sz31 Sz41 Sps2 Ss2 Slam2 Sz12 Sz22 Sz32 Sz42 Sa;

% parameters

alpha1s = [0.5; 0.4; 0.3; 0.2; 0.1];
alpha2s = [0.5; 0.6; 0.7; 0.8; 0.9];

f1s     = [0.5; 0.3; 0.7];
f2s     = [0.5; 0.7; 0.3];

varphis = 1;

Pibars  = [1:0.001:1.061].^(1/4);

ppsis   = [0; 0.6; 1.1; 8];

alpha1n = length(alpha1s);
f1n     = length(f1s);
varphin = length(varphis);
Pibarn  = length(Pibars);
ppsin   = length(ppsis);

theta = 10;
bet   = 0.99;
chi   = 8;
sigm  = 1;

% initialize

Ybars   = nan(alpha1n,f1n,varphin,Pibarn,ppsin);
Ps1s    = nan(alpha1n,f1n,varphin,Pibarn,ppsin);
Ps2s    = nan(alpha1n,f1n,varphin,Pibarn,ppsin);
PRP1s   = nan(alpha1n,f1n,varphin,Pibarn,ppsin);
PRP2s   = nan(alpha1n,f1n,varphin,Pibarn,ppsin);
D1s     = nan(alpha1n,f1n,varphin,Pibarn,ppsin);
D2s     = nan(alpha1n,f1n,varphin,Pibarn,ppsin);
Ds      = nan(alpha1n,f1n,varphin,Pibarn,ppsin);
MC1s    = nan(alpha1n,f1n,varphin,Pibarn,ppsin);
MC2s    = nan(alpha1n,f1n,varphin,Pibarn,ppsin);
MCs     = nan(alpha1n,f1n,varphin,Pibarn,ppsin);
MKUPs   = nan(alpha1n,f1n,varphin,Pibarn,ppsin);
LRSLPs  = nan(alpha1n,f1n,varphin,Pibarn,ppsin);
%LRSLPCFs  = nan(alpha1n,f1n,varphin,Pibarn,ppsin);

Psk1    = nan(201,alpha1n,f1n,varphin,Pibarn,ppsin);
Psk2    = nan(201,alpha1n,f1n,varphin,Pibarn,ppsin);
Ysk1    = nan(201,alpha1n,f1n,varphin,Pibarn,ppsin);
Ysk2    = nan(201,alpha1n,f1n,varphin,Pibarn,ppsin);
fsk1    = nan(201,alpha1n,f1n,varphin,Pibarn,ppsin);
fsk2    = nan(201,alpha1n,f1n,varphin,Pibarn,ppsin);
esk1    = nan(201,alpha1n,f1n,varphin,Pibarn,ppsin);
esk2    = nan(201,alpha1n,f1n,varphin,Pibarn,ppsin);
ssk1    = nan(201,alpha1n,f1n,varphin,Pibarn,ppsin);
ssk2    = nan(201,alpha1n,f1n,varphin,Pibarn,ppsin);

% compute (iterate over the grid)

for ind1=1:alpha1n
    
    alph1  = alpha1s(ind1);
    alph2  = alpha2s(ind1);
    
for ind5=1:f1n

    f1     = f1s(ind5);
    f2     = f2s(ind5);

for ind2=1:varphin
    
    varphi = varphis(ind2);
    
parfor ind3=1:Pibarn
    
    Pibar  = Pibars(ind3);
    
for ind4=1:ppsin
    
    ppsi   = ppsis(ind4);

    upper_Pibar = (1/bet/(1-min(alph1,alph2)))^(1/theta/(1-ppsi)/(1+varphi));
    if (ppsi<=1 && Pibar > upper_Pibar)
        continue;
    end

    % Find the steady state

    ff = @(x) func_2sectors_SS(x,bet,alph1,alph2,f1,f2,Pibar,theta,ppsi,sigm,chi);
    [x,fval,exitf] = fsolve(ff,[0;0;0],options);

    if (exitf<1)
        error('SS not solved!')
    end

    % steady state

    PsP1          = exp(x(1));
    PsP2          = exp(x(2));
    Ybar          = exp(x(3));

    Lam1powered   = alph1/(1-(1-alph1)*Pibar^(theta*(1-ppsi)-1))*PsP1^(1-theta*(1-ppsi));
    Lam1bar       = Lam1powered^(1/(1-theta*(1-ppsi)));
    Lam2powered   = alph2/(1-(1-alph2)*Pibar^(theta*(1-ppsi)-1))*PsP2^(1-theta*(1-ppsi));
    Lam2bar       = Lam2powered^(1/(1-theta*(1-ppsi)));
    Lampowered    = f1*Lam1powered + f2*Lam2powered;
    Lambar        = Lampowered^(1/(1-theta*(1-ppsi)));

    S1bar         = alph1/(1-(1-alph1)/Pibar)*PsP1;
    S2bar         = alph2/(1-(1-alph2)/Pibar)*PsP2;
    Sbar          = f1*S1bar + f2*S2bar;

    Z11bar        = Lambar^(theta*(1-ppsi))*Ybar^(1-sigm)/(1-bet*(1-alph1)*Pibar^(theta*(1-ppsi)-1));
    Z21bar        = Ybar^(1-sigm)/(1-bet*(1-alph1)/Pibar);
    Z31bar        = Lambar^(2*theta*(1-ppsi))*Ybar^2/(1-bet*(1-alph1)*Pibar^(2*theta*(1-ppsi)));
    Z41bar        = Lambar^(theta*(1-ppsi))*Ybar^2/(1-bet*(1-alph1)*Pibar^(theta*(1-ppsi)));
    
    Z12bar        = Lambar^(theta*(1-ppsi))*Ybar^(1-sigm)/(1-bet*(1-alph2)*Pibar^(theta*(1-ppsi)-1));
    Z22bar        = Ybar^(1-sigm)/(1-bet*(1-alph2)/Pibar);
    Z32bar        = Lambar^(2*theta*(1-ppsi))*Ybar^2/(1-bet*(1-alph2)*Pibar^(2*theta*(1-ppsi)));
    Z42bar        = Lambar^(theta*(1-ppsi))*Ybar^2/(1-bet*(1-alph2)*Pibar^(theta*(1-ppsi)));

    D1bar         = 1/(1-ppsi)*(alph1/(1-(1-alph1)*Pibar^(theta*(1-ppsi)))*(PsP1/Lambar)^(-theta*(1-ppsi))-ppsi);
    D2bar         = 1/(1-ppsi)*(alph2/(1-(1-alph2)*Pibar^(theta*(1-ppsi)))*(PsP2/Lambar)^(-theta*(1-ppsi))-ppsi);
    Dbar          = f1*D1bar + f2*D2bar;

    MC1bar        = chi*D1bar*Ybar^(1+sigm);
    MC2bar        = chi*D2bar*Ybar^(1+sigm);
    MCbar         = (f1*MC1bar + f2*MC2bar);
    Mbar          = 1/MCbar;

    % log-linearied equations to get the LR slope (timeless)

    expr01 = Slam  == f1*(Lam1bar/Lambar)^(1-theta*(1-ppsi))*Slam1 + f2*(Lam2bar/Lambar)^(1-theta*(1-ppsi))*Slam2;
    expr02 = Slam1 == (1-alph1)*Pibar^(theta*(1-ppsi)-1)*(Slam1 - Sp) + (1-(1-alph1)*Pibar^(theta*(1-ppsi)-1))*Sps1;
    expr03 = Slam2 == (1-alph2)*Pibar^(theta*(1-ppsi)-1)*(Slam2 - Sp) + (1-(1-alph2)*Pibar^(theta*(1-ppsi)-1))*Sps2;

    expr04 = Slam == ppsi*(f1*S1bar/Lambar*Ss1 + f2*S2bar/Lambar*Ss2);
    expr05 = Ss1  == (1-alph1)/Pibar*(Ss1 - Sp) + (1-(1-alph1)/Pibar)*Sps1;
    expr06 = Ss2  == (1-alph2)/Pibar*(Ss2 - Sp) + (1-(1-alph2)/Pibar)*Sps2;

%    expr07 = 1/(1+ppsi/(theta*(1-ppsi)-1)*Z21bar/Z11bar*PsP1^(theta*(1-ppsi)))*(Sz11 + Sps1) + ppsi/(1/(1/(theta*(1-ppsi)-1)*Z21bar/Z11bar*PsP1^(theta*(1-ppsi)))+ppsi)*(Sz21 + (theta*(1-ppsi)+1)*Sps1) == 1/(1-ppsi*Z41bar/Z31bar*PsP1^(theta*(1-ppsi)))*(Sz31 - theta*(1-ppsi)*Sps1) - ppsi/(1/(Z41bar/Z31bar*PsP1^(theta*(1-ppsi)))-ppsi)*Sz41;
%    expr08 = 1/(1+ppsi/(theta*(1-ppsi)-1)*Z22bar/Z12bar*PsP2^(theta*(1-ppsi)))*(Sz12 + Sps2) + ppsi/(1/(1/(theta*(1-ppsi)-1)*Z22bar/Z12bar*PsP2^(theta*(1-ppsi)))+ppsi)*(Sz22 + (theta*(1-ppsi)+1)*Sps2) == 1/(1-ppsi*Z42bar/Z32bar*PsP2^(theta*(1-ppsi)))*(Sz32 - theta*(1-ppsi)*Sps2) - ppsi/(1/(Z42bar/Z32bar*PsP2^(theta*(1-ppsi)))-ppsi)*Sz42;

    expr07 = (theta*(1-ppsi)-1)*Z11bar*PsP1*(Sz11 + Sps1) + ppsi*Z21bar*PsP1^(theta*(1-ppsi)+1)*(Sz21 + (theta*(1-ppsi)+1)*Sps1) - theta*chi*Z31bar*PsP1^(-theta*(1-ppsi))*(Sz31 - theta*(1-ppsi)*Sps1) + theta*chi*ppsi*Z41bar*Sz41;
    expr08 = (theta*(1-ppsi)-1)*Z12bar*PsP2*(Sz12 + Sps2) + ppsi*Z22bar*PsP2^(theta*(1-ppsi)+1)*(Sz22 + (theta*(1-ppsi)+1)*Sps2) - theta*chi*Z32bar*PsP2^(-theta*(1-ppsi))*(Sz32 - theta*(1-ppsi)*Sps2) + theta*chi*ppsi*Z42bar*Sz42;

    expr09 = Sz11 == (1-bet*(1-alph1)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*Slam + (1-sigm)*Sy) + bet*(1-alph1)*Pibar^(theta*(1-ppsi)-1)*(Sz11+(theta*(1-ppsi)-1)*Sp);
    expr10 = Sz21 == (1-bet*(1-alph1)/Pibar)*(1-sigm)*Sy + bet*(1-alph1)/Pibar*(Sz21 - Sp);
    %expr11 = Sz31 == (1-bet*(1-alph1)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*Slam + 2*Sy - 2*Sa) + bet*(1-alph1)*Pibar^(2*theta*(1-ppsi))*(Sz31 + 2*theta*(1-ppsi)*Sp);
    expr11 = Sz31 == (1-bet*(1-alph1)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*Slam + 2*Sy) + bet*(1-alph1)*Pibar^(2*theta*(1-ppsi))*(Sz31 + 2*theta*(1-ppsi)*Sp);
    %expr12 = Sz41 == (1-bet*(1-alph1)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*Slam + 2*Sy - 2*Sa) + bet*(1-alph1)*Pibar^(theta*(1-ppsi))*(Sz41 + theta*(1-ppsi)*Sp);
    expr12 = Sz41 == (1-bet*(1-alph1)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*Slam + 2*Sy) + bet*(1-alph1)*Pibar^(theta*(1-ppsi))*(Sz41 + theta*(1-ppsi)*Sp);

    expr13 = Sz12 == (1-bet*(1-alph2)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*Slam + (1-sigm)*Sy) + bet*(1-alph2)*Pibar^(theta*(1-ppsi)-1)*(Sz12+(theta*(1-ppsi)-1)*Sp);
    expr14 = Sz22 == (1-bet*(1-alph2)/Pibar)*(1-sigm)*Sy + bet*(1-alph2)/Pibar*(Sz22 - Sp);
    %expr15 = Sz32 == (1-bet*(1-alph2)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*Slam + 2*Sy - 2*Sa) + bet*(1-alph2)*Pibar^(2*theta*(1-ppsi))*(Sz32 + 2*theta*(1-ppsi)*Sp);
    expr15 = Sz32 == (1-bet*(1-alph2)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*Slam + 2*Sy) + bet*(1-alph2)*Pibar^(2*theta*(1-ppsi))*(Sz32 + 2*theta*(1-ppsi)*Sp);
    %expr16 = Sz42 == (1-bet*(1-alph2)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*Slam + 2*Sy - 2*Sa) + bet*(1-alph2)*Pibar^(theta*(1-ppsi))*(Sz42 + theta*(1-ppsi)*Sp);
    expr16 = Sz42 == (1-bet*(1-alph2)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*Slam + 2*Sy) + bet*(1-alph2)*Pibar^(theta*(1-ppsi))*(Sz42 + theta*(1-ppsi)*Sp);

    % elimination

    expr21 = eliminate([expr01, expr02, expr03],[Slam1,Slam2]); % lam, p, ps1, ps2
    expr22 = eliminate([expr04, expr05, expr06],[Ss1,Ss2]);     % lam, p, ps1, ps2
    expr23 = eliminate([expr07,expr09,expr10,expr11,expr12],[Sz11,Sz21,Sz31,Sz41]); % ps1, p, lam, y
    expr24 = eliminate([expr08,expr13,expr14,expr15,expr16],[Sz12,Sz22,Sz32,Sz42]); % ps2, p, lam, y

    expr00 = eliminate([expr21,expr22,expr23,expr24],[Slam,Sps1,Sps2]);

    LRS    = -double(diff(expr00,Sp))/double(diff(expr00,Sy));
% 
%     % log-linearied equations to get the LR slope (timeless) SECTORAL
%     % RELATIVE PRICES SHUTDOWN
% 
%     % elimination
% 
%     expr21 = eliminate([expr01, expr02, expr03],[Slam1,Slam2]); % lam, p, ps1, ps2
%     expr22 = eliminate([expr04, expr05, expr06],[Sps1,Sps2]);     % lam, p, Ss1, Ss2
%     expr23 = eliminate([expr07,expr09,expr10,expr11,expr12],[Sz11,Sz21,Sz31,Sz41]); % ps1, p, lam, y
%     expr24 = eliminate([expr08,expr13,expr14,expr15,expr16],[Sz12,Sz22,Sz32,Sz42]); % ps2, p, lam, y
% 
%     expr00 = eliminate([expr21,expr22,expr23,expr24],[Slam,Sps1,Sps2]);
%     
%     LRSCF    = -double(diff(expr00,Sp))/double(diff(expr00,Sy));
    
    Ybars(ind1,ind5,ind2,ind3,ind4)  = Ybar;
    Ps1s(ind1,ind5,ind2,ind3,ind4)   = PsP1;
    Ps2s(ind1,ind5,ind2,ind3,ind4)   = PsP2;
    Lam1s(ind1,ind5,ind2,ind3,ind4)  = Lam1bar;
    Lam2s(ind1,ind5,ind2,ind3,ind4)  = Lam2bar;
    D1s(ind1,ind5,ind2,ind3,ind4)    = D1bar;
    D2s(ind1,ind5,ind2,ind3,ind4)    = D2bar;
    Ds(ind1,ind5,ind2,ind3,ind4)     = Dbar;
    MC1s(ind1,ind5,ind2,ind3,ind4)   = MC1bar;
    MC2s(ind1,ind5,ind2,ind3,ind4)   = MC2bar;
    MCs(ind1,ind5,ind2,ind3,ind4)    = MCbar;
    MKUPs(ind1,ind5,ind2,ind3,ind4)  = Mbar;
    LRSLPs(ind1,ind5,ind2,ind3,ind4) = LRS;
%     LRSLPCFs(ind1,ind5,ind2,ind3,ind4) = LRSCF;
    
    for indk=1:201
        Psk1(indk,ind1,ind5,ind2,ind3,ind4) = PsP1/(Pibar^(indk-1));
        Ysk1(indk,ind1,ind5,ind2,ind3,ind4) = (1/(1-ppsi))*(Psk1(indk,ind1,ind5,ind2,ind3,ind4)^(-theta*(1-ppsi))*Lambar^(theta*(1-ppsi))-ppsi)*Ybar;
        fsk1(indk,ind1,ind5,ind2,ind3,ind4) = alph1*(1-alph1)^(indk-1)*f1;
        esk1(indk,ind1,ind5,ind2,ind3,ind4) = theta + theta*ppsi*(1/Ysk1(indk,ind1,ind5,ind2,ind3,ind4) -1);
        ssk1(indk,ind1,ind5,ind2,ind3,ind4) = theta*ppsi/Ysk1(indk,ind1,ind5,ind2,ind3,ind4);
        Psk2(indk,ind1,ind5,ind2,ind3,ind4) = PsP2/(Pibar^(indk-1));
        Ysk2(indk,ind1,ind5,ind2,ind3,ind4) = (1/(1-ppsi))*(Psk2(indk,ind1,ind5,ind2,ind3,ind4)^(-theta*(1-ppsi))*Lambar^(theta*(1-ppsi))-ppsi)*Ybar;
        fsk2(indk,ind1,ind5,ind2,ind3,ind4) = alph2*(1-alph2)^(indk-1)*f2;
        esk2(indk,ind1,ind5,ind2,ind3,ind4) = theta + theta*ppsi*(1/Ysk2(indk,ind1,ind5,ind2,ind3,ind4) -1);
        ssk2(indk,ind1,ind5,ind2,ind3,ind4) = theta*ppsi/Ysk2(indk,ind1,ind5,ind2,ind3,ind4);
    end
    
%    Xi1              = alph1/(1-(1-alph1)*Pibar^(2*theta*(1-ppsi)))/((1-ppsi)^2)*PsP1^(-2*theta*(1-ppsi))*Lambar^(2*theta*(1-ppsi))...
%                       - 2*alph1/(1-(1-alph1)*Pibar^(theta*(1-ppsi)))*ppsi/((1-ppsi)^2)*PsP1^(-theta*(1-ppsi))*Lambar^(theta*(1-ppsi)) + (ppsi/(1-ppsi))^2;
%    Xi2              = alph2/(1-(1-alph2)*Pibar^(2*theta*(1-ppsi)))/((1-ppsi)^2)*PsP2^(-2*theta*(1-ppsi))*Lambar^(2*theta*(1-ppsi))...
%                       - 2*alph2/(1-(1-alph2)*Pibar^(theta*(1-ppsi)))*ppsi/((1-ppsi)^2)*PsP2^(-theta*(1-ppsi))*Lambar^(theta*(1-ppsi)) + (ppsi/(1-ppsi))^2;
%    Ubar             = log(Ybar) - 1/2*(Ybar)^2*(f1*Xi1+f2*Xi2);
%    Ubars(indz,indx,indy) = Ubar;

end
end
end
end
end

save('LRSLPs.mat','LRSLPs','LRSLPCFs','Ybars','alpha1s','alpha2s','f1s','f2s','varphis','Pibars','ppsis','Psk1','Ysk1','fsk1','esk1','ssk1','Psk2','Ysk2','fsk2','esk2','ssk2');

%% figures psi=1.1

h1=figure;

% output

xs  = (Pibars.^4-1)*100;
ys1 = Ybars(1,1,1,:,3);
ys2 = Ybars(2,1,1,:,3);
ys3 = Ybars(3,1,1,:,3);
ys4 = Ybars(4,1,1,:,3);
ys5 = Ybars(5,1,1,:,3);

subplot(1,4,1)
plot(xs,ys1(:),'LineWidth',3)
line(xs,ys2(:),'LineWidth',1,'LineStyle','--','Color',[0.8500 0.3250 0.0980])
line(xs,ys3(:),'LineWidth',2,'LineStyle',':','Color',[0.9290 0.6940 0.1250])
line(xs,ys4(:),'LineWidth',1,'LineStyle','-.','Color',[0.4940 0.1840 0.5560])
line(xs,ys5(:),'LineWidth',1,'LineStyle','-','Color',[0.4660 0.6740 0.1880])
xlim([min(xs) max(xs)])
%ylim([0 1])
title('Output','FontName','Times New Roman','FontSize',10)
xlabel('Trend inflation','FontName','Times New Roman','FontSize',10)

% distortion factor

xs  = (Pibars.^4-1)*100;
ys1 = Ds(1,1,1,:,3);
ys2 = Ds(2,1,1,:,3);
ys3 = Ds(3,1,1,:,3);
ys4 = Ds(4,1,1,:,3);
ys5 = Ds(5,1,1,:,3);

subplot(1,4,2)
plot(xs,ys1(:),'LineWidth',3)
line(xs,ys2(:),'LineWidth',1,'LineStyle','--','Color',[0.8500 0.3250 0.0980])
line(xs,ys3(:),'LineWidth',2,'LineStyle',':','Color',[0.9290 0.6940 0.1250])
line(xs,ys4(:),'LineWidth',1,'LineStyle','-.','Color',[0.4940 0.1840 0.5560])
line(xs,ys5(:),'LineWidth',1,'LineStyle','-','Color',[0.4660 0.6740 0.1880])
xlim([min(xs) max(xs)])
%ylim([0 1])
title('Distortion factor','FontName','Times New Roman','FontSize',10)

% average markup

xs  = (Pibars.^4-1)*100;
ys1 = MKUPs(1,1,1,:,3);
ys2 = MKUPs(2,1,1,:,3);
ys3 = MKUPs(3,1,1,:,3);
ys4 = MKUPs(4,1,1,:,3);
ys5 = MKUPs(5,1,1,:,3);

subplot(1,4,3)
plot(xs,ys1(:),'LineWidth',3)
line(xs,ys2(:),'LineWidth',1,'LineStyle','--','Color',[0.8500 0.3250 0.0980])
line(xs,ys3(:),'LineWidth',2,'LineStyle',':','Color',[0.9290 0.6940 0.1250])
line(xs,ys4(:),'LineWidth',1,'LineStyle','-.','Color',[0.4940 0.1840 0.5560])
line(xs,ys5(:),'LineWidth',1,'LineStyle','-','Color',[0.4660 0.6740 0.1880])
xlim([min(xs) max(xs)])
%ylim([0 1])
title('Average markups','FontName','Times New Roman','FontSize',10)

% Slope of LR NKPC

xs  = (Pibars.^4-1)*100;
ys1 = LRSLPs(1,1,1,:,3);
ys2 = LRSLPs(2,1,1,:,3);
ys3 = LRSLPs(3,1,1,:,3);
ys4 = LRSLPs(4,1,1,:,3);
ys5 = LRSLPs(5,1,1,:,3);

subplot(1,4,4)
plot(xs,ys1(:),'LineWidth',3)
line(xs,ys2(:),'LineWidth',1,'LineStyle','--','Color',[0.8500 0.3250 0.0980])
line(xs,ys3(:),'LineWidth',2,'LineStyle',':','Color',[0.9290 0.6940 0.1250])
line(xs,ys4(:),'LineWidth',1,'LineStyle','-.','Color',[0.4940 0.1840 0.5560])
line(xs,ys5(:),'LineWidth',1,'LineStyle','-','Color',[0.4660 0.6740 0.1880])
xlim([min(xs) max(xs)])
%ylim([-500 1])
title('Slope of LR NKPC','FontName','Times New Roman','FontSize',10)

legend({'$(\alpha_{1},\alpha_{2}) = (0.5,0.5)$',...
        '$\phantom{(\alpha_{1},\alpha_{2}) = }(0.4,0.6)$',...
        '$\phantom{(\alpha_{1},\alpha_{2}) = }(0.3,0.7)$',...
        '$\phantom{(\alpha_{1},\alpha_{2}) = }(0.2,0.1)$',...
        '$\phantom{(\alpha_{1},\alpha_{2}) = }(0.1,0.9)$'},'Interpreter','latex','Location','East','FontName','Times New Roman','FontSize',8)
legend('boxoff')
    
h1.PaperSize = [21 29.7/4];
h1.PaperUnits = 'centimeters';
h1.PaperPosition = [0 0 1.5*21 1.5*29.7/4];

print kink_2s_SS_psi11.eps -depsc2

%% figures psi=1.1

h1=figure;

% output

xs  = (Pibars.^4-1)*100;
ys1 = Ybars(1,1,1,:,3);
ys2 = Ybars(2,1,1,:,3);
ys3 = Ybars(3,1,1,:,3);
ys4 = Ybars(4,1,1,:,3);
ys5 = Ybars(5,1,1,:,3);

subplot(1,2,1)
plot(xs,ys1(:),'LineWidth',3)
line(xs,ys2(:),'LineWidth',1,'LineStyle','--','Color',[0.8500 0.3250 0.0980])
line(xs,ys3(:),'LineWidth',2,'LineStyle',':','Color',[0.9290 0.6940 0.1250])
line(xs,ys4(:),'LineWidth',1,'LineStyle','-.','Color',[0.4940 0.1840 0.5560])
line(xs,ys5(:),'LineWidth',1,'LineStyle','-','Color',[0.4660 0.6740 0.1880])
xlim([min(xs) max(xs)])
%ylim([0 1])
title({'(a) Output',''},'FontName','Times New Roman','FontSize',12)
xlabel('Trend inflation','FontName','Times New Roman','FontSize',12)

% Slope of LR NKPC

xs  = (Pibars.^4-1)*100;
ys1 = LRSLPs(1,1,1,:,3);
ys2 = LRSLPs(2,1,1,:,3);
ys3 = LRSLPs(3,1,1,:,3);
ys4 = LRSLPs(4,1,1,:,3);
ys5 = LRSLPs(5,1,1,:,3);

subplot(1,2,2)
plot(xs,ys1(:),'LineWidth',3)
line(xs,ys2(:),'LineWidth',1,'LineStyle','--','Color',[0.8500 0.3250 0.0980])
line(xs,ys3(:),'LineWidth',2,'LineStyle',':','Color',[0.9290 0.6940 0.1250])
line(xs,ys4(:),'LineWidth',1,'LineStyle','-.','Color',[0.4940 0.1840 0.5560])
line(xs,ys5(:),'LineWidth',1,'LineStyle','-','Color',[0.4660 0.6740 0.1880])
xlim([min(xs) max(xs)])
ylim([0 7])
title({'(b) LR trade-off',''},'FontName','Times New Roman','FontSize',12)
xlabel('Trend inflation','FontName','Times New Roman','FontSize',12)
   
% % Slope of LR NKPC (with sectoral prices shut down)
% 
% xs  = (Pibars.^4-1)*100;
% ys1 = LRSLPCFs(1,1,1,:,3);
% ys2 = LRSLPCFs(2,1,1,:,3);
% ys3 = LRSLPCFs(3,1,1,:,3);
% ys4 = LRSLPCFs(4,1,1,:,3);
% ys5 = LRSLPCFs(5,1,1,:,3);
% 
% subplot(1,3,3)
% plot(xs,ys1(:),'LineWidth',3)
% line(xs,ys2(:),'LineWidth',1,'LineStyle','--','Color',[0.8500 0.3250 0.0980])
% line(xs,ys3(:),'LineWidth',2,'LineStyle',':','Color',[0.9290 0.6940 0.1250])
% line(xs,ys4(:),'LineWidth',1,'LineStyle','-.','Color',[0.4940 0.1840 0.5560])
% line(xs,ys5(:),'LineWidth',1,'LineStyle','-','Color',[0.4660 0.6740 0.1880])
% xlim([min(xs) max(xs)])
% ylim([0 7])
% title({'(c) LR trade-off','with the sectoral prices shut down'},'FontName','Times New Roman','FontSize',12)
% xlabel('Trend inflation','FontName','Times New Roman','FontSize',12)
%   
legend({'$(\alpha_{1},\alpha_{2}) = (0.5,0.5)$',...
        '$\phantom{(\alpha_{1},\alpha_{2}) = }(0.4,0.6)$',...
        '$\phantom{(\alpha_{1},\alpha_{2}) = }(0.3,0.7)$',...
        '$\phantom{(\alpha_{1},\alpha_{2}) = }(0.2,0.1)$',...
        '$\phantom{(\alpha_{1},\alpha_{2}) = }(0.1,0.9)$'},'Interpreter','latex','Location','NorthWest','FontName','Times New Roman','FontSize',10)
legend('boxoff')

h1.PaperSize = [21 29.7/4];
h1.PaperUnits = 'centimeters';
h1.PaperPosition = [0 0 1.5*21 1.5*29.7/4];

print kink_2s_SS_psi11_outputslope.eps -depsc2
