% A 272-sector model with the kinked demand curve
% contemporaneous MP rule
% post-Volcker
% WYP, February 2020

close all

options = optimoptions('fsolve','FunctionTolerance',1e-8,'OptimalityTolerance',1e-8);
filenm  = 'kinked_linear_NS_boundary';

%% defining parameters

parameters Pibar theta ppsi bet phipi phiy Ybar Lambar chi sigm rhoi;
parameters alph001 f001 PsP001 Lam001bar S001bar Z1001bar Z2001bar Z3001bar Z4001bar;
parameters alph002 f002 PsP002 Lam002bar S002bar Z1002bar Z2002bar Z3002bar Z4002bar;
parameters alph003 f003 PsP003 Lam003bar S003bar Z1003bar Z2003bar Z3003bar Z4003bar;
parameters alph004 f004 PsP004 Lam004bar S004bar Z1004bar Z2004bar Z3004bar Z4004bar;
parameters alph005 f005 PsP005 Lam005bar S005bar Z1005bar Z2005bar Z3005bar Z4005bar;
parameters alph006 f006 PsP006 Lam006bar S006bar Z1006bar Z2006bar Z3006bar Z4006bar;
parameters alph007 f007 PsP007 Lam007bar S007bar Z1007bar Z2007bar Z3007bar Z4007bar;
parameters alph008 f008 PsP008 Lam008bar S008bar Z1008bar Z2008bar Z3008bar Z4008bar;
parameters alph009 f009 PsP009 Lam009bar S009bar Z1009bar Z2009bar Z3009bar Z4009bar;
parameters alph010 f010 PsP010 Lam010bar S010bar Z1010bar Z2010bar Z3010bar Z4010bar;
parameters alph011 f011 PsP011 Lam011bar S011bar Z1011bar Z2011bar Z3011bar Z4011bar;
parameters alph012 f012 PsP012 Lam012bar S012bar Z1012bar Z2012bar Z3012bar Z4012bar;
parameters alph013 f013 PsP013 Lam013bar S013bar Z1013bar Z2013bar Z3013bar Z4013bar;
parameters alph014 f014 PsP014 Lam014bar S014bar Z1014bar Z2014bar Z3014bar Z4014bar;
parameters alph015 f015 PsP015 Lam015bar S015bar Z1015bar Z2015bar Z3015bar Z4015bar;
parameters alph016 f016 PsP016 Lam016bar S016bar Z1016bar Z2016bar Z3016bar Z4016bar;
parameters alph017 f017 PsP017 Lam017bar S017bar Z1017bar Z2017bar Z3017bar Z4017bar;
parameters alph018 f018 PsP018 Lam018bar S018bar Z1018bar Z2018bar Z3018bar Z4018bar;
parameters alph019 f019 PsP019 Lam019bar S019bar Z1019bar Z2019bar Z3019bar Z4019bar;
parameters alph020 f020 PsP020 Lam020bar S020bar Z1020bar Z2020bar Z3020bar Z4020bar;
parameters alph021 f021 PsP021 Lam021bar S021bar Z1021bar Z2021bar Z3021bar Z4021bar;
parameters alph022 f022 PsP022 Lam022bar S022bar Z1022bar Z2022bar Z3022bar Z4022bar;
parameters alph023 f023 PsP023 Lam023bar S023bar Z1023bar Z2023bar Z3023bar Z4023bar;
parameters alph024 f024 PsP024 Lam024bar S024bar Z1024bar Z2024bar Z3024bar Z4024bar;
parameters alph025 f025 PsP025 Lam025bar S025bar Z1025bar Z2025bar Z3025bar Z4025bar;
parameters alph026 f026 PsP026 Lam026bar S026bar Z1026bar Z2026bar Z3026bar Z4026bar;
parameters alph027 f027 PsP027 Lam027bar S027bar Z1027bar Z2027bar Z3027bar Z4027bar;
parameters alph028 f028 PsP028 Lam028bar S028bar Z1028bar Z2028bar Z3028bar Z4028bar;
parameters alph029 f029 PsP029 Lam029bar S029bar Z1029bar Z2029bar Z3029bar Z4029bar;
parameters alph030 f030 PsP030 Lam030bar S030bar Z1030bar Z2030bar Z3030bar Z4030bar;
parameters alph031 f031 PsP031 Lam031bar S031bar Z1031bar Z2031bar Z3031bar Z4031bar;
parameters alph032 f032 PsP032 Lam032bar S032bar Z1032bar Z2032bar Z3032bar Z4032bar;
parameters alph033 f033 PsP033 Lam033bar S033bar Z1033bar Z2033bar Z3033bar Z4033bar;
parameters alph034 f034 PsP034 Lam034bar S034bar Z1034bar Z2034bar Z3034bar Z4034bar;
parameters alph035 f035 PsP035 Lam035bar S035bar Z1035bar Z2035bar Z3035bar Z4035bar;
parameters alph036 f036 PsP036 Lam036bar S036bar Z1036bar Z2036bar Z3036bar Z4036bar;
parameters alph037 f037 PsP037 Lam037bar S037bar Z1037bar Z2037bar Z3037bar Z4037bar;
parameters alph038 f038 PsP038 Lam038bar S038bar Z1038bar Z2038bar Z3038bar Z4038bar;
parameters alph039 f039 PsP039 Lam039bar S039bar Z1039bar Z2039bar Z3039bar Z4039bar;
parameters alph040 f040 PsP040 Lam040bar S040bar Z1040bar Z2040bar Z3040bar Z4040bar;
parameters alph041 f041 PsP041 Lam041bar S041bar Z1041bar Z2041bar Z3041bar Z4041bar;
parameters alph042 f042 PsP042 Lam042bar S042bar Z1042bar Z2042bar Z3042bar Z4042bar;
parameters alph043 f043 PsP043 Lam043bar S043bar Z1043bar Z2043bar Z3043bar Z4043bar;
parameters alph044 f044 PsP044 Lam044bar S044bar Z1044bar Z2044bar Z3044bar Z4044bar;
parameters alph045 f045 PsP045 Lam045bar S045bar Z1045bar Z2045bar Z3045bar Z4045bar;
parameters alph046 f046 PsP046 Lam046bar S046bar Z1046bar Z2046bar Z3046bar Z4046bar;
parameters alph047 f047 PsP047 Lam047bar S047bar Z1047bar Z2047bar Z3047bar Z4047bar;
parameters alph048 f048 PsP048 Lam048bar S048bar Z1048bar Z2048bar Z3048bar Z4048bar;
parameters alph049 f049 PsP049 Lam049bar S049bar Z1049bar Z2049bar Z3049bar Z4049bar;
parameters alph050 f050 PsP050 Lam050bar S050bar Z1050bar Z2050bar Z3050bar Z4050bar;
parameters alph051 f051 PsP051 Lam051bar S051bar Z1051bar Z2051bar Z3051bar Z4051bar;
parameters alph052 f052 PsP052 Lam052bar S052bar Z1052bar Z2052bar Z3052bar Z4052bar;
parameters alph053 f053 PsP053 Lam053bar S053bar Z1053bar Z2053bar Z3053bar Z4053bar;
parameters alph054 f054 PsP054 Lam054bar S054bar Z1054bar Z2054bar Z3054bar Z4054bar;
parameters alph055 f055 PsP055 Lam055bar S055bar Z1055bar Z2055bar Z3055bar Z4055bar;
parameters alph056 f056 PsP056 Lam056bar S056bar Z1056bar Z2056bar Z3056bar Z4056bar;
parameters alph057 f057 PsP057 Lam057bar S057bar Z1057bar Z2057bar Z3057bar Z4057bar;
parameters alph058 f058 PsP058 Lam058bar S058bar Z1058bar Z2058bar Z3058bar Z4058bar;
parameters alph059 f059 PsP059 Lam059bar S059bar Z1059bar Z2059bar Z3059bar Z4059bar;
parameters alph060 f060 PsP060 Lam060bar S060bar Z1060bar Z2060bar Z3060bar Z4060bar;
parameters alph061 f061 PsP061 Lam061bar S061bar Z1061bar Z2061bar Z3061bar Z4061bar;
parameters alph062 f062 PsP062 Lam062bar S062bar Z1062bar Z2062bar Z3062bar Z4062bar;
parameters alph063 f063 PsP063 Lam063bar S063bar Z1063bar Z2063bar Z3063bar Z4063bar;
parameters alph064 f064 PsP064 Lam064bar S064bar Z1064bar Z2064bar Z3064bar Z4064bar;
parameters alph065 f065 PsP065 Lam065bar S065bar Z1065bar Z2065bar Z3065bar Z4065bar;
parameters alph066 f066 PsP066 Lam066bar S066bar Z1066bar Z2066bar Z3066bar Z4066bar;
parameters alph067 f067 PsP067 Lam067bar S067bar Z1067bar Z2067bar Z3067bar Z4067bar;
parameters alph068 f068 PsP068 Lam068bar S068bar Z1068bar Z2068bar Z3068bar Z4068bar;
parameters alph069 f069 PsP069 Lam069bar S069bar Z1069bar Z2069bar Z3069bar Z4069bar;
parameters alph070 f070 PsP070 Lam070bar S070bar Z1070bar Z2070bar Z3070bar Z4070bar;
parameters alph071 f071 PsP071 Lam071bar S071bar Z1071bar Z2071bar Z3071bar Z4071bar;
parameters alph072 f072 PsP072 Lam072bar S072bar Z1072bar Z2072bar Z3072bar Z4072bar;
parameters alph073 f073 PsP073 Lam073bar S073bar Z1073bar Z2073bar Z3073bar Z4073bar;
parameters alph074 f074 PsP074 Lam074bar S074bar Z1074bar Z2074bar Z3074bar Z4074bar;
parameters alph075 f075 PsP075 Lam075bar S075bar Z1075bar Z2075bar Z3075bar Z4075bar;
parameters alph076 f076 PsP076 Lam076bar S076bar Z1076bar Z2076bar Z3076bar Z4076bar;
parameters alph077 f077 PsP077 Lam077bar S077bar Z1077bar Z2077bar Z3077bar Z4077bar;
parameters alph078 f078 PsP078 Lam078bar S078bar Z1078bar Z2078bar Z3078bar Z4078bar;
parameters alph079 f079 PsP079 Lam079bar S079bar Z1079bar Z2079bar Z3079bar Z4079bar;
parameters alph080 f080 PsP080 Lam080bar S080bar Z1080bar Z2080bar Z3080bar Z4080bar;
parameters alph081 f081 PsP081 Lam081bar S081bar Z1081bar Z2081bar Z3081bar Z4081bar;
parameters alph082 f082 PsP082 Lam082bar S082bar Z1082bar Z2082bar Z3082bar Z4082bar;
parameters alph083 f083 PsP083 Lam083bar S083bar Z1083bar Z2083bar Z3083bar Z4083bar;
parameters alph084 f084 PsP084 Lam084bar S084bar Z1084bar Z2084bar Z3084bar Z4084bar;
parameters alph085 f085 PsP085 Lam085bar S085bar Z1085bar Z2085bar Z3085bar Z4085bar;
parameters alph086 f086 PsP086 Lam086bar S086bar Z1086bar Z2086bar Z3086bar Z4086bar;
parameters alph087 f087 PsP087 Lam087bar S087bar Z1087bar Z2087bar Z3087bar Z4087bar;
parameters alph088 f088 PsP088 Lam088bar S088bar Z1088bar Z2088bar Z3088bar Z4088bar;
parameters alph089 f089 PsP089 Lam089bar S089bar Z1089bar Z2089bar Z3089bar Z4089bar;
parameters alph090 f090 PsP090 Lam090bar S090bar Z1090bar Z2090bar Z3090bar Z4090bar;
parameters alph091 f091 PsP091 Lam091bar S091bar Z1091bar Z2091bar Z3091bar Z4091bar;
parameters alph092 f092 PsP092 Lam092bar S092bar Z1092bar Z2092bar Z3092bar Z4092bar;
parameters alph093 f093 PsP093 Lam093bar S093bar Z1093bar Z2093bar Z3093bar Z4093bar;
parameters alph094 f094 PsP094 Lam094bar S094bar Z1094bar Z2094bar Z3094bar Z4094bar;
parameters alph095 f095 PsP095 Lam095bar S095bar Z1095bar Z2095bar Z3095bar Z4095bar;
parameters alph096 f096 PsP096 Lam096bar S096bar Z1096bar Z2096bar Z3096bar Z4096bar;
parameters alph097 f097 PsP097 Lam097bar S097bar Z1097bar Z2097bar Z3097bar Z4097bar;
parameters alph098 f098 PsP098 Lam098bar S098bar Z1098bar Z2098bar Z3098bar Z4098bar;
parameters alph099 f099 PsP099 Lam099bar S099bar Z1099bar Z2099bar Z3099bar Z4099bar;
parameters alph100 f100 PsP100 Lam100bar S100bar Z1100bar Z2100bar Z3100bar Z4100bar;
parameters alph101 f101 PsP101 Lam101bar S101bar Z1101bar Z2101bar Z3101bar Z4101bar;
parameters alph102 f102 PsP102 Lam102bar S102bar Z1102bar Z2102bar Z3102bar Z4102bar;
parameters alph103 f103 PsP103 Lam103bar S103bar Z1103bar Z2103bar Z3103bar Z4103bar;
parameters alph104 f104 PsP104 Lam104bar S104bar Z1104bar Z2104bar Z3104bar Z4104bar;
parameters alph105 f105 PsP105 Lam105bar S105bar Z1105bar Z2105bar Z3105bar Z4105bar;
parameters alph106 f106 PsP106 Lam106bar S106bar Z1106bar Z2106bar Z3106bar Z4106bar;
parameters alph107 f107 PsP107 Lam107bar S107bar Z1107bar Z2107bar Z3107bar Z4107bar;
parameters alph108 f108 PsP108 Lam108bar S108bar Z1108bar Z2108bar Z3108bar Z4108bar;
parameters alph109 f109 PsP109 Lam109bar S109bar Z1109bar Z2109bar Z3109bar Z4109bar;
parameters alph110 f110 PsP110 Lam110bar S110bar Z1110bar Z2110bar Z3110bar Z4110bar;
parameters alph111 f111 PsP111 Lam111bar S111bar Z1111bar Z2111bar Z3111bar Z4111bar;
parameters alph112 f112 PsP112 Lam112bar S112bar Z1112bar Z2112bar Z3112bar Z4112bar;
parameters alph113 f113 PsP113 Lam113bar S113bar Z1113bar Z2113bar Z3113bar Z4113bar;
parameters alph114 f114 PsP114 Lam114bar S114bar Z1114bar Z2114bar Z3114bar Z4114bar;
parameters alph115 f115 PsP115 Lam115bar S115bar Z1115bar Z2115bar Z3115bar Z4115bar;
parameters alph116 f116 PsP116 Lam116bar S116bar Z1116bar Z2116bar Z3116bar Z4116bar;
parameters alph117 f117 PsP117 Lam117bar S117bar Z1117bar Z2117bar Z3117bar Z4117bar;
parameters alph118 f118 PsP118 Lam118bar S118bar Z1118bar Z2118bar Z3118bar Z4118bar;
parameters alph119 f119 PsP119 Lam119bar S119bar Z1119bar Z2119bar Z3119bar Z4119bar;
parameters alph120 f120 PsP120 Lam120bar S120bar Z1120bar Z2120bar Z3120bar Z4120bar;
parameters alph121 f121 PsP121 Lam121bar S121bar Z1121bar Z2121bar Z3121bar Z4121bar;
parameters alph122 f122 PsP122 Lam122bar S122bar Z1122bar Z2122bar Z3122bar Z4122bar;
parameters alph123 f123 PsP123 Lam123bar S123bar Z1123bar Z2123bar Z3123bar Z4123bar;
parameters alph124 f124 PsP124 Lam124bar S124bar Z1124bar Z2124bar Z3124bar Z4124bar;
parameters alph125 f125 PsP125 Lam125bar S125bar Z1125bar Z2125bar Z3125bar Z4125bar;
parameters alph126 f126 PsP126 Lam126bar S126bar Z1126bar Z2126bar Z3126bar Z4126bar;
parameters alph127 f127 PsP127 Lam127bar S127bar Z1127bar Z2127bar Z3127bar Z4127bar;
parameters alph128 f128 PsP128 Lam128bar S128bar Z1128bar Z2128bar Z3128bar Z4128bar;
parameters alph129 f129 PsP129 Lam129bar S129bar Z1129bar Z2129bar Z3129bar Z4129bar;
parameters alph130 f130 PsP130 Lam130bar S130bar Z1130bar Z2130bar Z3130bar Z4130bar;
parameters alph131 f131 PsP131 Lam131bar S131bar Z1131bar Z2131bar Z3131bar Z4131bar;
parameters alph132 f132 PsP132 Lam132bar S132bar Z1132bar Z2132bar Z3132bar Z4132bar;
parameters alph133 f133 PsP133 Lam133bar S133bar Z1133bar Z2133bar Z3133bar Z4133bar;
parameters alph134 f134 PsP134 Lam134bar S134bar Z1134bar Z2134bar Z3134bar Z4134bar;
parameters alph135 f135 PsP135 Lam135bar S135bar Z1135bar Z2135bar Z3135bar Z4135bar;
parameters alph136 f136 PsP136 Lam136bar S136bar Z1136bar Z2136bar Z3136bar Z4136bar;
parameters alph137 f137 PsP137 Lam137bar S137bar Z1137bar Z2137bar Z3137bar Z4137bar;
parameters alph138 f138 PsP138 Lam138bar S138bar Z1138bar Z2138bar Z3138bar Z4138bar;
parameters alph139 f139 PsP139 Lam139bar S139bar Z1139bar Z2139bar Z3139bar Z4139bar;
parameters alph140 f140 PsP140 Lam140bar S140bar Z1140bar Z2140bar Z3140bar Z4140bar;
parameters alph141 f141 PsP141 Lam141bar S141bar Z1141bar Z2141bar Z3141bar Z4141bar;
parameters alph142 f142 PsP142 Lam142bar S142bar Z1142bar Z2142bar Z3142bar Z4142bar;
parameters alph143 f143 PsP143 Lam143bar S143bar Z1143bar Z2143bar Z3143bar Z4143bar;
parameters alph144 f144 PsP144 Lam144bar S144bar Z1144bar Z2144bar Z3144bar Z4144bar;
parameters alph145 f145 PsP145 Lam145bar S145bar Z1145bar Z2145bar Z3145bar Z4145bar;
parameters alph146 f146 PsP146 Lam146bar S146bar Z1146bar Z2146bar Z3146bar Z4146bar;
parameters alph147 f147 PsP147 Lam147bar S147bar Z1147bar Z2147bar Z3147bar Z4147bar;
parameters alph148 f148 PsP148 Lam148bar S148bar Z1148bar Z2148bar Z3148bar Z4148bar;
parameters alph149 f149 PsP149 Lam149bar S149bar Z1149bar Z2149bar Z3149bar Z4149bar;
parameters alph150 f150 PsP150 Lam150bar S150bar Z1150bar Z2150bar Z3150bar Z4150bar;
parameters alph151 f151 PsP151 Lam151bar S151bar Z1151bar Z2151bar Z3151bar Z4151bar;
parameters alph152 f152 PsP152 Lam152bar S152bar Z1152bar Z2152bar Z3152bar Z4152bar;
parameters alph153 f153 PsP153 Lam153bar S153bar Z1153bar Z2153bar Z3153bar Z4153bar;
parameters alph154 f154 PsP154 Lam154bar S154bar Z1154bar Z2154bar Z3154bar Z4154bar;
parameters alph155 f155 PsP155 Lam155bar S155bar Z1155bar Z2155bar Z3155bar Z4155bar;
parameters alph156 f156 PsP156 Lam156bar S156bar Z1156bar Z2156bar Z3156bar Z4156bar;
parameters alph157 f157 PsP157 Lam157bar S157bar Z1157bar Z2157bar Z3157bar Z4157bar;
parameters alph158 f158 PsP158 Lam158bar S158bar Z1158bar Z2158bar Z3158bar Z4158bar;
parameters alph159 f159 PsP159 Lam159bar S159bar Z1159bar Z2159bar Z3159bar Z4159bar;
parameters alph160 f160 PsP160 Lam160bar S160bar Z1160bar Z2160bar Z3160bar Z4160bar;
parameters alph161 f161 PsP161 Lam161bar S161bar Z1161bar Z2161bar Z3161bar Z4161bar;
parameters alph162 f162 PsP162 Lam162bar S162bar Z1162bar Z2162bar Z3162bar Z4162bar;
parameters alph163 f163 PsP163 Lam163bar S163bar Z1163bar Z2163bar Z3163bar Z4163bar;
parameters alph164 f164 PsP164 Lam164bar S164bar Z1164bar Z2164bar Z3164bar Z4164bar;
parameters alph165 f165 PsP165 Lam165bar S165bar Z1165bar Z2165bar Z3165bar Z4165bar;
parameters alph166 f166 PsP166 Lam166bar S166bar Z1166bar Z2166bar Z3166bar Z4166bar;
parameters alph167 f167 PsP167 Lam167bar S167bar Z1167bar Z2167bar Z3167bar Z4167bar;
parameters alph168 f168 PsP168 Lam168bar S168bar Z1168bar Z2168bar Z3168bar Z4168bar;
parameters alph169 f169 PsP169 Lam169bar S169bar Z1169bar Z2169bar Z3169bar Z4169bar;
parameters alph170 f170 PsP170 Lam170bar S170bar Z1170bar Z2170bar Z3170bar Z4170bar;
parameters alph171 f171 PsP171 Lam171bar S171bar Z1171bar Z2171bar Z3171bar Z4171bar;
parameters alph172 f172 PsP172 Lam172bar S172bar Z1172bar Z2172bar Z3172bar Z4172bar;
parameters alph173 f173 PsP173 Lam173bar S173bar Z1173bar Z2173bar Z3173bar Z4173bar;
parameters alph174 f174 PsP174 Lam174bar S174bar Z1174bar Z2174bar Z3174bar Z4174bar;
parameters alph175 f175 PsP175 Lam175bar S175bar Z1175bar Z2175bar Z3175bar Z4175bar;
parameters alph176 f176 PsP176 Lam176bar S176bar Z1176bar Z2176bar Z3176bar Z4176bar;
parameters alph177 f177 PsP177 Lam177bar S177bar Z1177bar Z2177bar Z3177bar Z4177bar;
parameters alph178 f178 PsP178 Lam178bar S178bar Z1178bar Z2178bar Z3178bar Z4178bar;
parameters alph179 f179 PsP179 Lam179bar S179bar Z1179bar Z2179bar Z3179bar Z4179bar;
parameters alph180 f180 PsP180 Lam180bar S180bar Z1180bar Z2180bar Z3180bar Z4180bar;
parameters alph181 f181 PsP181 Lam181bar S181bar Z1181bar Z2181bar Z3181bar Z4181bar;
parameters alph182 f182 PsP182 Lam182bar S182bar Z1182bar Z2182bar Z3182bar Z4182bar;
parameters alph183 f183 PsP183 Lam183bar S183bar Z1183bar Z2183bar Z3183bar Z4183bar;
parameters alph184 f184 PsP184 Lam184bar S184bar Z1184bar Z2184bar Z3184bar Z4184bar;
parameters alph185 f185 PsP185 Lam185bar S185bar Z1185bar Z2185bar Z3185bar Z4185bar;
parameters alph186 f186 PsP186 Lam186bar S186bar Z1186bar Z2186bar Z3186bar Z4186bar;
parameters alph187 f187 PsP187 Lam187bar S187bar Z1187bar Z2187bar Z3187bar Z4187bar;
parameters alph188 f188 PsP188 Lam188bar S188bar Z1188bar Z2188bar Z3188bar Z4188bar;
parameters alph189 f189 PsP189 Lam189bar S189bar Z1189bar Z2189bar Z3189bar Z4189bar;
parameters alph190 f190 PsP190 Lam190bar S190bar Z1190bar Z2190bar Z3190bar Z4190bar;
parameters alph191 f191 PsP191 Lam191bar S191bar Z1191bar Z2191bar Z3191bar Z4191bar;
parameters alph192 f192 PsP192 Lam192bar S192bar Z1192bar Z2192bar Z3192bar Z4192bar;
parameters alph193 f193 PsP193 Lam193bar S193bar Z1193bar Z2193bar Z3193bar Z4193bar;
parameters alph194 f194 PsP194 Lam194bar S194bar Z1194bar Z2194bar Z3194bar Z4194bar;
parameters alph195 f195 PsP195 Lam195bar S195bar Z1195bar Z2195bar Z3195bar Z4195bar;
parameters alph196 f196 PsP196 Lam196bar S196bar Z1196bar Z2196bar Z3196bar Z4196bar;
parameters alph197 f197 PsP197 Lam197bar S197bar Z1197bar Z2197bar Z3197bar Z4197bar;
parameters alph198 f198 PsP198 Lam198bar S198bar Z1198bar Z2198bar Z3198bar Z4198bar;
parameters alph199 f199 PsP199 Lam199bar S199bar Z1199bar Z2199bar Z3199bar Z4199bar;
parameters alph200 f200 PsP200 Lam200bar S200bar Z1200bar Z2200bar Z3200bar Z4200bar;
parameters alph201 f201 PsP201 Lam201bar S201bar Z1201bar Z2201bar Z3201bar Z4201bar;
parameters alph202 f202 PsP202 Lam202bar S202bar Z1202bar Z2202bar Z3202bar Z4202bar;
parameters alph203 f203 PsP203 Lam203bar S203bar Z1203bar Z2203bar Z3203bar Z4203bar;
parameters alph204 f204 PsP204 Lam204bar S204bar Z1204bar Z2204bar Z3204bar Z4204bar;
parameters alph205 f205 PsP205 Lam205bar S205bar Z1205bar Z2205bar Z3205bar Z4205bar;
parameters alph206 f206 PsP206 Lam206bar S206bar Z1206bar Z2206bar Z3206bar Z4206bar;
parameters alph207 f207 PsP207 Lam207bar S207bar Z1207bar Z2207bar Z3207bar Z4207bar;
parameters alph208 f208 PsP208 Lam208bar S208bar Z1208bar Z2208bar Z3208bar Z4208bar;
parameters alph209 f209 PsP209 Lam209bar S209bar Z1209bar Z2209bar Z3209bar Z4209bar;
parameters alph210 f210 PsP210 Lam210bar S210bar Z1210bar Z2210bar Z3210bar Z4210bar;
parameters alph211 f211 PsP211 Lam211bar S211bar Z1211bar Z2211bar Z3211bar Z4211bar;
parameters alph212 f212 PsP212 Lam212bar S212bar Z1212bar Z2212bar Z3212bar Z4212bar;
parameters alph213 f213 PsP213 Lam213bar S213bar Z1213bar Z2213bar Z3213bar Z4213bar;
parameters alph214 f214 PsP214 Lam214bar S214bar Z1214bar Z2214bar Z3214bar Z4214bar;
parameters alph215 f215 PsP215 Lam215bar S215bar Z1215bar Z2215bar Z3215bar Z4215bar;
parameters alph216 f216 PsP216 Lam216bar S216bar Z1216bar Z2216bar Z3216bar Z4216bar;
parameters alph217 f217 PsP217 Lam217bar S217bar Z1217bar Z2217bar Z3217bar Z4217bar;
parameters alph218 f218 PsP218 Lam218bar S218bar Z1218bar Z2218bar Z3218bar Z4218bar;
parameters alph219 f219 PsP219 Lam219bar S219bar Z1219bar Z2219bar Z3219bar Z4219bar;
parameters alph220 f220 PsP220 Lam220bar S220bar Z1220bar Z2220bar Z3220bar Z4220bar;
parameters alph221 f221 PsP221 Lam221bar S221bar Z1221bar Z2221bar Z3221bar Z4221bar;
parameters alph222 f222 PsP222 Lam222bar S222bar Z1222bar Z2222bar Z3222bar Z4222bar;
parameters alph223 f223 PsP223 Lam223bar S223bar Z1223bar Z2223bar Z3223bar Z4223bar;
parameters alph224 f224 PsP224 Lam224bar S224bar Z1224bar Z2224bar Z3224bar Z4224bar;
parameters alph225 f225 PsP225 Lam225bar S225bar Z1225bar Z2225bar Z3225bar Z4225bar;
parameters alph226 f226 PsP226 Lam226bar S226bar Z1226bar Z2226bar Z3226bar Z4226bar;
parameters alph227 f227 PsP227 Lam227bar S227bar Z1227bar Z2227bar Z3227bar Z4227bar;
parameters alph228 f228 PsP228 Lam228bar S228bar Z1228bar Z2228bar Z3228bar Z4228bar;
parameters alph229 f229 PsP229 Lam229bar S229bar Z1229bar Z2229bar Z3229bar Z4229bar;
parameters alph230 f230 PsP230 Lam230bar S230bar Z1230bar Z2230bar Z3230bar Z4230bar;
parameters alph231 f231 PsP231 Lam231bar S231bar Z1231bar Z2231bar Z3231bar Z4231bar;
parameters alph232 f232 PsP232 Lam232bar S232bar Z1232bar Z2232bar Z3232bar Z4232bar;
parameters alph233 f233 PsP233 Lam233bar S233bar Z1233bar Z2233bar Z3233bar Z4233bar;
parameters alph234 f234 PsP234 Lam234bar S234bar Z1234bar Z2234bar Z3234bar Z4234bar;
parameters alph235 f235 PsP235 Lam235bar S235bar Z1235bar Z2235bar Z3235bar Z4235bar;
parameters alph236 f236 PsP236 Lam236bar S236bar Z1236bar Z2236bar Z3236bar Z4236bar;
parameters alph237 f237 PsP237 Lam237bar S237bar Z1237bar Z2237bar Z3237bar Z4237bar;
parameters alph238 f238 PsP238 Lam238bar S238bar Z1238bar Z2238bar Z3238bar Z4238bar;
parameters alph239 f239 PsP239 Lam239bar S239bar Z1239bar Z2239bar Z3239bar Z4239bar;
parameters alph240 f240 PsP240 Lam240bar S240bar Z1240bar Z2240bar Z3240bar Z4240bar;
parameters alph241 f241 PsP241 Lam241bar S241bar Z1241bar Z2241bar Z3241bar Z4241bar;
parameters alph242 f242 PsP242 Lam242bar S242bar Z1242bar Z2242bar Z3242bar Z4242bar;
parameters alph243 f243 PsP243 Lam243bar S243bar Z1243bar Z2243bar Z3243bar Z4243bar;
parameters alph244 f244 PsP244 Lam244bar S244bar Z1244bar Z2244bar Z3244bar Z4244bar;
parameters alph245 f245 PsP245 Lam245bar S245bar Z1245bar Z2245bar Z3245bar Z4245bar;
parameters alph246 f246 PsP246 Lam246bar S246bar Z1246bar Z2246bar Z3246bar Z4246bar;
parameters alph247 f247 PsP247 Lam247bar S247bar Z1247bar Z2247bar Z3247bar Z4247bar;
parameters alph248 f248 PsP248 Lam248bar S248bar Z1248bar Z2248bar Z3248bar Z4248bar;
parameters alph249 f249 PsP249 Lam249bar S249bar Z1249bar Z2249bar Z3249bar Z4249bar;
parameters alph250 f250 PsP250 Lam250bar S250bar Z1250bar Z2250bar Z3250bar Z4250bar;
parameters alph251 f251 PsP251 Lam251bar S251bar Z1251bar Z2251bar Z3251bar Z4251bar;
parameters alph252 f252 PsP252 Lam252bar S252bar Z1252bar Z2252bar Z3252bar Z4252bar;
parameters alph253 f253 PsP253 Lam253bar S253bar Z1253bar Z2253bar Z3253bar Z4253bar;
parameters alph254 f254 PsP254 Lam254bar S254bar Z1254bar Z2254bar Z3254bar Z4254bar;
parameters alph255 f255 PsP255 Lam255bar S255bar Z1255bar Z2255bar Z3255bar Z4255bar;
parameters alph256 f256 PsP256 Lam256bar S256bar Z1256bar Z2256bar Z3256bar Z4256bar;
parameters alph257 f257 PsP257 Lam257bar S257bar Z1257bar Z2257bar Z3257bar Z4257bar;
parameters alph258 f258 PsP258 Lam258bar S258bar Z1258bar Z2258bar Z3258bar Z4258bar;
parameters alph259 f259 PsP259 Lam259bar S259bar Z1259bar Z2259bar Z3259bar Z4259bar;
parameters alph260 f260 PsP260 Lam260bar S260bar Z1260bar Z2260bar Z3260bar Z4260bar;
parameters alph261 f261 PsP261 Lam261bar S261bar Z1261bar Z2261bar Z3261bar Z4261bar;
parameters alph262 f262 PsP262 Lam262bar S262bar Z1262bar Z2262bar Z3262bar Z4262bar;
parameters alph263 f263 PsP263 Lam263bar S263bar Z1263bar Z2263bar Z3263bar Z4263bar;
parameters alph264 f264 PsP264 Lam264bar S264bar Z1264bar Z2264bar Z3264bar Z4264bar;
parameters alph265 f265 PsP265 Lam265bar S265bar Z1265bar Z2265bar Z3265bar Z4265bar;
parameters alph266 f266 PsP266 Lam266bar S266bar Z1266bar Z2266bar Z3266bar Z4266bar;
parameters alph267 f267 PsP267 Lam267bar S267bar Z1267bar Z2267bar Z3267bar Z4267bar;
parameters alph268 f268 PsP268 Lam268bar S268bar Z1268bar Z2268bar Z3268bar Z4268bar;
parameters alph269 f269 PsP269 Lam269bar S269bar Z1269bar Z2269bar Z3269bar Z4269bar;
parameters alph270 f270 PsP270 Lam270bar S270bar Z1270bar Z2270bar Z3270bar Z4270bar;
parameters alph271 f271 PsP271 Lam271bar S271bar Z1271bar Z2271bar Z3271bar Z4271bar;
parameters alph272 f272 PsP272 Lam272bar S272bar Z1272bar Z2272bar Z3272bar Z4272bar;

% calibrated parameters

Pibar   = (1.0275)^(1/4); % estimate of Carvalho, Nechio, Tristao (2021) Volcker-Greenspan
varphi  = 1;
bet     = 0.99;
theta   = 10;
chi     = 8;
sigm    = 1;
ppsi    = 1.1; % 1.0001

rhoi    = 0.55; % estimate of Carvalho, Nechio, Tristao (2021) rhoi1+rhoi2

phipi   = 0;
phiy    = 0;

J = 272;

%% load Nakamura-Setinsson frequencies
% d_regular | d_posted | weight (monthly duration)

NS_duration = load('duration_weight.txt');

d1 = NS_duration(:,1)/3;
d2 = NS_duration(:,2)/3;
weight = NS_duration(:,3);
weight = weight/sum(weight);

alpha1 = 1 - exp(-1./d1);
alpha2 = 1 - exp(-1./d2);

alpha1_mean = sum(weight.*alpha1);
alpha2_mean = sum(weight.*alpha2);

alphj   = alpha1;
fj      = weight;

phipis  = 0:0.002:2.5;
phiyinc = 0.002; phiys  = (0:phiyinc:2);

phipin  = length(phipis);
phiyn   = length(phiys);

phipin  = length(phipis);

detchk  = nan(phipin,phiyn);
bnds    = cell(phipin,1);

%% solve for the steady state

% upper_Pibar = (1/bet/(1-min(alphs)))^(1/theta/2);
% if (Pibar > upper_Pibar)
%     break;
% end

ff = @(x) func_kinked_linear_NS_SS(x,J,bet,alphj,fj,Pibar,theta,sigm,chi,ppsi);
x0 = ones(J+1,1);
[x,fval,exitf] = fsolve(ff,x0,options);

if (exitf<1)
    error('SS not solved!')
end

Ybar          = exp(x(1));
PsPj          = exp(x(2:end));

Lam_j_powered = alphj./(1-(1-alphj)*Pibar^(theta*(1-ppsi)-1)).*(PsPj.^(1-theta*(1-ppsi)));
Lambarj       = Lam_j_powered.^(1/(1-theta*(1-ppsi)));

Lambar        = (transpose(weight)*Lam_j_powered)^(1/(1-theta*(1-ppsi)));

Sbarj         = alphj./(1-(1-alphj)/Pibar).*PsPj;

Z1barj        = Lambar^(theta*(1-ppsi))*Ybar^(1-sigm)./(1-bet*(1-alphj)*Pibar^(theta*(1-ppsi)-1));
Z2barj        = Ybar^(1-sigm)./(1-bet*(1-alphj)/Pibar);
Z3barj        = Lambar^(2*theta*(1-ppsi))*Ybar^2./(1-bet*(1-alphj)*Pibar^(2*theta*(1-ppsi)));
Z4barj        = Lambar^(theta*(1-ppsi))*Ybar^2./(1-bet*(1-alphj)*Pibar^(theta*(1-ppsi)));

% assign parameter values

% for indj=1:J

% eval(sprintf('alph%03i   = alphj(%03i);',indj,indj));
% eval(sprintf('f%03i      = fj(%03i);',indj,indj));
% eval(sprintf('PsP%03i    = PsPj(%03i);',indj,indj));
% eval(sprintf('Lam%03ibar = Lambarj(%03i);',indj,indj));
% eval(sprintf('S%03ibar   = Sbarj(%03i);',indj,indj));
% eval(sprintf('Z1%03ibar  = Z1barj(%03i);',indj,indj));
% eval(sprintf('Z2%03ibar  = Z2barj(%03i);',indj,indj));
% eval(sprintf('Z3%03ibar  = Z3barj(%03i);',indj,indj));
% eval(sprintf('Z4%03ibar  = Z4barj(%03i);',indj,indj));

% end

alph001   = alphj(001);
f001      = fj(001);
PsP001    = PsPj(001);
Lam001bar = Lambarj(001);
S001bar   = Sbarj(001);
Z1001bar  = Z1barj(001);
Z2001bar  = Z2barj(001);
Z3001bar  = Z3barj(001);
Z4001bar  = Z4barj(001);

alph002   = alphj(002);
f002      = fj(002);
PsP002    = PsPj(002);
Lam002bar = Lambarj(002);
S002bar   = Sbarj(002);
Z1002bar  = Z1barj(002);
Z2002bar  = Z2barj(002);
Z3002bar  = Z3barj(002);
Z4002bar  = Z4barj(002);

alph003   = alphj(003);
f003      = fj(003);
PsP003    = PsPj(003);
Lam003bar = Lambarj(003);
S003bar   = Sbarj(003);
Z1003bar  = Z1barj(003);
Z2003bar  = Z2barj(003);
Z3003bar  = Z3barj(003);
Z4003bar  = Z4barj(003);

alph004   = alphj(004);
f004      = fj(004);
PsP004    = PsPj(004);
Lam004bar = Lambarj(004);
S004bar   = Sbarj(004);
Z1004bar  = Z1barj(004);
Z2004bar  = Z2barj(004);
Z3004bar  = Z3barj(004);
Z4004bar  = Z4barj(004);

alph005   = alphj(005);
f005      = fj(005);
PsP005    = PsPj(005);
Lam005bar = Lambarj(005);
S005bar   = Sbarj(005);
Z1005bar  = Z1barj(005);
Z2005bar  = Z2barj(005);
Z3005bar  = Z3barj(005);
Z4005bar  = Z4barj(005);

alph006   = alphj(006);
f006      = fj(006);
PsP006    = PsPj(006);
Lam006bar = Lambarj(006);
S006bar   = Sbarj(006);
Z1006bar  = Z1barj(006);
Z2006bar  = Z2barj(006);
Z3006bar  = Z3barj(006);
Z4006bar  = Z4barj(006);

alph007   = alphj(007);
f007      = fj(007);
PsP007    = PsPj(007);
Lam007bar = Lambarj(007);
S007bar   = Sbarj(007);
Z1007bar  = Z1barj(007);
Z2007bar  = Z2barj(007);
Z3007bar  = Z3barj(007);
Z4007bar  = Z4barj(007);

alph008   = alphj(008);
f008      = fj(008);
PsP008    = PsPj(008);
Lam008bar = Lambarj(008);
S008bar   = Sbarj(008);
Z1008bar  = Z1barj(008);
Z2008bar  = Z2barj(008);
Z3008bar  = Z3barj(008);
Z4008bar  = Z4barj(008);

alph009   = alphj(009);
f009      = fj(009);
PsP009    = PsPj(009);
Lam009bar = Lambarj(009);
S009bar   = Sbarj(009);
Z1009bar  = Z1barj(009);
Z2009bar  = Z2barj(009);
Z3009bar  = Z3barj(009);
Z4009bar  = Z4barj(009);

alph010   = alphj(010);
f010      = fj(010);
PsP010    = PsPj(010);
Lam010bar = Lambarj(010);
S010bar   = Sbarj(010);
Z1010bar  = Z1barj(010);
Z2010bar  = Z2barj(010);
Z3010bar  = Z3barj(010);
Z4010bar  = Z4barj(010);

alph011   = alphj(011);
f011      = fj(011);
PsP011    = PsPj(011);
Lam011bar = Lambarj(011);
S011bar   = Sbarj(011);
Z1011bar  = Z1barj(011);
Z2011bar  = Z2barj(011);
Z3011bar  = Z3barj(011);
Z4011bar  = Z4barj(011);

alph012   = alphj(012);
f012      = fj(012);
PsP012    = PsPj(012);
Lam012bar = Lambarj(012);
S012bar   = Sbarj(012);
Z1012bar  = Z1barj(012);
Z2012bar  = Z2barj(012);
Z3012bar  = Z3barj(012);
Z4012bar  = Z4barj(012);

alph013   = alphj(013);
f013      = fj(013);
PsP013    = PsPj(013);
Lam013bar = Lambarj(013);
S013bar   = Sbarj(013);
Z1013bar  = Z1barj(013);
Z2013bar  = Z2barj(013);
Z3013bar  = Z3barj(013);
Z4013bar  = Z4barj(013);

alph014   = alphj(014);
f014      = fj(014);
PsP014    = PsPj(014);
Lam014bar = Lambarj(014);
S014bar   = Sbarj(014);
Z1014bar  = Z1barj(014);
Z2014bar  = Z2barj(014);
Z3014bar  = Z3barj(014);
Z4014bar  = Z4barj(014);

alph015   = alphj(015);
f015      = fj(015);
PsP015    = PsPj(015);
Lam015bar = Lambarj(015);
S015bar   = Sbarj(015);
Z1015bar  = Z1barj(015);
Z2015bar  = Z2barj(015);
Z3015bar  = Z3barj(015);
Z4015bar  = Z4barj(015);

alph016   = alphj(016);
f016      = fj(016);
PsP016    = PsPj(016);
Lam016bar = Lambarj(016);
S016bar   = Sbarj(016);
Z1016bar  = Z1barj(016);
Z2016bar  = Z2barj(016);
Z3016bar  = Z3barj(016);
Z4016bar  = Z4barj(016);

alph017   = alphj(017);
f017      = fj(017);
PsP017    = PsPj(017);
Lam017bar = Lambarj(017);
S017bar   = Sbarj(017);
Z1017bar  = Z1barj(017);
Z2017bar  = Z2barj(017);
Z3017bar  = Z3barj(017);
Z4017bar  = Z4barj(017);

alph018   = alphj(018);
f018      = fj(018);
PsP018    = PsPj(018);
Lam018bar = Lambarj(018);
S018bar   = Sbarj(018);
Z1018bar  = Z1barj(018);
Z2018bar  = Z2barj(018);
Z3018bar  = Z3barj(018);
Z4018bar  = Z4barj(018);

alph019   = alphj(019);
f019      = fj(019);
PsP019    = PsPj(019);
Lam019bar = Lambarj(019);
S019bar   = Sbarj(019);
Z1019bar  = Z1barj(019);
Z2019bar  = Z2barj(019);
Z3019bar  = Z3barj(019);
Z4019bar  = Z4barj(019);

alph020   = alphj(020);
f020      = fj(020);
PsP020    = PsPj(020);
Lam020bar = Lambarj(020);
S020bar   = Sbarj(020);
Z1020bar  = Z1barj(020);
Z2020bar  = Z2barj(020);
Z3020bar  = Z3barj(020);
Z4020bar  = Z4barj(020);

alph021   = alphj(021);
f021      = fj(021);
PsP021    = PsPj(021);
Lam021bar = Lambarj(021);
S021bar   = Sbarj(021);
Z1021bar  = Z1barj(021);
Z2021bar  = Z2barj(021);
Z3021bar  = Z3barj(021);
Z4021bar  = Z4barj(021);

alph022   = alphj(022);
f022      = fj(022);
PsP022    = PsPj(022);
Lam022bar = Lambarj(022);
S022bar   = Sbarj(022);
Z1022bar  = Z1barj(022);
Z2022bar  = Z2barj(022);
Z3022bar  = Z3barj(022);
Z4022bar  = Z4barj(022);

alph023   = alphj(023);
f023      = fj(023);
PsP023    = PsPj(023);
Lam023bar = Lambarj(023);
S023bar   = Sbarj(023);
Z1023bar  = Z1barj(023);
Z2023bar  = Z2barj(023);
Z3023bar  = Z3barj(023);
Z4023bar  = Z4barj(023);

alph024   = alphj(024);
f024      = fj(024);
PsP024    = PsPj(024);
Lam024bar = Lambarj(024);
S024bar   = Sbarj(024);
Z1024bar  = Z1barj(024);
Z2024bar  = Z2barj(024);
Z3024bar  = Z3barj(024);
Z4024bar  = Z4barj(024);

alph025   = alphj(025);
f025      = fj(025);
PsP025    = PsPj(025);
Lam025bar = Lambarj(025);
S025bar   = Sbarj(025);
Z1025bar  = Z1barj(025);
Z2025bar  = Z2barj(025);
Z3025bar  = Z3barj(025);
Z4025bar  = Z4barj(025);

alph026   = alphj(026);
f026      = fj(026);
PsP026    = PsPj(026);
Lam026bar = Lambarj(026);
S026bar   = Sbarj(026);
Z1026bar  = Z1barj(026);
Z2026bar  = Z2barj(026);
Z3026bar  = Z3barj(026);
Z4026bar  = Z4barj(026);

alph027   = alphj(027);
f027      = fj(027);
PsP027    = PsPj(027);
Lam027bar = Lambarj(027);
S027bar   = Sbarj(027);
Z1027bar  = Z1barj(027);
Z2027bar  = Z2barj(027);
Z3027bar  = Z3barj(027);
Z4027bar  = Z4barj(027);

alph028   = alphj(028);
f028      = fj(028);
PsP028    = PsPj(028);
Lam028bar = Lambarj(028);
S028bar   = Sbarj(028);
Z1028bar  = Z1barj(028);
Z2028bar  = Z2barj(028);
Z3028bar  = Z3barj(028);
Z4028bar  = Z4barj(028);

alph029   = alphj(029);
f029      = fj(029);
PsP029    = PsPj(029);
Lam029bar = Lambarj(029);
S029bar   = Sbarj(029);
Z1029bar  = Z1barj(029);
Z2029bar  = Z2barj(029);
Z3029bar  = Z3barj(029);
Z4029bar  = Z4barj(029);

alph030   = alphj(030);
f030      = fj(030);
PsP030    = PsPj(030);
Lam030bar = Lambarj(030);
S030bar   = Sbarj(030);
Z1030bar  = Z1barj(030);
Z2030bar  = Z2barj(030);
Z3030bar  = Z3barj(030);
Z4030bar  = Z4barj(030);

alph031   = alphj(031);
f031      = fj(031);
PsP031    = PsPj(031);
Lam031bar = Lambarj(031);
S031bar   = Sbarj(031);
Z1031bar  = Z1barj(031);
Z2031bar  = Z2barj(031);
Z3031bar  = Z3barj(031);
Z4031bar  = Z4barj(031);

alph032   = alphj(032);
f032      = fj(032);
PsP032    = PsPj(032);
Lam032bar = Lambarj(032);
S032bar   = Sbarj(032);
Z1032bar  = Z1barj(032);
Z2032bar  = Z2barj(032);
Z3032bar  = Z3barj(032);
Z4032bar  = Z4barj(032);

alph033   = alphj(033);
f033      = fj(033);
PsP033    = PsPj(033);
Lam033bar = Lambarj(033);
S033bar   = Sbarj(033);
Z1033bar  = Z1barj(033);
Z2033bar  = Z2barj(033);
Z3033bar  = Z3barj(033);
Z4033bar  = Z4barj(033);

alph034   = alphj(034);
f034      = fj(034);
PsP034    = PsPj(034);
Lam034bar = Lambarj(034);
S034bar   = Sbarj(034);
Z1034bar  = Z1barj(034);
Z2034bar  = Z2barj(034);
Z3034bar  = Z3barj(034);
Z4034bar  = Z4barj(034);

alph035   = alphj(035);
f035      = fj(035);
PsP035    = PsPj(035);
Lam035bar = Lambarj(035);
S035bar   = Sbarj(035);
Z1035bar  = Z1barj(035);
Z2035bar  = Z2barj(035);
Z3035bar  = Z3barj(035);
Z4035bar  = Z4barj(035);

alph036   = alphj(036);
f036      = fj(036);
PsP036    = PsPj(036);
Lam036bar = Lambarj(036);
S036bar   = Sbarj(036);
Z1036bar  = Z1barj(036);
Z2036bar  = Z2barj(036);
Z3036bar  = Z3barj(036);
Z4036bar  = Z4barj(036);

alph037   = alphj(037);
f037      = fj(037);
PsP037    = PsPj(037);
Lam037bar = Lambarj(037);
S037bar   = Sbarj(037);
Z1037bar  = Z1barj(037);
Z2037bar  = Z2barj(037);
Z3037bar  = Z3barj(037);
Z4037bar  = Z4barj(037);

alph038   = alphj(038);
f038      = fj(038);
PsP038    = PsPj(038);
Lam038bar = Lambarj(038);
S038bar   = Sbarj(038);
Z1038bar  = Z1barj(038);
Z2038bar  = Z2barj(038);
Z3038bar  = Z3barj(038);
Z4038bar  = Z4barj(038);

alph039   = alphj(039);
f039      = fj(039);
PsP039    = PsPj(039);
Lam039bar = Lambarj(039);
S039bar   = Sbarj(039);
Z1039bar  = Z1barj(039);
Z2039bar  = Z2barj(039);
Z3039bar  = Z3barj(039);
Z4039bar  = Z4barj(039);

alph040   = alphj(040);
f040      = fj(040);
PsP040    = PsPj(040);
Lam040bar = Lambarj(040);
S040bar   = Sbarj(040);
Z1040bar  = Z1barj(040);
Z2040bar  = Z2barj(040);
Z3040bar  = Z3barj(040);
Z4040bar  = Z4barj(040);

alph041   = alphj(041);
f041      = fj(041);
PsP041    = PsPj(041);
Lam041bar = Lambarj(041);
S041bar   = Sbarj(041);
Z1041bar  = Z1barj(041);
Z2041bar  = Z2barj(041);
Z3041bar  = Z3barj(041);
Z4041bar  = Z4barj(041);

alph042   = alphj(042);
f042      = fj(042);
PsP042    = PsPj(042);
Lam042bar = Lambarj(042);
S042bar   = Sbarj(042);
Z1042bar  = Z1barj(042);
Z2042bar  = Z2barj(042);
Z3042bar  = Z3barj(042);
Z4042bar  = Z4barj(042);

alph043   = alphj(043);
f043      = fj(043);
PsP043    = PsPj(043);
Lam043bar = Lambarj(043);
S043bar   = Sbarj(043);
Z1043bar  = Z1barj(043);
Z2043bar  = Z2barj(043);
Z3043bar  = Z3barj(043);
Z4043bar  = Z4barj(043);

alph044   = alphj(044);
f044      = fj(044);
PsP044    = PsPj(044);
Lam044bar = Lambarj(044);
S044bar   = Sbarj(044);
Z1044bar  = Z1barj(044);
Z2044bar  = Z2barj(044);
Z3044bar  = Z3barj(044);
Z4044bar  = Z4barj(044);

alph045   = alphj(045);
f045      = fj(045);
PsP045    = PsPj(045);
Lam045bar = Lambarj(045);
S045bar   = Sbarj(045);
Z1045bar  = Z1barj(045);
Z2045bar  = Z2barj(045);
Z3045bar  = Z3barj(045);
Z4045bar  = Z4barj(045);

alph046   = alphj(046);
f046      = fj(046);
PsP046    = PsPj(046);
Lam046bar = Lambarj(046);
S046bar   = Sbarj(046);
Z1046bar  = Z1barj(046);
Z2046bar  = Z2barj(046);
Z3046bar  = Z3barj(046);
Z4046bar  = Z4barj(046);

alph047   = alphj(047);
f047      = fj(047);
PsP047    = PsPj(047);
Lam047bar = Lambarj(047);
S047bar   = Sbarj(047);
Z1047bar  = Z1barj(047);
Z2047bar  = Z2barj(047);
Z3047bar  = Z3barj(047);
Z4047bar  = Z4barj(047);

alph048   = alphj(048);
f048      = fj(048);
PsP048    = PsPj(048);
Lam048bar = Lambarj(048);
S048bar   = Sbarj(048);
Z1048bar  = Z1barj(048);
Z2048bar  = Z2barj(048);
Z3048bar  = Z3barj(048);
Z4048bar  = Z4barj(048);

alph049   = alphj(049);
f049      = fj(049);
PsP049    = PsPj(049);
Lam049bar = Lambarj(049);
S049bar   = Sbarj(049);
Z1049bar  = Z1barj(049);
Z2049bar  = Z2barj(049);
Z3049bar  = Z3barj(049);
Z4049bar  = Z4barj(049);

alph050   = alphj(050);
f050      = fj(050);
PsP050    = PsPj(050);
Lam050bar = Lambarj(050);
S050bar   = Sbarj(050);
Z1050bar  = Z1barj(050);
Z2050bar  = Z2barj(050);
Z3050bar  = Z3barj(050);
Z4050bar  = Z4barj(050);

alph051   = alphj(051);
f051      = fj(051);
PsP051    = PsPj(051);
Lam051bar = Lambarj(051);
S051bar   = Sbarj(051);
Z1051bar  = Z1barj(051);
Z2051bar  = Z2barj(051);
Z3051bar  = Z3barj(051);
Z4051bar  = Z4barj(051);

alph052   = alphj(052);
f052      = fj(052);
PsP052    = PsPj(052);
Lam052bar = Lambarj(052);
S052bar   = Sbarj(052);
Z1052bar  = Z1barj(052);
Z2052bar  = Z2barj(052);
Z3052bar  = Z3barj(052);
Z4052bar  = Z4barj(052);

alph053   = alphj(053);
f053      = fj(053);
PsP053    = PsPj(053);
Lam053bar = Lambarj(053);
S053bar   = Sbarj(053);
Z1053bar  = Z1barj(053);
Z2053bar  = Z2barj(053);
Z3053bar  = Z3barj(053);
Z4053bar  = Z4barj(053);

alph054   = alphj(054);
f054      = fj(054);
PsP054    = PsPj(054);
Lam054bar = Lambarj(054);
S054bar   = Sbarj(054);
Z1054bar  = Z1barj(054);
Z2054bar  = Z2barj(054);
Z3054bar  = Z3barj(054);
Z4054bar  = Z4barj(054);

alph055   = alphj(055);
f055      = fj(055);
PsP055    = PsPj(055);
Lam055bar = Lambarj(055);
S055bar   = Sbarj(055);
Z1055bar  = Z1barj(055);
Z2055bar  = Z2barj(055);
Z3055bar  = Z3barj(055);
Z4055bar  = Z4barj(055);

alph056   = alphj(056);
f056      = fj(056);
PsP056    = PsPj(056);
Lam056bar = Lambarj(056);
S056bar   = Sbarj(056);
Z1056bar  = Z1barj(056);
Z2056bar  = Z2barj(056);
Z3056bar  = Z3barj(056);
Z4056bar  = Z4barj(056);

alph057   = alphj(057);
f057      = fj(057);
PsP057    = PsPj(057);
Lam057bar = Lambarj(057);
S057bar   = Sbarj(057);
Z1057bar  = Z1barj(057);
Z2057bar  = Z2barj(057);
Z3057bar  = Z3barj(057);
Z4057bar  = Z4barj(057);

alph058   = alphj(058);
f058      = fj(058);
PsP058    = PsPj(058);
Lam058bar = Lambarj(058);
S058bar   = Sbarj(058);
Z1058bar  = Z1barj(058);
Z2058bar  = Z2barj(058);
Z3058bar  = Z3barj(058);
Z4058bar  = Z4barj(058);

alph059   = alphj(059);
f059      = fj(059);
PsP059    = PsPj(059);
Lam059bar = Lambarj(059);
S059bar   = Sbarj(059);
Z1059bar  = Z1barj(059);
Z2059bar  = Z2barj(059);
Z3059bar  = Z3barj(059);
Z4059bar  = Z4barj(059);

alph060   = alphj(060);
f060      = fj(060);
PsP060    = PsPj(060);
Lam060bar = Lambarj(060);
S060bar   = Sbarj(060);
Z1060bar  = Z1barj(060);
Z2060bar  = Z2barj(060);
Z3060bar  = Z3barj(060);
Z4060bar  = Z4barj(060);

alph061   = alphj(061);
f061      = fj(061);
PsP061    = PsPj(061);
Lam061bar = Lambarj(061);
S061bar   = Sbarj(061);
Z1061bar  = Z1barj(061);
Z2061bar  = Z2barj(061);
Z3061bar  = Z3barj(061);
Z4061bar  = Z4barj(061);

alph062   = alphj(062);
f062      = fj(062);
PsP062    = PsPj(062);
Lam062bar = Lambarj(062);
S062bar   = Sbarj(062);
Z1062bar  = Z1barj(062);
Z2062bar  = Z2barj(062);
Z3062bar  = Z3barj(062);
Z4062bar  = Z4barj(062);

alph063   = alphj(063);
f063      = fj(063);
PsP063    = PsPj(063);
Lam063bar = Lambarj(063);
S063bar   = Sbarj(063);
Z1063bar  = Z1barj(063);
Z2063bar  = Z2barj(063);
Z3063bar  = Z3barj(063);
Z4063bar  = Z4barj(063);

alph064   = alphj(064);
f064      = fj(064);
PsP064    = PsPj(064);
Lam064bar = Lambarj(064);
S064bar   = Sbarj(064);
Z1064bar  = Z1barj(064);
Z2064bar  = Z2barj(064);
Z3064bar  = Z3barj(064);
Z4064bar  = Z4barj(064);

alph065   = alphj(065);
f065      = fj(065);
PsP065    = PsPj(065);
Lam065bar = Lambarj(065);
S065bar   = Sbarj(065);
Z1065bar  = Z1barj(065);
Z2065bar  = Z2barj(065);
Z3065bar  = Z3barj(065);
Z4065bar  = Z4barj(065);

alph066   = alphj(066);
f066      = fj(066);
PsP066    = PsPj(066);
Lam066bar = Lambarj(066);
S066bar   = Sbarj(066);
Z1066bar  = Z1barj(066);
Z2066bar  = Z2barj(066);
Z3066bar  = Z3barj(066);
Z4066bar  = Z4barj(066);

alph067   = alphj(067);
f067      = fj(067);
PsP067    = PsPj(067);
Lam067bar = Lambarj(067);
S067bar   = Sbarj(067);
Z1067bar  = Z1barj(067);
Z2067bar  = Z2barj(067);
Z3067bar  = Z3barj(067);
Z4067bar  = Z4barj(067);

alph068   = alphj(068);
f068      = fj(068);
PsP068    = PsPj(068);
Lam068bar = Lambarj(068);
S068bar   = Sbarj(068);
Z1068bar  = Z1barj(068);
Z2068bar  = Z2barj(068);
Z3068bar  = Z3barj(068);
Z4068bar  = Z4barj(068);

alph069   = alphj(069);
f069      = fj(069);
PsP069    = PsPj(069);
Lam069bar = Lambarj(069);
S069bar   = Sbarj(069);
Z1069bar  = Z1barj(069);
Z2069bar  = Z2barj(069);
Z3069bar  = Z3barj(069);
Z4069bar  = Z4barj(069);

alph070   = alphj(070);
f070      = fj(070);
PsP070    = PsPj(070);
Lam070bar = Lambarj(070);
S070bar   = Sbarj(070);
Z1070bar  = Z1barj(070);
Z2070bar  = Z2barj(070);
Z3070bar  = Z3barj(070);
Z4070bar  = Z4barj(070);

alph071   = alphj(071);
f071      = fj(071);
PsP071    = PsPj(071);
Lam071bar = Lambarj(071);
S071bar   = Sbarj(071);
Z1071bar  = Z1barj(071);
Z2071bar  = Z2barj(071);
Z3071bar  = Z3barj(071);
Z4071bar  = Z4barj(071);

alph072   = alphj(072);
f072      = fj(072);
PsP072    = PsPj(072);
Lam072bar = Lambarj(072);
S072bar   = Sbarj(072);
Z1072bar  = Z1barj(072);
Z2072bar  = Z2barj(072);
Z3072bar  = Z3barj(072);
Z4072bar  = Z4barj(072);

alph073   = alphj(073);
f073      = fj(073);
PsP073    = PsPj(073);
Lam073bar = Lambarj(073);
S073bar   = Sbarj(073);
Z1073bar  = Z1barj(073);
Z2073bar  = Z2barj(073);
Z3073bar  = Z3barj(073);
Z4073bar  = Z4barj(073);

alph074   = alphj(074);
f074      = fj(074);
PsP074    = PsPj(074);
Lam074bar = Lambarj(074);
S074bar   = Sbarj(074);
Z1074bar  = Z1barj(074);
Z2074bar  = Z2barj(074);
Z3074bar  = Z3barj(074);
Z4074bar  = Z4barj(074);

alph075   = alphj(075);
f075      = fj(075);
PsP075    = PsPj(075);
Lam075bar = Lambarj(075);
S075bar   = Sbarj(075);
Z1075bar  = Z1barj(075);
Z2075bar  = Z2barj(075);
Z3075bar  = Z3barj(075);
Z4075bar  = Z4barj(075);

alph076   = alphj(076);
f076      = fj(076);
PsP076    = PsPj(076);
Lam076bar = Lambarj(076);
S076bar   = Sbarj(076);
Z1076bar  = Z1barj(076);
Z2076bar  = Z2barj(076);
Z3076bar  = Z3barj(076);
Z4076bar  = Z4barj(076);

alph077   = alphj(077);
f077      = fj(077);
PsP077    = PsPj(077);
Lam077bar = Lambarj(077);
S077bar   = Sbarj(077);
Z1077bar  = Z1barj(077);
Z2077bar  = Z2barj(077);
Z3077bar  = Z3barj(077);
Z4077bar  = Z4barj(077);

alph078   = alphj(078);
f078      = fj(078);
PsP078    = PsPj(078);
Lam078bar = Lambarj(078);
S078bar   = Sbarj(078);
Z1078bar  = Z1barj(078);
Z2078bar  = Z2barj(078);
Z3078bar  = Z3barj(078);
Z4078bar  = Z4barj(078);

alph079   = alphj(079);
f079      = fj(079);
PsP079    = PsPj(079);
Lam079bar = Lambarj(079);
S079bar   = Sbarj(079);
Z1079bar  = Z1barj(079);
Z2079bar  = Z2barj(079);
Z3079bar  = Z3barj(079);
Z4079bar  = Z4barj(079);

alph080   = alphj(080);
f080      = fj(080);
PsP080    = PsPj(080);
Lam080bar = Lambarj(080);
S080bar   = Sbarj(080);
Z1080bar  = Z1barj(080);
Z2080bar  = Z2barj(080);
Z3080bar  = Z3barj(080);
Z4080bar  = Z4barj(080);

alph081   = alphj(081);
f081      = fj(081);
PsP081    = PsPj(081);
Lam081bar = Lambarj(081);
S081bar   = Sbarj(081);
Z1081bar  = Z1barj(081);
Z2081bar  = Z2barj(081);
Z3081bar  = Z3barj(081);
Z4081bar  = Z4barj(081);

alph082   = alphj(082);
f082      = fj(082);
PsP082    = PsPj(082);
Lam082bar = Lambarj(082);
S082bar   = Sbarj(082);
Z1082bar  = Z1barj(082);
Z2082bar  = Z2barj(082);
Z3082bar  = Z3barj(082);
Z4082bar  = Z4barj(082);

alph083   = alphj(083);
f083      = fj(083);
PsP083    = PsPj(083);
Lam083bar = Lambarj(083);
S083bar   = Sbarj(083);
Z1083bar  = Z1barj(083);
Z2083bar  = Z2barj(083);
Z3083bar  = Z3barj(083);
Z4083bar  = Z4barj(083);

alph084   = alphj(084);
f084      = fj(084);
PsP084    = PsPj(084);
Lam084bar = Lambarj(084);
S084bar   = Sbarj(084);
Z1084bar  = Z1barj(084);
Z2084bar  = Z2barj(084);
Z3084bar  = Z3barj(084);
Z4084bar  = Z4barj(084);

alph085   = alphj(085);
f085      = fj(085);
PsP085    = PsPj(085);
Lam085bar = Lambarj(085);
S085bar   = Sbarj(085);
Z1085bar  = Z1barj(085);
Z2085bar  = Z2barj(085);
Z3085bar  = Z3barj(085);
Z4085bar  = Z4barj(085);

alph086   = alphj(086);
f086      = fj(086);
PsP086    = PsPj(086);
Lam086bar = Lambarj(086);
S086bar   = Sbarj(086);
Z1086bar  = Z1barj(086);
Z2086bar  = Z2barj(086);
Z3086bar  = Z3barj(086);
Z4086bar  = Z4barj(086);

alph087   = alphj(087);
f087      = fj(087);
PsP087    = PsPj(087);
Lam087bar = Lambarj(087);
S087bar   = Sbarj(087);
Z1087bar  = Z1barj(087);
Z2087bar  = Z2barj(087);
Z3087bar  = Z3barj(087);
Z4087bar  = Z4barj(087);

alph088   = alphj(088);
f088      = fj(088);
PsP088    = PsPj(088);
Lam088bar = Lambarj(088);
S088bar   = Sbarj(088);
Z1088bar  = Z1barj(088);
Z2088bar  = Z2barj(088);
Z3088bar  = Z3barj(088);
Z4088bar  = Z4barj(088);

alph089   = alphj(089);
f089      = fj(089);
PsP089    = PsPj(089);
Lam089bar = Lambarj(089);
S089bar   = Sbarj(089);
Z1089bar  = Z1barj(089);
Z2089bar  = Z2barj(089);
Z3089bar  = Z3barj(089);
Z4089bar  = Z4barj(089);

alph090   = alphj(090);
f090      = fj(090);
PsP090    = PsPj(090);
Lam090bar = Lambarj(090);
S090bar   = Sbarj(090);
Z1090bar  = Z1barj(090);
Z2090bar  = Z2barj(090);
Z3090bar  = Z3barj(090);
Z4090bar  = Z4barj(090);

alph091   = alphj(091);
f091      = fj(091);
PsP091    = PsPj(091);
Lam091bar = Lambarj(091);
S091bar   = Sbarj(091);
Z1091bar  = Z1barj(091);
Z2091bar  = Z2barj(091);
Z3091bar  = Z3barj(091);
Z4091bar  = Z4barj(091);

alph092   = alphj(092);
f092      = fj(092);
PsP092    = PsPj(092);
Lam092bar = Lambarj(092);
S092bar   = Sbarj(092);
Z1092bar  = Z1barj(092);
Z2092bar  = Z2barj(092);
Z3092bar  = Z3barj(092);
Z4092bar  = Z4barj(092);

alph093   = alphj(093);
f093      = fj(093);
PsP093    = PsPj(093);
Lam093bar = Lambarj(093);
S093bar   = Sbarj(093);
Z1093bar  = Z1barj(093);
Z2093bar  = Z2barj(093);
Z3093bar  = Z3barj(093);
Z4093bar  = Z4barj(093);

alph094   = alphj(094);
f094      = fj(094);
PsP094    = PsPj(094);
Lam094bar = Lambarj(094);
S094bar   = Sbarj(094);
Z1094bar  = Z1barj(094);
Z2094bar  = Z2barj(094);
Z3094bar  = Z3barj(094);
Z4094bar  = Z4barj(094);

alph095   = alphj(095);
f095      = fj(095);
PsP095    = PsPj(095);
Lam095bar = Lambarj(095);
S095bar   = Sbarj(095);
Z1095bar  = Z1barj(095);
Z2095bar  = Z2barj(095);
Z3095bar  = Z3barj(095);
Z4095bar  = Z4barj(095);

alph096   = alphj(096);
f096      = fj(096);
PsP096    = PsPj(096);
Lam096bar = Lambarj(096);
S096bar   = Sbarj(096);
Z1096bar  = Z1barj(096);
Z2096bar  = Z2barj(096);
Z3096bar  = Z3barj(096);
Z4096bar  = Z4barj(096);

alph097   = alphj(097);
f097      = fj(097);
PsP097    = PsPj(097);
Lam097bar = Lambarj(097);
S097bar   = Sbarj(097);
Z1097bar  = Z1barj(097);
Z2097bar  = Z2barj(097);
Z3097bar  = Z3barj(097);
Z4097bar  = Z4barj(097);

alph098   = alphj(098);
f098      = fj(098);
PsP098    = PsPj(098);
Lam098bar = Lambarj(098);
S098bar   = Sbarj(098);
Z1098bar  = Z1barj(098);
Z2098bar  = Z2barj(098);
Z3098bar  = Z3barj(098);
Z4098bar  = Z4barj(098);

alph099   = alphj(099);
f099      = fj(099);
PsP099    = PsPj(099);
Lam099bar = Lambarj(099);
S099bar   = Sbarj(099);
Z1099bar  = Z1barj(099);
Z2099bar  = Z2barj(099);
Z3099bar  = Z3barj(099);
Z4099bar  = Z4barj(099);

alph100   = alphj(100);
f100      = fj(100);
PsP100    = PsPj(100);
Lam100bar = Lambarj(100);
S100bar   = Sbarj(100);
Z1100bar  = Z1barj(100);
Z2100bar  = Z2barj(100);
Z3100bar  = Z3barj(100);
Z4100bar  = Z4barj(100);

alph101   = alphj(101);
f101      = fj(101);
PsP101    = PsPj(101);
Lam101bar = Lambarj(101);
S101bar   = Sbarj(101);
Z1101bar  = Z1barj(101);
Z2101bar  = Z2barj(101);
Z3101bar  = Z3barj(101);
Z4101bar  = Z4barj(101);

alph102   = alphj(102);
f102      = fj(102);
PsP102    = PsPj(102);
Lam102bar = Lambarj(102);
S102bar   = Sbarj(102);
Z1102bar  = Z1barj(102);
Z2102bar  = Z2barj(102);
Z3102bar  = Z3barj(102);
Z4102bar  = Z4barj(102);

alph103   = alphj(103);
f103      = fj(103);
PsP103    = PsPj(103);
Lam103bar = Lambarj(103);
S103bar   = Sbarj(103);
Z1103bar  = Z1barj(103);
Z2103bar  = Z2barj(103);
Z3103bar  = Z3barj(103);
Z4103bar  = Z4barj(103);

alph104   = alphj(104);
f104      = fj(104);
PsP104    = PsPj(104);
Lam104bar = Lambarj(104);
S104bar   = Sbarj(104);
Z1104bar  = Z1barj(104);
Z2104bar  = Z2barj(104);
Z3104bar  = Z3barj(104);
Z4104bar  = Z4barj(104);

alph105   = alphj(105);
f105      = fj(105);
PsP105    = PsPj(105);
Lam105bar = Lambarj(105);
S105bar   = Sbarj(105);
Z1105bar  = Z1barj(105);
Z2105bar  = Z2barj(105);
Z3105bar  = Z3barj(105);
Z4105bar  = Z4barj(105);

alph106   = alphj(106);
f106      = fj(106);
PsP106    = PsPj(106);
Lam106bar = Lambarj(106);
S106bar   = Sbarj(106);
Z1106bar  = Z1barj(106);
Z2106bar  = Z2barj(106);
Z3106bar  = Z3barj(106);
Z4106bar  = Z4barj(106);

alph107   = alphj(107);
f107      = fj(107);
PsP107    = PsPj(107);
Lam107bar = Lambarj(107);
S107bar   = Sbarj(107);
Z1107bar  = Z1barj(107);
Z2107bar  = Z2barj(107);
Z3107bar  = Z3barj(107);
Z4107bar  = Z4barj(107);

alph108   = alphj(108);
f108      = fj(108);
PsP108    = PsPj(108);
Lam108bar = Lambarj(108);
S108bar   = Sbarj(108);
Z1108bar  = Z1barj(108);
Z2108bar  = Z2barj(108);
Z3108bar  = Z3barj(108);
Z4108bar  = Z4barj(108);

alph109   = alphj(109);
f109      = fj(109);
PsP109    = PsPj(109);
Lam109bar = Lambarj(109);
S109bar   = Sbarj(109);
Z1109bar  = Z1barj(109);
Z2109bar  = Z2barj(109);
Z3109bar  = Z3barj(109);
Z4109bar  = Z4barj(109);

alph110   = alphj(110);
f110      = fj(110);
PsP110    = PsPj(110);
Lam110bar = Lambarj(110);
S110bar   = Sbarj(110);
Z1110bar  = Z1barj(110);
Z2110bar  = Z2barj(110);
Z3110bar  = Z3barj(110);
Z4110bar  = Z4barj(110);

alph111   = alphj(111);
f111      = fj(111);
PsP111    = PsPj(111);
Lam111bar = Lambarj(111);
S111bar   = Sbarj(111);
Z1111bar  = Z1barj(111);
Z2111bar  = Z2barj(111);
Z3111bar  = Z3barj(111);
Z4111bar  = Z4barj(111);

alph112   = alphj(112);
f112      = fj(112);
PsP112    = PsPj(112);
Lam112bar = Lambarj(112);
S112bar   = Sbarj(112);
Z1112bar  = Z1barj(112);
Z2112bar  = Z2barj(112);
Z3112bar  = Z3barj(112);
Z4112bar  = Z4barj(112);

alph113   = alphj(113);
f113      = fj(113);
PsP113    = PsPj(113);
Lam113bar = Lambarj(113);
S113bar   = Sbarj(113);
Z1113bar  = Z1barj(113);
Z2113bar  = Z2barj(113);
Z3113bar  = Z3barj(113);
Z4113bar  = Z4barj(113);

alph114   = alphj(114);
f114      = fj(114);
PsP114    = PsPj(114);
Lam114bar = Lambarj(114);
S114bar   = Sbarj(114);
Z1114bar  = Z1barj(114);
Z2114bar  = Z2barj(114);
Z3114bar  = Z3barj(114);
Z4114bar  = Z4barj(114);

alph115   = alphj(115);
f115      = fj(115);
PsP115    = PsPj(115);
Lam115bar = Lambarj(115);
S115bar   = Sbarj(115);
Z1115bar  = Z1barj(115);
Z2115bar  = Z2barj(115);
Z3115bar  = Z3barj(115);
Z4115bar  = Z4barj(115);

alph116   = alphj(116);
f116      = fj(116);
PsP116    = PsPj(116);
Lam116bar = Lambarj(116);
S116bar   = Sbarj(116);
Z1116bar  = Z1barj(116);
Z2116bar  = Z2barj(116);
Z3116bar  = Z3barj(116);
Z4116bar  = Z4barj(116);

alph117   = alphj(117);
f117      = fj(117);
PsP117    = PsPj(117);
Lam117bar = Lambarj(117);
S117bar   = Sbarj(117);
Z1117bar  = Z1barj(117);
Z2117bar  = Z2barj(117);
Z3117bar  = Z3barj(117);
Z4117bar  = Z4barj(117);

alph118   = alphj(118);
f118      = fj(118);
PsP118    = PsPj(118);
Lam118bar = Lambarj(118);
S118bar   = Sbarj(118);
Z1118bar  = Z1barj(118);
Z2118bar  = Z2barj(118);
Z3118bar  = Z3barj(118);
Z4118bar  = Z4barj(118);

alph119   = alphj(119);
f119      = fj(119);
PsP119    = PsPj(119);
Lam119bar = Lambarj(119);
S119bar   = Sbarj(119);
Z1119bar  = Z1barj(119);
Z2119bar  = Z2barj(119);
Z3119bar  = Z3barj(119);
Z4119bar  = Z4barj(119);

alph120   = alphj(120);
f120      = fj(120);
PsP120    = PsPj(120);
Lam120bar = Lambarj(120);
S120bar   = Sbarj(120);
Z1120bar  = Z1barj(120);
Z2120bar  = Z2barj(120);
Z3120bar  = Z3barj(120);
Z4120bar  = Z4barj(120);

alph121   = alphj(121);
f121      = fj(121);
PsP121    = PsPj(121);
Lam121bar = Lambarj(121);
S121bar   = Sbarj(121);
Z1121bar  = Z1barj(121);
Z2121bar  = Z2barj(121);
Z3121bar  = Z3barj(121);
Z4121bar  = Z4barj(121);

alph122   = alphj(122);
f122      = fj(122);
PsP122    = PsPj(122);
Lam122bar = Lambarj(122);
S122bar   = Sbarj(122);
Z1122bar  = Z1barj(122);
Z2122bar  = Z2barj(122);
Z3122bar  = Z3barj(122);
Z4122bar  = Z4barj(122);

alph123   = alphj(123);
f123      = fj(123);
PsP123    = PsPj(123);
Lam123bar = Lambarj(123);
S123bar   = Sbarj(123);
Z1123bar  = Z1barj(123);
Z2123bar  = Z2barj(123);
Z3123bar  = Z3barj(123);
Z4123bar  = Z4barj(123);

alph124   = alphj(124);
f124      = fj(124);
PsP124    = PsPj(124);
Lam124bar = Lambarj(124);
S124bar   = Sbarj(124);
Z1124bar  = Z1barj(124);
Z2124bar  = Z2barj(124);
Z3124bar  = Z3barj(124);
Z4124bar  = Z4barj(124);

alph125   = alphj(125);
f125      = fj(125);
PsP125    = PsPj(125);
Lam125bar = Lambarj(125);
S125bar   = Sbarj(125);
Z1125bar  = Z1barj(125);
Z2125bar  = Z2barj(125);
Z3125bar  = Z3barj(125);
Z4125bar  = Z4barj(125);

alph126   = alphj(126);
f126      = fj(126);
PsP126    = PsPj(126);
Lam126bar = Lambarj(126);
S126bar   = Sbarj(126);
Z1126bar  = Z1barj(126);
Z2126bar  = Z2barj(126);
Z3126bar  = Z3barj(126);
Z4126bar  = Z4barj(126);

alph127   = alphj(127);
f127      = fj(127);
PsP127    = PsPj(127);
Lam127bar = Lambarj(127);
S127bar   = Sbarj(127);
Z1127bar  = Z1barj(127);
Z2127bar  = Z2barj(127);
Z3127bar  = Z3barj(127);
Z4127bar  = Z4barj(127);

alph128   = alphj(128);
f128      = fj(128);
PsP128    = PsPj(128);
Lam128bar = Lambarj(128);
S128bar   = Sbarj(128);
Z1128bar  = Z1barj(128);
Z2128bar  = Z2barj(128);
Z3128bar  = Z3barj(128);
Z4128bar  = Z4barj(128);

alph129   = alphj(129);
f129      = fj(129);
PsP129    = PsPj(129);
Lam129bar = Lambarj(129);
S129bar   = Sbarj(129);
Z1129bar  = Z1barj(129);
Z2129bar  = Z2barj(129);
Z3129bar  = Z3barj(129);
Z4129bar  = Z4barj(129);

alph130   = alphj(130);
f130      = fj(130);
PsP130    = PsPj(130);
Lam130bar = Lambarj(130);
S130bar   = Sbarj(130);
Z1130bar  = Z1barj(130);
Z2130bar  = Z2barj(130);
Z3130bar  = Z3barj(130);
Z4130bar  = Z4barj(130);

alph131   = alphj(131);
f131      = fj(131);
PsP131    = PsPj(131);
Lam131bar = Lambarj(131);
S131bar   = Sbarj(131);
Z1131bar  = Z1barj(131);
Z2131bar  = Z2barj(131);
Z3131bar  = Z3barj(131);
Z4131bar  = Z4barj(131);

alph132   = alphj(132);
f132      = fj(132);
PsP132    = PsPj(132);
Lam132bar = Lambarj(132);
S132bar   = Sbarj(132);
Z1132bar  = Z1barj(132);
Z2132bar  = Z2barj(132);
Z3132bar  = Z3barj(132);
Z4132bar  = Z4barj(132);

alph133   = alphj(133);
f133      = fj(133);
PsP133    = PsPj(133);
Lam133bar = Lambarj(133);
S133bar   = Sbarj(133);
Z1133bar  = Z1barj(133);
Z2133bar  = Z2barj(133);
Z3133bar  = Z3barj(133);
Z4133bar  = Z4barj(133);

alph134   = alphj(134);
f134      = fj(134);
PsP134    = PsPj(134);
Lam134bar = Lambarj(134);
S134bar   = Sbarj(134);
Z1134bar  = Z1barj(134);
Z2134bar  = Z2barj(134);
Z3134bar  = Z3barj(134);
Z4134bar  = Z4barj(134);

alph135   = alphj(135);
f135      = fj(135);
PsP135    = PsPj(135);
Lam135bar = Lambarj(135);
S135bar   = Sbarj(135);
Z1135bar  = Z1barj(135);
Z2135bar  = Z2barj(135);
Z3135bar  = Z3barj(135);
Z4135bar  = Z4barj(135);

alph136   = alphj(136);
f136      = fj(136);
PsP136    = PsPj(136);
Lam136bar = Lambarj(136);
S136bar   = Sbarj(136);
Z1136bar  = Z1barj(136);
Z2136bar  = Z2barj(136);
Z3136bar  = Z3barj(136);
Z4136bar  = Z4barj(136);

alph137   = alphj(137);
f137      = fj(137);
PsP137    = PsPj(137);
Lam137bar = Lambarj(137);
S137bar   = Sbarj(137);
Z1137bar  = Z1barj(137);
Z2137bar  = Z2barj(137);
Z3137bar  = Z3barj(137);
Z4137bar  = Z4barj(137);

alph138   = alphj(138);
f138      = fj(138);
PsP138    = PsPj(138);
Lam138bar = Lambarj(138);
S138bar   = Sbarj(138);
Z1138bar  = Z1barj(138);
Z2138bar  = Z2barj(138);
Z3138bar  = Z3barj(138);
Z4138bar  = Z4barj(138);

alph139   = alphj(139);
f139      = fj(139);
PsP139    = PsPj(139);
Lam139bar = Lambarj(139);
S139bar   = Sbarj(139);
Z1139bar  = Z1barj(139);
Z2139bar  = Z2barj(139);
Z3139bar  = Z3barj(139);
Z4139bar  = Z4barj(139);

alph140   = alphj(140);
f140      = fj(140);
PsP140    = PsPj(140);
Lam140bar = Lambarj(140);
S140bar   = Sbarj(140);
Z1140bar  = Z1barj(140);
Z2140bar  = Z2barj(140);
Z3140bar  = Z3barj(140);
Z4140bar  = Z4barj(140);

alph141   = alphj(141);
f141      = fj(141);
PsP141    = PsPj(141);
Lam141bar = Lambarj(141);
S141bar   = Sbarj(141);
Z1141bar  = Z1barj(141);
Z2141bar  = Z2barj(141);
Z3141bar  = Z3barj(141);
Z4141bar  = Z4barj(141);

alph142   = alphj(142);
f142      = fj(142);
PsP142    = PsPj(142);
Lam142bar = Lambarj(142);
S142bar   = Sbarj(142);
Z1142bar  = Z1barj(142);
Z2142bar  = Z2barj(142);
Z3142bar  = Z3barj(142);
Z4142bar  = Z4barj(142);

alph143   = alphj(143);
f143      = fj(143);
PsP143    = PsPj(143);
Lam143bar = Lambarj(143);
S143bar   = Sbarj(143);
Z1143bar  = Z1barj(143);
Z2143bar  = Z2barj(143);
Z3143bar  = Z3barj(143);
Z4143bar  = Z4barj(143);

alph144   = alphj(144);
f144      = fj(144);
PsP144    = PsPj(144);
Lam144bar = Lambarj(144);
S144bar   = Sbarj(144);
Z1144bar  = Z1barj(144);
Z2144bar  = Z2barj(144);
Z3144bar  = Z3barj(144);
Z4144bar  = Z4barj(144);

alph145   = alphj(145);
f145      = fj(145);
PsP145    = PsPj(145);
Lam145bar = Lambarj(145);
S145bar   = Sbarj(145);
Z1145bar  = Z1barj(145);
Z2145bar  = Z2barj(145);
Z3145bar  = Z3barj(145);
Z4145bar  = Z4barj(145);

alph146   = alphj(146);
f146      = fj(146);
PsP146    = PsPj(146);
Lam146bar = Lambarj(146);
S146bar   = Sbarj(146);
Z1146bar  = Z1barj(146);
Z2146bar  = Z2barj(146);
Z3146bar  = Z3barj(146);
Z4146bar  = Z4barj(146);

alph147   = alphj(147);
f147      = fj(147);
PsP147    = PsPj(147);
Lam147bar = Lambarj(147);
S147bar   = Sbarj(147);
Z1147bar  = Z1barj(147);
Z2147bar  = Z2barj(147);
Z3147bar  = Z3barj(147);
Z4147bar  = Z4barj(147);

alph148   = alphj(148);
f148      = fj(148);
PsP148    = PsPj(148);
Lam148bar = Lambarj(148);
S148bar   = Sbarj(148);
Z1148bar  = Z1barj(148);
Z2148bar  = Z2barj(148);
Z3148bar  = Z3barj(148);
Z4148bar  = Z4barj(148);

alph149   = alphj(149);
f149      = fj(149);
PsP149    = PsPj(149);
Lam149bar = Lambarj(149);
S149bar   = Sbarj(149);
Z1149bar  = Z1barj(149);
Z2149bar  = Z2barj(149);
Z3149bar  = Z3barj(149);
Z4149bar  = Z4barj(149);

alph150   = alphj(150);
f150      = fj(150);
PsP150    = PsPj(150);
Lam150bar = Lambarj(150);
S150bar   = Sbarj(150);
Z1150bar  = Z1barj(150);
Z2150bar  = Z2barj(150);
Z3150bar  = Z3barj(150);
Z4150bar  = Z4barj(150);

alph151   = alphj(151);
f151      = fj(151);
PsP151    = PsPj(151);
Lam151bar = Lambarj(151);
S151bar   = Sbarj(151);
Z1151bar  = Z1barj(151);
Z2151bar  = Z2barj(151);
Z3151bar  = Z3barj(151);
Z4151bar  = Z4barj(151);

alph152   = alphj(152);
f152      = fj(152);
PsP152    = PsPj(152);
Lam152bar = Lambarj(152);
S152bar   = Sbarj(152);
Z1152bar  = Z1barj(152);
Z2152bar  = Z2barj(152);
Z3152bar  = Z3barj(152);
Z4152bar  = Z4barj(152);

alph153   = alphj(153);
f153      = fj(153);
PsP153    = PsPj(153);
Lam153bar = Lambarj(153);
S153bar   = Sbarj(153);
Z1153bar  = Z1barj(153);
Z2153bar  = Z2barj(153);
Z3153bar  = Z3barj(153);
Z4153bar  = Z4barj(153);

alph154   = alphj(154);
f154      = fj(154);
PsP154    = PsPj(154);
Lam154bar = Lambarj(154);
S154bar   = Sbarj(154);
Z1154bar  = Z1barj(154);
Z2154bar  = Z2barj(154);
Z3154bar  = Z3barj(154);
Z4154bar  = Z4barj(154);

alph155   = alphj(155);
f155      = fj(155);
PsP155    = PsPj(155);
Lam155bar = Lambarj(155);
S155bar   = Sbarj(155);
Z1155bar  = Z1barj(155);
Z2155bar  = Z2barj(155);
Z3155bar  = Z3barj(155);
Z4155bar  = Z4barj(155);

alph156   = alphj(156);
f156      = fj(156);
PsP156    = PsPj(156);
Lam156bar = Lambarj(156);
S156bar   = Sbarj(156);
Z1156bar  = Z1barj(156);
Z2156bar  = Z2barj(156);
Z3156bar  = Z3barj(156);
Z4156bar  = Z4barj(156);

alph157   = alphj(157);
f157      = fj(157);
PsP157    = PsPj(157);
Lam157bar = Lambarj(157);
S157bar   = Sbarj(157);
Z1157bar  = Z1barj(157);
Z2157bar  = Z2barj(157);
Z3157bar  = Z3barj(157);
Z4157bar  = Z4barj(157);

alph158   = alphj(158);
f158      = fj(158);
PsP158    = PsPj(158);
Lam158bar = Lambarj(158);
S158bar   = Sbarj(158);
Z1158bar  = Z1barj(158);
Z2158bar  = Z2barj(158);
Z3158bar  = Z3barj(158);
Z4158bar  = Z4barj(158);

alph159   = alphj(159);
f159      = fj(159);
PsP159    = PsPj(159);
Lam159bar = Lambarj(159);
S159bar   = Sbarj(159);
Z1159bar  = Z1barj(159);
Z2159bar  = Z2barj(159);
Z3159bar  = Z3barj(159);
Z4159bar  = Z4barj(159);

alph160   = alphj(160);
f160      = fj(160);
PsP160    = PsPj(160);
Lam160bar = Lambarj(160);
S160bar   = Sbarj(160);
Z1160bar  = Z1barj(160);
Z2160bar  = Z2barj(160);
Z3160bar  = Z3barj(160);
Z4160bar  = Z4barj(160);

alph161   = alphj(161);
f161      = fj(161);
PsP161    = PsPj(161);
Lam161bar = Lambarj(161);
S161bar   = Sbarj(161);
Z1161bar  = Z1barj(161);
Z2161bar  = Z2barj(161);
Z3161bar  = Z3barj(161);
Z4161bar  = Z4barj(161);

alph162   = alphj(162);
f162      = fj(162);
PsP162    = PsPj(162);
Lam162bar = Lambarj(162);
S162bar   = Sbarj(162);
Z1162bar  = Z1barj(162);
Z2162bar  = Z2barj(162);
Z3162bar  = Z3barj(162);
Z4162bar  = Z4barj(162);

alph163   = alphj(163);
f163      = fj(163);
PsP163    = PsPj(163);
Lam163bar = Lambarj(163);
S163bar   = Sbarj(163);
Z1163bar  = Z1barj(163);
Z2163bar  = Z2barj(163);
Z3163bar  = Z3barj(163);
Z4163bar  = Z4barj(163);

alph164   = alphj(164);
f164      = fj(164);
PsP164    = PsPj(164);
Lam164bar = Lambarj(164);
S164bar   = Sbarj(164);
Z1164bar  = Z1barj(164);
Z2164bar  = Z2barj(164);
Z3164bar  = Z3barj(164);
Z4164bar  = Z4barj(164);

alph165   = alphj(165);
f165      = fj(165);
PsP165    = PsPj(165);
Lam165bar = Lambarj(165);
S165bar   = Sbarj(165);
Z1165bar  = Z1barj(165);
Z2165bar  = Z2barj(165);
Z3165bar  = Z3barj(165);
Z4165bar  = Z4barj(165);

alph166   = alphj(166);
f166      = fj(166);
PsP166    = PsPj(166);
Lam166bar = Lambarj(166);
S166bar   = Sbarj(166);
Z1166bar  = Z1barj(166);
Z2166bar  = Z2barj(166);
Z3166bar  = Z3barj(166);
Z4166bar  = Z4barj(166);

alph167   = alphj(167);
f167      = fj(167);
PsP167    = PsPj(167);
Lam167bar = Lambarj(167);
S167bar   = Sbarj(167);
Z1167bar  = Z1barj(167);
Z2167bar  = Z2barj(167);
Z3167bar  = Z3barj(167);
Z4167bar  = Z4barj(167);

alph168   = alphj(168);
f168      = fj(168);
PsP168    = PsPj(168);
Lam168bar = Lambarj(168);
S168bar   = Sbarj(168);
Z1168bar  = Z1barj(168);
Z2168bar  = Z2barj(168);
Z3168bar  = Z3barj(168);
Z4168bar  = Z4barj(168);

alph169   = alphj(169);
f169      = fj(169);
PsP169    = PsPj(169);
Lam169bar = Lambarj(169);
S169bar   = Sbarj(169);
Z1169bar  = Z1barj(169);
Z2169bar  = Z2barj(169);
Z3169bar  = Z3barj(169);
Z4169bar  = Z4barj(169);

alph170   = alphj(170);
f170      = fj(170);
PsP170    = PsPj(170);
Lam170bar = Lambarj(170);
S170bar   = Sbarj(170);
Z1170bar  = Z1barj(170);
Z2170bar  = Z2barj(170);
Z3170bar  = Z3barj(170);
Z4170bar  = Z4barj(170);

alph171   = alphj(171);
f171      = fj(171);
PsP171    = PsPj(171);
Lam171bar = Lambarj(171);
S171bar   = Sbarj(171);
Z1171bar  = Z1barj(171);
Z2171bar  = Z2barj(171);
Z3171bar  = Z3barj(171);
Z4171bar  = Z4barj(171);

alph172   = alphj(172);
f172      = fj(172);
PsP172    = PsPj(172);
Lam172bar = Lambarj(172);
S172bar   = Sbarj(172);
Z1172bar  = Z1barj(172);
Z2172bar  = Z2barj(172);
Z3172bar  = Z3barj(172);
Z4172bar  = Z4barj(172);

alph173   = alphj(173);
f173      = fj(173);
PsP173    = PsPj(173);
Lam173bar = Lambarj(173);
S173bar   = Sbarj(173);
Z1173bar  = Z1barj(173);
Z2173bar  = Z2barj(173);
Z3173bar  = Z3barj(173);
Z4173bar  = Z4barj(173);

alph174   = alphj(174);
f174      = fj(174);
PsP174    = PsPj(174);
Lam174bar = Lambarj(174);
S174bar   = Sbarj(174);
Z1174bar  = Z1barj(174);
Z2174bar  = Z2barj(174);
Z3174bar  = Z3barj(174);
Z4174bar  = Z4barj(174);

alph175   = alphj(175);
f175      = fj(175);
PsP175    = PsPj(175);
Lam175bar = Lambarj(175);
S175bar   = Sbarj(175);
Z1175bar  = Z1barj(175);
Z2175bar  = Z2barj(175);
Z3175bar  = Z3barj(175);
Z4175bar  = Z4barj(175);

alph176   = alphj(176);
f176      = fj(176);
PsP176    = PsPj(176);
Lam176bar = Lambarj(176);
S176bar   = Sbarj(176);
Z1176bar  = Z1barj(176);
Z2176bar  = Z2barj(176);
Z3176bar  = Z3barj(176);
Z4176bar  = Z4barj(176);

alph177   = alphj(177);
f177      = fj(177);
PsP177    = PsPj(177);
Lam177bar = Lambarj(177);
S177bar   = Sbarj(177);
Z1177bar  = Z1barj(177);
Z2177bar  = Z2barj(177);
Z3177bar  = Z3barj(177);
Z4177bar  = Z4barj(177);

alph178   = alphj(178);
f178      = fj(178);
PsP178    = PsPj(178);
Lam178bar = Lambarj(178);
S178bar   = Sbarj(178);
Z1178bar  = Z1barj(178);
Z2178bar  = Z2barj(178);
Z3178bar  = Z3barj(178);
Z4178bar  = Z4barj(178);

alph179   = alphj(179);
f179      = fj(179);
PsP179    = PsPj(179);
Lam179bar = Lambarj(179);
S179bar   = Sbarj(179);
Z1179bar  = Z1barj(179);
Z2179bar  = Z2barj(179);
Z3179bar  = Z3barj(179);
Z4179bar  = Z4barj(179);

alph180   = alphj(180);
f180      = fj(180);
PsP180    = PsPj(180);
Lam180bar = Lambarj(180);
S180bar   = Sbarj(180);
Z1180bar  = Z1barj(180);
Z2180bar  = Z2barj(180);
Z3180bar  = Z3barj(180);
Z4180bar  = Z4barj(180);

alph181   = alphj(181);
f181      = fj(181);
PsP181    = PsPj(181);
Lam181bar = Lambarj(181);
S181bar   = Sbarj(181);
Z1181bar  = Z1barj(181);
Z2181bar  = Z2barj(181);
Z3181bar  = Z3barj(181);
Z4181bar  = Z4barj(181);

alph182   = alphj(182);
f182      = fj(182);
PsP182    = PsPj(182);
Lam182bar = Lambarj(182);
S182bar   = Sbarj(182);
Z1182bar  = Z1barj(182);
Z2182bar  = Z2barj(182);
Z3182bar  = Z3barj(182);
Z4182bar  = Z4barj(182);

alph183   = alphj(183);
f183      = fj(183);
PsP183    = PsPj(183);
Lam183bar = Lambarj(183);
S183bar   = Sbarj(183);
Z1183bar  = Z1barj(183);
Z2183bar  = Z2barj(183);
Z3183bar  = Z3barj(183);
Z4183bar  = Z4barj(183);

alph184   = alphj(184);
f184      = fj(184);
PsP184    = PsPj(184);
Lam184bar = Lambarj(184);
S184bar   = Sbarj(184);
Z1184bar  = Z1barj(184);
Z2184bar  = Z2barj(184);
Z3184bar  = Z3barj(184);
Z4184bar  = Z4barj(184);

alph185   = alphj(185);
f185      = fj(185);
PsP185    = PsPj(185);
Lam185bar = Lambarj(185);
S185bar   = Sbarj(185);
Z1185bar  = Z1barj(185);
Z2185bar  = Z2barj(185);
Z3185bar  = Z3barj(185);
Z4185bar  = Z4barj(185);

alph186   = alphj(186);
f186      = fj(186);
PsP186    = PsPj(186);
Lam186bar = Lambarj(186);
S186bar   = Sbarj(186);
Z1186bar  = Z1barj(186);
Z2186bar  = Z2barj(186);
Z3186bar  = Z3barj(186);
Z4186bar  = Z4barj(186);

alph187   = alphj(187);
f187      = fj(187);
PsP187    = PsPj(187);
Lam187bar = Lambarj(187);
S187bar   = Sbarj(187);
Z1187bar  = Z1barj(187);
Z2187bar  = Z2barj(187);
Z3187bar  = Z3barj(187);
Z4187bar  = Z4barj(187);

alph188   = alphj(188);
f188      = fj(188);
PsP188    = PsPj(188);
Lam188bar = Lambarj(188);
S188bar   = Sbarj(188);
Z1188bar  = Z1barj(188);
Z2188bar  = Z2barj(188);
Z3188bar  = Z3barj(188);
Z4188bar  = Z4barj(188);

alph189   = alphj(189);
f189      = fj(189);
PsP189    = PsPj(189);
Lam189bar = Lambarj(189);
S189bar   = Sbarj(189);
Z1189bar  = Z1barj(189);
Z2189bar  = Z2barj(189);
Z3189bar  = Z3barj(189);
Z4189bar  = Z4barj(189);

alph190   = alphj(190);
f190      = fj(190);
PsP190    = PsPj(190);
Lam190bar = Lambarj(190);
S190bar   = Sbarj(190);
Z1190bar  = Z1barj(190);
Z2190bar  = Z2barj(190);
Z3190bar  = Z3barj(190);
Z4190bar  = Z4barj(190);

alph191   = alphj(191);
f191      = fj(191);
PsP191    = PsPj(191);
Lam191bar = Lambarj(191);
S191bar   = Sbarj(191);
Z1191bar  = Z1barj(191);
Z2191bar  = Z2barj(191);
Z3191bar  = Z3barj(191);
Z4191bar  = Z4barj(191);

alph192   = alphj(192);
f192      = fj(192);
PsP192    = PsPj(192);
Lam192bar = Lambarj(192);
S192bar   = Sbarj(192);
Z1192bar  = Z1barj(192);
Z2192bar  = Z2barj(192);
Z3192bar  = Z3barj(192);
Z4192bar  = Z4barj(192);

alph193   = alphj(193);
f193      = fj(193);
PsP193    = PsPj(193);
Lam193bar = Lambarj(193);
S193bar   = Sbarj(193);
Z1193bar  = Z1barj(193);
Z2193bar  = Z2barj(193);
Z3193bar  = Z3barj(193);
Z4193bar  = Z4barj(193);

alph194   = alphj(194);
f194      = fj(194);
PsP194    = PsPj(194);
Lam194bar = Lambarj(194);
S194bar   = Sbarj(194);
Z1194bar  = Z1barj(194);
Z2194bar  = Z2barj(194);
Z3194bar  = Z3barj(194);
Z4194bar  = Z4barj(194);

alph195   = alphj(195);
f195      = fj(195);
PsP195    = PsPj(195);
Lam195bar = Lambarj(195);
S195bar   = Sbarj(195);
Z1195bar  = Z1barj(195);
Z2195bar  = Z2barj(195);
Z3195bar  = Z3barj(195);
Z4195bar  = Z4barj(195);

alph196   = alphj(196);
f196      = fj(196);
PsP196    = PsPj(196);
Lam196bar = Lambarj(196);
S196bar   = Sbarj(196);
Z1196bar  = Z1barj(196);
Z2196bar  = Z2barj(196);
Z3196bar  = Z3barj(196);
Z4196bar  = Z4barj(196);

alph197   = alphj(197);
f197      = fj(197);
PsP197    = PsPj(197);
Lam197bar = Lambarj(197);
S197bar   = Sbarj(197);
Z1197bar  = Z1barj(197);
Z2197bar  = Z2barj(197);
Z3197bar  = Z3barj(197);
Z4197bar  = Z4barj(197);

alph198   = alphj(198);
f198      = fj(198);
PsP198    = PsPj(198);
Lam198bar = Lambarj(198);
S198bar   = Sbarj(198);
Z1198bar  = Z1barj(198);
Z2198bar  = Z2barj(198);
Z3198bar  = Z3barj(198);
Z4198bar  = Z4barj(198);

alph199   = alphj(199);
f199      = fj(199);
PsP199    = PsPj(199);
Lam199bar = Lambarj(199);
S199bar   = Sbarj(199);
Z1199bar  = Z1barj(199);
Z2199bar  = Z2barj(199);
Z3199bar  = Z3barj(199);
Z4199bar  = Z4barj(199);

alph200   = alphj(200);
f200      = fj(200);
PsP200    = PsPj(200);
Lam200bar = Lambarj(200);
S200bar   = Sbarj(200);
Z1200bar  = Z1barj(200);
Z2200bar  = Z2barj(200);
Z3200bar  = Z3barj(200);
Z4200bar  = Z4barj(200);

alph201   = alphj(201);
f201      = fj(201);
PsP201    = PsPj(201);
Lam201bar = Lambarj(201);
S201bar   = Sbarj(201);
Z1201bar  = Z1barj(201);
Z2201bar  = Z2barj(201);
Z3201bar  = Z3barj(201);
Z4201bar  = Z4barj(201);

alph202   = alphj(202);
f202      = fj(202);
PsP202    = PsPj(202);
Lam202bar = Lambarj(202);
S202bar   = Sbarj(202);
Z1202bar  = Z1barj(202);
Z2202bar  = Z2barj(202);
Z3202bar  = Z3barj(202);
Z4202bar  = Z4barj(202);

alph203   = alphj(203);
f203      = fj(203);
PsP203    = PsPj(203);
Lam203bar = Lambarj(203);
S203bar   = Sbarj(203);
Z1203bar  = Z1barj(203);
Z2203bar  = Z2barj(203);
Z3203bar  = Z3barj(203);
Z4203bar  = Z4barj(203);

alph204   = alphj(204);
f204      = fj(204);
PsP204    = PsPj(204);
Lam204bar = Lambarj(204);
S204bar   = Sbarj(204);
Z1204bar  = Z1barj(204);
Z2204bar  = Z2barj(204);
Z3204bar  = Z3barj(204);
Z4204bar  = Z4barj(204);

alph205   = alphj(205);
f205      = fj(205);
PsP205    = PsPj(205);
Lam205bar = Lambarj(205);
S205bar   = Sbarj(205);
Z1205bar  = Z1barj(205);
Z2205bar  = Z2barj(205);
Z3205bar  = Z3barj(205);
Z4205bar  = Z4barj(205);

alph206   = alphj(206);
f206      = fj(206);
PsP206    = PsPj(206);
Lam206bar = Lambarj(206);
S206bar   = Sbarj(206);
Z1206bar  = Z1barj(206);
Z2206bar  = Z2barj(206);
Z3206bar  = Z3barj(206);
Z4206bar  = Z4barj(206);

alph207   = alphj(207);
f207      = fj(207);
PsP207    = PsPj(207);
Lam207bar = Lambarj(207);
S207bar   = Sbarj(207);
Z1207bar  = Z1barj(207);
Z2207bar  = Z2barj(207);
Z3207bar  = Z3barj(207);
Z4207bar  = Z4barj(207);

alph208   = alphj(208);
f208      = fj(208);
PsP208    = PsPj(208);
Lam208bar = Lambarj(208);
S208bar   = Sbarj(208);
Z1208bar  = Z1barj(208);
Z2208bar  = Z2barj(208);
Z3208bar  = Z3barj(208);
Z4208bar  = Z4barj(208);

alph209   = alphj(209);
f209      = fj(209);
PsP209    = PsPj(209);
Lam209bar = Lambarj(209);
S209bar   = Sbarj(209);
Z1209bar  = Z1barj(209);
Z2209bar  = Z2barj(209);
Z3209bar  = Z3barj(209);
Z4209bar  = Z4barj(209);

alph210   = alphj(210);
f210      = fj(210);
PsP210    = PsPj(210);
Lam210bar = Lambarj(210);
S210bar   = Sbarj(210);
Z1210bar  = Z1barj(210);
Z2210bar  = Z2barj(210);
Z3210bar  = Z3barj(210);
Z4210bar  = Z4barj(210);

alph211   = alphj(211);
f211      = fj(211);
PsP211    = PsPj(211);
Lam211bar = Lambarj(211);
S211bar   = Sbarj(211);
Z1211bar  = Z1barj(211);
Z2211bar  = Z2barj(211);
Z3211bar  = Z3barj(211);
Z4211bar  = Z4barj(211);

alph212   = alphj(212);
f212      = fj(212);
PsP212    = PsPj(212);
Lam212bar = Lambarj(212);
S212bar   = Sbarj(212);
Z1212bar  = Z1barj(212);
Z2212bar  = Z2barj(212);
Z3212bar  = Z3barj(212);
Z4212bar  = Z4barj(212);

alph213   = alphj(213);
f213      = fj(213);
PsP213    = PsPj(213);
Lam213bar = Lambarj(213);
S213bar   = Sbarj(213);
Z1213bar  = Z1barj(213);
Z2213bar  = Z2barj(213);
Z3213bar  = Z3barj(213);
Z4213bar  = Z4barj(213);

alph214   = alphj(214);
f214      = fj(214);
PsP214    = PsPj(214);
Lam214bar = Lambarj(214);
S214bar   = Sbarj(214);
Z1214bar  = Z1barj(214);
Z2214bar  = Z2barj(214);
Z3214bar  = Z3barj(214);
Z4214bar  = Z4barj(214);

alph215   = alphj(215);
f215      = fj(215);
PsP215    = PsPj(215);
Lam215bar = Lambarj(215);
S215bar   = Sbarj(215);
Z1215bar  = Z1barj(215);
Z2215bar  = Z2barj(215);
Z3215bar  = Z3barj(215);
Z4215bar  = Z4barj(215);

alph216   = alphj(216);
f216      = fj(216);
PsP216    = PsPj(216);
Lam216bar = Lambarj(216);
S216bar   = Sbarj(216);
Z1216bar  = Z1barj(216);
Z2216bar  = Z2barj(216);
Z3216bar  = Z3barj(216);
Z4216bar  = Z4barj(216);

alph217   = alphj(217);
f217      = fj(217);
PsP217    = PsPj(217);
Lam217bar = Lambarj(217);
S217bar   = Sbarj(217);
Z1217bar  = Z1barj(217);
Z2217bar  = Z2barj(217);
Z3217bar  = Z3barj(217);
Z4217bar  = Z4barj(217);

alph218   = alphj(218);
f218      = fj(218);
PsP218    = PsPj(218);
Lam218bar = Lambarj(218);
S218bar   = Sbarj(218);
Z1218bar  = Z1barj(218);
Z2218bar  = Z2barj(218);
Z3218bar  = Z3barj(218);
Z4218bar  = Z4barj(218);

alph219   = alphj(219);
f219      = fj(219);
PsP219    = PsPj(219);
Lam219bar = Lambarj(219);
S219bar   = Sbarj(219);
Z1219bar  = Z1barj(219);
Z2219bar  = Z2barj(219);
Z3219bar  = Z3barj(219);
Z4219bar  = Z4barj(219);

alph220   = alphj(220);
f220      = fj(220);
PsP220    = PsPj(220);
Lam220bar = Lambarj(220);
S220bar   = Sbarj(220);
Z1220bar  = Z1barj(220);
Z2220bar  = Z2barj(220);
Z3220bar  = Z3barj(220);
Z4220bar  = Z4barj(220);

alph221   = alphj(221);
f221      = fj(221);
PsP221    = PsPj(221);
Lam221bar = Lambarj(221);
S221bar   = Sbarj(221);
Z1221bar  = Z1barj(221);
Z2221bar  = Z2barj(221);
Z3221bar  = Z3barj(221);
Z4221bar  = Z4barj(221);

alph222   = alphj(222);
f222      = fj(222);
PsP222    = PsPj(222);
Lam222bar = Lambarj(222);
S222bar   = Sbarj(222);
Z1222bar  = Z1barj(222);
Z2222bar  = Z2barj(222);
Z3222bar  = Z3barj(222);
Z4222bar  = Z4barj(222);

alph223   = alphj(223);
f223      = fj(223);
PsP223    = PsPj(223);
Lam223bar = Lambarj(223);
S223bar   = Sbarj(223);
Z1223bar  = Z1barj(223);
Z2223bar  = Z2barj(223);
Z3223bar  = Z3barj(223);
Z4223bar  = Z4barj(223);

alph224   = alphj(224);
f224      = fj(224);
PsP224    = PsPj(224);
Lam224bar = Lambarj(224);
S224bar   = Sbarj(224);
Z1224bar  = Z1barj(224);
Z2224bar  = Z2barj(224);
Z3224bar  = Z3barj(224);
Z4224bar  = Z4barj(224);

alph225   = alphj(225);
f225      = fj(225);
PsP225    = PsPj(225);
Lam225bar = Lambarj(225);
S225bar   = Sbarj(225);
Z1225bar  = Z1barj(225);
Z2225bar  = Z2barj(225);
Z3225bar  = Z3barj(225);
Z4225bar  = Z4barj(225);

alph226   = alphj(226);
f226      = fj(226);
PsP226    = PsPj(226);
Lam226bar = Lambarj(226);
S226bar   = Sbarj(226);
Z1226bar  = Z1barj(226);
Z2226bar  = Z2barj(226);
Z3226bar  = Z3barj(226);
Z4226bar  = Z4barj(226);

alph227   = alphj(227);
f227      = fj(227);
PsP227    = PsPj(227);
Lam227bar = Lambarj(227);
S227bar   = Sbarj(227);
Z1227bar  = Z1barj(227);
Z2227bar  = Z2barj(227);
Z3227bar  = Z3barj(227);
Z4227bar  = Z4barj(227);

alph228   = alphj(228);
f228      = fj(228);
PsP228    = PsPj(228);
Lam228bar = Lambarj(228);
S228bar   = Sbarj(228);
Z1228bar  = Z1barj(228);
Z2228bar  = Z2barj(228);
Z3228bar  = Z3barj(228);
Z4228bar  = Z4barj(228);

alph229   = alphj(229);
f229      = fj(229);
PsP229    = PsPj(229);
Lam229bar = Lambarj(229);
S229bar   = Sbarj(229);
Z1229bar  = Z1barj(229);
Z2229bar  = Z2barj(229);
Z3229bar  = Z3barj(229);
Z4229bar  = Z4barj(229);

alph230   = alphj(230);
f230      = fj(230);
PsP230    = PsPj(230);
Lam230bar = Lambarj(230);
S230bar   = Sbarj(230);
Z1230bar  = Z1barj(230);
Z2230bar  = Z2barj(230);
Z3230bar  = Z3barj(230);
Z4230bar  = Z4barj(230);

alph231   = alphj(231);
f231      = fj(231);
PsP231    = PsPj(231);
Lam231bar = Lambarj(231);
S231bar   = Sbarj(231);
Z1231bar  = Z1barj(231);
Z2231bar  = Z2barj(231);
Z3231bar  = Z3barj(231);
Z4231bar  = Z4barj(231);

alph232   = alphj(232);
f232      = fj(232);
PsP232    = PsPj(232);
Lam232bar = Lambarj(232);
S232bar   = Sbarj(232);
Z1232bar  = Z1barj(232);
Z2232bar  = Z2barj(232);
Z3232bar  = Z3barj(232);
Z4232bar  = Z4barj(232);

alph233   = alphj(233);
f233      = fj(233);
PsP233    = PsPj(233);
Lam233bar = Lambarj(233);
S233bar   = Sbarj(233);
Z1233bar  = Z1barj(233);
Z2233bar  = Z2barj(233);
Z3233bar  = Z3barj(233);
Z4233bar  = Z4barj(233);

alph234   = alphj(234);
f234      = fj(234);
PsP234    = PsPj(234);
Lam234bar = Lambarj(234);
S234bar   = Sbarj(234);
Z1234bar  = Z1barj(234);
Z2234bar  = Z2barj(234);
Z3234bar  = Z3barj(234);
Z4234bar  = Z4barj(234);

alph235   = alphj(235);
f235      = fj(235);
PsP235    = PsPj(235);
Lam235bar = Lambarj(235);
S235bar   = Sbarj(235);
Z1235bar  = Z1barj(235);
Z2235bar  = Z2barj(235);
Z3235bar  = Z3barj(235);
Z4235bar  = Z4barj(235);

alph236   = alphj(236);
f236      = fj(236);
PsP236    = PsPj(236);
Lam236bar = Lambarj(236);
S236bar   = Sbarj(236);
Z1236bar  = Z1barj(236);
Z2236bar  = Z2barj(236);
Z3236bar  = Z3barj(236);
Z4236bar  = Z4barj(236);

alph237   = alphj(237);
f237      = fj(237);
PsP237    = PsPj(237);
Lam237bar = Lambarj(237);
S237bar   = Sbarj(237);
Z1237bar  = Z1barj(237);
Z2237bar  = Z2barj(237);
Z3237bar  = Z3barj(237);
Z4237bar  = Z4barj(237);

alph238   = alphj(238);
f238      = fj(238);
PsP238    = PsPj(238);
Lam238bar = Lambarj(238);
S238bar   = Sbarj(238);
Z1238bar  = Z1barj(238);
Z2238bar  = Z2barj(238);
Z3238bar  = Z3barj(238);
Z4238bar  = Z4barj(238);

alph239   = alphj(239);
f239      = fj(239);
PsP239    = PsPj(239);
Lam239bar = Lambarj(239);
S239bar   = Sbarj(239);
Z1239bar  = Z1barj(239);
Z2239bar  = Z2barj(239);
Z3239bar  = Z3barj(239);
Z4239bar  = Z4barj(239);

alph240   = alphj(240);
f240      = fj(240);
PsP240    = PsPj(240);
Lam240bar = Lambarj(240);
S240bar   = Sbarj(240);
Z1240bar  = Z1barj(240);
Z2240bar  = Z2barj(240);
Z3240bar  = Z3barj(240);
Z4240bar  = Z4barj(240);

alph241   = alphj(241);
f241      = fj(241);
PsP241    = PsPj(241);
Lam241bar = Lambarj(241);
S241bar   = Sbarj(241);
Z1241bar  = Z1barj(241);
Z2241bar  = Z2barj(241);
Z3241bar  = Z3barj(241);
Z4241bar  = Z4barj(241);

alph242   = alphj(242);
f242      = fj(242);
PsP242    = PsPj(242);
Lam242bar = Lambarj(242);
S242bar   = Sbarj(242);
Z1242bar  = Z1barj(242);
Z2242bar  = Z2barj(242);
Z3242bar  = Z3barj(242);
Z4242bar  = Z4barj(242);

alph243   = alphj(243);
f243      = fj(243);
PsP243    = PsPj(243);
Lam243bar = Lambarj(243);
S243bar   = Sbarj(243);
Z1243bar  = Z1barj(243);
Z2243bar  = Z2barj(243);
Z3243bar  = Z3barj(243);
Z4243bar  = Z4barj(243);

alph244   = alphj(244);
f244      = fj(244);
PsP244    = PsPj(244);
Lam244bar = Lambarj(244);
S244bar   = Sbarj(244);
Z1244bar  = Z1barj(244);
Z2244bar  = Z2barj(244);
Z3244bar  = Z3barj(244);
Z4244bar  = Z4barj(244);

alph245   = alphj(245);
f245      = fj(245);
PsP245    = PsPj(245);
Lam245bar = Lambarj(245);
S245bar   = Sbarj(245);
Z1245bar  = Z1barj(245);
Z2245bar  = Z2barj(245);
Z3245bar  = Z3barj(245);
Z4245bar  = Z4barj(245);

alph246   = alphj(246);
f246      = fj(246);
PsP246    = PsPj(246);
Lam246bar = Lambarj(246);
S246bar   = Sbarj(246);
Z1246bar  = Z1barj(246);
Z2246bar  = Z2barj(246);
Z3246bar  = Z3barj(246);
Z4246bar  = Z4barj(246);

alph247   = alphj(247);
f247      = fj(247);
PsP247    = PsPj(247);
Lam247bar = Lambarj(247);
S247bar   = Sbarj(247);
Z1247bar  = Z1barj(247);
Z2247bar  = Z2barj(247);
Z3247bar  = Z3barj(247);
Z4247bar  = Z4barj(247);

alph248   = alphj(248);
f248      = fj(248);
PsP248    = PsPj(248);
Lam248bar = Lambarj(248);
S248bar   = Sbarj(248);
Z1248bar  = Z1barj(248);
Z2248bar  = Z2barj(248);
Z3248bar  = Z3barj(248);
Z4248bar  = Z4barj(248);

alph249   = alphj(249);
f249      = fj(249);
PsP249    = PsPj(249);
Lam249bar = Lambarj(249);
S249bar   = Sbarj(249);
Z1249bar  = Z1barj(249);
Z2249bar  = Z2barj(249);
Z3249bar  = Z3barj(249);
Z4249bar  = Z4barj(249);

alph250   = alphj(250);
f250      = fj(250);
PsP250    = PsPj(250);
Lam250bar = Lambarj(250);
S250bar   = Sbarj(250);
Z1250bar  = Z1barj(250);
Z2250bar  = Z2barj(250);
Z3250bar  = Z3barj(250);
Z4250bar  = Z4barj(250);

alph251   = alphj(251);
f251      = fj(251);
PsP251    = PsPj(251);
Lam251bar = Lambarj(251);
S251bar   = Sbarj(251);
Z1251bar  = Z1barj(251);
Z2251bar  = Z2barj(251);
Z3251bar  = Z3barj(251);
Z4251bar  = Z4barj(251);

alph252   = alphj(252);
f252      = fj(252);
PsP252    = PsPj(252);
Lam252bar = Lambarj(252);
S252bar   = Sbarj(252);
Z1252bar  = Z1barj(252);
Z2252bar  = Z2barj(252);
Z3252bar  = Z3barj(252);
Z4252bar  = Z4barj(252);

alph253   = alphj(253);
f253      = fj(253);
PsP253    = PsPj(253);
Lam253bar = Lambarj(253);
S253bar   = Sbarj(253);
Z1253bar  = Z1barj(253);
Z2253bar  = Z2barj(253);
Z3253bar  = Z3barj(253);
Z4253bar  = Z4barj(253);

alph254   = alphj(254);
f254      = fj(254);
PsP254    = PsPj(254);
Lam254bar = Lambarj(254);
S254bar   = Sbarj(254);
Z1254bar  = Z1barj(254);
Z2254bar  = Z2barj(254);
Z3254bar  = Z3barj(254);
Z4254bar  = Z4barj(254);

alph255   = alphj(255);
f255      = fj(255);
PsP255    = PsPj(255);
Lam255bar = Lambarj(255);
S255bar   = Sbarj(255);
Z1255bar  = Z1barj(255);
Z2255bar  = Z2barj(255);
Z3255bar  = Z3barj(255);
Z4255bar  = Z4barj(255);

alph256   = alphj(256);
f256      = fj(256);
PsP256    = PsPj(256);
Lam256bar = Lambarj(256);
S256bar   = Sbarj(256);
Z1256bar  = Z1barj(256);
Z2256bar  = Z2barj(256);
Z3256bar  = Z3barj(256);
Z4256bar  = Z4barj(256);

alph257   = alphj(257);
f257      = fj(257);
PsP257    = PsPj(257);
Lam257bar = Lambarj(257);
S257bar   = Sbarj(257);
Z1257bar  = Z1barj(257);
Z2257bar  = Z2barj(257);
Z3257bar  = Z3barj(257);
Z4257bar  = Z4barj(257);

alph258   = alphj(258);
f258      = fj(258);
PsP258    = PsPj(258);
Lam258bar = Lambarj(258);
S258bar   = Sbarj(258);
Z1258bar  = Z1barj(258);
Z2258bar  = Z2barj(258);
Z3258bar  = Z3barj(258);
Z4258bar  = Z4barj(258);

alph259   = alphj(259);
f259      = fj(259);
PsP259    = PsPj(259);
Lam259bar = Lambarj(259);
S259bar   = Sbarj(259);
Z1259bar  = Z1barj(259);
Z2259bar  = Z2barj(259);
Z3259bar  = Z3barj(259);
Z4259bar  = Z4barj(259);

alph260   = alphj(260);
f260      = fj(260);
PsP260    = PsPj(260);
Lam260bar = Lambarj(260);
S260bar   = Sbarj(260);
Z1260bar  = Z1barj(260);
Z2260bar  = Z2barj(260);
Z3260bar  = Z3barj(260);
Z4260bar  = Z4barj(260);

alph261   = alphj(261);
f261      = fj(261);
PsP261    = PsPj(261);
Lam261bar = Lambarj(261);
S261bar   = Sbarj(261);
Z1261bar  = Z1barj(261);
Z2261bar  = Z2barj(261);
Z3261bar  = Z3barj(261);
Z4261bar  = Z4barj(261);

alph262   = alphj(262);
f262      = fj(262);
PsP262    = PsPj(262);
Lam262bar = Lambarj(262);
S262bar   = Sbarj(262);
Z1262bar  = Z1barj(262);
Z2262bar  = Z2barj(262);
Z3262bar  = Z3barj(262);
Z4262bar  = Z4barj(262);

alph263   = alphj(263);
f263      = fj(263);
PsP263    = PsPj(263);
Lam263bar = Lambarj(263);
S263bar   = Sbarj(263);
Z1263bar  = Z1barj(263);
Z2263bar  = Z2barj(263);
Z3263bar  = Z3barj(263);
Z4263bar  = Z4barj(263);

alph264   = alphj(264);
f264      = fj(264);
PsP264    = PsPj(264);
Lam264bar = Lambarj(264);
S264bar   = Sbarj(264);
Z1264bar  = Z1barj(264);
Z2264bar  = Z2barj(264);
Z3264bar  = Z3barj(264);
Z4264bar  = Z4barj(264);

alph265   = alphj(265);
f265      = fj(265);
PsP265    = PsPj(265);
Lam265bar = Lambarj(265);
S265bar   = Sbarj(265);
Z1265bar  = Z1barj(265);
Z2265bar  = Z2barj(265);
Z3265bar  = Z3barj(265);
Z4265bar  = Z4barj(265);

alph266   = alphj(266);
f266      = fj(266);
PsP266    = PsPj(266);
Lam266bar = Lambarj(266);
S266bar   = Sbarj(266);
Z1266bar  = Z1barj(266);
Z2266bar  = Z2barj(266);
Z3266bar  = Z3barj(266);
Z4266bar  = Z4barj(266);

alph267   = alphj(267);
f267      = fj(267);
PsP267    = PsPj(267);
Lam267bar = Lambarj(267);
S267bar   = Sbarj(267);
Z1267bar  = Z1barj(267);
Z2267bar  = Z2barj(267);
Z3267bar  = Z3barj(267);
Z4267bar  = Z4barj(267);

alph268   = alphj(268);
f268      = fj(268);
PsP268    = PsPj(268);
Lam268bar = Lambarj(268);
S268bar   = Sbarj(268);
Z1268bar  = Z1barj(268);
Z2268bar  = Z2barj(268);
Z3268bar  = Z3barj(268);
Z4268bar  = Z4barj(268);

alph269   = alphj(269);
f269      = fj(269);
PsP269    = PsPj(269);
Lam269bar = Lambarj(269);
S269bar   = Sbarj(269);
Z1269bar  = Z1barj(269);
Z2269bar  = Z2barj(269);
Z3269bar  = Z3barj(269);
Z4269bar  = Z4barj(269);

alph270   = alphj(270);
f270      = fj(270);
PsP270    = PsPj(270);
Lam270bar = Lambarj(270);
S270bar   = Sbarj(270);
Z1270bar  = Z1barj(270);
Z2270bar  = Z2barj(270);
Z3270bar  = Z3barj(270);
Z4270bar  = Z4barj(270);

alph271   = alphj(271);
f271      = fj(271);
PsP271    = PsPj(271);
Lam271bar = Lambarj(271);
S271bar   = Sbarj(271);
Z1271bar  = Z1barj(271);
Z2271bar  = Z2barj(271);
Z3271bar  = Z3barj(271);
Z4271bar  = Z4barj(271);

alph272   = alphj(272);
f272      = fj(272);
PsP272    = PsPj(272);
Lam272bar = Lambarj(272);
S272bar   = Sbarj(272);
Z1272bar  = Z1barj(272);
Z2272bar  = Z2barj(272);
Z3272bar  = Z3barj(272);
Z4272bar  = Z4barj(272);

%% defining variables

var y i p lam;
var ps001 s001 lam001 z1001 z2001 z3001 z4001;
var ps002 s002 lam002 z1002 z2002 z3002 z4002;
var ps003 s003 lam003 z1003 z2003 z3003 z4003;
var ps004 s004 lam004 z1004 z2004 z3004 z4004;
var ps005 s005 lam005 z1005 z2005 z3005 z4005;
var ps006 s006 lam006 z1006 z2006 z3006 z4006;
var ps007 s007 lam007 z1007 z2007 z3007 z4007;
var ps008 s008 lam008 z1008 z2008 z3008 z4008;
var ps009 s009 lam009 z1009 z2009 z3009 z4009;
var ps010 s010 lam010 z1010 z2010 z3010 z4010;
var ps011 s011 lam011 z1011 z2011 z3011 z4011;
var ps012 s012 lam012 z1012 z2012 z3012 z4012;
var ps013 s013 lam013 z1013 z2013 z3013 z4013;
var ps014 s014 lam014 z1014 z2014 z3014 z4014;
var ps015 s015 lam015 z1015 z2015 z3015 z4015;
var ps016 s016 lam016 z1016 z2016 z3016 z4016;
var ps017 s017 lam017 z1017 z2017 z3017 z4017;
var ps018 s018 lam018 z1018 z2018 z3018 z4018;
var ps019 s019 lam019 z1019 z2019 z3019 z4019;
var ps020 s020 lam020 z1020 z2020 z3020 z4020;
var ps021 s021 lam021 z1021 z2021 z3021 z4021;
var ps022 s022 lam022 z1022 z2022 z3022 z4022;
var ps023 s023 lam023 z1023 z2023 z3023 z4023;
var ps024 s024 lam024 z1024 z2024 z3024 z4024;
var ps025 s025 lam025 z1025 z2025 z3025 z4025;
var ps026 s026 lam026 z1026 z2026 z3026 z4026;
var ps027 s027 lam027 z1027 z2027 z3027 z4027;
var ps028 s028 lam028 z1028 z2028 z3028 z4028;
var ps029 s029 lam029 z1029 z2029 z3029 z4029;
var ps030 s030 lam030 z1030 z2030 z3030 z4030;
var ps031 s031 lam031 z1031 z2031 z3031 z4031;
var ps032 s032 lam032 z1032 z2032 z3032 z4032;
var ps033 s033 lam033 z1033 z2033 z3033 z4033;
var ps034 s034 lam034 z1034 z2034 z3034 z4034;
var ps035 s035 lam035 z1035 z2035 z3035 z4035;
var ps036 s036 lam036 z1036 z2036 z3036 z4036;
var ps037 s037 lam037 z1037 z2037 z3037 z4037;
var ps038 s038 lam038 z1038 z2038 z3038 z4038;
var ps039 s039 lam039 z1039 z2039 z3039 z4039;
var ps040 s040 lam040 z1040 z2040 z3040 z4040;
var ps041 s041 lam041 z1041 z2041 z3041 z4041;
var ps042 s042 lam042 z1042 z2042 z3042 z4042;
var ps043 s043 lam043 z1043 z2043 z3043 z4043;
var ps044 s044 lam044 z1044 z2044 z3044 z4044;
var ps045 s045 lam045 z1045 z2045 z3045 z4045;
var ps046 s046 lam046 z1046 z2046 z3046 z4046;
var ps047 s047 lam047 z1047 z2047 z3047 z4047;
var ps048 s048 lam048 z1048 z2048 z3048 z4048;
var ps049 s049 lam049 z1049 z2049 z3049 z4049;
var ps050 s050 lam050 z1050 z2050 z3050 z4050;
var ps051 s051 lam051 z1051 z2051 z3051 z4051;
var ps052 s052 lam052 z1052 z2052 z3052 z4052;
var ps053 s053 lam053 z1053 z2053 z3053 z4053;
var ps054 s054 lam054 z1054 z2054 z3054 z4054;
var ps055 s055 lam055 z1055 z2055 z3055 z4055;
var ps056 s056 lam056 z1056 z2056 z3056 z4056;
var ps057 s057 lam057 z1057 z2057 z3057 z4057;
var ps058 s058 lam058 z1058 z2058 z3058 z4058;
var ps059 s059 lam059 z1059 z2059 z3059 z4059;
var ps060 s060 lam060 z1060 z2060 z3060 z4060;
var ps061 s061 lam061 z1061 z2061 z3061 z4061;
var ps062 s062 lam062 z1062 z2062 z3062 z4062;
var ps063 s063 lam063 z1063 z2063 z3063 z4063;
var ps064 s064 lam064 z1064 z2064 z3064 z4064;
var ps065 s065 lam065 z1065 z2065 z3065 z4065;
var ps066 s066 lam066 z1066 z2066 z3066 z4066;
var ps067 s067 lam067 z1067 z2067 z3067 z4067;
var ps068 s068 lam068 z1068 z2068 z3068 z4068;
var ps069 s069 lam069 z1069 z2069 z3069 z4069;
var ps070 s070 lam070 z1070 z2070 z3070 z4070;
var ps071 s071 lam071 z1071 z2071 z3071 z4071;
var ps072 s072 lam072 z1072 z2072 z3072 z4072;
var ps073 s073 lam073 z1073 z2073 z3073 z4073;
var ps074 s074 lam074 z1074 z2074 z3074 z4074;
var ps075 s075 lam075 z1075 z2075 z3075 z4075;
var ps076 s076 lam076 z1076 z2076 z3076 z4076;
var ps077 s077 lam077 z1077 z2077 z3077 z4077;
var ps078 s078 lam078 z1078 z2078 z3078 z4078;
var ps079 s079 lam079 z1079 z2079 z3079 z4079;
var ps080 s080 lam080 z1080 z2080 z3080 z4080;
var ps081 s081 lam081 z1081 z2081 z3081 z4081;
var ps082 s082 lam082 z1082 z2082 z3082 z4082;
var ps083 s083 lam083 z1083 z2083 z3083 z4083;
var ps084 s084 lam084 z1084 z2084 z3084 z4084;
var ps085 s085 lam085 z1085 z2085 z3085 z4085;
var ps086 s086 lam086 z1086 z2086 z3086 z4086;
var ps087 s087 lam087 z1087 z2087 z3087 z4087;
var ps088 s088 lam088 z1088 z2088 z3088 z4088;
var ps089 s089 lam089 z1089 z2089 z3089 z4089;
var ps090 s090 lam090 z1090 z2090 z3090 z4090;
var ps091 s091 lam091 z1091 z2091 z3091 z4091;
var ps092 s092 lam092 z1092 z2092 z3092 z4092;
var ps093 s093 lam093 z1093 z2093 z3093 z4093;
var ps094 s094 lam094 z1094 z2094 z3094 z4094;
var ps095 s095 lam095 z1095 z2095 z3095 z4095;
var ps096 s096 lam096 z1096 z2096 z3096 z4096;
var ps097 s097 lam097 z1097 z2097 z3097 z4097;
var ps098 s098 lam098 z1098 z2098 z3098 z4098;
var ps099 s099 lam099 z1099 z2099 z3099 z4099;
var ps100 s100 lam100 z1100 z2100 z3100 z4100;
var ps101 s101 lam101 z1101 z2101 z3101 z4101;
var ps102 s102 lam102 z1102 z2102 z3102 z4102;
var ps103 s103 lam103 z1103 z2103 z3103 z4103;
var ps104 s104 lam104 z1104 z2104 z3104 z4104;
var ps105 s105 lam105 z1105 z2105 z3105 z4105;
var ps106 s106 lam106 z1106 z2106 z3106 z4106;
var ps107 s107 lam107 z1107 z2107 z3107 z4107;
var ps108 s108 lam108 z1108 z2108 z3108 z4108;
var ps109 s109 lam109 z1109 z2109 z3109 z4109;
var ps110 s110 lam110 z1110 z2110 z3110 z4110;
var ps111 s111 lam111 z1111 z2111 z3111 z4111;
var ps112 s112 lam112 z1112 z2112 z3112 z4112;
var ps113 s113 lam113 z1113 z2113 z3113 z4113;
var ps114 s114 lam114 z1114 z2114 z3114 z4114;
var ps115 s115 lam115 z1115 z2115 z3115 z4115;
var ps116 s116 lam116 z1116 z2116 z3116 z4116;
var ps117 s117 lam117 z1117 z2117 z3117 z4117;
var ps118 s118 lam118 z1118 z2118 z3118 z4118;
var ps119 s119 lam119 z1119 z2119 z3119 z4119;
var ps120 s120 lam120 z1120 z2120 z3120 z4120;
var ps121 s121 lam121 z1121 z2121 z3121 z4121;
var ps122 s122 lam122 z1122 z2122 z3122 z4122;
var ps123 s123 lam123 z1123 z2123 z3123 z4123;
var ps124 s124 lam124 z1124 z2124 z3124 z4124;
var ps125 s125 lam125 z1125 z2125 z3125 z4125;
var ps126 s126 lam126 z1126 z2126 z3126 z4126;
var ps127 s127 lam127 z1127 z2127 z3127 z4127;
var ps128 s128 lam128 z1128 z2128 z3128 z4128;
var ps129 s129 lam129 z1129 z2129 z3129 z4129;
var ps130 s130 lam130 z1130 z2130 z3130 z4130;
var ps131 s131 lam131 z1131 z2131 z3131 z4131;
var ps132 s132 lam132 z1132 z2132 z3132 z4132;
var ps133 s133 lam133 z1133 z2133 z3133 z4133;
var ps134 s134 lam134 z1134 z2134 z3134 z4134;
var ps135 s135 lam135 z1135 z2135 z3135 z4135;
var ps136 s136 lam136 z1136 z2136 z3136 z4136;
var ps137 s137 lam137 z1137 z2137 z3137 z4137;
var ps138 s138 lam138 z1138 z2138 z3138 z4138;
var ps139 s139 lam139 z1139 z2139 z3139 z4139;
var ps140 s140 lam140 z1140 z2140 z3140 z4140;
var ps141 s141 lam141 z1141 z2141 z3141 z4141;
var ps142 s142 lam142 z1142 z2142 z3142 z4142;
var ps143 s143 lam143 z1143 z2143 z3143 z4143;
var ps144 s144 lam144 z1144 z2144 z3144 z4144;
var ps145 s145 lam145 z1145 z2145 z3145 z4145;
var ps146 s146 lam146 z1146 z2146 z3146 z4146;
var ps147 s147 lam147 z1147 z2147 z3147 z4147;
var ps148 s148 lam148 z1148 z2148 z3148 z4148;
var ps149 s149 lam149 z1149 z2149 z3149 z4149;
var ps150 s150 lam150 z1150 z2150 z3150 z4150;
var ps151 s151 lam151 z1151 z2151 z3151 z4151;
var ps152 s152 lam152 z1152 z2152 z3152 z4152;
var ps153 s153 lam153 z1153 z2153 z3153 z4153;
var ps154 s154 lam154 z1154 z2154 z3154 z4154;
var ps155 s155 lam155 z1155 z2155 z3155 z4155;
var ps156 s156 lam156 z1156 z2156 z3156 z4156;
var ps157 s157 lam157 z1157 z2157 z3157 z4157;
var ps158 s158 lam158 z1158 z2158 z3158 z4158;
var ps159 s159 lam159 z1159 z2159 z3159 z4159;
var ps160 s160 lam160 z1160 z2160 z3160 z4160;
var ps161 s161 lam161 z1161 z2161 z3161 z4161;
var ps162 s162 lam162 z1162 z2162 z3162 z4162;
var ps163 s163 lam163 z1163 z2163 z3163 z4163;
var ps164 s164 lam164 z1164 z2164 z3164 z4164;
var ps165 s165 lam165 z1165 z2165 z3165 z4165;
var ps166 s166 lam166 z1166 z2166 z3166 z4166;
var ps167 s167 lam167 z1167 z2167 z3167 z4167;
var ps168 s168 lam168 z1168 z2168 z3168 z4168;
var ps169 s169 lam169 z1169 z2169 z3169 z4169;
var ps170 s170 lam170 z1170 z2170 z3170 z4170;
var ps171 s171 lam171 z1171 z2171 z3171 z4171;
var ps172 s172 lam172 z1172 z2172 z3172 z4172;
var ps173 s173 lam173 z1173 z2173 z3173 z4173;
var ps174 s174 lam174 z1174 z2174 z3174 z4174;
var ps175 s175 lam175 z1175 z2175 z3175 z4175;
var ps176 s176 lam176 z1176 z2176 z3176 z4176;
var ps177 s177 lam177 z1177 z2177 z3177 z4177;
var ps178 s178 lam178 z1178 z2178 z3178 z4178;
var ps179 s179 lam179 z1179 z2179 z3179 z4179;
var ps180 s180 lam180 z1180 z2180 z3180 z4180;
var ps181 s181 lam181 z1181 z2181 z3181 z4181;
var ps182 s182 lam182 z1182 z2182 z3182 z4182;
var ps183 s183 lam183 z1183 z2183 z3183 z4183;
var ps184 s184 lam184 z1184 z2184 z3184 z4184;
var ps185 s185 lam185 z1185 z2185 z3185 z4185;
var ps186 s186 lam186 z1186 z2186 z3186 z4186;
var ps187 s187 lam187 z1187 z2187 z3187 z4187;
var ps188 s188 lam188 z1188 z2188 z3188 z4188;
var ps189 s189 lam189 z1189 z2189 z3189 z4189;
var ps190 s190 lam190 z1190 z2190 z3190 z4190;
var ps191 s191 lam191 z1191 z2191 z3191 z4191;
var ps192 s192 lam192 z1192 z2192 z3192 z4192;
var ps193 s193 lam193 z1193 z2193 z3193 z4193;
var ps194 s194 lam194 z1194 z2194 z3194 z4194;
var ps195 s195 lam195 z1195 z2195 z3195 z4195;
var ps196 s196 lam196 z1196 z2196 z3196 z4196;
var ps197 s197 lam197 z1197 z2197 z3197 z4197;
var ps198 s198 lam198 z1198 z2198 z3198 z4198;
var ps199 s199 lam199 z1199 z2199 z3199 z4199;
var ps200 s200 lam200 z1200 z2200 z3200 z4200;
var ps201 s201 lam201 z1201 z2201 z3201 z4201;
var ps202 s202 lam202 z1202 z2202 z3202 z4202;
var ps203 s203 lam203 z1203 z2203 z3203 z4203;
var ps204 s204 lam204 z1204 z2204 z3204 z4204;
var ps205 s205 lam205 z1205 z2205 z3205 z4205;
var ps206 s206 lam206 z1206 z2206 z3206 z4206;
var ps207 s207 lam207 z1207 z2207 z3207 z4207;
var ps208 s208 lam208 z1208 z2208 z3208 z4208;
var ps209 s209 lam209 z1209 z2209 z3209 z4209;
var ps210 s210 lam210 z1210 z2210 z3210 z4210;
var ps211 s211 lam211 z1211 z2211 z3211 z4211;
var ps212 s212 lam212 z1212 z2212 z3212 z4212;
var ps213 s213 lam213 z1213 z2213 z3213 z4213;
var ps214 s214 lam214 z1214 z2214 z3214 z4214;
var ps215 s215 lam215 z1215 z2215 z3215 z4215;
var ps216 s216 lam216 z1216 z2216 z3216 z4216;
var ps217 s217 lam217 z1217 z2217 z3217 z4217;
var ps218 s218 lam218 z1218 z2218 z3218 z4218;
var ps219 s219 lam219 z1219 z2219 z3219 z4219;
var ps220 s220 lam220 z1220 z2220 z3220 z4220;
var ps221 s221 lam221 z1221 z2221 z3221 z4221;
var ps222 s222 lam222 z1222 z2222 z3222 z4222;
var ps223 s223 lam223 z1223 z2223 z3223 z4223;
var ps224 s224 lam224 z1224 z2224 z3224 z4224;
var ps225 s225 lam225 z1225 z2225 z3225 z4225;
var ps226 s226 lam226 z1226 z2226 z3226 z4226;
var ps227 s227 lam227 z1227 z2227 z3227 z4227;
var ps228 s228 lam228 z1228 z2228 z3228 z4228;
var ps229 s229 lam229 z1229 z2229 z3229 z4229;
var ps230 s230 lam230 z1230 z2230 z3230 z4230;
var ps231 s231 lam231 z1231 z2231 z3231 z4231;
var ps232 s232 lam232 z1232 z2232 z3232 z4232;
var ps233 s233 lam233 z1233 z2233 z3233 z4233;
var ps234 s234 lam234 z1234 z2234 z3234 z4234;
var ps235 s235 lam235 z1235 z2235 z3235 z4235;
var ps236 s236 lam236 z1236 z2236 z3236 z4236;
var ps237 s237 lam237 z1237 z2237 z3237 z4237;
var ps238 s238 lam238 z1238 z2238 z3238 z4238;
var ps239 s239 lam239 z1239 z2239 z3239 z4239;
var ps240 s240 lam240 z1240 z2240 z3240 z4240;
var ps241 s241 lam241 z1241 z2241 z3241 z4241;
var ps242 s242 lam242 z1242 z2242 z3242 z4242;
var ps243 s243 lam243 z1243 z2243 z3243 z4243;
var ps244 s244 lam244 z1244 z2244 z3244 z4244;
var ps245 s245 lam245 z1245 z2245 z3245 z4245;
var ps246 s246 lam246 z1246 z2246 z3246 z4246;
var ps247 s247 lam247 z1247 z2247 z3247 z4247;
var ps248 s248 lam248 z1248 z2248 z3248 z4248;
var ps249 s249 lam249 z1249 z2249 z3249 z4249;
var ps250 s250 lam250 z1250 z2250 z3250 z4250;
var ps251 s251 lam251 z1251 z2251 z3251 z4251;
var ps252 s252 lam252 z1252 z2252 z3252 z4252;
var ps253 s253 lam253 z1253 z2253 z3253 z4253;
var ps254 s254 lam254 z1254 z2254 z3254 z4254;
var ps255 s255 lam255 z1255 z2255 z3255 z4255;
var ps256 s256 lam256 z1256 z2256 z3256 z4256;
var ps257 s257 lam257 z1257 z2257 z3257 z4257;
var ps258 s258 lam258 z1258 z2258 z3258 z4258;
var ps259 s259 lam259 z1259 z2259 z3259 z4259;
var ps260 s260 lam260 z1260 z2260 z3260 z4260;
var ps261 s261 lam261 z1261 z2261 z3261 z4261;
var ps262 s262 lam262 z1262 z2262 z3262 z4262;
var ps263 s263 lam263 z1263 z2263 z3263 z4263;
var ps264 s264 lam264 z1264 z2264 z3264 z4264;
var ps265 s265 lam265 z1265 z2265 z3265 z4265;
var ps266 s266 lam266 z1266 z2266 z3266 z4266;
var ps267 s267 lam267 z1267 z2267 z3267 z4267;
var ps268 s268 lam268 z1268 z2268 z3268 z4268;
var ps269 s269 lam269 z1269 z2269 z3269 z4269;
var ps270 s270 lam270 z1270 z2270 z3270 z4270;
var ps271 s271 lam271 z1271 z2271 z3271 z4271;
var ps272 s272 lam272 z1272 z2272 z3272 z4272;

%% defining exogenous variables

varexo er;

%% shocks

shocks;
var er;
stderr 1;
end;

%% model equations in the same order as in our notes

model(linear);

y = y(+1) - 1/sigm*(i - p(+1));

% lam  = f1*(Lam1bar/Lambar)^(1-theta*(1-ppsi))*lam1 + f2*(Lam2bar/Lambar)^(1-theta*(1-ppsi))*lam2;
lam = f001*(Lam001bar/Lambar)^(1-theta*(1-ppsi))*lam001+f002*(Lam002bar/Lambar)^(1-theta*(1-ppsi))*lam002+f003*(Lam003bar/Lambar)^(1-theta*(1-ppsi))*lam003+f004*(Lam004bar/Lambar)^(1-theta*(1-ppsi))*lam004+f005*(Lam005bar/Lambar)^(1-theta*(1-ppsi))*lam005+f006*(Lam006bar/Lambar)^(1-theta*(1-ppsi))*lam006+f007*(Lam007bar/Lambar)^(1-theta*(1-ppsi))*lam007+f008*(Lam008bar/Lambar)^(1-theta*(1-ppsi))*lam008+f009*(Lam009bar/Lambar)^(1-theta*(1-ppsi))*lam009+f010*(Lam010bar/Lambar)^(1-theta*(1-ppsi))*lam010+f011*(Lam011bar/Lambar)^(1-theta*(1-ppsi))*lam011+f012*(Lam012bar/Lambar)^(1-theta*(1-ppsi))*lam012+f013*(Lam013bar/Lambar)^(1-theta*(1-ppsi))*lam013+f014*(Lam014bar/Lambar)^(1-theta*(1-ppsi))*lam014+f015*(Lam015bar/Lambar)^(1-theta*(1-ppsi))*lam015+f016*(Lam016bar/Lambar)^(1-theta*(1-ppsi))*lam016+f017*(Lam017bar/Lambar)^(1-theta*(1-ppsi))*lam017+f018*(Lam018bar/Lambar)^(1-theta*(1-ppsi))*lam018+f019*(Lam019bar/Lambar)^(1-theta*(1-ppsi))*lam019+f020*(Lam020bar/Lambar)^(1-theta*(1-ppsi))*lam020+f021*(Lam021bar/Lambar)^(1-theta*(1-ppsi))*lam021+f022*(Lam022bar/Lambar)^(1-theta*(1-ppsi))*lam022+f023*(Lam023bar/Lambar)^(1-theta*(1-ppsi))*lam023+f024*(Lam024bar/Lambar)^(1-theta*(1-ppsi))*lam024+f025*(Lam025bar/Lambar)^(1-theta*(1-ppsi))*lam025+f026*(Lam026bar/Lambar)^(1-theta*(1-ppsi))*lam026+f027*(Lam027bar/Lambar)^(1-theta*(1-ppsi))*lam027+f028*(Lam028bar/Lambar)^(1-theta*(1-ppsi))*lam028+f029*(Lam029bar/Lambar)^(1-theta*(1-ppsi))*lam029+f030*(Lam030bar/Lambar)^(1-theta*(1-ppsi))*lam030+f031*(Lam031bar/Lambar)^(1-theta*(1-ppsi))*lam031+f032*(Lam032bar/Lambar)^(1-theta*(1-ppsi))*lam032+f033*(Lam033bar/Lambar)^(1-theta*(1-ppsi))*lam033+f034*(Lam034bar/Lambar)^(1-theta*(1-ppsi))*lam034+f035*(Lam035bar/Lambar)^(1-theta*(1-ppsi))*lam035+f036*(Lam036bar/Lambar)^(1-theta*(1-ppsi))*lam036+f037*(Lam037bar/Lambar)^(1-theta*(1-ppsi))*lam037+f038*(Lam038bar/Lambar)^(1-theta*(1-ppsi))*lam038+f039*(Lam039bar/Lambar)^(1-theta*(1-ppsi))*lam039+f040*(Lam040bar/Lambar)^(1-theta*(1-ppsi))*lam040+f041*(Lam041bar/Lambar)^(1-theta*(1-ppsi))*lam041+f042*(Lam042bar/Lambar)^(1-theta*(1-ppsi))*lam042+f043*(Lam043bar/Lambar)^(1-theta*(1-ppsi))*lam043+f044*(Lam044bar/Lambar)^(1-theta*(1-ppsi))*lam044+f045*(Lam045bar/Lambar)^(1-theta*(1-ppsi))*lam045+f046*(Lam046bar/Lambar)^(1-theta*(1-ppsi))*lam046+f047*(Lam047bar/Lambar)^(1-theta*(1-ppsi))*lam047+f048*(Lam048bar/Lambar)^(1-theta*(1-ppsi))*lam048+f049*(Lam049bar/Lambar)^(1-theta*(1-ppsi))*lam049+f050*(Lam050bar/Lambar)^(1-theta*(1-ppsi))*lam050+f051*(Lam051bar/Lambar)^(1-theta*(1-ppsi))*lam051+f052*(Lam052bar/Lambar)^(1-theta*(1-ppsi))*lam052+f053*(Lam053bar/Lambar)^(1-theta*(1-ppsi))*lam053+f054*(Lam054bar/Lambar)^(1-theta*(1-ppsi))*lam054+f055*(Lam055bar/Lambar)^(1-theta*(1-ppsi))*lam055+f056*(Lam056bar/Lambar)^(1-theta*(1-ppsi))*lam056+f057*(Lam057bar/Lambar)^(1-theta*(1-ppsi))*lam057+f058*(Lam058bar/Lambar)^(1-theta*(1-ppsi))*lam058+f059*(Lam059bar/Lambar)^(1-theta*(1-ppsi))*lam059+f060*(Lam060bar/Lambar)^(1-theta*(1-ppsi))*lam060+f061*(Lam061bar/Lambar)^(1-theta*(1-ppsi))*lam061+f062*(Lam062bar/Lambar)^(1-theta*(1-ppsi))*lam062+f063*(Lam063bar/Lambar)^(1-theta*(1-ppsi))*lam063+f064*(Lam064bar/Lambar)^(1-theta*(1-ppsi))*lam064+f065*(Lam065bar/Lambar)^(1-theta*(1-ppsi))*lam065+f066*(Lam066bar/Lambar)^(1-theta*(1-ppsi))*lam066+f067*(Lam067bar/Lambar)^(1-theta*(1-ppsi))*lam067+f068*(Lam068bar/Lambar)^(1-theta*(1-ppsi))*lam068+f069*(Lam069bar/Lambar)^(1-theta*(1-ppsi))*lam069+f070*(Lam070bar/Lambar)^(1-theta*(1-ppsi))*lam070+f071*(Lam071bar/Lambar)^(1-theta*(1-ppsi))*lam071+f072*(Lam072bar/Lambar)^(1-theta*(1-ppsi))*lam072+f073*(Lam073bar/Lambar)^(1-theta*(1-ppsi))*lam073+f074*(Lam074bar/Lambar)^(1-theta*(1-ppsi))*lam074+f075*(Lam075bar/Lambar)^(1-theta*(1-ppsi))*lam075+f076*(Lam076bar/Lambar)^(1-theta*(1-ppsi))*lam076+f077*(Lam077bar/Lambar)^(1-theta*(1-ppsi))*lam077+f078*(Lam078bar/Lambar)^(1-theta*(1-ppsi))*lam078+f079*(Lam079bar/Lambar)^(1-theta*(1-ppsi))*lam079+f080*(Lam080bar/Lambar)^(1-theta*(1-ppsi))*lam080+f081*(Lam081bar/Lambar)^(1-theta*(1-ppsi))*lam081+f082*(Lam082bar/Lambar)^(1-theta*(1-ppsi))*lam082+f083*(Lam083bar/Lambar)^(1-theta*(1-ppsi))*lam083+f084*(Lam084bar/Lambar)^(1-theta*(1-ppsi))*lam084+f085*(Lam085bar/Lambar)^(1-theta*(1-ppsi))*lam085+f086*(Lam086bar/Lambar)^(1-theta*(1-ppsi))*lam086+f087*(Lam087bar/Lambar)^(1-theta*(1-ppsi))*lam087+f088*(Lam088bar/Lambar)^(1-theta*(1-ppsi))*lam088+f089*(Lam089bar/Lambar)^(1-theta*(1-ppsi))*lam089+f090*(Lam090bar/Lambar)^(1-theta*(1-ppsi))*lam090+f091*(Lam091bar/Lambar)^(1-theta*(1-ppsi))*lam091+f092*(Lam092bar/Lambar)^(1-theta*(1-ppsi))*lam092+f093*(Lam093bar/Lambar)^(1-theta*(1-ppsi))*lam093+f094*(Lam094bar/Lambar)^(1-theta*(1-ppsi))*lam094+f095*(Lam095bar/Lambar)^(1-theta*(1-ppsi))*lam095+f096*(Lam096bar/Lambar)^(1-theta*(1-ppsi))*lam096+f097*(Lam097bar/Lambar)^(1-theta*(1-ppsi))*lam097+f098*(Lam098bar/Lambar)^(1-theta*(1-ppsi))*lam098+f099*(Lam099bar/Lambar)^(1-theta*(1-ppsi))*lam099+f100*(Lam100bar/Lambar)^(1-theta*(1-ppsi))*lam100+f101*(Lam101bar/Lambar)^(1-theta*(1-ppsi))*lam101+f102*(Lam102bar/Lambar)^(1-theta*(1-ppsi))*lam102+f103*(Lam103bar/Lambar)^(1-theta*(1-ppsi))*lam103+f104*(Lam104bar/Lambar)^(1-theta*(1-ppsi))*lam104+f105*(Lam105bar/Lambar)^(1-theta*(1-ppsi))*lam105+f106*(Lam106bar/Lambar)^(1-theta*(1-ppsi))*lam106+f107*(Lam107bar/Lambar)^(1-theta*(1-ppsi))*lam107+f108*(Lam108bar/Lambar)^(1-theta*(1-ppsi))*lam108+f109*(Lam109bar/Lambar)^(1-theta*(1-ppsi))*lam109+f110*(Lam110bar/Lambar)^(1-theta*(1-ppsi))*lam110+f111*(Lam111bar/Lambar)^(1-theta*(1-ppsi))*lam111+f112*(Lam112bar/Lambar)^(1-theta*(1-ppsi))*lam112+f113*(Lam113bar/Lambar)^(1-theta*(1-ppsi))*lam113+f114*(Lam114bar/Lambar)^(1-theta*(1-ppsi))*lam114+f115*(Lam115bar/Lambar)^(1-theta*(1-ppsi))*lam115+f116*(Lam116bar/Lambar)^(1-theta*(1-ppsi))*lam116+f117*(Lam117bar/Lambar)^(1-theta*(1-ppsi))*lam117+f118*(Lam118bar/Lambar)^(1-theta*(1-ppsi))*lam118+f119*(Lam119bar/Lambar)^(1-theta*(1-ppsi))*lam119+f120*(Lam120bar/Lambar)^(1-theta*(1-ppsi))*lam120+f121*(Lam121bar/Lambar)^(1-theta*(1-ppsi))*lam121+f122*(Lam122bar/Lambar)^(1-theta*(1-ppsi))*lam122+f123*(Lam123bar/Lambar)^(1-theta*(1-ppsi))*lam123+f124*(Lam124bar/Lambar)^(1-theta*(1-ppsi))*lam124+f125*(Lam125bar/Lambar)^(1-theta*(1-ppsi))*lam125+f126*(Lam126bar/Lambar)^(1-theta*(1-ppsi))*lam126+f127*(Lam127bar/Lambar)^(1-theta*(1-ppsi))*lam127+f128*(Lam128bar/Lambar)^(1-theta*(1-ppsi))*lam128+f129*(Lam129bar/Lambar)^(1-theta*(1-ppsi))*lam129+f130*(Lam130bar/Lambar)^(1-theta*(1-ppsi))*lam130+f131*(Lam131bar/Lambar)^(1-theta*(1-ppsi))*lam131+f132*(Lam132bar/Lambar)^(1-theta*(1-ppsi))*lam132+f133*(Lam133bar/Lambar)^(1-theta*(1-ppsi))*lam133+f134*(Lam134bar/Lambar)^(1-theta*(1-ppsi))*lam134+f135*(Lam135bar/Lambar)^(1-theta*(1-ppsi))*lam135+f136*(Lam136bar/Lambar)^(1-theta*(1-ppsi))*lam136+f137*(Lam137bar/Lambar)^(1-theta*(1-ppsi))*lam137+f138*(Lam138bar/Lambar)^(1-theta*(1-ppsi))*lam138+f139*(Lam139bar/Lambar)^(1-theta*(1-ppsi))*lam139+f140*(Lam140bar/Lambar)^(1-theta*(1-ppsi))*lam140+f141*(Lam141bar/Lambar)^(1-theta*(1-ppsi))*lam141+f142*(Lam142bar/Lambar)^(1-theta*(1-ppsi))*lam142+f143*(Lam143bar/Lambar)^(1-theta*(1-ppsi))*lam143+f144*(Lam144bar/Lambar)^(1-theta*(1-ppsi))*lam144+f145*(Lam145bar/Lambar)^(1-theta*(1-ppsi))*lam145+f146*(Lam146bar/Lambar)^(1-theta*(1-ppsi))*lam146+f147*(Lam147bar/Lambar)^(1-theta*(1-ppsi))*lam147+f148*(Lam148bar/Lambar)^(1-theta*(1-ppsi))*lam148+f149*(Lam149bar/Lambar)^(1-theta*(1-ppsi))*lam149+f150*(Lam150bar/Lambar)^(1-theta*(1-ppsi))*lam150+f151*(Lam151bar/Lambar)^(1-theta*(1-ppsi))*lam151+f152*(Lam152bar/Lambar)^(1-theta*(1-ppsi))*lam152+f153*(Lam153bar/Lambar)^(1-theta*(1-ppsi))*lam153+f154*(Lam154bar/Lambar)^(1-theta*(1-ppsi))*lam154+f155*(Lam155bar/Lambar)^(1-theta*(1-ppsi))*lam155+f156*(Lam156bar/Lambar)^(1-theta*(1-ppsi))*lam156+f157*(Lam157bar/Lambar)^(1-theta*(1-ppsi))*lam157+f158*(Lam158bar/Lambar)^(1-theta*(1-ppsi))*lam158+f159*(Lam159bar/Lambar)^(1-theta*(1-ppsi))*lam159+f160*(Lam160bar/Lambar)^(1-theta*(1-ppsi))*lam160+f161*(Lam161bar/Lambar)^(1-theta*(1-ppsi))*lam161+f162*(Lam162bar/Lambar)^(1-theta*(1-ppsi))*lam162+f163*(Lam163bar/Lambar)^(1-theta*(1-ppsi))*lam163+f164*(Lam164bar/Lambar)^(1-theta*(1-ppsi))*lam164+f165*(Lam165bar/Lambar)^(1-theta*(1-ppsi))*lam165+f166*(Lam166bar/Lambar)^(1-theta*(1-ppsi))*lam166+f167*(Lam167bar/Lambar)^(1-theta*(1-ppsi))*lam167+f168*(Lam168bar/Lambar)^(1-theta*(1-ppsi))*lam168+f169*(Lam169bar/Lambar)^(1-theta*(1-ppsi))*lam169+f170*(Lam170bar/Lambar)^(1-theta*(1-ppsi))*lam170+f171*(Lam171bar/Lambar)^(1-theta*(1-ppsi))*lam171+f172*(Lam172bar/Lambar)^(1-theta*(1-ppsi))*lam172+f173*(Lam173bar/Lambar)^(1-theta*(1-ppsi))*lam173+f174*(Lam174bar/Lambar)^(1-theta*(1-ppsi))*lam174+f175*(Lam175bar/Lambar)^(1-theta*(1-ppsi))*lam175+f176*(Lam176bar/Lambar)^(1-theta*(1-ppsi))*lam176+f177*(Lam177bar/Lambar)^(1-theta*(1-ppsi))*lam177+f178*(Lam178bar/Lambar)^(1-theta*(1-ppsi))*lam178+f179*(Lam179bar/Lambar)^(1-theta*(1-ppsi))*lam179+f180*(Lam180bar/Lambar)^(1-theta*(1-ppsi))*lam180+f181*(Lam181bar/Lambar)^(1-theta*(1-ppsi))*lam181+f182*(Lam182bar/Lambar)^(1-theta*(1-ppsi))*lam182+f183*(Lam183bar/Lambar)^(1-theta*(1-ppsi))*lam183+f184*(Lam184bar/Lambar)^(1-theta*(1-ppsi))*lam184+f185*(Lam185bar/Lambar)^(1-theta*(1-ppsi))*lam185+f186*(Lam186bar/Lambar)^(1-theta*(1-ppsi))*lam186+f187*(Lam187bar/Lambar)^(1-theta*(1-ppsi))*lam187+f188*(Lam188bar/Lambar)^(1-theta*(1-ppsi))*lam188+f189*(Lam189bar/Lambar)^(1-theta*(1-ppsi))*lam189+f190*(Lam190bar/Lambar)^(1-theta*(1-ppsi))*lam190+f191*(Lam191bar/Lambar)^(1-theta*(1-ppsi))*lam191+f192*(Lam192bar/Lambar)^(1-theta*(1-ppsi))*lam192+f193*(Lam193bar/Lambar)^(1-theta*(1-ppsi))*lam193+f194*(Lam194bar/Lambar)^(1-theta*(1-ppsi))*lam194+f195*(Lam195bar/Lambar)^(1-theta*(1-ppsi))*lam195+f196*(Lam196bar/Lambar)^(1-theta*(1-ppsi))*lam196+f197*(Lam197bar/Lambar)^(1-theta*(1-ppsi))*lam197+f198*(Lam198bar/Lambar)^(1-theta*(1-ppsi))*lam198+f199*(Lam199bar/Lambar)^(1-theta*(1-ppsi))*lam199+f200*(Lam200bar/Lambar)^(1-theta*(1-ppsi))*lam200+f201*(Lam201bar/Lambar)^(1-theta*(1-ppsi))*lam201+f202*(Lam202bar/Lambar)^(1-theta*(1-ppsi))*lam202+f203*(Lam203bar/Lambar)^(1-theta*(1-ppsi))*lam203+f204*(Lam204bar/Lambar)^(1-theta*(1-ppsi))*lam204+f205*(Lam205bar/Lambar)^(1-theta*(1-ppsi))*lam205+f206*(Lam206bar/Lambar)^(1-theta*(1-ppsi))*lam206+f207*(Lam207bar/Lambar)^(1-theta*(1-ppsi))*lam207+f208*(Lam208bar/Lambar)^(1-theta*(1-ppsi))*lam208+f209*(Lam209bar/Lambar)^(1-theta*(1-ppsi))*lam209+f210*(Lam210bar/Lambar)^(1-theta*(1-ppsi))*lam210+f211*(Lam211bar/Lambar)^(1-theta*(1-ppsi))*lam211+f212*(Lam212bar/Lambar)^(1-theta*(1-ppsi))*lam212+f213*(Lam213bar/Lambar)^(1-theta*(1-ppsi))*lam213+f214*(Lam214bar/Lambar)^(1-theta*(1-ppsi))*lam214+f215*(Lam215bar/Lambar)^(1-theta*(1-ppsi))*lam215+f216*(Lam216bar/Lambar)^(1-theta*(1-ppsi))*lam216+f217*(Lam217bar/Lambar)^(1-theta*(1-ppsi))*lam217+f218*(Lam218bar/Lambar)^(1-theta*(1-ppsi))*lam218+f219*(Lam219bar/Lambar)^(1-theta*(1-ppsi))*lam219+f220*(Lam220bar/Lambar)^(1-theta*(1-ppsi))*lam220+f221*(Lam221bar/Lambar)^(1-theta*(1-ppsi))*lam221+f222*(Lam222bar/Lambar)^(1-theta*(1-ppsi))*lam222+f223*(Lam223bar/Lambar)^(1-theta*(1-ppsi))*lam223+f224*(Lam224bar/Lambar)^(1-theta*(1-ppsi))*lam224+f225*(Lam225bar/Lambar)^(1-theta*(1-ppsi))*lam225+f226*(Lam226bar/Lambar)^(1-theta*(1-ppsi))*lam226+f227*(Lam227bar/Lambar)^(1-theta*(1-ppsi))*lam227+f228*(Lam228bar/Lambar)^(1-theta*(1-ppsi))*lam228+f229*(Lam229bar/Lambar)^(1-theta*(1-ppsi))*lam229+f230*(Lam230bar/Lambar)^(1-theta*(1-ppsi))*lam230+f231*(Lam231bar/Lambar)^(1-theta*(1-ppsi))*lam231+f232*(Lam232bar/Lambar)^(1-theta*(1-ppsi))*lam232+f233*(Lam233bar/Lambar)^(1-theta*(1-ppsi))*lam233+f234*(Lam234bar/Lambar)^(1-theta*(1-ppsi))*lam234+f235*(Lam235bar/Lambar)^(1-theta*(1-ppsi))*lam235+f236*(Lam236bar/Lambar)^(1-theta*(1-ppsi))*lam236+f237*(Lam237bar/Lambar)^(1-theta*(1-ppsi))*lam237+f238*(Lam238bar/Lambar)^(1-theta*(1-ppsi))*lam238+f239*(Lam239bar/Lambar)^(1-theta*(1-ppsi))*lam239+f240*(Lam240bar/Lambar)^(1-theta*(1-ppsi))*lam240+f241*(Lam241bar/Lambar)^(1-theta*(1-ppsi))*lam241+f242*(Lam242bar/Lambar)^(1-theta*(1-ppsi))*lam242+f243*(Lam243bar/Lambar)^(1-theta*(1-ppsi))*lam243+f244*(Lam244bar/Lambar)^(1-theta*(1-ppsi))*lam244+f245*(Lam245bar/Lambar)^(1-theta*(1-ppsi))*lam245+f246*(Lam246bar/Lambar)^(1-theta*(1-ppsi))*lam246+f247*(Lam247bar/Lambar)^(1-theta*(1-ppsi))*lam247+f248*(Lam248bar/Lambar)^(1-theta*(1-ppsi))*lam248+f249*(Lam249bar/Lambar)^(1-theta*(1-ppsi))*lam249+f250*(Lam250bar/Lambar)^(1-theta*(1-ppsi))*lam250+f251*(Lam251bar/Lambar)^(1-theta*(1-ppsi))*lam251+f252*(Lam252bar/Lambar)^(1-theta*(1-ppsi))*lam252+f253*(Lam253bar/Lambar)^(1-theta*(1-ppsi))*lam253+f254*(Lam254bar/Lambar)^(1-theta*(1-ppsi))*lam254+f255*(Lam255bar/Lambar)^(1-theta*(1-ppsi))*lam255+f256*(Lam256bar/Lambar)^(1-theta*(1-ppsi))*lam256+f257*(Lam257bar/Lambar)^(1-theta*(1-ppsi))*lam257+f258*(Lam258bar/Lambar)^(1-theta*(1-ppsi))*lam258+f259*(Lam259bar/Lambar)^(1-theta*(1-ppsi))*lam259+f260*(Lam260bar/Lambar)^(1-theta*(1-ppsi))*lam260+f261*(Lam261bar/Lambar)^(1-theta*(1-ppsi))*lam261+f262*(Lam262bar/Lambar)^(1-theta*(1-ppsi))*lam262+f263*(Lam263bar/Lambar)^(1-theta*(1-ppsi))*lam263+f264*(Lam264bar/Lambar)^(1-theta*(1-ppsi))*lam264+f265*(Lam265bar/Lambar)^(1-theta*(1-ppsi))*lam265+f266*(Lam266bar/Lambar)^(1-theta*(1-ppsi))*lam266+f267*(Lam267bar/Lambar)^(1-theta*(1-ppsi))*lam267+f268*(Lam268bar/Lambar)^(1-theta*(1-ppsi))*lam268+f269*(Lam269bar/Lambar)^(1-theta*(1-ppsi))*lam269+f270*(Lam270bar/Lambar)^(1-theta*(1-ppsi))*lam270+f271*(Lam271bar/Lambar)^(1-theta*(1-ppsi))*lam271+f272*(Lam272bar/Lambar)^(1-theta*(1-ppsi))*lam272;

% lam1 = (1-alph1)*Pibar^(theta*(1-ppsi)-1)*(lam1(-1) - p) + (1-(1-alph1)*Pibar^(theta*(1-ppsi)-1))*ps1;
lam001 = (1-alph001)*Pibar^(theta*(1-ppsi)-1)*(lam001(-1) - p) + (1-(1-alph001)*Pibar^(theta*(1-ppsi)-1))*ps001;
lam002 = (1-alph002)*Pibar^(theta*(1-ppsi)-1)*(lam002(-1) - p) + (1-(1-alph002)*Pibar^(theta*(1-ppsi)-1))*ps002;
lam003 = (1-alph003)*Pibar^(theta*(1-ppsi)-1)*(lam003(-1) - p) + (1-(1-alph003)*Pibar^(theta*(1-ppsi)-1))*ps003;
lam004 = (1-alph004)*Pibar^(theta*(1-ppsi)-1)*(lam004(-1) - p) + (1-(1-alph004)*Pibar^(theta*(1-ppsi)-1))*ps004;
lam005 = (1-alph005)*Pibar^(theta*(1-ppsi)-1)*(lam005(-1) - p) + (1-(1-alph005)*Pibar^(theta*(1-ppsi)-1))*ps005;
lam006 = (1-alph006)*Pibar^(theta*(1-ppsi)-1)*(lam006(-1) - p) + (1-(1-alph006)*Pibar^(theta*(1-ppsi)-1))*ps006;
lam007 = (1-alph007)*Pibar^(theta*(1-ppsi)-1)*(lam007(-1) - p) + (1-(1-alph007)*Pibar^(theta*(1-ppsi)-1))*ps007;
lam008 = (1-alph008)*Pibar^(theta*(1-ppsi)-1)*(lam008(-1) - p) + (1-(1-alph008)*Pibar^(theta*(1-ppsi)-1))*ps008;
lam009 = (1-alph009)*Pibar^(theta*(1-ppsi)-1)*(lam009(-1) - p) + (1-(1-alph009)*Pibar^(theta*(1-ppsi)-1))*ps009;
lam010 = (1-alph010)*Pibar^(theta*(1-ppsi)-1)*(lam010(-1) - p) + (1-(1-alph010)*Pibar^(theta*(1-ppsi)-1))*ps010;
lam011 = (1-alph011)*Pibar^(theta*(1-ppsi)-1)*(lam011(-1) - p) + (1-(1-alph011)*Pibar^(theta*(1-ppsi)-1))*ps011;
lam012 = (1-alph012)*Pibar^(theta*(1-ppsi)-1)*(lam012(-1) - p) + (1-(1-alph012)*Pibar^(theta*(1-ppsi)-1))*ps012;
lam013 = (1-alph013)*Pibar^(theta*(1-ppsi)-1)*(lam013(-1) - p) + (1-(1-alph013)*Pibar^(theta*(1-ppsi)-1))*ps013;
lam014 = (1-alph014)*Pibar^(theta*(1-ppsi)-1)*(lam014(-1) - p) + (1-(1-alph014)*Pibar^(theta*(1-ppsi)-1))*ps014;
lam015 = (1-alph015)*Pibar^(theta*(1-ppsi)-1)*(lam015(-1) - p) + (1-(1-alph015)*Pibar^(theta*(1-ppsi)-1))*ps015;
lam016 = (1-alph016)*Pibar^(theta*(1-ppsi)-1)*(lam016(-1) - p) + (1-(1-alph016)*Pibar^(theta*(1-ppsi)-1))*ps016;
lam017 = (1-alph017)*Pibar^(theta*(1-ppsi)-1)*(lam017(-1) - p) + (1-(1-alph017)*Pibar^(theta*(1-ppsi)-1))*ps017;
lam018 = (1-alph018)*Pibar^(theta*(1-ppsi)-1)*(lam018(-1) - p) + (1-(1-alph018)*Pibar^(theta*(1-ppsi)-1))*ps018;
lam019 = (1-alph019)*Pibar^(theta*(1-ppsi)-1)*(lam019(-1) - p) + (1-(1-alph019)*Pibar^(theta*(1-ppsi)-1))*ps019;
lam020 = (1-alph020)*Pibar^(theta*(1-ppsi)-1)*(lam020(-1) - p) + (1-(1-alph020)*Pibar^(theta*(1-ppsi)-1))*ps020;
lam021 = (1-alph021)*Pibar^(theta*(1-ppsi)-1)*(lam021(-1) - p) + (1-(1-alph021)*Pibar^(theta*(1-ppsi)-1))*ps021;
lam022 = (1-alph022)*Pibar^(theta*(1-ppsi)-1)*(lam022(-1) - p) + (1-(1-alph022)*Pibar^(theta*(1-ppsi)-1))*ps022;
lam023 = (1-alph023)*Pibar^(theta*(1-ppsi)-1)*(lam023(-1) - p) + (1-(1-alph023)*Pibar^(theta*(1-ppsi)-1))*ps023;
lam024 = (1-alph024)*Pibar^(theta*(1-ppsi)-1)*(lam024(-1) - p) + (1-(1-alph024)*Pibar^(theta*(1-ppsi)-1))*ps024;
lam025 = (1-alph025)*Pibar^(theta*(1-ppsi)-1)*(lam025(-1) - p) + (1-(1-alph025)*Pibar^(theta*(1-ppsi)-1))*ps025;
lam026 = (1-alph026)*Pibar^(theta*(1-ppsi)-1)*(lam026(-1) - p) + (1-(1-alph026)*Pibar^(theta*(1-ppsi)-1))*ps026;
lam027 = (1-alph027)*Pibar^(theta*(1-ppsi)-1)*(lam027(-1) - p) + (1-(1-alph027)*Pibar^(theta*(1-ppsi)-1))*ps027;
lam028 = (1-alph028)*Pibar^(theta*(1-ppsi)-1)*(lam028(-1) - p) + (1-(1-alph028)*Pibar^(theta*(1-ppsi)-1))*ps028;
lam029 = (1-alph029)*Pibar^(theta*(1-ppsi)-1)*(lam029(-1) - p) + (1-(1-alph029)*Pibar^(theta*(1-ppsi)-1))*ps029;
lam030 = (1-alph030)*Pibar^(theta*(1-ppsi)-1)*(lam030(-1) - p) + (1-(1-alph030)*Pibar^(theta*(1-ppsi)-1))*ps030;
lam031 = (1-alph031)*Pibar^(theta*(1-ppsi)-1)*(lam031(-1) - p) + (1-(1-alph031)*Pibar^(theta*(1-ppsi)-1))*ps031;
lam032 = (1-alph032)*Pibar^(theta*(1-ppsi)-1)*(lam032(-1) - p) + (1-(1-alph032)*Pibar^(theta*(1-ppsi)-1))*ps032;
lam033 = (1-alph033)*Pibar^(theta*(1-ppsi)-1)*(lam033(-1) - p) + (1-(1-alph033)*Pibar^(theta*(1-ppsi)-1))*ps033;
lam034 = (1-alph034)*Pibar^(theta*(1-ppsi)-1)*(lam034(-1) - p) + (1-(1-alph034)*Pibar^(theta*(1-ppsi)-1))*ps034;
lam035 = (1-alph035)*Pibar^(theta*(1-ppsi)-1)*(lam035(-1) - p) + (1-(1-alph035)*Pibar^(theta*(1-ppsi)-1))*ps035;
lam036 = (1-alph036)*Pibar^(theta*(1-ppsi)-1)*(lam036(-1) - p) + (1-(1-alph036)*Pibar^(theta*(1-ppsi)-1))*ps036;
lam037 = (1-alph037)*Pibar^(theta*(1-ppsi)-1)*(lam037(-1) - p) + (1-(1-alph037)*Pibar^(theta*(1-ppsi)-1))*ps037;
lam038 = (1-alph038)*Pibar^(theta*(1-ppsi)-1)*(lam038(-1) - p) + (1-(1-alph038)*Pibar^(theta*(1-ppsi)-1))*ps038;
lam039 = (1-alph039)*Pibar^(theta*(1-ppsi)-1)*(lam039(-1) - p) + (1-(1-alph039)*Pibar^(theta*(1-ppsi)-1))*ps039;
lam040 = (1-alph040)*Pibar^(theta*(1-ppsi)-1)*(lam040(-1) - p) + (1-(1-alph040)*Pibar^(theta*(1-ppsi)-1))*ps040;
lam041 = (1-alph041)*Pibar^(theta*(1-ppsi)-1)*(lam041(-1) - p) + (1-(1-alph041)*Pibar^(theta*(1-ppsi)-1))*ps041;
lam042 = (1-alph042)*Pibar^(theta*(1-ppsi)-1)*(lam042(-1) - p) + (1-(1-alph042)*Pibar^(theta*(1-ppsi)-1))*ps042;
lam043 = (1-alph043)*Pibar^(theta*(1-ppsi)-1)*(lam043(-1) - p) + (1-(1-alph043)*Pibar^(theta*(1-ppsi)-1))*ps043;
lam044 = (1-alph044)*Pibar^(theta*(1-ppsi)-1)*(lam044(-1) - p) + (1-(1-alph044)*Pibar^(theta*(1-ppsi)-1))*ps044;
lam045 = (1-alph045)*Pibar^(theta*(1-ppsi)-1)*(lam045(-1) - p) + (1-(1-alph045)*Pibar^(theta*(1-ppsi)-1))*ps045;
lam046 = (1-alph046)*Pibar^(theta*(1-ppsi)-1)*(lam046(-1) - p) + (1-(1-alph046)*Pibar^(theta*(1-ppsi)-1))*ps046;
lam047 = (1-alph047)*Pibar^(theta*(1-ppsi)-1)*(lam047(-1) - p) + (1-(1-alph047)*Pibar^(theta*(1-ppsi)-1))*ps047;
lam048 = (1-alph048)*Pibar^(theta*(1-ppsi)-1)*(lam048(-1) - p) + (1-(1-alph048)*Pibar^(theta*(1-ppsi)-1))*ps048;
lam049 = (1-alph049)*Pibar^(theta*(1-ppsi)-1)*(lam049(-1) - p) + (1-(1-alph049)*Pibar^(theta*(1-ppsi)-1))*ps049;
lam050 = (1-alph050)*Pibar^(theta*(1-ppsi)-1)*(lam050(-1) - p) + (1-(1-alph050)*Pibar^(theta*(1-ppsi)-1))*ps050;
lam051 = (1-alph051)*Pibar^(theta*(1-ppsi)-1)*(lam051(-1) - p) + (1-(1-alph051)*Pibar^(theta*(1-ppsi)-1))*ps051;
lam052 = (1-alph052)*Pibar^(theta*(1-ppsi)-1)*(lam052(-1) - p) + (1-(1-alph052)*Pibar^(theta*(1-ppsi)-1))*ps052;
lam053 = (1-alph053)*Pibar^(theta*(1-ppsi)-1)*(lam053(-1) - p) + (1-(1-alph053)*Pibar^(theta*(1-ppsi)-1))*ps053;
lam054 = (1-alph054)*Pibar^(theta*(1-ppsi)-1)*(lam054(-1) - p) + (1-(1-alph054)*Pibar^(theta*(1-ppsi)-1))*ps054;
lam055 = (1-alph055)*Pibar^(theta*(1-ppsi)-1)*(lam055(-1) - p) + (1-(1-alph055)*Pibar^(theta*(1-ppsi)-1))*ps055;
lam056 = (1-alph056)*Pibar^(theta*(1-ppsi)-1)*(lam056(-1) - p) + (1-(1-alph056)*Pibar^(theta*(1-ppsi)-1))*ps056;
lam057 = (1-alph057)*Pibar^(theta*(1-ppsi)-1)*(lam057(-1) - p) + (1-(1-alph057)*Pibar^(theta*(1-ppsi)-1))*ps057;
lam058 = (1-alph058)*Pibar^(theta*(1-ppsi)-1)*(lam058(-1) - p) + (1-(1-alph058)*Pibar^(theta*(1-ppsi)-1))*ps058;
lam059 = (1-alph059)*Pibar^(theta*(1-ppsi)-1)*(lam059(-1) - p) + (1-(1-alph059)*Pibar^(theta*(1-ppsi)-1))*ps059;
lam060 = (1-alph060)*Pibar^(theta*(1-ppsi)-1)*(lam060(-1) - p) + (1-(1-alph060)*Pibar^(theta*(1-ppsi)-1))*ps060;
lam061 = (1-alph061)*Pibar^(theta*(1-ppsi)-1)*(lam061(-1) - p) + (1-(1-alph061)*Pibar^(theta*(1-ppsi)-1))*ps061;
lam062 = (1-alph062)*Pibar^(theta*(1-ppsi)-1)*(lam062(-1) - p) + (1-(1-alph062)*Pibar^(theta*(1-ppsi)-1))*ps062;
lam063 = (1-alph063)*Pibar^(theta*(1-ppsi)-1)*(lam063(-1) - p) + (1-(1-alph063)*Pibar^(theta*(1-ppsi)-1))*ps063;
lam064 = (1-alph064)*Pibar^(theta*(1-ppsi)-1)*(lam064(-1) - p) + (1-(1-alph064)*Pibar^(theta*(1-ppsi)-1))*ps064;
lam065 = (1-alph065)*Pibar^(theta*(1-ppsi)-1)*(lam065(-1) - p) + (1-(1-alph065)*Pibar^(theta*(1-ppsi)-1))*ps065;
lam066 = (1-alph066)*Pibar^(theta*(1-ppsi)-1)*(lam066(-1) - p) + (1-(1-alph066)*Pibar^(theta*(1-ppsi)-1))*ps066;
lam067 = (1-alph067)*Pibar^(theta*(1-ppsi)-1)*(lam067(-1) - p) + (1-(1-alph067)*Pibar^(theta*(1-ppsi)-1))*ps067;
lam068 = (1-alph068)*Pibar^(theta*(1-ppsi)-1)*(lam068(-1) - p) + (1-(1-alph068)*Pibar^(theta*(1-ppsi)-1))*ps068;
lam069 = (1-alph069)*Pibar^(theta*(1-ppsi)-1)*(lam069(-1) - p) + (1-(1-alph069)*Pibar^(theta*(1-ppsi)-1))*ps069;
lam070 = (1-alph070)*Pibar^(theta*(1-ppsi)-1)*(lam070(-1) - p) + (1-(1-alph070)*Pibar^(theta*(1-ppsi)-1))*ps070;
lam071 = (1-alph071)*Pibar^(theta*(1-ppsi)-1)*(lam071(-1) - p) + (1-(1-alph071)*Pibar^(theta*(1-ppsi)-1))*ps071;
lam072 = (1-alph072)*Pibar^(theta*(1-ppsi)-1)*(lam072(-1) - p) + (1-(1-alph072)*Pibar^(theta*(1-ppsi)-1))*ps072;
lam073 = (1-alph073)*Pibar^(theta*(1-ppsi)-1)*(lam073(-1) - p) + (1-(1-alph073)*Pibar^(theta*(1-ppsi)-1))*ps073;
lam074 = (1-alph074)*Pibar^(theta*(1-ppsi)-1)*(lam074(-1) - p) + (1-(1-alph074)*Pibar^(theta*(1-ppsi)-1))*ps074;
lam075 = (1-alph075)*Pibar^(theta*(1-ppsi)-1)*(lam075(-1) - p) + (1-(1-alph075)*Pibar^(theta*(1-ppsi)-1))*ps075;
lam076 = (1-alph076)*Pibar^(theta*(1-ppsi)-1)*(lam076(-1) - p) + (1-(1-alph076)*Pibar^(theta*(1-ppsi)-1))*ps076;
lam077 = (1-alph077)*Pibar^(theta*(1-ppsi)-1)*(lam077(-1) - p) + (1-(1-alph077)*Pibar^(theta*(1-ppsi)-1))*ps077;
lam078 = (1-alph078)*Pibar^(theta*(1-ppsi)-1)*(lam078(-1) - p) + (1-(1-alph078)*Pibar^(theta*(1-ppsi)-1))*ps078;
lam079 = (1-alph079)*Pibar^(theta*(1-ppsi)-1)*(lam079(-1) - p) + (1-(1-alph079)*Pibar^(theta*(1-ppsi)-1))*ps079;
lam080 = (1-alph080)*Pibar^(theta*(1-ppsi)-1)*(lam080(-1) - p) + (1-(1-alph080)*Pibar^(theta*(1-ppsi)-1))*ps080;
lam081 = (1-alph081)*Pibar^(theta*(1-ppsi)-1)*(lam081(-1) - p) + (1-(1-alph081)*Pibar^(theta*(1-ppsi)-1))*ps081;
lam082 = (1-alph082)*Pibar^(theta*(1-ppsi)-1)*(lam082(-1) - p) + (1-(1-alph082)*Pibar^(theta*(1-ppsi)-1))*ps082;
lam083 = (1-alph083)*Pibar^(theta*(1-ppsi)-1)*(lam083(-1) - p) + (1-(1-alph083)*Pibar^(theta*(1-ppsi)-1))*ps083;
lam084 = (1-alph084)*Pibar^(theta*(1-ppsi)-1)*(lam084(-1) - p) + (1-(1-alph084)*Pibar^(theta*(1-ppsi)-1))*ps084;
lam085 = (1-alph085)*Pibar^(theta*(1-ppsi)-1)*(lam085(-1) - p) + (1-(1-alph085)*Pibar^(theta*(1-ppsi)-1))*ps085;
lam086 = (1-alph086)*Pibar^(theta*(1-ppsi)-1)*(lam086(-1) - p) + (1-(1-alph086)*Pibar^(theta*(1-ppsi)-1))*ps086;
lam087 = (1-alph087)*Pibar^(theta*(1-ppsi)-1)*(lam087(-1) - p) + (1-(1-alph087)*Pibar^(theta*(1-ppsi)-1))*ps087;
lam088 = (1-alph088)*Pibar^(theta*(1-ppsi)-1)*(lam088(-1) - p) + (1-(1-alph088)*Pibar^(theta*(1-ppsi)-1))*ps088;
lam089 = (1-alph089)*Pibar^(theta*(1-ppsi)-1)*(lam089(-1) - p) + (1-(1-alph089)*Pibar^(theta*(1-ppsi)-1))*ps089;
lam090 = (1-alph090)*Pibar^(theta*(1-ppsi)-1)*(lam090(-1) - p) + (1-(1-alph090)*Pibar^(theta*(1-ppsi)-1))*ps090;
lam091 = (1-alph091)*Pibar^(theta*(1-ppsi)-1)*(lam091(-1) - p) + (1-(1-alph091)*Pibar^(theta*(1-ppsi)-1))*ps091;
lam092 = (1-alph092)*Pibar^(theta*(1-ppsi)-1)*(lam092(-1) - p) + (1-(1-alph092)*Pibar^(theta*(1-ppsi)-1))*ps092;
lam093 = (1-alph093)*Pibar^(theta*(1-ppsi)-1)*(lam093(-1) - p) + (1-(1-alph093)*Pibar^(theta*(1-ppsi)-1))*ps093;
lam094 = (1-alph094)*Pibar^(theta*(1-ppsi)-1)*(lam094(-1) - p) + (1-(1-alph094)*Pibar^(theta*(1-ppsi)-1))*ps094;
lam095 = (1-alph095)*Pibar^(theta*(1-ppsi)-1)*(lam095(-1) - p) + (1-(1-alph095)*Pibar^(theta*(1-ppsi)-1))*ps095;
lam096 = (1-alph096)*Pibar^(theta*(1-ppsi)-1)*(lam096(-1) - p) + (1-(1-alph096)*Pibar^(theta*(1-ppsi)-1))*ps096;
lam097 = (1-alph097)*Pibar^(theta*(1-ppsi)-1)*(lam097(-1) - p) + (1-(1-alph097)*Pibar^(theta*(1-ppsi)-1))*ps097;
lam098 = (1-alph098)*Pibar^(theta*(1-ppsi)-1)*(lam098(-1) - p) + (1-(1-alph098)*Pibar^(theta*(1-ppsi)-1))*ps098;
lam099 = (1-alph099)*Pibar^(theta*(1-ppsi)-1)*(lam099(-1) - p) + (1-(1-alph099)*Pibar^(theta*(1-ppsi)-1))*ps099;
lam100 = (1-alph100)*Pibar^(theta*(1-ppsi)-1)*(lam100(-1) - p) + (1-(1-alph100)*Pibar^(theta*(1-ppsi)-1))*ps100;
lam101 = (1-alph101)*Pibar^(theta*(1-ppsi)-1)*(lam101(-1) - p) + (1-(1-alph101)*Pibar^(theta*(1-ppsi)-1))*ps101;
lam102 = (1-alph102)*Pibar^(theta*(1-ppsi)-1)*(lam102(-1) - p) + (1-(1-alph102)*Pibar^(theta*(1-ppsi)-1))*ps102;
lam103 = (1-alph103)*Pibar^(theta*(1-ppsi)-1)*(lam103(-1) - p) + (1-(1-alph103)*Pibar^(theta*(1-ppsi)-1))*ps103;
lam104 = (1-alph104)*Pibar^(theta*(1-ppsi)-1)*(lam104(-1) - p) + (1-(1-alph104)*Pibar^(theta*(1-ppsi)-1))*ps104;
lam105 = (1-alph105)*Pibar^(theta*(1-ppsi)-1)*(lam105(-1) - p) + (1-(1-alph105)*Pibar^(theta*(1-ppsi)-1))*ps105;
lam106 = (1-alph106)*Pibar^(theta*(1-ppsi)-1)*(lam106(-1) - p) + (1-(1-alph106)*Pibar^(theta*(1-ppsi)-1))*ps106;
lam107 = (1-alph107)*Pibar^(theta*(1-ppsi)-1)*(lam107(-1) - p) + (1-(1-alph107)*Pibar^(theta*(1-ppsi)-1))*ps107;
lam108 = (1-alph108)*Pibar^(theta*(1-ppsi)-1)*(lam108(-1) - p) + (1-(1-alph108)*Pibar^(theta*(1-ppsi)-1))*ps108;
lam109 = (1-alph109)*Pibar^(theta*(1-ppsi)-1)*(lam109(-1) - p) + (1-(1-alph109)*Pibar^(theta*(1-ppsi)-1))*ps109;
lam110 = (1-alph110)*Pibar^(theta*(1-ppsi)-1)*(lam110(-1) - p) + (1-(1-alph110)*Pibar^(theta*(1-ppsi)-1))*ps110;
lam111 = (1-alph111)*Pibar^(theta*(1-ppsi)-1)*(lam111(-1) - p) + (1-(1-alph111)*Pibar^(theta*(1-ppsi)-1))*ps111;
lam112 = (1-alph112)*Pibar^(theta*(1-ppsi)-1)*(lam112(-1) - p) + (1-(1-alph112)*Pibar^(theta*(1-ppsi)-1))*ps112;
lam113 = (1-alph113)*Pibar^(theta*(1-ppsi)-1)*(lam113(-1) - p) + (1-(1-alph113)*Pibar^(theta*(1-ppsi)-1))*ps113;
lam114 = (1-alph114)*Pibar^(theta*(1-ppsi)-1)*(lam114(-1) - p) + (1-(1-alph114)*Pibar^(theta*(1-ppsi)-1))*ps114;
lam115 = (1-alph115)*Pibar^(theta*(1-ppsi)-1)*(lam115(-1) - p) + (1-(1-alph115)*Pibar^(theta*(1-ppsi)-1))*ps115;
lam116 = (1-alph116)*Pibar^(theta*(1-ppsi)-1)*(lam116(-1) - p) + (1-(1-alph116)*Pibar^(theta*(1-ppsi)-1))*ps116;
lam117 = (1-alph117)*Pibar^(theta*(1-ppsi)-1)*(lam117(-1) - p) + (1-(1-alph117)*Pibar^(theta*(1-ppsi)-1))*ps117;
lam118 = (1-alph118)*Pibar^(theta*(1-ppsi)-1)*(lam118(-1) - p) + (1-(1-alph118)*Pibar^(theta*(1-ppsi)-1))*ps118;
lam119 = (1-alph119)*Pibar^(theta*(1-ppsi)-1)*(lam119(-1) - p) + (1-(1-alph119)*Pibar^(theta*(1-ppsi)-1))*ps119;
lam120 = (1-alph120)*Pibar^(theta*(1-ppsi)-1)*(lam120(-1) - p) + (1-(1-alph120)*Pibar^(theta*(1-ppsi)-1))*ps120;
lam121 = (1-alph121)*Pibar^(theta*(1-ppsi)-1)*(lam121(-1) - p) + (1-(1-alph121)*Pibar^(theta*(1-ppsi)-1))*ps121;
lam122 = (1-alph122)*Pibar^(theta*(1-ppsi)-1)*(lam122(-1) - p) + (1-(1-alph122)*Pibar^(theta*(1-ppsi)-1))*ps122;
lam123 = (1-alph123)*Pibar^(theta*(1-ppsi)-1)*(lam123(-1) - p) + (1-(1-alph123)*Pibar^(theta*(1-ppsi)-1))*ps123;
lam124 = (1-alph124)*Pibar^(theta*(1-ppsi)-1)*(lam124(-1) - p) + (1-(1-alph124)*Pibar^(theta*(1-ppsi)-1))*ps124;
lam125 = (1-alph125)*Pibar^(theta*(1-ppsi)-1)*(lam125(-1) - p) + (1-(1-alph125)*Pibar^(theta*(1-ppsi)-1))*ps125;
lam126 = (1-alph126)*Pibar^(theta*(1-ppsi)-1)*(lam126(-1) - p) + (1-(1-alph126)*Pibar^(theta*(1-ppsi)-1))*ps126;
lam127 = (1-alph127)*Pibar^(theta*(1-ppsi)-1)*(lam127(-1) - p) + (1-(1-alph127)*Pibar^(theta*(1-ppsi)-1))*ps127;
lam128 = (1-alph128)*Pibar^(theta*(1-ppsi)-1)*(lam128(-1) - p) + (1-(1-alph128)*Pibar^(theta*(1-ppsi)-1))*ps128;
lam129 = (1-alph129)*Pibar^(theta*(1-ppsi)-1)*(lam129(-1) - p) + (1-(1-alph129)*Pibar^(theta*(1-ppsi)-1))*ps129;
lam130 = (1-alph130)*Pibar^(theta*(1-ppsi)-1)*(lam130(-1) - p) + (1-(1-alph130)*Pibar^(theta*(1-ppsi)-1))*ps130;
lam131 = (1-alph131)*Pibar^(theta*(1-ppsi)-1)*(lam131(-1) - p) + (1-(1-alph131)*Pibar^(theta*(1-ppsi)-1))*ps131;
lam132 = (1-alph132)*Pibar^(theta*(1-ppsi)-1)*(lam132(-1) - p) + (1-(1-alph132)*Pibar^(theta*(1-ppsi)-1))*ps132;
lam133 = (1-alph133)*Pibar^(theta*(1-ppsi)-1)*(lam133(-1) - p) + (1-(1-alph133)*Pibar^(theta*(1-ppsi)-1))*ps133;
lam134 = (1-alph134)*Pibar^(theta*(1-ppsi)-1)*(lam134(-1) - p) + (1-(1-alph134)*Pibar^(theta*(1-ppsi)-1))*ps134;
lam135 = (1-alph135)*Pibar^(theta*(1-ppsi)-1)*(lam135(-1) - p) + (1-(1-alph135)*Pibar^(theta*(1-ppsi)-1))*ps135;
lam136 = (1-alph136)*Pibar^(theta*(1-ppsi)-1)*(lam136(-1) - p) + (1-(1-alph136)*Pibar^(theta*(1-ppsi)-1))*ps136;
lam137 = (1-alph137)*Pibar^(theta*(1-ppsi)-1)*(lam137(-1) - p) + (1-(1-alph137)*Pibar^(theta*(1-ppsi)-1))*ps137;
lam138 = (1-alph138)*Pibar^(theta*(1-ppsi)-1)*(lam138(-1) - p) + (1-(1-alph138)*Pibar^(theta*(1-ppsi)-1))*ps138;
lam139 = (1-alph139)*Pibar^(theta*(1-ppsi)-1)*(lam139(-1) - p) + (1-(1-alph139)*Pibar^(theta*(1-ppsi)-1))*ps139;
lam140 = (1-alph140)*Pibar^(theta*(1-ppsi)-1)*(lam140(-1) - p) + (1-(1-alph140)*Pibar^(theta*(1-ppsi)-1))*ps140;
lam141 = (1-alph141)*Pibar^(theta*(1-ppsi)-1)*(lam141(-1) - p) + (1-(1-alph141)*Pibar^(theta*(1-ppsi)-1))*ps141;
lam142 = (1-alph142)*Pibar^(theta*(1-ppsi)-1)*(lam142(-1) - p) + (1-(1-alph142)*Pibar^(theta*(1-ppsi)-1))*ps142;
lam143 = (1-alph143)*Pibar^(theta*(1-ppsi)-1)*(lam143(-1) - p) + (1-(1-alph143)*Pibar^(theta*(1-ppsi)-1))*ps143;
lam144 = (1-alph144)*Pibar^(theta*(1-ppsi)-1)*(lam144(-1) - p) + (1-(1-alph144)*Pibar^(theta*(1-ppsi)-1))*ps144;
lam145 = (1-alph145)*Pibar^(theta*(1-ppsi)-1)*(lam145(-1) - p) + (1-(1-alph145)*Pibar^(theta*(1-ppsi)-1))*ps145;
lam146 = (1-alph146)*Pibar^(theta*(1-ppsi)-1)*(lam146(-1) - p) + (1-(1-alph146)*Pibar^(theta*(1-ppsi)-1))*ps146;
lam147 = (1-alph147)*Pibar^(theta*(1-ppsi)-1)*(lam147(-1) - p) + (1-(1-alph147)*Pibar^(theta*(1-ppsi)-1))*ps147;
lam148 = (1-alph148)*Pibar^(theta*(1-ppsi)-1)*(lam148(-1) - p) + (1-(1-alph148)*Pibar^(theta*(1-ppsi)-1))*ps148;
lam149 = (1-alph149)*Pibar^(theta*(1-ppsi)-1)*(lam149(-1) - p) + (1-(1-alph149)*Pibar^(theta*(1-ppsi)-1))*ps149;
lam150 = (1-alph150)*Pibar^(theta*(1-ppsi)-1)*(lam150(-1) - p) + (1-(1-alph150)*Pibar^(theta*(1-ppsi)-1))*ps150;
lam151 = (1-alph151)*Pibar^(theta*(1-ppsi)-1)*(lam151(-1) - p) + (1-(1-alph151)*Pibar^(theta*(1-ppsi)-1))*ps151;
lam152 = (1-alph152)*Pibar^(theta*(1-ppsi)-1)*(lam152(-1) - p) + (1-(1-alph152)*Pibar^(theta*(1-ppsi)-1))*ps152;
lam153 = (1-alph153)*Pibar^(theta*(1-ppsi)-1)*(lam153(-1) - p) + (1-(1-alph153)*Pibar^(theta*(1-ppsi)-1))*ps153;
lam154 = (1-alph154)*Pibar^(theta*(1-ppsi)-1)*(lam154(-1) - p) + (1-(1-alph154)*Pibar^(theta*(1-ppsi)-1))*ps154;
lam155 = (1-alph155)*Pibar^(theta*(1-ppsi)-1)*(lam155(-1) - p) + (1-(1-alph155)*Pibar^(theta*(1-ppsi)-1))*ps155;
lam156 = (1-alph156)*Pibar^(theta*(1-ppsi)-1)*(lam156(-1) - p) + (1-(1-alph156)*Pibar^(theta*(1-ppsi)-1))*ps156;
lam157 = (1-alph157)*Pibar^(theta*(1-ppsi)-1)*(lam157(-1) - p) + (1-(1-alph157)*Pibar^(theta*(1-ppsi)-1))*ps157;
lam158 = (1-alph158)*Pibar^(theta*(1-ppsi)-1)*(lam158(-1) - p) + (1-(1-alph158)*Pibar^(theta*(1-ppsi)-1))*ps158;
lam159 = (1-alph159)*Pibar^(theta*(1-ppsi)-1)*(lam159(-1) - p) + (1-(1-alph159)*Pibar^(theta*(1-ppsi)-1))*ps159;
lam160 = (1-alph160)*Pibar^(theta*(1-ppsi)-1)*(lam160(-1) - p) + (1-(1-alph160)*Pibar^(theta*(1-ppsi)-1))*ps160;
lam161 = (1-alph161)*Pibar^(theta*(1-ppsi)-1)*(lam161(-1) - p) + (1-(1-alph161)*Pibar^(theta*(1-ppsi)-1))*ps161;
lam162 = (1-alph162)*Pibar^(theta*(1-ppsi)-1)*(lam162(-1) - p) + (1-(1-alph162)*Pibar^(theta*(1-ppsi)-1))*ps162;
lam163 = (1-alph163)*Pibar^(theta*(1-ppsi)-1)*(lam163(-1) - p) + (1-(1-alph163)*Pibar^(theta*(1-ppsi)-1))*ps163;
lam164 = (1-alph164)*Pibar^(theta*(1-ppsi)-1)*(lam164(-1) - p) + (1-(1-alph164)*Pibar^(theta*(1-ppsi)-1))*ps164;
lam165 = (1-alph165)*Pibar^(theta*(1-ppsi)-1)*(lam165(-1) - p) + (1-(1-alph165)*Pibar^(theta*(1-ppsi)-1))*ps165;
lam166 = (1-alph166)*Pibar^(theta*(1-ppsi)-1)*(lam166(-1) - p) + (1-(1-alph166)*Pibar^(theta*(1-ppsi)-1))*ps166;
lam167 = (1-alph167)*Pibar^(theta*(1-ppsi)-1)*(lam167(-1) - p) + (1-(1-alph167)*Pibar^(theta*(1-ppsi)-1))*ps167;
lam168 = (1-alph168)*Pibar^(theta*(1-ppsi)-1)*(lam168(-1) - p) + (1-(1-alph168)*Pibar^(theta*(1-ppsi)-1))*ps168;
lam169 = (1-alph169)*Pibar^(theta*(1-ppsi)-1)*(lam169(-1) - p) + (1-(1-alph169)*Pibar^(theta*(1-ppsi)-1))*ps169;
lam170 = (1-alph170)*Pibar^(theta*(1-ppsi)-1)*(lam170(-1) - p) + (1-(1-alph170)*Pibar^(theta*(1-ppsi)-1))*ps170;
lam171 = (1-alph171)*Pibar^(theta*(1-ppsi)-1)*(lam171(-1) - p) + (1-(1-alph171)*Pibar^(theta*(1-ppsi)-1))*ps171;
lam172 = (1-alph172)*Pibar^(theta*(1-ppsi)-1)*(lam172(-1) - p) + (1-(1-alph172)*Pibar^(theta*(1-ppsi)-1))*ps172;
lam173 = (1-alph173)*Pibar^(theta*(1-ppsi)-1)*(lam173(-1) - p) + (1-(1-alph173)*Pibar^(theta*(1-ppsi)-1))*ps173;
lam174 = (1-alph174)*Pibar^(theta*(1-ppsi)-1)*(lam174(-1) - p) + (1-(1-alph174)*Pibar^(theta*(1-ppsi)-1))*ps174;
lam175 = (1-alph175)*Pibar^(theta*(1-ppsi)-1)*(lam175(-1) - p) + (1-(1-alph175)*Pibar^(theta*(1-ppsi)-1))*ps175;
lam176 = (1-alph176)*Pibar^(theta*(1-ppsi)-1)*(lam176(-1) - p) + (1-(1-alph176)*Pibar^(theta*(1-ppsi)-1))*ps176;
lam177 = (1-alph177)*Pibar^(theta*(1-ppsi)-1)*(lam177(-1) - p) + (1-(1-alph177)*Pibar^(theta*(1-ppsi)-1))*ps177;
lam178 = (1-alph178)*Pibar^(theta*(1-ppsi)-1)*(lam178(-1) - p) + (1-(1-alph178)*Pibar^(theta*(1-ppsi)-1))*ps178;
lam179 = (1-alph179)*Pibar^(theta*(1-ppsi)-1)*(lam179(-1) - p) + (1-(1-alph179)*Pibar^(theta*(1-ppsi)-1))*ps179;
lam180 = (1-alph180)*Pibar^(theta*(1-ppsi)-1)*(lam180(-1) - p) + (1-(1-alph180)*Pibar^(theta*(1-ppsi)-1))*ps180;
lam181 = (1-alph181)*Pibar^(theta*(1-ppsi)-1)*(lam181(-1) - p) + (1-(1-alph181)*Pibar^(theta*(1-ppsi)-1))*ps181;
lam182 = (1-alph182)*Pibar^(theta*(1-ppsi)-1)*(lam182(-1) - p) + (1-(1-alph182)*Pibar^(theta*(1-ppsi)-1))*ps182;
lam183 = (1-alph183)*Pibar^(theta*(1-ppsi)-1)*(lam183(-1) - p) + (1-(1-alph183)*Pibar^(theta*(1-ppsi)-1))*ps183;
lam184 = (1-alph184)*Pibar^(theta*(1-ppsi)-1)*(lam184(-1) - p) + (1-(1-alph184)*Pibar^(theta*(1-ppsi)-1))*ps184;
lam185 = (1-alph185)*Pibar^(theta*(1-ppsi)-1)*(lam185(-1) - p) + (1-(1-alph185)*Pibar^(theta*(1-ppsi)-1))*ps185;
lam186 = (1-alph186)*Pibar^(theta*(1-ppsi)-1)*(lam186(-1) - p) + (1-(1-alph186)*Pibar^(theta*(1-ppsi)-1))*ps186;
lam187 = (1-alph187)*Pibar^(theta*(1-ppsi)-1)*(lam187(-1) - p) + (1-(1-alph187)*Pibar^(theta*(1-ppsi)-1))*ps187;
lam188 = (1-alph188)*Pibar^(theta*(1-ppsi)-1)*(lam188(-1) - p) + (1-(1-alph188)*Pibar^(theta*(1-ppsi)-1))*ps188;
lam189 = (1-alph189)*Pibar^(theta*(1-ppsi)-1)*(lam189(-1) - p) + (1-(1-alph189)*Pibar^(theta*(1-ppsi)-1))*ps189;
lam190 = (1-alph190)*Pibar^(theta*(1-ppsi)-1)*(lam190(-1) - p) + (1-(1-alph190)*Pibar^(theta*(1-ppsi)-1))*ps190;
lam191 = (1-alph191)*Pibar^(theta*(1-ppsi)-1)*(lam191(-1) - p) + (1-(1-alph191)*Pibar^(theta*(1-ppsi)-1))*ps191;
lam192 = (1-alph192)*Pibar^(theta*(1-ppsi)-1)*(lam192(-1) - p) + (1-(1-alph192)*Pibar^(theta*(1-ppsi)-1))*ps192;
lam193 = (1-alph193)*Pibar^(theta*(1-ppsi)-1)*(lam193(-1) - p) + (1-(1-alph193)*Pibar^(theta*(1-ppsi)-1))*ps193;
lam194 = (1-alph194)*Pibar^(theta*(1-ppsi)-1)*(lam194(-1) - p) + (1-(1-alph194)*Pibar^(theta*(1-ppsi)-1))*ps194;
lam195 = (1-alph195)*Pibar^(theta*(1-ppsi)-1)*(lam195(-1) - p) + (1-(1-alph195)*Pibar^(theta*(1-ppsi)-1))*ps195;
lam196 = (1-alph196)*Pibar^(theta*(1-ppsi)-1)*(lam196(-1) - p) + (1-(1-alph196)*Pibar^(theta*(1-ppsi)-1))*ps196;
lam197 = (1-alph197)*Pibar^(theta*(1-ppsi)-1)*(lam197(-1) - p) + (1-(1-alph197)*Pibar^(theta*(1-ppsi)-1))*ps197;
lam198 = (1-alph198)*Pibar^(theta*(1-ppsi)-1)*(lam198(-1) - p) + (1-(1-alph198)*Pibar^(theta*(1-ppsi)-1))*ps198;
lam199 = (1-alph199)*Pibar^(theta*(1-ppsi)-1)*(lam199(-1) - p) + (1-(1-alph199)*Pibar^(theta*(1-ppsi)-1))*ps199;
lam200 = (1-alph200)*Pibar^(theta*(1-ppsi)-1)*(lam200(-1) - p) + (1-(1-alph200)*Pibar^(theta*(1-ppsi)-1))*ps200;
lam201 = (1-alph201)*Pibar^(theta*(1-ppsi)-1)*(lam201(-1) - p) + (1-(1-alph201)*Pibar^(theta*(1-ppsi)-1))*ps201;
lam202 = (1-alph202)*Pibar^(theta*(1-ppsi)-1)*(lam202(-1) - p) + (1-(1-alph202)*Pibar^(theta*(1-ppsi)-1))*ps202;
lam203 = (1-alph203)*Pibar^(theta*(1-ppsi)-1)*(lam203(-1) - p) + (1-(1-alph203)*Pibar^(theta*(1-ppsi)-1))*ps203;
lam204 = (1-alph204)*Pibar^(theta*(1-ppsi)-1)*(lam204(-1) - p) + (1-(1-alph204)*Pibar^(theta*(1-ppsi)-1))*ps204;
lam205 = (1-alph205)*Pibar^(theta*(1-ppsi)-1)*(lam205(-1) - p) + (1-(1-alph205)*Pibar^(theta*(1-ppsi)-1))*ps205;
lam206 = (1-alph206)*Pibar^(theta*(1-ppsi)-1)*(lam206(-1) - p) + (1-(1-alph206)*Pibar^(theta*(1-ppsi)-1))*ps206;
lam207 = (1-alph207)*Pibar^(theta*(1-ppsi)-1)*(lam207(-1) - p) + (1-(1-alph207)*Pibar^(theta*(1-ppsi)-1))*ps207;
lam208 = (1-alph208)*Pibar^(theta*(1-ppsi)-1)*(lam208(-1) - p) + (1-(1-alph208)*Pibar^(theta*(1-ppsi)-1))*ps208;
lam209 = (1-alph209)*Pibar^(theta*(1-ppsi)-1)*(lam209(-1) - p) + (1-(1-alph209)*Pibar^(theta*(1-ppsi)-1))*ps209;
lam210 = (1-alph210)*Pibar^(theta*(1-ppsi)-1)*(lam210(-1) - p) + (1-(1-alph210)*Pibar^(theta*(1-ppsi)-1))*ps210;
lam211 = (1-alph211)*Pibar^(theta*(1-ppsi)-1)*(lam211(-1) - p) + (1-(1-alph211)*Pibar^(theta*(1-ppsi)-1))*ps211;
lam212 = (1-alph212)*Pibar^(theta*(1-ppsi)-1)*(lam212(-1) - p) + (1-(1-alph212)*Pibar^(theta*(1-ppsi)-1))*ps212;
lam213 = (1-alph213)*Pibar^(theta*(1-ppsi)-1)*(lam213(-1) - p) + (1-(1-alph213)*Pibar^(theta*(1-ppsi)-1))*ps213;
lam214 = (1-alph214)*Pibar^(theta*(1-ppsi)-1)*(lam214(-1) - p) + (1-(1-alph214)*Pibar^(theta*(1-ppsi)-1))*ps214;
lam215 = (1-alph215)*Pibar^(theta*(1-ppsi)-1)*(lam215(-1) - p) + (1-(1-alph215)*Pibar^(theta*(1-ppsi)-1))*ps215;
lam216 = (1-alph216)*Pibar^(theta*(1-ppsi)-1)*(lam216(-1) - p) + (1-(1-alph216)*Pibar^(theta*(1-ppsi)-1))*ps216;
lam217 = (1-alph217)*Pibar^(theta*(1-ppsi)-1)*(lam217(-1) - p) + (1-(1-alph217)*Pibar^(theta*(1-ppsi)-1))*ps217;
lam218 = (1-alph218)*Pibar^(theta*(1-ppsi)-1)*(lam218(-1) - p) + (1-(1-alph218)*Pibar^(theta*(1-ppsi)-1))*ps218;
lam219 = (1-alph219)*Pibar^(theta*(1-ppsi)-1)*(lam219(-1) - p) + (1-(1-alph219)*Pibar^(theta*(1-ppsi)-1))*ps219;
lam220 = (1-alph220)*Pibar^(theta*(1-ppsi)-1)*(lam220(-1) - p) + (1-(1-alph220)*Pibar^(theta*(1-ppsi)-1))*ps220;
lam221 = (1-alph221)*Pibar^(theta*(1-ppsi)-1)*(lam221(-1) - p) + (1-(1-alph221)*Pibar^(theta*(1-ppsi)-1))*ps221;
lam222 = (1-alph222)*Pibar^(theta*(1-ppsi)-1)*(lam222(-1) - p) + (1-(1-alph222)*Pibar^(theta*(1-ppsi)-1))*ps222;
lam223 = (1-alph223)*Pibar^(theta*(1-ppsi)-1)*(lam223(-1) - p) + (1-(1-alph223)*Pibar^(theta*(1-ppsi)-1))*ps223;
lam224 = (1-alph224)*Pibar^(theta*(1-ppsi)-1)*(lam224(-1) - p) + (1-(1-alph224)*Pibar^(theta*(1-ppsi)-1))*ps224;
lam225 = (1-alph225)*Pibar^(theta*(1-ppsi)-1)*(lam225(-1) - p) + (1-(1-alph225)*Pibar^(theta*(1-ppsi)-1))*ps225;
lam226 = (1-alph226)*Pibar^(theta*(1-ppsi)-1)*(lam226(-1) - p) + (1-(1-alph226)*Pibar^(theta*(1-ppsi)-1))*ps226;
lam227 = (1-alph227)*Pibar^(theta*(1-ppsi)-1)*(lam227(-1) - p) + (1-(1-alph227)*Pibar^(theta*(1-ppsi)-1))*ps227;
lam228 = (1-alph228)*Pibar^(theta*(1-ppsi)-1)*(lam228(-1) - p) + (1-(1-alph228)*Pibar^(theta*(1-ppsi)-1))*ps228;
lam229 = (1-alph229)*Pibar^(theta*(1-ppsi)-1)*(lam229(-1) - p) + (1-(1-alph229)*Pibar^(theta*(1-ppsi)-1))*ps229;
lam230 = (1-alph230)*Pibar^(theta*(1-ppsi)-1)*(lam230(-1) - p) + (1-(1-alph230)*Pibar^(theta*(1-ppsi)-1))*ps230;
lam231 = (1-alph231)*Pibar^(theta*(1-ppsi)-1)*(lam231(-1) - p) + (1-(1-alph231)*Pibar^(theta*(1-ppsi)-1))*ps231;
lam232 = (1-alph232)*Pibar^(theta*(1-ppsi)-1)*(lam232(-1) - p) + (1-(1-alph232)*Pibar^(theta*(1-ppsi)-1))*ps232;
lam233 = (1-alph233)*Pibar^(theta*(1-ppsi)-1)*(lam233(-1) - p) + (1-(1-alph233)*Pibar^(theta*(1-ppsi)-1))*ps233;
lam234 = (1-alph234)*Pibar^(theta*(1-ppsi)-1)*(lam234(-1) - p) + (1-(1-alph234)*Pibar^(theta*(1-ppsi)-1))*ps234;
lam235 = (1-alph235)*Pibar^(theta*(1-ppsi)-1)*(lam235(-1) - p) + (1-(1-alph235)*Pibar^(theta*(1-ppsi)-1))*ps235;
lam236 = (1-alph236)*Pibar^(theta*(1-ppsi)-1)*(lam236(-1) - p) + (1-(1-alph236)*Pibar^(theta*(1-ppsi)-1))*ps236;
lam237 = (1-alph237)*Pibar^(theta*(1-ppsi)-1)*(lam237(-1) - p) + (1-(1-alph237)*Pibar^(theta*(1-ppsi)-1))*ps237;
lam238 = (1-alph238)*Pibar^(theta*(1-ppsi)-1)*(lam238(-1) - p) + (1-(1-alph238)*Pibar^(theta*(1-ppsi)-1))*ps238;
lam239 = (1-alph239)*Pibar^(theta*(1-ppsi)-1)*(lam239(-1) - p) + (1-(1-alph239)*Pibar^(theta*(1-ppsi)-1))*ps239;
lam240 = (1-alph240)*Pibar^(theta*(1-ppsi)-1)*(lam240(-1) - p) + (1-(1-alph240)*Pibar^(theta*(1-ppsi)-1))*ps240;
lam241 = (1-alph241)*Pibar^(theta*(1-ppsi)-1)*(lam241(-1) - p) + (1-(1-alph241)*Pibar^(theta*(1-ppsi)-1))*ps241;
lam242 = (1-alph242)*Pibar^(theta*(1-ppsi)-1)*(lam242(-1) - p) + (1-(1-alph242)*Pibar^(theta*(1-ppsi)-1))*ps242;
lam243 = (1-alph243)*Pibar^(theta*(1-ppsi)-1)*(lam243(-1) - p) + (1-(1-alph243)*Pibar^(theta*(1-ppsi)-1))*ps243;
lam244 = (1-alph244)*Pibar^(theta*(1-ppsi)-1)*(lam244(-1) - p) + (1-(1-alph244)*Pibar^(theta*(1-ppsi)-1))*ps244;
lam245 = (1-alph245)*Pibar^(theta*(1-ppsi)-1)*(lam245(-1) - p) + (1-(1-alph245)*Pibar^(theta*(1-ppsi)-1))*ps245;
lam246 = (1-alph246)*Pibar^(theta*(1-ppsi)-1)*(lam246(-1) - p) + (1-(1-alph246)*Pibar^(theta*(1-ppsi)-1))*ps246;
lam247 = (1-alph247)*Pibar^(theta*(1-ppsi)-1)*(lam247(-1) - p) + (1-(1-alph247)*Pibar^(theta*(1-ppsi)-1))*ps247;
lam248 = (1-alph248)*Pibar^(theta*(1-ppsi)-1)*(lam248(-1) - p) + (1-(1-alph248)*Pibar^(theta*(1-ppsi)-1))*ps248;
lam249 = (1-alph249)*Pibar^(theta*(1-ppsi)-1)*(lam249(-1) - p) + (1-(1-alph249)*Pibar^(theta*(1-ppsi)-1))*ps249;
lam250 = (1-alph250)*Pibar^(theta*(1-ppsi)-1)*(lam250(-1) - p) + (1-(1-alph250)*Pibar^(theta*(1-ppsi)-1))*ps250;
lam251 = (1-alph251)*Pibar^(theta*(1-ppsi)-1)*(lam251(-1) - p) + (1-(1-alph251)*Pibar^(theta*(1-ppsi)-1))*ps251;
lam252 = (1-alph252)*Pibar^(theta*(1-ppsi)-1)*(lam252(-1) - p) + (1-(1-alph252)*Pibar^(theta*(1-ppsi)-1))*ps252;
lam253 = (1-alph253)*Pibar^(theta*(1-ppsi)-1)*(lam253(-1) - p) + (1-(1-alph253)*Pibar^(theta*(1-ppsi)-1))*ps253;
lam254 = (1-alph254)*Pibar^(theta*(1-ppsi)-1)*(lam254(-1) - p) + (1-(1-alph254)*Pibar^(theta*(1-ppsi)-1))*ps254;
lam255 = (1-alph255)*Pibar^(theta*(1-ppsi)-1)*(lam255(-1) - p) + (1-(1-alph255)*Pibar^(theta*(1-ppsi)-1))*ps255;
lam256 = (1-alph256)*Pibar^(theta*(1-ppsi)-1)*(lam256(-1) - p) + (1-(1-alph256)*Pibar^(theta*(1-ppsi)-1))*ps256;
lam257 = (1-alph257)*Pibar^(theta*(1-ppsi)-1)*(lam257(-1) - p) + (1-(1-alph257)*Pibar^(theta*(1-ppsi)-1))*ps257;
lam258 = (1-alph258)*Pibar^(theta*(1-ppsi)-1)*(lam258(-1) - p) + (1-(1-alph258)*Pibar^(theta*(1-ppsi)-1))*ps258;
lam259 = (1-alph259)*Pibar^(theta*(1-ppsi)-1)*(lam259(-1) - p) + (1-(1-alph259)*Pibar^(theta*(1-ppsi)-1))*ps259;
lam260 = (1-alph260)*Pibar^(theta*(1-ppsi)-1)*(lam260(-1) - p) + (1-(1-alph260)*Pibar^(theta*(1-ppsi)-1))*ps260;
lam261 = (1-alph261)*Pibar^(theta*(1-ppsi)-1)*(lam261(-1) - p) + (1-(1-alph261)*Pibar^(theta*(1-ppsi)-1))*ps261;
lam262 = (1-alph262)*Pibar^(theta*(1-ppsi)-1)*(lam262(-1) - p) + (1-(1-alph262)*Pibar^(theta*(1-ppsi)-1))*ps262;
lam263 = (1-alph263)*Pibar^(theta*(1-ppsi)-1)*(lam263(-1) - p) + (1-(1-alph263)*Pibar^(theta*(1-ppsi)-1))*ps263;
lam264 = (1-alph264)*Pibar^(theta*(1-ppsi)-1)*(lam264(-1) - p) + (1-(1-alph264)*Pibar^(theta*(1-ppsi)-1))*ps264;
lam265 = (1-alph265)*Pibar^(theta*(1-ppsi)-1)*(lam265(-1) - p) + (1-(1-alph265)*Pibar^(theta*(1-ppsi)-1))*ps265;
lam266 = (1-alph266)*Pibar^(theta*(1-ppsi)-1)*(lam266(-1) - p) + (1-(1-alph266)*Pibar^(theta*(1-ppsi)-1))*ps266;
lam267 = (1-alph267)*Pibar^(theta*(1-ppsi)-1)*(lam267(-1) - p) + (1-(1-alph267)*Pibar^(theta*(1-ppsi)-1))*ps267;
lam268 = (1-alph268)*Pibar^(theta*(1-ppsi)-1)*(lam268(-1) - p) + (1-(1-alph268)*Pibar^(theta*(1-ppsi)-1))*ps268;
lam269 = (1-alph269)*Pibar^(theta*(1-ppsi)-1)*(lam269(-1) - p) + (1-(1-alph269)*Pibar^(theta*(1-ppsi)-1))*ps269;
lam270 = (1-alph270)*Pibar^(theta*(1-ppsi)-1)*(lam270(-1) - p) + (1-(1-alph270)*Pibar^(theta*(1-ppsi)-1))*ps270;
lam271 = (1-alph271)*Pibar^(theta*(1-ppsi)-1)*(lam271(-1) - p) + (1-(1-alph271)*Pibar^(theta*(1-ppsi)-1))*ps271;
lam272 = (1-alph272)*Pibar^(theta*(1-ppsi)-1)*(lam272(-1) - p) + (1-(1-alph272)*Pibar^(theta*(1-ppsi)-1))*ps272;
 
% lam = ppsi*(f1*S1bar/Lambar*s1 + f2*S2bar/Lambar*s2);
lam = ppsi*(f001*S001bar/Lambar*s001+f002*S002bar/Lambar*s002+f003*S003bar/Lambar*s003+f004*S004bar/Lambar*s004+f005*S005bar/Lambar*s005+f006*S006bar/Lambar*s006+f007*S007bar/Lambar*s007+f008*S008bar/Lambar*s008+f009*S009bar/Lambar*s009+f010*S010bar/Lambar*s010+f011*S011bar/Lambar*s011+f012*S012bar/Lambar*s012+f013*S013bar/Lambar*s013+f014*S014bar/Lambar*s014+f015*S015bar/Lambar*s015+f016*S016bar/Lambar*s016+f017*S017bar/Lambar*s017+f018*S018bar/Lambar*s018+f019*S019bar/Lambar*s019+f020*S020bar/Lambar*s020+f021*S021bar/Lambar*s021+f022*S022bar/Lambar*s022+f023*S023bar/Lambar*s023+f024*S024bar/Lambar*s024+f025*S025bar/Lambar*s025+f026*S026bar/Lambar*s026+f027*S027bar/Lambar*s027+f028*S028bar/Lambar*s028+f029*S029bar/Lambar*s029+f030*S030bar/Lambar*s030+f031*S031bar/Lambar*s031+f032*S032bar/Lambar*s032+f033*S033bar/Lambar*s033+f034*S034bar/Lambar*s034+f035*S035bar/Lambar*s035+f036*S036bar/Lambar*s036+f037*S037bar/Lambar*s037+f038*S038bar/Lambar*s038+f039*S039bar/Lambar*s039+f040*S040bar/Lambar*s040+f041*S041bar/Lambar*s041+f042*S042bar/Lambar*s042+f043*S043bar/Lambar*s043+f044*S044bar/Lambar*s044+f045*S045bar/Lambar*s045+f046*S046bar/Lambar*s046+f047*S047bar/Lambar*s047+f048*S048bar/Lambar*s048+f049*S049bar/Lambar*s049+f050*S050bar/Lambar*s050+f051*S051bar/Lambar*s051+f052*S052bar/Lambar*s052+f053*S053bar/Lambar*s053+f054*S054bar/Lambar*s054+f055*S055bar/Lambar*s055+f056*S056bar/Lambar*s056+f057*S057bar/Lambar*s057+f058*S058bar/Lambar*s058+f059*S059bar/Lambar*s059+f060*S060bar/Lambar*s060+f061*S061bar/Lambar*s061+f062*S062bar/Lambar*s062+f063*S063bar/Lambar*s063+f064*S064bar/Lambar*s064+f065*S065bar/Lambar*s065+f066*S066bar/Lambar*s066+f067*S067bar/Lambar*s067+f068*S068bar/Lambar*s068+f069*S069bar/Lambar*s069+f070*S070bar/Lambar*s070+f071*S071bar/Lambar*s071+f072*S072bar/Lambar*s072+f073*S073bar/Lambar*s073+f074*S074bar/Lambar*s074+f075*S075bar/Lambar*s075+f076*S076bar/Lambar*s076+f077*S077bar/Lambar*s077+f078*S078bar/Lambar*s078+f079*S079bar/Lambar*s079+f080*S080bar/Lambar*s080+f081*S081bar/Lambar*s081+f082*S082bar/Lambar*s082+f083*S083bar/Lambar*s083+f084*S084bar/Lambar*s084+f085*S085bar/Lambar*s085+f086*S086bar/Lambar*s086+f087*S087bar/Lambar*s087+f088*S088bar/Lambar*s088+f089*S089bar/Lambar*s089+f090*S090bar/Lambar*s090+f091*S091bar/Lambar*s091+f092*S092bar/Lambar*s092+f093*S093bar/Lambar*s093+f094*S094bar/Lambar*s094+f095*S095bar/Lambar*s095+f096*S096bar/Lambar*s096+f097*S097bar/Lambar*s097+f098*S098bar/Lambar*s098+f099*S099bar/Lambar*s099+f100*S100bar/Lambar*s100+f101*S101bar/Lambar*s101+f102*S102bar/Lambar*s102+f103*S103bar/Lambar*s103+f104*S104bar/Lambar*s104+f105*S105bar/Lambar*s105+f106*S106bar/Lambar*s106+f107*S107bar/Lambar*s107+f108*S108bar/Lambar*s108+f109*S109bar/Lambar*s109+f110*S110bar/Lambar*s110+f111*S111bar/Lambar*s111+f112*S112bar/Lambar*s112+f113*S113bar/Lambar*s113+f114*S114bar/Lambar*s114+f115*S115bar/Lambar*s115+f116*S116bar/Lambar*s116+f117*S117bar/Lambar*s117+f118*S118bar/Lambar*s118+f119*S119bar/Lambar*s119+f120*S120bar/Lambar*s120+f121*S121bar/Lambar*s121+f122*S122bar/Lambar*s122+f123*S123bar/Lambar*s123+f124*S124bar/Lambar*s124+f125*S125bar/Lambar*s125+f126*S126bar/Lambar*s126+f127*S127bar/Lambar*s127+f128*S128bar/Lambar*s128+f129*S129bar/Lambar*s129+f130*S130bar/Lambar*s130+f131*S131bar/Lambar*s131+f132*S132bar/Lambar*s132+f133*S133bar/Lambar*s133+f134*S134bar/Lambar*s134+f135*S135bar/Lambar*s135+f136*S136bar/Lambar*s136+f137*S137bar/Lambar*s137+f138*S138bar/Lambar*s138+f139*S139bar/Lambar*s139+f140*S140bar/Lambar*s140+f141*S141bar/Lambar*s141+f142*S142bar/Lambar*s142+f143*S143bar/Lambar*s143+f144*S144bar/Lambar*s144+f145*S145bar/Lambar*s145+f146*S146bar/Lambar*s146+f147*S147bar/Lambar*s147+f148*S148bar/Lambar*s148+f149*S149bar/Lambar*s149+f150*S150bar/Lambar*s150+f151*S151bar/Lambar*s151+f152*S152bar/Lambar*s152+f153*S153bar/Lambar*s153+f154*S154bar/Lambar*s154+f155*S155bar/Lambar*s155+f156*S156bar/Lambar*s156+f157*S157bar/Lambar*s157+f158*S158bar/Lambar*s158+f159*S159bar/Lambar*s159+f160*S160bar/Lambar*s160+f161*S161bar/Lambar*s161+f162*S162bar/Lambar*s162+f163*S163bar/Lambar*s163+f164*S164bar/Lambar*s164+f165*S165bar/Lambar*s165+f166*S166bar/Lambar*s166+f167*S167bar/Lambar*s167+f168*S168bar/Lambar*s168+f169*S169bar/Lambar*s169+f170*S170bar/Lambar*s170+f171*S171bar/Lambar*s171+f172*S172bar/Lambar*s172+f173*S173bar/Lambar*s173+f174*S174bar/Lambar*s174+f175*S175bar/Lambar*s175+f176*S176bar/Lambar*s176+f177*S177bar/Lambar*s177+f178*S178bar/Lambar*s178+f179*S179bar/Lambar*s179+f180*S180bar/Lambar*s180+f181*S181bar/Lambar*s181+f182*S182bar/Lambar*s182+f183*S183bar/Lambar*s183+f184*S184bar/Lambar*s184+f185*S185bar/Lambar*s185+f186*S186bar/Lambar*s186+f187*S187bar/Lambar*s187+f188*S188bar/Lambar*s188+f189*S189bar/Lambar*s189+f190*S190bar/Lambar*s190+f191*S191bar/Lambar*s191+f192*S192bar/Lambar*s192+f193*S193bar/Lambar*s193+f194*S194bar/Lambar*s194+f195*S195bar/Lambar*s195+f196*S196bar/Lambar*s196+f197*S197bar/Lambar*s197+f198*S198bar/Lambar*s198+f199*S199bar/Lambar*s199+f200*S200bar/Lambar*s200+f201*S201bar/Lambar*s201+f202*S202bar/Lambar*s202+f203*S203bar/Lambar*s203+f204*S204bar/Lambar*s204+f205*S205bar/Lambar*s205+f206*S206bar/Lambar*s206+f207*S207bar/Lambar*s207+f208*S208bar/Lambar*s208+f209*S209bar/Lambar*s209+f210*S210bar/Lambar*s210+f211*S211bar/Lambar*s211+f212*S212bar/Lambar*s212+f213*S213bar/Lambar*s213+f214*S214bar/Lambar*s214+f215*S215bar/Lambar*s215+f216*S216bar/Lambar*s216+f217*S217bar/Lambar*s217+f218*S218bar/Lambar*s218+f219*S219bar/Lambar*s219+f220*S220bar/Lambar*s220+f221*S221bar/Lambar*s221+f222*S222bar/Lambar*s222+f223*S223bar/Lambar*s223+f224*S224bar/Lambar*s224+f225*S225bar/Lambar*s225+f226*S226bar/Lambar*s226+f227*S227bar/Lambar*s227+f228*S228bar/Lambar*s228+f229*S229bar/Lambar*s229+f230*S230bar/Lambar*s230+f231*S231bar/Lambar*s231+f232*S232bar/Lambar*s232+f233*S233bar/Lambar*s233+f234*S234bar/Lambar*s234+f235*S235bar/Lambar*s235+f236*S236bar/Lambar*s236+f237*S237bar/Lambar*s237+f238*S238bar/Lambar*s238+f239*S239bar/Lambar*s239+f240*S240bar/Lambar*s240+f241*S241bar/Lambar*s241+f242*S242bar/Lambar*s242+f243*S243bar/Lambar*s243+f244*S244bar/Lambar*s244+f245*S245bar/Lambar*s245+f246*S246bar/Lambar*s246+f247*S247bar/Lambar*s247+f248*S248bar/Lambar*s248+f249*S249bar/Lambar*s249+f250*S250bar/Lambar*s250+f251*S251bar/Lambar*s251+f252*S252bar/Lambar*s252+f253*S253bar/Lambar*s253+f254*S254bar/Lambar*s254+f255*S255bar/Lambar*s255+f256*S256bar/Lambar*s256+f257*S257bar/Lambar*s257+f258*S258bar/Lambar*s258+f259*S259bar/Lambar*s259+f260*S260bar/Lambar*s260+f261*S261bar/Lambar*s261+f262*S262bar/Lambar*s262+f263*S263bar/Lambar*s263+f264*S264bar/Lambar*s264+f265*S265bar/Lambar*s265+f266*S266bar/Lambar*s266+f267*S267bar/Lambar*s267+f268*S268bar/Lambar*s268+f269*S269bar/Lambar*s269+f270*S270bar/Lambar*s270+f271*S271bar/Lambar*s271+f272*S272bar/Lambar*s272);

% s1  = (1-alph1)/Pibar*(s1(-1) - p) + (1-(1-alph1)/Pibar)*ps1;
% s2  = (1-alph2)/Pibar*(s2(-1) - p) + (1-(1-alph2)/Pibar)*ps2;
s001  = (1-alph001)/Pibar*(s001(-1) - p) + (1-(1-alph001)/Pibar)*ps001;
s002  = (1-alph002)/Pibar*(s002(-1) - p) + (1-(1-alph002)/Pibar)*ps002;
s003  = (1-alph003)/Pibar*(s003(-1) - p) + (1-(1-alph003)/Pibar)*ps003;
s004  = (1-alph004)/Pibar*(s004(-1) - p) + (1-(1-alph004)/Pibar)*ps004;
s005  = (1-alph005)/Pibar*(s005(-1) - p) + (1-(1-alph005)/Pibar)*ps005;
s006  = (1-alph006)/Pibar*(s006(-1) - p) + (1-(1-alph006)/Pibar)*ps006;
s007  = (1-alph007)/Pibar*(s007(-1) - p) + (1-(1-alph007)/Pibar)*ps007;
s008  = (1-alph008)/Pibar*(s008(-1) - p) + (1-(1-alph008)/Pibar)*ps008;
s009  = (1-alph009)/Pibar*(s009(-1) - p) + (1-(1-alph009)/Pibar)*ps009;
s010  = (1-alph010)/Pibar*(s010(-1) - p) + (1-(1-alph010)/Pibar)*ps010;
s011  = (1-alph011)/Pibar*(s011(-1) - p) + (1-(1-alph011)/Pibar)*ps011;
s012  = (1-alph012)/Pibar*(s012(-1) - p) + (1-(1-alph012)/Pibar)*ps012;
s013  = (1-alph013)/Pibar*(s013(-1) - p) + (1-(1-alph013)/Pibar)*ps013;
s014  = (1-alph014)/Pibar*(s014(-1) - p) + (1-(1-alph014)/Pibar)*ps014;
s015  = (1-alph015)/Pibar*(s015(-1) - p) + (1-(1-alph015)/Pibar)*ps015;
s016  = (1-alph016)/Pibar*(s016(-1) - p) + (1-(1-alph016)/Pibar)*ps016;
s017  = (1-alph017)/Pibar*(s017(-1) - p) + (1-(1-alph017)/Pibar)*ps017;
s018  = (1-alph018)/Pibar*(s018(-1) - p) + (1-(1-alph018)/Pibar)*ps018;
s019  = (1-alph019)/Pibar*(s019(-1) - p) + (1-(1-alph019)/Pibar)*ps019;
s020  = (1-alph020)/Pibar*(s020(-1) - p) + (1-(1-alph020)/Pibar)*ps020;
s021  = (1-alph021)/Pibar*(s021(-1) - p) + (1-(1-alph021)/Pibar)*ps021;
s022  = (1-alph022)/Pibar*(s022(-1) - p) + (1-(1-alph022)/Pibar)*ps022;
s023  = (1-alph023)/Pibar*(s023(-1) - p) + (1-(1-alph023)/Pibar)*ps023;
s024  = (1-alph024)/Pibar*(s024(-1) - p) + (1-(1-alph024)/Pibar)*ps024;
s025  = (1-alph025)/Pibar*(s025(-1) - p) + (1-(1-alph025)/Pibar)*ps025;
s026  = (1-alph026)/Pibar*(s026(-1) - p) + (1-(1-alph026)/Pibar)*ps026;
s027  = (1-alph027)/Pibar*(s027(-1) - p) + (1-(1-alph027)/Pibar)*ps027;
s028  = (1-alph028)/Pibar*(s028(-1) - p) + (1-(1-alph028)/Pibar)*ps028;
s029  = (1-alph029)/Pibar*(s029(-1) - p) + (1-(1-alph029)/Pibar)*ps029;
s030  = (1-alph030)/Pibar*(s030(-1) - p) + (1-(1-alph030)/Pibar)*ps030;
s031  = (1-alph031)/Pibar*(s031(-1) - p) + (1-(1-alph031)/Pibar)*ps031;
s032  = (1-alph032)/Pibar*(s032(-1) - p) + (1-(1-alph032)/Pibar)*ps032;
s033  = (1-alph033)/Pibar*(s033(-1) - p) + (1-(1-alph033)/Pibar)*ps033;
s034  = (1-alph034)/Pibar*(s034(-1) - p) + (1-(1-alph034)/Pibar)*ps034;
s035  = (1-alph035)/Pibar*(s035(-1) - p) + (1-(1-alph035)/Pibar)*ps035;
s036  = (1-alph036)/Pibar*(s036(-1) - p) + (1-(1-alph036)/Pibar)*ps036;
s037  = (1-alph037)/Pibar*(s037(-1) - p) + (1-(1-alph037)/Pibar)*ps037;
s038  = (1-alph038)/Pibar*(s038(-1) - p) + (1-(1-alph038)/Pibar)*ps038;
s039  = (1-alph039)/Pibar*(s039(-1) - p) + (1-(1-alph039)/Pibar)*ps039;
s040  = (1-alph040)/Pibar*(s040(-1) - p) + (1-(1-alph040)/Pibar)*ps040;
s041  = (1-alph041)/Pibar*(s041(-1) - p) + (1-(1-alph041)/Pibar)*ps041;
s042  = (1-alph042)/Pibar*(s042(-1) - p) + (1-(1-alph042)/Pibar)*ps042;
s043  = (1-alph043)/Pibar*(s043(-1) - p) + (1-(1-alph043)/Pibar)*ps043;
s044  = (1-alph044)/Pibar*(s044(-1) - p) + (1-(1-alph044)/Pibar)*ps044;
s045  = (1-alph045)/Pibar*(s045(-1) - p) + (1-(1-alph045)/Pibar)*ps045;
s046  = (1-alph046)/Pibar*(s046(-1) - p) + (1-(1-alph046)/Pibar)*ps046;
s047  = (1-alph047)/Pibar*(s047(-1) - p) + (1-(1-alph047)/Pibar)*ps047;
s048  = (1-alph048)/Pibar*(s048(-1) - p) + (1-(1-alph048)/Pibar)*ps048;
s049  = (1-alph049)/Pibar*(s049(-1) - p) + (1-(1-alph049)/Pibar)*ps049;
s050  = (1-alph050)/Pibar*(s050(-1) - p) + (1-(1-alph050)/Pibar)*ps050;
s051  = (1-alph051)/Pibar*(s051(-1) - p) + (1-(1-alph051)/Pibar)*ps051;
s052  = (1-alph052)/Pibar*(s052(-1) - p) + (1-(1-alph052)/Pibar)*ps052;
s053  = (1-alph053)/Pibar*(s053(-1) - p) + (1-(1-alph053)/Pibar)*ps053;
s054  = (1-alph054)/Pibar*(s054(-1) - p) + (1-(1-alph054)/Pibar)*ps054;
s055  = (1-alph055)/Pibar*(s055(-1) - p) + (1-(1-alph055)/Pibar)*ps055;
s056  = (1-alph056)/Pibar*(s056(-1) - p) + (1-(1-alph056)/Pibar)*ps056;
s057  = (1-alph057)/Pibar*(s057(-1) - p) + (1-(1-alph057)/Pibar)*ps057;
s058  = (1-alph058)/Pibar*(s058(-1) - p) + (1-(1-alph058)/Pibar)*ps058;
s059  = (1-alph059)/Pibar*(s059(-1) - p) + (1-(1-alph059)/Pibar)*ps059;
s060  = (1-alph060)/Pibar*(s060(-1) - p) + (1-(1-alph060)/Pibar)*ps060;
s061  = (1-alph061)/Pibar*(s061(-1) - p) + (1-(1-alph061)/Pibar)*ps061;
s062  = (1-alph062)/Pibar*(s062(-1) - p) + (1-(1-alph062)/Pibar)*ps062;
s063  = (1-alph063)/Pibar*(s063(-1) - p) + (1-(1-alph063)/Pibar)*ps063;
s064  = (1-alph064)/Pibar*(s064(-1) - p) + (1-(1-alph064)/Pibar)*ps064;
s065  = (1-alph065)/Pibar*(s065(-1) - p) + (1-(1-alph065)/Pibar)*ps065;
s066  = (1-alph066)/Pibar*(s066(-1) - p) + (1-(1-alph066)/Pibar)*ps066;
s067  = (1-alph067)/Pibar*(s067(-1) - p) + (1-(1-alph067)/Pibar)*ps067;
s068  = (1-alph068)/Pibar*(s068(-1) - p) + (1-(1-alph068)/Pibar)*ps068;
s069  = (1-alph069)/Pibar*(s069(-1) - p) + (1-(1-alph069)/Pibar)*ps069;
s070  = (1-alph070)/Pibar*(s070(-1) - p) + (1-(1-alph070)/Pibar)*ps070;
s071  = (1-alph071)/Pibar*(s071(-1) - p) + (1-(1-alph071)/Pibar)*ps071;
s072  = (1-alph072)/Pibar*(s072(-1) - p) + (1-(1-alph072)/Pibar)*ps072;
s073  = (1-alph073)/Pibar*(s073(-1) - p) + (1-(1-alph073)/Pibar)*ps073;
s074  = (1-alph074)/Pibar*(s074(-1) - p) + (1-(1-alph074)/Pibar)*ps074;
s075  = (1-alph075)/Pibar*(s075(-1) - p) + (1-(1-alph075)/Pibar)*ps075;
s076  = (1-alph076)/Pibar*(s076(-1) - p) + (1-(1-alph076)/Pibar)*ps076;
s077  = (1-alph077)/Pibar*(s077(-1) - p) + (1-(1-alph077)/Pibar)*ps077;
s078  = (1-alph078)/Pibar*(s078(-1) - p) + (1-(1-alph078)/Pibar)*ps078;
s079  = (1-alph079)/Pibar*(s079(-1) - p) + (1-(1-alph079)/Pibar)*ps079;
s080  = (1-alph080)/Pibar*(s080(-1) - p) + (1-(1-alph080)/Pibar)*ps080;
s081  = (1-alph081)/Pibar*(s081(-1) - p) + (1-(1-alph081)/Pibar)*ps081;
s082  = (1-alph082)/Pibar*(s082(-1) - p) + (1-(1-alph082)/Pibar)*ps082;
s083  = (1-alph083)/Pibar*(s083(-1) - p) + (1-(1-alph083)/Pibar)*ps083;
s084  = (1-alph084)/Pibar*(s084(-1) - p) + (1-(1-alph084)/Pibar)*ps084;
s085  = (1-alph085)/Pibar*(s085(-1) - p) + (1-(1-alph085)/Pibar)*ps085;
s086  = (1-alph086)/Pibar*(s086(-1) - p) + (1-(1-alph086)/Pibar)*ps086;
s087  = (1-alph087)/Pibar*(s087(-1) - p) + (1-(1-alph087)/Pibar)*ps087;
s088  = (1-alph088)/Pibar*(s088(-1) - p) + (1-(1-alph088)/Pibar)*ps088;
s089  = (1-alph089)/Pibar*(s089(-1) - p) + (1-(1-alph089)/Pibar)*ps089;
s090  = (1-alph090)/Pibar*(s090(-1) - p) + (1-(1-alph090)/Pibar)*ps090;
s091  = (1-alph091)/Pibar*(s091(-1) - p) + (1-(1-alph091)/Pibar)*ps091;
s092  = (1-alph092)/Pibar*(s092(-1) - p) + (1-(1-alph092)/Pibar)*ps092;
s093  = (1-alph093)/Pibar*(s093(-1) - p) + (1-(1-alph093)/Pibar)*ps093;
s094  = (1-alph094)/Pibar*(s094(-1) - p) + (1-(1-alph094)/Pibar)*ps094;
s095  = (1-alph095)/Pibar*(s095(-1) - p) + (1-(1-alph095)/Pibar)*ps095;
s096  = (1-alph096)/Pibar*(s096(-1) - p) + (1-(1-alph096)/Pibar)*ps096;
s097  = (1-alph097)/Pibar*(s097(-1) - p) + (1-(1-alph097)/Pibar)*ps097;
s098  = (1-alph098)/Pibar*(s098(-1) - p) + (1-(1-alph098)/Pibar)*ps098;
s099  = (1-alph099)/Pibar*(s099(-1) - p) + (1-(1-alph099)/Pibar)*ps099;
s100  = (1-alph100)/Pibar*(s100(-1) - p) + (1-(1-alph100)/Pibar)*ps100;
s101  = (1-alph101)/Pibar*(s101(-1) - p) + (1-(1-alph101)/Pibar)*ps101;
s102  = (1-alph102)/Pibar*(s102(-1) - p) + (1-(1-alph102)/Pibar)*ps102;
s103  = (1-alph103)/Pibar*(s103(-1) - p) + (1-(1-alph103)/Pibar)*ps103;
s104  = (1-alph104)/Pibar*(s104(-1) - p) + (1-(1-alph104)/Pibar)*ps104;
s105  = (1-alph105)/Pibar*(s105(-1) - p) + (1-(1-alph105)/Pibar)*ps105;
s106  = (1-alph106)/Pibar*(s106(-1) - p) + (1-(1-alph106)/Pibar)*ps106;
s107  = (1-alph107)/Pibar*(s107(-1) - p) + (1-(1-alph107)/Pibar)*ps107;
s108  = (1-alph108)/Pibar*(s108(-1) - p) + (1-(1-alph108)/Pibar)*ps108;
s109  = (1-alph109)/Pibar*(s109(-1) - p) + (1-(1-alph109)/Pibar)*ps109;
s110  = (1-alph110)/Pibar*(s110(-1) - p) + (1-(1-alph110)/Pibar)*ps110;
s111  = (1-alph111)/Pibar*(s111(-1) - p) + (1-(1-alph111)/Pibar)*ps111;
s112  = (1-alph112)/Pibar*(s112(-1) - p) + (1-(1-alph112)/Pibar)*ps112;
s113  = (1-alph113)/Pibar*(s113(-1) - p) + (1-(1-alph113)/Pibar)*ps113;
s114  = (1-alph114)/Pibar*(s114(-1) - p) + (1-(1-alph114)/Pibar)*ps114;
s115  = (1-alph115)/Pibar*(s115(-1) - p) + (1-(1-alph115)/Pibar)*ps115;
s116  = (1-alph116)/Pibar*(s116(-1) - p) + (1-(1-alph116)/Pibar)*ps116;
s117  = (1-alph117)/Pibar*(s117(-1) - p) + (1-(1-alph117)/Pibar)*ps117;
s118  = (1-alph118)/Pibar*(s118(-1) - p) + (1-(1-alph118)/Pibar)*ps118;
s119  = (1-alph119)/Pibar*(s119(-1) - p) + (1-(1-alph119)/Pibar)*ps119;
s120  = (1-alph120)/Pibar*(s120(-1) - p) + (1-(1-alph120)/Pibar)*ps120;
s121  = (1-alph121)/Pibar*(s121(-1) - p) + (1-(1-alph121)/Pibar)*ps121;
s122  = (1-alph122)/Pibar*(s122(-1) - p) + (1-(1-alph122)/Pibar)*ps122;
s123  = (1-alph123)/Pibar*(s123(-1) - p) + (1-(1-alph123)/Pibar)*ps123;
s124  = (1-alph124)/Pibar*(s124(-1) - p) + (1-(1-alph124)/Pibar)*ps124;
s125  = (1-alph125)/Pibar*(s125(-1) - p) + (1-(1-alph125)/Pibar)*ps125;
s126  = (1-alph126)/Pibar*(s126(-1) - p) + (1-(1-alph126)/Pibar)*ps126;
s127  = (1-alph127)/Pibar*(s127(-1) - p) + (1-(1-alph127)/Pibar)*ps127;
s128  = (1-alph128)/Pibar*(s128(-1) - p) + (1-(1-alph128)/Pibar)*ps128;
s129  = (1-alph129)/Pibar*(s129(-1) - p) + (1-(1-alph129)/Pibar)*ps129;
s130  = (1-alph130)/Pibar*(s130(-1) - p) + (1-(1-alph130)/Pibar)*ps130;
s131  = (1-alph131)/Pibar*(s131(-1) - p) + (1-(1-alph131)/Pibar)*ps131;
s132  = (1-alph132)/Pibar*(s132(-1) - p) + (1-(1-alph132)/Pibar)*ps132;
s133  = (1-alph133)/Pibar*(s133(-1) - p) + (1-(1-alph133)/Pibar)*ps133;
s134  = (1-alph134)/Pibar*(s134(-1) - p) + (1-(1-alph134)/Pibar)*ps134;
s135  = (1-alph135)/Pibar*(s135(-1) - p) + (1-(1-alph135)/Pibar)*ps135;
s136  = (1-alph136)/Pibar*(s136(-1) - p) + (1-(1-alph136)/Pibar)*ps136;
s137  = (1-alph137)/Pibar*(s137(-1) - p) + (1-(1-alph137)/Pibar)*ps137;
s138  = (1-alph138)/Pibar*(s138(-1) - p) + (1-(1-alph138)/Pibar)*ps138;
s139  = (1-alph139)/Pibar*(s139(-1) - p) + (1-(1-alph139)/Pibar)*ps139;
s140  = (1-alph140)/Pibar*(s140(-1) - p) + (1-(1-alph140)/Pibar)*ps140;
s141  = (1-alph141)/Pibar*(s141(-1) - p) + (1-(1-alph141)/Pibar)*ps141;
s142  = (1-alph142)/Pibar*(s142(-1) - p) + (1-(1-alph142)/Pibar)*ps142;
s143  = (1-alph143)/Pibar*(s143(-1) - p) + (1-(1-alph143)/Pibar)*ps143;
s144  = (1-alph144)/Pibar*(s144(-1) - p) + (1-(1-alph144)/Pibar)*ps144;
s145  = (1-alph145)/Pibar*(s145(-1) - p) + (1-(1-alph145)/Pibar)*ps145;
s146  = (1-alph146)/Pibar*(s146(-1) - p) + (1-(1-alph146)/Pibar)*ps146;
s147  = (1-alph147)/Pibar*(s147(-1) - p) + (1-(1-alph147)/Pibar)*ps147;
s148  = (1-alph148)/Pibar*(s148(-1) - p) + (1-(1-alph148)/Pibar)*ps148;
s149  = (1-alph149)/Pibar*(s149(-1) - p) + (1-(1-alph149)/Pibar)*ps149;
s150  = (1-alph150)/Pibar*(s150(-1) - p) + (1-(1-alph150)/Pibar)*ps150;
s151  = (1-alph151)/Pibar*(s151(-1) - p) + (1-(1-alph151)/Pibar)*ps151;
s152  = (1-alph152)/Pibar*(s152(-1) - p) + (1-(1-alph152)/Pibar)*ps152;
s153  = (1-alph153)/Pibar*(s153(-1) - p) + (1-(1-alph153)/Pibar)*ps153;
s154  = (1-alph154)/Pibar*(s154(-1) - p) + (1-(1-alph154)/Pibar)*ps154;
s155  = (1-alph155)/Pibar*(s155(-1) - p) + (1-(1-alph155)/Pibar)*ps155;
s156  = (1-alph156)/Pibar*(s156(-1) - p) + (1-(1-alph156)/Pibar)*ps156;
s157  = (1-alph157)/Pibar*(s157(-1) - p) + (1-(1-alph157)/Pibar)*ps157;
s158  = (1-alph158)/Pibar*(s158(-1) - p) + (1-(1-alph158)/Pibar)*ps158;
s159  = (1-alph159)/Pibar*(s159(-1) - p) + (1-(1-alph159)/Pibar)*ps159;
s160  = (1-alph160)/Pibar*(s160(-1) - p) + (1-(1-alph160)/Pibar)*ps160;
s161  = (1-alph161)/Pibar*(s161(-1) - p) + (1-(1-alph161)/Pibar)*ps161;
s162  = (1-alph162)/Pibar*(s162(-1) - p) + (1-(1-alph162)/Pibar)*ps162;
s163  = (1-alph163)/Pibar*(s163(-1) - p) + (1-(1-alph163)/Pibar)*ps163;
s164  = (1-alph164)/Pibar*(s164(-1) - p) + (1-(1-alph164)/Pibar)*ps164;
s165  = (1-alph165)/Pibar*(s165(-1) - p) + (1-(1-alph165)/Pibar)*ps165;
s166  = (1-alph166)/Pibar*(s166(-1) - p) + (1-(1-alph166)/Pibar)*ps166;
s167  = (1-alph167)/Pibar*(s167(-1) - p) + (1-(1-alph167)/Pibar)*ps167;
s168  = (1-alph168)/Pibar*(s168(-1) - p) + (1-(1-alph168)/Pibar)*ps168;
s169  = (1-alph169)/Pibar*(s169(-1) - p) + (1-(1-alph169)/Pibar)*ps169;
s170  = (1-alph170)/Pibar*(s170(-1) - p) + (1-(1-alph170)/Pibar)*ps170;
s171  = (1-alph171)/Pibar*(s171(-1) - p) + (1-(1-alph171)/Pibar)*ps171;
s172  = (1-alph172)/Pibar*(s172(-1) - p) + (1-(1-alph172)/Pibar)*ps172;
s173  = (1-alph173)/Pibar*(s173(-1) - p) + (1-(1-alph173)/Pibar)*ps173;
s174  = (1-alph174)/Pibar*(s174(-1) - p) + (1-(1-alph174)/Pibar)*ps174;
s175  = (1-alph175)/Pibar*(s175(-1) - p) + (1-(1-alph175)/Pibar)*ps175;
s176  = (1-alph176)/Pibar*(s176(-1) - p) + (1-(1-alph176)/Pibar)*ps176;
s177  = (1-alph177)/Pibar*(s177(-1) - p) + (1-(1-alph177)/Pibar)*ps177;
s178  = (1-alph178)/Pibar*(s178(-1) - p) + (1-(1-alph178)/Pibar)*ps178;
s179  = (1-alph179)/Pibar*(s179(-1) - p) + (1-(1-alph179)/Pibar)*ps179;
s180  = (1-alph180)/Pibar*(s180(-1) - p) + (1-(1-alph180)/Pibar)*ps180;
s181  = (1-alph181)/Pibar*(s181(-1) - p) + (1-(1-alph181)/Pibar)*ps181;
s182  = (1-alph182)/Pibar*(s182(-1) - p) + (1-(1-alph182)/Pibar)*ps182;
s183  = (1-alph183)/Pibar*(s183(-1) - p) + (1-(1-alph183)/Pibar)*ps183;
s184  = (1-alph184)/Pibar*(s184(-1) - p) + (1-(1-alph184)/Pibar)*ps184;
s185  = (1-alph185)/Pibar*(s185(-1) - p) + (1-(1-alph185)/Pibar)*ps185;
s186  = (1-alph186)/Pibar*(s186(-1) - p) + (1-(1-alph186)/Pibar)*ps186;
s187  = (1-alph187)/Pibar*(s187(-1) - p) + (1-(1-alph187)/Pibar)*ps187;
s188  = (1-alph188)/Pibar*(s188(-1) - p) + (1-(1-alph188)/Pibar)*ps188;
s189  = (1-alph189)/Pibar*(s189(-1) - p) + (1-(1-alph189)/Pibar)*ps189;
s190  = (1-alph190)/Pibar*(s190(-1) - p) + (1-(1-alph190)/Pibar)*ps190;
s191  = (1-alph191)/Pibar*(s191(-1) - p) + (1-(1-alph191)/Pibar)*ps191;
s192  = (1-alph192)/Pibar*(s192(-1) - p) + (1-(1-alph192)/Pibar)*ps192;
s193  = (1-alph193)/Pibar*(s193(-1) - p) + (1-(1-alph193)/Pibar)*ps193;
s194  = (1-alph194)/Pibar*(s194(-1) - p) + (1-(1-alph194)/Pibar)*ps194;
s195  = (1-alph195)/Pibar*(s195(-1) - p) + (1-(1-alph195)/Pibar)*ps195;
s196  = (1-alph196)/Pibar*(s196(-1) - p) + (1-(1-alph196)/Pibar)*ps196;
s197  = (1-alph197)/Pibar*(s197(-1) - p) + (1-(1-alph197)/Pibar)*ps197;
s198  = (1-alph198)/Pibar*(s198(-1) - p) + (1-(1-alph198)/Pibar)*ps198;
s199  = (1-alph199)/Pibar*(s199(-1) - p) + (1-(1-alph199)/Pibar)*ps199;
s200  = (1-alph200)/Pibar*(s200(-1) - p) + (1-(1-alph200)/Pibar)*ps200;
s201  = (1-alph201)/Pibar*(s201(-1) - p) + (1-(1-alph201)/Pibar)*ps201;
s202  = (1-alph202)/Pibar*(s202(-1) - p) + (1-(1-alph202)/Pibar)*ps202;
s203  = (1-alph203)/Pibar*(s203(-1) - p) + (1-(1-alph203)/Pibar)*ps203;
s204  = (1-alph204)/Pibar*(s204(-1) - p) + (1-(1-alph204)/Pibar)*ps204;
s205  = (1-alph205)/Pibar*(s205(-1) - p) + (1-(1-alph205)/Pibar)*ps205;
s206  = (1-alph206)/Pibar*(s206(-1) - p) + (1-(1-alph206)/Pibar)*ps206;
s207  = (1-alph207)/Pibar*(s207(-1) - p) + (1-(1-alph207)/Pibar)*ps207;
s208  = (1-alph208)/Pibar*(s208(-1) - p) + (1-(1-alph208)/Pibar)*ps208;
s209  = (1-alph209)/Pibar*(s209(-1) - p) + (1-(1-alph209)/Pibar)*ps209;
s210  = (1-alph210)/Pibar*(s210(-1) - p) + (1-(1-alph210)/Pibar)*ps210;
s211  = (1-alph211)/Pibar*(s211(-1) - p) + (1-(1-alph211)/Pibar)*ps211;
s212  = (1-alph212)/Pibar*(s212(-1) - p) + (1-(1-alph212)/Pibar)*ps212;
s213  = (1-alph213)/Pibar*(s213(-1) - p) + (1-(1-alph213)/Pibar)*ps213;
s214  = (1-alph214)/Pibar*(s214(-1) - p) + (1-(1-alph214)/Pibar)*ps214;
s215  = (1-alph215)/Pibar*(s215(-1) - p) + (1-(1-alph215)/Pibar)*ps215;
s216  = (1-alph216)/Pibar*(s216(-1) - p) + (1-(1-alph216)/Pibar)*ps216;
s217  = (1-alph217)/Pibar*(s217(-1) - p) + (1-(1-alph217)/Pibar)*ps217;
s218  = (1-alph218)/Pibar*(s218(-1) - p) + (1-(1-alph218)/Pibar)*ps218;
s219  = (1-alph219)/Pibar*(s219(-1) - p) + (1-(1-alph219)/Pibar)*ps219;
s220  = (1-alph220)/Pibar*(s220(-1) - p) + (1-(1-alph220)/Pibar)*ps220;
s221  = (1-alph221)/Pibar*(s221(-1) - p) + (1-(1-alph221)/Pibar)*ps221;
s222  = (1-alph222)/Pibar*(s222(-1) - p) + (1-(1-alph222)/Pibar)*ps222;
s223  = (1-alph223)/Pibar*(s223(-1) - p) + (1-(1-alph223)/Pibar)*ps223;
s224  = (1-alph224)/Pibar*(s224(-1) - p) + (1-(1-alph224)/Pibar)*ps224;
s225  = (1-alph225)/Pibar*(s225(-1) - p) + (1-(1-alph225)/Pibar)*ps225;
s226  = (1-alph226)/Pibar*(s226(-1) - p) + (1-(1-alph226)/Pibar)*ps226;
s227  = (1-alph227)/Pibar*(s227(-1) - p) + (1-(1-alph227)/Pibar)*ps227;
s228  = (1-alph228)/Pibar*(s228(-1) - p) + (1-(1-alph228)/Pibar)*ps228;
s229  = (1-alph229)/Pibar*(s229(-1) - p) + (1-(1-alph229)/Pibar)*ps229;
s230  = (1-alph230)/Pibar*(s230(-1) - p) + (1-(1-alph230)/Pibar)*ps230;
s231  = (1-alph231)/Pibar*(s231(-1) - p) + (1-(1-alph231)/Pibar)*ps231;
s232  = (1-alph232)/Pibar*(s232(-1) - p) + (1-(1-alph232)/Pibar)*ps232;
s233  = (1-alph233)/Pibar*(s233(-1) - p) + (1-(1-alph233)/Pibar)*ps233;
s234  = (1-alph234)/Pibar*(s234(-1) - p) + (1-(1-alph234)/Pibar)*ps234;
s235  = (1-alph235)/Pibar*(s235(-1) - p) + (1-(1-alph235)/Pibar)*ps235;
s236  = (1-alph236)/Pibar*(s236(-1) - p) + (1-(1-alph236)/Pibar)*ps236;
s237  = (1-alph237)/Pibar*(s237(-1) - p) + (1-(1-alph237)/Pibar)*ps237;
s238  = (1-alph238)/Pibar*(s238(-1) - p) + (1-(1-alph238)/Pibar)*ps238;
s239  = (1-alph239)/Pibar*(s239(-1) - p) + (1-(1-alph239)/Pibar)*ps239;
s240  = (1-alph240)/Pibar*(s240(-1) - p) + (1-(1-alph240)/Pibar)*ps240;
s241  = (1-alph241)/Pibar*(s241(-1) - p) + (1-(1-alph241)/Pibar)*ps241;
s242  = (1-alph242)/Pibar*(s242(-1) - p) + (1-(1-alph242)/Pibar)*ps242;
s243  = (1-alph243)/Pibar*(s243(-1) - p) + (1-(1-alph243)/Pibar)*ps243;
s244  = (1-alph244)/Pibar*(s244(-1) - p) + (1-(1-alph244)/Pibar)*ps244;
s245  = (1-alph245)/Pibar*(s245(-1) - p) + (1-(1-alph245)/Pibar)*ps245;
s246  = (1-alph246)/Pibar*(s246(-1) - p) + (1-(1-alph246)/Pibar)*ps246;
s247  = (1-alph247)/Pibar*(s247(-1) - p) + (1-(1-alph247)/Pibar)*ps247;
s248  = (1-alph248)/Pibar*(s248(-1) - p) + (1-(1-alph248)/Pibar)*ps248;
s249  = (1-alph249)/Pibar*(s249(-1) - p) + (1-(1-alph249)/Pibar)*ps249;
s250  = (1-alph250)/Pibar*(s250(-1) - p) + (1-(1-alph250)/Pibar)*ps250;
s251  = (1-alph251)/Pibar*(s251(-1) - p) + (1-(1-alph251)/Pibar)*ps251;
s252  = (1-alph252)/Pibar*(s252(-1) - p) + (1-(1-alph252)/Pibar)*ps252;
s253  = (1-alph253)/Pibar*(s253(-1) - p) + (1-(1-alph253)/Pibar)*ps253;
s254  = (1-alph254)/Pibar*(s254(-1) - p) + (1-(1-alph254)/Pibar)*ps254;
s255  = (1-alph255)/Pibar*(s255(-1) - p) + (1-(1-alph255)/Pibar)*ps255;
s256  = (1-alph256)/Pibar*(s256(-1) - p) + (1-(1-alph256)/Pibar)*ps256;
s257  = (1-alph257)/Pibar*(s257(-1) - p) + (1-(1-alph257)/Pibar)*ps257;
s258  = (1-alph258)/Pibar*(s258(-1) - p) + (1-(1-alph258)/Pibar)*ps258;
s259  = (1-alph259)/Pibar*(s259(-1) - p) + (1-(1-alph259)/Pibar)*ps259;
s260  = (1-alph260)/Pibar*(s260(-1) - p) + (1-(1-alph260)/Pibar)*ps260;
s261  = (1-alph261)/Pibar*(s261(-1) - p) + (1-(1-alph261)/Pibar)*ps261;
s262  = (1-alph262)/Pibar*(s262(-1) - p) + (1-(1-alph262)/Pibar)*ps262;
s263  = (1-alph263)/Pibar*(s263(-1) - p) + (1-(1-alph263)/Pibar)*ps263;
s264  = (1-alph264)/Pibar*(s264(-1) - p) + (1-(1-alph264)/Pibar)*ps264;
s265  = (1-alph265)/Pibar*(s265(-1) - p) + (1-(1-alph265)/Pibar)*ps265;
s266  = (1-alph266)/Pibar*(s266(-1) - p) + (1-(1-alph266)/Pibar)*ps266;
s267  = (1-alph267)/Pibar*(s267(-1) - p) + (1-(1-alph267)/Pibar)*ps267;
s268  = (1-alph268)/Pibar*(s268(-1) - p) + (1-(1-alph268)/Pibar)*ps268;
s269  = (1-alph269)/Pibar*(s269(-1) - p) + (1-(1-alph269)/Pibar)*ps269;
s270  = (1-alph270)/Pibar*(s270(-1) - p) + (1-(1-alph270)/Pibar)*ps270;
s271  = (1-alph271)/Pibar*(s271(-1) - p) + (1-(1-alph271)/Pibar)*ps271;
s272  = (1-alph272)/Pibar*(s272(-1) - p) + (1-(1-alph272)/Pibar)*ps272;

% z1, z2, z3, z4's

z1001 = (1-bet*(1-alph001)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph001)*Pibar^(theta*(1-ppsi)-1)*(z1001(+1)+(theta*(1-ppsi)-1)*p(+1));
z2001 = (1-bet*(1-alph001)/Pibar)*(1-sigm)*y + bet*(1-alph001)/Pibar*(z2001(+1) - p(+1));
z3001 = (1-bet*(1-alph001)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph001)*Pibar^(2*theta*(1-ppsi))*(z3001(+1) + 2*theta*(1-ppsi)*p(+1));
z4001 = (1-bet*(1-alph001)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph001)*Pibar^(theta*(1-ppsi))*(z4001(+1) + theta*(1-ppsi)*p(+1));

z1002 = (1-bet*(1-alph002)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph002)*Pibar^(theta*(1-ppsi)-1)*(z1002(+1)+(theta*(1-ppsi)-1)*p(+1));
z2002 = (1-bet*(1-alph002)/Pibar)*(1-sigm)*y + bet*(1-alph002)/Pibar*(z2002(+1) - p(+1));
z3002 = (1-bet*(1-alph002)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph002)*Pibar^(2*theta*(1-ppsi))*(z3002(+1) + 2*theta*(1-ppsi)*p(+1));
z4002 = (1-bet*(1-alph002)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph002)*Pibar^(theta*(1-ppsi))*(z4002(+1) + theta*(1-ppsi)*p(+1));

z1003 = (1-bet*(1-alph003)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph003)*Pibar^(theta*(1-ppsi)-1)*(z1003(+1)+(theta*(1-ppsi)-1)*p(+1));
z2003 = (1-bet*(1-alph003)/Pibar)*(1-sigm)*y + bet*(1-alph003)/Pibar*(z2003(+1) - p(+1));
z3003 = (1-bet*(1-alph003)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph003)*Pibar^(2*theta*(1-ppsi))*(z3003(+1) + 2*theta*(1-ppsi)*p(+1));
z4003 = (1-bet*(1-alph003)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph003)*Pibar^(theta*(1-ppsi))*(z4003(+1) + theta*(1-ppsi)*p(+1));

z1004 = (1-bet*(1-alph004)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph004)*Pibar^(theta*(1-ppsi)-1)*(z1004(+1)+(theta*(1-ppsi)-1)*p(+1));
z2004 = (1-bet*(1-alph004)/Pibar)*(1-sigm)*y + bet*(1-alph004)/Pibar*(z2004(+1) - p(+1));
z3004 = (1-bet*(1-alph004)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph004)*Pibar^(2*theta*(1-ppsi))*(z3004(+1) + 2*theta*(1-ppsi)*p(+1));
z4004 = (1-bet*(1-alph004)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph004)*Pibar^(theta*(1-ppsi))*(z4004(+1) + theta*(1-ppsi)*p(+1));

z1005 = (1-bet*(1-alph005)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph005)*Pibar^(theta*(1-ppsi)-1)*(z1005(+1)+(theta*(1-ppsi)-1)*p(+1));
z2005 = (1-bet*(1-alph005)/Pibar)*(1-sigm)*y + bet*(1-alph005)/Pibar*(z2005(+1) - p(+1));
z3005 = (1-bet*(1-alph005)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph005)*Pibar^(2*theta*(1-ppsi))*(z3005(+1) + 2*theta*(1-ppsi)*p(+1));
z4005 = (1-bet*(1-alph005)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph005)*Pibar^(theta*(1-ppsi))*(z4005(+1) + theta*(1-ppsi)*p(+1));

z1006 = (1-bet*(1-alph006)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph006)*Pibar^(theta*(1-ppsi)-1)*(z1006(+1)+(theta*(1-ppsi)-1)*p(+1));
z2006 = (1-bet*(1-alph006)/Pibar)*(1-sigm)*y + bet*(1-alph006)/Pibar*(z2006(+1) - p(+1));
z3006 = (1-bet*(1-alph006)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph006)*Pibar^(2*theta*(1-ppsi))*(z3006(+1) + 2*theta*(1-ppsi)*p(+1));
z4006 = (1-bet*(1-alph006)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph006)*Pibar^(theta*(1-ppsi))*(z4006(+1) + theta*(1-ppsi)*p(+1));

z1007 = (1-bet*(1-alph007)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph007)*Pibar^(theta*(1-ppsi)-1)*(z1007(+1)+(theta*(1-ppsi)-1)*p(+1));
z2007 = (1-bet*(1-alph007)/Pibar)*(1-sigm)*y + bet*(1-alph007)/Pibar*(z2007(+1) - p(+1));
z3007 = (1-bet*(1-alph007)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph007)*Pibar^(2*theta*(1-ppsi))*(z3007(+1) + 2*theta*(1-ppsi)*p(+1));
z4007 = (1-bet*(1-alph007)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph007)*Pibar^(theta*(1-ppsi))*(z4007(+1) + theta*(1-ppsi)*p(+1));

z1008 = (1-bet*(1-alph008)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph008)*Pibar^(theta*(1-ppsi)-1)*(z1008(+1)+(theta*(1-ppsi)-1)*p(+1));
z2008 = (1-bet*(1-alph008)/Pibar)*(1-sigm)*y + bet*(1-alph008)/Pibar*(z2008(+1) - p(+1));
z3008 = (1-bet*(1-alph008)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph008)*Pibar^(2*theta*(1-ppsi))*(z3008(+1) + 2*theta*(1-ppsi)*p(+1));
z4008 = (1-bet*(1-alph008)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph008)*Pibar^(theta*(1-ppsi))*(z4008(+1) + theta*(1-ppsi)*p(+1));

z1009 = (1-bet*(1-alph009)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph009)*Pibar^(theta*(1-ppsi)-1)*(z1009(+1)+(theta*(1-ppsi)-1)*p(+1));
z2009 = (1-bet*(1-alph009)/Pibar)*(1-sigm)*y + bet*(1-alph009)/Pibar*(z2009(+1) - p(+1));
z3009 = (1-bet*(1-alph009)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph009)*Pibar^(2*theta*(1-ppsi))*(z3009(+1) + 2*theta*(1-ppsi)*p(+1));
z4009 = (1-bet*(1-alph009)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph009)*Pibar^(theta*(1-ppsi))*(z4009(+1) + theta*(1-ppsi)*p(+1));

z1010 = (1-bet*(1-alph010)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph010)*Pibar^(theta*(1-ppsi)-1)*(z1010(+1)+(theta*(1-ppsi)-1)*p(+1));
z2010 = (1-bet*(1-alph010)/Pibar)*(1-sigm)*y + bet*(1-alph010)/Pibar*(z2010(+1) - p(+1));
z3010 = (1-bet*(1-alph010)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph010)*Pibar^(2*theta*(1-ppsi))*(z3010(+1) + 2*theta*(1-ppsi)*p(+1));
z4010 = (1-bet*(1-alph010)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph010)*Pibar^(theta*(1-ppsi))*(z4010(+1) + theta*(1-ppsi)*p(+1));

z1011 = (1-bet*(1-alph011)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph011)*Pibar^(theta*(1-ppsi)-1)*(z1011(+1)+(theta*(1-ppsi)-1)*p(+1));
z2011 = (1-bet*(1-alph011)/Pibar)*(1-sigm)*y + bet*(1-alph011)/Pibar*(z2011(+1) - p(+1));
z3011 = (1-bet*(1-alph011)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph011)*Pibar^(2*theta*(1-ppsi))*(z3011(+1) + 2*theta*(1-ppsi)*p(+1));
z4011 = (1-bet*(1-alph011)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph011)*Pibar^(theta*(1-ppsi))*(z4011(+1) + theta*(1-ppsi)*p(+1));

z1012 = (1-bet*(1-alph012)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph012)*Pibar^(theta*(1-ppsi)-1)*(z1012(+1)+(theta*(1-ppsi)-1)*p(+1));
z2012 = (1-bet*(1-alph012)/Pibar)*(1-sigm)*y + bet*(1-alph012)/Pibar*(z2012(+1) - p(+1));
z3012 = (1-bet*(1-alph012)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph012)*Pibar^(2*theta*(1-ppsi))*(z3012(+1) + 2*theta*(1-ppsi)*p(+1));
z4012 = (1-bet*(1-alph012)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph012)*Pibar^(theta*(1-ppsi))*(z4012(+1) + theta*(1-ppsi)*p(+1));

z1013 = (1-bet*(1-alph013)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph013)*Pibar^(theta*(1-ppsi)-1)*(z1013(+1)+(theta*(1-ppsi)-1)*p(+1));
z2013 = (1-bet*(1-alph013)/Pibar)*(1-sigm)*y + bet*(1-alph013)/Pibar*(z2013(+1) - p(+1));
z3013 = (1-bet*(1-alph013)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph013)*Pibar^(2*theta*(1-ppsi))*(z3013(+1) + 2*theta*(1-ppsi)*p(+1));
z4013 = (1-bet*(1-alph013)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph013)*Pibar^(theta*(1-ppsi))*(z4013(+1) + theta*(1-ppsi)*p(+1));

z1014 = (1-bet*(1-alph014)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph014)*Pibar^(theta*(1-ppsi)-1)*(z1014(+1)+(theta*(1-ppsi)-1)*p(+1));
z2014 = (1-bet*(1-alph014)/Pibar)*(1-sigm)*y + bet*(1-alph014)/Pibar*(z2014(+1) - p(+1));
z3014 = (1-bet*(1-alph014)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph014)*Pibar^(2*theta*(1-ppsi))*(z3014(+1) + 2*theta*(1-ppsi)*p(+1));
z4014 = (1-bet*(1-alph014)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph014)*Pibar^(theta*(1-ppsi))*(z4014(+1) + theta*(1-ppsi)*p(+1));

z1015 = (1-bet*(1-alph015)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph015)*Pibar^(theta*(1-ppsi)-1)*(z1015(+1)+(theta*(1-ppsi)-1)*p(+1));
z2015 = (1-bet*(1-alph015)/Pibar)*(1-sigm)*y + bet*(1-alph015)/Pibar*(z2015(+1) - p(+1));
z3015 = (1-bet*(1-alph015)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph015)*Pibar^(2*theta*(1-ppsi))*(z3015(+1) + 2*theta*(1-ppsi)*p(+1));
z4015 = (1-bet*(1-alph015)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph015)*Pibar^(theta*(1-ppsi))*(z4015(+1) + theta*(1-ppsi)*p(+1));

z1016 = (1-bet*(1-alph016)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph016)*Pibar^(theta*(1-ppsi)-1)*(z1016(+1)+(theta*(1-ppsi)-1)*p(+1));
z2016 = (1-bet*(1-alph016)/Pibar)*(1-sigm)*y + bet*(1-alph016)/Pibar*(z2016(+1) - p(+1));
z3016 = (1-bet*(1-alph016)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph016)*Pibar^(2*theta*(1-ppsi))*(z3016(+1) + 2*theta*(1-ppsi)*p(+1));
z4016 = (1-bet*(1-alph016)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph016)*Pibar^(theta*(1-ppsi))*(z4016(+1) + theta*(1-ppsi)*p(+1));

z1017 = (1-bet*(1-alph017)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph017)*Pibar^(theta*(1-ppsi)-1)*(z1017(+1)+(theta*(1-ppsi)-1)*p(+1));
z2017 = (1-bet*(1-alph017)/Pibar)*(1-sigm)*y + bet*(1-alph017)/Pibar*(z2017(+1) - p(+1));
z3017 = (1-bet*(1-alph017)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph017)*Pibar^(2*theta*(1-ppsi))*(z3017(+1) + 2*theta*(1-ppsi)*p(+1));
z4017 = (1-bet*(1-alph017)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph017)*Pibar^(theta*(1-ppsi))*(z4017(+1) + theta*(1-ppsi)*p(+1));

z1018 = (1-bet*(1-alph018)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph018)*Pibar^(theta*(1-ppsi)-1)*(z1018(+1)+(theta*(1-ppsi)-1)*p(+1));
z2018 = (1-bet*(1-alph018)/Pibar)*(1-sigm)*y + bet*(1-alph018)/Pibar*(z2018(+1) - p(+1));
z3018 = (1-bet*(1-alph018)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph018)*Pibar^(2*theta*(1-ppsi))*(z3018(+1) + 2*theta*(1-ppsi)*p(+1));
z4018 = (1-bet*(1-alph018)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph018)*Pibar^(theta*(1-ppsi))*(z4018(+1) + theta*(1-ppsi)*p(+1));

z1019 = (1-bet*(1-alph019)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph019)*Pibar^(theta*(1-ppsi)-1)*(z1019(+1)+(theta*(1-ppsi)-1)*p(+1));
z2019 = (1-bet*(1-alph019)/Pibar)*(1-sigm)*y + bet*(1-alph019)/Pibar*(z2019(+1) - p(+1));
z3019 = (1-bet*(1-alph019)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph019)*Pibar^(2*theta*(1-ppsi))*(z3019(+1) + 2*theta*(1-ppsi)*p(+1));
z4019 = (1-bet*(1-alph019)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph019)*Pibar^(theta*(1-ppsi))*(z4019(+1) + theta*(1-ppsi)*p(+1));

z1020 = (1-bet*(1-alph020)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph020)*Pibar^(theta*(1-ppsi)-1)*(z1020(+1)+(theta*(1-ppsi)-1)*p(+1));
z2020 = (1-bet*(1-alph020)/Pibar)*(1-sigm)*y + bet*(1-alph020)/Pibar*(z2020(+1) - p(+1));
z3020 = (1-bet*(1-alph020)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph020)*Pibar^(2*theta*(1-ppsi))*(z3020(+1) + 2*theta*(1-ppsi)*p(+1));
z4020 = (1-bet*(1-alph020)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph020)*Pibar^(theta*(1-ppsi))*(z4020(+1) + theta*(1-ppsi)*p(+1));

z1021 = (1-bet*(1-alph021)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph021)*Pibar^(theta*(1-ppsi)-1)*(z1021(+1)+(theta*(1-ppsi)-1)*p(+1));
z2021 = (1-bet*(1-alph021)/Pibar)*(1-sigm)*y + bet*(1-alph021)/Pibar*(z2021(+1) - p(+1));
z3021 = (1-bet*(1-alph021)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph021)*Pibar^(2*theta*(1-ppsi))*(z3021(+1) + 2*theta*(1-ppsi)*p(+1));
z4021 = (1-bet*(1-alph021)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph021)*Pibar^(theta*(1-ppsi))*(z4021(+1) + theta*(1-ppsi)*p(+1));

z1022 = (1-bet*(1-alph022)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph022)*Pibar^(theta*(1-ppsi)-1)*(z1022(+1)+(theta*(1-ppsi)-1)*p(+1));
z2022 = (1-bet*(1-alph022)/Pibar)*(1-sigm)*y + bet*(1-alph022)/Pibar*(z2022(+1) - p(+1));
z3022 = (1-bet*(1-alph022)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph022)*Pibar^(2*theta*(1-ppsi))*(z3022(+1) + 2*theta*(1-ppsi)*p(+1));
z4022 = (1-bet*(1-alph022)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph022)*Pibar^(theta*(1-ppsi))*(z4022(+1) + theta*(1-ppsi)*p(+1));

z1023 = (1-bet*(1-alph023)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph023)*Pibar^(theta*(1-ppsi)-1)*(z1023(+1)+(theta*(1-ppsi)-1)*p(+1));
z2023 = (1-bet*(1-alph023)/Pibar)*(1-sigm)*y + bet*(1-alph023)/Pibar*(z2023(+1) - p(+1));
z3023 = (1-bet*(1-alph023)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph023)*Pibar^(2*theta*(1-ppsi))*(z3023(+1) + 2*theta*(1-ppsi)*p(+1));
z4023 = (1-bet*(1-alph023)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph023)*Pibar^(theta*(1-ppsi))*(z4023(+1) + theta*(1-ppsi)*p(+1));

z1024 = (1-bet*(1-alph024)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph024)*Pibar^(theta*(1-ppsi)-1)*(z1024(+1)+(theta*(1-ppsi)-1)*p(+1));
z2024 = (1-bet*(1-alph024)/Pibar)*(1-sigm)*y + bet*(1-alph024)/Pibar*(z2024(+1) - p(+1));
z3024 = (1-bet*(1-alph024)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph024)*Pibar^(2*theta*(1-ppsi))*(z3024(+1) + 2*theta*(1-ppsi)*p(+1));
z4024 = (1-bet*(1-alph024)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph024)*Pibar^(theta*(1-ppsi))*(z4024(+1) + theta*(1-ppsi)*p(+1));

z1025 = (1-bet*(1-alph025)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph025)*Pibar^(theta*(1-ppsi)-1)*(z1025(+1)+(theta*(1-ppsi)-1)*p(+1));
z2025 = (1-bet*(1-alph025)/Pibar)*(1-sigm)*y + bet*(1-alph025)/Pibar*(z2025(+1) - p(+1));
z3025 = (1-bet*(1-alph025)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph025)*Pibar^(2*theta*(1-ppsi))*(z3025(+1) + 2*theta*(1-ppsi)*p(+1));
z4025 = (1-bet*(1-alph025)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph025)*Pibar^(theta*(1-ppsi))*(z4025(+1) + theta*(1-ppsi)*p(+1));

z1026 = (1-bet*(1-alph026)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph026)*Pibar^(theta*(1-ppsi)-1)*(z1026(+1)+(theta*(1-ppsi)-1)*p(+1));
z2026 = (1-bet*(1-alph026)/Pibar)*(1-sigm)*y + bet*(1-alph026)/Pibar*(z2026(+1) - p(+1));
z3026 = (1-bet*(1-alph026)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph026)*Pibar^(2*theta*(1-ppsi))*(z3026(+1) + 2*theta*(1-ppsi)*p(+1));
z4026 = (1-bet*(1-alph026)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph026)*Pibar^(theta*(1-ppsi))*(z4026(+1) + theta*(1-ppsi)*p(+1));

z1027 = (1-bet*(1-alph027)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph027)*Pibar^(theta*(1-ppsi)-1)*(z1027(+1)+(theta*(1-ppsi)-1)*p(+1));
z2027 = (1-bet*(1-alph027)/Pibar)*(1-sigm)*y + bet*(1-alph027)/Pibar*(z2027(+1) - p(+1));
z3027 = (1-bet*(1-alph027)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph027)*Pibar^(2*theta*(1-ppsi))*(z3027(+1) + 2*theta*(1-ppsi)*p(+1));
z4027 = (1-bet*(1-alph027)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph027)*Pibar^(theta*(1-ppsi))*(z4027(+1) + theta*(1-ppsi)*p(+1));

z1028 = (1-bet*(1-alph028)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph028)*Pibar^(theta*(1-ppsi)-1)*(z1028(+1)+(theta*(1-ppsi)-1)*p(+1));
z2028 = (1-bet*(1-alph028)/Pibar)*(1-sigm)*y + bet*(1-alph028)/Pibar*(z2028(+1) - p(+1));
z3028 = (1-bet*(1-alph028)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph028)*Pibar^(2*theta*(1-ppsi))*(z3028(+1) + 2*theta*(1-ppsi)*p(+1));
z4028 = (1-bet*(1-alph028)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph028)*Pibar^(theta*(1-ppsi))*(z4028(+1) + theta*(1-ppsi)*p(+1));

z1029 = (1-bet*(1-alph029)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph029)*Pibar^(theta*(1-ppsi)-1)*(z1029(+1)+(theta*(1-ppsi)-1)*p(+1));
z2029 = (1-bet*(1-alph029)/Pibar)*(1-sigm)*y + bet*(1-alph029)/Pibar*(z2029(+1) - p(+1));
z3029 = (1-bet*(1-alph029)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph029)*Pibar^(2*theta*(1-ppsi))*(z3029(+1) + 2*theta*(1-ppsi)*p(+1));
z4029 = (1-bet*(1-alph029)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph029)*Pibar^(theta*(1-ppsi))*(z4029(+1) + theta*(1-ppsi)*p(+1));

z1030 = (1-bet*(1-alph030)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph030)*Pibar^(theta*(1-ppsi)-1)*(z1030(+1)+(theta*(1-ppsi)-1)*p(+1));
z2030 = (1-bet*(1-alph030)/Pibar)*(1-sigm)*y + bet*(1-alph030)/Pibar*(z2030(+1) - p(+1));
z3030 = (1-bet*(1-alph030)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph030)*Pibar^(2*theta*(1-ppsi))*(z3030(+1) + 2*theta*(1-ppsi)*p(+1));
z4030 = (1-bet*(1-alph030)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph030)*Pibar^(theta*(1-ppsi))*(z4030(+1) + theta*(1-ppsi)*p(+1));

z1031 = (1-bet*(1-alph031)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph031)*Pibar^(theta*(1-ppsi)-1)*(z1031(+1)+(theta*(1-ppsi)-1)*p(+1));
z2031 = (1-bet*(1-alph031)/Pibar)*(1-sigm)*y + bet*(1-alph031)/Pibar*(z2031(+1) - p(+1));
z3031 = (1-bet*(1-alph031)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph031)*Pibar^(2*theta*(1-ppsi))*(z3031(+1) + 2*theta*(1-ppsi)*p(+1));
z4031 = (1-bet*(1-alph031)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph031)*Pibar^(theta*(1-ppsi))*(z4031(+1) + theta*(1-ppsi)*p(+1));

z1032 = (1-bet*(1-alph032)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph032)*Pibar^(theta*(1-ppsi)-1)*(z1032(+1)+(theta*(1-ppsi)-1)*p(+1));
z2032 = (1-bet*(1-alph032)/Pibar)*(1-sigm)*y + bet*(1-alph032)/Pibar*(z2032(+1) - p(+1));
z3032 = (1-bet*(1-alph032)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph032)*Pibar^(2*theta*(1-ppsi))*(z3032(+1) + 2*theta*(1-ppsi)*p(+1));
z4032 = (1-bet*(1-alph032)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph032)*Pibar^(theta*(1-ppsi))*(z4032(+1) + theta*(1-ppsi)*p(+1));

z1033 = (1-bet*(1-alph033)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph033)*Pibar^(theta*(1-ppsi)-1)*(z1033(+1)+(theta*(1-ppsi)-1)*p(+1));
z2033 = (1-bet*(1-alph033)/Pibar)*(1-sigm)*y + bet*(1-alph033)/Pibar*(z2033(+1) - p(+1));
z3033 = (1-bet*(1-alph033)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph033)*Pibar^(2*theta*(1-ppsi))*(z3033(+1) + 2*theta*(1-ppsi)*p(+1));
z4033 = (1-bet*(1-alph033)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph033)*Pibar^(theta*(1-ppsi))*(z4033(+1) + theta*(1-ppsi)*p(+1));

z1034 = (1-bet*(1-alph034)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph034)*Pibar^(theta*(1-ppsi)-1)*(z1034(+1)+(theta*(1-ppsi)-1)*p(+1));
z2034 = (1-bet*(1-alph034)/Pibar)*(1-sigm)*y + bet*(1-alph034)/Pibar*(z2034(+1) - p(+1));
z3034 = (1-bet*(1-alph034)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph034)*Pibar^(2*theta*(1-ppsi))*(z3034(+1) + 2*theta*(1-ppsi)*p(+1));
z4034 = (1-bet*(1-alph034)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph034)*Pibar^(theta*(1-ppsi))*(z4034(+1) + theta*(1-ppsi)*p(+1));

z1035 = (1-bet*(1-alph035)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph035)*Pibar^(theta*(1-ppsi)-1)*(z1035(+1)+(theta*(1-ppsi)-1)*p(+1));
z2035 = (1-bet*(1-alph035)/Pibar)*(1-sigm)*y + bet*(1-alph035)/Pibar*(z2035(+1) - p(+1));
z3035 = (1-bet*(1-alph035)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph035)*Pibar^(2*theta*(1-ppsi))*(z3035(+1) + 2*theta*(1-ppsi)*p(+1));
z4035 = (1-bet*(1-alph035)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph035)*Pibar^(theta*(1-ppsi))*(z4035(+1) + theta*(1-ppsi)*p(+1));

z1036 = (1-bet*(1-alph036)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph036)*Pibar^(theta*(1-ppsi)-1)*(z1036(+1)+(theta*(1-ppsi)-1)*p(+1));
z2036 = (1-bet*(1-alph036)/Pibar)*(1-sigm)*y + bet*(1-alph036)/Pibar*(z2036(+1) - p(+1));
z3036 = (1-bet*(1-alph036)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph036)*Pibar^(2*theta*(1-ppsi))*(z3036(+1) + 2*theta*(1-ppsi)*p(+1));
z4036 = (1-bet*(1-alph036)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph036)*Pibar^(theta*(1-ppsi))*(z4036(+1) + theta*(1-ppsi)*p(+1));

z1037 = (1-bet*(1-alph037)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph037)*Pibar^(theta*(1-ppsi)-1)*(z1037(+1)+(theta*(1-ppsi)-1)*p(+1));
z2037 = (1-bet*(1-alph037)/Pibar)*(1-sigm)*y + bet*(1-alph037)/Pibar*(z2037(+1) - p(+1));
z3037 = (1-bet*(1-alph037)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph037)*Pibar^(2*theta*(1-ppsi))*(z3037(+1) + 2*theta*(1-ppsi)*p(+1));
z4037 = (1-bet*(1-alph037)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph037)*Pibar^(theta*(1-ppsi))*(z4037(+1) + theta*(1-ppsi)*p(+1));

z1038 = (1-bet*(1-alph038)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph038)*Pibar^(theta*(1-ppsi)-1)*(z1038(+1)+(theta*(1-ppsi)-1)*p(+1));
z2038 = (1-bet*(1-alph038)/Pibar)*(1-sigm)*y + bet*(1-alph038)/Pibar*(z2038(+1) - p(+1));
z3038 = (1-bet*(1-alph038)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph038)*Pibar^(2*theta*(1-ppsi))*(z3038(+1) + 2*theta*(1-ppsi)*p(+1));
z4038 = (1-bet*(1-alph038)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph038)*Pibar^(theta*(1-ppsi))*(z4038(+1) + theta*(1-ppsi)*p(+1));

z1039 = (1-bet*(1-alph039)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph039)*Pibar^(theta*(1-ppsi)-1)*(z1039(+1)+(theta*(1-ppsi)-1)*p(+1));
z2039 = (1-bet*(1-alph039)/Pibar)*(1-sigm)*y + bet*(1-alph039)/Pibar*(z2039(+1) - p(+1));
z3039 = (1-bet*(1-alph039)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph039)*Pibar^(2*theta*(1-ppsi))*(z3039(+1) + 2*theta*(1-ppsi)*p(+1));
z4039 = (1-bet*(1-alph039)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph039)*Pibar^(theta*(1-ppsi))*(z4039(+1) + theta*(1-ppsi)*p(+1));

z1040 = (1-bet*(1-alph040)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph040)*Pibar^(theta*(1-ppsi)-1)*(z1040(+1)+(theta*(1-ppsi)-1)*p(+1));
z2040 = (1-bet*(1-alph040)/Pibar)*(1-sigm)*y + bet*(1-alph040)/Pibar*(z2040(+1) - p(+1));
z3040 = (1-bet*(1-alph040)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph040)*Pibar^(2*theta*(1-ppsi))*(z3040(+1) + 2*theta*(1-ppsi)*p(+1));
z4040 = (1-bet*(1-alph040)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph040)*Pibar^(theta*(1-ppsi))*(z4040(+1) + theta*(1-ppsi)*p(+1));

z1041 = (1-bet*(1-alph041)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph041)*Pibar^(theta*(1-ppsi)-1)*(z1041(+1)+(theta*(1-ppsi)-1)*p(+1));
z2041 = (1-bet*(1-alph041)/Pibar)*(1-sigm)*y + bet*(1-alph041)/Pibar*(z2041(+1) - p(+1));
z3041 = (1-bet*(1-alph041)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph041)*Pibar^(2*theta*(1-ppsi))*(z3041(+1) + 2*theta*(1-ppsi)*p(+1));
z4041 = (1-bet*(1-alph041)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph041)*Pibar^(theta*(1-ppsi))*(z4041(+1) + theta*(1-ppsi)*p(+1));

z1042 = (1-bet*(1-alph042)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph042)*Pibar^(theta*(1-ppsi)-1)*(z1042(+1)+(theta*(1-ppsi)-1)*p(+1));
z2042 = (1-bet*(1-alph042)/Pibar)*(1-sigm)*y + bet*(1-alph042)/Pibar*(z2042(+1) - p(+1));
z3042 = (1-bet*(1-alph042)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph042)*Pibar^(2*theta*(1-ppsi))*(z3042(+1) + 2*theta*(1-ppsi)*p(+1));
z4042 = (1-bet*(1-alph042)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph042)*Pibar^(theta*(1-ppsi))*(z4042(+1) + theta*(1-ppsi)*p(+1));

z1043 = (1-bet*(1-alph043)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph043)*Pibar^(theta*(1-ppsi)-1)*(z1043(+1)+(theta*(1-ppsi)-1)*p(+1));
z2043 = (1-bet*(1-alph043)/Pibar)*(1-sigm)*y + bet*(1-alph043)/Pibar*(z2043(+1) - p(+1));
z3043 = (1-bet*(1-alph043)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph043)*Pibar^(2*theta*(1-ppsi))*(z3043(+1) + 2*theta*(1-ppsi)*p(+1));
z4043 = (1-bet*(1-alph043)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph043)*Pibar^(theta*(1-ppsi))*(z4043(+1) + theta*(1-ppsi)*p(+1));

z1044 = (1-bet*(1-alph044)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph044)*Pibar^(theta*(1-ppsi)-1)*(z1044(+1)+(theta*(1-ppsi)-1)*p(+1));
z2044 = (1-bet*(1-alph044)/Pibar)*(1-sigm)*y + bet*(1-alph044)/Pibar*(z2044(+1) - p(+1));
z3044 = (1-bet*(1-alph044)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph044)*Pibar^(2*theta*(1-ppsi))*(z3044(+1) + 2*theta*(1-ppsi)*p(+1));
z4044 = (1-bet*(1-alph044)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph044)*Pibar^(theta*(1-ppsi))*(z4044(+1) + theta*(1-ppsi)*p(+1));

z1045 = (1-bet*(1-alph045)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph045)*Pibar^(theta*(1-ppsi)-1)*(z1045(+1)+(theta*(1-ppsi)-1)*p(+1));
z2045 = (1-bet*(1-alph045)/Pibar)*(1-sigm)*y + bet*(1-alph045)/Pibar*(z2045(+1) - p(+1));
z3045 = (1-bet*(1-alph045)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph045)*Pibar^(2*theta*(1-ppsi))*(z3045(+1) + 2*theta*(1-ppsi)*p(+1));
z4045 = (1-bet*(1-alph045)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph045)*Pibar^(theta*(1-ppsi))*(z4045(+1) + theta*(1-ppsi)*p(+1));

z1046 = (1-bet*(1-alph046)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph046)*Pibar^(theta*(1-ppsi)-1)*(z1046(+1)+(theta*(1-ppsi)-1)*p(+1));
z2046 = (1-bet*(1-alph046)/Pibar)*(1-sigm)*y + bet*(1-alph046)/Pibar*(z2046(+1) - p(+1));
z3046 = (1-bet*(1-alph046)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph046)*Pibar^(2*theta*(1-ppsi))*(z3046(+1) + 2*theta*(1-ppsi)*p(+1));
z4046 = (1-bet*(1-alph046)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph046)*Pibar^(theta*(1-ppsi))*(z4046(+1) + theta*(1-ppsi)*p(+1));

z1047 = (1-bet*(1-alph047)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph047)*Pibar^(theta*(1-ppsi)-1)*(z1047(+1)+(theta*(1-ppsi)-1)*p(+1));
z2047 = (1-bet*(1-alph047)/Pibar)*(1-sigm)*y + bet*(1-alph047)/Pibar*(z2047(+1) - p(+1));
z3047 = (1-bet*(1-alph047)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph047)*Pibar^(2*theta*(1-ppsi))*(z3047(+1) + 2*theta*(1-ppsi)*p(+1));
z4047 = (1-bet*(1-alph047)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph047)*Pibar^(theta*(1-ppsi))*(z4047(+1) + theta*(1-ppsi)*p(+1));

z1048 = (1-bet*(1-alph048)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph048)*Pibar^(theta*(1-ppsi)-1)*(z1048(+1)+(theta*(1-ppsi)-1)*p(+1));
z2048 = (1-bet*(1-alph048)/Pibar)*(1-sigm)*y + bet*(1-alph048)/Pibar*(z2048(+1) - p(+1));
z3048 = (1-bet*(1-alph048)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph048)*Pibar^(2*theta*(1-ppsi))*(z3048(+1) + 2*theta*(1-ppsi)*p(+1));
z4048 = (1-bet*(1-alph048)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph048)*Pibar^(theta*(1-ppsi))*(z4048(+1) + theta*(1-ppsi)*p(+1));

z1049 = (1-bet*(1-alph049)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph049)*Pibar^(theta*(1-ppsi)-1)*(z1049(+1)+(theta*(1-ppsi)-1)*p(+1));
z2049 = (1-bet*(1-alph049)/Pibar)*(1-sigm)*y + bet*(1-alph049)/Pibar*(z2049(+1) - p(+1));
z3049 = (1-bet*(1-alph049)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph049)*Pibar^(2*theta*(1-ppsi))*(z3049(+1) + 2*theta*(1-ppsi)*p(+1));
z4049 = (1-bet*(1-alph049)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph049)*Pibar^(theta*(1-ppsi))*(z4049(+1) + theta*(1-ppsi)*p(+1));

z1050 = (1-bet*(1-alph050)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph050)*Pibar^(theta*(1-ppsi)-1)*(z1050(+1)+(theta*(1-ppsi)-1)*p(+1));
z2050 = (1-bet*(1-alph050)/Pibar)*(1-sigm)*y + bet*(1-alph050)/Pibar*(z2050(+1) - p(+1));
z3050 = (1-bet*(1-alph050)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph050)*Pibar^(2*theta*(1-ppsi))*(z3050(+1) + 2*theta*(1-ppsi)*p(+1));
z4050 = (1-bet*(1-alph050)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph050)*Pibar^(theta*(1-ppsi))*(z4050(+1) + theta*(1-ppsi)*p(+1));

z1051 = (1-bet*(1-alph051)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph051)*Pibar^(theta*(1-ppsi)-1)*(z1051(+1)+(theta*(1-ppsi)-1)*p(+1));
z2051 = (1-bet*(1-alph051)/Pibar)*(1-sigm)*y + bet*(1-alph051)/Pibar*(z2051(+1) - p(+1));
z3051 = (1-bet*(1-alph051)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph051)*Pibar^(2*theta*(1-ppsi))*(z3051(+1) + 2*theta*(1-ppsi)*p(+1));
z4051 = (1-bet*(1-alph051)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph051)*Pibar^(theta*(1-ppsi))*(z4051(+1) + theta*(1-ppsi)*p(+1));

z1052 = (1-bet*(1-alph052)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph052)*Pibar^(theta*(1-ppsi)-1)*(z1052(+1)+(theta*(1-ppsi)-1)*p(+1));
z2052 = (1-bet*(1-alph052)/Pibar)*(1-sigm)*y + bet*(1-alph052)/Pibar*(z2052(+1) - p(+1));
z3052 = (1-bet*(1-alph052)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph052)*Pibar^(2*theta*(1-ppsi))*(z3052(+1) + 2*theta*(1-ppsi)*p(+1));
z4052 = (1-bet*(1-alph052)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph052)*Pibar^(theta*(1-ppsi))*(z4052(+1) + theta*(1-ppsi)*p(+1));

z1053 = (1-bet*(1-alph053)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph053)*Pibar^(theta*(1-ppsi)-1)*(z1053(+1)+(theta*(1-ppsi)-1)*p(+1));
z2053 = (1-bet*(1-alph053)/Pibar)*(1-sigm)*y + bet*(1-alph053)/Pibar*(z2053(+1) - p(+1));
z3053 = (1-bet*(1-alph053)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph053)*Pibar^(2*theta*(1-ppsi))*(z3053(+1) + 2*theta*(1-ppsi)*p(+1));
z4053 = (1-bet*(1-alph053)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph053)*Pibar^(theta*(1-ppsi))*(z4053(+1) + theta*(1-ppsi)*p(+1));

z1054 = (1-bet*(1-alph054)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph054)*Pibar^(theta*(1-ppsi)-1)*(z1054(+1)+(theta*(1-ppsi)-1)*p(+1));
z2054 = (1-bet*(1-alph054)/Pibar)*(1-sigm)*y + bet*(1-alph054)/Pibar*(z2054(+1) - p(+1));
z3054 = (1-bet*(1-alph054)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph054)*Pibar^(2*theta*(1-ppsi))*(z3054(+1) + 2*theta*(1-ppsi)*p(+1));
z4054 = (1-bet*(1-alph054)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph054)*Pibar^(theta*(1-ppsi))*(z4054(+1) + theta*(1-ppsi)*p(+1));

z1055 = (1-bet*(1-alph055)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph055)*Pibar^(theta*(1-ppsi)-1)*(z1055(+1)+(theta*(1-ppsi)-1)*p(+1));
z2055 = (1-bet*(1-alph055)/Pibar)*(1-sigm)*y + bet*(1-alph055)/Pibar*(z2055(+1) - p(+1));
z3055 = (1-bet*(1-alph055)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph055)*Pibar^(2*theta*(1-ppsi))*(z3055(+1) + 2*theta*(1-ppsi)*p(+1));
z4055 = (1-bet*(1-alph055)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph055)*Pibar^(theta*(1-ppsi))*(z4055(+1) + theta*(1-ppsi)*p(+1));

z1056 = (1-bet*(1-alph056)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph056)*Pibar^(theta*(1-ppsi)-1)*(z1056(+1)+(theta*(1-ppsi)-1)*p(+1));
z2056 = (1-bet*(1-alph056)/Pibar)*(1-sigm)*y + bet*(1-alph056)/Pibar*(z2056(+1) - p(+1));
z3056 = (1-bet*(1-alph056)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph056)*Pibar^(2*theta*(1-ppsi))*(z3056(+1) + 2*theta*(1-ppsi)*p(+1));
z4056 = (1-bet*(1-alph056)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph056)*Pibar^(theta*(1-ppsi))*(z4056(+1) + theta*(1-ppsi)*p(+1));

z1057 = (1-bet*(1-alph057)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph057)*Pibar^(theta*(1-ppsi)-1)*(z1057(+1)+(theta*(1-ppsi)-1)*p(+1));
z2057 = (1-bet*(1-alph057)/Pibar)*(1-sigm)*y + bet*(1-alph057)/Pibar*(z2057(+1) - p(+1));
z3057 = (1-bet*(1-alph057)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph057)*Pibar^(2*theta*(1-ppsi))*(z3057(+1) + 2*theta*(1-ppsi)*p(+1));
z4057 = (1-bet*(1-alph057)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph057)*Pibar^(theta*(1-ppsi))*(z4057(+1) + theta*(1-ppsi)*p(+1));

z1058 = (1-bet*(1-alph058)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph058)*Pibar^(theta*(1-ppsi)-1)*(z1058(+1)+(theta*(1-ppsi)-1)*p(+1));
z2058 = (1-bet*(1-alph058)/Pibar)*(1-sigm)*y + bet*(1-alph058)/Pibar*(z2058(+1) - p(+1));
z3058 = (1-bet*(1-alph058)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph058)*Pibar^(2*theta*(1-ppsi))*(z3058(+1) + 2*theta*(1-ppsi)*p(+1));
z4058 = (1-bet*(1-alph058)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph058)*Pibar^(theta*(1-ppsi))*(z4058(+1) + theta*(1-ppsi)*p(+1));

z1059 = (1-bet*(1-alph059)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph059)*Pibar^(theta*(1-ppsi)-1)*(z1059(+1)+(theta*(1-ppsi)-1)*p(+1));
z2059 = (1-bet*(1-alph059)/Pibar)*(1-sigm)*y + bet*(1-alph059)/Pibar*(z2059(+1) - p(+1));
z3059 = (1-bet*(1-alph059)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph059)*Pibar^(2*theta*(1-ppsi))*(z3059(+1) + 2*theta*(1-ppsi)*p(+1));
z4059 = (1-bet*(1-alph059)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph059)*Pibar^(theta*(1-ppsi))*(z4059(+1) + theta*(1-ppsi)*p(+1));

z1060 = (1-bet*(1-alph060)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph060)*Pibar^(theta*(1-ppsi)-1)*(z1060(+1)+(theta*(1-ppsi)-1)*p(+1));
z2060 = (1-bet*(1-alph060)/Pibar)*(1-sigm)*y + bet*(1-alph060)/Pibar*(z2060(+1) - p(+1));
z3060 = (1-bet*(1-alph060)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph060)*Pibar^(2*theta*(1-ppsi))*(z3060(+1) + 2*theta*(1-ppsi)*p(+1));
z4060 = (1-bet*(1-alph060)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph060)*Pibar^(theta*(1-ppsi))*(z4060(+1) + theta*(1-ppsi)*p(+1));

z1061 = (1-bet*(1-alph061)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph061)*Pibar^(theta*(1-ppsi)-1)*(z1061(+1)+(theta*(1-ppsi)-1)*p(+1));
z2061 = (1-bet*(1-alph061)/Pibar)*(1-sigm)*y + bet*(1-alph061)/Pibar*(z2061(+1) - p(+1));
z3061 = (1-bet*(1-alph061)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph061)*Pibar^(2*theta*(1-ppsi))*(z3061(+1) + 2*theta*(1-ppsi)*p(+1));
z4061 = (1-bet*(1-alph061)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph061)*Pibar^(theta*(1-ppsi))*(z4061(+1) + theta*(1-ppsi)*p(+1));

z1062 = (1-bet*(1-alph062)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph062)*Pibar^(theta*(1-ppsi)-1)*(z1062(+1)+(theta*(1-ppsi)-1)*p(+1));
z2062 = (1-bet*(1-alph062)/Pibar)*(1-sigm)*y + bet*(1-alph062)/Pibar*(z2062(+1) - p(+1));
z3062 = (1-bet*(1-alph062)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph062)*Pibar^(2*theta*(1-ppsi))*(z3062(+1) + 2*theta*(1-ppsi)*p(+1));
z4062 = (1-bet*(1-alph062)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph062)*Pibar^(theta*(1-ppsi))*(z4062(+1) + theta*(1-ppsi)*p(+1));

z1063 = (1-bet*(1-alph063)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph063)*Pibar^(theta*(1-ppsi)-1)*(z1063(+1)+(theta*(1-ppsi)-1)*p(+1));
z2063 = (1-bet*(1-alph063)/Pibar)*(1-sigm)*y + bet*(1-alph063)/Pibar*(z2063(+1) - p(+1));
z3063 = (1-bet*(1-alph063)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph063)*Pibar^(2*theta*(1-ppsi))*(z3063(+1) + 2*theta*(1-ppsi)*p(+1));
z4063 = (1-bet*(1-alph063)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph063)*Pibar^(theta*(1-ppsi))*(z4063(+1) + theta*(1-ppsi)*p(+1));

z1064 = (1-bet*(1-alph064)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph064)*Pibar^(theta*(1-ppsi)-1)*(z1064(+1)+(theta*(1-ppsi)-1)*p(+1));
z2064 = (1-bet*(1-alph064)/Pibar)*(1-sigm)*y + bet*(1-alph064)/Pibar*(z2064(+1) - p(+1));
z3064 = (1-bet*(1-alph064)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph064)*Pibar^(2*theta*(1-ppsi))*(z3064(+1) + 2*theta*(1-ppsi)*p(+1));
z4064 = (1-bet*(1-alph064)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph064)*Pibar^(theta*(1-ppsi))*(z4064(+1) + theta*(1-ppsi)*p(+1));

z1065 = (1-bet*(1-alph065)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph065)*Pibar^(theta*(1-ppsi)-1)*(z1065(+1)+(theta*(1-ppsi)-1)*p(+1));
z2065 = (1-bet*(1-alph065)/Pibar)*(1-sigm)*y + bet*(1-alph065)/Pibar*(z2065(+1) - p(+1));
z3065 = (1-bet*(1-alph065)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph065)*Pibar^(2*theta*(1-ppsi))*(z3065(+1) + 2*theta*(1-ppsi)*p(+1));
z4065 = (1-bet*(1-alph065)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph065)*Pibar^(theta*(1-ppsi))*(z4065(+1) + theta*(1-ppsi)*p(+1));

z1066 = (1-bet*(1-alph066)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph066)*Pibar^(theta*(1-ppsi)-1)*(z1066(+1)+(theta*(1-ppsi)-1)*p(+1));
z2066 = (1-bet*(1-alph066)/Pibar)*(1-sigm)*y + bet*(1-alph066)/Pibar*(z2066(+1) - p(+1));
z3066 = (1-bet*(1-alph066)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph066)*Pibar^(2*theta*(1-ppsi))*(z3066(+1) + 2*theta*(1-ppsi)*p(+1));
z4066 = (1-bet*(1-alph066)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph066)*Pibar^(theta*(1-ppsi))*(z4066(+1) + theta*(1-ppsi)*p(+1));

z1067 = (1-bet*(1-alph067)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph067)*Pibar^(theta*(1-ppsi)-1)*(z1067(+1)+(theta*(1-ppsi)-1)*p(+1));
z2067 = (1-bet*(1-alph067)/Pibar)*(1-sigm)*y + bet*(1-alph067)/Pibar*(z2067(+1) - p(+1));
z3067 = (1-bet*(1-alph067)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph067)*Pibar^(2*theta*(1-ppsi))*(z3067(+1) + 2*theta*(1-ppsi)*p(+1));
z4067 = (1-bet*(1-alph067)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph067)*Pibar^(theta*(1-ppsi))*(z4067(+1) + theta*(1-ppsi)*p(+1));

z1068 = (1-bet*(1-alph068)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph068)*Pibar^(theta*(1-ppsi)-1)*(z1068(+1)+(theta*(1-ppsi)-1)*p(+1));
z2068 = (1-bet*(1-alph068)/Pibar)*(1-sigm)*y + bet*(1-alph068)/Pibar*(z2068(+1) - p(+1));
z3068 = (1-bet*(1-alph068)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph068)*Pibar^(2*theta*(1-ppsi))*(z3068(+1) + 2*theta*(1-ppsi)*p(+1));
z4068 = (1-bet*(1-alph068)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph068)*Pibar^(theta*(1-ppsi))*(z4068(+1) + theta*(1-ppsi)*p(+1));

z1069 = (1-bet*(1-alph069)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph069)*Pibar^(theta*(1-ppsi)-1)*(z1069(+1)+(theta*(1-ppsi)-1)*p(+1));
z2069 = (1-bet*(1-alph069)/Pibar)*(1-sigm)*y + bet*(1-alph069)/Pibar*(z2069(+1) - p(+1));
z3069 = (1-bet*(1-alph069)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph069)*Pibar^(2*theta*(1-ppsi))*(z3069(+1) + 2*theta*(1-ppsi)*p(+1));
z4069 = (1-bet*(1-alph069)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph069)*Pibar^(theta*(1-ppsi))*(z4069(+1) + theta*(1-ppsi)*p(+1));

z1070 = (1-bet*(1-alph070)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph070)*Pibar^(theta*(1-ppsi)-1)*(z1070(+1)+(theta*(1-ppsi)-1)*p(+1));
z2070 = (1-bet*(1-alph070)/Pibar)*(1-sigm)*y + bet*(1-alph070)/Pibar*(z2070(+1) - p(+1));
z3070 = (1-bet*(1-alph070)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph070)*Pibar^(2*theta*(1-ppsi))*(z3070(+1) + 2*theta*(1-ppsi)*p(+1));
z4070 = (1-bet*(1-alph070)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph070)*Pibar^(theta*(1-ppsi))*(z4070(+1) + theta*(1-ppsi)*p(+1));

z1071 = (1-bet*(1-alph071)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph071)*Pibar^(theta*(1-ppsi)-1)*(z1071(+1)+(theta*(1-ppsi)-1)*p(+1));
z2071 = (1-bet*(1-alph071)/Pibar)*(1-sigm)*y + bet*(1-alph071)/Pibar*(z2071(+1) - p(+1));
z3071 = (1-bet*(1-alph071)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph071)*Pibar^(2*theta*(1-ppsi))*(z3071(+1) + 2*theta*(1-ppsi)*p(+1));
z4071 = (1-bet*(1-alph071)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph071)*Pibar^(theta*(1-ppsi))*(z4071(+1) + theta*(1-ppsi)*p(+1));

z1072 = (1-bet*(1-alph072)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph072)*Pibar^(theta*(1-ppsi)-1)*(z1072(+1)+(theta*(1-ppsi)-1)*p(+1));
z2072 = (1-bet*(1-alph072)/Pibar)*(1-sigm)*y + bet*(1-alph072)/Pibar*(z2072(+1) - p(+1));
z3072 = (1-bet*(1-alph072)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph072)*Pibar^(2*theta*(1-ppsi))*(z3072(+1) + 2*theta*(1-ppsi)*p(+1));
z4072 = (1-bet*(1-alph072)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph072)*Pibar^(theta*(1-ppsi))*(z4072(+1) + theta*(1-ppsi)*p(+1));

z1073 = (1-bet*(1-alph073)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph073)*Pibar^(theta*(1-ppsi)-1)*(z1073(+1)+(theta*(1-ppsi)-1)*p(+1));
z2073 = (1-bet*(1-alph073)/Pibar)*(1-sigm)*y + bet*(1-alph073)/Pibar*(z2073(+1) - p(+1));
z3073 = (1-bet*(1-alph073)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph073)*Pibar^(2*theta*(1-ppsi))*(z3073(+1) + 2*theta*(1-ppsi)*p(+1));
z4073 = (1-bet*(1-alph073)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph073)*Pibar^(theta*(1-ppsi))*(z4073(+1) + theta*(1-ppsi)*p(+1));

z1074 = (1-bet*(1-alph074)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph074)*Pibar^(theta*(1-ppsi)-1)*(z1074(+1)+(theta*(1-ppsi)-1)*p(+1));
z2074 = (1-bet*(1-alph074)/Pibar)*(1-sigm)*y + bet*(1-alph074)/Pibar*(z2074(+1) - p(+1));
z3074 = (1-bet*(1-alph074)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph074)*Pibar^(2*theta*(1-ppsi))*(z3074(+1) + 2*theta*(1-ppsi)*p(+1));
z4074 = (1-bet*(1-alph074)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph074)*Pibar^(theta*(1-ppsi))*(z4074(+1) + theta*(1-ppsi)*p(+1));

z1075 = (1-bet*(1-alph075)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph075)*Pibar^(theta*(1-ppsi)-1)*(z1075(+1)+(theta*(1-ppsi)-1)*p(+1));
z2075 = (1-bet*(1-alph075)/Pibar)*(1-sigm)*y + bet*(1-alph075)/Pibar*(z2075(+1) - p(+1));
z3075 = (1-bet*(1-alph075)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph075)*Pibar^(2*theta*(1-ppsi))*(z3075(+1) + 2*theta*(1-ppsi)*p(+1));
z4075 = (1-bet*(1-alph075)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph075)*Pibar^(theta*(1-ppsi))*(z4075(+1) + theta*(1-ppsi)*p(+1));

z1076 = (1-bet*(1-alph076)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph076)*Pibar^(theta*(1-ppsi)-1)*(z1076(+1)+(theta*(1-ppsi)-1)*p(+1));
z2076 = (1-bet*(1-alph076)/Pibar)*(1-sigm)*y + bet*(1-alph076)/Pibar*(z2076(+1) - p(+1));
z3076 = (1-bet*(1-alph076)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph076)*Pibar^(2*theta*(1-ppsi))*(z3076(+1) + 2*theta*(1-ppsi)*p(+1));
z4076 = (1-bet*(1-alph076)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph076)*Pibar^(theta*(1-ppsi))*(z4076(+1) + theta*(1-ppsi)*p(+1));

z1077 = (1-bet*(1-alph077)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph077)*Pibar^(theta*(1-ppsi)-1)*(z1077(+1)+(theta*(1-ppsi)-1)*p(+1));
z2077 = (1-bet*(1-alph077)/Pibar)*(1-sigm)*y + bet*(1-alph077)/Pibar*(z2077(+1) - p(+1));
z3077 = (1-bet*(1-alph077)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph077)*Pibar^(2*theta*(1-ppsi))*(z3077(+1) + 2*theta*(1-ppsi)*p(+1));
z4077 = (1-bet*(1-alph077)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph077)*Pibar^(theta*(1-ppsi))*(z4077(+1) + theta*(1-ppsi)*p(+1));

z1078 = (1-bet*(1-alph078)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph078)*Pibar^(theta*(1-ppsi)-1)*(z1078(+1)+(theta*(1-ppsi)-1)*p(+1));
z2078 = (1-bet*(1-alph078)/Pibar)*(1-sigm)*y + bet*(1-alph078)/Pibar*(z2078(+1) - p(+1));
z3078 = (1-bet*(1-alph078)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph078)*Pibar^(2*theta*(1-ppsi))*(z3078(+1) + 2*theta*(1-ppsi)*p(+1));
z4078 = (1-bet*(1-alph078)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph078)*Pibar^(theta*(1-ppsi))*(z4078(+1) + theta*(1-ppsi)*p(+1));

z1079 = (1-bet*(1-alph079)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph079)*Pibar^(theta*(1-ppsi)-1)*(z1079(+1)+(theta*(1-ppsi)-1)*p(+1));
z2079 = (1-bet*(1-alph079)/Pibar)*(1-sigm)*y + bet*(1-alph079)/Pibar*(z2079(+1) - p(+1));
z3079 = (1-bet*(1-alph079)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph079)*Pibar^(2*theta*(1-ppsi))*(z3079(+1) + 2*theta*(1-ppsi)*p(+1));
z4079 = (1-bet*(1-alph079)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph079)*Pibar^(theta*(1-ppsi))*(z4079(+1) + theta*(1-ppsi)*p(+1));

z1080 = (1-bet*(1-alph080)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph080)*Pibar^(theta*(1-ppsi)-1)*(z1080(+1)+(theta*(1-ppsi)-1)*p(+1));
z2080 = (1-bet*(1-alph080)/Pibar)*(1-sigm)*y + bet*(1-alph080)/Pibar*(z2080(+1) - p(+1));
z3080 = (1-bet*(1-alph080)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph080)*Pibar^(2*theta*(1-ppsi))*(z3080(+1) + 2*theta*(1-ppsi)*p(+1));
z4080 = (1-bet*(1-alph080)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph080)*Pibar^(theta*(1-ppsi))*(z4080(+1) + theta*(1-ppsi)*p(+1));

z1081 = (1-bet*(1-alph081)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph081)*Pibar^(theta*(1-ppsi)-1)*(z1081(+1)+(theta*(1-ppsi)-1)*p(+1));
z2081 = (1-bet*(1-alph081)/Pibar)*(1-sigm)*y + bet*(1-alph081)/Pibar*(z2081(+1) - p(+1));
z3081 = (1-bet*(1-alph081)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph081)*Pibar^(2*theta*(1-ppsi))*(z3081(+1) + 2*theta*(1-ppsi)*p(+1));
z4081 = (1-bet*(1-alph081)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph081)*Pibar^(theta*(1-ppsi))*(z4081(+1) + theta*(1-ppsi)*p(+1));

z1082 = (1-bet*(1-alph082)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph082)*Pibar^(theta*(1-ppsi)-1)*(z1082(+1)+(theta*(1-ppsi)-1)*p(+1));
z2082 = (1-bet*(1-alph082)/Pibar)*(1-sigm)*y + bet*(1-alph082)/Pibar*(z2082(+1) - p(+1));
z3082 = (1-bet*(1-alph082)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph082)*Pibar^(2*theta*(1-ppsi))*(z3082(+1) + 2*theta*(1-ppsi)*p(+1));
z4082 = (1-bet*(1-alph082)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph082)*Pibar^(theta*(1-ppsi))*(z4082(+1) + theta*(1-ppsi)*p(+1));

z1083 = (1-bet*(1-alph083)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph083)*Pibar^(theta*(1-ppsi)-1)*(z1083(+1)+(theta*(1-ppsi)-1)*p(+1));
z2083 = (1-bet*(1-alph083)/Pibar)*(1-sigm)*y + bet*(1-alph083)/Pibar*(z2083(+1) - p(+1));
z3083 = (1-bet*(1-alph083)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph083)*Pibar^(2*theta*(1-ppsi))*(z3083(+1) + 2*theta*(1-ppsi)*p(+1));
z4083 = (1-bet*(1-alph083)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph083)*Pibar^(theta*(1-ppsi))*(z4083(+1) + theta*(1-ppsi)*p(+1));

z1084 = (1-bet*(1-alph084)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph084)*Pibar^(theta*(1-ppsi)-1)*(z1084(+1)+(theta*(1-ppsi)-1)*p(+1));
z2084 = (1-bet*(1-alph084)/Pibar)*(1-sigm)*y + bet*(1-alph084)/Pibar*(z2084(+1) - p(+1));
z3084 = (1-bet*(1-alph084)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph084)*Pibar^(2*theta*(1-ppsi))*(z3084(+1) + 2*theta*(1-ppsi)*p(+1));
z4084 = (1-bet*(1-alph084)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph084)*Pibar^(theta*(1-ppsi))*(z4084(+1) + theta*(1-ppsi)*p(+1));

z1085 = (1-bet*(1-alph085)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph085)*Pibar^(theta*(1-ppsi)-1)*(z1085(+1)+(theta*(1-ppsi)-1)*p(+1));
z2085 = (1-bet*(1-alph085)/Pibar)*(1-sigm)*y + bet*(1-alph085)/Pibar*(z2085(+1) - p(+1));
z3085 = (1-bet*(1-alph085)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph085)*Pibar^(2*theta*(1-ppsi))*(z3085(+1) + 2*theta*(1-ppsi)*p(+1));
z4085 = (1-bet*(1-alph085)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph085)*Pibar^(theta*(1-ppsi))*(z4085(+1) + theta*(1-ppsi)*p(+1));

z1086 = (1-bet*(1-alph086)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph086)*Pibar^(theta*(1-ppsi)-1)*(z1086(+1)+(theta*(1-ppsi)-1)*p(+1));
z2086 = (1-bet*(1-alph086)/Pibar)*(1-sigm)*y + bet*(1-alph086)/Pibar*(z2086(+1) - p(+1));
z3086 = (1-bet*(1-alph086)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph086)*Pibar^(2*theta*(1-ppsi))*(z3086(+1) + 2*theta*(1-ppsi)*p(+1));
z4086 = (1-bet*(1-alph086)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph086)*Pibar^(theta*(1-ppsi))*(z4086(+1) + theta*(1-ppsi)*p(+1));

z1087 = (1-bet*(1-alph087)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph087)*Pibar^(theta*(1-ppsi)-1)*(z1087(+1)+(theta*(1-ppsi)-1)*p(+1));
z2087 = (1-bet*(1-alph087)/Pibar)*(1-sigm)*y + bet*(1-alph087)/Pibar*(z2087(+1) - p(+1));
z3087 = (1-bet*(1-alph087)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph087)*Pibar^(2*theta*(1-ppsi))*(z3087(+1) + 2*theta*(1-ppsi)*p(+1));
z4087 = (1-bet*(1-alph087)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph087)*Pibar^(theta*(1-ppsi))*(z4087(+1) + theta*(1-ppsi)*p(+1));

z1088 = (1-bet*(1-alph088)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph088)*Pibar^(theta*(1-ppsi)-1)*(z1088(+1)+(theta*(1-ppsi)-1)*p(+1));
z2088 = (1-bet*(1-alph088)/Pibar)*(1-sigm)*y + bet*(1-alph088)/Pibar*(z2088(+1) - p(+1));
z3088 = (1-bet*(1-alph088)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph088)*Pibar^(2*theta*(1-ppsi))*(z3088(+1) + 2*theta*(1-ppsi)*p(+1));
z4088 = (1-bet*(1-alph088)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph088)*Pibar^(theta*(1-ppsi))*(z4088(+1) + theta*(1-ppsi)*p(+1));

z1089 = (1-bet*(1-alph089)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph089)*Pibar^(theta*(1-ppsi)-1)*(z1089(+1)+(theta*(1-ppsi)-1)*p(+1));
z2089 = (1-bet*(1-alph089)/Pibar)*(1-sigm)*y + bet*(1-alph089)/Pibar*(z2089(+1) - p(+1));
z3089 = (1-bet*(1-alph089)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph089)*Pibar^(2*theta*(1-ppsi))*(z3089(+1) + 2*theta*(1-ppsi)*p(+1));
z4089 = (1-bet*(1-alph089)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph089)*Pibar^(theta*(1-ppsi))*(z4089(+1) + theta*(1-ppsi)*p(+1));

z1090 = (1-bet*(1-alph090)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph090)*Pibar^(theta*(1-ppsi)-1)*(z1090(+1)+(theta*(1-ppsi)-1)*p(+1));
z2090 = (1-bet*(1-alph090)/Pibar)*(1-sigm)*y + bet*(1-alph090)/Pibar*(z2090(+1) - p(+1));
z3090 = (1-bet*(1-alph090)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph090)*Pibar^(2*theta*(1-ppsi))*(z3090(+1) + 2*theta*(1-ppsi)*p(+1));
z4090 = (1-bet*(1-alph090)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph090)*Pibar^(theta*(1-ppsi))*(z4090(+1) + theta*(1-ppsi)*p(+1));

z1091 = (1-bet*(1-alph091)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph091)*Pibar^(theta*(1-ppsi)-1)*(z1091(+1)+(theta*(1-ppsi)-1)*p(+1));
z2091 = (1-bet*(1-alph091)/Pibar)*(1-sigm)*y + bet*(1-alph091)/Pibar*(z2091(+1) - p(+1));
z3091 = (1-bet*(1-alph091)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph091)*Pibar^(2*theta*(1-ppsi))*(z3091(+1) + 2*theta*(1-ppsi)*p(+1));
z4091 = (1-bet*(1-alph091)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph091)*Pibar^(theta*(1-ppsi))*(z4091(+1) + theta*(1-ppsi)*p(+1));

z1092 = (1-bet*(1-alph092)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph092)*Pibar^(theta*(1-ppsi)-1)*(z1092(+1)+(theta*(1-ppsi)-1)*p(+1));
z2092 = (1-bet*(1-alph092)/Pibar)*(1-sigm)*y + bet*(1-alph092)/Pibar*(z2092(+1) - p(+1));
z3092 = (1-bet*(1-alph092)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph092)*Pibar^(2*theta*(1-ppsi))*(z3092(+1) + 2*theta*(1-ppsi)*p(+1));
z4092 = (1-bet*(1-alph092)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph092)*Pibar^(theta*(1-ppsi))*(z4092(+1) + theta*(1-ppsi)*p(+1));

z1093 = (1-bet*(1-alph093)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph093)*Pibar^(theta*(1-ppsi)-1)*(z1093(+1)+(theta*(1-ppsi)-1)*p(+1));
z2093 = (1-bet*(1-alph093)/Pibar)*(1-sigm)*y + bet*(1-alph093)/Pibar*(z2093(+1) - p(+1));
z3093 = (1-bet*(1-alph093)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph093)*Pibar^(2*theta*(1-ppsi))*(z3093(+1) + 2*theta*(1-ppsi)*p(+1));
z4093 = (1-bet*(1-alph093)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph093)*Pibar^(theta*(1-ppsi))*(z4093(+1) + theta*(1-ppsi)*p(+1));

z1094 = (1-bet*(1-alph094)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph094)*Pibar^(theta*(1-ppsi)-1)*(z1094(+1)+(theta*(1-ppsi)-1)*p(+1));
z2094 = (1-bet*(1-alph094)/Pibar)*(1-sigm)*y + bet*(1-alph094)/Pibar*(z2094(+1) - p(+1));
z3094 = (1-bet*(1-alph094)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph094)*Pibar^(2*theta*(1-ppsi))*(z3094(+1) + 2*theta*(1-ppsi)*p(+1));
z4094 = (1-bet*(1-alph094)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph094)*Pibar^(theta*(1-ppsi))*(z4094(+1) + theta*(1-ppsi)*p(+1));

z1095 = (1-bet*(1-alph095)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph095)*Pibar^(theta*(1-ppsi)-1)*(z1095(+1)+(theta*(1-ppsi)-1)*p(+1));
z2095 = (1-bet*(1-alph095)/Pibar)*(1-sigm)*y + bet*(1-alph095)/Pibar*(z2095(+1) - p(+1));
z3095 = (1-bet*(1-alph095)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph095)*Pibar^(2*theta*(1-ppsi))*(z3095(+1) + 2*theta*(1-ppsi)*p(+1));
z4095 = (1-bet*(1-alph095)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph095)*Pibar^(theta*(1-ppsi))*(z4095(+1) + theta*(1-ppsi)*p(+1));

z1096 = (1-bet*(1-alph096)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph096)*Pibar^(theta*(1-ppsi)-1)*(z1096(+1)+(theta*(1-ppsi)-1)*p(+1));
z2096 = (1-bet*(1-alph096)/Pibar)*(1-sigm)*y + bet*(1-alph096)/Pibar*(z2096(+1) - p(+1));
z3096 = (1-bet*(1-alph096)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph096)*Pibar^(2*theta*(1-ppsi))*(z3096(+1) + 2*theta*(1-ppsi)*p(+1));
z4096 = (1-bet*(1-alph096)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph096)*Pibar^(theta*(1-ppsi))*(z4096(+1) + theta*(1-ppsi)*p(+1));

z1097 = (1-bet*(1-alph097)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph097)*Pibar^(theta*(1-ppsi)-1)*(z1097(+1)+(theta*(1-ppsi)-1)*p(+1));
z2097 = (1-bet*(1-alph097)/Pibar)*(1-sigm)*y + bet*(1-alph097)/Pibar*(z2097(+1) - p(+1));
z3097 = (1-bet*(1-alph097)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph097)*Pibar^(2*theta*(1-ppsi))*(z3097(+1) + 2*theta*(1-ppsi)*p(+1));
z4097 = (1-bet*(1-alph097)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph097)*Pibar^(theta*(1-ppsi))*(z4097(+1) + theta*(1-ppsi)*p(+1));

z1098 = (1-bet*(1-alph098)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph098)*Pibar^(theta*(1-ppsi)-1)*(z1098(+1)+(theta*(1-ppsi)-1)*p(+1));
z2098 = (1-bet*(1-alph098)/Pibar)*(1-sigm)*y + bet*(1-alph098)/Pibar*(z2098(+1) - p(+1));
z3098 = (1-bet*(1-alph098)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph098)*Pibar^(2*theta*(1-ppsi))*(z3098(+1) + 2*theta*(1-ppsi)*p(+1));
z4098 = (1-bet*(1-alph098)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph098)*Pibar^(theta*(1-ppsi))*(z4098(+1) + theta*(1-ppsi)*p(+1));

z1099 = (1-bet*(1-alph099)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph099)*Pibar^(theta*(1-ppsi)-1)*(z1099(+1)+(theta*(1-ppsi)-1)*p(+1));
z2099 = (1-bet*(1-alph099)/Pibar)*(1-sigm)*y + bet*(1-alph099)/Pibar*(z2099(+1) - p(+1));
z3099 = (1-bet*(1-alph099)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph099)*Pibar^(2*theta*(1-ppsi))*(z3099(+1) + 2*theta*(1-ppsi)*p(+1));
z4099 = (1-bet*(1-alph099)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph099)*Pibar^(theta*(1-ppsi))*(z4099(+1) + theta*(1-ppsi)*p(+1));

z1100 = (1-bet*(1-alph100)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph100)*Pibar^(theta*(1-ppsi)-1)*(z1100(+1)+(theta*(1-ppsi)-1)*p(+1));
z2100 = (1-bet*(1-alph100)/Pibar)*(1-sigm)*y + bet*(1-alph100)/Pibar*(z2100(+1) - p(+1));
z3100 = (1-bet*(1-alph100)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph100)*Pibar^(2*theta*(1-ppsi))*(z3100(+1) + 2*theta*(1-ppsi)*p(+1));
z4100 = (1-bet*(1-alph100)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph100)*Pibar^(theta*(1-ppsi))*(z4100(+1) + theta*(1-ppsi)*p(+1));

z1101 = (1-bet*(1-alph101)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph101)*Pibar^(theta*(1-ppsi)-1)*(z1101(+1)+(theta*(1-ppsi)-1)*p(+1));
z2101 = (1-bet*(1-alph101)/Pibar)*(1-sigm)*y + bet*(1-alph101)/Pibar*(z2101(+1) - p(+1));
z3101 = (1-bet*(1-alph101)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph101)*Pibar^(2*theta*(1-ppsi))*(z3101(+1) + 2*theta*(1-ppsi)*p(+1));
z4101 = (1-bet*(1-alph101)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph101)*Pibar^(theta*(1-ppsi))*(z4101(+1) + theta*(1-ppsi)*p(+1));

z1102 = (1-bet*(1-alph102)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph102)*Pibar^(theta*(1-ppsi)-1)*(z1102(+1)+(theta*(1-ppsi)-1)*p(+1));
z2102 = (1-bet*(1-alph102)/Pibar)*(1-sigm)*y + bet*(1-alph102)/Pibar*(z2102(+1) - p(+1));
z3102 = (1-bet*(1-alph102)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph102)*Pibar^(2*theta*(1-ppsi))*(z3102(+1) + 2*theta*(1-ppsi)*p(+1));
z4102 = (1-bet*(1-alph102)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph102)*Pibar^(theta*(1-ppsi))*(z4102(+1) + theta*(1-ppsi)*p(+1));

z1103 = (1-bet*(1-alph103)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph103)*Pibar^(theta*(1-ppsi)-1)*(z1103(+1)+(theta*(1-ppsi)-1)*p(+1));
z2103 = (1-bet*(1-alph103)/Pibar)*(1-sigm)*y + bet*(1-alph103)/Pibar*(z2103(+1) - p(+1));
z3103 = (1-bet*(1-alph103)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph103)*Pibar^(2*theta*(1-ppsi))*(z3103(+1) + 2*theta*(1-ppsi)*p(+1));
z4103 = (1-bet*(1-alph103)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph103)*Pibar^(theta*(1-ppsi))*(z4103(+1) + theta*(1-ppsi)*p(+1));

z1104 = (1-bet*(1-alph104)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph104)*Pibar^(theta*(1-ppsi)-1)*(z1104(+1)+(theta*(1-ppsi)-1)*p(+1));
z2104 = (1-bet*(1-alph104)/Pibar)*(1-sigm)*y + bet*(1-alph104)/Pibar*(z2104(+1) - p(+1));
z3104 = (1-bet*(1-alph104)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph104)*Pibar^(2*theta*(1-ppsi))*(z3104(+1) + 2*theta*(1-ppsi)*p(+1));
z4104 = (1-bet*(1-alph104)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph104)*Pibar^(theta*(1-ppsi))*(z4104(+1) + theta*(1-ppsi)*p(+1));

z1105 = (1-bet*(1-alph105)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph105)*Pibar^(theta*(1-ppsi)-1)*(z1105(+1)+(theta*(1-ppsi)-1)*p(+1));
z2105 = (1-bet*(1-alph105)/Pibar)*(1-sigm)*y + bet*(1-alph105)/Pibar*(z2105(+1) - p(+1));
z3105 = (1-bet*(1-alph105)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph105)*Pibar^(2*theta*(1-ppsi))*(z3105(+1) + 2*theta*(1-ppsi)*p(+1));
z4105 = (1-bet*(1-alph105)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph105)*Pibar^(theta*(1-ppsi))*(z4105(+1) + theta*(1-ppsi)*p(+1));

z1106 = (1-bet*(1-alph106)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph106)*Pibar^(theta*(1-ppsi)-1)*(z1106(+1)+(theta*(1-ppsi)-1)*p(+1));
z2106 = (1-bet*(1-alph106)/Pibar)*(1-sigm)*y + bet*(1-alph106)/Pibar*(z2106(+1) - p(+1));
z3106 = (1-bet*(1-alph106)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph106)*Pibar^(2*theta*(1-ppsi))*(z3106(+1) + 2*theta*(1-ppsi)*p(+1));
z4106 = (1-bet*(1-alph106)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph106)*Pibar^(theta*(1-ppsi))*(z4106(+1) + theta*(1-ppsi)*p(+1));

z1107 = (1-bet*(1-alph107)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph107)*Pibar^(theta*(1-ppsi)-1)*(z1107(+1)+(theta*(1-ppsi)-1)*p(+1));
z2107 = (1-bet*(1-alph107)/Pibar)*(1-sigm)*y + bet*(1-alph107)/Pibar*(z2107(+1) - p(+1));
z3107 = (1-bet*(1-alph107)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph107)*Pibar^(2*theta*(1-ppsi))*(z3107(+1) + 2*theta*(1-ppsi)*p(+1));
z4107 = (1-bet*(1-alph107)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph107)*Pibar^(theta*(1-ppsi))*(z4107(+1) + theta*(1-ppsi)*p(+1));

z1108 = (1-bet*(1-alph108)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph108)*Pibar^(theta*(1-ppsi)-1)*(z1108(+1)+(theta*(1-ppsi)-1)*p(+1));
z2108 = (1-bet*(1-alph108)/Pibar)*(1-sigm)*y + bet*(1-alph108)/Pibar*(z2108(+1) - p(+1));
z3108 = (1-bet*(1-alph108)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph108)*Pibar^(2*theta*(1-ppsi))*(z3108(+1) + 2*theta*(1-ppsi)*p(+1));
z4108 = (1-bet*(1-alph108)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph108)*Pibar^(theta*(1-ppsi))*(z4108(+1) + theta*(1-ppsi)*p(+1));

z1109 = (1-bet*(1-alph109)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph109)*Pibar^(theta*(1-ppsi)-1)*(z1109(+1)+(theta*(1-ppsi)-1)*p(+1));
z2109 = (1-bet*(1-alph109)/Pibar)*(1-sigm)*y + bet*(1-alph109)/Pibar*(z2109(+1) - p(+1));
z3109 = (1-bet*(1-alph109)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph109)*Pibar^(2*theta*(1-ppsi))*(z3109(+1) + 2*theta*(1-ppsi)*p(+1));
z4109 = (1-bet*(1-alph109)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph109)*Pibar^(theta*(1-ppsi))*(z4109(+1) + theta*(1-ppsi)*p(+1));

z1110 = (1-bet*(1-alph110)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph110)*Pibar^(theta*(1-ppsi)-1)*(z1110(+1)+(theta*(1-ppsi)-1)*p(+1));
z2110 = (1-bet*(1-alph110)/Pibar)*(1-sigm)*y + bet*(1-alph110)/Pibar*(z2110(+1) - p(+1));
z3110 = (1-bet*(1-alph110)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph110)*Pibar^(2*theta*(1-ppsi))*(z3110(+1) + 2*theta*(1-ppsi)*p(+1));
z4110 = (1-bet*(1-alph110)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph110)*Pibar^(theta*(1-ppsi))*(z4110(+1) + theta*(1-ppsi)*p(+1));

z1111 = (1-bet*(1-alph111)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph111)*Pibar^(theta*(1-ppsi)-1)*(z1111(+1)+(theta*(1-ppsi)-1)*p(+1));
z2111 = (1-bet*(1-alph111)/Pibar)*(1-sigm)*y + bet*(1-alph111)/Pibar*(z2111(+1) - p(+1));
z3111 = (1-bet*(1-alph111)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph111)*Pibar^(2*theta*(1-ppsi))*(z3111(+1) + 2*theta*(1-ppsi)*p(+1));
z4111 = (1-bet*(1-alph111)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph111)*Pibar^(theta*(1-ppsi))*(z4111(+1) + theta*(1-ppsi)*p(+1));

z1112 = (1-bet*(1-alph112)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph112)*Pibar^(theta*(1-ppsi)-1)*(z1112(+1)+(theta*(1-ppsi)-1)*p(+1));
z2112 = (1-bet*(1-alph112)/Pibar)*(1-sigm)*y + bet*(1-alph112)/Pibar*(z2112(+1) - p(+1));
z3112 = (1-bet*(1-alph112)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph112)*Pibar^(2*theta*(1-ppsi))*(z3112(+1) + 2*theta*(1-ppsi)*p(+1));
z4112 = (1-bet*(1-alph112)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph112)*Pibar^(theta*(1-ppsi))*(z4112(+1) + theta*(1-ppsi)*p(+1));

z1113 = (1-bet*(1-alph113)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph113)*Pibar^(theta*(1-ppsi)-1)*(z1113(+1)+(theta*(1-ppsi)-1)*p(+1));
z2113 = (1-bet*(1-alph113)/Pibar)*(1-sigm)*y + bet*(1-alph113)/Pibar*(z2113(+1) - p(+1));
z3113 = (1-bet*(1-alph113)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph113)*Pibar^(2*theta*(1-ppsi))*(z3113(+1) + 2*theta*(1-ppsi)*p(+1));
z4113 = (1-bet*(1-alph113)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph113)*Pibar^(theta*(1-ppsi))*(z4113(+1) + theta*(1-ppsi)*p(+1));

z1114 = (1-bet*(1-alph114)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph114)*Pibar^(theta*(1-ppsi)-1)*(z1114(+1)+(theta*(1-ppsi)-1)*p(+1));
z2114 = (1-bet*(1-alph114)/Pibar)*(1-sigm)*y + bet*(1-alph114)/Pibar*(z2114(+1) - p(+1));
z3114 = (1-bet*(1-alph114)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph114)*Pibar^(2*theta*(1-ppsi))*(z3114(+1) + 2*theta*(1-ppsi)*p(+1));
z4114 = (1-bet*(1-alph114)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph114)*Pibar^(theta*(1-ppsi))*(z4114(+1) + theta*(1-ppsi)*p(+1));

z1115 = (1-bet*(1-alph115)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph115)*Pibar^(theta*(1-ppsi)-1)*(z1115(+1)+(theta*(1-ppsi)-1)*p(+1));
z2115 = (1-bet*(1-alph115)/Pibar)*(1-sigm)*y + bet*(1-alph115)/Pibar*(z2115(+1) - p(+1));
z3115 = (1-bet*(1-alph115)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph115)*Pibar^(2*theta*(1-ppsi))*(z3115(+1) + 2*theta*(1-ppsi)*p(+1));
z4115 = (1-bet*(1-alph115)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph115)*Pibar^(theta*(1-ppsi))*(z4115(+1) + theta*(1-ppsi)*p(+1));

z1116 = (1-bet*(1-alph116)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph116)*Pibar^(theta*(1-ppsi)-1)*(z1116(+1)+(theta*(1-ppsi)-1)*p(+1));
z2116 = (1-bet*(1-alph116)/Pibar)*(1-sigm)*y + bet*(1-alph116)/Pibar*(z2116(+1) - p(+1));
z3116 = (1-bet*(1-alph116)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph116)*Pibar^(2*theta*(1-ppsi))*(z3116(+1) + 2*theta*(1-ppsi)*p(+1));
z4116 = (1-bet*(1-alph116)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph116)*Pibar^(theta*(1-ppsi))*(z4116(+1) + theta*(1-ppsi)*p(+1));

z1117 = (1-bet*(1-alph117)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph117)*Pibar^(theta*(1-ppsi)-1)*(z1117(+1)+(theta*(1-ppsi)-1)*p(+1));
z2117 = (1-bet*(1-alph117)/Pibar)*(1-sigm)*y + bet*(1-alph117)/Pibar*(z2117(+1) - p(+1));
z3117 = (1-bet*(1-alph117)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph117)*Pibar^(2*theta*(1-ppsi))*(z3117(+1) + 2*theta*(1-ppsi)*p(+1));
z4117 = (1-bet*(1-alph117)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph117)*Pibar^(theta*(1-ppsi))*(z4117(+1) + theta*(1-ppsi)*p(+1));

z1118 = (1-bet*(1-alph118)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph118)*Pibar^(theta*(1-ppsi)-1)*(z1118(+1)+(theta*(1-ppsi)-1)*p(+1));
z2118 = (1-bet*(1-alph118)/Pibar)*(1-sigm)*y + bet*(1-alph118)/Pibar*(z2118(+1) - p(+1));
z3118 = (1-bet*(1-alph118)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph118)*Pibar^(2*theta*(1-ppsi))*(z3118(+1) + 2*theta*(1-ppsi)*p(+1));
z4118 = (1-bet*(1-alph118)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph118)*Pibar^(theta*(1-ppsi))*(z4118(+1) + theta*(1-ppsi)*p(+1));

z1119 = (1-bet*(1-alph119)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph119)*Pibar^(theta*(1-ppsi)-1)*(z1119(+1)+(theta*(1-ppsi)-1)*p(+1));
z2119 = (1-bet*(1-alph119)/Pibar)*(1-sigm)*y + bet*(1-alph119)/Pibar*(z2119(+1) - p(+1));
z3119 = (1-bet*(1-alph119)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph119)*Pibar^(2*theta*(1-ppsi))*(z3119(+1) + 2*theta*(1-ppsi)*p(+1));
z4119 = (1-bet*(1-alph119)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph119)*Pibar^(theta*(1-ppsi))*(z4119(+1) + theta*(1-ppsi)*p(+1));

z1120 = (1-bet*(1-alph120)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph120)*Pibar^(theta*(1-ppsi)-1)*(z1120(+1)+(theta*(1-ppsi)-1)*p(+1));
z2120 = (1-bet*(1-alph120)/Pibar)*(1-sigm)*y + bet*(1-alph120)/Pibar*(z2120(+1) - p(+1));
z3120 = (1-bet*(1-alph120)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph120)*Pibar^(2*theta*(1-ppsi))*(z3120(+1) + 2*theta*(1-ppsi)*p(+1));
z4120 = (1-bet*(1-alph120)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph120)*Pibar^(theta*(1-ppsi))*(z4120(+1) + theta*(1-ppsi)*p(+1));

z1121 = (1-bet*(1-alph121)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph121)*Pibar^(theta*(1-ppsi)-1)*(z1121(+1)+(theta*(1-ppsi)-1)*p(+1));
z2121 = (1-bet*(1-alph121)/Pibar)*(1-sigm)*y + bet*(1-alph121)/Pibar*(z2121(+1) - p(+1));
z3121 = (1-bet*(1-alph121)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph121)*Pibar^(2*theta*(1-ppsi))*(z3121(+1) + 2*theta*(1-ppsi)*p(+1));
z4121 = (1-bet*(1-alph121)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph121)*Pibar^(theta*(1-ppsi))*(z4121(+1) + theta*(1-ppsi)*p(+1));

z1122 = (1-bet*(1-alph122)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph122)*Pibar^(theta*(1-ppsi)-1)*(z1122(+1)+(theta*(1-ppsi)-1)*p(+1));
z2122 = (1-bet*(1-alph122)/Pibar)*(1-sigm)*y + bet*(1-alph122)/Pibar*(z2122(+1) - p(+1));
z3122 = (1-bet*(1-alph122)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph122)*Pibar^(2*theta*(1-ppsi))*(z3122(+1) + 2*theta*(1-ppsi)*p(+1));
z4122 = (1-bet*(1-alph122)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph122)*Pibar^(theta*(1-ppsi))*(z4122(+1) + theta*(1-ppsi)*p(+1));

z1123 = (1-bet*(1-alph123)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph123)*Pibar^(theta*(1-ppsi)-1)*(z1123(+1)+(theta*(1-ppsi)-1)*p(+1));
z2123 = (1-bet*(1-alph123)/Pibar)*(1-sigm)*y + bet*(1-alph123)/Pibar*(z2123(+1) - p(+1));
z3123 = (1-bet*(1-alph123)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph123)*Pibar^(2*theta*(1-ppsi))*(z3123(+1) + 2*theta*(1-ppsi)*p(+1));
z4123 = (1-bet*(1-alph123)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph123)*Pibar^(theta*(1-ppsi))*(z4123(+1) + theta*(1-ppsi)*p(+1));

z1124 = (1-bet*(1-alph124)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph124)*Pibar^(theta*(1-ppsi)-1)*(z1124(+1)+(theta*(1-ppsi)-1)*p(+1));
z2124 = (1-bet*(1-alph124)/Pibar)*(1-sigm)*y + bet*(1-alph124)/Pibar*(z2124(+1) - p(+1));
z3124 = (1-bet*(1-alph124)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph124)*Pibar^(2*theta*(1-ppsi))*(z3124(+1) + 2*theta*(1-ppsi)*p(+1));
z4124 = (1-bet*(1-alph124)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph124)*Pibar^(theta*(1-ppsi))*(z4124(+1) + theta*(1-ppsi)*p(+1));

z1125 = (1-bet*(1-alph125)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph125)*Pibar^(theta*(1-ppsi)-1)*(z1125(+1)+(theta*(1-ppsi)-1)*p(+1));
z2125 = (1-bet*(1-alph125)/Pibar)*(1-sigm)*y + bet*(1-alph125)/Pibar*(z2125(+1) - p(+1));
z3125 = (1-bet*(1-alph125)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph125)*Pibar^(2*theta*(1-ppsi))*(z3125(+1) + 2*theta*(1-ppsi)*p(+1));
z4125 = (1-bet*(1-alph125)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph125)*Pibar^(theta*(1-ppsi))*(z4125(+1) + theta*(1-ppsi)*p(+1));

z1126 = (1-bet*(1-alph126)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph126)*Pibar^(theta*(1-ppsi)-1)*(z1126(+1)+(theta*(1-ppsi)-1)*p(+1));
z2126 = (1-bet*(1-alph126)/Pibar)*(1-sigm)*y + bet*(1-alph126)/Pibar*(z2126(+1) - p(+1));
z3126 = (1-bet*(1-alph126)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph126)*Pibar^(2*theta*(1-ppsi))*(z3126(+1) + 2*theta*(1-ppsi)*p(+1));
z4126 = (1-bet*(1-alph126)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph126)*Pibar^(theta*(1-ppsi))*(z4126(+1) + theta*(1-ppsi)*p(+1));

z1127 = (1-bet*(1-alph127)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph127)*Pibar^(theta*(1-ppsi)-1)*(z1127(+1)+(theta*(1-ppsi)-1)*p(+1));
z2127 = (1-bet*(1-alph127)/Pibar)*(1-sigm)*y + bet*(1-alph127)/Pibar*(z2127(+1) - p(+1));
z3127 = (1-bet*(1-alph127)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph127)*Pibar^(2*theta*(1-ppsi))*(z3127(+1) + 2*theta*(1-ppsi)*p(+1));
z4127 = (1-bet*(1-alph127)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph127)*Pibar^(theta*(1-ppsi))*(z4127(+1) + theta*(1-ppsi)*p(+1));

z1128 = (1-bet*(1-alph128)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph128)*Pibar^(theta*(1-ppsi)-1)*(z1128(+1)+(theta*(1-ppsi)-1)*p(+1));
z2128 = (1-bet*(1-alph128)/Pibar)*(1-sigm)*y + bet*(1-alph128)/Pibar*(z2128(+1) - p(+1));
z3128 = (1-bet*(1-alph128)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph128)*Pibar^(2*theta*(1-ppsi))*(z3128(+1) + 2*theta*(1-ppsi)*p(+1));
z4128 = (1-bet*(1-alph128)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph128)*Pibar^(theta*(1-ppsi))*(z4128(+1) + theta*(1-ppsi)*p(+1));

z1129 = (1-bet*(1-alph129)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph129)*Pibar^(theta*(1-ppsi)-1)*(z1129(+1)+(theta*(1-ppsi)-1)*p(+1));
z2129 = (1-bet*(1-alph129)/Pibar)*(1-sigm)*y + bet*(1-alph129)/Pibar*(z2129(+1) - p(+1));
z3129 = (1-bet*(1-alph129)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph129)*Pibar^(2*theta*(1-ppsi))*(z3129(+1) + 2*theta*(1-ppsi)*p(+1));
z4129 = (1-bet*(1-alph129)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph129)*Pibar^(theta*(1-ppsi))*(z4129(+1) + theta*(1-ppsi)*p(+1));

z1130 = (1-bet*(1-alph130)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph130)*Pibar^(theta*(1-ppsi)-1)*(z1130(+1)+(theta*(1-ppsi)-1)*p(+1));
z2130 = (1-bet*(1-alph130)/Pibar)*(1-sigm)*y + bet*(1-alph130)/Pibar*(z2130(+1) - p(+1));
z3130 = (1-bet*(1-alph130)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph130)*Pibar^(2*theta*(1-ppsi))*(z3130(+1) + 2*theta*(1-ppsi)*p(+1));
z4130 = (1-bet*(1-alph130)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph130)*Pibar^(theta*(1-ppsi))*(z4130(+1) + theta*(1-ppsi)*p(+1));

z1131 = (1-bet*(1-alph131)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph131)*Pibar^(theta*(1-ppsi)-1)*(z1131(+1)+(theta*(1-ppsi)-1)*p(+1));
z2131 = (1-bet*(1-alph131)/Pibar)*(1-sigm)*y + bet*(1-alph131)/Pibar*(z2131(+1) - p(+1));
z3131 = (1-bet*(1-alph131)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph131)*Pibar^(2*theta*(1-ppsi))*(z3131(+1) + 2*theta*(1-ppsi)*p(+1));
z4131 = (1-bet*(1-alph131)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph131)*Pibar^(theta*(1-ppsi))*(z4131(+1) + theta*(1-ppsi)*p(+1));

z1132 = (1-bet*(1-alph132)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph132)*Pibar^(theta*(1-ppsi)-1)*(z1132(+1)+(theta*(1-ppsi)-1)*p(+1));
z2132 = (1-bet*(1-alph132)/Pibar)*(1-sigm)*y + bet*(1-alph132)/Pibar*(z2132(+1) - p(+1));
z3132 = (1-bet*(1-alph132)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph132)*Pibar^(2*theta*(1-ppsi))*(z3132(+1) + 2*theta*(1-ppsi)*p(+1));
z4132 = (1-bet*(1-alph132)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph132)*Pibar^(theta*(1-ppsi))*(z4132(+1) + theta*(1-ppsi)*p(+1));

z1133 = (1-bet*(1-alph133)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph133)*Pibar^(theta*(1-ppsi)-1)*(z1133(+1)+(theta*(1-ppsi)-1)*p(+1));
z2133 = (1-bet*(1-alph133)/Pibar)*(1-sigm)*y + bet*(1-alph133)/Pibar*(z2133(+1) - p(+1));
z3133 = (1-bet*(1-alph133)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph133)*Pibar^(2*theta*(1-ppsi))*(z3133(+1) + 2*theta*(1-ppsi)*p(+1));
z4133 = (1-bet*(1-alph133)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph133)*Pibar^(theta*(1-ppsi))*(z4133(+1) + theta*(1-ppsi)*p(+1));

z1134 = (1-bet*(1-alph134)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph134)*Pibar^(theta*(1-ppsi)-1)*(z1134(+1)+(theta*(1-ppsi)-1)*p(+1));
z2134 = (1-bet*(1-alph134)/Pibar)*(1-sigm)*y + bet*(1-alph134)/Pibar*(z2134(+1) - p(+1));
z3134 = (1-bet*(1-alph134)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph134)*Pibar^(2*theta*(1-ppsi))*(z3134(+1) + 2*theta*(1-ppsi)*p(+1));
z4134 = (1-bet*(1-alph134)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph134)*Pibar^(theta*(1-ppsi))*(z4134(+1) + theta*(1-ppsi)*p(+1));

z1135 = (1-bet*(1-alph135)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph135)*Pibar^(theta*(1-ppsi)-1)*(z1135(+1)+(theta*(1-ppsi)-1)*p(+1));
z2135 = (1-bet*(1-alph135)/Pibar)*(1-sigm)*y + bet*(1-alph135)/Pibar*(z2135(+1) - p(+1));
z3135 = (1-bet*(1-alph135)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph135)*Pibar^(2*theta*(1-ppsi))*(z3135(+1) + 2*theta*(1-ppsi)*p(+1));
z4135 = (1-bet*(1-alph135)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph135)*Pibar^(theta*(1-ppsi))*(z4135(+1) + theta*(1-ppsi)*p(+1));

z1136 = (1-bet*(1-alph136)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph136)*Pibar^(theta*(1-ppsi)-1)*(z1136(+1)+(theta*(1-ppsi)-1)*p(+1));
z2136 = (1-bet*(1-alph136)/Pibar)*(1-sigm)*y + bet*(1-alph136)/Pibar*(z2136(+1) - p(+1));
z3136 = (1-bet*(1-alph136)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph136)*Pibar^(2*theta*(1-ppsi))*(z3136(+1) + 2*theta*(1-ppsi)*p(+1));
z4136 = (1-bet*(1-alph136)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph136)*Pibar^(theta*(1-ppsi))*(z4136(+1) + theta*(1-ppsi)*p(+1));

z1137 = (1-bet*(1-alph137)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph137)*Pibar^(theta*(1-ppsi)-1)*(z1137(+1)+(theta*(1-ppsi)-1)*p(+1));
z2137 = (1-bet*(1-alph137)/Pibar)*(1-sigm)*y + bet*(1-alph137)/Pibar*(z2137(+1) - p(+1));
z3137 = (1-bet*(1-alph137)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph137)*Pibar^(2*theta*(1-ppsi))*(z3137(+1) + 2*theta*(1-ppsi)*p(+1));
z4137 = (1-bet*(1-alph137)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph137)*Pibar^(theta*(1-ppsi))*(z4137(+1) + theta*(1-ppsi)*p(+1));

z1138 = (1-bet*(1-alph138)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph138)*Pibar^(theta*(1-ppsi)-1)*(z1138(+1)+(theta*(1-ppsi)-1)*p(+1));
z2138 = (1-bet*(1-alph138)/Pibar)*(1-sigm)*y + bet*(1-alph138)/Pibar*(z2138(+1) - p(+1));
z3138 = (1-bet*(1-alph138)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph138)*Pibar^(2*theta*(1-ppsi))*(z3138(+1) + 2*theta*(1-ppsi)*p(+1));
z4138 = (1-bet*(1-alph138)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph138)*Pibar^(theta*(1-ppsi))*(z4138(+1) + theta*(1-ppsi)*p(+1));

z1139 = (1-bet*(1-alph139)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph139)*Pibar^(theta*(1-ppsi)-1)*(z1139(+1)+(theta*(1-ppsi)-1)*p(+1));
z2139 = (1-bet*(1-alph139)/Pibar)*(1-sigm)*y + bet*(1-alph139)/Pibar*(z2139(+1) - p(+1));
z3139 = (1-bet*(1-alph139)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph139)*Pibar^(2*theta*(1-ppsi))*(z3139(+1) + 2*theta*(1-ppsi)*p(+1));
z4139 = (1-bet*(1-alph139)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph139)*Pibar^(theta*(1-ppsi))*(z4139(+1) + theta*(1-ppsi)*p(+1));

z1140 = (1-bet*(1-alph140)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph140)*Pibar^(theta*(1-ppsi)-1)*(z1140(+1)+(theta*(1-ppsi)-1)*p(+1));
z2140 = (1-bet*(1-alph140)/Pibar)*(1-sigm)*y + bet*(1-alph140)/Pibar*(z2140(+1) - p(+1));
z3140 = (1-bet*(1-alph140)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph140)*Pibar^(2*theta*(1-ppsi))*(z3140(+1) + 2*theta*(1-ppsi)*p(+1));
z4140 = (1-bet*(1-alph140)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph140)*Pibar^(theta*(1-ppsi))*(z4140(+1) + theta*(1-ppsi)*p(+1));

z1141 = (1-bet*(1-alph141)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph141)*Pibar^(theta*(1-ppsi)-1)*(z1141(+1)+(theta*(1-ppsi)-1)*p(+1));
z2141 = (1-bet*(1-alph141)/Pibar)*(1-sigm)*y + bet*(1-alph141)/Pibar*(z2141(+1) - p(+1));
z3141 = (1-bet*(1-alph141)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph141)*Pibar^(2*theta*(1-ppsi))*(z3141(+1) + 2*theta*(1-ppsi)*p(+1));
z4141 = (1-bet*(1-alph141)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph141)*Pibar^(theta*(1-ppsi))*(z4141(+1) + theta*(1-ppsi)*p(+1));

z1142 = (1-bet*(1-alph142)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph142)*Pibar^(theta*(1-ppsi)-1)*(z1142(+1)+(theta*(1-ppsi)-1)*p(+1));
z2142 = (1-bet*(1-alph142)/Pibar)*(1-sigm)*y + bet*(1-alph142)/Pibar*(z2142(+1) - p(+1));
z3142 = (1-bet*(1-alph142)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph142)*Pibar^(2*theta*(1-ppsi))*(z3142(+1) + 2*theta*(1-ppsi)*p(+1));
z4142 = (1-bet*(1-alph142)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph142)*Pibar^(theta*(1-ppsi))*(z4142(+1) + theta*(1-ppsi)*p(+1));

z1143 = (1-bet*(1-alph143)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph143)*Pibar^(theta*(1-ppsi)-1)*(z1143(+1)+(theta*(1-ppsi)-1)*p(+1));
z2143 = (1-bet*(1-alph143)/Pibar)*(1-sigm)*y + bet*(1-alph143)/Pibar*(z2143(+1) - p(+1));
z3143 = (1-bet*(1-alph143)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph143)*Pibar^(2*theta*(1-ppsi))*(z3143(+1) + 2*theta*(1-ppsi)*p(+1));
z4143 = (1-bet*(1-alph143)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph143)*Pibar^(theta*(1-ppsi))*(z4143(+1) + theta*(1-ppsi)*p(+1));

z1144 = (1-bet*(1-alph144)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph144)*Pibar^(theta*(1-ppsi)-1)*(z1144(+1)+(theta*(1-ppsi)-1)*p(+1));
z2144 = (1-bet*(1-alph144)/Pibar)*(1-sigm)*y + bet*(1-alph144)/Pibar*(z2144(+1) - p(+1));
z3144 = (1-bet*(1-alph144)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph144)*Pibar^(2*theta*(1-ppsi))*(z3144(+1) + 2*theta*(1-ppsi)*p(+1));
z4144 = (1-bet*(1-alph144)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph144)*Pibar^(theta*(1-ppsi))*(z4144(+1) + theta*(1-ppsi)*p(+1));

z1145 = (1-bet*(1-alph145)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph145)*Pibar^(theta*(1-ppsi)-1)*(z1145(+1)+(theta*(1-ppsi)-1)*p(+1));
z2145 = (1-bet*(1-alph145)/Pibar)*(1-sigm)*y + bet*(1-alph145)/Pibar*(z2145(+1) - p(+1));
z3145 = (1-bet*(1-alph145)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph145)*Pibar^(2*theta*(1-ppsi))*(z3145(+1) + 2*theta*(1-ppsi)*p(+1));
z4145 = (1-bet*(1-alph145)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph145)*Pibar^(theta*(1-ppsi))*(z4145(+1) + theta*(1-ppsi)*p(+1));

z1146 = (1-bet*(1-alph146)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph146)*Pibar^(theta*(1-ppsi)-1)*(z1146(+1)+(theta*(1-ppsi)-1)*p(+1));
z2146 = (1-bet*(1-alph146)/Pibar)*(1-sigm)*y + bet*(1-alph146)/Pibar*(z2146(+1) - p(+1));
z3146 = (1-bet*(1-alph146)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph146)*Pibar^(2*theta*(1-ppsi))*(z3146(+1) + 2*theta*(1-ppsi)*p(+1));
z4146 = (1-bet*(1-alph146)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph146)*Pibar^(theta*(1-ppsi))*(z4146(+1) + theta*(1-ppsi)*p(+1));

z1147 = (1-bet*(1-alph147)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph147)*Pibar^(theta*(1-ppsi)-1)*(z1147(+1)+(theta*(1-ppsi)-1)*p(+1));
z2147 = (1-bet*(1-alph147)/Pibar)*(1-sigm)*y + bet*(1-alph147)/Pibar*(z2147(+1) - p(+1));
z3147 = (1-bet*(1-alph147)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph147)*Pibar^(2*theta*(1-ppsi))*(z3147(+1) + 2*theta*(1-ppsi)*p(+1));
z4147 = (1-bet*(1-alph147)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph147)*Pibar^(theta*(1-ppsi))*(z4147(+1) + theta*(1-ppsi)*p(+1));

z1148 = (1-bet*(1-alph148)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph148)*Pibar^(theta*(1-ppsi)-1)*(z1148(+1)+(theta*(1-ppsi)-1)*p(+1));
z2148 = (1-bet*(1-alph148)/Pibar)*(1-sigm)*y + bet*(1-alph148)/Pibar*(z2148(+1) - p(+1));
z3148 = (1-bet*(1-alph148)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph148)*Pibar^(2*theta*(1-ppsi))*(z3148(+1) + 2*theta*(1-ppsi)*p(+1));
z4148 = (1-bet*(1-alph148)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph148)*Pibar^(theta*(1-ppsi))*(z4148(+1) + theta*(1-ppsi)*p(+1));

z1149 = (1-bet*(1-alph149)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph149)*Pibar^(theta*(1-ppsi)-1)*(z1149(+1)+(theta*(1-ppsi)-1)*p(+1));
z2149 = (1-bet*(1-alph149)/Pibar)*(1-sigm)*y + bet*(1-alph149)/Pibar*(z2149(+1) - p(+1));
z3149 = (1-bet*(1-alph149)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph149)*Pibar^(2*theta*(1-ppsi))*(z3149(+1) + 2*theta*(1-ppsi)*p(+1));
z4149 = (1-bet*(1-alph149)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph149)*Pibar^(theta*(1-ppsi))*(z4149(+1) + theta*(1-ppsi)*p(+1));

z1150 = (1-bet*(1-alph150)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph150)*Pibar^(theta*(1-ppsi)-1)*(z1150(+1)+(theta*(1-ppsi)-1)*p(+1));
z2150 = (1-bet*(1-alph150)/Pibar)*(1-sigm)*y + bet*(1-alph150)/Pibar*(z2150(+1) - p(+1));
z3150 = (1-bet*(1-alph150)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph150)*Pibar^(2*theta*(1-ppsi))*(z3150(+1) + 2*theta*(1-ppsi)*p(+1));
z4150 = (1-bet*(1-alph150)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph150)*Pibar^(theta*(1-ppsi))*(z4150(+1) + theta*(1-ppsi)*p(+1));

z1151 = (1-bet*(1-alph151)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph151)*Pibar^(theta*(1-ppsi)-1)*(z1151(+1)+(theta*(1-ppsi)-1)*p(+1));
z2151 = (1-bet*(1-alph151)/Pibar)*(1-sigm)*y + bet*(1-alph151)/Pibar*(z2151(+1) - p(+1));
z3151 = (1-bet*(1-alph151)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph151)*Pibar^(2*theta*(1-ppsi))*(z3151(+1) + 2*theta*(1-ppsi)*p(+1));
z4151 = (1-bet*(1-alph151)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph151)*Pibar^(theta*(1-ppsi))*(z4151(+1) + theta*(1-ppsi)*p(+1));

z1152 = (1-bet*(1-alph152)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph152)*Pibar^(theta*(1-ppsi)-1)*(z1152(+1)+(theta*(1-ppsi)-1)*p(+1));
z2152 = (1-bet*(1-alph152)/Pibar)*(1-sigm)*y + bet*(1-alph152)/Pibar*(z2152(+1) - p(+1));
z3152 = (1-bet*(1-alph152)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph152)*Pibar^(2*theta*(1-ppsi))*(z3152(+1) + 2*theta*(1-ppsi)*p(+1));
z4152 = (1-bet*(1-alph152)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph152)*Pibar^(theta*(1-ppsi))*(z4152(+1) + theta*(1-ppsi)*p(+1));

z1153 = (1-bet*(1-alph153)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph153)*Pibar^(theta*(1-ppsi)-1)*(z1153(+1)+(theta*(1-ppsi)-1)*p(+1));
z2153 = (1-bet*(1-alph153)/Pibar)*(1-sigm)*y + bet*(1-alph153)/Pibar*(z2153(+1) - p(+1));
z3153 = (1-bet*(1-alph153)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph153)*Pibar^(2*theta*(1-ppsi))*(z3153(+1) + 2*theta*(1-ppsi)*p(+1));
z4153 = (1-bet*(1-alph153)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph153)*Pibar^(theta*(1-ppsi))*(z4153(+1) + theta*(1-ppsi)*p(+1));

z1154 = (1-bet*(1-alph154)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph154)*Pibar^(theta*(1-ppsi)-1)*(z1154(+1)+(theta*(1-ppsi)-1)*p(+1));
z2154 = (1-bet*(1-alph154)/Pibar)*(1-sigm)*y + bet*(1-alph154)/Pibar*(z2154(+1) - p(+1));
z3154 = (1-bet*(1-alph154)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph154)*Pibar^(2*theta*(1-ppsi))*(z3154(+1) + 2*theta*(1-ppsi)*p(+1));
z4154 = (1-bet*(1-alph154)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph154)*Pibar^(theta*(1-ppsi))*(z4154(+1) + theta*(1-ppsi)*p(+1));

z1155 = (1-bet*(1-alph155)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph155)*Pibar^(theta*(1-ppsi)-1)*(z1155(+1)+(theta*(1-ppsi)-1)*p(+1));
z2155 = (1-bet*(1-alph155)/Pibar)*(1-sigm)*y + bet*(1-alph155)/Pibar*(z2155(+1) - p(+1));
z3155 = (1-bet*(1-alph155)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph155)*Pibar^(2*theta*(1-ppsi))*(z3155(+1) + 2*theta*(1-ppsi)*p(+1));
z4155 = (1-bet*(1-alph155)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph155)*Pibar^(theta*(1-ppsi))*(z4155(+1) + theta*(1-ppsi)*p(+1));

z1156 = (1-bet*(1-alph156)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph156)*Pibar^(theta*(1-ppsi)-1)*(z1156(+1)+(theta*(1-ppsi)-1)*p(+1));
z2156 = (1-bet*(1-alph156)/Pibar)*(1-sigm)*y + bet*(1-alph156)/Pibar*(z2156(+1) - p(+1));
z3156 = (1-bet*(1-alph156)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph156)*Pibar^(2*theta*(1-ppsi))*(z3156(+1) + 2*theta*(1-ppsi)*p(+1));
z4156 = (1-bet*(1-alph156)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph156)*Pibar^(theta*(1-ppsi))*(z4156(+1) + theta*(1-ppsi)*p(+1));

z1157 = (1-bet*(1-alph157)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph157)*Pibar^(theta*(1-ppsi)-1)*(z1157(+1)+(theta*(1-ppsi)-1)*p(+1));
z2157 = (1-bet*(1-alph157)/Pibar)*(1-sigm)*y + bet*(1-alph157)/Pibar*(z2157(+1) - p(+1));
z3157 = (1-bet*(1-alph157)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph157)*Pibar^(2*theta*(1-ppsi))*(z3157(+1) + 2*theta*(1-ppsi)*p(+1));
z4157 = (1-bet*(1-alph157)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph157)*Pibar^(theta*(1-ppsi))*(z4157(+1) + theta*(1-ppsi)*p(+1));

z1158 = (1-bet*(1-alph158)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph158)*Pibar^(theta*(1-ppsi)-1)*(z1158(+1)+(theta*(1-ppsi)-1)*p(+1));
z2158 = (1-bet*(1-alph158)/Pibar)*(1-sigm)*y + bet*(1-alph158)/Pibar*(z2158(+1) - p(+1));
z3158 = (1-bet*(1-alph158)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph158)*Pibar^(2*theta*(1-ppsi))*(z3158(+1) + 2*theta*(1-ppsi)*p(+1));
z4158 = (1-bet*(1-alph158)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph158)*Pibar^(theta*(1-ppsi))*(z4158(+1) + theta*(1-ppsi)*p(+1));

z1159 = (1-bet*(1-alph159)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph159)*Pibar^(theta*(1-ppsi)-1)*(z1159(+1)+(theta*(1-ppsi)-1)*p(+1));
z2159 = (1-bet*(1-alph159)/Pibar)*(1-sigm)*y + bet*(1-alph159)/Pibar*(z2159(+1) - p(+1));
z3159 = (1-bet*(1-alph159)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph159)*Pibar^(2*theta*(1-ppsi))*(z3159(+1) + 2*theta*(1-ppsi)*p(+1));
z4159 = (1-bet*(1-alph159)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph159)*Pibar^(theta*(1-ppsi))*(z4159(+1) + theta*(1-ppsi)*p(+1));

z1160 = (1-bet*(1-alph160)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph160)*Pibar^(theta*(1-ppsi)-1)*(z1160(+1)+(theta*(1-ppsi)-1)*p(+1));
z2160 = (1-bet*(1-alph160)/Pibar)*(1-sigm)*y + bet*(1-alph160)/Pibar*(z2160(+1) - p(+1));
z3160 = (1-bet*(1-alph160)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph160)*Pibar^(2*theta*(1-ppsi))*(z3160(+1) + 2*theta*(1-ppsi)*p(+1));
z4160 = (1-bet*(1-alph160)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph160)*Pibar^(theta*(1-ppsi))*(z4160(+1) + theta*(1-ppsi)*p(+1));

z1161 = (1-bet*(1-alph161)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph161)*Pibar^(theta*(1-ppsi)-1)*(z1161(+1)+(theta*(1-ppsi)-1)*p(+1));
z2161 = (1-bet*(1-alph161)/Pibar)*(1-sigm)*y + bet*(1-alph161)/Pibar*(z2161(+1) - p(+1));
z3161 = (1-bet*(1-alph161)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph161)*Pibar^(2*theta*(1-ppsi))*(z3161(+1) + 2*theta*(1-ppsi)*p(+1));
z4161 = (1-bet*(1-alph161)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph161)*Pibar^(theta*(1-ppsi))*(z4161(+1) + theta*(1-ppsi)*p(+1));

z1162 = (1-bet*(1-alph162)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph162)*Pibar^(theta*(1-ppsi)-1)*(z1162(+1)+(theta*(1-ppsi)-1)*p(+1));
z2162 = (1-bet*(1-alph162)/Pibar)*(1-sigm)*y + bet*(1-alph162)/Pibar*(z2162(+1) - p(+1));
z3162 = (1-bet*(1-alph162)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph162)*Pibar^(2*theta*(1-ppsi))*(z3162(+1) + 2*theta*(1-ppsi)*p(+1));
z4162 = (1-bet*(1-alph162)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph162)*Pibar^(theta*(1-ppsi))*(z4162(+1) + theta*(1-ppsi)*p(+1));

z1163 = (1-bet*(1-alph163)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph163)*Pibar^(theta*(1-ppsi)-1)*(z1163(+1)+(theta*(1-ppsi)-1)*p(+1));
z2163 = (1-bet*(1-alph163)/Pibar)*(1-sigm)*y + bet*(1-alph163)/Pibar*(z2163(+1) - p(+1));
z3163 = (1-bet*(1-alph163)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph163)*Pibar^(2*theta*(1-ppsi))*(z3163(+1) + 2*theta*(1-ppsi)*p(+1));
z4163 = (1-bet*(1-alph163)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph163)*Pibar^(theta*(1-ppsi))*(z4163(+1) + theta*(1-ppsi)*p(+1));

z1164 = (1-bet*(1-alph164)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph164)*Pibar^(theta*(1-ppsi)-1)*(z1164(+1)+(theta*(1-ppsi)-1)*p(+1));
z2164 = (1-bet*(1-alph164)/Pibar)*(1-sigm)*y + bet*(1-alph164)/Pibar*(z2164(+1) - p(+1));
z3164 = (1-bet*(1-alph164)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph164)*Pibar^(2*theta*(1-ppsi))*(z3164(+1) + 2*theta*(1-ppsi)*p(+1));
z4164 = (1-bet*(1-alph164)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph164)*Pibar^(theta*(1-ppsi))*(z4164(+1) + theta*(1-ppsi)*p(+1));

z1165 = (1-bet*(1-alph165)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph165)*Pibar^(theta*(1-ppsi)-1)*(z1165(+1)+(theta*(1-ppsi)-1)*p(+1));
z2165 = (1-bet*(1-alph165)/Pibar)*(1-sigm)*y + bet*(1-alph165)/Pibar*(z2165(+1) - p(+1));
z3165 = (1-bet*(1-alph165)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph165)*Pibar^(2*theta*(1-ppsi))*(z3165(+1) + 2*theta*(1-ppsi)*p(+1));
z4165 = (1-bet*(1-alph165)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph165)*Pibar^(theta*(1-ppsi))*(z4165(+1) + theta*(1-ppsi)*p(+1));

z1166 = (1-bet*(1-alph166)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph166)*Pibar^(theta*(1-ppsi)-1)*(z1166(+1)+(theta*(1-ppsi)-1)*p(+1));
z2166 = (1-bet*(1-alph166)/Pibar)*(1-sigm)*y + bet*(1-alph166)/Pibar*(z2166(+1) - p(+1));
z3166 = (1-bet*(1-alph166)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph166)*Pibar^(2*theta*(1-ppsi))*(z3166(+1) + 2*theta*(1-ppsi)*p(+1));
z4166 = (1-bet*(1-alph166)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph166)*Pibar^(theta*(1-ppsi))*(z4166(+1) + theta*(1-ppsi)*p(+1));

z1167 = (1-bet*(1-alph167)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph167)*Pibar^(theta*(1-ppsi)-1)*(z1167(+1)+(theta*(1-ppsi)-1)*p(+1));
z2167 = (1-bet*(1-alph167)/Pibar)*(1-sigm)*y + bet*(1-alph167)/Pibar*(z2167(+1) - p(+1));
z3167 = (1-bet*(1-alph167)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph167)*Pibar^(2*theta*(1-ppsi))*(z3167(+1) + 2*theta*(1-ppsi)*p(+1));
z4167 = (1-bet*(1-alph167)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph167)*Pibar^(theta*(1-ppsi))*(z4167(+1) + theta*(1-ppsi)*p(+1));

z1168 = (1-bet*(1-alph168)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph168)*Pibar^(theta*(1-ppsi)-1)*(z1168(+1)+(theta*(1-ppsi)-1)*p(+1));
z2168 = (1-bet*(1-alph168)/Pibar)*(1-sigm)*y + bet*(1-alph168)/Pibar*(z2168(+1) - p(+1));
z3168 = (1-bet*(1-alph168)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph168)*Pibar^(2*theta*(1-ppsi))*(z3168(+1) + 2*theta*(1-ppsi)*p(+1));
z4168 = (1-bet*(1-alph168)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph168)*Pibar^(theta*(1-ppsi))*(z4168(+1) + theta*(1-ppsi)*p(+1));

z1169 = (1-bet*(1-alph169)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph169)*Pibar^(theta*(1-ppsi)-1)*(z1169(+1)+(theta*(1-ppsi)-1)*p(+1));
z2169 = (1-bet*(1-alph169)/Pibar)*(1-sigm)*y + bet*(1-alph169)/Pibar*(z2169(+1) - p(+1));
z3169 = (1-bet*(1-alph169)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph169)*Pibar^(2*theta*(1-ppsi))*(z3169(+1) + 2*theta*(1-ppsi)*p(+1));
z4169 = (1-bet*(1-alph169)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph169)*Pibar^(theta*(1-ppsi))*(z4169(+1) + theta*(1-ppsi)*p(+1));

z1170 = (1-bet*(1-alph170)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph170)*Pibar^(theta*(1-ppsi)-1)*(z1170(+1)+(theta*(1-ppsi)-1)*p(+1));
z2170 = (1-bet*(1-alph170)/Pibar)*(1-sigm)*y + bet*(1-alph170)/Pibar*(z2170(+1) - p(+1));
z3170 = (1-bet*(1-alph170)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph170)*Pibar^(2*theta*(1-ppsi))*(z3170(+1) + 2*theta*(1-ppsi)*p(+1));
z4170 = (1-bet*(1-alph170)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph170)*Pibar^(theta*(1-ppsi))*(z4170(+1) + theta*(1-ppsi)*p(+1));

z1171 = (1-bet*(1-alph171)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph171)*Pibar^(theta*(1-ppsi)-1)*(z1171(+1)+(theta*(1-ppsi)-1)*p(+1));
z2171 = (1-bet*(1-alph171)/Pibar)*(1-sigm)*y + bet*(1-alph171)/Pibar*(z2171(+1) - p(+1));
z3171 = (1-bet*(1-alph171)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph171)*Pibar^(2*theta*(1-ppsi))*(z3171(+1) + 2*theta*(1-ppsi)*p(+1));
z4171 = (1-bet*(1-alph171)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph171)*Pibar^(theta*(1-ppsi))*(z4171(+1) + theta*(1-ppsi)*p(+1));

z1172 = (1-bet*(1-alph172)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph172)*Pibar^(theta*(1-ppsi)-1)*(z1172(+1)+(theta*(1-ppsi)-1)*p(+1));
z2172 = (1-bet*(1-alph172)/Pibar)*(1-sigm)*y + bet*(1-alph172)/Pibar*(z2172(+1) - p(+1));
z3172 = (1-bet*(1-alph172)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph172)*Pibar^(2*theta*(1-ppsi))*(z3172(+1) + 2*theta*(1-ppsi)*p(+1));
z4172 = (1-bet*(1-alph172)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph172)*Pibar^(theta*(1-ppsi))*(z4172(+1) + theta*(1-ppsi)*p(+1));

z1173 = (1-bet*(1-alph173)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph173)*Pibar^(theta*(1-ppsi)-1)*(z1173(+1)+(theta*(1-ppsi)-1)*p(+1));
z2173 = (1-bet*(1-alph173)/Pibar)*(1-sigm)*y + bet*(1-alph173)/Pibar*(z2173(+1) - p(+1));
z3173 = (1-bet*(1-alph173)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph173)*Pibar^(2*theta*(1-ppsi))*(z3173(+1) + 2*theta*(1-ppsi)*p(+1));
z4173 = (1-bet*(1-alph173)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph173)*Pibar^(theta*(1-ppsi))*(z4173(+1) + theta*(1-ppsi)*p(+1));

z1174 = (1-bet*(1-alph174)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph174)*Pibar^(theta*(1-ppsi)-1)*(z1174(+1)+(theta*(1-ppsi)-1)*p(+1));
z2174 = (1-bet*(1-alph174)/Pibar)*(1-sigm)*y + bet*(1-alph174)/Pibar*(z2174(+1) - p(+1));
z3174 = (1-bet*(1-alph174)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph174)*Pibar^(2*theta*(1-ppsi))*(z3174(+1) + 2*theta*(1-ppsi)*p(+1));
z4174 = (1-bet*(1-alph174)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph174)*Pibar^(theta*(1-ppsi))*(z4174(+1) + theta*(1-ppsi)*p(+1));

z1175 = (1-bet*(1-alph175)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph175)*Pibar^(theta*(1-ppsi)-1)*(z1175(+1)+(theta*(1-ppsi)-1)*p(+1));
z2175 = (1-bet*(1-alph175)/Pibar)*(1-sigm)*y + bet*(1-alph175)/Pibar*(z2175(+1) - p(+1));
z3175 = (1-bet*(1-alph175)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph175)*Pibar^(2*theta*(1-ppsi))*(z3175(+1) + 2*theta*(1-ppsi)*p(+1));
z4175 = (1-bet*(1-alph175)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph175)*Pibar^(theta*(1-ppsi))*(z4175(+1) + theta*(1-ppsi)*p(+1));

z1176 = (1-bet*(1-alph176)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph176)*Pibar^(theta*(1-ppsi)-1)*(z1176(+1)+(theta*(1-ppsi)-1)*p(+1));
z2176 = (1-bet*(1-alph176)/Pibar)*(1-sigm)*y + bet*(1-alph176)/Pibar*(z2176(+1) - p(+1));
z3176 = (1-bet*(1-alph176)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph176)*Pibar^(2*theta*(1-ppsi))*(z3176(+1) + 2*theta*(1-ppsi)*p(+1));
z4176 = (1-bet*(1-alph176)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph176)*Pibar^(theta*(1-ppsi))*(z4176(+1) + theta*(1-ppsi)*p(+1));

z1177 = (1-bet*(1-alph177)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph177)*Pibar^(theta*(1-ppsi)-1)*(z1177(+1)+(theta*(1-ppsi)-1)*p(+1));
z2177 = (1-bet*(1-alph177)/Pibar)*(1-sigm)*y + bet*(1-alph177)/Pibar*(z2177(+1) - p(+1));
z3177 = (1-bet*(1-alph177)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph177)*Pibar^(2*theta*(1-ppsi))*(z3177(+1) + 2*theta*(1-ppsi)*p(+1));
z4177 = (1-bet*(1-alph177)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph177)*Pibar^(theta*(1-ppsi))*(z4177(+1) + theta*(1-ppsi)*p(+1));

z1178 = (1-bet*(1-alph178)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph178)*Pibar^(theta*(1-ppsi)-1)*(z1178(+1)+(theta*(1-ppsi)-1)*p(+1));
z2178 = (1-bet*(1-alph178)/Pibar)*(1-sigm)*y + bet*(1-alph178)/Pibar*(z2178(+1) - p(+1));
z3178 = (1-bet*(1-alph178)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph178)*Pibar^(2*theta*(1-ppsi))*(z3178(+1) + 2*theta*(1-ppsi)*p(+1));
z4178 = (1-bet*(1-alph178)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph178)*Pibar^(theta*(1-ppsi))*(z4178(+1) + theta*(1-ppsi)*p(+1));

z1179 = (1-bet*(1-alph179)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph179)*Pibar^(theta*(1-ppsi)-1)*(z1179(+1)+(theta*(1-ppsi)-1)*p(+1));
z2179 = (1-bet*(1-alph179)/Pibar)*(1-sigm)*y + bet*(1-alph179)/Pibar*(z2179(+1) - p(+1));
z3179 = (1-bet*(1-alph179)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph179)*Pibar^(2*theta*(1-ppsi))*(z3179(+1) + 2*theta*(1-ppsi)*p(+1));
z4179 = (1-bet*(1-alph179)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph179)*Pibar^(theta*(1-ppsi))*(z4179(+1) + theta*(1-ppsi)*p(+1));

z1180 = (1-bet*(1-alph180)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph180)*Pibar^(theta*(1-ppsi)-1)*(z1180(+1)+(theta*(1-ppsi)-1)*p(+1));
z2180 = (1-bet*(1-alph180)/Pibar)*(1-sigm)*y + bet*(1-alph180)/Pibar*(z2180(+1) - p(+1));
z3180 = (1-bet*(1-alph180)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph180)*Pibar^(2*theta*(1-ppsi))*(z3180(+1) + 2*theta*(1-ppsi)*p(+1));
z4180 = (1-bet*(1-alph180)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph180)*Pibar^(theta*(1-ppsi))*(z4180(+1) + theta*(1-ppsi)*p(+1));

z1181 = (1-bet*(1-alph181)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph181)*Pibar^(theta*(1-ppsi)-1)*(z1181(+1)+(theta*(1-ppsi)-1)*p(+1));
z2181 = (1-bet*(1-alph181)/Pibar)*(1-sigm)*y + bet*(1-alph181)/Pibar*(z2181(+1) - p(+1));
z3181 = (1-bet*(1-alph181)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph181)*Pibar^(2*theta*(1-ppsi))*(z3181(+1) + 2*theta*(1-ppsi)*p(+1));
z4181 = (1-bet*(1-alph181)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph181)*Pibar^(theta*(1-ppsi))*(z4181(+1) + theta*(1-ppsi)*p(+1));

z1182 = (1-bet*(1-alph182)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph182)*Pibar^(theta*(1-ppsi)-1)*(z1182(+1)+(theta*(1-ppsi)-1)*p(+1));
z2182 = (1-bet*(1-alph182)/Pibar)*(1-sigm)*y + bet*(1-alph182)/Pibar*(z2182(+1) - p(+1));
z3182 = (1-bet*(1-alph182)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph182)*Pibar^(2*theta*(1-ppsi))*(z3182(+1) + 2*theta*(1-ppsi)*p(+1));
z4182 = (1-bet*(1-alph182)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph182)*Pibar^(theta*(1-ppsi))*(z4182(+1) + theta*(1-ppsi)*p(+1));

z1183 = (1-bet*(1-alph183)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph183)*Pibar^(theta*(1-ppsi)-1)*(z1183(+1)+(theta*(1-ppsi)-1)*p(+1));
z2183 = (1-bet*(1-alph183)/Pibar)*(1-sigm)*y + bet*(1-alph183)/Pibar*(z2183(+1) - p(+1));
z3183 = (1-bet*(1-alph183)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph183)*Pibar^(2*theta*(1-ppsi))*(z3183(+1) + 2*theta*(1-ppsi)*p(+1));
z4183 = (1-bet*(1-alph183)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph183)*Pibar^(theta*(1-ppsi))*(z4183(+1) + theta*(1-ppsi)*p(+1));

z1184 = (1-bet*(1-alph184)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph184)*Pibar^(theta*(1-ppsi)-1)*(z1184(+1)+(theta*(1-ppsi)-1)*p(+1));
z2184 = (1-bet*(1-alph184)/Pibar)*(1-sigm)*y + bet*(1-alph184)/Pibar*(z2184(+1) - p(+1));
z3184 = (1-bet*(1-alph184)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph184)*Pibar^(2*theta*(1-ppsi))*(z3184(+1) + 2*theta*(1-ppsi)*p(+1));
z4184 = (1-bet*(1-alph184)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph184)*Pibar^(theta*(1-ppsi))*(z4184(+1) + theta*(1-ppsi)*p(+1));

z1185 = (1-bet*(1-alph185)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph185)*Pibar^(theta*(1-ppsi)-1)*(z1185(+1)+(theta*(1-ppsi)-1)*p(+1));
z2185 = (1-bet*(1-alph185)/Pibar)*(1-sigm)*y + bet*(1-alph185)/Pibar*(z2185(+1) - p(+1));
z3185 = (1-bet*(1-alph185)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph185)*Pibar^(2*theta*(1-ppsi))*(z3185(+1) + 2*theta*(1-ppsi)*p(+1));
z4185 = (1-bet*(1-alph185)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph185)*Pibar^(theta*(1-ppsi))*(z4185(+1) + theta*(1-ppsi)*p(+1));

z1186 = (1-bet*(1-alph186)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph186)*Pibar^(theta*(1-ppsi)-1)*(z1186(+1)+(theta*(1-ppsi)-1)*p(+1));
z2186 = (1-bet*(1-alph186)/Pibar)*(1-sigm)*y + bet*(1-alph186)/Pibar*(z2186(+1) - p(+1));
z3186 = (1-bet*(1-alph186)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph186)*Pibar^(2*theta*(1-ppsi))*(z3186(+1) + 2*theta*(1-ppsi)*p(+1));
z4186 = (1-bet*(1-alph186)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph186)*Pibar^(theta*(1-ppsi))*(z4186(+1) + theta*(1-ppsi)*p(+1));

z1187 = (1-bet*(1-alph187)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph187)*Pibar^(theta*(1-ppsi)-1)*(z1187(+1)+(theta*(1-ppsi)-1)*p(+1));
z2187 = (1-bet*(1-alph187)/Pibar)*(1-sigm)*y + bet*(1-alph187)/Pibar*(z2187(+1) - p(+1));
z3187 = (1-bet*(1-alph187)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph187)*Pibar^(2*theta*(1-ppsi))*(z3187(+1) + 2*theta*(1-ppsi)*p(+1));
z4187 = (1-bet*(1-alph187)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph187)*Pibar^(theta*(1-ppsi))*(z4187(+1) + theta*(1-ppsi)*p(+1));

z1188 = (1-bet*(1-alph188)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph188)*Pibar^(theta*(1-ppsi)-1)*(z1188(+1)+(theta*(1-ppsi)-1)*p(+1));
z2188 = (1-bet*(1-alph188)/Pibar)*(1-sigm)*y + bet*(1-alph188)/Pibar*(z2188(+1) - p(+1));
z3188 = (1-bet*(1-alph188)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph188)*Pibar^(2*theta*(1-ppsi))*(z3188(+1) + 2*theta*(1-ppsi)*p(+1));
z4188 = (1-bet*(1-alph188)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph188)*Pibar^(theta*(1-ppsi))*(z4188(+1) + theta*(1-ppsi)*p(+1));

z1189 = (1-bet*(1-alph189)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph189)*Pibar^(theta*(1-ppsi)-1)*(z1189(+1)+(theta*(1-ppsi)-1)*p(+1));
z2189 = (1-bet*(1-alph189)/Pibar)*(1-sigm)*y + bet*(1-alph189)/Pibar*(z2189(+1) - p(+1));
z3189 = (1-bet*(1-alph189)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph189)*Pibar^(2*theta*(1-ppsi))*(z3189(+1) + 2*theta*(1-ppsi)*p(+1));
z4189 = (1-bet*(1-alph189)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph189)*Pibar^(theta*(1-ppsi))*(z4189(+1) + theta*(1-ppsi)*p(+1));

z1190 = (1-bet*(1-alph190)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph190)*Pibar^(theta*(1-ppsi)-1)*(z1190(+1)+(theta*(1-ppsi)-1)*p(+1));
z2190 = (1-bet*(1-alph190)/Pibar)*(1-sigm)*y + bet*(1-alph190)/Pibar*(z2190(+1) - p(+1));
z3190 = (1-bet*(1-alph190)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph190)*Pibar^(2*theta*(1-ppsi))*(z3190(+1) + 2*theta*(1-ppsi)*p(+1));
z4190 = (1-bet*(1-alph190)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph190)*Pibar^(theta*(1-ppsi))*(z4190(+1) + theta*(1-ppsi)*p(+1));

z1191 = (1-bet*(1-alph191)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph191)*Pibar^(theta*(1-ppsi)-1)*(z1191(+1)+(theta*(1-ppsi)-1)*p(+1));
z2191 = (1-bet*(1-alph191)/Pibar)*(1-sigm)*y + bet*(1-alph191)/Pibar*(z2191(+1) - p(+1));
z3191 = (1-bet*(1-alph191)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph191)*Pibar^(2*theta*(1-ppsi))*(z3191(+1) + 2*theta*(1-ppsi)*p(+1));
z4191 = (1-bet*(1-alph191)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph191)*Pibar^(theta*(1-ppsi))*(z4191(+1) + theta*(1-ppsi)*p(+1));

z1192 = (1-bet*(1-alph192)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph192)*Pibar^(theta*(1-ppsi)-1)*(z1192(+1)+(theta*(1-ppsi)-1)*p(+1));
z2192 = (1-bet*(1-alph192)/Pibar)*(1-sigm)*y + bet*(1-alph192)/Pibar*(z2192(+1) - p(+1));
z3192 = (1-bet*(1-alph192)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph192)*Pibar^(2*theta*(1-ppsi))*(z3192(+1) + 2*theta*(1-ppsi)*p(+1));
z4192 = (1-bet*(1-alph192)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph192)*Pibar^(theta*(1-ppsi))*(z4192(+1) + theta*(1-ppsi)*p(+1));

z1193 = (1-bet*(1-alph193)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph193)*Pibar^(theta*(1-ppsi)-1)*(z1193(+1)+(theta*(1-ppsi)-1)*p(+1));
z2193 = (1-bet*(1-alph193)/Pibar)*(1-sigm)*y + bet*(1-alph193)/Pibar*(z2193(+1) - p(+1));
z3193 = (1-bet*(1-alph193)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph193)*Pibar^(2*theta*(1-ppsi))*(z3193(+1) + 2*theta*(1-ppsi)*p(+1));
z4193 = (1-bet*(1-alph193)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph193)*Pibar^(theta*(1-ppsi))*(z4193(+1) + theta*(1-ppsi)*p(+1));

z1194 = (1-bet*(1-alph194)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph194)*Pibar^(theta*(1-ppsi)-1)*(z1194(+1)+(theta*(1-ppsi)-1)*p(+1));
z2194 = (1-bet*(1-alph194)/Pibar)*(1-sigm)*y + bet*(1-alph194)/Pibar*(z2194(+1) - p(+1));
z3194 = (1-bet*(1-alph194)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph194)*Pibar^(2*theta*(1-ppsi))*(z3194(+1) + 2*theta*(1-ppsi)*p(+1));
z4194 = (1-bet*(1-alph194)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph194)*Pibar^(theta*(1-ppsi))*(z4194(+1) + theta*(1-ppsi)*p(+1));

z1195 = (1-bet*(1-alph195)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph195)*Pibar^(theta*(1-ppsi)-1)*(z1195(+1)+(theta*(1-ppsi)-1)*p(+1));
z2195 = (1-bet*(1-alph195)/Pibar)*(1-sigm)*y + bet*(1-alph195)/Pibar*(z2195(+1) - p(+1));
z3195 = (1-bet*(1-alph195)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph195)*Pibar^(2*theta*(1-ppsi))*(z3195(+1) + 2*theta*(1-ppsi)*p(+1));
z4195 = (1-bet*(1-alph195)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph195)*Pibar^(theta*(1-ppsi))*(z4195(+1) + theta*(1-ppsi)*p(+1));

z1196 = (1-bet*(1-alph196)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph196)*Pibar^(theta*(1-ppsi)-1)*(z1196(+1)+(theta*(1-ppsi)-1)*p(+1));
z2196 = (1-bet*(1-alph196)/Pibar)*(1-sigm)*y + bet*(1-alph196)/Pibar*(z2196(+1) - p(+1));
z3196 = (1-bet*(1-alph196)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph196)*Pibar^(2*theta*(1-ppsi))*(z3196(+1) + 2*theta*(1-ppsi)*p(+1));
z4196 = (1-bet*(1-alph196)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph196)*Pibar^(theta*(1-ppsi))*(z4196(+1) + theta*(1-ppsi)*p(+1));

z1197 = (1-bet*(1-alph197)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph197)*Pibar^(theta*(1-ppsi)-1)*(z1197(+1)+(theta*(1-ppsi)-1)*p(+1));
z2197 = (1-bet*(1-alph197)/Pibar)*(1-sigm)*y + bet*(1-alph197)/Pibar*(z2197(+1) - p(+1));
z3197 = (1-bet*(1-alph197)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph197)*Pibar^(2*theta*(1-ppsi))*(z3197(+1) + 2*theta*(1-ppsi)*p(+1));
z4197 = (1-bet*(1-alph197)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph197)*Pibar^(theta*(1-ppsi))*(z4197(+1) + theta*(1-ppsi)*p(+1));

z1198 = (1-bet*(1-alph198)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph198)*Pibar^(theta*(1-ppsi)-1)*(z1198(+1)+(theta*(1-ppsi)-1)*p(+1));
z2198 = (1-bet*(1-alph198)/Pibar)*(1-sigm)*y + bet*(1-alph198)/Pibar*(z2198(+1) - p(+1));
z3198 = (1-bet*(1-alph198)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph198)*Pibar^(2*theta*(1-ppsi))*(z3198(+1) + 2*theta*(1-ppsi)*p(+1));
z4198 = (1-bet*(1-alph198)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph198)*Pibar^(theta*(1-ppsi))*(z4198(+1) + theta*(1-ppsi)*p(+1));

z1199 = (1-bet*(1-alph199)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph199)*Pibar^(theta*(1-ppsi)-1)*(z1199(+1)+(theta*(1-ppsi)-1)*p(+1));
z2199 = (1-bet*(1-alph199)/Pibar)*(1-sigm)*y + bet*(1-alph199)/Pibar*(z2199(+1) - p(+1));
z3199 = (1-bet*(1-alph199)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph199)*Pibar^(2*theta*(1-ppsi))*(z3199(+1) + 2*theta*(1-ppsi)*p(+1));
z4199 = (1-bet*(1-alph199)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph199)*Pibar^(theta*(1-ppsi))*(z4199(+1) + theta*(1-ppsi)*p(+1));

z1200 = (1-bet*(1-alph200)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph200)*Pibar^(theta*(1-ppsi)-1)*(z1200(+1)+(theta*(1-ppsi)-1)*p(+1));
z2200 = (1-bet*(1-alph200)/Pibar)*(1-sigm)*y + bet*(1-alph200)/Pibar*(z2200(+1) - p(+1));
z3200 = (1-bet*(1-alph200)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph200)*Pibar^(2*theta*(1-ppsi))*(z3200(+1) + 2*theta*(1-ppsi)*p(+1));
z4200 = (1-bet*(1-alph200)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph200)*Pibar^(theta*(1-ppsi))*(z4200(+1) + theta*(1-ppsi)*p(+1));

z1201 = (1-bet*(1-alph201)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph201)*Pibar^(theta*(1-ppsi)-1)*(z1201(+1)+(theta*(1-ppsi)-1)*p(+1));
z2201 = (1-bet*(1-alph201)/Pibar)*(1-sigm)*y + bet*(1-alph201)/Pibar*(z2201(+1) - p(+1));
z3201 = (1-bet*(1-alph201)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph201)*Pibar^(2*theta*(1-ppsi))*(z3201(+1) + 2*theta*(1-ppsi)*p(+1));
z4201 = (1-bet*(1-alph201)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph201)*Pibar^(theta*(1-ppsi))*(z4201(+1) + theta*(1-ppsi)*p(+1));

z1202 = (1-bet*(1-alph202)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph202)*Pibar^(theta*(1-ppsi)-1)*(z1202(+1)+(theta*(1-ppsi)-1)*p(+1));
z2202 = (1-bet*(1-alph202)/Pibar)*(1-sigm)*y + bet*(1-alph202)/Pibar*(z2202(+1) - p(+1));
z3202 = (1-bet*(1-alph202)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph202)*Pibar^(2*theta*(1-ppsi))*(z3202(+1) + 2*theta*(1-ppsi)*p(+1));
z4202 = (1-bet*(1-alph202)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph202)*Pibar^(theta*(1-ppsi))*(z4202(+1) + theta*(1-ppsi)*p(+1));

z1203 = (1-bet*(1-alph203)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph203)*Pibar^(theta*(1-ppsi)-1)*(z1203(+1)+(theta*(1-ppsi)-1)*p(+1));
z2203 = (1-bet*(1-alph203)/Pibar)*(1-sigm)*y + bet*(1-alph203)/Pibar*(z2203(+1) - p(+1));
z3203 = (1-bet*(1-alph203)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph203)*Pibar^(2*theta*(1-ppsi))*(z3203(+1) + 2*theta*(1-ppsi)*p(+1));
z4203 = (1-bet*(1-alph203)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph203)*Pibar^(theta*(1-ppsi))*(z4203(+1) + theta*(1-ppsi)*p(+1));

z1204 = (1-bet*(1-alph204)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph204)*Pibar^(theta*(1-ppsi)-1)*(z1204(+1)+(theta*(1-ppsi)-1)*p(+1));
z2204 = (1-bet*(1-alph204)/Pibar)*(1-sigm)*y + bet*(1-alph204)/Pibar*(z2204(+1) - p(+1));
z3204 = (1-bet*(1-alph204)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph204)*Pibar^(2*theta*(1-ppsi))*(z3204(+1) + 2*theta*(1-ppsi)*p(+1));
z4204 = (1-bet*(1-alph204)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph204)*Pibar^(theta*(1-ppsi))*(z4204(+1) + theta*(1-ppsi)*p(+1));

z1205 = (1-bet*(1-alph205)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph205)*Pibar^(theta*(1-ppsi)-1)*(z1205(+1)+(theta*(1-ppsi)-1)*p(+1));
z2205 = (1-bet*(1-alph205)/Pibar)*(1-sigm)*y + bet*(1-alph205)/Pibar*(z2205(+1) - p(+1));
z3205 = (1-bet*(1-alph205)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph205)*Pibar^(2*theta*(1-ppsi))*(z3205(+1) + 2*theta*(1-ppsi)*p(+1));
z4205 = (1-bet*(1-alph205)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph205)*Pibar^(theta*(1-ppsi))*(z4205(+1) + theta*(1-ppsi)*p(+1));

z1206 = (1-bet*(1-alph206)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph206)*Pibar^(theta*(1-ppsi)-1)*(z1206(+1)+(theta*(1-ppsi)-1)*p(+1));
z2206 = (1-bet*(1-alph206)/Pibar)*(1-sigm)*y + bet*(1-alph206)/Pibar*(z2206(+1) - p(+1));
z3206 = (1-bet*(1-alph206)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph206)*Pibar^(2*theta*(1-ppsi))*(z3206(+1) + 2*theta*(1-ppsi)*p(+1));
z4206 = (1-bet*(1-alph206)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph206)*Pibar^(theta*(1-ppsi))*(z4206(+1) + theta*(1-ppsi)*p(+1));

z1207 = (1-bet*(1-alph207)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph207)*Pibar^(theta*(1-ppsi)-1)*(z1207(+1)+(theta*(1-ppsi)-1)*p(+1));
z2207 = (1-bet*(1-alph207)/Pibar)*(1-sigm)*y + bet*(1-alph207)/Pibar*(z2207(+1) - p(+1));
z3207 = (1-bet*(1-alph207)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph207)*Pibar^(2*theta*(1-ppsi))*(z3207(+1) + 2*theta*(1-ppsi)*p(+1));
z4207 = (1-bet*(1-alph207)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph207)*Pibar^(theta*(1-ppsi))*(z4207(+1) + theta*(1-ppsi)*p(+1));

z1208 = (1-bet*(1-alph208)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph208)*Pibar^(theta*(1-ppsi)-1)*(z1208(+1)+(theta*(1-ppsi)-1)*p(+1));
z2208 = (1-bet*(1-alph208)/Pibar)*(1-sigm)*y + bet*(1-alph208)/Pibar*(z2208(+1) - p(+1));
z3208 = (1-bet*(1-alph208)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph208)*Pibar^(2*theta*(1-ppsi))*(z3208(+1) + 2*theta*(1-ppsi)*p(+1));
z4208 = (1-bet*(1-alph208)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph208)*Pibar^(theta*(1-ppsi))*(z4208(+1) + theta*(1-ppsi)*p(+1));

z1209 = (1-bet*(1-alph209)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph209)*Pibar^(theta*(1-ppsi)-1)*(z1209(+1)+(theta*(1-ppsi)-1)*p(+1));
z2209 = (1-bet*(1-alph209)/Pibar)*(1-sigm)*y + bet*(1-alph209)/Pibar*(z2209(+1) - p(+1));
z3209 = (1-bet*(1-alph209)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph209)*Pibar^(2*theta*(1-ppsi))*(z3209(+1) + 2*theta*(1-ppsi)*p(+1));
z4209 = (1-bet*(1-alph209)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph209)*Pibar^(theta*(1-ppsi))*(z4209(+1) + theta*(1-ppsi)*p(+1));

z1210 = (1-bet*(1-alph210)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph210)*Pibar^(theta*(1-ppsi)-1)*(z1210(+1)+(theta*(1-ppsi)-1)*p(+1));
z2210 = (1-bet*(1-alph210)/Pibar)*(1-sigm)*y + bet*(1-alph210)/Pibar*(z2210(+1) - p(+1));
z3210 = (1-bet*(1-alph210)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph210)*Pibar^(2*theta*(1-ppsi))*(z3210(+1) + 2*theta*(1-ppsi)*p(+1));
z4210 = (1-bet*(1-alph210)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph210)*Pibar^(theta*(1-ppsi))*(z4210(+1) + theta*(1-ppsi)*p(+1));

z1211 = (1-bet*(1-alph211)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph211)*Pibar^(theta*(1-ppsi)-1)*(z1211(+1)+(theta*(1-ppsi)-1)*p(+1));
z2211 = (1-bet*(1-alph211)/Pibar)*(1-sigm)*y + bet*(1-alph211)/Pibar*(z2211(+1) - p(+1));
z3211 = (1-bet*(1-alph211)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph211)*Pibar^(2*theta*(1-ppsi))*(z3211(+1) + 2*theta*(1-ppsi)*p(+1));
z4211 = (1-bet*(1-alph211)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph211)*Pibar^(theta*(1-ppsi))*(z4211(+1) + theta*(1-ppsi)*p(+1));

z1212 = (1-bet*(1-alph212)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph212)*Pibar^(theta*(1-ppsi)-1)*(z1212(+1)+(theta*(1-ppsi)-1)*p(+1));
z2212 = (1-bet*(1-alph212)/Pibar)*(1-sigm)*y + bet*(1-alph212)/Pibar*(z2212(+1) - p(+1));
z3212 = (1-bet*(1-alph212)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph212)*Pibar^(2*theta*(1-ppsi))*(z3212(+1) + 2*theta*(1-ppsi)*p(+1));
z4212 = (1-bet*(1-alph212)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph212)*Pibar^(theta*(1-ppsi))*(z4212(+1) + theta*(1-ppsi)*p(+1));

z1213 = (1-bet*(1-alph213)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph213)*Pibar^(theta*(1-ppsi)-1)*(z1213(+1)+(theta*(1-ppsi)-1)*p(+1));
z2213 = (1-bet*(1-alph213)/Pibar)*(1-sigm)*y + bet*(1-alph213)/Pibar*(z2213(+1) - p(+1));
z3213 = (1-bet*(1-alph213)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph213)*Pibar^(2*theta*(1-ppsi))*(z3213(+1) + 2*theta*(1-ppsi)*p(+1));
z4213 = (1-bet*(1-alph213)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph213)*Pibar^(theta*(1-ppsi))*(z4213(+1) + theta*(1-ppsi)*p(+1));

z1214 = (1-bet*(1-alph214)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph214)*Pibar^(theta*(1-ppsi)-1)*(z1214(+1)+(theta*(1-ppsi)-1)*p(+1));
z2214 = (1-bet*(1-alph214)/Pibar)*(1-sigm)*y + bet*(1-alph214)/Pibar*(z2214(+1) - p(+1));
z3214 = (1-bet*(1-alph214)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph214)*Pibar^(2*theta*(1-ppsi))*(z3214(+1) + 2*theta*(1-ppsi)*p(+1));
z4214 = (1-bet*(1-alph214)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph214)*Pibar^(theta*(1-ppsi))*(z4214(+1) + theta*(1-ppsi)*p(+1));

z1215 = (1-bet*(1-alph215)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph215)*Pibar^(theta*(1-ppsi)-1)*(z1215(+1)+(theta*(1-ppsi)-1)*p(+1));
z2215 = (1-bet*(1-alph215)/Pibar)*(1-sigm)*y + bet*(1-alph215)/Pibar*(z2215(+1) - p(+1));
z3215 = (1-bet*(1-alph215)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph215)*Pibar^(2*theta*(1-ppsi))*(z3215(+1) + 2*theta*(1-ppsi)*p(+1));
z4215 = (1-bet*(1-alph215)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph215)*Pibar^(theta*(1-ppsi))*(z4215(+1) + theta*(1-ppsi)*p(+1));

z1216 = (1-bet*(1-alph216)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph216)*Pibar^(theta*(1-ppsi)-1)*(z1216(+1)+(theta*(1-ppsi)-1)*p(+1));
z2216 = (1-bet*(1-alph216)/Pibar)*(1-sigm)*y + bet*(1-alph216)/Pibar*(z2216(+1) - p(+1));
z3216 = (1-bet*(1-alph216)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph216)*Pibar^(2*theta*(1-ppsi))*(z3216(+1) + 2*theta*(1-ppsi)*p(+1));
z4216 = (1-bet*(1-alph216)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph216)*Pibar^(theta*(1-ppsi))*(z4216(+1) + theta*(1-ppsi)*p(+1));

z1217 = (1-bet*(1-alph217)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph217)*Pibar^(theta*(1-ppsi)-1)*(z1217(+1)+(theta*(1-ppsi)-1)*p(+1));
z2217 = (1-bet*(1-alph217)/Pibar)*(1-sigm)*y + bet*(1-alph217)/Pibar*(z2217(+1) - p(+1));
z3217 = (1-bet*(1-alph217)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph217)*Pibar^(2*theta*(1-ppsi))*(z3217(+1) + 2*theta*(1-ppsi)*p(+1));
z4217 = (1-bet*(1-alph217)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph217)*Pibar^(theta*(1-ppsi))*(z4217(+1) + theta*(1-ppsi)*p(+1));

z1218 = (1-bet*(1-alph218)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph218)*Pibar^(theta*(1-ppsi)-1)*(z1218(+1)+(theta*(1-ppsi)-1)*p(+1));
z2218 = (1-bet*(1-alph218)/Pibar)*(1-sigm)*y + bet*(1-alph218)/Pibar*(z2218(+1) - p(+1));
z3218 = (1-bet*(1-alph218)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph218)*Pibar^(2*theta*(1-ppsi))*(z3218(+1) + 2*theta*(1-ppsi)*p(+1));
z4218 = (1-bet*(1-alph218)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph218)*Pibar^(theta*(1-ppsi))*(z4218(+1) + theta*(1-ppsi)*p(+1));

z1219 = (1-bet*(1-alph219)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph219)*Pibar^(theta*(1-ppsi)-1)*(z1219(+1)+(theta*(1-ppsi)-1)*p(+1));
z2219 = (1-bet*(1-alph219)/Pibar)*(1-sigm)*y + bet*(1-alph219)/Pibar*(z2219(+1) - p(+1));
z3219 = (1-bet*(1-alph219)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph219)*Pibar^(2*theta*(1-ppsi))*(z3219(+1) + 2*theta*(1-ppsi)*p(+1));
z4219 = (1-bet*(1-alph219)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph219)*Pibar^(theta*(1-ppsi))*(z4219(+1) + theta*(1-ppsi)*p(+1));

z1220 = (1-bet*(1-alph220)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph220)*Pibar^(theta*(1-ppsi)-1)*(z1220(+1)+(theta*(1-ppsi)-1)*p(+1));
z2220 = (1-bet*(1-alph220)/Pibar)*(1-sigm)*y + bet*(1-alph220)/Pibar*(z2220(+1) - p(+1));
z3220 = (1-bet*(1-alph220)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph220)*Pibar^(2*theta*(1-ppsi))*(z3220(+1) + 2*theta*(1-ppsi)*p(+1));
z4220 = (1-bet*(1-alph220)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph220)*Pibar^(theta*(1-ppsi))*(z4220(+1) + theta*(1-ppsi)*p(+1));

z1221 = (1-bet*(1-alph221)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph221)*Pibar^(theta*(1-ppsi)-1)*(z1221(+1)+(theta*(1-ppsi)-1)*p(+1));
z2221 = (1-bet*(1-alph221)/Pibar)*(1-sigm)*y + bet*(1-alph221)/Pibar*(z2221(+1) - p(+1));
z3221 = (1-bet*(1-alph221)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph221)*Pibar^(2*theta*(1-ppsi))*(z3221(+1) + 2*theta*(1-ppsi)*p(+1));
z4221 = (1-bet*(1-alph221)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph221)*Pibar^(theta*(1-ppsi))*(z4221(+1) + theta*(1-ppsi)*p(+1));

z1222 = (1-bet*(1-alph222)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph222)*Pibar^(theta*(1-ppsi)-1)*(z1222(+1)+(theta*(1-ppsi)-1)*p(+1));
z2222 = (1-bet*(1-alph222)/Pibar)*(1-sigm)*y + bet*(1-alph222)/Pibar*(z2222(+1) - p(+1));
z3222 = (1-bet*(1-alph222)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph222)*Pibar^(2*theta*(1-ppsi))*(z3222(+1) + 2*theta*(1-ppsi)*p(+1));
z4222 = (1-bet*(1-alph222)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph222)*Pibar^(theta*(1-ppsi))*(z4222(+1) + theta*(1-ppsi)*p(+1));

z1223 = (1-bet*(1-alph223)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph223)*Pibar^(theta*(1-ppsi)-1)*(z1223(+1)+(theta*(1-ppsi)-1)*p(+1));
z2223 = (1-bet*(1-alph223)/Pibar)*(1-sigm)*y + bet*(1-alph223)/Pibar*(z2223(+1) - p(+1));
z3223 = (1-bet*(1-alph223)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph223)*Pibar^(2*theta*(1-ppsi))*(z3223(+1) + 2*theta*(1-ppsi)*p(+1));
z4223 = (1-bet*(1-alph223)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph223)*Pibar^(theta*(1-ppsi))*(z4223(+1) + theta*(1-ppsi)*p(+1));

z1224 = (1-bet*(1-alph224)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph224)*Pibar^(theta*(1-ppsi)-1)*(z1224(+1)+(theta*(1-ppsi)-1)*p(+1));
z2224 = (1-bet*(1-alph224)/Pibar)*(1-sigm)*y + bet*(1-alph224)/Pibar*(z2224(+1) - p(+1));
z3224 = (1-bet*(1-alph224)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph224)*Pibar^(2*theta*(1-ppsi))*(z3224(+1) + 2*theta*(1-ppsi)*p(+1));
z4224 = (1-bet*(1-alph224)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph224)*Pibar^(theta*(1-ppsi))*(z4224(+1) + theta*(1-ppsi)*p(+1));

z1225 = (1-bet*(1-alph225)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph225)*Pibar^(theta*(1-ppsi)-1)*(z1225(+1)+(theta*(1-ppsi)-1)*p(+1));
z2225 = (1-bet*(1-alph225)/Pibar)*(1-sigm)*y + bet*(1-alph225)/Pibar*(z2225(+1) - p(+1));
z3225 = (1-bet*(1-alph225)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph225)*Pibar^(2*theta*(1-ppsi))*(z3225(+1) + 2*theta*(1-ppsi)*p(+1));
z4225 = (1-bet*(1-alph225)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph225)*Pibar^(theta*(1-ppsi))*(z4225(+1) + theta*(1-ppsi)*p(+1));

z1226 = (1-bet*(1-alph226)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph226)*Pibar^(theta*(1-ppsi)-1)*(z1226(+1)+(theta*(1-ppsi)-1)*p(+1));
z2226 = (1-bet*(1-alph226)/Pibar)*(1-sigm)*y + bet*(1-alph226)/Pibar*(z2226(+1) - p(+1));
z3226 = (1-bet*(1-alph226)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph226)*Pibar^(2*theta*(1-ppsi))*(z3226(+1) + 2*theta*(1-ppsi)*p(+1));
z4226 = (1-bet*(1-alph226)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph226)*Pibar^(theta*(1-ppsi))*(z4226(+1) + theta*(1-ppsi)*p(+1));

z1227 = (1-bet*(1-alph227)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph227)*Pibar^(theta*(1-ppsi)-1)*(z1227(+1)+(theta*(1-ppsi)-1)*p(+1));
z2227 = (1-bet*(1-alph227)/Pibar)*(1-sigm)*y + bet*(1-alph227)/Pibar*(z2227(+1) - p(+1));
z3227 = (1-bet*(1-alph227)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph227)*Pibar^(2*theta*(1-ppsi))*(z3227(+1) + 2*theta*(1-ppsi)*p(+1));
z4227 = (1-bet*(1-alph227)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph227)*Pibar^(theta*(1-ppsi))*(z4227(+1) + theta*(1-ppsi)*p(+1));

z1228 = (1-bet*(1-alph228)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph228)*Pibar^(theta*(1-ppsi)-1)*(z1228(+1)+(theta*(1-ppsi)-1)*p(+1));
z2228 = (1-bet*(1-alph228)/Pibar)*(1-sigm)*y + bet*(1-alph228)/Pibar*(z2228(+1) - p(+1));
z3228 = (1-bet*(1-alph228)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph228)*Pibar^(2*theta*(1-ppsi))*(z3228(+1) + 2*theta*(1-ppsi)*p(+1));
z4228 = (1-bet*(1-alph228)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph228)*Pibar^(theta*(1-ppsi))*(z4228(+1) + theta*(1-ppsi)*p(+1));

z1229 = (1-bet*(1-alph229)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph229)*Pibar^(theta*(1-ppsi)-1)*(z1229(+1)+(theta*(1-ppsi)-1)*p(+1));
z2229 = (1-bet*(1-alph229)/Pibar)*(1-sigm)*y + bet*(1-alph229)/Pibar*(z2229(+1) - p(+1));
z3229 = (1-bet*(1-alph229)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph229)*Pibar^(2*theta*(1-ppsi))*(z3229(+1) + 2*theta*(1-ppsi)*p(+1));
z4229 = (1-bet*(1-alph229)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph229)*Pibar^(theta*(1-ppsi))*(z4229(+1) + theta*(1-ppsi)*p(+1));

z1230 = (1-bet*(1-alph230)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph230)*Pibar^(theta*(1-ppsi)-1)*(z1230(+1)+(theta*(1-ppsi)-1)*p(+1));
z2230 = (1-bet*(1-alph230)/Pibar)*(1-sigm)*y + bet*(1-alph230)/Pibar*(z2230(+1) - p(+1));
z3230 = (1-bet*(1-alph230)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph230)*Pibar^(2*theta*(1-ppsi))*(z3230(+1) + 2*theta*(1-ppsi)*p(+1));
z4230 = (1-bet*(1-alph230)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph230)*Pibar^(theta*(1-ppsi))*(z4230(+1) + theta*(1-ppsi)*p(+1));

z1231 = (1-bet*(1-alph231)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph231)*Pibar^(theta*(1-ppsi)-1)*(z1231(+1)+(theta*(1-ppsi)-1)*p(+1));
z2231 = (1-bet*(1-alph231)/Pibar)*(1-sigm)*y + bet*(1-alph231)/Pibar*(z2231(+1) - p(+1));
z3231 = (1-bet*(1-alph231)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph231)*Pibar^(2*theta*(1-ppsi))*(z3231(+1) + 2*theta*(1-ppsi)*p(+1));
z4231 = (1-bet*(1-alph231)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph231)*Pibar^(theta*(1-ppsi))*(z4231(+1) + theta*(1-ppsi)*p(+1));

z1232 = (1-bet*(1-alph232)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph232)*Pibar^(theta*(1-ppsi)-1)*(z1232(+1)+(theta*(1-ppsi)-1)*p(+1));
z2232 = (1-bet*(1-alph232)/Pibar)*(1-sigm)*y + bet*(1-alph232)/Pibar*(z2232(+1) - p(+1));
z3232 = (1-bet*(1-alph232)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph232)*Pibar^(2*theta*(1-ppsi))*(z3232(+1) + 2*theta*(1-ppsi)*p(+1));
z4232 = (1-bet*(1-alph232)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph232)*Pibar^(theta*(1-ppsi))*(z4232(+1) + theta*(1-ppsi)*p(+1));

z1233 = (1-bet*(1-alph233)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph233)*Pibar^(theta*(1-ppsi)-1)*(z1233(+1)+(theta*(1-ppsi)-1)*p(+1));
z2233 = (1-bet*(1-alph233)/Pibar)*(1-sigm)*y + bet*(1-alph233)/Pibar*(z2233(+1) - p(+1));
z3233 = (1-bet*(1-alph233)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph233)*Pibar^(2*theta*(1-ppsi))*(z3233(+1) + 2*theta*(1-ppsi)*p(+1));
z4233 = (1-bet*(1-alph233)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph233)*Pibar^(theta*(1-ppsi))*(z4233(+1) + theta*(1-ppsi)*p(+1));

z1234 = (1-bet*(1-alph234)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph234)*Pibar^(theta*(1-ppsi)-1)*(z1234(+1)+(theta*(1-ppsi)-1)*p(+1));
z2234 = (1-bet*(1-alph234)/Pibar)*(1-sigm)*y + bet*(1-alph234)/Pibar*(z2234(+1) - p(+1));
z3234 = (1-bet*(1-alph234)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph234)*Pibar^(2*theta*(1-ppsi))*(z3234(+1) + 2*theta*(1-ppsi)*p(+1));
z4234 = (1-bet*(1-alph234)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph234)*Pibar^(theta*(1-ppsi))*(z4234(+1) + theta*(1-ppsi)*p(+1));

z1235 = (1-bet*(1-alph235)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph235)*Pibar^(theta*(1-ppsi)-1)*(z1235(+1)+(theta*(1-ppsi)-1)*p(+1));
z2235 = (1-bet*(1-alph235)/Pibar)*(1-sigm)*y + bet*(1-alph235)/Pibar*(z2235(+1) - p(+1));
z3235 = (1-bet*(1-alph235)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph235)*Pibar^(2*theta*(1-ppsi))*(z3235(+1) + 2*theta*(1-ppsi)*p(+1));
z4235 = (1-bet*(1-alph235)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph235)*Pibar^(theta*(1-ppsi))*(z4235(+1) + theta*(1-ppsi)*p(+1));

z1236 = (1-bet*(1-alph236)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph236)*Pibar^(theta*(1-ppsi)-1)*(z1236(+1)+(theta*(1-ppsi)-1)*p(+1));
z2236 = (1-bet*(1-alph236)/Pibar)*(1-sigm)*y + bet*(1-alph236)/Pibar*(z2236(+1) - p(+1));
z3236 = (1-bet*(1-alph236)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph236)*Pibar^(2*theta*(1-ppsi))*(z3236(+1) + 2*theta*(1-ppsi)*p(+1));
z4236 = (1-bet*(1-alph236)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph236)*Pibar^(theta*(1-ppsi))*(z4236(+1) + theta*(1-ppsi)*p(+1));

z1237 = (1-bet*(1-alph237)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph237)*Pibar^(theta*(1-ppsi)-1)*(z1237(+1)+(theta*(1-ppsi)-1)*p(+1));
z2237 = (1-bet*(1-alph237)/Pibar)*(1-sigm)*y + bet*(1-alph237)/Pibar*(z2237(+1) - p(+1));
z3237 = (1-bet*(1-alph237)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph237)*Pibar^(2*theta*(1-ppsi))*(z3237(+1) + 2*theta*(1-ppsi)*p(+1));
z4237 = (1-bet*(1-alph237)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph237)*Pibar^(theta*(1-ppsi))*(z4237(+1) + theta*(1-ppsi)*p(+1));

z1238 = (1-bet*(1-alph238)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph238)*Pibar^(theta*(1-ppsi)-1)*(z1238(+1)+(theta*(1-ppsi)-1)*p(+1));
z2238 = (1-bet*(1-alph238)/Pibar)*(1-sigm)*y + bet*(1-alph238)/Pibar*(z2238(+1) - p(+1));
z3238 = (1-bet*(1-alph238)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph238)*Pibar^(2*theta*(1-ppsi))*(z3238(+1) + 2*theta*(1-ppsi)*p(+1));
z4238 = (1-bet*(1-alph238)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph238)*Pibar^(theta*(1-ppsi))*(z4238(+1) + theta*(1-ppsi)*p(+1));

z1239 = (1-bet*(1-alph239)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph239)*Pibar^(theta*(1-ppsi)-1)*(z1239(+1)+(theta*(1-ppsi)-1)*p(+1));
z2239 = (1-bet*(1-alph239)/Pibar)*(1-sigm)*y + bet*(1-alph239)/Pibar*(z2239(+1) - p(+1));
z3239 = (1-bet*(1-alph239)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph239)*Pibar^(2*theta*(1-ppsi))*(z3239(+1) + 2*theta*(1-ppsi)*p(+1));
z4239 = (1-bet*(1-alph239)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph239)*Pibar^(theta*(1-ppsi))*(z4239(+1) + theta*(1-ppsi)*p(+1));

z1240 = (1-bet*(1-alph240)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph240)*Pibar^(theta*(1-ppsi)-1)*(z1240(+1)+(theta*(1-ppsi)-1)*p(+1));
z2240 = (1-bet*(1-alph240)/Pibar)*(1-sigm)*y + bet*(1-alph240)/Pibar*(z2240(+1) - p(+1));
z3240 = (1-bet*(1-alph240)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph240)*Pibar^(2*theta*(1-ppsi))*(z3240(+1) + 2*theta*(1-ppsi)*p(+1));
z4240 = (1-bet*(1-alph240)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph240)*Pibar^(theta*(1-ppsi))*(z4240(+1) + theta*(1-ppsi)*p(+1));

z1241 = (1-bet*(1-alph241)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph241)*Pibar^(theta*(1-ppsi)-1)*(z1241(+1)+(theta*(1-ppsi)-1)*p(+1));
z2241 = (1-bet*(1-alph241)/Pibar)*(1-sigm)*y + bet*(1-alph241)/Pibar*(z2241(+1) - p(+1));
z3241 = (1-bet*(1-alph241)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph241)*Pibar^(2*theta*(1-ppsi))*(z3241(+1) + 2*theta*(1-ppsi)*p(+1));
z4241 = (1-bet*(1-alph241)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph241)*Pibar^(theta*(1-ppsi))*(z4241(+1) + theta*(1-ppsi)*p(+1));

z1242 = (1-bet*(1-alph242)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph242)*Pibar^(theta*(1-ppsi)-1)*(z1242(+1)+(theta*(1-ppsi)-1)*p(+1));
z2242 = (1-bet*(1-alph242)/Pibar)*(1-sigm)*y + bet*(1-alph242)/Pibar*(z2242(+1) - p(+1));
z3242 = (1-bet*(1-alph242)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph242)*Pibar^(2*theta*(1-ppsi))*(z3242(+1) + 2*theta*(1-ppsi)*p(+1));
z4242 = (1-bet*(1-alph242)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph242)*Pibar^(theta*(1-ppsi))*(z4242(+1) + theta*(1-ppsi)*p(+1));

z1243 = (1-bet*(1-alph243)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph243)*Pibar^(theta*(1-ppsi)-1)*(z1243(+1)+(theta*(1-ppsi)-1)*p(+1));
z2243 = (1-bet*(1-alph243)/Pibar)*(1-sigm)*y + bet*(1-alph243)/Pibar*(z2243(+1) - p(+1));
z3243 = (1-bet*(1-alph243)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph243)*Pibar^(2*theta*(1-ppsi))*(z3243(+1) + 2*theta*(1-ppsi)*p(+1));
z4243 = (1-bet*(1-alph243)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph243)*Pibar^(theta*(1-ppsi))*(z4243(+1) + theta*(1-ppsi)*p(+1));

z1244 = (1-bet*(1-alph244)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph244)*Pibar^(theta*(1-ppsi)-1)*(z1244(+1)+(theta*(1-ppsi)-1)*p(+1));
z2244 = (1-bet*(1-alph244)/Pibar)*(1-sigm)*y + bet*(1-alph244)/Pibar*(z2244(+1) - p(+1));
z3244 = (1-bet*(1-alph244)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph244)*Pibar^(2*theta*(1-ppsi))*(z3244(+1) + 2*theta*(1-ppsi)*p(+1));
z4244 = (1-bet*(1-alph244)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph244)*Pibar^(theta*(1-ppsi))*(z4244(+1) + theta*(1-ppsi)*p(+1));

z1245 = (1-bet*(1-alph245)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph245)*Pibar^(theta*(1-ppsi)-1)*(z1245(+1)+(theta*(1-ppsi)-1)*p(+1));
z2245 = (1-bet*(1-alph245)/Pibar)*(1-sigm)*y + bet*(1-alph245)/Pibar*(z2245(+1) - p(+1));
z3245 = (1-bet*(1-alph245)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph245)*Pibar^(2*theta*(1-ppsi))*(z3245(+1) + 2*theta*(1-ppsi)*p(+1));
z4245 = (1-bet*(1-alph245)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph245)*Pibar^(theta*(1-ppsi))*(z4245(+1) + theta*(1-ppsi)*p(+1));

z1246 = (1-bet*(1-alph246)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph246)*Pibar^(theta*(1-ppsi)-1)*(z1246(+1)+(theta*(1-ppsi)-1)*p(+1));
z2246 = (1-bet*(1-alph246)/Pibar)*(1-sigm)*y + bet*(1-alph246)/Pibar*(z2246(+1) - p(+1));
z3246 = (1-bet*(1-alph246)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph246)*Pibar^(2*theta*(1-ppsi))*(z3246(+1) + 2*theta*(1-ppsi)*p(+1));
z4246 = (1-bet*(1-alph246)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph246)*Pibar^(theta*(1-ppsi))*(z4246(+1) + theta*(1-ppsi)*p(+1));

z1247 = (1-bet*(1-alph247)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph247)*Pibar^(theta*(1-ppsi)-1)*(z1247(+1)+(theta*(1-ppsi)-1)*p(+1));
z2247 = (1-bet*(1-alph247)/Pibar)*(1-sigm)*y + bet*(1-alph247)/Pibar*(z2247(+1) - p(+1));
z3247 = (1-bet*(1-alph247)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph247)*Pibar^(2*theta*(1-ppsi))*(z3247(+1) + 2*theta*(1-ppsi)*p(+1));
z4247 = (1-bet*(1-alph247)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph247)*Pibar^(theta*(1-ppsi))*(z4247(+1) + theta*(1-ppsi)*p(+1));

z1248 = (1-bet*(1-alph248)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph248)*Pibar^(theta*(1-ppsi)-1)*(z1248(+1)+(theta*(1-ppsi)-1)*p(+1));
z2248 = (1-bet*(1-alph248)/Pibar)*(1-sigm)*y + bet*(1-alph248)/Pibar*(z2248(+1) - p(+1));
z3248 = (1-bet*(1-alph248)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph248)*Pibar^(2*theta*(1-ppsi))*(z3248(+1) + 2*theta*(1-ppsi)*p(+1));
z4248 = (1-bet*(1-alph248)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph248)*Pibar^(theta*(1-ppsi))*(z4248(+1) + theta*(1-ppsi)*p(+1));

z1249 = (1-bet*(1-alph249)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph249)*Pibar^(theta*(1-ppsi)-1)*(z1249(+1)+(theta*(1-ppsi)-1)*p(+1));
z2249 = (1-bet*(1-alph249)/Pibar)*(1-sigm)*y + bet*(1-alph249)/Pibar*(z2249(+1) - p(+1));
z3249 = (1-bet*(1-alph249)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph249)*Pibar^(2*theta*(1-ppsi))*(z3249(+1) + 2*theta*(1-ppsi)*p(+1));
z4249 = (1-bet*(1-alph249)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph249)*Pibar^(theta*(1-ppsi))*(z4249(+1) + theta*(1-ppsi)*p(+1));

z1250 = (1-bet*(1-alph250)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph250)*Pibar^(theta*(1-ppsi)-1)*(z1250(+1)+(theta*(1-ppsi)-1)*p(+1));
z2250 = (1-bet*(1-alph250)/Pibar)*(1-sigm)*y + bet*(1-alph250)/Pibar*(z2250(+1) - p(+1));
z3250 = (1-bet*(1-alph250)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph250)*Pibar^(2*theta*(1-ppsi))*(z3250(+1) + 2*theta*(1-ppsi)*p(+1));
z4250 = (1-bet*(1-alph250)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph250)*Pibar^(theta*(1-ppsi))*(z4250(+1) + theta*(1-ppsi)*p(+1));

z1251 = (1-bet*(1-alph251)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph251)*Pibar^(theta*(1-ppsi)-1)*(z1251(+1)+(theta*(1-ppsi)-1)*p(+1));
z2251 = (1-bet*(1-alph251)/Pibar)*(1-sigm)*y + bet*(1-alph251)/Pibar*(z2251(+1) - p(+1));
z3251 = (1-bet*(1-alph251)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph251)*Pibar^(2*theta*(1-ppsi))*(z3251(+1) + 2*theta*(1-ppsi)*p(+1));
z4251 = (1-bet*(1-alph251)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph251)*Pibar^(theta*(1-ppsi))*(z4251(+1) + theta*(1-ppsi)*p(+1));

z1252 = (1-bet*(1-alph252)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph252)*Pibar^(theta*(1-ppsi)-1)*(z1252(+1)+(theta*(1-ppsi)-1)*p(+1));
z2252 = (1-bet*(1-alph252)/Pibar)*(1-sigm)*y + bet*(1-alph252)/Pibar*(z2252(+1) - p(+1));
z3252 = (1-bet*(1-alph252)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph252)*Pibar^(2*theta*(1-ppsi))*(z3252(+1) + 2*theta*(1-ppsi)*p(+1));
z4252 = (1-bet*(1-alph252)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph252)*Pibar^(theta*(1-ppsi))*(z4252(+1) + theta*(1-ppsi)*p(+1));

z1253 = (1-bet*(1-alph253)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph253)*Pibar^(theta*(1-ppsi)-1)*(z1253(+1)+(theta*(1-ppsi)-1)*p(+1));
z2253 = (1-bet*(1-alph253)/Pibar)*(1-sigm)*y + bet*(1-alph253)/Pibar*(z2253(+1) - p(+1));
z3253 = (1-bet*(1-alph253)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph253)*Pibar^(2*theta*(1-ppsi))*(z3253(+1) + 2*theta*(1-ppsi)*p(+1));
z4253 = (1-bet*(1-alph253)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph253)*Pibar^(theta*(1-ppsi))*(z4253(+1) + theta*(1-ppsi)*p(+1));

z1254 = (1-bet*(1-alph254)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph254)*Pibar^(theta*(1-ppsi)-1)*(z1254(+1)+(theta*(1-ppsi)-1)*p(+1));
z2254 = (1-bet*(1-alph254)/Pibar)*(1-sigm)*y + bet*(1-alph254)/Pibar*(z2254(+1) - p(+1));
z3254 = (1-bet*(1-alph254)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph254)*Pibar^(2*theta*(1-ppsi))*(z3254(+1) + 2*theta*(1-ppsi)*p(+1));
z4254 = (1-bet*(1-alph254)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph254)*Pibar^(theta*(1-ppsi))*(z4254(+1) + theta*(1-ppsi)*p(+1));

z1255 = (1-bet*(1-alph255)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph255)*Pibar^(theta*(1-ppsi)-1)*(z1255(+1)+(theta*(1-ppsi)-1)*p(+1));
z2255 = (1-bet*(1-alph255)/Pibar)*(1-sigm)*y + bet*(1-alph255)/Pibar*(z2255(+1) - p(+1));
z3255 = (1-bet*(1-alph255)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph255)*Pibar^(2*theta*(1-ppsi))*(z3255(+1) + 2*theta*(1-ppsi)*p(+1));
z4255 = (1-bet*(1-alph255)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph255)*Pibar^(theta*(1-ppsi))*(z4255(+1) + theta*(1-ppsi)*p(+1));

z1256 = (1-bet*(1-alph256)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph256)*Pibar^(theta*(1-ppsi)-1)*(z1256(+1)+(theta*(1-ppsi)-1)*p(+1));
z2256 = (1-bet*(1-alph256)/Pibar)*(1-sigm)*y + bet*(1-alph256)/Pibar*(z2256(+1) - p(+1));
z3256 = (1-bet*(1-alph256)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph256)*Pibar^(2*theta*(1-ppsi))*(z3256(+1) + 2*theta*(1-ppsi)*p(+1));
z4256 = (1-bet*(1-alph256)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph256)*Pibar^(theta*(1-ppsi))*(z4256(+1) + theta*(1-ppsi)*p(+1));

z1257 = (1-bet*(1-alph257)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph257)*Pibar^(theta*(1-ppsi)-1)*(z1257(+1)+(theta*(1-ppsi)-1)*p(+1));
z2257 = (1-bet*(1-alph257)/Pibar)*(1-sigm)*y + bet*(1-alph257)/Pibar*(z2257(+1) - p(+1));
z3257 = (1-bet*(1-alph257)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph257)*Pibar^(2*theta*(1-ppsi))*(z3257(+1) + 2*theta*(1-ppsi)*p(+1));
z4257 = (1-bet*(1-alph257)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph257)*Pibar^(theta*(1-ppsi))*(z4257(+1) + theta*(1-ppsi)*p(+1));

z1258 = (1-bet*(1-alph258)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph258)*Pibar^(theta*(1-ppsi)-1)*(z1258(+1)+(theta*(1-ppsi)-1)*p(+1));
z2258 = (1-bet*(1-alph258)/Pibar)*(1-sigm)*y + bet*(1-alph258)/Pibar*(z2258(+1) - p(+1));
z3258 = (1-bet*(1-alph258)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph258)*Pibar^(2*theta*(1-ppsi))*(z3258(+1) + 2*theta*(1-ppsi)*p(+1));
z4258 = (1-bet*(1-alph258)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph258)*Pibar^(theta*(1-ppsi))*(z4258(+1) + theta*(1-ppsi)*p(+1));

z1259 = (1-bet*(1-alph259)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph259)*Pibar^(theta*(1-ppsi)-1)*(z1259(+1)+(theta*(1-ppsi)-1)*p(+1));
z2259 = (1-bet*(1-alph259)/Pibar)*(1-sigm)*y + bet*(1-alph259)/Pibar*(z2259(+1) - p(+1));
z3259 = (1-bet*(1-alph259)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph259)*Pibar^(2*theta*(1-ppsi))*(z3259(+1) + 2*theta*(1-ppsi)*p(+1));
z4259 = (1-bet*(1-alph259)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph259)*Pibar^(theta*(1-ppsi))*(z4259(+1) + theta*(1-ppsi)*p(+1));

z1260 = (1-bet*(1-alph260)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph260)*Pibar^(theta*(1-ppsi)-1)*(z1260(+1)+(theta*(1-ppsi)-1)*p(+1));
z2260 = (1-bet*(1-alph260)/Pibar)*(1-sigm)*y + bet*(1-alph260)/Pibar*(z2260(+1) - p(+1));
z3260 = (1-bet*(1-alph260)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph260)*Pibar^(2*theta*(1-ppsi))*(z3260(+1) + 2*theta*(1-ppsi)*p(+1));
z4260 = (1-bet*(1-alph260)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph260)*Pibar^(theta*(1-ppsi))*(z4260(+1) + theta*(1-ppsi)*p(+1));

z1261 = (1-bet*(1-alph261)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph261)*Pibar^(theta*(1-ppsi)-1)*(z1261(+1)+(theta*(1-ppsi)-1)*p(+1));
z2261 = (1-bet*(1-alph261)/Pibar)*(1-sigm)*y + bet*(1-alph261)/Pibar*(z2261(+1) - p(+1));
z3261 = (1-bet*(1-alph261)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph261)*Pibar^(2*theta*(1-ppsi))*(z3261(+1) + 2*theta*(1-ppsi)*p(+1));
z4261 = (1-bet*(1-alph261)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph261)*Pibar^(theta*(1-ppsi))*(z4261(+1) + theta*(1-ppsi)*p(+1));

z1262 = (1-bet*(1-alph262)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph262)*Pibar^(theta*(1-ppsi)-1)*(z1262(+1)+(theta*(1-ppsi)-1)*p(+1));
z2262 = (1-bet*(1-alph262)/Pibar)*(1-sigm)*y + bet*(1-alph262)/Pibar*(z2262(+1) - p(+1));
z3262 = (1-bet*(1-alph262)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph262)*Pibar^(2*theta*(1-ppsi))*(z3262(+1) + 2*theta*(1-ppsi)*p(+1));
z4262 = (1-bet*(1-alph262)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph262)*Pibar^(theta*(1-ppsi))*(z4262(+1) + theta*(1-ppsi)*p(+1));

z1263 = (1-bet*(1-alph263)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph263)*Pibar^(theta*(1-ppsi)-1)*(z1263(+1)+(theta*(1-ppsi)-1)*p(+1));
z2263 = (1-bet*(1-alph263)/Pibar)*(1-sigm)*y + bet*(1-alph263)/Pibar*(z2263(+1) - p(+1));
z3263 = (1-bet*(1-alph263)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph263)*Pibar^(2*theta*(1-ppsi))*(z3263(+1) + 2*theta*(1-ppsi)*p(+1));
z4263 = (1-bet*(1-alph263)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph263)*Pibar^(theta*(1-ppsi))*(z4263(+1) + theta*(1-ppsi)*p(+1));

z1264 = (1-bet*(1-alph264)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph264)*Pibar^(theta*(1-ppsi)-1)*(z1264(+1)+(theta*(1-ppsi)-1)*p(+1));
z2264 = (1-bet*(1-alph264)/Pibar)*(1-sigm)*y + bet*(1-alph264)/Pibar*(z2264(+1) - p(+1));
z3264 = (1-bet*(1-alph264)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph264)*Pibar^(2*theta*(1-ppsi))*(z3264(+1) + 2*theta*(1-ppsi)*p(+1));
z4264 = (1-bet*(1-alph264)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph264)*Pibar^(theta*(1-ppsi))*(z4264(+1) + theta*(1-ppsi)*p(+1));

z1265 = (1-bet*(1-alph265)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph265)*Pibar^(theta*(1-ppsi)-1)*(z1265(+1)+(theta*(1-ppsi)-1)*p(+1));
z2265 = (1-bet*(1-alph265)/Pibar)*(1-sigm)*y + bet*(1-alph265)/Pibar*(z2265(+1) - p(+1));
z3265 = (1-bet*(1-alph265)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph265)*Pibar^(2*theta*(1-ppsi))*(z3265(+1) + 2*theta*(1-ppsi)*p(+1));
z4265 = (1-bet*(1-alph265)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph265)*Pibar^(theta*(1-ppsi))*(z4265(+1) + theta*(1-ppsi)*p(+1));

z1266 = (1-bet*(1-alph266)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph266)*Pibar^(theta*(1-ppsi)-1)*(z1266(+1)+(theta*(1-ppsi)-1)*p(+1));
z2266 = (1-bet*(1-alph266)/Pibar)*(1-sigm)*y + bet*(1-alph266)/Pibar*(z2266(+1) - p(+1));
z3266 = (1-bet*(1-alph266)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph266)*Pibar^(2*theta*(1-ppsi))*(z3266(+1) + 2*theta*(1-ppsi)*p(+1));
z4266 = (1-bet*(1-alph266)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph266)*Pibar^(theta*(1-ppsi))*(z4266(+1) + theta*(1-ppsi)*p(+1));

z1267 = (1-bet*(1-alph267)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph267)*Pibar^(theta*(1-ppsi)-1)*(z1267(+1)+(theta*(1-ppsi)-1)*p(+1));
z2267 = (1-bet*(1-alph267)/Pibar)*(1-sigm)*y + bet*(1-alph267)/Pibar*(z2267(+1) - p(+1));
z3267 = (1-bet*(1-alph267)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph267)*Pibar^(2*theta*(1-ppsi))*(z3267(+1) + 2*theta*(1-ppsi)*p(+1));
z4267 = (1-bet*(1-alph267)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph267)*Pibar^(theta*(1-ppsi))*(z4267(+1) + theta*(1-ppsi)*p(+1));

z1268 = (1-bet*(1-alph268)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph268)*Pibar^(theta*(1-ppsi)-1)*(z1268(+1)+(theta*(1-ppsi)-1)*p(+1));
z2268 = (1-bet*(1-alph268)/Pibar)*(1-sigm)*y + bet*(1-alph268)/Pibar*(z2268(+1) - p(+1));
z3268 = (1-bet*(1-alph268)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph268)*Pibar^(2*theta*(1-ppsi))*(z3268(+1) + 2*theta*(1-ppsi)*p(+1));
z4268 = (1-bet*(1-alph268)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph268)*Pibar^(theta*(1-ppsi))*(z4268(+1) + theta*(1-ppsi)*p(+1));

z1269 = (1-bet*(1-alph269)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph269)*Pibar^(theta*(1-ppsi)-1)*(z1269(+1)+(theta*(1-ppsi)-1)*p(+1));
z2269 = (1-bet*(1-alph269)/Pibar)*(1-sigm)*y + bet*(1-alph269)/Pibar*(z2269(+1) - p(+1));
z3269 = (1-bet*(1-alph269)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph269)*Pibar^(2*theta*(1-ppsi))*(z3269(+1) + 2*theta*(1-ppsi)*p(+1));
z4269 = (1-bet*(1-alph269)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph269)*Pibar^(theta*(1-ppsi))*(z4269(+1) + theta*(1-ppsi)*p(+1));

z1270 = (1-bet*(1-alph270)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph270)*Pibar^(theta*(1-ppsi)-1)*(z1270(+1)+(theta*(1-ppsi)-1)*p(+1));
z2270 = (1-bet*(1-alph270)/Pibar)*(1-sigm)*y + bet*(1-alph270)/Pibar*(z2270(+1) - p(+1));
z3270 = (1-bet*(1-alph270)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph270)*Pibar^(2*theta*(1-ppsi))*(z3270(+1) + 2*theta*(1-ppsi)*p(+1));
z4270 = (1-bet*(1-alph270)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph270)*Pibar^(theta*(1-ppsi))*(z4270(+1) + theta*(1-ppsi)*p(+1));

z1271 = (1-bet*(1-alph271)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph271)*Pibar^(theta*(1-ppsi)-1)*(z1271(+1)+(theta*(1-ppsi)-1)*p(+1));
z2271 = (1-bet*(1-alph271)/Pibar)*(1-sigm)*y + bet*(1-alph271)/Pibar*(z2271(+1) - p(+1));
z3271 = (1-bet*(1-alph271)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph271)*Pibar^(2*theta*(1-ppsi))*(z3271(+1) + 2*theta*(1-ppsi)*p(+1));
z4271 = (1-bet*(1-alph271)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph271)*Pibar^(theta*(1-ppsi))*(z4271(+1) + theta*(1-ppsi)*p(+1));

z1272 = (1-bet*(1-alph272)*Pibar^(theta*(1-ppsi)-1))*(theta*(1-ppsi)*lam + (1-sigm)*y) + bet*(1-alph272)*Pibar^(theta*(1-ppsi)-1)*(z1272(+1)+(theta*(1-ppsi)-1)*p(+1));
z2272 = (1-bet*(1-alph272)/Pibar)*(1-sigm)*y + bet*(1-alph272)/Pibar*(z2272(+1) - p(+1));
z3272 = (1-bet*(1-alph272)*Pibar^(2*theta*(1-ppsi)))*(2*theta*(1-ppsi)*lam + 2*y) + bet*(1-alph272)*Pibar^(2*theta*(1-ppsi))*(z3272(+1) + 2*theta*(1-ppsi)*p(+1));
z4272 = (1-bet*(1-alph272)*Pibar^(theta*(1-ppsi)))*(theta*(1-ppsi)*lam + 2*y) + bet*(1-alph272)*Pibar^(theta*(1-ppsi))*(z4272(+1) + theta*(1-ppsi)*p(+1));

% FOC

(theta*(1-ppsi)-1)*Z1001bar*PsP001*(z1001+ps001) + ppsi*Z2001bar*PsP001^(theta*(1-ppsi)+1)*(z2001+(theta*(1-ppsi)+1)*ps001) = theta*chi*Z3001bar*PsP001^(-theta*(1-ppsi))*(z3001-theta*(1-ppsi)*ps001) - theta*chi*ppsi*Z4001bar*z4001;
(theta*(1-ppsi)-1)*Z1002bar*PsP002*(z1002+ps002) + ppsi*Z2002bar*PsP002^(theta*(1-ppsi)+1)*(z2002+(theta*(1-ppsi)+1)*ps002) = theta*chi*Z3002bar*PsP002^(-theta*(1-ppsi))*(z3002-theta*(1-ppsi)*ps002) - theta*chi*ppsi*Z4002bar*z4002;
(theta*(1-ppsi)-1)*Z1003bar*PsP003*(z1003+ps003) + ppsi*Z2003bar*PsP003^(theta*(1-ppsi)+1)*(z2003+(theta*(1-ppsi)+1)*ps003) = theta*chi*Z3003bar*PsP003^(-theta*(1-ppsi))*(z3003-theta*(1-ppsi)*ps003) - theta*chi*ppsi*Z4003bar*z4003;
(theta*(1-ppsi)-1)*Z1004bar*PsP004*(z1004+ps004) + ppsi*Z2004bar*PsP004^(theta*(1-ppsi)+1)*(z2004+(theta*(1-ppsi)+1)*ps004) = theta*chi*Z3004bar*PsP004^(-theta*(1-ppsi))*(z3004-theta*(1-ppsi)*ps004) - theta*chi*ppsi*Z4004bar*z4004;
(theta*(1-ppsi)-1)*Z1005bar*PsP005*(z1005+ps005) + ppsi*Z2005bar*PsP005^(theta*(1-ppsi)+1)*(z2005+(theta*(1-ppsi)+1)*ps005) = theta*chi*Z3005bar*PsP005^(-theta*(1-ppsi))*(z3005-theta*(1-ppsi)*ps005) - theta*chi*ppsi*Z4005bar*z4005;
(theta*(1-ppsi)-1)*Z1006bar*PsP006*(z1006+ps006) + ppsi*Z2006bar*PsP006^(theta*(1-ppsi)+1)*(z2006+(theta*(1-ppsi)+1)*ps006) = theta*chi*Z3006bar*PsP006^(-theta*(1-ppsi))*(z3006-theta*(1-ppsi)*ps006) - theta*chi*ppsi*Z4006bar*z4006;
(theta*(1-ppsi)-1)*Z1007bar*PsP007*(z1007+ps007) + ppsi*Z2007bar*PsP007^(theta*(1-ppsi)+1)*(z2007+(theta*(1-ppsi)+1)*ps007) = theta*chi*Z3007bar*PsP007^(-theta*(1-ppsi))*(z3007-theta*(1-ppsi)*ps007) - theta*chi*ppsi*Z4007bar*z4007;
(theta*(1-ppsi)-1)*Z1008bar*PsP008*(z1008+ps008) + ppsi*Z2008bar*PsP008^(theta*(1-ppsi)+1)*(z2008+(theta*(1-ppsi)+1)*ps008) = theta*chi*Z3008bar*PsP008^(-theta*(1-ppsi))*(z3008-theta*(1-ppsi)*ps008) - theta*chi*ppsi*Z4008bar*z4008;
(theta*(1-ppsi)-1)*Z1009bar*PsP009*(z1009+ps009) + ppsi*Z2009bar*PsP009^(theta*(1-ppsi)+1)*(z2009+(theta*(1-ppsi)+1)*ps009) = theta*chi*Z3009bar*PsP009^(-theta*(1-ppsi))*(z3009-theta*(1-ppsi)*ps009) - theta*chi*ppsi*Z4009bar*z4009;
(theta*(1-ppsi)-1)*Z1010bar*PsP010*(z1010+ps010) + ppsi*Z2010bar*PsP010^(theta*(1-ppsi)+1)*(z2010+(theta*(1-ppsi)+1)*ps010) = theta*chi*Z3010bar*PsP010^(-theta*(1-ppsi))*(z3010-theta*(1-ppsi)*ps010) - theta*chi*ppsi*Z4010bar*z4010;
(theta*(1-ppsi)-1)*Z1011bar*PsP011*(z1011+ps011) + ppsi*Z2011bar*PsP011^(theta*(1-ppsi)+1)*(z2011+(theta*(1-ppsi)+1)*ps011) = theta*chi*Z3011bar*PsP011^(-theta*(1-ppsi))*(z3011-theta*(1-ppsi)*ps011) - theta*chi*ppsi*Z4011bar*z4011;
(theta*(1-ppsi)-1)*Z1012bar*PsP012*(z1012+ps012) + ppsi*Z2012bar*PsP012^(theta*(1-ppsi)+1)*(z2012+(theta*(1-ppsi)+1)*ps012) = theta*chi*Z3012bar*PsP012^(-theta*(1-ppsi))*(z3012-theta*(1-ppsi)*ps012) - theta*chi*ppsi*Z4012bar*z4012;
(theta*(1-ppsi)-1)*Z1013bar*PsP013*(z1013+ps013) + ppsi*Z2013bar*PsP013^(theta*(1-ppsi)+1)*(z2013+(theta*(1-ppsi)+1)*ps013) = theta*chi*Z3013bar*PsP013^(-theta*(1-ppsi))*(z3013-theta*(1-ppsi)*ps013) - theta*chi*ppsi*Z4013bar*z4013;
(theta*(1-ppsi)-1)*Z1014bar*PsP014*(z1014+ps014) + ppsi*Z2014bar*PsP014^(theta*(1-ppsi)+1)*(z2014+(theta*(1-ppsi)+1)*ps014) = theta*chi*Z3014bar*PsP014^(-theta*(1-ppsi))*(z3014-theta*(1-ppsi)*ps014) - theta*chi*ppsi*Z4014bar*z4014;
(theta*(1-ppsi)-1)*Z1015bar*PsP015*(z1015+ps015) + ppsi*Z2015bar*PsP015^(theta*(1-ppsi)+1)*(z2015+(theta*(1-ppsi)+1)*ps015) = theta*chi*Z3015bar*PsP015^(-theta*(1-ppsi))*(z3015-theta*(1-ppsi)*ps015) - theta*chi*ppsi*Z4015bar*z4015;
(theta*(1-ppsi)-1)*Z1016bar*PsP016*(z1016+ps016) + ppsi*Z2016bar*PsP016^(theta*(1-ppsi)+1)*(z2016+(theta*(1-ppsi)+1)*ps016) = theta*chi*Z3016bar*PsP016^(-theta*(1-ppsi))*(z3016-theta*(1-ppsi)*ps016) - theta*chi*ppsi*Z4016bar*z4016;
(theta*(1-ppsi)-1)*Z1017bar*PsP017*(z1017+ps017) + ppsi*Z2017bar*PsP017^(theta*(1-ppsi)+1)*(z2017+(theta*(1-ppsi)+1)*ps017) = theta*chi*Z3017bar*PsP017^(-theta*(1-ppsi))*(z3017-theta*(1-ppsi)*ps017) - theta*chi*ppsi*Z4017bar*z4017;
(theta*(1-ppsi)-1)*Z1018bar*PsP018*(z1018+ps018) + ppsi*Z2018bar*PsP018^(theta*(1-ppsi)+1)*(z2018+(theta*(1-ppsi)+1)*ps018) = theta*chi*Z3018bar*PsP018^(-theta*(1-ppsi))*(z3018-theta*(1-ppsi)*ps018) - theta*chi*ppsi*Z4018bar*z4018;
(theta*(1-ppsi)-1)*Z1019bar*PsP019*(z1019+ps019) + ppsi*Z2019bar*PsP019^(theta*(1-ppsi)+1)*(z2019+(theta*(1-ppsi)+1)*ps019) = theta*chi*Z3019bar*PsP019^(-theta*(1-ppsi))*(z3019-theta*(1-ppsi)*ps019) - theta*chi*ppsi*Z4019bar*z4019;
(theta*(1-ppsi)-1)*Z1020bar*PsP020*(z1020+ps020) + ppsi*Z2020bar*PsP020^(theta*(1-ppsi)+1)*(z2020+(theta*(1-ppsi)+1)*ps020) = theta*chi*Z3020bar*PsP020^(-theta*(1-ppsi))*(z3020-theta*(1-ppsi)*ps020) - theta*chi*ppsi*Z4020bar*z4020;
(theta*(1-ppsi)-1)*Z1021bar*PsP021*(z1021+ps021) + ppsi*Z2021bar*PsP021^(theta*(1-ppsi)+1)*(z2021+(theta*(1-ppsi)+1)*ps021) = theta*chi*Z3021bar*PsP021^(-theta*(1-ppsi))*(z3021-theta*(1-ppsi)*ps021) - theta*chi*ppsi*Z4021bar*z4021;
(theta*(1-ppsi)-1)*Z1022bar*PsP022*(z1022+ps022) + ppsi*Z2022bar*PsP022^(theta*(1-ppsi)+1)*(z2022+(theta*(1-ppsi)+1)*ps022) = theta*chi*Z3022bar*PsP022^(-theta*(1-ppsi))*(z3022-theta*(1-ppsi)*ps022) - theta*chi*ppsi*Z4022bar*z4022;
(theta*(1-ppsi)-1)*Z1023bar*PsP023*(z1023+ps023) + ppsi*Z2023bar*PsP023^(theta*(1-ppsi)+1)*(z2023+(theta*(1-ppsi)+1)*ps023) = theta*chi*Z3023bar*PsP023^(-theta*(1-ppsi))*(z3023-theta*(1-ppsi)*ps023) - theta*chi*ppsi*Z4023bar*z4023;
(theta*(1-ppsi)-1)*Z1024bar*PsP024*(z1024+ps024) + ppsi*Z2024bar*PsP024^(theta*(1-ppsi)+1)*(z2024+(theta*(1-ppsi)+1)*ps024) = theta*chi*Z3024bar*PsP024^(-theta*(1-ppsi))*(z3024-theta*(1-ppsi)*ps024) - theta*chi*ppsi*Z4024bar*z4024;
(theta*(1-ppsi)-1)*Z1025bar*PsP025*(z1025+ps025) + ppsi*Z2025bar*PsP025^(theta*(1-ppsi)+1)*(z2025+(theta*(1-ppsi)+1)*ps025) = theta*chi*Z3025bar*PsP025^(-theta*(1-ppsi))*(z3025-theta*(1-ppsi)*ps025) - theta*chi*ppsi*Z4025bar*z4025;
(theta*(1-ppsi)-1)*Z1026bar*PsP026*(z1026+ps026) + ppsi*Z2026bar*PsP026^(theta*(1-ppsi)+1)*(z2026+(theta*(1-ppsi)+1)*ps026) = theta*chi*Z3026bar*PsP026^(-theta*(1-ppsi))*(z3026-theta*(1-ppsi)*ps026) - theta*chi*ppsi*Z4026bar*z4026;
(theta*(1-ppsi)-1)*Z1027bar*PsP027*(z1027+ps027) + ppsi*Z2027bar*PsP027^(theta*(1-ppsi)+1)*(z2027+(theta*(1-ppsi)+1)*ps027) = theta*chi*Z3027bar*PsP027^(-theta*(1-ppsi))*(z3027-theta*(1-ppsi)*ps027) - theta*chi*ppsi*Z4027bar*z4027;
(theta*(1-ppsi)-1)*Z1028bar*PsP028*(z1028+ps028) + ppsi*Z2028bar*PsP028^(theta*(1-ppsi)+1)*(z2028+(theta*(1-ppsi)+1)*ps028) = theta*chi*Z3028bar*PsP028^(-theta*(1-ppsi))*(z3028-theta*(1-ppsi)*ps028) - theta*chi*ppsi*Z4028bar*z4028;
(theta*(1-ppsi)-1)*Z1029bar*PsP029*(z1029+ps029) + ppsi*Z2029bar*PsP029^(theta*(1-ppsi)+1)*(z2029+(theta*(1-ppsi)+1)*ps029) = theta*chi*Z3029bar*PsP029^(-theta*(1-ppsi))*(z3029-theta*(1-ppsi)*ps029) - theta*chi*ppsi*Z4029bar*z4029;
(theta*(1-ppsi)-1)*Z1030bar*PsP030*(z1030+ps030) + ppsi*Z2030bar*PsP030^(theta*(1-ppsi)+1)*(z2030+(theta*(1-ppsi)+1)*ps030) = theta*chi*Z3030bar*PsP030^(-theta*(1-ppsi))*(z3030-theta*(1-ppsi)*ps030) - theta*chi*ppsi*Z4030bar*z4030;
(theta*(1-ppsi)-1)*Z1031bar*PsP031*(z1031+ps031) + ppsi*Z2031bar*PsP031^(theta*(1-ppsi)+1)*(z2031+(theta*(1-ppsi)+1)*ps031) = theta*chi*Z3031bar*PsP031^(-theta*(1-ppsi))*(z3031-theta*(1-ppsi)*ps031) - theta*chi*ppsi*Z4031bar*z4031;
(theta*(1-ppsi)-1)*Z1032bar*PsP032*(z1032+ps032) + ppsi*Z2032bar*PsP032^(theta*(1-ppsi)+1)*(z2032+(theta*(1-ppsi)+1)*ps032) = theta*chi*Z3032bar*PsP032^(-theta*(1-ppsi))*(z3032-theta*(1-ppsi)*ps032) - theta*chi*ppsi*Z4032bar*z4032;
(theta*(1-ppsi)-1)*Z1033bar*PsP033*(z1033+ps033) + ppsi*Z2033bar*PsP033^(theta*(1-ppsi)+1)*(z2033+(theta*(1-ppsi)+1)*ps033) = theta*chi*Z3033bar*PsP033^(-theta*(1-ppsi))*(z3033-theta*(1-ppsi)*ps033) - theta*chi*ppsi*Z4033bar*z4033;
(theta*(1-ppsi)-1)*Z1034bar*PsP034*(z1034+ps034) + ppsi*Z2034bar*PsP034^(theta*(1-ppsi)+1)*(z2034+(theta*(1-ppsi)+1)*ps034) = theta*chi*Z3034bar*PsP034^(-theta*(1-ppsi))*(z3034-theta*(1-ppsi)*ps034) - theta*chi*ppsi*Z4034bar*z4034;
(theta*(1-ppsi)-1)*Z1035bar*PsP035*(z1035+ps035) + ppsi*Z2035bar*PsP035^(theta*(1-ppsi)+1)*(z2035+(theta*(1-ppsi)+1)*ps035) = theta*chi*Z3035bar*PsP035^(-theta*(1-ppsi))*(z3035-theta*(1-ppsi)*ps035) - theta*chi*ppsi*Z4035bar*z4035;
(theta*(1-ppsi)-1)*Z1036bar*PsP036*(z1036+ps036) + ppsi*Z2036bar*PsP036^(theta*(1-ppsi)+1)*(z2036+(theta*(1-ppsi)+1)*ps036) = theta*chi*Z3036bar*PsP036^(-theta*(1-ppsi))*(z3036-theta*(1-ppsi)*ps036) - theta*chi*ppsi*Z4036bar*z4036;
(theta*(1-ppsi)-1)*Z1037bar*PsP037*(z1037+ps037) + ppsi*Z2037bar*PsP037^(theta*(1-ppsi)+1)*(z2037+(theta*(1-ppsi)+1)*ps037) = theta*chi*Z3037bar*PsP037^(-theta*(1-ppsi))*(z3037-theta*(1-ppsi)*ps037) - theta*chi*ppsi*Z4037bar*z4037;
(theta*(1-ppsi)-1)*Z1038bar*PsP038*(z1038+ps038) + ppsi*Z2038bar*PsP038^(theta*(1-ppsi)+1)*(z2038+(theta*(1-ppsi)+1)*ps038) = theta*chi*Z3038bar*PsP038^(-theta*(1-ppsi))*(z3038-theta*(1-ppsi)*ps038) - theta*chi*ppsi*Z4038bar*z4038;
(theta*(1-ppsi)-1)*Z1039bar*PsP039*(z1039+ps039) + ppsi*Z2039bar*PsP039^(theta*(1-ppsi)+1)*(z2039+(theta*(1-ppsi)+1)*ps039) = theta*chi*Z3039bar*PsP039^(-theta*(1-ppsi))*(z3039-theta*(1-ppsi)*ps039) - theta*chi*ppsi*Z4039bar*z4039;
(theta*(1-ppsi)-1)*Z1040bar*PsP040*(z1040+ps040) + ppsi*Z2040bar*PsP040^(theta*(1-ppsi)+1)*(z2040+(theta*(1-ppsi)+1)*ps040) = theta*chi*Z3040bar*PsP040^(-theta*(1-ppsi))*(z3040-theta*(1-ppsi)*ps040) - theta*chi*ppsi*Z4040bar*z4040;
(theta*(1-ppsi)-1)*Z1041bar*PsP041*(z1041+ps041) + ppsi*Z2041bar*PsP041^(theta*(1-ppsi)+1)*(z2041+(theta*(1-ppsi)+1)*ps041) = theta*chi*Z3041bar*PsP041^(-theta*(1-ppsi))*(z3041-theta*(1-ppsi)*ps041) - theta*chi*ppsi*Z4041bar*z4041;
(theta*(1-ppsi)-1)*Z1042bar*PsP042*(z1042+ps042) + ppsi*Z2042bar*PsP042^(theta*(1-ppsi)+1)*(z2042+(theta*(1-ppsi)+1)*ps042) = theta*chi*Z3042bar*PsP042^(-theta*(1-ppsi))*(z3042-theta*(1-ppsi)*ps042) - theta*chi*ppsi*Z4042bar*z4042;
(theta*(1-ppsi)-1)*Z1043bar*PsP043*(z1043+ps043) + ppsi*Z2043bar*PsP043^(theta*(1-ppsi)+1)*(z2043+(theta*(1-ppsi)+1)*ps043) = theta*chi*Z3043bar*PsP043^(-theta*(1-ppsi))*(z3043-theta*(1-ppsi)*ps043) - theta*chi*ppsi*Z4043bar*z4043;
(theta*(1-ppsi)-1)*Z1044bar*PsP044*(z1044+ps044) + ppsi*Z2044bar*PsP044^(theta*(1-ppsi)+1)*(z2044+(theta*(1-ppsi)+1)*ps044) = theta*chi*Z3044bar*PsP044^(-theta*(1-ppsi))*(z3044-theta*(1-ppsi)*ps044) - theta*chi*ppsi*Z4044bar*z4044;
(theta*(1-ppsi)-1)*Z1045bar*PsP045*(z1045+ps045) + ppsi*Z2045bar*PsP045^(theta*(1-ppsi)+1)*(z2045+(theta*(1-ppsi)+1)*ps045) = theta*chi*Z3045bar*PsP045^(-theta*(1-ppsi))*(z3045-theta*(1-ppsi)*ps045) - theta*chi*ppsi*Z4045bar*z4045;
(theta*(1-ppsi)-1)*Z1046bar*PsP046*(z1046+ps046) + ppsi*Z2046bar*PsP046^(theta*(1-ppsi)+1)*(z2046+(theta*(1-ppsi)+1)*ps046) = theta*chi*Z3046bar*PsP046^(-theta*(1-ppsi))*(z3046-theta*(1-ppsi)*ps046) - theta*chi*ppsi*Z4046bar*z4046;
(theta*(1-ppsi)-1)*Z1047bar*PsP047*(z1047+ps047) + ppsi*Z2047bar*PsP047^(theta*(1-ppsi)+1)*(z2047+(theta*(1-ppsi)+1)*ps047) = theta*chi*Z3047bar*PsP047^(-theta*(1-ppsi))*(z3047-theta*(1-ppsi)*ps047) - theta*chi*ppsi*Z4047bar*z4047;
(theta*(1-ppsi)-1)*Z1048bar*PsP048*(z1048+ps048) + ppsi*Z2048bar*PsP048^(theta*(1-ppsi)+1)*(z2048+(theta*(1-ppsi)+1)*ps048) = theta*chi*Z3048bar*PsP048^(-theta*(1-ppsi))*(z3048-theta*(1-ppsi)*ps048) - theta*chi*ppsi*Z4048bar*z4048;
(theta*(1-ppsi)-1)*Z1049bar*PsP049*(z1049+ps049) + ppsi*Z2049bar*PsP049^(theta*(1-ppsi)+1)*(z2049+(theta*(1-ppsi)+1)*ps049) = theta*chi*Z3049bar*PsP049^(-theta*(1-ppsi))*(z3049-theta*(1-ppsi)*ps049) - theta*chi*ppsi*Z4049bar*z4049;
(theta*(1-ppsi)-1)*Z1050bar*PsP050*(z1050+ps050) + ppsi*Z2050bar*PsP050^(theta*(1-ppsi)+1)*(z2050+(theta*(1-ppsi)+1)*ps050) = theta*chi*Z3050bar*PsP050^(-theta*(1-ppsi))*(z3050-theta*(1-ppsi)*ps050) - theta*chi*ppsi*Z4050bar*z4050;
(theta*(1-ppsi)-1)*Z1051bar*PsP051*(z1051+ps051) + ppsi*Z2051bar*PsP051^(theta*(1-ppsi)+1)*(z2051+(theta*(1-ppsi)+1)*ps051) = theta*chi*Z3051bar*PsP051^(-theta*(1-ppsi))*(z3051-theta*(1-ppsi)*ps051) - theta*chi*ppsi*Z4051bar*z4051;
(theta*(1-ppsi)-1)*Z1052bar*PsP052*(z1052+ps052) + ppsi*Z2052bar*PsP052^(theta*(1-ppsi)+1)*(z2052+(theta*(1-ppsi)+1)*ps052) = theta*chi*Z3052bar*PsP052^(-theta*(1-ppsi))*(z3052-theta*(1-ppsi)*ps052) - theta*chi*ppsi*Z4052bar*z4052;
(theta*(1-ppsi)-1)*Z1053bar*PsP053*(z1053+ps053) + ppsi*Z2053bar*PsP053^(theta*(1-ppsi)+1)*(z2053+(theta*(1-ppsi)+1)*ps053) = theta*chi*Z3053bar*PsP053^(-theta*(1-ppsi))*(z3053-theta*(1-ppsi)*ps053) - theta*chi*ppsi*Z4053bar*z4053;
(theta*(1-ppsi)-1)*Z1054bar*PsP054*(z1054+ps054) + ppsi*Z2054bar*PsP054^(theta*(1-ppsi)+1)*(z2054+(theta*(1-ppsi)+1)*ps054) = theta*chi*Z3054bar*PsP054^(-theta*(1-ppsi))*(z3054-theta*(1-ppsi)*ps054) - theta*chi*ppsi*Z4054bar*z4054;
(theta*(1-ppsi)-1)*Z1055bar*PsP055*(z1055+ps055) + ppsi*Z2055bar*PsP055^(theta*(1-ppsi)+1)*(z2055+(theta*(1-ppsi)+1)*ps055) = theta*chi*Z3055bar*PsP055^(-theta*(1-ppsi))*(z3055-theta*(1-ppsi)*ps055) - theta*chi*ppsi*Z4055bar*z4055;
(theta*(1-ppsi)-1)*Z1056bar*PsP056*(z1056+ps056) + ppsi*Z2056bar*PsP056^(theta*(1-ppsi)+1)*(z2056+(theta*(1-ppsi)+1)*ps056) = theta*chi*Z3056bar*PsP056^(-theta*(1-ppsi))*(z3056-theta*(1-ppsi)*ps056) - theta*chi*ppsi*Z4056bar*z4056;
(theta*(1-ppsi)-1)*Z1057bar*PsP057*(z1057+ps057) + ppsi*Z2057bar*PsP057^(theta*(1-ppsi)+1)*(z2057+(theta*(1-ppsi)+1)*ps057) = theta*chi*Z3057bar*PsP057^(-theta*(1-ppsi))*(z3057-theta*(1-ppsi)*ps057) - theta*chi*ppsi*Z4057bar*z4057;
(theta*(1-ppsi)-1)*Z1058bar*PsP058*(z1058+ps058) + ppsi*Z2058bar*PsP058^(theta*(1-ppsi)+1)*(z2058+(theta*(1-ppsi)+1)*ps058) = theta*chi*Z3058bar*PsP058^(-theta*(1-ppsi))*(z3058-theta*(1-ppsi)*ps058) - theta*chi*ppsi*Z4058bar*z4058;
(theta*(1-ppsi)-1)*Z1059bar*PsP059*(z1059+ps059) + ppsi*Z2059bar*PsP059^(theta*(1-ppsi)+1)*(z2059+(theta*(1-ppsi)+1)*ps059) = theta*chi*Z3059bar*PsP059^(-theta*(1-ppsi))*(z3059-theta*(1-ppsi)*ps059) - theta*chi*ppsi*Z4059bar*z4059;
(theta*(1-ppsi)-1)*Z1060bar*PsP060*(z1060+ps060) + ppsi*Z2060bar*PsP060^(theta*(1-ppsi)+1)*(z2060+(theta*(1-ppsi)+1)*ps060) = theta*chi*Z3060bar*PsP060^(-theta*(1-ppsi))*(z3060-theta*(1-ppsi)*ps060) - theta*chi*ppsi*Z4060bar*z4060;
(theta*(1-ppsi)-1)*Z1061bar*PsP061*(z1061+ps061) + ppsi*Z2061bar*PsP061^(theta*(1-ppsi)+1)*(z2061+(theta*(1-ppsi)+1)*ps061) = theta*chi*Z3061bar*PsP061^(-theta*(1-ppsi))*(z3061-theta*(1-ppsi)*ps061) - theta*chi*ppsi*Z4061bar*z4061;
(theta*(1-ppsi)-1)*Z1062bar*PsP062*(z1062+ps062) + ppsi*Z2062bar*PsP062^(theta*(1-ppsi)+1)*(z2062+(theta*(1-ppsi)+1)*ps062) = theta*chi*Z3062bar*PsP062^(-theta*(1-ppsi))*(z3062-theta*(1-ppsi)*ps062) - theta*chi*ppsi*Z4062bar*z4062;
(theta*(1-ppsi)-1)*Z1063bar*PsP063*(z1063+ps063) + ppsi*Z2063bar*PsP063^(theta*(1-ppsi)+1)*(z2063+(theta*(1-ppsi)+1)*ps063) = theta*chi*Z3063bar*PsP063^(-theta*(1-ppsi))*(z3063-theta*(1-ppsi)*ps063) - theta*chi*ppsi*Z4063bar*z4063;
(theta*(1-ppsi)-1)*Z1064bar*PsP064*(z1064+ps064) + ppsi*Z2064bar*PsP064^(theta*(1-ppsi)+1)*(z2064+(theta*(1-ppsi)+1)*ps064) = theta*chi*Z3064bar*PsP064^(-theta*(1-ppsi))*(z3064-theta*(1-ppsi)*ps064) - theta*chi*ppsi*Z4064bar*z4064;
(theta*(1-ppsi)-1)*Z1065bar*PsP065*(z1065+ps065) + ppsi*Z2065bar*PsP065^(theta*(1-ppsi)+1)*(z2065+(theta*(1-ppsi)+1)*ps065) = theta*chi*Z3065bar*PsP065^(-theta*(1-ppsi))*(z3065-theta*(1-ppsi)*ps065) - theta*chi*ppsi*Z4065bar*z4065;
(theta*(1-ppsi)-1)*Z1066bar*PsP066*(z1066+ps066) + ppsi*Z2066bar*PsP066^(theta*(1-ppsi)+1)*(z2066+(theta*(1-ppsi)+1)*ps066) = theta*chi*Z3066bar*PsP066^(-theta*(1-ppsi))*(z3066-theta*(1-ppsi)*ps066) - theta*chi*ppsi*Z4066bar*z4066;
(theta*(1-ppsi)-1)*Z1067bar*PsP067*(z1067+ps067) + ppsi*Z2067bar*PsP067^(theta*(1-ppsi)+1)*(z2067+(theta*(1-ppsi)+1)*ps067) = theta*chi*Z3067bar*PsP067^(-theta*(1-ppsi))*(z3067-theta*(1-ppsi)*ps067) - theta*chi*ppsi*Z4067bar*z4067;
(theta*(1-ppsi)-1)*Z1068bar*PsP068*(z1068+ps068) + ppsi*Z2068bar*PsP068^(theta*(1-ppsi)+1)*(z2068+(theta*(1-ppsi)+1)*ps068) = theta*chi*Z3068bar*PsP068^(-theta*(1-ppsi))*(z3068-theta*(1-ppsi)*ps068) - theta*chi*ppsi*Z4068bar*z4068;
(theta*(1-ppsi)-1)*Z1069bar*PsP069*(z1069+ps069) + ppsi*Z2069bar*PsP069^(theta*(1-ppsi)+1)*(z2069+(theta*(1-ppsi)+1)*ps069) = theta*chi*Z3069bar*PsP069^(-theta*(1-ppsi))*(z3069-theta*(1-ppsi)*ps069) - theta*chi*ppsi*Z4069bar*z4069;
(theta*(1-ppsi)-1)*Z1070bar*PsP070*(z1070+ps070) + ppsi*Z2070bar*PsP070^(theta*(1-ppsi)+1)*(z2070+(theta*(1-ppsi)+1)*ps070) = theta*chi*Z3070bar*PsP070^(-theta*(1-ppsi))*(z3070-theta*(1-ppsi)*ps070) - theta*chi*ppsi*Z4070bar*z4070;
(theta*(1-ppsi)-1)*Z1071bar*PsP071*(z1071+ps071) + ppsi*Z2071bar*PsP071^(theta*(1-ppsi)+1)*(z2071+(theta*(1-ppsi)+1)*ps071) = theta*chi*Z3071bar*PsP071^(-theta*(1-ppsi))*(z3071-theta*(1-ppsi)*ps071) - theta*chi*ppsi*Z4071bar*z4071;
(theta*(1-ppsi)-1)*Z1072bar*PsP072*(z1072+ps072) + ppsi*Z2072bar*PsP072^(theta*(1-ppsi)+1)*(z2072+(theta*(1-ppsi)+1)*ps072) = theta*chi*Z3072bar*PsP072^(-theta*(1-ppsi))*(z3072-theta*(1-ppsi)*ps072) - theta*chi*ppsi*Z4072bar*z4072;
(theta*(1-ppsi)-1)*Z1073bar*PsP073*(z1073+ps073) + ppsi*Z2073bar*PsP073^(theta*(1-ppsi)+1)*(z2073+(theta*(1-ppsi)+1)*ps073) = theta*chi*Z3073bar*PsP073^(-theta*(1-ppsi))*(z3073-theta*(1-ppsi)*ps073) - theta*chi*ppsi*Z4073bar*z4073;
(theta*(1-ppsi)-1)*Z1074bar*PsP074*(z1074+ps074) + ppsi*Z2074bar*PsP074^(theta*(1-ppsi)+1)*(z2074+(theta*(1-ppsi)+1)*ps074) = theta*chi*Z3074bar*PsP074^(-theta*(1-ppsi))*(z3074-theta*(1-ppsi)*ps074) - theta*chi*ppsi*Z4074bar*z4074;
(theta*(1-ppsi)-1)*Z1075bar*PsP075*(z1075+ps075) + ppsi*Z2075bar*PsP075^(theta*(1-ppsi)+1)*(z2075+(theta*(1-ppsi)+1)*ps075) = theta*chi*Z3075bar*PsP075^(-theta*(1-ppsi))*(z3075-theta*(1-ppsi)*ps075) - theta*chi*ppsi*Z4075bar*z4075;
(theta*(1-ppsi)-1)*Z1076bar*PsP076*(z1076+ps076) + ppsi*Z2076bar*PsP076^(theta*(1-ppsi)+1)*(z2076+(theta*(1-ppsi)+1)*ps076) = theta*chi*Z3076bar*PsP076^(-theta*(1-ppsi))*(z3076-theta*(1-ppsi)*ps076) - theta*chi*ppsi*Z4076bar*z4076;
(theta*(1-ppsi)-1)*Z1077bar*PsP077*(z1077+ps077) + ppsi*Z2077bar*PsP077^(theta*(1-ppsi)+1)*(z2077+(theta*(1-ppsi)+1)*ps077) = theta*chi*Z3077bar*PsP077^(-theta*(1-ppsi))*(z3077-theta*(1-ppsi)*ps077) - theta*chi*ppsi*Z4077bar*z4077;
(theta*(1-ppsi)-1)*Z1078bar*PsP078*(z1078+ps078) + ppsi*Z2078bar*PsP078^(theta*(1-ppsi)+1)*(z2078+(theta*(1-ppsi)+1)*ps078) = theta*chi*Z3078bar*PsP078^(-theta*(1-ppsi))*(z3078-theta*(1-ppsi)*ps078) - theta*chi*ppsi*Z4078bar*z4078;
(theta*(1-ppsi)-1)*Z1079bar*PsP079*(z1079+ps079) + ppsi*Z2079bar*PsP079^(theta*(1-ppsi)+1)*(z2079+(theta*(1-ppsi)+1)*ps079) = theta*chi*Z3079bar*PsP079^(-theta*(1-ppsi))*(z3079-theta*(1-ppsi)*ps079) - theta*chi*ppsi*Z4079bar*z4079;
(theta*(1-ppsi)-1)*Z1080bar*PsP080*(z1080+ps080) + ppsi*Z2080bar*PsP080^(theta*(1-ppsi)+1)*(z2080+(theta*(1-ppsi)+1)*ps080) = theta*chi*Z3080bar*PsP080^(-theta*(1-ppsi))*(z3080-theta*(1-ppsi)*ps080) - theta*chi*ppsi*Z4080bar*z4080;
(theta*(1-ppsi)-1)*Z1081bar*PsP081*(z1081+ps081) + ppsi*Z2081bar*PsP081^(theta*(1-ppsi)+1)*(z2081+(theta*(1-ppsi)+1)*ps081) = theta*chi*Z3081bar*PsP081^(-theta*(1-ppsi))*(z3081-theta*(1-ppsi)*ps081) - theta*chi*ppsi*Z4081bar*z4081;
(theta*(1-ppsi)-1)*Z1082bar*PsP082*(z1082+ps082) + ppsi*Z2082bar*PsP082^(theta*(1-ppsi)+1)*(z2082+(theta*(1-ppsi)+1)*ps082) = theta*chi*Z3082bar*PsP082^(-theta*(1-ppsi))*(z3082-theta*(1-ppsi)*ps082) - theta*chi*ppsi*Z4082bar*z4082;
(theta*(1-ppsi)-1)*Z1083bar*PsP083*(z1083+ps083) + ppsi*Z2083bar*PsP083^(theta*(1-ppsi)+1)*(z2083+(theta*(1-ppsi)+1)*ps083) = theta*chi*Z3083bar*PsP083^(-theta*(1-ppsi))*(z3083-theta*(1-ppsi)*ps083) - theta*chi*ppsi*Z4083bar*z4083;
(theta*(1-ppsi)-1)*Z1084bar*PsP084*(z1084+ps084) + ppsi*Z2084bar*PsP084^(theta*(1-ppsi)+1)*(z2084+(theta*(1-ppsi)+1)*ps084) = theta*chi*Z3084bar*PsP084^(-theta*(1-ppsi))*(z3084-theta*(1-ppsi)*ps084) - theta*chi*ppsi*Z4084bar*z4084;
(theta*(1-ppsi)-1)*Z1085bar*PsP085*(z1085+ps085) + ppsi*Z2085bar*PsP085^(theta*(1-ppsi)+1)*(z2085+(theta*(1-ppsi)+1)*ps085) = theta*chi*Z3085bar*PsP085^(-theta*(1-ppsi))*(z3085-theta*(1-ppsi)*ps085) - theta*chi*ppsi*Z4085bar*z4085;
(theta*(1-ppsi)-1)*Z1086bar*PsP086*(z1086+ps086) + ppsi*Z2086bar*PsP086^(theta*(1-ppsi)+1)*(z2086+(theta*(1-ppsi)+1)*ps086) = theta*chi*Z3086bar*PsP086^(-theta*(1-ppsi))*(z3086-theta*(1-ppsi)*ps086) - theta*chi*ppsi*Z4086bar*z4086;
(theta*(1-ppsi)-1)*Z1087bar*PsP087*(z1087+ps087) + ppsi*Z2087bar*PsP087^(theta*(1-ppsi)+1)*(z2087+(theta*(1-ppsi)+1)*ps087) = theta*chi*Z3087bar*PsP087^(-theta*(1-ppsi))*(z3087-theta*(1-ppsi)*ps087) - theta*chi*ppsi*Z4087bar*z4087;
(theta*(1-ppsi)-1)*Z1088bar*PsP088*(z1088+ps088) + ppsi*Z2088bar*PsP088^(theta*(1-ppsi)+1)*(z2088+(theta*(1-ppsi)+1)*ps088) = theta*chi*Z3088bar*PsP088^(-theta*(1-ppsi))*(z3088-theta*(1-ppsi)*ps088) - theta*chi*ppsi*Z4088bar*z4088;
(theta*(1-ppsi)-1)*Z1089bar*PsP089*(z1089+ps089) + ppsi*Z2089bar*PsP089^(theta*(1-ppsi)+1)*(z2089+(theta*(1-ppsi)+1)*ps089) = theta*chi*Z3089bar*PsP089^(-theta*(1-ppsi))*(z3089-theta*(1-ppsi)*ps089) - theta*chi*ppsi*Z4089bar*z4089;
(theta*(1-ppsi)-1)*Z1090bar*PsP090*(z1090+ps090) + ppsi*Z2090bar*PsP090^(theta*(1-ppsi)+1)*(z2090+(theta*(1-ppsi)+1)*ps090) = theta*chi*Z3090bar*PsP090^(-theta*(1-ppsi))*(z3090-theta*(1-ppsi)*ps090) - theta*chi*ppsi*Z4090bar*z4090;
(theta*(1-ppsi)-1)*Z1091bar*PsP091*(z1091+ps091) + ppsi*Z2091bar*PsP091^(theta*(1-ppsi)+1)*(z2091+(theta*(1-ppsi)+1)*ps091) = theta*chi*Z3091bar*PsP091^(-theta*(1-ppsi))*(z3091-theta*(1-ppsi)*ps091) - theta*chi*ppsi*Z4091bar*z4091;
(theta*(1-ppsi)-1)*Z1092bar*PsP092*(z1092+ps092) + ppsi*Z2092bar*PsP092^(theta*(1-ppsi)+1)*(z2092+(theta*(1-ppsi)+1)*ps092) = theta*chi*Z3092bar*PsP092^(-theta*(1-ppsi))*(z3092-theta*(1-ppsi)*ps092) - theta*chi*ppsi*Z4092bar*z4092;
(theta*(1-ppsi)-1)*Z1093bar*PsP093*(z1093+ps093) + ppsi*Z2093bar*PsP093^(theta*(1-ppsi)+1)*(z2093+(theta*(1-ppsi)+1)*ps093) = theta*chi*Z3093bar*PsP093^(-theta*(1-ppsi))*(z3093-theta*(1-ppsi)*ps093) - theta*chi*ppsi*Z4093bar*z4093;
(theta*(1-ppsi)-1)*Z1094bar*PsP094*(z1094+ps094) + ppsi*Z2094bar*PsP094^(theta*(1-ppsi)+1)*(z2094+(theta*(1-ppsi)+1)*ps094) = theta*chi*Z3094bar*PsP094^(-theta*(1-ppsi))*(z3094-theta*(1-ppsi)*ps094) - theta*chi*ppsi*Z4094bar*z4094;
(theta*(1-ppsi)-1)*Z1095bar*PsP095*(z1095+ps095) + ppsi*Z2095bar*PsP095^(theta*(1-ppsi)+1)*(z2095+(theta*(1-ppsi)+1)*ps095) = theta*chi*Z3095bar*PsP095^(-theta*(1-ppsi))*(z3095-theta*(1-ppsi)*ps095) - theta*chi*ppsi*Z4095bar*z4095;
(theta*(1-ppsi)-1)*Z1096bar*PsP096*(z1096+ps096) + ppsi*Z2096bar*PsP096^(theta*(1-ppsi)+1)*(z2096+(theta*(1-ppsi)+1)*ps096) = theta*chi*Z3096bar*PsP096^(-theta*(1-ppsi))*(z3096-theta*(1-ppsi)*ps096) - theta*chi*ppsi*Z4096bar*z4096;
(theta*(1-ppsi)-1)*Z1097bar*PsP097*(z1097+ps097) + ppsi*Z2097bar*PsP097^(theta*(1-ppsi)+1)*(z2097+(theta*(1-ppsi)+1)*ps097) = theta*chi*Z3097bar*PsP097^(-theta*(1-ppsi))*(z3097-theta*(1-ppsi)*ps097) - theta*chi*ppsi*Z4097bar*z4097;
(theta*(1-ppsi)-1)*Z1098bar*PsP098*(z1098+ps098) + ppsi*Z2098bar*PsP098^(theta*(1-ppsi)+1)*(z2098+(theta*(1-ppsi)+1)*ps098) = theta*chi*Z3098bar*PsP098^(-theta*(1-ppsi))*(z3098-theta*(1-ppsi)*ps098) - theta*chi*ppsi*Z4098bar*z4098;
(theta*(1-ppsi)-1)*Z1099bar*PsP099*(z1099+ps099) + ppsi*Z2099bar*PsP099^(theta*(1-ppsi)+1)*(z2099+(theta*(1-ppsi)+1)*ps099) = theta*chi*Z3099bar*PsP099^(-theta*(1-ppsi))*(z3099-theta*(1-ppsi)*ps099) - theta*chi*ppsi*Z4099bar*z4099;
(theta*(1-ppsi)-1)*Z1100bar*PsP100*(z1100+ps100) + ppsi*Z2100bar*PsP100^(theta*(1-ppsi)+1)*(z2100+(theta*(1-ppsi)+1)*ps100) = theta*chi*Z3100bar*PsP100^(-theta*(1-ppsi))*(z3100-theta*(1-ppsi)*ps100) - theta*chi*ppsi*Z4100bar*z4100;
(theta*(1-ppsi)-1)*Z1101bar*PsP101*(z1101+ps101) + ppsi*Z2101bar*PsP101^(theta*(1-ppsi)+1)*(z2101+(theta*(1-ppsi)+1)*ps101) = theta*chi*Z3101bar*PsP101^(-theta*(1-ppsi))*(z3101-theta*(1-ppsi)*ps101) - theta*chi*ppsi*Z4101bar*z4101;
(theta*(1-ppsi)-1)*Z1102bar*PsP102*(z1102+ps102) + ppsi*Z2102bar*PsP102^(theta*(1-ppsi)+1)*(z2102+(theta*(1-ppsi)+1)*ps102) = theta*chi*Z3102bar*PsP102^(-theta*(1-ppsi))*(z3102-theta*(1-ppsi)*ps102) - theta*chi*ppsi*Z4102bar*z4102;
(theta*(1-ppsi)-1)*Z1103bar*PsP103*(z1103+ps103) + ppsi*Z2103bar*PsP103^(theta*(1-ppsi)+1)*(z2103+(theta*(1-ppsi)+1)*ps103) = theta*chi*Z3103bar*PsP103^(-theta*(1-ppsi))*(z3103-theta*(1-ppsi)*ps103) - theta*chi*ppsi*Z4103bar*z4103;
(theta*(1-ppsi)-1)*Z1104bar*PsP104*(z1104+ps104) + ppsi*Z2104bar*PsP104^(theta*(1-ppsi)+1)*(z2104+(theta*(1-ppsi)+1)*ps104) = theta*chi*Z3104bar*PsP104^(-theta*(1-ppsi))*(z3104-theta*(1-ppsi)*ps104) - theta*chi*ppsi*Z4104bar*z4104;
(theta*(1-ppsi)-1)*Z1105bar*PsP105*(z1105+ps105) + ppsi*Z2105bar*PsP105^(theta*(1-ppsi)+1)*(z2105+(theta*(1-ppsi)+1)*ps105) = theta*chi*Z3105bar*PsP105^(-theta*(1-ppsi))*(z3105-theta*(1-ppsi)*ps105) - theta*chi*ppsi*Z4105bar*z4105;
(theta*(1-ppsi)-1)*Z1106bar*PsP106*(z1106+ps106) + ppsi*Z2106bar*PsP106^(theta*(1-ppsi)+1)*(z2106+(theta*(1-ppsi)+1)*ps106) = theta*chi*Z3106bar*PsP106^(-theta*(1-ppsi))*(z3106-theta*(1-ppsi)*ps106) - theta*chi*ppsi*Z4106bar*z4106;
(theta*(1-ppsi)-1)*Z1107bar*PsP107*(z1107+ps107) + ppsi*Z2107bar*PsP107^(theta*(1-ppsi)+1)*(z2107+(theta*(1-ppsi)+1)*ps107) = theta*chi*Z3107bar*PsP107^(-theta*(1-ppsi))*(z3107-theta*(1-ppsi)*ps107) - theta*chi*ppsi*Z4107bar*z4107;
(theta*(1-ppsi)-1)*Z1108bar*PsP108*(z1108+ps108) + ppsi*Z2108bar*PsP108^(theta*(1-ppsi)+1)*(z2108+(theta*(1-ppsi)+1)*ps108) = theta*chi*Z3108bar*PsP108^(-theta*(1-ppsi))*(z3108-theta*(1-ppsi)*ps108) - theta*chi*ppsi*Z4108bar*z4108;
(theta*(1-ppsi)-1)*Z1109bar*PsP109*(z1109+ps109) + ppsi*Z2109bar*PsP109^(theta*(1-ppsi)+1)*(z2109+(theta*(1-ppsi)+1)*ps109) = theta*chi*Z3109bar*PsP109^(-theta*(1-ppsi))*(z3109-theta*(1-ppsi)*ps109) - theta*chi*ppsi*Z4109bar*z4109;
(theta*(1-ppsi)-1)*Z1110bar*PsP110*(z1110+ps110) + ppsi*Z2110bar*PsP110^(theta*(1-ppsi)+1)*(z2110+(theta*(1-ppsi)+1)*ps110) = theta*chi*Z3110bar*PsP110^(-theta*(1-ppsi))*(z3110-theta*(1-ppsi)*ps110) - theta*chi*ppsi*Z4110bar*z4110;
(theta*(1-ppsi)-1)*Z1111bar*PsP111*(z1111+ps111) + ppsi*Z2111bar*PsP111^(theta*(1-ppsi)+1)*(z2111+(theta*(1-ppsi)+1)*ps111) = theta*chi*Z3111bar*PsP111^(-theta*(1-ppsi))*(z3111-theta*(1-ppsi)*ps111) - theta*chi*ppsi*Z4111bar*z4111;
(theta*(1-ppsi)-1)*Z1112bar*PsP112*(z1112+ps112) + ppsi*Z2112bar*PsP112^(theta*(1-ppsi)+1)*(z2112+(theta*(1-ppsi)+1)*ps112) = theta*chi*Z3112bar*PsP112^(-theta*(1-ppsi))*(z3112-theta*(1-ppsi)*ps112) - theta*chi*ppsi*Z4112bar*z4112;
(theta*(1-ppsi)-1)*Z1113bar*PsP113*(z1113+ps113) + ppsi*Z2113bar*PsP113^(theta*(1-ppsi)+1)*(z2113+(theta*(1-ppsi)+1)*ps113) = theta*chi*Z3113bar*PsP113^(-theta*(1-ppsi))*(z3113-theta*(1-ppsi)*ps113) - theta*chi*ppsi*Z4113bar*z4113;
(theta*(1-ppsi)-1)*Z1114bar*PsP114*(z1114+ps114) + ppsi*Z2114bar*PsP114^(theta*(1-ppsi)+1)*(z2114+(theta*(1-ppsi)+1)*ps114) = theta*chi*Z3114bar*PsP114^(-theta*(1-ppsi))*(z3114-theta*(1-ppsi)*ps114) - theta*chi*ppsi*Z4114bar*z4114;
(theta*(1-ppsi)-1)*Z1115bar*PsP115*(z1115+ps115) + ppsi*Z2115bar*PsP115^(theta*(1-ppsi)+1)*(z2115+(theta*(1-ppsi)+1)*ps115) = theta*chi*Z3115bar*PsP115^(-theta*(1-ppsi))*(z3115-theta*(1-ppsi)*ps115) - theta*chi*ppsi*Z4115bar*z4115;
(theta*(1-ppsi)-1)*Z1116bar*PsP116*(z1116+ps116) + ppsi*Z2116bar*PsP116^(theta*(1-ppsi)+1)*(z2116+(theta*(1-ppsi)+1)*ps116) = theta*chi*Z3116bar*PsP116^(-theta*(1-ppsi))*(z3116-theta*(1-ppsi)*ps116) - theta*chi*ppsi*Z4116bar*z4116;
(theta*(1-ppsi)-1)*Z1117bar*PsP117*(z1117+ps117) + ppsi*Z2117bar*PsP117^(theta*(1-ppsi)+1)*(z2117+(theta*(1-ppsi)+1)*ps117) = theta*chi*Z3117bar*PsP117^(-theta*(1-ppsi))*(z3117-theta*(1-ppsi)*ps117) - theta*chi*ppsi*Z4117bar*z4117;
(theta*(1-ppsi)-1)*Z1118bar*PsP118*(z1118+ps118) + ppsi*Z2118bar*PsP118^(theta*(1-ppsi)+1)*(z2118+(theta*(1-ppsi)+1)*ps118) = theta*chi*Z3118bar*PsP118^(-theta*(1-ppsi))*(z3118-theta*(1-ppsi)*ps118) - theta*chi*ppsi*Z4118bar*z4118;
(theta*(1-ppsi)-1)*Z1119bar*PsP119*(z1119+ps119) + ppsi*Z2119bar*PsP119^(theta*(1-ppsi)+1)*(z2119+(theta*(1-ppsi)+1)*ps119) = theta*chi*Z3119bar*PsP119^(-theta*(1-ppsi))*(z3119-theta*(1-ppsi)*ps119) - theta*chi*ppsi*Z4119bar*z4119;
(theta*(1-ppsi)-1)*Z1120bar*PsP120*(z1120+ps120) + ppsi*Z2120bar*PsP120^(theta*(1-ppsi)+1)*(z2120+(theta*(1-ppsi)+1)*ps120) = theta*chi*Z3120bar*PsP120^(-theta*(1-ppsi))*(z3120-theta*(1-ppsi)*ps120) - theta*chi*ppsi*Z4120bar*z4120;
(theta*(1-ppsi)-1)*Z1121bar*PsP121*(z1121+ps121) + ppsi*Z2121bar*PsP121^(theta*(1-ppsi)+1)*(z2121+(theta*(1-ppsi)+1)*ps121) = theta*chi*Z3121bar*PsP121^(-theta*(1-ppsi))*(z3121-theta*(1-ppsi)*ps121) - theta*chi*ppsi*Z4121bar*z4121;
(theta*(1-ppsi)-1)*Z1122bar*PsP122*(z1122+ps122) + ppsi*Z2122bar*PsP122^(theta*(1-ppsi)+1)*(z2122+(theta*(1-ppsi)+1)*ps122) = theta*chi*Z3122bar*PsP122^(-theta*(1-ppsi))*(z3122-theta*(1-ppsi)*ps122) - theta*chi*ppsi*Z4122bar*z4122;
(theta*(1-ppsi)-1)*Z1123bar*PsP123*(z1123+ps123) + ppsi*Z2123bar*PsP123^(theta*(1-ppsi)+1)*(z2123+(theta*(1-ppsi)+1)*ps123) = theta*chi*Z3123bar*PsP123^(-theta*(1-ppsi))*(z3123-theta*(1-ppsi)*ps123) - theta*chi*ppsi*Z4123bar*z4123;
(theta*(1-ppsi)-1)*Z1124bar*PsP124*(z1124+ps124) + ppsi*Z2124bar*PsP124^(theta*(1-ppsi)+1)*(z2124+(theta*(1-ppsi)+1)*ps124) = theta*chi*Z3124bar*PsP124^(-theta*(1-ppsi))*(z3124-theta*(1-ppsi)*ps124) - theta*chi*ppsi*Z4124bar*z4124;
(theta*(1-ppsi)-1)*Z1125bar*PsP125*(z1125+ps125) + ppsi*Z2125bar*PsP125^(theta*(1-ppsi)+1)*(z2125+(theta*(1-ppsi)+1)*ps125) = theta*chi*Z3125bar*PsP125^(-theta*(1-ppsi))*(z3125-theta*(1-ppsi)*ps125) - theta*chi*ppsi*Z4125bar*z4125;
(theta*(1-ppsi)-1)*Z1126bar*PsP126*(z1126+ps126) + ppsi*Z2126bar*PsP126^(theta*(1-ppsi)+1)*(z2126+(theta*(1-ppsi)+1)*ps126) = theta*chi*Z3126bar*PsP126^(-theta*(1-ppsi))*(z3126-theta*(1-ppsi)*ps126) - theta*chi*ppsi*Z4126bar*z4126;
(theta*(1-ppsi)-1)*Z1127bar*PsP127*(z1127+ps127) + ppsi*Z2127bar*PsP127^(theta*(1-ppsi)+1)*(z2127+(theta*(1-ppsi)+1)*ps127) = theta*chi*Z3127bar*PsP127^(-theta*(1-ppsi))*(z3127-theta*(1-ppsi)*ps127) - theta*chi*ppsi*Z4127bar*z4127;
(theta*(1-ppsi)-1)*Z1128bar*PsP128*(z1128+ps128) + ppsi*Z2128bar*PsP128^(theta*(1-ppsi)+1)*(z2128+(theta*(1-ppsi)+1)*ps128) = theta*chi*Z3128bar*PsP128^(-theta*(1-ppsi))*(z3128-theta*(1-ppsi)*ps128) - theta*chi*ppsi*Z4128bar*z4128;
(theta*(1-ppsi)-1)*Z1129bar*PsP129*(z1129+ps129) + ppsi*Z2129bar*PsP129^(theta*(1-ppsi)+1)*(z2129+(theta*(1-ppsi)+1)*ps129) = theta*chi*Z3129bar*PsP129^(-theta*(1-ppsi))*(z3129-theta*(1-ppsi)*ps129) - theta*chi*ppsi*Z4129bar*z4129;
(theta*(1-ppsi)-1)*Z1130bar*PsP130*(z1130+ps130) + ppsi*Z2130bar*PsP130^(theta*(1-ppsi)+1)*(z2130+(theta*(1-ppsi)+1)*ps130) = theta*chi*Z3130bar*PsP130^(-theta*(1-ppsi))*(z3130-theta*(1-ppsi)*ps130) - theta*chi*ppsi*Z4130bar*z4130;
(theta*(1-ppsi)-1)*Z1131bar*PsP131*(z1131+ps131) + ppsi*Z2131bar*PsP131^(theta*(1-ppsi)+1)*(z2131+(theta*(1-ppsi)+1)*ps131) = theta*chi*Z3131bar*PsP131^(-theta*(1-ppsi))*(z3131-theta*(1-ppsi)*ps131) - theta*chi*ppsi*Z4131bar*z4131;
(theta*(1-ppsi)-1)*Z1132bar*PsP132*(z1132+ps132) + ppsi*Z2132bar*PsP132^(theta*(1-ppsi)+1)*(z2132+(theta*(1-ppsi)+1)*ps132) = theta*chi*Z3132bar*PsP132^(-theta*(1-ppsi))*(z3132-theta*(1-ppsi)*ps132) - theta*chi*ppsi*Z4132bar*z4132;
(theta*(1-ppsi)-1)*Z1133bar*PsP133*(z1133+ps133) + ppsi*Z2133bar*PsP133^(theta*(1-ppsi)+1)*(z2133+(theta*(1-ppsi)+1)*ps133) = theta*chi*Z3133bar*PsP133^(-theta*(1-ppsi))*(z3133-theta*(1-ppsi)*ps133) - theta*chi*ppsi*Z4133bar*z4133;
(theta*(1-ppsi)-1)*Z1134bar*PsP134*(z1134+ps134) + ppsi*Z2134bar*PsP134^(theta*(1-ppsi)+1)*(z2134+(theta*(1-ppsi)+1)*ps134) = theta*chi*Z3134bar*PsP134^(-theta*(1-ppsi))*(z3134-theta*(1-ppsi)*ps134) - theta*chi*ppsi*Z4134bar*z4134;
(theta*(1-ppsi)-1)*Z1135bar*PsP135*(z1135+ps135) + ppsi*Z2135bar*PsP135^(theta*(1-ppsi)+1)*(z2135+(theta*(1-ppsi)+1)*ps135) = theta*chi*Z3135bar*PsP135^(-theta*(1-ppsi))*(z3135-theta*(1-ppsi)*ps135) - theta*chi*ppsi*Z4135bar*z4135;
(theta*(1-ppsi)-1)*Z1136bar*PsP136*(z1136+ps136) + ppsi*Z2136bar*PsP136^(theta*(1-ppsi)+1)*(z2136+(theta*(1-ppsi)+1)*ps136) = theta*chi*Z3136bar*PsP136^(-theta*(1-ppsi))*(z3136-theta*(1-ppsi)*ps136) - theta*chi*ppsi*Z4136bar*z4136;
(theta*(1-ppsi)-1)*Z1137bar*PsP137*(z1137+ps137) + ppsi*Z2137bar*PsP137^(theta*(1-ppsi)+1)*(z2137+(theta*(1-ppsi)+1)*ps137) = theta*chi*Z3137bar*PsP137^(-theta*(1-ppsi))*(z3137-theta*(1-ppsi)*ps137) - theta*chi*ppsi*Z4137bar*z4137;
(theta*(1-ppsi)-1)*Z1138bar*PsP138*(z1138+ps138) + ppsi*Z2138bar*PsP138^(theta*(1-ppsi)+1)*(z2138+(theta*(1-ppsi)+1)*ps138) = theta*chi*Z3138bar*PsP138^(-theta*(1-ppsi))*(z3138-theta*(1-ppsi)*ps138) - theta*chi*ppsi*Z4138bar*z4138;
(theta*(1-ppsi)-1)*Z1139bar*PsP139*(z1139+ps139) + ppsi*Z2139bar*PsP139^(theta*(1-ppsi)+1)*(z2139+(theta*(1-ppsi)+1)*ps139) = theta*chi*Z3139bar*PsP139^(-theta*(1-ppsi))*(z3139-theta*(1-ppsi)*ps139) - theta*chi*ppsi*Z4139bar*z4139;
(theta*(1-ppsi)-1)*Z1140bar*PsP140*(z1140+ps140) + ppsi*Z2140bar*PsP140^(theta*(1-ppsi)+1)*(z2140+(theta*(1-ppsi)+1)*ps140) = theta*chi*Z3140bar*PsP140^(-theta*(1-ppsi))*(z3140-theta*(1-ppsi)*ps140) - theta*chi*ppsi*Z4140bar*z4140;
(theta*(1-ppsi)-1)*Z1141bar*PsP141*(z1141+ps141) + ppsi*Z2141bar*PsP141^(theta*(1-ppsi)+1)*(z2141+(theta*(1-ppsi)+1)*ps141) = theta*chi*Z3141bar*PsP141^(-theta*(1-ppsi))*(z3141-theta*(1-ppsi)*ps141) - theta*chi*ppsi*Z4141bar*z4141;
(theta*(1-ppsi)-1)*Z1142bar*PsP142*(z1142+ps142) + ppsi*Z2142bar*PsP142^(theta*(1-ppsi)+1)*(z2142+(theta*(1-ppsi)+1)*ps142) = theta*chi*Z3142bar*PsP142^(-theta*(1-ppsi))*(z3142-theta*(1-ppsi)*ps142) - theta*chi*ppsi*Z4142bar*z4142;
(theta*(1-ppsi)-1)*Z1143bar*PsP143*(z1143+ps143) + ppsi*Z2143bar*PsP143^(theta*(1-ppsi)+1)*(z2143+(theta*(1-ppsi)+1)*ps143) = theta*chi*Z3143bar*PsP143^(-theta*(1-ppsi))*(z3143-theta*(1-ppsi)*ps143) - theta*chi*ppsi*Z4143bar*z4143;
(theta*(1-ppsi)-1)*Z1144bar*PsP144*(z1144+ps144) + ppsi*Z2144bar*PsP144^(theta*(1-ppsi)+1)*(z2144+(theta*(1-ppsi)+1)*ps144) = theta*chi*Z3144bar*PsP144^(-theta*(1-ppsi))*(z3144-theta*(1-ppsi)*ps144) - theta*chi*ppsi*Z4144bar*z4144;
(theta*(1-ppsi)-1)*Z1145bar*PsP145*(z1145+ps145) + ppsi*Z2145bar*PsP145^(theta*(1-ppsi)+1)*(z2145+(theta*(1-ppsi)+1)*ps145) = theta*chi*Z3145bar*PsP145^(-theta*(1-ppsi))*(z3145-theta*(1-ppsi)*ps145) - theta*chi*ppsi*Z4145bar*z4145;
(theta*(1-ppsi)-1)*Z1146bar*PsP146*(z1146+ps146) + ppsi*Z2146bar*PsP146^(theta*(1-ppsi)+1)*(z2146+(theta*(1-ppsi)+1)*ps146) = theta*chi*Z3146bar*PsP146^(-theta*(1-ppsi))*(z3146-theta*(1-ppsi)*ps146) - theta*chi*ppsi*Z4146bar*z4146;
(theta*(1-ppsi)-1)*Z1147bar*PsP147*(z1147+ps147) + ppsi*Z2147bar*PsP147^(theta*(1-ppsi)+1)*(z2147+(theta*(1-ppsi)+1)*ps147) = theta*chi*Z3147bar*PsP147^(-theta*(1-ppsi))*(z3147-theta*(1-ppsi)*ps147) - theta*chi*ppsi*Z4147bar*z4147;
(theta*(1-ppsi)-1)*Z1148bar*PsP148*(z1148+ps148) + ppsi*Z2148bar*PsP148^(theta*(1-ppsi)+1)*(z2148+(theta*(1-ppsi)+1)*ps148) = theta*chi*Z3148bar*PsP148^(-theta*(1-ppsi))*(z3148-theta*(1-ppsi)*ps148) - theta*chi*ppsi*Z4148bar*z4148;
(theta*(1-ppsi)-1)*Z1149bar*PsP149*(z1149+ps149) + ppsi*Z2149bar*PsP149^(theta*(1-ppsi)+1)*(z2149+(theta*(1-ppsi)+1)*ps149) = theta*chi*Z3149bar*PsP149^(-theta*(1-ppsi))*(z3149-theta*(1-ppsi)*ps149) - theta*chi*ppsi*Z4149bar*z4149;
(theta*(1-ppsi)-1)*Z1150bar*PsP150*(z1150+ps150) + ppsi*Z2150bar*PsP150^(theta*(1-ppsi)+1)*(z2150+(theta*(1-ppsi)+1)*ps150) = theta*chi*Z3150bar*PsP150^(-theta*(1-ppsi))*(z3150-theta*(1-ppsi)*ps150) - theta*chi*ppsi*Z4150bar*z4150;
(theta*(1-ppsi)-1)*Z1151bar*PsP151*(z1151+ps151) + ppsi*Z2151bar*PsP151^(theta*(1-ppsi)+1)*(z2151+(theta*(1-ppsi)+1)*ps151) = theta*chi*Z3151bar*PsP151^(-theta*(1-ppsi))*(z3151-theta*(1-ppsi)*ps151) - theta*chi*ppsi*Z4151bar*z4151;
(theta*(1-ppsi)-1)*Z1152bar*PsP152*(z1152+ps152) + ppsi*Z2152bar*PsP152^(theta*(1-ppsi)+1)*(z2152+(theta*(1-ppsi)+1)*ps152) = theta*chi*Z3152bar*PsP152^(-theta*(1-ppsi))*(z3152-theta*(1-ppsi)*ps152) - theta*chi*ppsi*Z4152bar*z4152;
(theta*(1-ppsi)-1)*Z1153bar*PsP153*(z1153+ps153) + ppsi*Z2153bar*PsP153^(theta*(1-ppsi)+1)*(z2153+(theta*(1-ppsi)+1)*ps153) = theta*chi*Z3153bar*PsP153^(-theta*(1-ppsi))*(z3153-theta*(1-ppsi)*ps153) - theta*chi*ppsi*Z4153bar*z4153;
(theta*(1-ppsi)-1)*Z1154bar*PsP154*(z1154+ps154) + ppsi*Z2154bar*PsP154^(theta*(1-ppsi)+1)*(z2154+(theta*(1-ppsi)+1)*ps154) = theta*chi*Z3154bar*PsP154^(-theta*(1-ppsi))*(z3154-theta*(1-ppsi)*ps154) - theta*chi*ppsi*Z4154bar*z4154;
(theta*(1-ppsi)-1)*Z1155bar*PsP155*(z1155+ps155) + ppsi*Z2155bar*PsP155^(theta*(1-ppsi)+1)*(z2155+(theta*(1-ppsi)+1)*ps155) = theta*chi*Z3155bar*PsP155^(-theta*(1-ppsi))*(z3155-theta*(1-ppsi)*ps155) - theta*chi*ppsi*Z4155bar*z4155;
(theta*(1-ppsi)-1)*Z1156bar*PsP156*(z1156+ps156) + ppsi*Z2156bar*PsP156^(theta*(1-ppsi)+1)*(z2156+(theta*(1-ppsi)+1)*ps156) = theta*chi*Z3156bar*PsP156^(-theta*(1-ppsi))*(z3156-theta*(1-ppsi)*ps156) - theta*chi*ppsi*Z4156bar*z4156;
(theta*(1-ppsi)-1)*Z1157bar*PsP157*(z1157+ps157) + ppsi*Z2157bar*PsP157^(theta*(1-ppsi)+1)*(z2157+(theta*(1-ppsi)+1)*ps157) = theta*chi*Z3157bar*PsP157^(-theta*(1-ppsi))*(z3157-theta*(1-ppsi)*ps157) - theta*chi*ppsi*Z4157bar*z4157;
(theta*(1-ppsi)-1)*Z1158bar*PsP158*(z1158+ps158) + ppsi*Z2158bar*PsP158^(theta*(1-ppsi)+1)*(z2158+(theta*(1-ppsi)+1)*ps158) = theta*chi*Z3158bar*PsP158^(-theta*(1-ppsi))*(z3158-theta*(1-ppsi)*ps158) - theta*chi*ppsi*Z4158bar*z4158;
(theta*(1-ppsi)-1)*Z1159bar*PsP159*(z1159+ps159) + ppsi*Z2159bar*PsP159^(theta*(1-ppsi)+1)*(z2159+(theta*(1-ppsi)+1)*ps159) = theta*chi*Z3159bar*PsP159^(-theta*(1-ppsi))*(z3159-theta*(1-ppsi)*ps159) - theta*chi*ppsi*Z4159bar*z4159;
(theta*(1-ppsi)-1)*Z1160bar*PsP160*(z1160+ps160) + ppsi*Z2160bar*PsP160^(theta*(1-ppsi)+1)*(z2160+(theta*(1-ppsi)+1)*ps160) = theta*chi*Z3160bar*PsP160^(-theta*(1-ppsi))*(z3160-theta*(1-ppsi)*ps160) - theta*chi*ppsi*Z4160bar*z4160;
(theta*(1-ppsi)-1)*Z1161bar*PsP161*(z1161+ps161) + ppsi*Z2161bar*PsP161^(theta*(1-ppsi)+1)*(z2161+(theta*(1-ppsi)+1)*ps161) = theta*chi*Z3161bar*PsP161^(-theta*(1-ppsi))*(z3161-theta*(1-ppsi)*ps161) - theta*chi*ppsi*Z4161bar*z4161;
(theta*(1-ppsi)-1)*Z1162bar*PsP162*(z1162+ps162) + ppsi*Z2162bar*PsP162^(theta*(1-ppsi)+1)*(z2162+(theta*(1-ppsi)+1)*ps162) = theta*chi*Z3162bar*PsP162^(-theta*(1-ppsi))*(z3162-theta*(1-ppsi)*ps162) - theta*chi*ppsi*Z4162bar*z4162;
(theta*(1-ppsi)-1)*Z1163bar*PsP163*(z1163+ps163) + ppsi*Z2163bar*PsP163^(theta*(1-ppsi)+1)*(z2163+(theta*(1-ppsi)+1)*ps163) = theta*chi*Z3163bar*PsP163^(-theta*(1-ppsi))*(z3163-theta*(1-ppsi)*ps163) - theta*chi*ppsi*Z4163bar*z4163;
(theta*(1-ppsi)-1)*Z1164bar*PsP164*(z1164+ps164) + ppsi*Z2164bar*PsP164^(theta*(1-ppsi)+1)*(z2164+(theta*(1-ppsi)+1)*ps164) = theta*chi*Z3164bar*PsP164^(-theta*(1-ppsi))*(z3164-theta*(1-ppsi)*ps164) - theta*chi*ppsi*Z4164bar*z4164;
(theta*(1-ppsi)-1)*Z1165bar*PsP165*(z1165+ps165) + ppsi*Z2165bar*PsP165^(theta*(1-ppsi)+1)*(z2165+(theta*(1-ppsi)+1)*ps165) = theta*chi*Z3165bar*PsP165^(-theta*(1-ppsi))*(z3165-theta*(1-ppsi)*ps165) - theta*chi*ppsi*Z4165bar*z4165;
(theta*(1-ppsi)-1)*Z1166bar*PsP166*(z1166+ps166) + ppsi*Z2166bar*PsP166^(theta*(1-ppsi)+1)*(z2166+(theta*(1-ppsi)+1)*ps166) = theta*chi*Z3166bar*PsP166^(-theta*(1-ppsi))*(z3166-theta*(1-ppsi)*ps166) - theta*chi*ppsi*Z4166bar*z4166;
(theta*(1-ppsi)-1)*Z1167bar*PsP167*(z1167+ps167) + ppsi*Z2167bar*PsP167^(theta*(1-ppsi)+1)*(z2167+(theta*(1-ppsi)+1)*ps167) = theta*chi*Z3167bar*PsP167^(-theta*(1-ppsi))*(z3167-theta*(1-ppsi)*ps167) - theta*chi*ppsi*Z4167bar*z4167;
(theta*(1-ppsi)-1)*Z1168bar*PsP168*(z1168+ps168) + ppsi*Z2168bar*PsP168^(theta*(1-ppsi)+1)*(z2168+(theta*(1-ppsi)+1)*ps168) = theta*chi*Z3168bar*PsP168^(-theta*(1-ppsi))*(z3168-theta*(1-ppsi)*ps168) - theta*chi*ppsi*Z4168bar*z4168;
(theta*(1-ppsi)-1)*Z1169bar*PsP169*(z1169+ps169) + ppsi*Z2169bar*PsP169^(theta*(1-ppsi)+1)*(z2169+(theta*(1-ppsi)+1)*ps169) = theta*chi*Z3169bar*PsP169^(-theta*(1-ppsi))*(z3169-theta*(1-ppsi)*ps169) - theta*chi*ppsi*Z4169bar*z4169;
(theta*(1-ppsi)-1)*Z1170bar*PsP170*(z1170+ps170) + ppsi*Z2170bar*PsP170^(theta*(1-ppsi)+1)*(z2170+(theta*(1-ppsi)+1)*ps170) = theta*chi*Z3170bar*PsP170^(-theta*(1-ppsi))*(z3170-theta*(1-ppsi)*ps170) - theta*chi*ppsi*Z4170bar*z4170;
(theta*(1-ppsi)-1)*Z1171bar*PsP171*(z1171+ps171) + ppsi*Z2171bar*PsP171^(theta*(1-ppsi)+1)*(z2171+(theta*(1-ppsi)+1)*ps171) = theta*chi*Z3171bar*PsP171^(-theta*(1-ppsi))*(z3171-theta*(1-ppsi)*ps171) - theta*chi*ppsi*Z4171bar*z4171;
(theta*(1-ppsi)-1)*Z1172bar*PsP172*(z1172+ps172) + ppsi*Z2172bar*PsP172^(theta*(1-ppsi)+1)*(z2172+(theta*(1-ppsi)+1)*ps172) = theta*chi*Z3172bar*PsP172^(-theta*(1-ppsi))*(z3172-theta*(1-ppsi)*ps172) - theta*chi*ppsi*Z4172bar*z4172;
(theta*(1-ppsi)-1)*Z1173bar*PsP173*(z1173+ps173) + ppsi*Z2173bar*PsP173^(theta*(1-ppsi)+1)*(z2173+(theta*(1-ppsi)+1)*ps173) = theta*chi*Z3173bar*PsP173^(-theta*(1-ppsi))*(z3173-theta*(1-ppsi)*ps173) - theta*chi*ppsi*Z4173bar*z4173;
(theta*(1-ppsi)-1)*Z1174bar*PsP174*(z1174+ps174) + ppsi*Z2174bar*PsP174^(theta*(1-ppsi)+1)*(z2174+(theta*(1-ppsi)+1)*ps174) = theta*chi*Z3174bar*PsP174^(-theta*(1-ppsi))*(z3174-theta*(1-ppsi)*ps174) - theta*chi*ppsi*Z4174bar*z4174;
(theta*(1-ppsi)-1)*Z1175bar*PsP175*(z1175+ps175) + ppsi*Z2175bar*PsP175^(theta*(1-ppsi)+1)*(z2175+(theta*(1-ppsi)+1)*ps175) = theta*chi*Z3175bar*PsP175^(-theta*(1-ppsi))*(z3175-theta*(1-ppsi)*ps175) - theta*chi*ppsi*Z4175bar*z4175;
(theta*(1-ppsi)-1)*Z1176bar*PsP176*(z1176+ps176) + ppsi*Z2176bar*PsP176^(theta*(1-ppsi)+1)*(z2176+(theta*(1-ppsi)+1)*ps176) = theta*chi*Z3176bar*PsP176^(-theta*(1-ppsi))*(z3176-theta*(1-ppsi)*ps176) - theta*chi*ppsi*Z4176bar*z4176;
(theta*(1-ppsi)-1)*Z1177bar*PsP177*(z1177+ps177) + ppsi*Z2177bar*PsP177^(theta*(1-ppsi)+1)*(z2177+(theta*(1-ppsi)+1)*ps177) = theta*chi*Z3177bar*PsP177^(-theta*(1-ppsi))*(z3177-theta*(1-ppsi)*ps177) - theta*chi*ppsi*Z4177bar*z4177;
(theta*(1-ppsi)-1)*Z1178bar*PsP178*(z1178+ps178) + ppsi*Z2178bar*PsP178^(theta*(1-ppsi)+1)*(z2178+(theta*(1-ppsi)+1)*ps178) = theta*chi*Z3178bar*PsP178^(-theta*(1-ppsi))*(z3178-theta*(1-ppsi)*ps178) - theta*chi*ppsi*Z4178bar*z4178;
(theta*(1-ppsi)-1)*Z1179bar*PsP179*(z1179+ps179) + ppsi*Z2179bar*PsP179^(theta*(1-ppsi)+1)*(z2179+(theta*(1-ppsi)+1)*ps179) = theta*chi*Z3179bar*PsP179^(-theta*(1-ppsi))*(z3179-theta*(1-ppsi)*ps179) - theta*chi*ppsi*Z4179bar*z4179;
(theta*(1-ppsi)-1)*Z1180bar*PsP180*(z1180+ps180) + ppsi*Z2180bar*PsP180^(theta*(1-ppsi)+1)*(z2180+(theta*(1-ppsi)+1)*ps180) = theta*chi*Z3180bar*PsP180^(-theta*(1-ppsi))*(z3180-theta*(1-ppsi)*ps180) - theta*chi*ppsi*Z4180bar*z4180;
(theta*(1-ppsi)-1)*Z1181bar*PsP181*(z1181+ps181) + ppsi*Z2181bar*PsP181^(theta*(1-ppsi)+1)*(z2181+(theta*(1-ppsi)+1)*ps181) = theta*chi*Z3181bar*PsP181^(-theta*(1-ppsi))*(z3181-theta*(1-ppsi)*ps181) - theta*chi*ppsi*Z4181bar*z4181;
(theta*(1-ppsi)-1)*Z1182bar*PsP182*(z1182+ps182) + ppsi*Z2182bar*PsP182^(theta*(1-ppsi)+1)*(z2182+(theta*(1-ppsi)+1)*ps182) = theta*chi*Z3182bar*PsP182^(-theta*(1-ppsi))*(z3182-theta*(1-ppsi)*ps182) - theta*chi*ppsi*Z4182bar*z4182;
(theta*(1-ppsi)-1)*Z1183bar*PsP183*(z1183+ps183) + ppsi*Z2183bar*PsP183^(theta*(1-ppsi)+1)*(z2183+(theta*(1-ppsi)+1)*ps183) = theta*chi*Z3183bar*PsP183^(-theta*(1-ppsi))*(z3183-theta*(1-ppsi)*ps183) - theta*chi*ppsi*Z4183bar*z4183;
(theta*(1-ppsi)-1)*Z1184bar*PsP184*(z1184+ps184) + ppsi*Z2184bar*PsP184^(theta*(1-ppsi)+1)*(z2184+(theta*(1-ppsi)+1)*ps184) = theta*chi*Z3184bar*PsP184^(-theta*(1-ppsi))*(z3184-theta*(1-ppsi)*ps184) - theta*chi*ppsi*Z4184bar*z4184;
(theta*(1-ppsi)-1)*Z1185bar*PsP185*(z1185+ps185) + ppsi*Z2185bar*PsP185^(theta*(1-ppsi)+1)*(z2185+(theta*(1-ppsi)+1)*ps185) = theta*chi*Z3185bar*PsP185^(-theta*(1-ppsi))*(z3185-theta*(1-ppsi)*ps185) - theta*chi*ppsi*Z4185bar*z4185;
(theta*(1-ppsi)-1)*Z1186bar*PsP186*(z1186+ps186) + ppsi*Z2186bar*PsP186^(theta*(1-ppsi)+1)*(z2186+(theta*(1-ppsi)+1)*ps186) = theta*chi*Z3186bar*PsP186^(-theta*(1-ppsi))*(z3186-theta*(1-ppsi)*ps186) - theta*chi*ppsi*Z4186bar*z4186;
(theta*(1-ppsi)-1)*Z1187bar*PsP187*(z1187+ps187) + ppsi*Z2187bar*PsP187^(theta*(1-ppsi)+1)*(z2187+(theta*(1-ppsi)+1)*ps187) = theta*chi*Z3187bar*PsP187^(-theta*(1-ppsi))*(z3187-theta*(1-ppsi)*ps187) - theta*chi*ppsi*Z4187bar*z4187;
(theta*(1-ppsi)-1)*Z1188bar*PsP188*(z1188+ps188) + ppsi*Z2188bar*PsP188^(theta*(1-ppsi)+1)*(z2188+(theta*(1-ppsi)+1)*ps188) = theta*chi*Z3188bar*PsP188^(-theta*(1-ppsi))*(z3188-theta*(1-ppsi)*ps188) - theta*chi*ppsi*Z4188bar*z4188;
(theta*(1-ppsi)-1)*Z1189bar*PsP189*(z1189+ps189) + ppsi*Z2189bar*PsP189^(theta*(1-ppsi)+1)*(z2189+(theta*(1-ppsi)+1)*ps189) = theta*chi*Z3189bar*PsP189^(-theta*(1-ppsi))*(z3189-theta*(1-ppsi)*ps189) - theta*chi*ppsi*Z4189bar*z4189;
(theta*(1-ppsi)-1)*Z1190bar*PsP190*(z1190+ps190) + ppsi*Z2190bar*PsP190^(theta*(1-ppsi)+1)*(z2190+(theta*(1-ppsi)+1)*ps190) = theta*chi*Z3190bar*PsP190^(-theta*(1-ppsi))*(z3190-theta*(1-ppsi)*ps190) - theta*chi*ppsi*Z4190bar*z4190;
(theta*(1-ppsi)-1)*Z1191bar*PsP191*(z1191+ps191) + ppsi*Z2191bar*PsP191^(theta*(1-ppsi)+1)*(z2191+(theta*(1-ppsi)+1)*ps191) = theta*chi*Z3191bar*PsP191^(-theta*(1-ppsi))*(z3191-theta*(1-ppsi)*ps191) - theta*chi*ppsi*Z4191bar*z4191;
(theta*(1-ppsi)-1)*Z1192bar*PsP192*(z1192+ps192) + ppsi*Z2192bar*PsP192^(theta*(1-ppsi)+1)*(z2192+(theta*(1-ppsi)+1)*ps192) = theta*chi*Z3192bar*PsP192^(-theta*(1-ppsi))*(z3192-theta*(1-ppsi)*ps192) - theta*chi*ppsi*Z4192bar*z4192;
(theta*(1-ppsi)-1)*Z1193bar*PsP193*(z1193+ps193) + ppsi*Z2193bar*PsP193^(theta*(1-ppsi)+1)*(z2193+(theta*(1-ppsi)+1)*ps193) = theta*chi*Z3193bar*PsP193^(-theta*(1-ppsi))*(z3193-theta*(1-ppsi)*ps193) - theta*chi*ppsi*Z4193bar*z4193;
(theta*(1-ppsi)-1)*Z1194bar*PsP194*(z1194+ps194) + ppsi*Z2194bar*PsP194^(theta*(1-ppsi)+1)*(z2194+(theta*(1-ppsi)+1)*ps194) = theta*chi*Z3194bar*PsP194^(-theta*(1-ppsi))*(z3194-theta*(1-ppsi)*ps194) - theta*chi*ppsi*Z4194bar*z4194;
(theta*(1-ppsi)-1)*Z1195bar*PsP195*(z1195+ps195) + ppsi*Z2195bar*PsP195^(theta*(1-ppsi)+1)*(z2195+(theta*(1-ppsi)+1)*ps195) = theta*chi*Z3195bar*PsP195^(-theta*(1-ppsi))*(z3195-theta*(1-ppsi)*ps195) - theta*chi*ppsi*Z4195bar*z4195;
(theta*(1-ppsi)-1)*Z1196bar*PsP196*(z1196+ps196) + ppsi*Z2196bar*PsP196^(theta*(1-ppsi)+1)*(z2196+(theta*(1-ppsi)+1)*ps196) = theta*chi*Z3196bar*PsP196^(-theta*(1-ppsi))*(z3196-theta*(1-ppsi)*ps196) - theta*chi*ppsi*Z4196bar*z4196;
(theta*(1-ppsi)-1)*Z1197bar*PsP197*(z1197+ps197) + ppsi*Z2197bar*PsP197^(theta*(1-ppsi)+1)*(z2197+(theta*(1-ppsi)+1)*ps197) = theta*chi*Z3197bar*PsP197^(-theta*(1-ppsi))*(z3197-theta*(1-ppsi)*ps197) - theta*chi*ppsi*Z4197bar*z4197;
(theta*(1-ppsi)-1)*Z1198bar*PsP198*(z1198+ps198) + ppsi*Z2198bar*PsP198^(theta*(1-ppsi)+1)*(z2198+(theta*(1-ppsi)+1)*ps198) = theta*chi*Z3198bar*PsP198^(-theta*(1-ppsi))*(z3198-theta*(1-ppsi)*ps198) - theta*chi*ppsi*Z4198bar*z4198;
(theta*(1-ppsi)-1)*Z1199bar*PsP199*(z1199+ps199) + ppsi*Z2199bar*PsP199^(theta*(1-ppsi)+1)*(z2199+(theta*(1-ppsi)+1)*ps199) = theta*chi*Z3199bar*PsP199^(-theta*(1-ppsi))*(z3199-theta*(1-ppsi)*ps199) - theta*chi*ppsi*Z4199bar*z4199;
(theta*(1-ppsi)-1)*Z1200bar*PsP200*(z1200+ps200) + ppsi*Z2200bar*PsP200^(theta*(1-ppsi)+1)*(z2200+(theta*(1-ppsi)+1)*ps200) = theta*chi*Z3200bar*PsP200^(-theta*(1-ppsi))*(z3200-theta*(1-ppsi)*ps200) - theta*chi*ppsi*Z4200bar*z4200;
(theta*(1-ppsi)-1)*Z1201bar*PsP201*(z1201+ps201) + ppsi*Z2201bar*PsP201^(theta*(1-ppsi)+1)*(z2201+(theta*(1-ppsi)+1)*ps201) = theta*chi*Z3201bar*PsP201^(-theta*(1-ppsi))*(z3201-theta*(1-ppsi)*ps201) - theta*chi*ppsi*Z4201bar*z4201;
(theta*(1-ppsi)-1)*Z1202bar*PsP202*(z1202+ps202) + ppsi*Z2202bar*PsP202^(theta*(1-ppsi)+1)*(z2202+(theta*(1-ppsi)+1)*ps202) = theta*chi*Z3202bar*PsP202^(-theta*(1-ppsi))*(z3202-theta*(1-ppsi)*ps202) - theta*chi*ppsi*Z4202bar*z4202;
(theta*(1-ppsi)-1)*Z1203bar*PsP203*(z1203+ps203) + ppsi*Z2203bar*PsP203^(theta*(1-ppsi)+1)*(z2203+(theta*(1-ppsi)+1)*ps203) = theta*chi*Z3203bar*PsP203^(-theta*(1-ppsi))*(z3203-theta*(1-ppsi)*ps203) - theta*chi*ppsi*Z4203bar*z4203;
(theta*(1-ppsi)-1)*Z1204bar*PsP204*(z1204+ps204) + ppsi*Z2204bar*PsP204^(theta*(1-ppsi)+1)*(z2204+(theta*(1-ppsi)+1)*ps204) = theta*chi*Z3204bar*PsP204^(-theta*(1-ppsi))*(z3204-theta*(1-ppsi)*ps204) - theta*chi*ppsi*Z4204bar*z4204;
(theta*(1-ppsi)-1)*Z1205bar*PsP205*(z1205+ps205) + ppsi*Z2205bar*PsP205^(theta*(1-ppsi)+1)*(z2205+(theta*(1-ppsi)+1)*ps205) = theta*chi*Z3205bar*PsP205^(-theta*(1-ppsi))*(z3205-theta*(1-ppsi)*ps205) - theta*chi*ppsi*Z4205bar*z4205;
(theta*(1-ppsi)-1)*Z1206bar*PsP206*(z1206+ps206) + ppsi*Z2206bar*PsP206^(theta*(1-ppsi)+1)*(z2206+(theta*(1-ppsi)+1)*ps206) = theta*chi*Z3206bar*PsP206^(-theta*(1-ppsi))*(z3206-theta*(1-ppsi)*ps206) - theta*chi*ppsi*Z4206bar*z4206;
(theta*(1-ppsi)-1)*Z1207bar*PsP207*(z1207+ps207) + ppsi*Z2207bar*PsP207^(theta*(1-ppsi)+1)*(z2207+(theta*(1-ppsi)+1)*ps207) = theta*chi*Z3207bar*PsP207^(-theta*(1-ppsi))*(z3207-theta*(1-ppsi)*ps207) - theta*chi*ppsi*Z4207bar*z4207;
(theta*(1-ppsi)-1)*Z1208bar*PsP208*(z1208+ps208) + ppsi*Z2208bar*PsP208^(theta*(1-ppsi)+1)*(z2208+(theta*(1-ppsi)+1)*ps208) = theta*chi*Z3208bar*PsP208^(-theta*(1-ppsi))*(z3208-theta*(1-ppsi)*ps208) - theta*chi*ppsi*Z4208bar*z4208;
(theta*(1-ppsi)-1)*Z1209bar*PsP209*(z1209+ps209) + ppsi*Z2209bar*PsP209^(theta*(1-ppsi)+1)*(z2209+(theta*(1-ppsi)+1)*ps209) = theta*chi*Z3209bar*PsP209^(-theta*(1-ppsi))*(z3209-theta*(1-ppsi)*ps209) - theta*chi*ppsi*Z4209bar*z4209;
(theta*(1-ppsi)-1)*Z1210bar*PsP210*(z1210+ps210) + ppsi*Z2210bar*PsP210^(theta*(1-ppsi)+1)*(z2210+(theta*(1-ppsi)+1)*ps210) = theta*chi*Z3210bar*PsP210^(-theta*(1-ppsi))*(z3210-theta*(1-ppsi)*ps210) - theta*chi*ppsi*Z4210bar*z4210;
(theta*(1-ppsi)-1)*Z1211bar*PsP211*(z1211+ps211) + ppsi*Z2211bar*PsP211^(theta*(1-ppsi)+1)*(z2211+(theta*(1-ppsi)+1)*ps211) = theta*chi*Z3211bar*PsP211^(-theta*(1-ppsi))*(z3211-theta*(1-ppsi)*ps211) - theta*chi*ppsi*Z4211bar*z4211;
(theta*(1-ppsi)-1)*Z1212bar*PsP212*(z1212+ps212) + ppsi*Z2212bar*PsP212^(theta*(1-ppsi)+1)*(z2212+(theta*(1-ppsi)+1)*ps212) = theta*chi*Z3212bar*PsP212^(-theta*(1-ppsi))*(z3212-theta*(1-ppsi)*ps212) - theta*chi*ppsi*Z4212bar*z4212;
(theta*(1-ppsi)-1)*Z1213bar*PsP213*(z1213+ps213) + ppsi*Z2213bar*PsP213^(theta*(1-ppsi)+1)*(z2213+(theta*(1-ppsi)+1)*ps213) = theta*chi*Z3213bar*PsP213^(-theta*(1-ppsi))*(z3213-theta*(1-ppsi)*ps213) - theta*chi*ppsi*Z4213bar*z4213;
(theta*(1-ppsi)-1)*Z1214bar*PsP214*(z1214+ps214) + ppsi*Z2214bar*PsP214^(theta*(1-ppsi)+1)*(z2214+(theta*(1-ppsi)+1)*ps214) = theta*chi*Z3214bar*PsP214^(-theta*(1-ppsi))*(z3214-theta*(1-ppsi)*ps214) - theta*chi*ppsi*Z4214bar*z4214;
(theta*(1-ppsi)-1)*Z1215bar*PsP215*(z1215+ps215) + ppsi*Z2215bar*PsP215^(theta*(1-ppsi)+1)*(z2215+(theta*(1-ppsi)+1)*ps215) = theta*chi*Z3215bar*PsP215^(-theta*(1-ppsi))*(z3215-theta*(1-ppsi)*ps215) - theta*chi*ppsi*Z4215bar*z4215;
(theta*(1-ppsi)-1)*Z1216bar*PsP216*(z1216+ps216) + ppsi*Z2216bar*PsP216^(theta*(1-ppsi)+1)*(z2216+(theta*(1-ppsi)+1)*ps216) = theta*chi*Z3216bar*PsP216^(-theta*(1-ppsi))*(z3216-theta*(1-ppsi)*ps216) - theta*chi*ppsi*Z4216bar*z4216;
(theta*(1-ppsi)-1)*Z1217bar*PsP217*(z1217+ps217) + ppsi*Z2217bar*PsP217^(theta*(1-ppsi)+1)*(z2217+(theta*(1-ppsi)+1)*ps217) = theta*chi*Z3217bar*PsP217^(-theta*(1-ppsi))*(z3217-theta*(1-ppsi)*ps217) - theta*chi*ppsi*Z4217bar*z4217;
(theta*(1-ppsi)-1)*Z1218bar*PsP218*(z1218+ps218) + ppsi*Z2218bar*PsP218^(theta*(1-ppsi)+1)*(z2218+(theta*(1-ppsi)+1)*ps218) = theta*chi*Z3218bar*PsP218^(-theta*(1-ppsi))*(z3218-theta*(1-ppsi)*ps218) - theta*chi*ppsi*Z4218bar*z4218;
(theta*(1-ppsi)-1)*Z1219bar*PsP219*(z1219+ps219) + ppsi*Z2219bar*PsP219^(theta*(1-ppsi)+1)*(z2219+(theta*(1-ppsi)+1)*ps219) = theta*chi*Z3219bar*PsP219^(-theta*(1-ppsi))*(z3219-theta*(1-ppsi)*ps219) - theta*chi*ppsi*Z4219bar*z4219;
(theta*(1-ppsi)-1)*Z1220bar*PsP220*(z1220+ps220) + ppsi*Z2220bar*PsP220^(theta*(1-ppsi)+1)*(z2220+(theta*(1-ppsi)+1)*ps220) = theta*chi*Z3220bar*PsP220^(-theta*(1-ppsi))*(z3220-theta*(1-ppsi)*ps220) - theta*chi*ppsi*Z4220bar*z4220;
(theta*(1-ppsi)-1)*Z1221bar*PsP221*(z1221+ps221) + ppsi*Z2221bar*PsP221^(theta*(1-ppsi)+1)*(z2221+(theta*(1-ppsi)+1)*ps221) = theta*chi*Z3221bar*PsP221^(-theta*(1-ppsi))*(z3221-theta*(1-ppsi)*ps221) - theta*chi*ppsi*Z4221bar*z4221;
(theta*(1-ppsi)-1)*Z1222bar*PsP222*(z1222+ps222) + ppsi*Z2222bar*PsP222^(theta*(1-ppsi)+1)*(z2222+(theta*(1-ppsi)+1)*ps222) = theta*chi*Z3222bar*PsP222^(-theta*(1-ppsi))*(z3222-theta*(1-ppsi)*ps222) - theta*chi*ppsi*Z4222bar*z4222;
(theta*(1-ppsi)-1)*Z1223bar*PsP223*(z1223+ps223) + ppsi*Z2223bar*PsP223^(theta*(1-ppsi)+1)*(z2223+(theta*(1-ppsi)+1)*ps223) = theta*chi*Z3223bar*PsP223^(-theta*(1-ppsi))*(z3223-theta*(1-ppsi)*ps223) - theta*chi*ppsi*Z4223bar*z4223;
(theta*(1-ppsi)-1)*Z1224bar*PsP224*(z1224+ps224) + ppsi*Z2224bar*PsP224^(theta*(1-ppsi)+1)*(z2224+(theta*(1-ppsi)+1)*ps224) = theta*chi*Z3224bar*PsP224^(-theta*(1-ppsi))*(z3224-theta*(1-ppsi)*ps224) - theta*chi*ppsi*Z4224bar*z4224;
(theta*(1-ppsi)-1)*Z1225bar*PsP225*(z1225+ps225) + ppsi*Z2225bar*PsP225^(theta*(1-ppsi)+1)*(z2225+(theta*(1-ppsi)+1)*ps225) = theta*chi*Z3225bar*PsP225^(-theta*(1-ppsi))*(z3225-theta*(1-ppsi)*ps225) - theta*chi*ppsi*Z4225bar*z4225;
(theta*(1-ppsi)-1)*Z1226bar*PsP226*(z1226+ps226) + ppsi*Z2226bar*PsP226^(theta*(1-ppsi)+1)*(z2226+(theta*(1-ppsi)+1)*ps226) = theta*chi*Z3226bar*PsP226^(-theta*(1-ppsi))*(z3226-theta*(1-ppsi)*ps226) - theta*chi*ppsi*Z4226bar*z4226;
(theta*(1-ppsi)-1)*Z1227bar*PsP227*(z1227+ps227) + ppsi*Z2227bar*PsP227^(theta*(1-ppsi)+1)*(z2227+(theta*(1-ppsi)+1)*ps227) = theta*chi*Z3227bar*PsP227^(-theta*(1-ppsi))*(z3227-theta*(1-ppsi)*ps227) - theta*chi*ppsi*Z4227bar*z4227;
(theta*(1-ppsi)-1)*Z1228bar*PsP228*(z1228+ps228) + ppsi*Z2228bar*PsP228^(theta*(1-ppsi)+1)*(z2228+(theta*(1-ppsi)+1)*ps228) = theta*chi*Z3228bar*PsP228^(-theta*(1-ppsi))*(z3228-theta*(1-ppsi)*ps228) - theta*chi*ppsi*Z4228bar*z4228;
(theta*(1-ppsi)-1)*Z1229bar*PsP229*(z1229+ps229) + ppsi*Z2229bar*PsP229^(theta*(1-ppsi)+1)*(z2229+(theta*(1-ppsi)+1)*ps229) = theta*chi*Z3229bar*PsP229^(-theta*(1-ppsi))*(z3229-theta*(1-ppsi)*ps229) - theta*chi*ppsi*Z4229bar*z4229;
(theta*(1-ppsi)-1)*Z1230bar*PsP230*(z1230+ps230) + ppsi*Z2230bar*PsP230^(theta*(1-ppsi)+1)*(z2230+(theta*(1-ppsi)+1)*ps230) = theta*chi*Z3230bar*PsP230^(-theta*(1-ppsi))*(z3230-theta*(1-ppsi)*ps230) - theta*chi*ppsi*Z4230bar*z4230;
(theta*(1-ppsi)-1)*Z1231bar*PsP231*(z1231+ps231) + ppsi*Z2231bar*PsP231^(theta*(1-ppsi)+1)*(z2231+(theta*(1-ppsi)+1)*ps231) = theta*chi*Z3231bar*PsP231^(-theta*(1-ppsi))*(z3231-theta*(1-ppsi)*ps231) - theta*chi*ppsi*Z4231bar*z4231;
(theta*(1-ppsi)-1)*Z1232bar*PsP232*(z1232+ps232) + ppsi*Z2232bar*PsP232^(theta*(1-ppsi)+1)*(z2232+(theta*(1-ppsi)+1)*ps232) = theta*chi*Z3232bar*PsP232^(-theta*(1-ppsi))*(z3232-theta*(1-ppsi)*ps232) - theta*chi*ppsi*Z4232bar*z4232;
(theta*(1-ppsi)-1)*Z1233bar*PsP233*(z1233+ps233) + ppsi*Z2233bar*PsP233^(theta*(1-ppsi)+1)*(z2233+(theta*(1-ppsi)+1)*ps233) = theta*chi*Z3233bar*PsP233^(-theta*(1-ppsi))*(z3233-theta*(1-ppsi)*ps233) - theta*chi*ppsi*Z4233bar*z4233;
(theta*(1-ppsi)-1)*Z1234bar*PsP234*(z1234+ps234) + ppsi*Z2234bar*PsP234^(theta*(1-ppsi)+1)*(z2234+(theta*(1-ppsi)+1)*ps234) = theta*chi*Z3234bar*PsP234^(-theta*(1-ppsi))*(z3234-theta*(1-ppsi)*ps234) - theta*chi*ppsi*Z4234bar*z4234;
(theta*(1-ppsi)-1)*Z1235bar*PsP235*(z1235+ps235) + ppsi*Z2235bar*PsP235^(theta*(1-ppsi)+1)*(z2235+(theta*(1-ppsi)+1)*ps235) = theta*chi*Z3235bar*PsP235^(-theta*(1-ppsi))*(z3235-theta*(1-ppsi)*ps235) - theta*chi*ppsi*Z4235bar*z4235;
(theta*(1-ppsi)-1)*Z1236bar*PsP236*(z1236+ps236) + ppsi*Z2236bar*PsP236^(theta*(1-ppsi)+1)*(z2236+(theta*(1-ppsi)+1)*ps236) = theta*chi*Z3236bar*PsP236^(-theta*(1-ppsi))*(z3236-theta*(1-ppsi)*ps236) - theta*chi*ppsi*Z4236bar*z4236;
(theta*(1-ppsi)-1)*Z1237bar*PsP237*(z1237+ps237) + ppsi*Z2237bar*PsP237^(theta*(1-ppsi)+1)*(z2237+(theta*(1-ppsi)+1)*ps237) = theta*chi*Z3237bar*PsP237^(-theta*(1-ppsi))*(z3237-theta*(1-ppsi)*ps237) - theta*chi*ppsi*Z4237bar*z4237;
(theta*(1-ppsi)-1)*Z1238bar*PsP238*(z1238+ps238) + ppsi*Z2238bar*PsP238^(theta*(1-ppsi)+1)*(z2238+(theta*(1-ppsi)+1)*ps238) = theta*chi*Z3238bar*PsP238^(-theta*(1-ppsi))*(z3238-theta*(1-ppsi)*ps238) - theta*chi*ppsi*Z4238bar*z4238;
(theta*(1-ppsi)-1)*Z1239bar*PsP239*(z1239+ps239) + ppsi*Z2239bar*PsP239^(theta*(1-ppsi)+1)*(z2239+(theta*(1-ppsi)+1)*ps239) = theta*chi*Z3239bar*PsP239^(-theta*(1-ppsi))*(z3239-theta*(1-ppsi)*ps239) - theta*chi*ppsi*Z4239bar*z4239;
(theta*(1-ppsi)-1)*Z1240bar*PsP240*(z1240+ps240) + ppsi*Z2240bar*PsP240^(theta*(1-ppsi)+1)*(z2240+(theta*(1-ppsi)+1)*ps240) = theta*chi*Z3240bar*PsP240^(-theta*(1-ppsi))*(z3240-theta*(1-ppsi)*ps240) - theta*chi*ppsi*Z4240bar*z4240;
(theta*(1-ppsi)-1)*Z1241bar*PsP241*(z1241+ps241) + ppsi*Z2241bar*PsP241^(theta*(1-ppsi)+1)*(z2241+(theta*(1-ppsi)+1)*ps241) = theta*chi*Z3241bar*PsP241^(-theta*(1-ppsi))*(z3241-theta*(1-ppsi)*ps241) - theta*chi*ppsi*Z4241bar*z4241;
(theta*(1-ppsi)-1)*Z1242bar*PsP242*(z1242+ps242) + ppsi*Z2242bar*PsP242^(theta*(1-ppsi)+1)*(z2242+(theta*(1-ppsi)+1)*ps242) = theta*chi*Z3242bar*PsP242^(-theta*(1-ppsi))*(z3242-theta*(1-ppsi)*ps242) - theta*chi*ppsi*Z4242bar*z4242;
(theta*(1-ppsi)-1)*Z1243bar*PsP243*(z1243+ps243) + ppsi*Z2243bar*PsP243^(theta*(1-ppsi)+1)*(z2243+(theta*(1-ppsi)+1)*ps243) = theta*chi*Z3243bar*PsP243^(-theta*(1-ppsi))*(z3243-theta*(1-ppsi)*ps243) - theta*chi*ppsi*Z4243bar*z4243;
(theta*(1-ppsi)-1)*Z1244bar*PsP244*(z1244+ps244) + ppsi*Z2244bar*PsP244^(theta*(1-ppsi)+1)*(z2244+(theta*(1-ppsi)+1)*ps244) = theta*chi*Z3244bar*PsP244^(-theta*(1-ppsi))*(z3244-theta*(1-ppsi)*ps244) - theta*chi*ppsi*Z4244bar*z4244;
(theta*(1-ppsi)-1)*Z1245bar*PsP245*(z1245+ps245) + ppsi*Z2245bar*PsP245^(theta*(1-ppsi)+1)*(z2245+(theta*(1-ppsi)+1)*ps245) = theta*chi*Z3245bar*PsP245^(-theta*(1-ppsi))*(z3245-theta*(1-ppsi)*ps245) - theta*chi*ppsi*Z4245bar*z4245;
(theta*(1-ppsi)-1)*Z1246bar*PsP246*(z1246+ps246) + ppsi*Z2246bar*PsP246^(theta*(1-ppsi)+1)*(z2246+(theta*(1-ppsi)+1)*ps246) = theta*chi*Z3246bar*PsP246^(-theta*(1-ppsi))*(z3246-theta*(1-ppsi)*ps246) - theta*chi*ppsi*Z4246bar*z4246;
(theta*(1-ppsi)-1)*Z1247bar*PsP247*(z1247+ps247) + ppsi*Z2247bar*PsP247^(theta*(1-ppsi)+1)*(z2247+(theta*(1-ppsi)+1)*ps247) = theta*chi*Z3247bar*PsP247^(-theta*(1-ppsi))*(z3247-theta*(1-ppsi)*ps247) - theta*chi*ppsi*Z4247bar*z4247;
(theta*(1-ppsi)-1)*Z1248bar*PsP248*(z1248+ps248) + ppsi*Z2248bar*PsP248^(theta*(1-ppsi)+1)*(z2248+(theta*(1-ppsi)+1)*ps248) = theta*chi*Z3248bar*PsP248^(-theta*(1-ppsi))*(z3248-theta*(1-ppsi)*ps248) - theta*chi*ppsi*Z4248bar*z4248;
(theta*(1-ppsi)-1)*Z1249bar*PsP249*(z1249+ps249) + ppsi*Z2249bar*PsP249^(theta*(1-ppsi)+1)*(z2249+(theta*(1-ppsi)+1)*ps249) = theta*chi*Z3249bar*PsP249^(-theta*(1-ppsi))*(z3249-theta*(1-ppsi)*ps249) - theta*chi*ppsi*Z4249bar*z4249;
(theta*(1-ppsi)-1)*Z1250bar*PsP250*(z1250+ps250) + ppsi*Z2250bar*PsP250^(theta*(1-ppsi)+1)*(z2250+(theta*(1-ppsi)+1)*ps250) = theta*chi*Z3250bar*PsP250^(-theta*(1-ppsi))*(z3250-theta*(1-ppsi)*ps250) - theta*chi*ppsi*Z4250bar*z4250;
(theta*(1-ppsi)-1)*Z1251bar*PsP251*(z1251+ps251) + ppsi*Z2251bar*PsP251^(theta*(1-ppsi)+1)*(z2251+(theta*(1-ppsi)+1)*ps251) = theta*chi*Z3251bar*PsP251^(-theta*(1-ppsi))*(z3251-theta*(1-ppsi)*ps251) - theta*chi*ppsi*Z4251bar*z4251;
(theta*(1-ppsi)-1)*Z1252bar*PsP252*(z1252+ps252) + ppsi*Z2252bar*PsP252^(theta*(1-ppsi)+1)*(z2252+(theta*(1-ppsi)+1)*ps252) = theta*chi*Z3252bar*PsP252^(-theta*(1-ppsi))*(z3252-theta*(1-ppsi)*ps252) - theta*chi*ppsi*Z4252bar*z4252;
(theta*(1-ppsi)-1)*Z1253bar*PsP253*(z1253+ps253) + ppsi*Z2253bar*PsP253^(theta*(1-ppsi)+1)*(z2253+(theta*(1-ppsi)+1)*ps253) = theta*chi*Z3253bar*PsP253^(-theta*(1-ppsi))*(z3253-theta*(1-ppsi)*ps253) - theta*chi*ppsi*Z4253bar*z4253;
(theta*(1-ppsi)-1)*Z1254bar*PsP254*(z1254+ps254) + ppsi*Z2254bar*PsP254^(theta*(1-ppsi)+1)*(z2254+(theta*(1-ppsi)+1)*ps254) = theta*chi*Z3254bar*PsP254^(-theta*(1-ppsi))*(z3254-theta*(1-ppsi)*ps254) - theta*chi*ppsi*Z4254bar*z4254;
(theta*(1-ppsi)-1)*Z1255bar*PsP255*(z1255+ps255) + ppsi*Z2255bar*PsP255^(theta*(1-ppsi)+1)*(z2255+(theta*(1-ppsi)+1)*ps255) = theta*chi*Z3255bar*PsP255^(-theta*(1-ppsi))*(z3255-theta*(1-ppsi)*ps255) - theta*chi*ppsi*Z4255bar*z4255;
(theta*(1-ppsi)-1)*Z1256bar*PsP256*(z1256+ps256) + ppsi*Z2256bar*PsP256^(theta*(1-ppsi)+1)*(z2256+(theta*(1-ppsi)+1)*ps256) = theta*chi*Z3256bar*PsP256^(-theta*(1-ppsi))*(z3256-theta*(1-ppsi)*ps256) - theta*chi*ppsi*Z4256bar*z4256;
(theta*(1-ppsi)-1)*Z1257bar*PsP257*(z1257+ps257) + ppsi*Z2257bar*PsP257^(theta*(1-ppsi)+1)*(z2257+(theta*(1-ppsi)+1)*ps257) = theta*chi*Z3257bar*PsP257^(-theta*(1-ppsi))*(z3257-theta*(1-ppsi)*ps257) - theta*chi*ppsi*Z4257bar*z4257;
(theta*(1-ppsi)-1)*Z1258bar*PsP258*(z1258+ps258) + ppsi*Z2258bar*PsP258^(theta*(1-ppsi)+1)*(z2258+(theta*(1-ppsi)+1)*ps258) = theta*chi*Z3258bar*PsP258^(-theta*(1-ppsi))*(z3258-theta*(1-ppsi)*ps258) - theta*chi*ppsi*Z4258bar*z4258;
(theta*(1-ppsi)-1)*Z1259bar*PsP259*(z1259+ps259) + ppsi*Z2259bar*PsP259^(theta*(1-ppsi)+1)*(z2259+(theta*(1-ppsi)+1)*ps259) = theta*chi*Z3259bar*PsP259^(-theta*(1-ppsi))*(z3259-theta*(1-ppsi)*ps259) - theta*chi*ppsi*Z4259bar*z4259;
(theta*(1-ppsi)-1)*Z1260bar*PsP260*(z1260+ps260) + ppsi*Z2260bar*PsP260^(theta*(1-ppsi)+1)*(z2260+(theta*(1-ppsi)+1)*ps260) = theta*chi*Z3260bar*PsP260^(-theta*(1-ppsi))*(z3260-theta*(1-ppsi)*ps260) - theta*chi*ppsi*Z4260bar*z4260;
(theta*(1-ppsi)-1)*Z1261bar*PsP261*(z1261+ps261) + ppsi*Z2261bar*PsP261^(theta*(1-ppsi)+1)*(z2261+(theta*(1-ppsi)+1)*ps261) = theta*chi*Z3261bar*PsP261^(-theta*(1-ppsi))*(z3261-theta*(1-ppsi)*ps261) - theta*chi*ppsi*Z4261bar*z4261;
(theta*(1-ppsi)-1)*Z1262bar*PsP262*(z1262+ps262) + ppsi*Z2262bar*PsP262^(theta*(1-ppsi)+1)*(z2262+(theta*(1-ppsi)+1)*ps262) = theta*chi*Z3262bar*PsP262^(-theta*(1-ppsi))*(z3262-theta*(1-ppsi)*ps262) - theta*chi*ppsi*Z4262bar*z4262;
(theta*(1-ppsi)-1)*Z1263bar*PsP263*(z1263+ps263) + ppsi*Z2263bar*PsP263^(theta*(1-ppsi)+1)*(z2263+(theta*(1-ppsi)+1)*ps263) = theta*chi*Z3263bar*PsP263^(-theta*(1-ppsi))*(z3263-theta*(1-ppsi)*ps263) - theta*chi*ppsi*Z4263bar*z4263;
(theta*(1-ppsi)-1)*Z1264bar*PsP264*(z1264+ps264) + ppsi*Z2264bar*PsP264^(theta*(1-ppsi)+1)*(z2264+(theta*(1-ppsi)+1)*ps264) = theta*chi*Z3264bar*PsP264^(-theta*(1-ppsi))*(z3264-theta*(1-ppsi)*ps264) - theta*chi*ppsi*Z4264bar*z4264;
(theta*(1-ppsi)-1)*Z1265bar*PsP265*(z1265+ps265) + ppsi*Z2265bar*PsP265^(theta*(1-ppsi)+1)*(z2265+(theta*(1-ppsi)+1)*ps265) = theta*chi*Z3265bar*PsP265^(-theta*(1-ppsi))*(z3265-theta*(1-ppsi)*ps265) - theta*chi*ppsi*Z4265bar*z4265;
(theta*(1-ppsi)-1)*Z1266bar*PsP266*(z1266+ps266) + ppsi*Z2266bar*PsP266^(theta*(1-ppsi)+1)*(z2266+(theta*(1-ppsi)+1)*ps266) = theta*chi*Z3266bar*PsP266^(-theta*(1-ppsi))*(z3266-theta*(1-ppsi)*ps266) - theta*chi*ppsi*Z4266bar*z4266;
(theta*(1-ppsi)-1)*Z1267bar*PsP267*(z1267+ps267) + ppsi*Z2267bar*PsP267^(theta*(1-ppsi)+1)*(z2267+(theta*(1-ppsi)+1)*ps267) = theta*chi*Z3267bar*PsP267^(-theta*(1-ppsi))*(z3267-theta*(1-ppsi)*ps267) - theta*chi*ppsi*Z4267bar*z4267;
(theta*(1-ppsi)-1)*Z1268bar*PsP268*(z1268+ps268) + ppsi*Z2268bar*PsP268^(theta*(1-ppsi)+1)*(z2268+(theta*(1-ppsi)+1)*ps268) = theta*chi*Z3268bar*PsP268^(-theta*(1-ppsi))*(z3268-theta*(1-ppsi)*ps268) - theta*chi*ppsi*Z4268bar*z4268;
(theta*(1-ppsi)-1)*Z1269bar*PsP269*(z1269+ps269) + ppsi*Z2269bar*PsP269^(theta*(1-ppsi)+1)*(z2269+(theta*(1-ppsi)+1)*ps269) = theta*chi*Z3269bar*PsP269^(-theta*(1-ppsi))*(z3269-theta*(1-ppsi)*ps269) - theta*chi*ppsi*Z4269bar*z4269;
(theta*(1-ppsi)-1)*Z1270bar*PsP270*(z1270+ps270) + ppsi*Z2270bar*PsP270^(theta*(1-ppsi)+1)*(z2270+(theta*(1-ppsi)+1)*ps270) = theta*chi*Z3270bar*PsP270^(-theta*(1-ppsi))*(z3270-theta*(1-ppsi)*ps270) - theta*chi*ppsi*Z4270bar*z4270;
(theta*(1-ppsi)-1)*Z1271bar*PsP271*(z1271+ps271) + ppsi*Z2271bar*PsP271^(theta*(1-ppsi)+1)*(z2271+(theta*(1-ppsi)+1)*ps271) = theta*chi*Z3271bar*PsP271^(-theta*(1-ppsi))*(z3271-theta*(1-ppsi)*ps271) - theta*chi*ppsi*Z4271bar*z4271;
(theta*(1-ppsi)-1)*Z1272bar*PsP272*(z1272+ps272) + ppsi*Z2272bar*PsP272^(theta*(1-ppsi)+1)*(z2272+(theta*(1-ppsi)+1)*ps272) = theta*chi*Z3272bar*PsP272^(-theta*(1-ppsi))*(z3272-theta*(1-ppsi)*ps272) - theta*chi*ppsi*Z4272bar*z4272;

i = rhoi*i(-1) + (1-rhoi)*(phipi*p + phiy*y) + er;

end;

% steady state

steady_state_model;

y=0; i=0; p=0; lam=0;
ps001=0; s001=0; lam001=0; z1001=0; z2001=0; z3001=0; z4001=0;
ps002=0; s002=0; lam002=0; z1002=0; z2002=0; z3002=0; z4002=0;
ps003=0; s003=0; lam003=0; z1003=0; z2003=0; z3003=0; z4003=0;
ps004=0; s004=0; lam004=0; z1004=0; z2004=0; z3004=0; z4004=0;
ps005=0; s005=0; lam005=0; z1005=0; z2005=0; z3005=0; z4005=0;
ps006=0; s006=0; lam006=0; z1006=0; z2006=0; z3006=0; z4006=0;
ps007=0; s007=0; lam007=0; z1007=0; z2007=0; z3007=0; z4007=0;
ps008=0; s008=0; lam008=0; z1008=0; z2008=0; z3008=0; z4008=0;
ps009=0; s009=0; lam009=0; z1009=0; z2009=0; z3009=0; z4009=0;
ps010=0; s010=0; lam010=0; z1010=0; z2010=0; z3010=0; z4010=0;
ps011=0; s011=0; lam011=0; z1011=0; z2011=0; z3011=0; z4011=0;
ps012=0; s012=0; lam012=0; z1012=0; z2012=0; z3012=0; z4012=0;
ps013=0; s013=0; lam013=0; z1013=0; z2013=0; z3013=0; z4013=0;
ps014=0; s014=0; lam014=0; z1014=0; z2014=0; z3014=0; z4014=0;
ps015=0; s015=0; lam015=0; z1015=0; z2015=0; z3015=0; z4015=0;
ps016=0; s016=0; lam016=0; z1016=0; z2016=0; z3016=0; z4016=0;
ps017=0; s017=0; lam017=0; z1017=0; z2017=0; z3017=0; z4017=0;
ps018=0; s018=0; lam018=0; z1018=0; z2018=0; z3018=0; z4018=0;
ps019=0; s019=0; lam019=0; z1019=0; z2019=0; z3019=0; z4019=0;
ps020=0; s020=0; lam020=0; z1020=0; z2020=0; z3020=0; z4020=0;
ps021=0; s021=0; lam021=0; z1021=0; z2021=0; z3021=0; z4021=0;
ps022=0; s022=0; lam022=0; z1022=0; z2022=0; z3022=0; z4022=0;
ps023=0; s023=0; lam023=0; z1023=0; z2023=0; z3023=0; z4023=0;
ps024=0; s024=0; lam024=0; z1024=0; z2024=0; z3024=0; z4024=0;
ps025=0; s025=0; lam025=0; z1025=0; z2025=0; z3025=0; z4025=0;
ps026=0; s026=0; lam026=0; z1026=0; z2026=0; z3026=0; z4026=0;
ps027=0; s027=0; lam027=0; z1027=0; z2027=0; z3027=0; z4027=0;
ps028=0; s028=0; lam028=0; z1028=0; z2028=0; z3028=0; z4028=0;
ps029=0; s029=0; lam029=0; z1029=0; z2029=0; z3029=0; z4029=0;
ps030=0; s030=0; lam030=0; z1030=0; z2030=0; z3030=0; z4030=0;
ps031=0; s031=0; lam031=0; z1031=0; z2031=0; z3031=0; z4031=0;
ps032=0; s032=0; lam032=0; z1032=0; z2032=0; z3032=0; z4032=0;
ps033=0; s033=0; lam033=0; z1033=0; z2033=0; z3033=0; z4033=0;
ps034=0; s034=0; lam034=0; z1034=0; z2034=0; z3034=0; z4034=0;
ps035=0; s035=0; lam035=0; z1035=0; z2035=0; z3035=0; z4035=0;
ps036=0; s036=0; lam036=0; z1036=0; z2036=0; z3036=0; z4036=0;
ps037=0; s037=0; lam037=0; z1037=0; z2037=0; z3037=0; z4037=0;
ps038=0; s038=0; lam038=0; z1038=0; z2038=0; z3038=0; z4038=0;
ps039=0; s039=0; lam039=0; z1039=0; z2039=0; z3039=0; z4039=0;
ps040=0; s040=0; lam040=0; z1040=0; z2040=0; z3040=0; z4040=0;
ps041=0; s041=0; lam041=0; z1041=0; z2041=0; z3041=0; z4041=0;
ps042=0; s042=0; lam042=0; z1042=0; z2042=0; z3042=0; z4042=0;
ps043=0; s043=0; lam043=0; z1043=0; z2043=0; z3043=0; z4043=0;
ps044=0; s044=0; lam044=0; z1044=0; z2044=0; z3044=0; z4044=0;
ps045=0; s045=0; lam045=0; z1045=0; z2045=0; z3045=0; z4045=0;
ps046=0; s046=0; lam046=0; z1046=0; z2046=0; z3046=0; z4046=0;
ps047=0; s047=0; lam047=0; z1047=0; z2047=0; z3047=0; z4047=0;
ps048=0; s048=0; lam048=0; z1048=0; z2048=0; z3048=0; z4048=0;
ps049=0; s049=0; lam049=0; z1049=0; z2049=0; z3049=0; z4049=0;
ps050=0; s050=0; lam050=0; z1050=0; z2050=0; z3050=0; z4050=0;
ps051=0; s051=0; lam051=0; z1051=0; z2051=0; z3051=0; z4051=0;
ps052=0; s052=0; lam052=0; z1052=0; z2052=0; z3052=0; z4052=0;
ps053=0; s053=0; lam053=0; z1053=0; z2053=0; z3053=0; z4053=0;
ps054=0; s054=0; lam054=0; z1054=0; z2054=0; z3054=0; z4054=0;
ps055=0; s055=0; lam055=0; z1055=0; z2055=0; z3055=0; z4055=0;
ps056=0; s056=0; lam056=0; z1056=0; z2056=0; z3056=0; z4056=0;
ps057=0; s057=0; lam057=0; z1057=0; z2057=0; z3057=0; z4057=0;
ps058=0; s058=0; lam058=0; z1058=0; z2058=0; z3058=0; z4058=0;
ps059=0; s059=0; lam059=0; z1059=0; z2059=0; z3059=0; z4059=0;
ps060=0; s060=0; lam060=0; z1060=0; z2060=0; z3060=0; z4060=0;
ps061=0; s061=0; lam061=0; z1061=0; z2061=0; z3061=0; z4061=0;
ps062=0; s062=0; lam062=0; z1062=0; z2062=0; z3062=0; z4062=0;
ps063=0; s063=0; lam063=0; z1063=0; z2063=0; z3063=0; z4063=0;
ps064=0; s064=0; lam064=0; z1064=0; z2064=0; z3064=0; z4064=0;
ps065=0; s065=0; lam065=0; z1065=0; z2065=0; z3065=0; z4065=0;
ps066=0; s066=0; lam066=0; z1066=0; z2066=0; z3066=0; z4066=0;
ps067=0; s067=0; lam067=0; z1067=0; z2067=0; z3067=0; z4067=0;
ps068=0; s068=0; lam068=0; z1068=0; z2068=0; z3068=0; z4068=0;
ps069=0; s069=0; lam069=0; z1069=0; z2069=0; z3069=0; z4069=0;
ps070=0; s070=0; lam070=0; z1070=0; z2070=0; z3070=0; z4070=0;
ps071=0; s071=0; lam071=0; z1071=0; z2071=0; z3071=0; z4071=0;
ps072=0; s072=0; lam072=0; z1072=0; z2072=0; z3072=0; z4072=0;
ps073=0; s073=0; lam073=0; z1073=0; z2073=0; z3073=0; z4073=0;
ps074=0; s074=0; lam074=0; z1074=0; z2074=0; z3074=0; z4074=0;
ps075=0; s075=0; lam075=0; z1075=0; z2075=0; z3075=0; z4075=0;
ps076=0; s076=0; lam076=0; z1076=0; z2076=0; z3076=0; z4076=0;
ps077=0; s077=0; lam077=0; z1077=0; z2077=0; z3077=0; z4077=0;
ps078=0; s078=0; lam078=0; z1078=0; z2078=0; z3078=0; z4078=0;
ps079=0; s079=0; lam079=0; z1079=0; z2079=0; z3079=0; z4079=0;
ps080=0; s080=0; lam080=0; z1080=0; z2080=0; z3080=0; z4080=0;
ps081=0; s081=0; lam081=0; z1081=0; z2081=0; z3081=0; z4081=0;
ps082=0; s082=0; lam082=0; z1082=0; z2082=0; z3082=0; z4082=0;
ps083=0; s083=0; lam083=0; z1083=0; z2083=0; z3083=0; z4083=0;
ps084=0; s084=0; lam084=0; z1084=0; z2084=0; z3084=0; z4084=0;
ps085=0; s085=0; lam085=0; z1085=0; z2085=0; z3085=0; z4085=0;
ps086=0; s086=0; lam086=0; z1086=0; z2086=0; z3086=0; z4086=0;
ps087=0; s087=0; lam087=0; z1087=0; z2087=0; z3087=0; z4087=0;
ps088=0; s088=0; lam088=0; z1088=0; z2088=0; z3088=0; z4088=0;
ps089=0; s089=0; lam089=0; z1089=0; z2089=0; z3089=0; z4089=0;
ps090=0; s090=0; lam090=0; z1090=0; z2090=0; z3090=0; z4090=0;
ps091=0; s091=0; lam091=0; z1091=0; z2091=0; z3091=0; z4091=0;
ps092=0; s092=0; lam092=0; z1092=0; z2092=0; z3092=0; z4092=0;
ps093=0; s093=0; lam093=0; z1093=0; z2093=0; z3093=0; z4093=0;
ps094=0; s094=0; lam094=0; z1094=0; z2094=0; z3094=0; z4094=0;
ps095=0; s095=0; lam095=0; z1095=0; z2095=0; z3095=0; z4095=0;
ps096=0; s096=0; lam096=0; z1096=0; z2096=0; z3096=0; z4096=0;
ps097=0; s097=0; lam097=0; z1097=0; z2097=0; z3097=0; z4097=0;
ps098=0; s098=0; lam098=0; z1098=0; z2098=0; z3098=0; z4098=0;
ps099=0; s099=0; lam099=0; z1099=0; z2099=0; z3099=0; z4099=0;
ps100=0; s100=0; lam100=0; z1100=0; z2100=0; z3100=0; z4100=0;
ps101=0; s101=0; lam101=0; z1101=0; z2101=0; z3101=0; z4101=0;
ps102=0; s102=0; lam102=0; z1102=0; z2102=0; z3102=0; z4102=0;
ps103=0; s103=0; lam103=0; z1103=0; z2103=0; z3103=0; z4103=0;
ps104=0; s104=0; lam104=0; z1104=0; z2104=0; z3104=0; z4104=0;
ps105=0; s105=0; lam105=0; z1105=0; z2105=0; z3105=0; z4105=0;
ps106=0; s106=0; lam106=0; z1106=0; z2106=0; z3106=0; z4106=0;
ps107=0; s107=0; lam107=0; z1107=0; z2107=0; z3107=0; z4107=0;
ps108=0; s108=0; lam108=0; z1108=0; z2108=0; z3108=0; z4108=0;
ps109=0; s109=0; lam109=0; z1109=0; z2109=0; z3109=0; z4109=0;
ps110=0; s110=0; lam110=0; z1110=0; z2110=0; z3110=0; z4110=0;
ps111=0; s111=0; lam111=0; z1111=0; z2111=0; z3111=0; z4111=0;
ps112=0; s112=0; lam112=0; z1112=0; z2112=0; z3112=0; z4112=0;
ps113=0; s113=0; lam113=0; z1113=0; z2113=0; z3113=0; z4113=0;
ps114=0; s114=0; lam114=0; z1114=0; z2114=0; z3114=0; z4114=0;
ps115=0; s115=0; lam115=0; z1115=0; z2115=0; z3115=0; z4115=0;
ps116=0; s116=0; lam116=0; z1116=0; z2116=0; z3116=0; z4116=0;
ps117=0; s117=0; lam117=0; z1117=0; z2117=0; z3117=0; z4117=0;
ps118=0; s118=0; lam118=0; z1118=0; z2118=0; z3118=0; z4118=0;
ps119=0; s119=0; lam119=0; z1119=0; z2119=0; z3119=0; z4119=0;
ps120=0; s120=0; lam120=0; z1120=0; z2120=0; z3120=0; z4120=0;
ps121=0; s121=0; lam121=0; z1121=0; z2121=0; z3121=0; z4121=0;
ps122=0; s122=0; lam122=0; z1122=0; z2122=0; z3122=0; z4122=0;
ps123=0; s123=0; lam123=0; z1123=0; z2123=0; z3123=0; z4123=0;
ps124=0; s124=0; lam124=0; z1124=0; z2124=0; z3124=0; z4124=0;
ps125=0; s125=0; lam125=0; z1125=0; z2125=0; z3125=0; z4125=0;
ps126=0; s126=0; lam126=0; z1126=0; z2126=0; z3126=0; z4126=0;
ps127=0; s127=0; lam127=0; z1127=0; z2127=0; z3127=0; z4127=0;
ps128=0; s128=0; lam128=0; z1128=0; z2128=0; z3128=0; z4128=0;
ps129=0; s129=0; lam129=0; z1129=0; z2129=0; z3129=0; z4129=0;
ps130=0; s130=0; lam130=0; z1130=0; z2130=0; z3130=0; z4130=0;
ps131=0; s131=0; lam131=0; z1131=0; z2131=0; z3131=0; z4131=0;
ps132=0; s132=0; lam132=0; z1132=0; z2132=0; z3132=0; z4132=0;
ps133=0; s133=0; lam133=0; z1133=0; z2133=0; z3133=0; z4133=0;
ps134=0; s134=0; lam134=0; z1134=0; z2134=0; z3134=0; z4134=0;
ps135=0; s135=0; lam135=0; z1135=0; z2135=0; z3135=0; z4135=0;
ps136=0; s136=0; lam136=0; z1136=0; z2136=0; z3136=0; z4136=0;
ps137=0; s137=0; lam137=0; z1137=0; z2137=0; z3137=0; z4137=0;
ps138=0; s138=0; lam138=0; z1138=0; z2138=0; z3138=0; z4138=0;
ps139=0; s139=0; lam139=0; z1139=0; z2139=0; z3139=0; z4139=0;
ps140=0; s140=0; lam140=0; z1140=0; z2140=0; z3140=0; z4140=0;
ps141=0; s141=0; lam141=0; z1141=0; z2141=0; z3141=0; z4141=0;
ps142=0; s142=0; lam142=0; z1142=0; z2142=0; z3142=0; z4142=0;
ps143=0; s143=0; lam143=0; z1143=0; z2143=0; z3143=0; z4143=0;
ps144=0; s144=0; lam144=0; z1144=0; z2144=0; z3144=0; z4144=0;
ps145=0; s145=0; lam145=0; z1145=0; z2145=0; z3145=0; z4145=0;
ps146=0; s146=0; lam146=0; z1146=0; z2146=0; z3146=0; z4146=0;
ps147=0; s147=0; lam147=0; z1147=0; z2147=0; z3147=0; z4147=0;
ps148=0; s148=0; lam148=0; z1148=0; z2148=0; z3148=0; z4148=0;
ps149=0; s149=0; lam149=0; z1149=0; z2149=0; z3149=0; z4149=0;
ps150=0; s150=0; lam150=0; z1150=0; z2150=0; z3150=0; z4150=0;
ps151=0; s151=0; lam151=0; z1151=0; z2151=0; z3151=0; z4151=0;
ps152=0; s152=0; lam152=0; z1152=0; z2152=0; z3152=0; z4152=0;
ps153=0; s153=0; lam153=0; z1153=0; z2153=0; z3153=0; z4153=0;
ps154=0; s154=0; lam154=0; z1154=0; z2154=0; z3154=0; z4154=0;
ps155=0; s155=0; lam155=0; z1155=0; z2155=0; z3155=0; z4155=0;
ps156=0; s156=0; lam156=0; z1156=0; z2156=0; z3156=0; z4156=0;
ps157=0; s157=0; lam157=0; z1157=0; z2157=0; z3157=0; z4157=0;
ps158=0; s158=0; lam158=0; z1158=0; z2158=0; z3158=0; z4158=0;
ps159=0; s159=0; lam159=0; z1159=0; z2159=0; z3159=0; z4159=0;
ps160=0; s160=0; lam160=0; z1160=0; z2160=0; z3160=0; z4160=0;
ps161=0; s161=0; lam161=0; z1161=0; z2161=0; z3161=0; z4161=0;
ps162=0; s162=0; lam162=0; z1162=0; z2162=0; z3162=0; z4162=0;
ps163=0; s163=0; lam163=0; z1163=0; z2163=0; z3163=0; z4163=0;
ps164=0; s164=0; lam164=0; z1164=0; z2164=0; z3164=0; z4164=0;
ps165=0; s165=0; lam165=0; z1165=0; z2165=0; z3165=0; z4165=0;
ps166=0; s166=0; lam166=0; z1166=0; z2166=0; z3166=0; z4166=0;
ps167=0; s167=0; lam167=0; z1167=0; z2167=0; z3167=0; z4167=0;
ps168=0; s168=0; lam168=0; z1168=0; z2168=0; z3168=0; z4168=0;
ps169=0; s169=0; lam169=0; z1169=0; z2169=0; z3169=0; z4169=0;
ps170=0; s170=0; lam170=0; z1170=0; z2170=0; z3170=0; z4170=0;
ps171=0; s171=0; lam171=0; z1171=0; z2171=0; z3171=0; z4171=0;
ps172=0; s172=0; lam172=0; z1172=0; z2172=0; z3172=0; z4172=0;
ps173=0; s173=0; lam173=0; z1173=0; z2173=0; z3173=0; z4173=0;
ps174=0; s174=0; lam174=0; z1174=0; z2174=0; z3174=0; z4174=0;
ps175=0; s175=0; lam175=0; z1175=0; z2175=0; z3175=0; z4175=0;
ps176=0; s176=0; lam176=0; z1176=0; z2176=0; z3176=0; z4176=0;
ps177=0; s177=0; lam177=0; z1177=0; z2177=0; z3177=0; z4177=0;
ps178=0; s178=0; lam178=0; z1178=0; z2178=0; z3178=0; z4178=0;
ps179=0; s179=0; lam179=0; z1179=0; z2179=0; z3179=0; z4179=0;
ps180=0; s180=0; lam180=0; z1180=0; z2180=0; z3180=0; z4180=0;
ps181=0; s181=0; lam181=0; z1181=0; z2181=0; z3181=0; z4181=0;
ps182=0; s182=0; lam182=0; z1182=0; z2182=0; z3182=0; z4182=0;
ps183=0; s183=0; lam183=0; z1183=0; z2183=0; z3183=0; z4183=0;
ps184=0; s184=0; lam184=0; z1184=0; z2184=0; z3184=0; z4184=0;
ps185=0; s185=0; lam185=0; z1185=0; z2185=0; z3185=0; z4185=0;
ps186=0; s186=0; lam186=0; z1186=0; z2186=0; z3186=0; z4186=0;
ps187=0; s187=0; lam187=0; z1187=0; z2187=0; z3187=0; z4187=0;
ps188=0; s188=0; lam188=0; z1188=0; z2188=0; z3188=0; z4188=0;
ps189=0; s189=0; lam189=0; z1189=0; z2189=0; z3189=0; z4189=0;
ps190=0; s190=0; lam190=0; z1190=0; z2190=0; z3190=0; z4190=0;
ps191=0; s191=0; lam191=0; z1191=0; z2191=0; z3191=0; z4191=0;
ps192=0; s192=0; lam192=0; z1192=0; z2192=0; z3192=0; z4192=0;
ps193=0; s193=0; lam193=0; z1193=0; z2193=0; z3193=0; z4193=0;
ps194=0; s194=0; lam194=0; z1194=0; z2194=0; z3194=0; z4194=0;
ps195=0; s195=0; lam195=0; z1195=0; z2195=0; z3195=0; z4195=0;
ps196=0; s196=0; lam196=0; z1196=0; z2196=0; z3196=0; z4196=0;
ps197=0; s197=0; lam197=0; z1197=0; z2197=0; z3197=0; z4197=0;
ps198=0; s198=0; lam198=0; z1198=0; z2198=0; z3198=0; z4198=0;
ps199=0; s199=0; lam199=0; z1199=0; z2199=0; z3199=0; z4199=0;
ps200=0; s200=0; lam200=0; z1200=0; z2200=0; z3200=0; z4200=0;
ps201=0; s201=0; lam201=0; z1201=0; z2201=0; z3201=0; z4201=0;
ps202=0; s202=0; lam202=0; z1202=0; z2202=0; z3202=0; z4202=0;
ps203=0; s203=0; lam203=0; z1203=0; z2203=0; z3203=0; z4203=0;
ps204=0; s204=0; lam204=0; z1204=0; z2204=0; z3204=0; z4204=0;
ps205=0; s205=0; lam205=0; z1205=0; z2205=0; z3205=0; z4205=0;
ps206=0; s206=0; lam206=0; z1206=0; z2206=0; z3206=0; z4206=0;
ps207=0; s207=0; lam207=0; z1207=0; z2207=0; z3207=0; z4207=0;
ps208=0; s208=0; lam208=0; z1208=0; z2208=0; z3208=0; z4208=0;
ps209=0; s209=0; lam209=0; z1209=0; z2209=0; z3209=0; z4209=0;
ps210=0; s210=0; lam210=0; z1210=0; z2210=0; z3210=0; z4210=0;
ps211=0; s211=0; lam211=0; z1211=0; z2211=0; z3211=0; z4211=0;
ps212=0; s212=0; lam212=0; z1212=0; z2212=0; z3212=0; z4212=0;
ps213=0; s213=0; lam213=0; z1213=0; z2213=0; z3213=0; z4213=0;
ps214=0; s214=0; lam214=0; z1214=0; z2214=0; z3214=0; z4214=0;
ps215=0; s215=0; lam215=0; z1215=0; z2215=0; z3215=0; z4215=0;
ps216=0; s216=0; lam216=0; z1216=0; z2216=0; z3216=0; z4216=0;
ps217=0; s217=0; lam217=0; z1217=0; z2217=0; z3217=0; z4217=0;
ps218=0; s218=0; lam218=0; z1218=0; z2218=0; z3218=0; z4218=0;
ps219=0; s219=0; lam219=0; z1219=0; z2219=0; z3219=0; z4219=0;
ps220=0; s220=0; lam220=0; z1220=0; z2220=0; z3220=0; z4220=0;
ps221=0; s221=0; lam221=0; z1221=0; z2221=0; z3221=0; z4221=0;
ps222=0; s222=0; lam222=0; z1222=0; z2222=0; z3222=0; z4222=0;
ps223=0; s223=0; lam223=0; z1223=0; z2223=0; z3223=0; z4223=0;
ps224=0; s224=0; lam224=0; z1224=0; z2224=0; z3224=0; z4224=0;
ps225=0; s225=0; lam225=0; z1225=0; z2225=0; z3225=0; z4225=0;
ps226=0; s226=0; lam226=0; z1226=0; z2226=0; z3226=0; z4226=0;
ps227=0; s227=0; lam227=0; z1227=0; z2227=0; z3227=0; z4227=0;
ps228=0; s228=0; lam228=0; z1228=0; z2228=0; z3228=0; z4228=0;
ps229=0; s229=0; lam229=0; z1229=0; z2229=0; z3229=0; z4229=0;
ps230=0; s230=0; lam230=0; z1230=0; z2230=0; z3230=0; z4230=0;
ps231=0; s231=0; lam231=0; z1231=0; z2231=0; z3231=0; z4231=0;
ps232=0; s232=0; lam232=0; z1232=0; z2232=0; z3232=0; z4232=0;
ps233=0; s233=0; lam233=0; z1233=0; z2233=0; z3233=0; z4233=0;
ps234=0; s234=0; lam234=0; z1234=0; z2234=0; z3234=0; z4234=0;
ps235=0; s235=0; lam235=0; z1235=0; z2235=0; z3235=0; z4235=0;
ps236=0; s236=0; lam236=0; z1236=0; z2236=0; z3236=0; z4236=0;
ps237=0; s237=0; lam237=0; z1237=0; z2237=0; z3237=0; z4237=0;
ps238=0; s238=0; lam238=0; z1238=0; z2238=0; z3238=0; z4238=0;
ps239=0; s239=0; lam239=0; z1239=0; z2239=0; z3239=0; z4239=0;
ps240=0; s240=0; lam240=0; z1240=0; z2240=0; z3240=0; z4240=0;
ps241=0; s241=0; lam241=0; z1241=0; z2241=0; z3241=0; z4241=0;
ps242=0; s242=0; lam242=0; z1242=0; z2242=0; z3242=0; z4242=0;
ps243=0; s243=0; lam243=0; z1243=0; z2243=0; z3243=0; z4243=0;
ps244=0; s244=0; lam244=0; z1244=0; z2244=0; z3244=0; z4244=0;
ps245=0; s245=0; lam245=0; z1245=0; z2245=0; z3245=0; z4245=0;
ps246=0; s246=0; lam246=0; z1246=0; z2246=0; z3246=0; z4246=0;
ps247=0; s247=0; lam247=0; z1247=0; z2247=0; z3247=0; z4247=0;
ps248=0; s248=0; lam248=0; z1248=0; z2248=0; z3248=0; z4248=0;
ps249=0; s249=0; lam249=0; z1249=0; z2249=0; z3249=0; z4249=0;
ps250=0; s250=0; lam250=0; z1250=0; z2250=0; z3250=0; z4250=0;
ps251=0; s251=0; lam251=0; z1251=0; z2251=0; z3251=0; z4251=0;
ps252=0; s252=0; lam252=0; z1252=0; z2252=0; z3252=0; z4252=0;
ps253=0; s253=0; lam253=0; z1253=0; z2253=0; z3253=0; z4253=0;
ps254=0; s254=0; lam254=0; z1254=0; z2254=0; z3254=0; z4254=0;
ps255=0; s255=0; lam255=0; z1255=0; z2255=0; z3255=0; z4255=0;
ps256=0; s256=0; lam256=0; z1256=0; z2256=0; z3256=0; z4256=0;
ps257=0; s257=0; lam257=0; z1257=0; z2257=0; z3257=0; z4257=0;
ps258=0; s258=0; lam258=0; z1258=0; z2258=0; z3258=0; z4258=0;
ps259=0; s259=0; lam259=0; z1259=0; z2259=0; z3259=0; z4259=0;
ps260=0; s260=0; lam260=0; z1260=0; z2260=0; z3260=0; z4260=0;
ps261=0; s261=0; lam261=0; z1261=0; z2261=0; z3261=0; z4261=0;
ps262=0; s262=0; lam262=0; z1262=0; z2262=0; z3262=0; z4262=0;
ps263=0; s263=0; lam263=0; z1263=0; z2263=0; z3263=0; z4263=0;
ps264=0; s264=0; lam264=0; z1264=0; z2264=0; z3264=0; z4264=0;
ps265=0; s265=0; lam265=0; z1265=0; z2265=0; z3265=0; z4265=0;
ps266=0; s266=0; lam266=0; z1266=0; z2266=0; z3266=0; z4266=0;
ps267=0; s267=0; lam267=0; z1267=0; z2267=0; z3267=0; z4267=0;
ps268=0; s268=0; lam268=0; z1268=0; z2268=0; z3268=0; z4268=0;
ps269=0; s269=0; lam269=0; z1269=0; z2269=0; z3269=0; z4269=0;
ps270=0; s270=0; lam270=0; z1270=0; z2270=0; z3270=0; z4270=0;
ps271=0; s271=0; lam271=0; z1271=0; z2271=0; z3271=0; z4271=0;
ps272=0; s272=0; lam272=0; z1272=0; z2272=0; z3272=0; z4272=0;

end;

%% loop

tic;

for ind6=1:phipin

    phipi = phipis(ind6);

disp('===============================================================')
fprintf('phipi = %8.4f (%i out of %i)\n',phipi,ind6,phipin)
disp('===============================================================')

    detchk0 = [];
    bnd0    = [];

for ind7 = 1:phiyn;

    phiy = phiys(ind7);

    check;

    deteig = sum(abs(oo_.dr.eigval)>1);
    detchk(ind6,ind7) = (deteig==M_.nsfwrd);

    if (~isempty(detchk0))
        if (detchk0~=detchk(ind6,ind7))
            bnd0 = [bnd0; phiy-0.5*phiyinc];
            detchk0 = detchk(ind6,ind7);
        end
    else
        detchk0 = detchk(ind6,ind7);
    end
        
end % ind7

    bnds{ind6} = bnd0;

end % ind6

toc;

save([filenm '.mat'],'phipis','phiys','detchk','bnds')
