function y=func_kinked_linear_NS_SS(x,J,bet,alphs,fs,Pibar,theta,sigm,chi,ppsi)
% Computes the violations of the optimality conditions for the final goods firms
% and intermediate goods firms to solve for the steady state

% exp(x(2:end)) = Pi/P;
thetppsi = theta*(1-ppsi);

y = zeros(J+1,1);

Lam_j_powered = alphs./(1-(1-alphs)*Pibar^(thetppsi-1)).*exp((1-thetppsi)*x(2:end));
Lam = (fs'*Lam_j_powered)^(1/(1-thetppsi));
S_j = alphs./(1-(1-alphs)/Pibar).*exp(x(2:end));

y(1) = Lam - (1-ppsi) - ppsi*(fs'*S_j);

Z1     = Lam^(thetppsi)*exp((1-sigm)*x(1))./(1-bet*(1-alphs)*Pibar^(thetppsi-1));
Z2     = exp((1-sigm)*x(1))./(1-bet*(1-alphs)/Pibar);
Z3     = Lam^(2*thetppsi)*exp(2*x(1))./(1-bet*(1-alphs)*Pibar^(2*thetppsi));
Z4     = Lam^(thetppsi)*exp(2*x(1))./(1-bet*(1-alphs)*Pibar^(thetppsi));

y(2:end)  = Z1.*exp(x(2:end)) + ppsi/(thetppsi-1)*Z2.*exp((1+thetppsi)*x(2:end)) - theta*chi/(thetppsi-1)*Z3.*exp((-thetppsi)*x(2:end)) + theta*chi*ppsi/(thetppsi-1)*Z4;
