% A 272-sector model with the CES demand curve
% homogeneous counterfactual
% WYP, December 2020

close all

filenm  = 'nokink_linear_NS_homo_boundary';

%% defining parameters

parameters varphi theta bet rhoi1 rhoi2 phipi phiy phigy chi sigm rhoi;
parameters alph001;
parameters f001;

% calibrated parameters

%Pibar   = 1^(1/4);
varphi  = 1;
bet     = 0.99;
theta   = 10;
chi     = 8;
sigm    = 1;

phipi   = 0;
phiy    = 0;

rhoi    = 0.79; % estimate of CGG(2000)

J = 1;

%% load Nakamura-Setinsson frequencies
% d_regular | d_posted | weight (monthly duration)

NS_duration = load('duration_weight.txt');

d1 = NS_duration(:,1)/3;
d2 = NS_duration(:,2)/3;
weight = NS_duration(:,3);
weight = weight/sum(weight);

alpha1 = 1 - exp(-1./d1);
alpha2 = 1 - exp(-1./d2);

alpha1_mean = sum(weight.*alpha1);
alpha2_mean = sum(weight.*alpha2);

alphj   = alpha1_mean;
fj      = 1;

phipis  = 0:0.002:2.5;
phiyinc = 0.002; phiys  = (0:phiyinc:2);

phipin  = length(phipis);
phiyn   = length(phiys);

detchk  = nan(phipin,phiyn);
bnds    = cell(phipin,1);

% assign parameter values

alph001   = alphj(001);
f001      = fj(001);

%% defining variables

var y i p;
var pR001;
var ps001;

%% defining exogenous variables

varexo er;

%% shocks

shocks;
var er;
stderr 1;
end;

%% model equations in the same order as in our notes

model(linear);

#omg = (sigm+varphi)/(1+theta*varphi);

y = y(+1) - 1/sigm*(i - p(+1));

0 = f001*pR001;

pR001 = (1-alph001)*(pR001(-1) - p) + alph001*ps001;

ps001 = (1-bet*(1-alph001))*omg*y + bet*(1-alph001)*(ps001(+1)+p(+1));

i = rhoi*i(-1) + (1-rhoi)*(phipi*p(+1) + phiy*y) + er;

end;

% steady state

steady_state_model;

y = 0;
p = 0;
pR001 = 0;
ps001 = 0;
i = 0;

end;

%% loop

tic;

for ind6=1:phipin

    phipi = phipis(ind6);

disp('===============================================================')
fprintf('phipi = %8.4f (%i out of %i)\n',phipi,ind6,phipin)
disp('===============================================================')

    detchk0 = [];
    bnd0    = [];

for ind7 = 1:phiyn;

    phiy = phiys(ind7);

    %resid(1);
    check;

    deteig = sum(abs(oo_.dr.eigval)>1);
    detchk(ind6,ind7) = (deteig==M_.nsfwrd);

    if (~isempty(detchk0))
        if (detchk0~=detchk(ind6,ind7))
            bnd0 = [bnd0; phiy-0.5*phiyinc];
            detchk0 = detchk(ind6,ind7);
        end
    else
        detchk0 = detchk(ind6,ind7);
    end
        
end % ind7

    bnds{ind6} = bnd0;

end % ind6

toc;

save([filenm '.mat'],'phipis','phiys','detchk','bnds')
