% make a graph of the boundaries based on Coibion and Gorodnichenko's estimates

filenm = 'graph_boundary_J272_empirical';

%% contemporaneous, pre_Volcker

bnds_all = [];

for indx=1:74

    load(sprintf('J272_empirical/contemporaneous2/pre-Volcker/kink_trend_inflation/regular/kinked_linear_NS_boundary_%02i.mat',indx));
    for indy=1:size(bnds,1)

        bnd = bnds{indy,1};

        for indz = 1:length(bnd)
            bnds_all = [bnds_all; phipis(indy) bnd(indz)];
        end

    end

end

ys1 = bnds_all;

%% contemporaneous, pre_Volcker, homo

bnds_all = [];

load('J272_empirical/contemporaneous2/pre-Volcker/kink_trend_inflation/homogeneous/kinked_linear_NS_homo_boundary.mat');
for indy=1:size(bnds,1)

    bnd = bnds{indy,1};

    for indz = 1:length(bnd)
        bnds_all = [bnds_all; phipis(indy) bnd(indz)];
    end

end

ys1homo = bnds_all;

%% contemporaneous, CES

bnds_all = [];

for indx=1:74

    load(sprintf('J272_empirical/contemporaneous2/pre-Volcker/nokink_zero_trend_inflation/regular/nokink_linear_NS_boundary_%02i.mat',indx));
    for indy=1:size(bnds,1)

        bnd = bnds{indy,1};

        for indz = 1:length(bnd)
            bnds_all = [bnds_all; phipis(indy) bnd(indz)];
        end

    end

end

ys1CES = bnds_all;

%% contemporaneous, CES, pre-Volcker

bnds_all = [];

load('J272_empirical/contemporaneous2/pre-Volcker/nokink_trend_inflation/homogeneous/regular/kinked_linear_NS_homo_boundary.mat');
for indy=1:size(bnds,1)

    bnd = bnds{indy,1};

    for indz = 1:length(bnd)
        bnds_all = [bnds_all; phipis(indy) bnd(indz)];
    end

end

ys1CEShomo = bnds_all;

%% contemporaneous, CES, post-Volcker

bnds_all = [];

load('J272_empirical/contemporaneous2/post-Volcker/nokink_trend_inflation/homogeneous/kinked_linear_NS_homo_boundary.mat');
for indy=1:size(bnds,1)

    bnd = bnds{indy,1};

    for indz = 1:length(bnd)
        bnds_all = [bnds_all; phipis(indy) bnd(indz)];
    end

end

ys2CEShomo = bnds_all;

%% contemporaneous, CES, pre-Volcker, zero trend inflation

bnds_all = [];

load('J272_empirical/contemporaneous2/pre-Volcker/nokink_zero_trend_inflation/homogeneous/nokink_linear_NS_homo_boundary.mat');
for indy=1:size(bnds,1)

    bnd = bnds{indy,1};

    for indz = 1:length(bnd)
        bnds_all = [bnds_all; phipis(indy) bnd(indz)];
    end

end

ys1CEShomozero = bnds_all;

%% contemporaneous, CES, post-Volcker, zero trend inflation

bnds_all = [];

load('J272_empirical/contemporaneous2/post-Volcker/nokink_zero_trend_inflation/homogeneous/nokink_linear_NS_homo_boundary.mat');
for indy=1:size(bnds,1)

    bnd = bnds{indy,1};

    for indz = 1:length(bnd)
        bnds_all = [bnds_all; phipis(indy) bnd(indz)];
    end

end

ys2CEShomozero = bnds_all;

%% contemporaneous, post-Volcker

bnds_all = [];

for indx=1:74

    load(sprintf('J272_empirical/contemporaneous2/post-Volcker/kink_trend_inflation/regular/kinked_linear_NS_boundary_%02i.mat',indx));
    for indy=1:size(bnds,1)

        bnd = bnds{indy,1};

        for indz = 1:length(bnd)
            bnds_all = [bnds_all; phipis(indy) bnd(indz)];
        end

    end

end

ys2 = bnds_all;

%% contemporaneous, post_Volcker, homo

bnds_all = [];

load('J272_empirical/contemporaneous2/post-Volcker/kink_trend_inflation/homogeneous/kinked_linear_NS_homo_boundary.mat');
for indy=1:size(bnds,1)

    bnd = bnds{indy,1};

    for indz = 1:length(bnd)
        bnds_all = [bnds_all; phipis(indy) bnd(indz)];
    end

end

ys2homo = bnds_all;

%% forward, pre-Volcker

bnds_all = [];

for indx=1:74

    load(sprintf('J272_empirical/forward/pre-Volcker/kink_trend_inflation/regular/kinked_linear_NS_boundary_%02i.mat',indx));
    for indy=1:size(bnds,1)

        bnd = bnds{indy,1};

        for indz = 1:length(bnd)
            bnds_all = [bnds_all; phipis(indy) bnd(indz)];
        end

    end

end

ys3 = bnds_all;

%% forward, pre-Volcker, homo

bnds_all = [];

    load('J272_empirical/forward/pre-Volcker/kink_trend_inflation/homogeneous/kinked_linear_NS_homo_boundary.mat');
    for indy=1:size(bnds,1)

        bnd = bnds{indy,1};

        for indz = 1:length(bnd)
            bnds_all = [bnds_all; phipis(indy) bnd(indz)];
        end

    end

ys3homo = bnds_all;

%% forward-looking, CES

bnds_all = [];

for indx=1:59

    load(sprintf('J272_empirical/forward/pre-Volcker/nokink_zero_trend_inflation/regular/nokink_linear_NS_boundary_%02i.mat',indx));
    for indy=1:size(bnds,1)

        bnd = bnds{indy,1};

        for indz = 1:length(bnd)
            bnds_all = [bnds_all; phipis(indy) bnd(indz)];
        end

    end

end

ys3CES = bnds_all;

%% forward-looking, CES, pre-Volcker, homo

bnds_all = [];

load('J272_empirical/forward/pre-Volcker/nokink_trend_inflation/homogeneous/kinked_linear_NS_homo_boundary.mat');
for indy=1:size(bnds,1)

    bnd = bnds{indy,1};

    for indz = 1:length(bnd)
        bnds_all = [bnds_all; phipis(indy) bnd(indz)];
    end

end

ys3CEShomo = bnds_all;

[ys3CEShomo(:,2),iys3CEShomo] = sort(ys3CEShomo(:,2));
ys3CEShomo(:,1) = ys3CEShomo(iys3CEShomo,1);

%% forward-looking, CES, post-Volcker, homo

bnds_all = [];

load('J272_empirical/forward/post-Volcker/nokink_trend_inflation/homogeneous/kinked_linear_NS_homo_boundary.mat');
for indy=1:size(bnds,1)

    bnd = bnds{indy,1};

    for indz = 1:length(bnd)
        bnds_all = [bnds_all; phipis(indy) bnd(indz)];
    end

end

ys4CEShomo = bnds_all;

%% forward-looking, CES, pre-Volcker, homo, zero trend inflation

bnds_all = [];

load('J272_empirical/forward/pre-Volcker/nokink_zero_trend_inflation/homogeneous/nokink_linear_NS_homo_boundary.mat');
for indy=1:size(bnds,1)

    bnd = bnds{indy,1};

    for indz = 1:length(bnd)
        bnds_all = [bnds_all; phipis(indy) bnd(indz)];
    end

end

ys3CEShomozero = bnds_all;

%% forward-looking, CES, post-Volcker, homo, zero trend inflation

bnds_all = [];

load('J272_empirical/forward/post-Volcker/nokink_zero_trend_inflation/homogeneous/nokink_linear_NS_homo_boundary.mat');
for indy=1:size(bnds,1)

    bnd = bnds{indy,1};

    for indz = 1:length(bnd)
        bnds_all = [bnds_all; phipis(indy) bnd(indz)];
    end

end

ys4CEShomozero = bnds_all;

%% forward, post-Volcker

bnds_all = [];

for indx=1:74

    load(sprintf('J272_empirical/forward/post-Volcker/kink_trend_inflation/regular/kinked_linear_NS_boundary_%02i.mat',indx));
    for indy=1:size(bnds,1)

        bnd = bnds{indy,1};

        for indz = 1:length(bnd)
            bnds_all = [bnds_all; phipis(indy) bnd(indz)];
        end

    end

end

ys4 = bnds_all;

%% forward, post-Volcker, homo

bnds_all = [];

    load('J272_empirical/forward/post-Volcker/kink_trend_inflation/homogeneous/kinked_linear_NS_homo_boundary.mat');
    for indy=1:size(bnds,1)

        bnd = bnds{indy,1};

        for indz = 1:length(bnd)
            bnds_all = [bnds_all; phipis(indy) bnd(indz)];
        end

    end

ys4homo = bnds_all;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Coibion and Gorodnichenko

%% no kink: pre-1979

bnds_all = [];

for indx=1:59

    load(sprintf('J272CG/dynare/nokink_zero_trend_inflation/nokink_linear_NS_boundary_%02i.mat',indx));
    for indy=1:size(bnds,1)

        bnd = bnds{indy,1};

        for indz = 1:length(bnd)
            bnds_all = [bnds_all; phipis(indy) bnd(indz)];
        end

    end

end

ys5 = bnds_all;

%% no kink: pre-1979, homo

bnds_all = [];

load('J272CG/dynare/nokink_trend_inflation_homo/regular_pre1979/nokink_linear_NS_homo_boundary.mat');
for indy=1:size(bnds,1)

    bnd = bnds{indy,1};

    for indz = 1:length(bnd)
        bnds_all = [bnds_all; phipis(indy) bnd(indz)];
    end

end

ys6CEShomo = bnds_all;

%% no kink: post-1982, homo

bnds_all = [];

load('J272CG/dynare/nokink_trend_inflation_homo/regular_post1982/kinked_linear_NS_homo_boundary.mat');
for indy=1:size(bnds,1)

    bnd = bnds{indy,1};

    for indz = 1:length(bnd)
        bnds_all = [bnds_all; phipis(indy) bnd(indz)];
    end

end

ys7CEShomo = bnds_all;

%% no kink: pre-1979, homo, zero trend inflation

bnds_all = [];

load('J272CG/dynare/nokink_zero_trend_inflation_homo/regular_pre1979/nokink_linear_NS_homo_boundary.mat');
for indy=1:size(bnds,1)

    bnd = bnds{indy,1};

    for indz = 1:length(bnd)
        bnds_all = [bnds_all; phipis(indy) bnd(indz)];
    end

end

ys6CEShomozero = bnds_all;

%% no kink: post-1982, homo, zero trend inflation

bnds_all = [];

load('J272CG/dynare/nokink_zero_trend_inflation_homo/regular_post1982/nokink_linear_NS_homo_boundary.mat');
for indy=1:size(bnds,1)

    bnd = bnds{indy,1};

    for indz = 1:length(bnd)
        bnds_all = [bnds_all; phipis(indy) bnd(indz)];
    end

end

ys7CEShomozero = bnds_all;

%% kink: pre-1979

bnds_all = [];

for indx=1:63

    if (indx==12)

        for indz=1:5
        
            load(sprintf('J272CG/dynare/kink_trend_inflation/regular_pre1979/kinked_linear_NS_boundary_%02i_%i.mat',indx,indz));
            for indy=1:size(bnds,1)

                bnd = bnds{indy,1};

                for indz = 1:length(bnd)
                    bnds_all = [bnds_all; phipis(indy) bnd(indz)];
                end

            end
            
        end
        
    else
        
        load(sprintf('J272CG/dynare/kink_trend_inflation/regular_pre1979/kinked_linear_NS_boundary_%02i.mat',indx));
        for indy=1:size(bnds,1)

            bnd = bnds{indy,1};

            for indz = 1:length(bnd)
                bnds_all = [bnds_all; phipis(indy) bnd(indz)];
            end

        end
        
    end

end

ys6 = bnds_all;

%% kink: pre-1979, homo

bnds_all = [];

load('J272CG/dynare/kink_trend_inflation/homogeneous/regular_pre1979/kinked_linear_NS_homo_boundary.mat');
for indy=1:size(bnds,1)

    bnd = bnds{indy,1};

    for indz = 1:length(bnd)
        bnds_all = [bnds_all; phipis(indy) bnd(indz)];
    end

end

ys6homo = bnds_all;

%% kink: post-1982

bnds_all = [];

for indx=1:63

    load(sprintf('J272CG/dynare/kink_trend_inflation/regular_post1982/kinked_linear_NS_boundary_%02i.mat',indx));
    for indy=1:size(bnds,1)

        bnd = bnds{indy,1};

        for indz = 1:length(bnd)
            bnds_all = [bnds_all; phipis(indy) bnd(indz)];
        end

    end

end

ys7 = bnds_all;

%% kink: post-1982, homo

bnds_all = [];

load('J272CG/dynare/kink_trend_inflation/homogeneous/regular_post1982/kinked_linear_NS_homo_boundary.mat');
for indy=1:size(bnds,1)

    bnd = bnds{indy,1};

    for indz = 1:length(bnd)
        bnds_all = [bnds_all; phipis(indy) bnd(indz)];
    end

end

ys7homo = bnds_all;

%% graphs

h1=figure;

subplot(1,3,1)
hold on
plot(ys3(:,1),ys3(:,2),'LineWidth',3,'Color',[0 0.4470 0.7410])
line(ys3homo(:,1),ys3homo(:,2),'LineWidth',1,'LineStyle','-','Color',[0 0.4470 0.7410])
line(ys4(:,1),ys4(:,2),'LineWidth',3,'LineStyle','--','Color',[0.8500 0.3250 0.0980])
line(ys4homo(:,1),ys4homo(:,2),'LineWidth',1,'LineStyle','--','Color',[0.8500 0.3250 0.0980])
scatter(0.83,0.27/4,25,'red','filled'); 
scatter(2.15,0.93/4,25,'red'); 
errorbar(0.83,0.27/4,2*0.07,'horizontal','Color','red');
errorbar(0.83,0.27/4,2*0.08/4,'Color','red');
errorbar(2.15,0.93/4,2*0.4,'horizontal','Color','red');
errorbar(2.15,0.93/4,2*0.42/4,'Color','red');
hold off
box on
xlim([0 2.5])
ylim([0 2])
%text(0.7,0.15,'Pre-Volcker estimate by CGG (2000)','FontName','Times New Roman','FontSize',10)
%text(1.3,0.32,'Post-Volcker estimate by CGG(2000)','FontName','Times New Roman','FontSize',10)
title({'(b-1) ﻿Clarida, Galí, and Gertler (2000)','Forward-looking rule'},'FontName','Times New Roman','FontSize',11)
xlabel('\phi_{\pi}')
ylabel('\phi_{y}')

%legend({'','','','','Pre-Volcker estimate','Post-Volcker estimate'},'FontName','Times New Roman','FontSize',8)
%legend('boxoff')

subplot(1,3,2)
hold on
plot(ys6(:,1),ys6(:,2),'LineWidth',3,'Color',[0 0.4470 0.7410])
line(ys6homo(:,1),ys6homo(:,2),'LineWidth',1,'LineStyle','-','Color',[0 0.4470 0.7410])
line(ys7(:,1),ys7(:,2),'LineWidth',3,'LineStyle','--','Color',[0.8500 0.3250 0.0980])
line(ys7homo(:,1),ys7homo(:,2),'LineWidth',1,'LineStyle','--','Color',[0.8500 0.3250 0.0980])
scatter(1.04,0.52/4,25,'red','filled'); 
scatter(2.20,0.43/4,25,'red'); 
errorbar(1.04,0.52/4,2*0.31,'horizontal','Color','red');
errorbar(1.04,0.52/4,2*0.13/4,'Color','red');
errorbar(2.20,0.43/4,2*0.4,'horizontal','Color','red');
errorbar(2.20,0.43/4,2*0.12/4,'Color','red');
hold off
box on
xlim([0 2.5])
ylim([0 2])
%text(0.7,0.27,'Pre-Volcker by CG(2010)','FontName','Times New Roman','FontSize',10)
%text(1.5,0.18,'Post-Volcker by CG(2010)','FontName','Times New Roman','FontSize',10)
title({'(b-2) ﻿Coibion and Gorodnichenko (2011)','Forward-looking rule'},'FontName','Times New Roman','FontSize',11)
xlabel('\phi_{\pi}')
ylabel('\phi_{y}')

legend({'Pre-Volcker: Heterogeneous','Homogeneous counterfactual','','','',''},'FontName','Times New Roman','FontSize',8)
legend('boxoff')

subplot(1,3,3)
hold on
plot(ys1(:,1),ys1(:,2),'LineWidth',3,'Color',[0 0.4470 0.7410])
line(ys1homo(:,1),ys1homo(:,2),'LineWidth',1,'LineStyle','-','Color',[0 0.4470 0.7410])
line(ys2(:,1),ys2(:,2),'LineWidth',3,'LineStyle','--','Color',[0.8500 0.3250 0.0980])
line(ys2homo(:,1),ys2homo(:,2),'LineWidth',1,'LineStyle','--','Color',[0.8500 0.3250 0.0980])
scatter(0.90,0.79/4,25,'red','filled'); 
scatter(1.99,0.75/4,25,'red'); 
errorbar(0.90,0.79/4,2*0.22,'horizontal','Color','red');
errorbar(0.90,0.79/4,2*0.29/4,'Color','red');
errorbar(1.99,0.75/4,2*0.3,'horizontal','Color','red');
errorbar(1.99,0.75/4,2*0.15/4,'Color','red');
hold off
box on
xlim([0 2.5])
ylim([0 2])
title({'(b-3) ﻿Carvalho, Nechio and Tristao (2019)','Contemporaneous rule'},'FontName','Times New Roman','FontSize',11)
xlabel('\phi_{\pi}')
ylabel('\phi_{y}')

legend({'','','Post-Volcker: Heterogeneous','Homogeneous counterfactual','Pre-Volcker estimate','Post-Volcker estimate'},'FontName','Times New Roman','FontSize',8)
legend('boxoff')

h1.PaperSize = [21/1.1 29.7/4/1.1];
h1.PaperUnits = 'centimeters';
h1.PaperPosition = [0 0 1.5*21/1.1 1.5*29.7/4/1.1];

print(['graph_' filenm '_Kimball.eps'],'-depsc2')

%%%%%%%%%%%%%%%%%


h1=figure;

subplot(1,3,1)
hold on
line(ys3CES(:,1),ys3CES(:,2),'LineWidth',3,'LineStyle','-','Color',[0 0.4470 0.7410])
line(ys3CEShomozero(:,1),ys3CEShomozero(:,2),'LineWidth',1,'LineStyle','-','Color',[0 0.4470 0.7410])
%line(ys3CEShomo(:,1),ys3CEShomo(:,2),'LineWidth',1,'LineStyle','--','Color',[0 0.4470 0.7410])
%line(ys4CEShomo(:,1),ys4CEShomo(:,2),'LineWidth',1,'LineStyle','-.','Color',[0 0.4470 0.7410])
scatter(0.83,0.27/4,25,'red','filled');
scatter(2.15,0.93/4,25,'red'); 
errorbar(0.83,0.27/4,2*0.07,'horizontal','Color','red');
errorbar(0.83,0.27/4,2*0.08/4,'Color','red');
errorbar(2.15,0.93/4,2*0.4,'horizontal','Color','red');
errorbar(2.15,0.93/4,2*0.42/4,'Color','red');
hold off
box on
xlim([0 2.5])
ylim([0 2])
%text(0.7,0.15,'Pre-Volcker estimate by CGG (2000)','FontName','Times New Roman','FontSize',10)
%text(1.3,0.32,'Post-Volcker estimate by CGG(2000)','FontName','Times New Roman','FontSize',10)
title({'(a-1) ﻿Clarida, Galí, and Gertler (2000)','Forward-looking rule'},'FontName','Times New Roman','FontSize',11)
xlabel('\phi_{\pi}')
ylabel('\phi_{y}')

%legend({'','','Pre-Volcker estimate','Post-Volcker estimate'},'FontName','Times New Roman','FontSize',8)
%legend('boxoff')

subplot(1,3,2)
hold on
line(ys5(:,1),ys5(:,2),'LineWidth',3,'LineStyle','-','Color',[0 0.4470 0.7410])
line(ys6CEShomozero(:,1),ys6CEShomozero(:,2),'LineWidth',1,'LineStyle','-','Color',[0 0.4470 0.7410])
%line(ys7CEShomo(:,1),ys7CEShomo(:,2),'LineWidth',1,'LineStyle','--','Color',[0 0.4470 0.7410])
%line(ys7CEShomo(:,1),ys7CEShomo(:,2),'LineWidth',1,'LineStyle','-.','Color',[0 0.4470 0.7410])
scatter(1.04,0.52/4,25,'red','filled');
scatter(2.20,0.43/4,25,'red'); 
errorbar(1.04,0.52/4,2*0.31,'horizontal','Color','red');
errorbar(1.04,0.52/4,2*0.13/4,'Color','red');
errorbar(2.20,0.43/4,2*0.4,'horizontal','Color','red');
errorbar(2.20,0.43/4,2*0.12/4,'Color','red');
hold off
box on
xlim([0 2.5])
ylim([0 2])
%text(0.7,0.27,'Pre-Volcker by CG(2010)','FontName','Times New Roman','FontSize',10)
%text(1.5,0.18,'Post-Volcker by CG(2010)','FontName','Times New Roman','FontSize',10)
title({'(a-2) ﻿Coibion and Gorodnichenko (2011)','Forward-looking rule'},'FontName','Times New Roman','FontSize',11)
xlabel('\phi_{\pi}')
ylabel('\phi_{y}')

%legend({'','','Pre-Volcker estimate','Post-Volcker estimate'},'FontName','Times New Roman','FontSize',8)
%legend('boxoff')

subplot(1,3,3)
hold on
line(ys1CES(:,1),ys1CES(:,2),'LineWidth',3,'LineStyle','-','Color',[0 0.4470 0.7410])
line(ys1CEShomozero(:,1),ys1CEShomozero(:,2),'LineWidth',1,'LineStyle','-','Color',[0 0.4470 0.7410])
%line(ys1CEShomo(:,1),ys1CEShomo(:,2),'LineWidth',1,'LineStyle','--','Color',[0 0.4470 0.7410])
%line(ys2CEShomo(:,1),ys2CEShomo(:,2),'LineWidth',1,'LineStyle','-.','Color',[0 0.4470 0.7410])
scatter(0.90,0.79/4,25,'red','filled'); 
scatter(1.99,0.75/4,25,'red');
errorbar(0.90,0.79/4,2*0.22,'horizontal','Color','red');
errorbar(0.90,0.79/4,2*0.29/4,'Color','red');
errorbar(1.99,0.75/4,2*0.3,'horizontal','Color','red');
errorbar(1.99,0.75/4,2*0.15/4,'Color','red');
hold off
box on
xlim([0 2.5])
ylim([0 2])
title({'(a-3) ﻿Carvalho, Nechio and Tristao (2019)','Contemporaneous rule'},'FontName','Times New Roman','FontSize',11)
xlabel('\phi_{\pi}')
ylabel('\phi_{y}')

legend({'Heterogeneous','Homogeneous counterfactual','Pre-Volcker estimate','Post-Volcker estimate'},'FontName','Times New Roman','FontSize',8)
%legend({'Heterogeneous',['homogeneous counterfactual 1' newline '(zero trend inflation)'],['homogeneous counterfactual 2' newline '(pre-Volcker with trend inflation)'],['homogeneous counterfactual 3' newline '(post-Volcker with trend inflation)'],'Pre-Volcker estimate by CNT (2019)','Post-Volcker estimate by CNT (2019)'},'FontName','Times New Roman','FontSize',8)
legend('boxoff')

h1.PaperSize = [21/1.1 29.7/4/1.1];
h1.PaperUnits = 'centimeters';
h1.PaperPosition = [0 0 1.5*21/1.1 1.5*29.7/4/1.1];

print(['graph_' filenm '_CES.eps'],'-depsc2')


%%%%%%%%%%%%%%%%%

h3=figure;

subplot(1,3,1)
hold on
line(ys3CES(:,1),ys3CES(:,2),'LineWidth',3,'LineStyle','-','Color',[0 0.4470 0.7410])
line(ys3CEShomozero(:,1),ys3CEShomozero(:,2),'LineWidth',1,'LineStyle','-','Color',[0 0.4470 0.7410])
line(ys3CEShomo(:,1),ys3CEShomo(:,2),'LineWidth',1,'LineStyle','--','Color',[0 0.4470 0.7410])
line(ys4CEShomo(:,1),ys4CEShomo(:,2),'LineWidth',1,'LineStyle','-.','Color',[0 0.4470 0.7410])
scatter(0.83,0.27/4,25,'red','filled');
scatter(2.15,0.93/4,25,'red'); 
errorbar(0.83,0.27/4,2*0.07,'horizontal','Color','red');
errorbar(0.83,0.27/4,2*0.08/4,'Color','red');
errorbar(2.15,0.93/4,2*0.4,'horizontal','Color','red');
errorbar(2.15,0.93/4,2*0.42/4,'Color','red');
hold off
box on
xlim([0 2.5])
ylim([0 2])
%text(0.7,0.15,'Pre-Volcker estimate by CGG (2000)','FontName','Times New Roman','FontSize',10)
%text(1.3,0.32,'Post-Volcker estimate by CGG(2000)','FontName','Times New Roman','FontSize',10)
title({'(a-1) ﻿Clarida, Galí, and Gertler (2000)','Forward-looking rule'},'FontName','Times New Roman','FontSize',11)
xlabel('\phi_{\pi}')
ylabel('\phi_{y}')

%legend({'','','','','Pre-Volcker estimate','Post-Volcker estimate'},'FontName','Times New Roman','FontSize',8)
%legend('boxoff')

subplot(1,3,2)
hold on
line(ys5(:,1),ys5(:,2),'LineWidth',3,'LineStyle','-','Color',[0 0.4470 0.7410])
line(ys6CEShomozero(:,1),ys6CEShomozero(:,2),'LineWidth',1,'LineStyle','-','Color',[0 0.4470 0.7410])
line(ys6CEShomo(:,1),ys6CEShomo(:,2),'LineWidth',1,'LineStyle','--','Color',[0 0.4470 0.7410])
line(ys7CEShomo(:,1),ys7CEShomo(:,2),'LineWidth',1,'LineStyle','-.','Color',[0 0.4470 0.7410])
scatter(1.04,0.52/4,25,'red','filled');
scatter(2.20,0.43/4,25,'red'); 
errorbar(1.04,0.52/4,2*0.31,'horizontal','Color','red');
errorbar(1.04,0.52/4,2*0.13/4,'Color','red');
errorbar(2.20,0.43/4,2*0.4,'horizontal','Color','red');
errorbar(2.20,0.43/4,2*0.12/4,'Color','red');
hold off
box on
xlim([0 2.5])
ylim([0 2])
%text(0.7,0.27,'Pre-Volcker by CG(2010)','FontName','Times New Roman','FontSize',10)
%text(1.5,0.18,'Post-Volcker by CG(2010)','FontName','Times New Roman','FontSize',10)
title({'(a-2) ﻿Coibion and Gorodnichenko (2011)','Forward-looking rule'},'FontName','Times New Roman','FontSize',11)
xlabel('\phi_{\pi}')
ylabel('\phi_{y}')

%legend({'','','','','Pre-Volcker estimate','Post-Volcker estimate'},'FontName','Times New Roman','FontSize',8)
%legend('boxoff')

subplot(1,3,3)
hold on
line(ys1CES(:,1),ys1CES(:,2),'LineWidth',3,'LineStyle','-','Color',[0 0.4470 0.7410])
line(ys1CEShomozero(:,1),ys1CEShomozero(:,2),'LineWidth',1,'LineStyle','-','Color',[0 0.4470 0.7410])
line(ys1CEShomo(:,1),ys1CEShomo(:,2),'LineWidth',1,'LineStyle','--','Color',[0 0.4470 0.7410])
line(ys2CEShomo(:,1),ys2CEShomo(:,2),'LineWidth',1,'LineStyle','-.','Color',[0 0.4470 0.7410])
scatter(0.90,0.79/4,25,'red','filled'); 
scatter(1.99,0.75/4,25,'red');
errorbar(0.90,0.79/4,2*0.22,'horizontal','Color','red');
errorbar(0.90,0.79/4,2*0.29/4,'Color','red');
errorbar(1.99,0.75/4,2*0.3,'horizontal','Color','red');
errorbar(1.99,0.75/4,2*0.15/4,'Color','red');
hold off
box on
xlim([0 2.5])
ylim([0 2])
title({'(a-3) ﻿Carvalho, Nechio and Tristao (2019)','Contemporaneous rule'},'FontName','Times New Roman','FontSize',11)
xlabel('\phi_{\pi}')
ylabel('\phi_{y}')

legend({'Heterogeneous','Homogeneous counterfactual 1','Homogeneous counterfactual 2','Homogeneous counterfactual 3','Pre-Volcker estimate','Post-Volcker estimate'},'FontName','Times New Roman','FontSize',8)
%legend({'Heterogeneous',['homogeneous counterfactual 1' newline '(zero trend inflation)'],['homogeneous counterfactual 2' newline '(pre-Volcker with trend inflation)'],['homogeneous counterfactual 3' newline '(post-Volcker with trend inflation)'],'Pre-Volcker estimate by CNT (2019)','Post-Volcker estimate by CNT (2019)'},'FontName','Times New Roman','FontSize',8)
legend('boxoff')

h3.PaperSize = [21/1.1 29.7/4/1.1];
h3.PaperUnits = 'centimeters';
h3.PaperPosition = [0 0 1.5*21/1.1 1.5*29.7/4/1.1];

print(['graph_' filenm '_CES_extra.eps'],'-depsc2')
