function out=monthlyvar(x)
% based on data at a higher-than-one-monht- frequency, 
% the programs gives the end of the month_date


x=x(all(~isnan(x),2),:); % for nan - rows
date=x(:,1);
yearnum=year(date);
monthnum=month(date);
daynum=day(date);
var=x(:,2:end);

% Giving a unique number to each month

firstmonth=yearnum(1)*12+monthnum(1)-1;
mn=(12*yearnum+monthnum)-firstmonth;

mend=max(mn(:,1));

i=1;
vix=[];
while i<=mend   
    mobs=var(mn==i,:);
    if isempty(mobs)==1
        display('THERE IS NO END OF THE MONTH DATA FOR ONE OF THE SERIES');
        vix(:,1);
    else
    newdate=date(mn==i);
    newdate=newdate(end);
    vix=[vix;[newdate mobs(end,:)]];
    %vix=[vix;[newdate mean(mobs(:,:))]];
    end
    i=i+1;
    
end

out=vix;
end

    
