%% 1. PRELIMINARIES
% =======================================================================
clear all; clear session; close all; clc
warning off

addpath './VAR_Toolbox/VAR'
addpath './VAR_Toolbox/Utils'
addpath './VAR_Toolbox/Auxiliary'
addpath './VAR_Toolbox/ExportFig'
addpath './VAR_Toolbox/Figure'
addpath './VAR_Toolbox/Stats'

country_list =["Australia", "Austria", "Belgium", "Brazil", "Canada", "Chile", "China", ...
    "Colombia", "Czech", "Denmark", "Estonia", "Finland", ...
    "France", "Germany", "Greece", "Hungary", "Iceland", ...
    "Ireland", "Israel", "Italy", "Japan", "Korea", ...
    "Latvia", "Lithuania", "Luxembourg", "Mexico", "Netherlands", ...
    "New Zealand", "Norway", "Poland", "Portugal", "Slovak Republic", ...
    "Slovenia", "Spain", "Sweden", "Switzerland", "Turkey", ...
    "UK","US" ];



for jj = 1:size(country_list,2)
    
    disp(jj);

    [xlsdata,text] = xlsread('./Data/uncertainty_index_wps.xlsx',country_list{jj});
    
    dates = 1960+7/12 : 1/12 : 2021+5/12;
    
    dates_1 = text(2,1);
    temp = char(dates_1(1));
    year = str2double(temp(1:4));
    month = str2double(temp(6:end));
    
    
    dates_first = year + month/12;
    dates_first_store(jj) =  year + month/12;
    
    dates_f = 1960+7/12;
    
    index = floor((dates_first - dates_f)*12);
    
    
    
    REU = xlsdata(1:end,1);
    ip = (xlsdata(:,2));
    
    if jj == 30
        ip_us = (xlsdata(:,2));
        reu_us = (xlsdata(:,1));
        ff  = (xlsdata(:,3));
        emp  = (xlsdata(:,4));
        sp500  = (xlsdata(:,5));
        cpi  = (xlsdata(:,6));
    end
    
    try
        REU_index(:,jj) = [NaN(index,1);REU];
        
    catch
        size_T = length([NaN(index,1);REU]);
        correct_T = length(REU_index(:,1));
        REU_index(:,jj) = [NaN(index,1);REU;NaN(correct_T-size_T,1)];
        
    end
    %ip_index(:,jj) = [NaN(index,1);ip];
    
    sum_stats(jj,1) = nanmean(REU_index(:,jj));
    sum_stats(jj,2) = nanstd(REU_index(:,jj));
    
    [sum_stats(jj,3),sum_stats(jj,4)]  = min(REU_index(:,jj));
    [sum_stats(jj,6),sum_stats(jj,7)] = max(REU_index(:,jj));
    
    year_min = floor(dates(sum_stats(jj,4)));
    month_min = (dates(sum_stats(jj,4)) - floor(dates(sum_stats(jj,4))))*12;
    
    year_max = floor(dates(sum_stats(jj,7)));
    month_max  = (dates(sum_stats(jj,7)) - floor(dates(sum_stats(jj,7))))*12;
    
    sum_stats(jj,4:5) = [year_min,month_min];
    sum_stats(jj,7:8) = [year_max,month_max];
    
end

%%% Table 2, Mean, SD, Min, Min Year, Min Month, Max, Max Year, Max Month. 
disp(sum_stats)


%% Plot
cjln_names = country_list;

figure
for jj = 1:20
    
    subplot(4,5,jj)
    plot(dates, REU_index(:,jj),'linewidth',2);
    title(cjln_names{jj}, 'fontsize',12)
    xlim([dates_first_store(jj)-7/12,2022])
    grid on
end
dim = [8,6];
set(gcf,'papersize',dim,'paperposition',[0,0,dim]);
figure(gcf)
print(gcf,'-dpdf','./figure/REU_first20') %Change Figure Name Here

figure
for jj = 21:39
    
    subplot(4,5,jj-20)
    plot(dates, REU_index(:,jj),'linewidth',2);
    title(cjln_names{jj}, 'fontsize',12)
     xlim([dates_first_store(jj)-7/12,2022])
    grid on
end
dim = [8,6];
set(gcf,'papersize',dim,'paperposition',[0,0,dim]);
figure(gcf)
print(gcf,'-dpdf','./figure/REU_next19') %Change Figure Name Here
