%% 1. PRELIMINARIES
% Written by Sai Ma
% =======================================================================
clear all; clear session; close all; clc
warning off

addpath './VAR_Toolbox/VAR'
addpath './VAR_Toolbox/Utils'
addpath './VAR_Toolbox/Auxiliary'
addpath './VAR_Toolbox/ExportFig'
addpath './VAR_Toolbox/Figure'
addpath './VAR_Toolbox/Stats'

country_list =["Australia", "Austria", "Belgium", "Brazil", "Canada", "Chile", "China", ...
    "Colombia", "Czech", "Denmark", "Estonia", "Finland", ...
    "France", "Germany", "Greece", "Hungary", "Iceland", ...
    "Ireland", "Israel", "Italy", "Japan", "Korea", ...
    "Latvia", "Lithuania", "Luxembourg", "Mexico", "Netherlands", ...
    "New Zealand", "Norway", "Poland", "Portugal", "Slovak Republic", ...
    "Slovenia", "Spain", "Sweden", "Switzerland", "Turkey", ...
    "UK","US" ];


for jj = 1:size(country_list,2)
    
       disp(jj);
    % Load
    [xlsdata,text] = xlsread('./Data/main_data_2020.xlsx',country_list{jj});
    
    dates = 1960+7/12 : 1/12 : 2020+4/12;
    
    dates_1 = text(2,1);
    temp = char(dates_1(1));
    year = str2double(temp(1:4));
    month = str2double(temp(6:end));
    
    dates_first = year + month/12;
    
    dates_f = 1960+7/12;
    
    index = floor((dates_first - dates_f)*12);
    
    
    REU = xlsdata(1:end,1);
    ip = (xlsdata(:,2));
    
    REU_index(:,jj) = [NaN(index,1);REU];

end
%% Gen correlation stats
for jj = 1:39
    
    dREU = REU_index(:,jj);
   % index_c = 1:39 == j;
   
   if jj >1 & jj < 39
    oREU = REU_index(:,[1:jj-1, jj+1:39]);
   elseif jj == 1
      oREU = REU_index(:,2:39);  
   elseif jj == 39
      oREU = REU_index(:,1:38);  
       
   end
   for ii = 1:38
   corr_out(ii) =  abs(nancorr(dREU, oREU(:,ii)));
   end
   
   corr_sum(jj,:) = round([mean(corr_out) min(corr_out), max(corr_out)],2);
   
end

disp(corr_sum)