function g1 = dynamic_g1(T, y, x, params, steady_state, it_, T_flag)
% function g1 = dynamic_g1(T, y, x, params, steady_state, it_, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double   vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double   vector of endogenous variables in the order stored
%                                                     in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double   matrix of exogenous variables (in declaration order)
%                                                     for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double   vector of steady state values
%   params        [M_.param_nbr by 1]        double   vector of parameter values in declaration order
%   it_           scalar                     double   time period for exogenous variables for which
%                                                     to evaluate the model
%   T_flag        boolean                    boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   g1
%

if T_flag
    T = bondpurchases6.dynamic_g1_tt(T, y, x, params, steady_state, it_);
end
g1 = zeros(63, 112);
g1(1,29)=(-((-((1-params(1))*y(30)))/(y(29)*y(29))));
g1(1,30)=(-((1-params(1))/y(29)));
g1(1,68)=1;
g1(2,29)=(-(params(7)*(1+1/params(5))*getPowerDeriv(y(29),1/params(5),1)/y(86)));
g1(2,68)=1;
g1(2,86)=(-((-T(1))/(y(86)*y(86))));
g1(3,29)=(-(T(3)*getPowerDeriv(y(29),1-params(1),1)));
g1(3,30)=1;
g1(3,1)=(-(T(4)*y(83)*params(6)*getPowerDeriv(y(1),params(1),1)));
g1(3,83)=(-(T(4)*params(6)*T(2)));
g1(4,30)=(-(1-params(1)));
g1(4,33)=1;
g1(4,2)=(-(1+y(21)));
g1(4,37)=1;
g1(4,52)=(-1);
g1(4,63)=(-1);
g1(4,21)=(-y(2));
g1(5,33)=(-(getPowerDeriv(y(33),(-params(38)),1)));
g1(5,86)=1;
g1(6,69)=(-(params(8)/y(81)*y(98)));
g1(6,81)=(-(y(98)*(1+y(69))*(-params(8))/(y(81)*y(81))));
g1(6,86)=1;
g1(6,98)=(-(params(8)/y(81)*(1+y(69))));
g1(7,40)=(-1);
g1(7,44)=1;
g1(7,48)=1;
g1(8,41)=(-1);
g1(8,45)=1;
g1(8,49)=1;
g1(9,49)=(-y(72));
g1(9,50)=1;
g1(9,72)=(-y(49));
g1(10,47)=1;
g1(10,48)=(-1);
g1(10,49)=(-y(72));
g1(10,72)=(-y(49));
g1(11,37)=1;
g1(11,38)=(-1);
g1(11,48)=(-1);
g1(11,49)=(-y(72));
g1(11,51)=(-1);
g1(11,54)=1;
g1(11,72)=(-y(49));
g1(11,87)=1;
g1(12,38)=(-params(16));
g1(12,50)=(-params(15));
g1(12,88)=1;
g1(13,31)=1;
g1(13,2)=1+y(21);
g1(13,37)=(-1);
g1(13,3)=(-(1+y(23)));
g1(13,38)=1;
g1(13,8)=(-(1+y(22)));
g1(13,48)=1;
g1(13,9)=(-(1+y(72)*params(20)));
g1(13,49)=y(72);
g1(13,10)=(-(1+y(79)));
g1(13,51)=1;
g1(13,11)=1+y(24);
g1(13,54)=(-1);
g1(13,21)=y(2);
g1(13,22)=(-y(8));
g1(13,72)=y(49)-params(20)*y(9);
g1(13,23)=(-y(3));
g1(13,79)=(-y(10));
g1(13,24)=y(11);
g1(14,31)=(-(getPowerDeriv(y(31),(-params(4)),1)));
g1(14,84)=1;
g1(15,76)=(-(params(9)/y(82)*y(96)));
g1(15,82)=(-(y(96)*(1+y(76))*(-params(9))/(y(82)*y(82))));
g1(15,84)=1;
g1(15,96)=(-(params(9)/y(82)*(1+y(76))));
g1(16,70)=1;
g1(16,76)=(-1);
g1(16,87)=T(10);
g1(16,90)=T(12);
g1(17,71)=1;
g1(17,76)=(-1);
g1(17,87)=T(10);
g1(17,88)=(-((-(y(90)*params(15)*params(14)))/(y(88)*y(88))));
g1(17,90)=T(12)-params(15)*params(14)/y(88);
g1(18,76)=(-1);
g1(18,77)=1;
g1(18,87)=T(10);
g1(18,88)=(-((-(y(90)*params(16)*params(14)))/(y(88)*y(88))));
g1(18,90)=T(12)-params(16)*params(14)/y(88);
g1(19,51)=(-(params(12)*y(89)))/(y(51)*y(51));
g1(19,76)=(-1);
g1(19,79)=1;
g1(19,87)=T(10);
g1(19,89)=params(12)/y(51);
g1(19,90)=T(12);
g1(20,37)=(-(params(12)*y(89)))/(y(37)*y(37));
g1(20,69)=1;
g1(20,76)=(-1);
g1(20,87)=T(10);
g1(20,89)=params(12)/y(37);
g1(20,90)=T(12);
g1(21,76)=(-1);
g1(21,80)=1;
g1(21,87)=T(10);
g1(21,90)=T(12);
g1(22,71)=(-((-(1+params(20)*y(94)))/((1+y(71))*(1+y(71)))));
g1(22,72)=1;
g1(22,94)=(-(params(20)/(1+y(71))));
g1(23,72)=(-((-1)/(y(72)*y(72))));
g1(23,73)=1;
g1(24,70)=(-((-(1+params(20)*y(95)))/((1+y(70))*(1+y(70)))));
g1(24,74)=1;
g1(24,95)=(-(params(20)/(1+y(70))));
g1(25,74)=(-((-1)/(y(74)*y(74))));
g1(25,75)=1;
g1(26,37)=(-(params(77)*1/y(51)*T(9)/T(6)));
g1(26,51)=(-(params(77)*T(9)*(-y(37))/(y(51)*y(51))/T(6)));
g1(26,89)=1;
g1(27,87)=(-(params(78)*(-y(88))/(y(87)*y(87))*T(11)/T(7)));
g1(27,88)=(-(params(78)*T(11)*1/y(87)/T(7)));
g1(27,90)=1;
g1(28,38)=(-1);
g1(28,55)=(-1);
g1(28,56)=(-1);
g1(28,57)=(-1);
g1(28,58)=(-1);
g1(28,60)=1;
g1(29,3)=1+y(23);
g1(29,12)=1+y(23);
g1(29,13)=1+y(23)-0.0025;
g1(29,14)=1+y(23)-0.0025;
g1(29,15)=1+y(23);
g1(29,59)=1;
g1(29,60)=(-1);
g1(29,17)=(-1);
g1(29,23)=(-((-(y(3)+y(12)+y(15)))-(y(13)+y(14))));
g1(30,30)=(-params(1));
g1(30,59)=(-1);
g1(30,61)=1;
g1(31,32)=1;
g1(31,35)=1;
g1(31,61)=(-1);
g1(32,35)=(-1);
g1(32,1)=(-(1-params(2)-params(3)/2*(-(2*(y(36)-y(1))))/params(57)));
g1(32,36)=1+params(3)/2*2*(y(36)-y(1))/params(57);
g1(33,32)=(-(getPowerDeriv(y(32),(-params(37)),1)));
g1(33,85)=1;
g1(34,78)=(-(params(10)*y(97)));
g1(34,85)=1;
g1(34,97)=(-(params(10)*(1+y(78))));
g1(35,92)=(-(params(1)*params(10)*y(97)/y(36)));
g1(35,1)=y(85)*(-params(3))/params(57);
g1(35,36)=y(85)*params(3)/params(57)-((-(params(1)*params(10)*y(97)*y(92)))/(y(36)*y(36))+params(10)*y(97)*(-params(3))/params(57));
g1(35,93)=(-(params(10)*y(97)*params(3)/params(57)));
g1(35,85)=1+params(3)*(y(36)-y(1))/params(57);
g1(35,97)=(-(y(92)*params(1)*params(10)/y(36)+params(10)*(1-params(2)+params(3)*(y(93)-y(36))/params(57))));
g1(36,30)=(-((-(params(18)*T(8)))-params(19)*T(8)));
g1(36,38)=(-(params(19)*1/params(33)/(y(38)/params(33))));
g1(36,62)=1;
g1(37,57)=0.25*1/(params(56)*params(44)*4);
g1(37,62)=(-1);
g1(37,77)=(-1);
g1(37,78)=1;
g1(37,91)=1;
g1(38,31)=(-1);
g1(38,32)=(-1);
g1(38,33)=(-1);
g1(38,34)=1;
g1(39,44)=1;
g1(39,65)=(-1);
g1(39,67)=1;
g1(40,45)=1;
g1(40,66)=(-1);
g1(40,67)=(-(1/y(72)));
g1(40,72)=(-((-y(67))/(y(72)*y(72))));
g1(41,45)=(-y(72));
g1(41,46)=1;
g1(41,72)=(-y(45));
g1(42,43)=1;
g1(42,44)=(-1);
g1(42,45)=(-y(72));
g1(42,72)=(-y(45));
g1(43,44)=(-1);
g1(43,45)=(-y(72));
g1(43,51)=1;
g1(43,54)=(-1);
g1(43,55)=(-1);
g1(43,56)=(-1);
g1(43,57)=(-1);
g1(43,72)=(-y(45));
g1(44,6)=(-(1+y(22)));
g1(44,7)=(-(1+y(72)*params(20)));
g1(44,10)=1+y(79);
g1(44,53)=1;
g1(44,11)=(-(1+y(24)));
g1(44,12)=(-(1+y(23)));
g1(44,13)=(-(1+y(23)-0.0025));
g1(44,14)=(-(1+y(23)-0.0025));
g1(44,17)=1+y(23)-0.0025;
g1(44,22)=(-y(6));
g1(44,72)=(-(params(20)*y(7)));
g1(44,23)=(-(y(12)+y(14)+y(13)-y(17)));
g1(44,79)=y(10);
g1(44,24)=(-y(11));
g1(45,39)=params(25)*params(28);
g1(45,52)=1;
g1(46,40)=1;
g1(46,41)=(-(y(72)*(1-params(21))/params(21)));
g1(46,72)=(-(y(41)*(1-params(21))/params(21)));
g1(47,41)=(-y(72));
g1(47,42)=1;
g1(47,72)=(-y(41));
g1(48,39)=1;
g1(48,40)=(-1);
g1(48,42)=(-1);
g1(49,4)=(-(1+y(22)));
g1(49,40)=1;
g1(49,5)=(-(1+y(72)*params(20)));
g1(49,41)=y(72);
g1(49,52)=(-1);
g1(49,53)=1;
g1(49,15)=1+y(23);
g1(49,58)=(-1);
g1(49,63)=(-1);
g1(49,22)=(-y(4));
g1(49,72)=y(41)-params(20)*y(5);
g1(49,23)=y(15);
g1(50,18)=(-params(23));
g1(50,65)=1;
g1(50,104)=(-1);
g1(51,19)=(-params(22));
g1(51,66)=1;
g1(51,105)=(-1);
g1(52,20)=(-params(23));
g1(52,67)=1;
g1(52,106)=(-1);
g1(53,12)=(-params(23));
g1(53,55)=1;
g1(53,108)=(-1);
g1(54,13)=(-params(23));
g1(54,56)=1;
g1(54,109)=(-1);
g1(55,14)=(-params(23));
g1(55,57)=1;
g1(55,110)=(-1);
g1(56,15)=(-params(23));
g1(56,58)=1;
g1(56,111)=(-1);
g1(57,11)=(-params(23));
g1(57,54)=1;
g1(57,107)=(-1);
g1(58,27)=(-(params(41)*1/y(27)));
g1(58,83)=1/y(83);
g1(58,99)=(-1);
g1(59,25)=(-(params(40)*1/y(25)));
g1(59,81)=1/y(81);
g1(59,100)=(-1);
g1(60,26)=(-(params(40)*1/y(26)));
g1(60,82)=1/y(82);
g1(60,101)=(-1);
g1(61,16)=(-params(42));
g1(61,63)=1;
g1(61,102)=(-1);
g1(62,17)=(-params(42));
g1(62,64)=1;
g1(62,103)=(-1);
g1(63,28)=(-params(43));
g1(63,91)=1;
g1(63,112)=(-1);

end
