function T = dynamic_g1_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_g1_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 12);

T = bondpurchases6.dynamic_resid_tt(T, y, x, params, steady_state, it_);

T(8) = 1/params(56)/(y(30)/params(56));
T(9) = getPowerDeriv(y(37)/y(51),params(12),1);
T(10) = (-(params(14)*y(90)))/(y(87)*y(87));
T(11) = getPowerDeriv(y(88)/y(87),params(14),1);
T(12) = params(14)/y(87);

end
