function residual = dynamic_resid(T, y, x, params, steady_state, it_, T_flag)
% function residual = dynamic_resid(T, y, x, params, steady_state, it_, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double   vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double   vector of endogenous variables in the order stored
%                                                     in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double   matrix of exogenous variables (in declaration order)
%                                                     for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double   vector of steady state values
%   params        [M_.param_nbr by 1]        double   vector of parameter values in declaration order
%   it_           scalar                     double   time period for exogenous variables for which
%                                                     to evaluate the model
%   T_flag        boolean                    boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   residual
%

if T_flag
    T = bondpurchases6.dynamic_resid_tt(T, y, x, params, steady_state, it_);
end
residual = zeros(63, 1);
lhs = y(68);
rhs = (1-params(1))*y(30)/y(29);
residual(1) = lhs - rhs;
lhs = y(68);
rhs = T(1)/y(86);
residual(2) = lhs - rhs;
lhs = y(30);
rhs = T(3)*T(4);
residual(3) = lhs - rhs;
lhs = y(33)+y(37);
rhs = (1-params(1))*y(30)+(1+y(21))*y(2)+y(52)+y(63);
residual(4) = lhs - rhs;
lhs = y(86);
rhs = y(33)^(-params(38));
residual(5) = lhs - rhs;
lhs = y(86);
rhs = params(8)/y(81)*(1+y(69))*y(98);
residual(6) = lhs - rhs;
lhs = y(48);
rhs = y(40)-y(44);
residual(7) = lhs - rhs;
lhs = y(49);
rhs = y(41)-y(45);
residual(8) = lhs - rhs;
lhs = y(50);
rhs = y(49)*y(72);
residual(9) = lhs - rhs;
lhs = y(47);
rhs = y(48)+y(49)*y(72);
residual(10) = lhs - rhs;
lhs = y(87);
rhs = y(48)+y(49)*y(72)+y(51)+y(38)-y(37)-y(54);
residual(11) = lhs - rhs;
lhs = y(88);
rhs = y(38)*params(16)+y(50)*params(15);
residual(12) = lhs - rhs;
lhs = (1+y(21))*y(2)+y(31)+(1+y(24))*y(11)-(1+y(22))*y(8)-(1+y(72)*params(20))*y(9)-(1+y(79))*y(10)-(1+y(23))*y(3);
rhs = y(37)+y(54)-y(48)-y(49)*y(72)-y(51)-y(38);
residual(13) = lhs - rhs;
lhs = y(84);
rhs = y(31)^(-params(4));
residual(14) = lhs - rhs;
lhs = y(84);
rhs = params(9)/y(82)*(1+y(76))*y(96);
residual(15) = lhs - rhs;
lhs = 1+y(70)+T(5);
rhs = 1+y(76);
residual(16) = lhs - rhs;
lhs = T(5)+1+y(71)-y(90)*params(15)*params(14)/y(88);
rhs = 1+y(76);
residual(17) = lhs - rhs;
lhs = T(5)+1+y(77)-y(90)*params(16)*params(14)/y(88);
rhs = 1+y(76);
residual(18) = lhs - rhs;
lhs = 1+y(79)+T(5)+params(12)*y(89)/y(51);
rhs = 1+y(76);
residual(19) = lhs - rhs;
lhs = 1+y(69)+T(5)+params(12)*y(89)/y(37);
rhs = 1+y(76);
residual(20) = lhs - rhs;
lhs = T(5)+1+y(80);
rhs = 1+y(76);
residual(21) = lhs - rhs;
lhs = y(72);
rhs = (1+params(20)*y(94))/(1+y(71));
residual(22) = lhs - rhs;
lhs = y(73);
rhs = params(20)+1/y(72)-1;
residual(23) = lhs - rhs;
lhs = y(74);
rhs = (1+params(20)*y(95))/(1+y(70));
residual(24) = lhs - rhs;
lhs = y(75);
rhs = params(20)+1/y(74)-1;
residual(25) = lhs - rhs;
lhs = y(89);
rhs = params(77)*(y(37)/y(51))^params(12)/T(6);
residual(26) = lhs - rhs;
lhs = y(90);
rhs = params(78)*(y(88)/y(87))^params(14)/T(7);
residual(27) = lhs - rhs;
lhs = y(60);
rhs = y(38)+y(55)+y(56)+y(57)+y(58);
residual(28) = lhs - rhs;
lhs = y(59);
rhs = y(60)-(1+y(23))*(y(3)+y(12)+y(15))-(1+y(23)-0.0025)*(y(13)+y(14))+y(17);
residual(29) = lhs - rhs;
lhs = y(61);
rhs = y(59)+params(1)*y(30);
residual(30) = lhs - rhs;
lhs = y(32)+y(35);
rhs = y(61);
residual(31) = lhs - rhs;
lhs = y(36);
rhs = y(35)+y(1)*(1-params(2))-params(3)/2*(y(36)-y(1))^2/params(57);
residual(32) = lhs - rhs;
lhs = y(85);
rhs = y(32)^(-params(37));
residual(33) = lhs - rhs;
lhs = y(85);
rhs = params(10)*(1+y(78))*y(97);
residual(34) = lhs - rhs;
lhs = y(85)*(1+params(3)*(y(36)-y(1))/params(57));
rhs = params(1)*params(10)*y(97)*y(92)/y(36)+params(10)*y(97)*(1-params(2)+params(3)*(y(93)-y(36))/params(57));
residual(35) = lhs - rhs;
lhs = y(62);
rhs = params(17)-params(18)*log(y(30)/params(56))+params(19)*log(y(38)/params(33))-log(y(30)/params(56))*params(19);
residual(36) = lhs - rhs;
lhs = y(78);
rhs = y(77)+y(62)-y(91)-y(57)/(params(56)*params(44)*4)*0.25;
residual(37) = lhs - rhs;
lhs = y(34);
rhs = y(33)+y(31)+y(32);
residual(38) = lhs - rhs;
lhs = y(44);
rhs = params(64)+y(65)-y(67);
residual(39) = lhs - rhs;
lhs = y(45);
rhs = params(65)+y(66)+y(67)/y(72);
residual(40) = lhs - rhs;
lhs = y(46);
rhs = y(45)*y(72);
residual(41) = lhs - rhs;
lhs = y(43);
rhs = y(44)+y(45)*y(72);
residual(42) = lhs - rhs;
lhs = y(51);
rhs = y(57)+y(56)+y(55)+y(54)+y(44)+y(45)*y(72);
residual(43) = lhs - rhs;
lhs = y(53);
rhs = (1+y(24))*y(11)+(1+y(22))*y(6)+(1+y(72)*params(20))*y(7)+(1+y(23))*y(12)+(1+y(23)-0.0025)*(y(14)+y(13)-y(17))-(1+y(79))*y(10);
residual(44) = lhs - rhs;
lhs = y(52);
rhs = params(71)-params(25)*params(28)*(y(39)-params(59));
residual(45) = lhs - rhs;
lhs = y(40);
rhs = (1-params(21))*y(41)*y(72)/params(21);
residual(46) = lhs - rhs;
lhs = y(42);
rhs = y(41)*y(72);
residual(47) = lhs - rhs;
lhs = y(39);
rhs = y(40)+y(42);
residual(48) = lhs - rhs;
lhs = y(40)+y(41)*y(72);
rhs = y(58)+y(63)+y(52)+(1+y(22))*y(4)+(1+y(72)*params(20))*y(5)-y(53)+params(24)-(1+y(23))*y(15);
residual(49) = lhs - rhs;
lhs = y(65);
rhs = params(23)*y(18)+x(it_, 6);
residual(50) = lhs - rhs;
lhs = y(66);
rhs = params(22)*y(19)+x(it_, 7);
residual(51) = lhs - rhs;
lhs = y(67);
rhs = params(23)*y(20)+x(it_, 8);
residual(52) = lhs - rhs;
lhs = y(55);
rhs = y(12)*params(23)+x(it_, 10);
residual(53) = lhs - rhs;
lhs = y(56);
rhs = y(13)*params(23)+x(it_, 11);
residual(54) = lhs - rhs;
lhs = y(57);
rhs = y(14)*params(23)+x(it_, 12);
residual(55) = lhs - rhs;
lhs = y(58);
rhs = y(15)*params(23)+x(it_, 13);
residual(56) = lhs - rhs;
lhs = y(54);
rhs = y(11)*params(23)+x(it_, 9);
residual(57) = lhs - rhs;
lhs = log(y(83));
rhs = params(41)*log(y(27))+x(it_, 1);
residual(58) = lhs - rhs;
lhs = log(y(81));
rhs = params(40)*log(y(25))+x(it_, 2);
residual(59) = lhs - rhs;
lhs = log(y(82));
rhs = params(40)*log(y(26))+x(it_, 3);
residual(60) = lhs - rhs;
lhs = y(63);
rhs = params(42)*y(16)+x(it_, 4);
residual(61) = lhs - rhs;
lhs = y(64);
rhs = y(17)*params(42)+x(it_, 5);
residual(62) = lhs - rhs;
lhs = y(91);
rhs = y(28)*params(43)+x(it_, 14);
residual(63) = lhs - rhs;

end
