clc;
clear variables;
close all;

% Setting of selected parameters.

printslidesindicator=0;

yss=1;

bondriskweight=0.25;
loanriskweight=0.5;
liqexponent=2;
credexponent=2;

loandefaultprobsemielasticity=0.042;
defaultprobsemielasticity=0.25;
fiscalpolicyrulecoef=0.01;

varphi=0.5;

save('benchmarkparam_openmktops', ...
    'printslidesindicator', ...
    'yss', ...
    'bondriskweight','loanriskweight','liqexponent','credexponent', ...
    'defaultprobsemielasticity','loandefaultprobsemielasticity','fiscalpolicyrulecoef','varphi'); 

% Plotting of Figures 1-3. 
% The "for yearsetting" loop calls the scripts "irfscript.m" and "printscript.m" and the Dynare model file "bondpurchases6.mod"
% to compute, first, the 2020 case (yearsetting=2019), and, then, the 2008 case (yearsetting=2008).

if 1

load('benchmarkparam_openmktops')

printsuffix='';
for yearsetting=[2019 2008]
 
if yearsetting==2019
depositsrss=0.0001;
rss=0.0033;
bondrss=0.0058; 
grossfirmrss=0.0115;
    reservesss = .0791*4*yss;
    bankgovtdebtss=0.1381*4*yss;
    bankloansss = .497*4*yss;
    depositsss = .606*4*yss;
    linestyle='-';
elseif yearsetting==2008
depositsrss=0.0008;
rss=0.0068;
bondrss=0.0111; 
grossfirmrss=0.0167;
    reservesss = .0225*4*yss;
    bankgovtdebtss=0.0776*4*yss;
    bankloansss = .511*4*yss;
    depositsss = .468*4*yss;
    linestyle='--';
end

save param_bondpurchases 

dynare bondpurchases6
%steadystate=oo_.steady_state;
RawParameterTable=[cell2table(M_.param_names,'Variablenames',{'param_names'}) array2table(M_.params,'Variablenames',{'params'})];
if yearsetting==2019
ParameterTable2020=RawParameterTable(1:36,:)
elseif yearsetting==2008
ParameterTable2008=RawParameterTable(1:36,:)
end

figurenumber=0;

% Figure 1
shocktype='bondpurchasesshock'; sign=''; irfscript; printscript;
% Figure 2
shocktype='directlendingshock'; sign=''; irfscript; printscript;
% Figure 3
shocktype='margeffectdirectlendingshock'; sign=''; irfscript; printscript;

end

end

% Plotting of Figure 4.
% The "for yearsetting" loop computes, first, the effects with the
% benchmark parameterization (yearsetting=2019), and, then, the effects with one changed parameter (yearsetting=2008).
% The nested "for shocknumber" loop computes, first, the effects of quantitative easing (shocknumber=1), and,
% then, the effects of direct lending (shocknumber=2).

if 1

figure(4)
set(gcf,'Name','Sensitivity')

numberofparameters=7;
numberofrows=numberofparameters; numberofcolumns=2;
for parameternumber=1:numberofparameters

for yearsetting=[2019 2008]

if yearsetting==2019
linestyle='-';
elseif yearsetting==2008
linestyle='--';
end

load('benchmarkparam_openmktops')
depositsrss=0.0001;
rss=0.0033;
bondrss=0.0058; 
grossfirmrss=0.0115;
    reservesss = .0791*4*yss;
    bankgovtdebtss=0.1381*4*yss;
    bankloansss = .497*4*yss;
    depositsss = .606*4*yss;

switch parameternumber
    case 2
paramequalstring='$\lambda=$';
benchmarkvalue=liqexponent;
altvalue=10;
if yearsetting==2008, liqexponent=altvalue; end
    case 3
paramequalstring='$\rho=$';
benchmarkvalue=credexponent;
altvalue=10;
if yearsetting==2008, credexponent=altvalue; end
    case 4
paramequalstring='$\omega_L=$';
benchmarkvalue=loanriskweight;
altvalue=1;
if yearsetting==2008, loanriskweight=altvalue; end
    case 5
paramequalstring='$\eta_y=$';
benchmarkvalue=defaultprobsemielasticity;
altvalue=0.5;
if yearsetting==2008, defaultprobsemielasticity=altvalue; end
    case 6
paramequalstring='$\eta_L=$';
benchmarkvalue=loandefaultprobsemielasticity;
altvalue=0.1;
if yearsetting==2008, loandefaultprobsemielasticity=altvalue; end
    case 7
paramequalstring='$\varphi=$';
benchmarkvalue=varphi;
altvalue=2;
if yearsetting==2008, varphi=altvalue; end
    case 1
rchange=rss-depositsrss; 
if yearsetting==2008, rss=rss+rchange; bondrss=bondrss+rchange; grossfirmrss=grossfirmrss+rchange;  end
end

save param_bondpurchases 

dynare bondpurchases6

switch parameternumber
    case 1
paramequalstring='$A_g=$';
if yearsetting==2019, benchmarkvalue=round(altliqfrictionss,4); altvalue=round(altliqfrictionss,4); end
if yearsetting==2008, altvalue=round(altliqfrictionss,4); end
end

legendnames=char([paramequalstring,num2str(benchmarkvalue)],[paramequalstring,num2str(altvalue)]);

for shocknumber=[1 2]

if shocknumber==1, shocktype='bondpurchasesshock'; elseif shocknumber==2, shocktype='directlendingshock'; end

eval(cat(2,'fosresponse=[y_',shocktype,'./yss];'))

subplot(numberofrows,numberofcolumns,2*(parameternumber-1)+shocknumber)
if yearsetting==2019, hold off, end
plot(fosresponse(:,1),'LineStyle',linestyle,'LineWidth',1)
hold on
ax = gca;
ax.YAxis.Exponent=0;
yl=ylim; 
if max(abs(yl))<1/100000, ylim([-1 1]), end
if yearsetting==2008, plot(zeros(size(fosresponse(:,1))),'LineStyle','-','LineWidth',0.01), end

if parameternumber==1
if shocknumber==1, title('Effect of quantitative easing on $y_t$',' ','FontSize',11,'Interpreter','latex'),
elseif shocknumber==2, title('Effect of direct lending on $y_t$',' ','FontSize',11,'Interpreter','latex'),
end
end

if yearsetting==2008, legend(legendnames,'FontSize',10,'Interpreter','latex','AutoUpdate','off'), end

end

end

end

set(gcf,'paperposition',[0 0 7 9])
%print('-deps','sensitivity')

end