clear all
close all
clc

data = xlsread("fig_b2.xlsx","A2:B131");
yyaxis left; plot(data(:,2),'k--','LineWidth',2);set(gca,'ycolor','k');ylim([0.5,3]);
ylabel('$\%$','Interpreter','Latex','FontSize',18);

yyaxis right; plot(data(:,1),'-','Color',[0,0.447,0.741],'LineWidth',2);ylim([0,.8]);
ylabel('$\gamma$','Interpreter','Latex','FontSize',18);

set(gca,'ycolor',[0,0.447,0.741]);
xlim([1,131])

xticks([ 1 41 91 131])
xticklabels({'1970-1980','1980-1990','1990-2000','2010-2020','Interpreter','Latex','FontSize',12})
grid on

legend('Inflation Volatility','Attention $\gamma$','Interpreter','Latex','FontSize',18)

