clear all
close all
clc

data = xlsread("data_figb1.xlsx","B2:E206");

spf_exp = data(:,1)*400;
gdpdef = data(:,2)*400;
soc_exp = data(:,3)*400;
cpi = data(:,4)*400;

% Figure B1:
figure(1)
subplot(212);
plot(1968.75:0.25:2019.75,cpi,'k-','LineWidth',2.5); hold on
plot(1968.75:0.25:2019.75,soc_exp,'-.','LineWidth',2.5,'Color',[0, 0.4470, 0.7410]); hold on
% plot(1968.75:0.25:2019.75,X(:,3),':','Color',[0.6350, 0.0780, 0.1840],'LineWidth',1.5); %plot(1968.75:0.25:2019.75,X(:,2),'k-','LineWidth',2)
legend('CPI Inflation','Michigan','Interpreter','Latex','FontSize',18)
set(gca,'ycolor','k') ;%title('SPF w/o FE','Interpreter','Latex','FontSize',25);
xlabel('Year','Interpreter','Latex','FontSize',18);xlim([1970,2020])
ylabel('$\%$','Interpreter','Latex','FontSize',18)
grid on
box on
subplot(211);
plot(1968.75:0.25:2019.75,gdpdef,'k-','LineWidth',2.5); hold on
plot(1968.75:0.25:2019.75,spf_exp,'-.','LineWidth',2.5,'Color',[0, 0.4470, 0.7410]); hold on
legend('GDP Deflator Inflation','SPF','Interpreter','Latex','FontSize',18)
set(gca,'ycolor','k') ;%title('SPF w/o FE','Interpreter','Latex','FontSize',25);
xlabel('Year','Interpreter','Latex','FontSize',18);xlim([1970,2020])
ylabel('$\%$','Interpreter','Latex','FontSize',18)
grid on
box on
ax = gca;
% set(ax,'position',pos);
x0=20;
y0=20;
width=700;
height=400
set(gcf,'position',[x0,y0,width,height])

% Table B1:
[mean(gdpdef(1:85)), mean(gdpdef(85:end)), mean(spf_exp(1:85)), mean(spf_exp(85:end))]
[std(gdpdef(1:85)), std(gdpdef(85:end)), std(spf_exp(1:85)), std(spf_exp(85:end))]
[corr(gdpdef(1:85),gdpdef(2:86)), corr(gdpdef(85:end-1),gdpdef(86:end)),corr(spf_exp(1:85),spf_exp(2:86)), corr(spf_exp(85:end-1),spf_exp(86:end))]

[mean(cpi(1:85)), mean(cpi(85:end)), mean(soc_exp(1:85)), mean(soc_exp(85:end))]
[std(cpi(1:85)), std(cpi(85:end)), std(soc_exp(1:85)), std(soc_exp(85:end))]
[corr(cpi(1:85),cpi(2:86)), corr(cpi(85:end-1),cpi(86:end)),corr(soc_exp(1:85),soc_exp(2:86)), corr(soc_exp(85:end-1),soc_exp(86:end))]
