function [residual, g1, g2, g3] = ey_dynamic(y, x, params, steady_state, it_)
%
% Status : Computes dynamic model for Dynare
%
% Inputs :
%   y         [#dynamic variables by 1] double    vector of endogenous variables in the order stored
%                                                 in M_.lead_lag_incidence; see the Manual
%   x         [nperiods by M_.exo_nbr] double     matrix of exogenous variables (in declaration order)
%                                                 for all simulation periods
%   steady_state  [M_.endo_nbr by 1] double       vector of steady state values
%   params    [M_.param_nbr by 1] double          vector of parameter values in declaration order
%   it_       scalar double                       time period for exogenous variables for which to evaluate the model
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the dynamic model equations in order of 
%                                          declaration of the equations.
%                                          Dynare may prepend auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by #dynamic variables] double    Jacobian matrix of the dynamic model equations;
%                                                           rows: equations in order of declaration
%                                                           columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%   g2        [M_.endo_nbr by (#dynamic variables)^2] double   Hessian matrix of the dynamic model equations;
%                                                              rows: equations in order of declaration
%                                                              columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%   g3        [M_.endo_nbr by (#dynamic variables)^3] double   Third order derivative matrix of the dynamic model equations;
%                                                              rows: equations in order of declaration
%                                                              columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

%
% Model equations
%

residual = zeros(17, 1);
lhs =y(22);
rhs =(1-params(16))*y(5)+params(16)*y(8);
residual(1)= lhs-rhs;
lhs =y(8);
rhs =y(22)-params(2)*(y(16)-y(6)-y(10));
residual(2)= lhs-rhs;
lhs =y(6);
rhs =(1-params(10))*y(1)+params(10)*y(7);
residual(3)= lhs-rhs;
lhs =y(7);
rhs =y(6)*params(1)+y(8)*params(11)+y(11);
residual(4)= lhs-rhs;
residual(5) = y(16)-params(14)*y(3)-(1-params(14))*(y(7)*params(3)+y(8)*params(4));
lhs =y(11);
rhs =x(it_, 1);
residual(6)= lhs-rhs;
lhs =y(10);
rhs =params(8)*y(2)+x(it_, 2);
residual(7)= lhs-rhs;
lhs =y(15);
rhs =y(26);
residual(8)= lhs-rhs;
lhs =y(9);
rhs =y(16)-y(6);
residual(9)= lhs-rhs;
lhs =y(14);
rhs =y(17)-y(26);
residual(10)= lhs-rhs;
lhs =y(12);
rhs =y(25)-params(2)*(y(17)-y(26)-y(10));
residual(11)= lhs-rhs;
lhs =y(13);
rhs =y(11)+params(1)*y(26)+params(11)*y(12);
residual(12)= lhs-rhs;
lhs =y(17);
rhs =params(14)*y(4)+(1-params(14))*(params(3)*y(13)+params(4)*y(12));
residual(13)= lhs-rhs;
lhs =y(18);
rhs =y(23);
residual(14)= lhs-rhs;
lhs =y(19);
rhs =y(24);
residual(15)= lhs-rhs;
lhs =y(20);
rhs =y(7)-y(6);
residual(16)= lhs-rhs;
lhs =y(21);
rhs =y(7)*0.8523;
residual(17)= lhs-rhs;
if nargout >= 2,
  g1 = zeros(17, 28);

  %
  % Jacobian matrix
  %

  g1(1,8)=(-params(16));
  g1(1,5)=(-(1-params(16)));
  g1(1,22)=1;
  g1(2,6)=(-params(2));
  g1(2,8)=1;
  g1(2,10)=(-params(2));
  g1(2,16)=params(2);
  g1(2,22)=(-1);
  g1(3,1)=(-(1-params(10)));
  g1(3,6)=1;
  g1(3,7)=(-params(10));
  g1(4,6)=(-params(1));
  g1(4,7)=1;
  g1(4,8)=(-params(11));
  g1(4,11)=(-1);
  g1(5,7)=(-((1-params(14))*params(3)));
  g1(5,8)=(-((1-params(14))*params(4)));
  g1(5,3)=(-params(14));
  g1(5,16)=1;
  g1(6,11)=1;
  g1(6,27)=(-1);
  g1(7,2)=(-params(8));
  g1(7,10)=1;
  g1(7,28)=(-1);
  g1(8,26)=(-1);
  g1(8,15)=1;
  g1(9,6)=1;
  g1(9,9)=1;
  g1(9,16)=(-1);
  g1(10,26)=1;
  g1(10,14)=1;
  g1(10,17)=(-1);
  g1(11,10)=(-params(2));
  g1(11,12)=1;
  g1(11,25)=(-1);
  g1(11,26)=(-params(2));
  g1(11,17)=params(2);
  g1(12,11)=(-1);
  g1(12,12)=(-params(11));
  g1(12,13)=1;
  g1(12,26)=(-params(1));
  g1(13,12)=(-((1-params(14))*params(4)));
  g1(13,13)=(-((1-params(14))*params(3)));
  g1(13,4)=(-params(14));
  g1(13,17)=1;
  g1(14,23)=(-1);
  g1(14,18)=1;
  g1(15,24)=(-1);
  g1(15,19)=1;
  g1(16,6)=1;
  g1(16,7)=(-1);
  g1(16,20)=1;
  g1(17,7)=(-0.8523);
  g1(17,21)=1;

if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],17,784);
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],17,21952);
end
end
end
end
