function [residual, g1, g2, g3] = ey_zlb_dynamic(y, x, params, steady_state, it_)
%
% Status : Computes dynamic model for Dynare
%
% Inputs :
%   y         [#dynamic variables by 1] double    vector of endogenous variables in the order stored
%                                                 in M_.lead_lag_incidence; see the Manual
%   x         [nperiods by M_.exo_nbr] double     matrix of exogenous variables (in declaration order)
%                                                 for all simulation periods
%   steady_state  [M_.endo_nbr by 1] double       vector of steady state values
%   params    [M_.param_nbr by 1] double          vector of parameter values in declaration order
%   it_       scalar double                       time period for exogenous variables for which to evaluate the model
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the dynamic model equations in order of 
%                                          declaration of the equations.
%                                          Dynare may prepend auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by #dynamic variables] double    Jacobian matrix of the dynamic model equations;
%                                                           rows: equations in order of declaration
%                                                           columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%   g2        [M_.endo_nbr by (#dynamic variables)^2] double   Hessian matrix of the dynamic model equations;
%                                                              rows: equations in order of declaration
%                                                              columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%   g3        [M_.endo_nbr by (#dynamic variables)^3] double   Third order derivative matrix of the dynamic model equations;
%                                                              rows: equations in order of declaration
%                                                              columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

%
% Model equations
%

residual = zeros(17, 1);
lhs =y(20);
rhs =(1-params(16))*y(3)+params(16)*y(6);
residual(1)= lhs-rhs;
lhs =y(6);
rhs =y(20)-params(2)*(y(14)-y(4)-y(8));
residual(2)= lhs-rhs;
lhs =y(4);
rhs =(1-params(10))*y(1)+params(10)*y(5);
residual(3)= lhs-rhs;
lhs =y(5);
rhs =y(4)*params(1)+y(6)*params(11)+y(9);
residual(4)= lhs-rhs;
residual(5) = y(14)+params(13)/400;
lhs =y(9);
rhs =x(it_, 1);
residual(6)= lhs-rhs;
lhs =y(8);
rhs =params(8)*y(2)+x(it_, 2);
residual(7)= lhs-rhs;
lhs =y(13);
rhs =y(24);
residual(8)= lhs-rhs;
lhs =y(7);
rhs =y(14)-y(4);
residual(9)= lhs-rhs;
lhs =y(12);
rhs =y(15)-y(24);
residual(10)= lhs-rhs;
lhs =y(10);
rhs =y(23)-params(2)*(y(15)-y(24)-y(8));
residual(11)= lhs-rhs;
lhs =y(11);
rhs =y(9)+params(1)*y(24)+params(11)*y(10);
residual(12)= lhs-rhs;
lhs =y(15);
rhs =(-params(13))/400;
residual(13)= lhs-rhs;
lhs =y(16);
rhs =y(21);
residual(14)= lhs-rhs;
lhs =y(17);
rhs =y(22);
residual(15)= lhs-rhs;
lhs =y(18);
rhs =y(5)-y(4);
residual(16)= lhs-rhs;
lhs =y(19);
rhs =y(5)*0.8523;
residual(17)= lhs-rhs;
if nargout >= 2,
  g1 = zeros(17, 26);

  %
  % Jacobian matrix
  %

  g1(1,6)=(-params(16));
  g1(1,3)=(-(1-params(16)));
  g1(1,20)=1;
  g1(2,4)=(-params(2));
  g1(2,6)=1;
  g1(2,8)=(-params(2));
  g1(2,14)=params(2);
  g1(2,20)=(-1);
  g1(3,1)=(-(1-params(10)));
  g1(3,4)=1;
  g1(3,5)=(-params(10));
  g1(4,4)=(-params(1));
  g1(4,5)=1;
  g1(4,6)=(-params(11));
  g1(4,9)=(-1);
  g1(5,14)=1;
  g1(6,9)=1;
  g1(6,25)=(-1);
  g1(7,2)=(-params(8));
  g1(7,8)=1;
  g1(7,26)=(-1);
  g1(8,24)=(-1);
  g1(8,13)=1;
  g1(9,4)=1;
  g1(9,7)=1;
  g1(9,14)=(-1);
  g1(10,24)=1;
  g1(10,12)=1;
  g1(10,15)=(-1);
  g1(11,8)=(-params(2));
  g1(11,10)=1;
  g1(11,23)=(-1);
  g1(11,24)=(-params(2));
  g1(11,15)=params(2);
  g1(12,9)=(-1);
  g1(12,10)=(-params(11));
  g1(12,11)=1;
  g1(12,24)=(-params(1));
  g1(13,15)=1;
  g1(14,21)=(-1);
  g1(14,16)=1;
  g1(15,22)=(-1);
  g1(15,17)=1;
  g1(16,4)=1;
  g1(16,5)=(-1);
  g1(16,18)=1;
  g1(17,5)=(-0.8523);
  g1(17,19)=1;

if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],17,676);
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],17,17576);
end
end
end
end
