function [residual, g1, g2, g3] = m1_dynamic(y, x, params, steady_state, it_)
%
% Status : Computes dynamic model for Dynare
%
% Inputs :
%   y         [#dynamic variables by 1] double    vector of endogenous variables in the order stored
%                                                 in M_.lead_lag_incidence; see the Manual
%   x         [nperiods by M_.exo_nbr] double     matrix of exogenous variables (in declaration order)
%                                                 for all simulation periods
%   steady_state  [M_.endo_nbr by 1] double       vector of steady state values
%   params    [M_.param_nbr by 1] double          vector of parameter values in declaration order
%   it_       scalar double                       time period for exogenous variables for which to evaluate the model
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the dynamic model equations in order of 
%                                          declaration of the equations.
%                                          Dynare may prepend auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by #dynamic variables] double    Jacobian matrix of the dynamic model equations;
%                                                           rows: equations in order of declaration
%                                                           columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%   g2        [M_.endo_nbr by (#dynamic variables)^2] double   Hessian matrix of the dynamic model equations;
%                                                              rows: equations in order of declaration
%                                                              columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%   g3        [M_.endo_nbr by (#dynamic variables)^3] double   Third order derivative matrix of the dynamic model equations;
%                                                              rows: equations in order of declaration
%                                                              columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

%
% Model equations
%

residual = zeros(15, 1);
lhs =y(7);
rhs =y(21)-params(2)*(y(15)-y(5)-y(9));
residual(1)= lhs-rhs;
lhs =y(5);
rhs =(1-params(10))*y(1)+params(10)*y(6);
residual(2)= lhs-rhs;
lhs =y(6);
rhs =y(5)*params(1)+y(7)*params(11)+y(10);
residual(3)= lhs-rhs;
residual(4) = y(15)-params(14)*y(3)-(1-params(14))*(y(6)*params(3)+y(7)*params(4));
lhs =y(10);
rhs =x(it_, 1);
residual(5)= lhs-rhs;
lhs =y(9);
rhs =params(8)*y(2)+x(it_, 2);
residual(6)= lhs-rhs;
lhs =y(14);
rhs =y(23);
residual(7)= lhs-rhs;
lhs =y(8);
rhs =y(15)-y(5);
residual(8)= lhs-rhs;
lhs =y(13);
rhs =y(16)-y(23);
residual(9)= lhs-rhs;
lhs =y(11);
rhs =y(22)-params(2)*(y(16)-y(23)-y(9));
residual(10)= lhs-rhs;
lhs =y(12);
rhs =y(10)+params(1)*y(23)+params(11)*y(11);
residual(11)= lhs-rhs;
lhs =y(16);
rhs =params(14)*y(4)+(1-params(14))*(params(3)*y(12)+params(4)*y(11));
residual(12)= lhs-rhs;
lhs =y(17);
rhs =y(20);
residual(13)= lhs-rhs;
lhs =y(18);
rhs =y(21);
residual(14)= lhs-rhs;
lhs =y(19);
rhs =y(6)-y(5);
residual(15)= lhs-rhs;
if nargout >= 2,
  g1 = zeros(15, 25);

  %
  % Jacobian matrix
  %

  g1(1,5)=(-params(2));
  g1(1,7)=1;
  g1(1,21)=(-1);
  g1(1,9)=(-params(2));
  g1(1,15)=params(2);
  g1(2,1)=(-(1-params(10)));
  g1(2,5)=1;
  g1(2,6)=(-params(10));
  g1(3,5)=(-params(1));
  g1(3,6)=1;
  g1(3,7)=(-params(11));
  g1(3,10)=(-1);
  g1(4,6)=(-((1-params(14))*params(3)));
  g1(4,7)=(-((1-params(14))*params(4)));
  g1(4,3)=(-params(14));
  g1(4,15)=1;
  g1(5,10)=1;
  g1(5,24)=(-1);
  g1(6,2)=(-params(8));
  g1(6,9)=1;
  g1(6,25)=(-1);
  g1(7,23)=(-1);
  g1(7,14)=1;
  g1(8,5)=1;
  g1(8,8)=1;
  g1(8,15)=(-1);
  g1(9,23)=1;
  g1(9,13)=1;
  g1(9,16)=(-1);
  g1(10,9)=(-params(2));
  g1(10,11)=1;
  g1(10,22)=(-1);
  g1(10,23)=(-params(2));
  g1(10,16)=params(2);
  g1(11,10)=(-1);
  g1(11,11)=(-params(11));
  g1(11,12)=1;
  g1(11,23)=(-params(1));
  g1(12,11)=(-((1-params(14))*params(4)));
  g1(12,12)=(-((1-params(14))*params(3)));
  g1(12,4)=(-params(14));
  g1(12,16)=1;
  g1(13,20)=(-1);
  g1(13,17)=1;
  g1(14,21)=(-1);
  g1(14,18)=1;
  g1(15,5)=1;
  g1(15,6)=(-1);
  g1(15,19)=1;

if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],15,625);
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],15,15625);
end
end
end
end
