
addpath /Users/op3563/Dropbox/NewProject_2020/JMCB_Final_Submission/ReplicationMaterial_OnlineAppendix/Model/Taylor_Rule/toolkit_files
addpath /Applications/Dynare/4.5.4/matlab
clear all
close all
clc

positive_shock = 1; % setting this to 1 produces the left panel of Fig E7. Otherwise, it produces the right panel.

for kk = 1:2

GAMMA = [0.3];
for j =1:length(GAMMA)
Gamma = GAMMA(j);
global M_ oo_ rn_steady beta



modnam = 'fe';
modnamstar = 'fe_zlb';



if kk == 1
constraint = 'i<-rn_steady/400';
constraint_relax ='i>-rn_steady/400';
else
constraint = 'ire<-rn_steady/400';
constraint_relax ='ire>-rn_steady/400';
    
end

irfshock =char('eps_rn','eps_u');     

maxiter = 10;
tol0 = 1e-8;






if positive_shock == 1

SHOCKS = [0 0
    0.00294*3  0*0.154/100
  zeros(40,2) ] ;
else

SHOCKS = [0 0
    -0.00294*3  0*0.154/100
  zeros(40,2) ] ;

end

shockssequence = SHOCKS;
nperiods = 40;

% 


% Solve model, generate model IRFs
[zdatalinear zdatapiecewise zdatass oobase_ Mbase_  ] = ...
  solve_one_constraint(modnam,modnamstar,...
  constraint, constraint_relax,...
  shockssequence,irfshock,nperiods);


% unpack the IRFs                          
for i=1:M_.endo_nbr
  eval([deblank(M_.endo_names(i,:)),'_u=zdatalinear(:,i);']);
  eval([deblank(M_.endo_names(i,:)),'_p=zdatapiecewise(:,i);']);
  eval([deblank(M_.endo_names(i,:)),'_ss=zdatass(i);']);
end


if kk == 1
i_irf(:,j)= i_p*400+rn_steady;
pi_irf(:,j) = pi_p*400;
y_irf(:,j) = y_p*100;
epi_irf(:,j) = Epi_p*400;

else
ire_irf(:,j)= ire_p*400+rn_steady;
pire_irf(:,j) = pire_p*400;
yre_irf(:,j) = yre_p*100;
epire_irf(:,j) = pireexp_p*400;

end
end
end



fig_r = figure(1);
set(fig_r,'DefaultAxesFontSize',15); 
set(fig_r,'DefaultLineLineWidth',2);  
hold on  
plot(1:1:nperiods-1,pi_irf(2:nperiods)- epi_irf(1:nperiods-1,1),'--o','MarkerSize',4.5,'MarkerFaceColor',[0, 0.4470, 0.7410],'Color',[0, 0.4470, 0.7410]);hold on
yline(0,'k-','LineWidth',1)     
hold off
xticks([1 6 11 16 20])
xticklabels({'0','5','10','15','20'})
title('$\pi_{t+1}-\pi^e_{t+1|t}$','Interpreter','Latex','FontSize',20)
ylabel('annualized $\%$','Interpreter','Latex')
xlabel('Time','Interpreter','Latex');xlim([1,20]) 
grid on
box on 

