addpath /Users/op3563/Dropbox/NewProject_2020/JMCB_Final_Submission/ReplicationMaterial_OnlineAppendix/Model/Taylor_Rule/toolkit_files
addpath /Applications/Dynare/4.5.4/matlab
clear all
close all
clc

for kk = 1:2

GAMMA = [0.3];
for j =1:length(GAMMA)
Gamma = GAMMA(j);
global M_ oo_ rn_steady beta



modnam = 'm1';
modnamstar = 'm1_zlb';



%modnam = 'ey';
%modnamstar = 'ey_zlb';



if kk == 1
constraint = 'i<-rn_steady/400';
constraint_relax ='i>-rn_steady/400';
else
constraint = 'ire<-rn_steady/400';
constraint_relax ='ire>-rn_steady/400';
    
end


irfshock =char('eps_rn','eps_u');     

maxiter = 10;
tol0 = 1e-8;








SHOCKS = [0 0
    -0.00294*3  0*0.154/100
  zeros(40,2) ] ;


shockssequence = SHOCKS;
nperiods = 40;

% 


[zdatalinear zdatapiecewise zdatass oobase_ Mbase_  ] = ...
  solve_one_constraint(modnam,modnamstar,...
  constraint, constraint_relax,...
  shockssequence,irfshock,nperiods);


% unpack the IRFs                          
for i=1:M_.endo_nbr
  eval([deblank(M_.endo_names(i,:)),'_u=zdatalinear(:,i);']);
  eval([deblank(M_.endo_names(i,:)),'_p=zdatapiecewise(:,i);']);
  eval([deblank(M_.endo_names(i,:)),'_ss=zdatass(i);']);
end


if kk == 1
i_irf(:,j)= i_p*400+rn_steady;
pi_irf(:,j) = pi_p*400;
y_irf(:,j) = y_p*100;
epi_irf(:,j) = Epi_p*400;
else
ire_irf(:,j)= ire_p*400+rn_steady;
pire_irf(:,j) = pire_p*400;
yre_irf(:,j) = yre_p*100;
epire_irf(:,j) = pireexp_p*400;

end
end
end

fig_r = figure(1);
set(fig_r,'DefaultAxesFontSize',18); 
set(fig_r,'DefaultLineLineWidth',2);  
plot(1:1:nperiods, i_irf(1:nperiods,1),'--o','MarkerSize',4.5,'MarkerFaceColor',[0, 0.4470, 0.7410],'Color',[0, 0.4470, 0.7410]);hold on
hold on
plot(1:1:nperiods,ire_irf(1:nperiods,1),'k-.o','MarkerSize',4.5,'MarkerFaceColor','k');
yline(0,'k-','LineWidth',1)   
legend('Limited Attention','Rational Expectations','Interpreter','Latex','Location','Northwest')
legend boxoff   
hold off
ylabel('annualized $\%$','Interpreter','Latex')
xlabel('Time','Interpreter','Latex');
if modnam == 'ey'
xlim([1,31]) 
else
xlim([1,21]) 
end
ylim([0, 1])
grid on
box on 
xticks([1 6 11 16 21 26 30 ])
xticklabels({'0','5','10','15','20', '25', '30'})
title('$i_t$','Interpreter','Latex','FontSize',20)

fig_r = figure(2);
set(fig_r,'DefaultAxesFontSize',15); 
set(fig_r,'DefaultLineLineWidth',2);  
hold on  
plot(1:1:nperiods, pi_irf(1:nperiods,1),'--o','MarkerSize',4.5,'MarkerFaceColor',[0, 0.4470, 0.7410],'Color',[0, 0.4470, 0.7410]);hold on
plot(1:1:nperiods,pire_irf(1:nperiods,1),'k-.o','MarkerSize',4.5,'MarkerFaceColor','k');hold on
yline(0,'k-','LineWidth',1)   
hold off
ylabel('annualized $\%$','Interpreter','Latex')
xlabel('Time','Interpreter','Latex');xlim([1,20]) 
grid on
box on 
xticks([1 6 11 16 20])
xticklabels({'0','5','10','15','20'})
title('$\pi_t$','Interpreter','Latex','FontSize',20)

fig_r = figure(3);
set(fig_r,'DefaultAxesFontSize',15); 
set(fig_r,'DefaultLineLineWidth',2);  
hold on  
plot(1:1:nperiods, y_irf(1:nperiods,1),'--o','MarkerSize',4.5,'MarkerFaceColor',[0, 0.4470, 0.7410],'Color',[0, 0.4470, 0.7410]);hold on
plot(1:1:nperiods,yre_irf(1:nperiods,1),'k-.o','MarkerSize',4.5,'MarkerFaceColor','k');hold on
yline(0,'k-','LineWidth',1)     
hold off
ylabel('$\%$','Interpreter','Latex')
xlabel('Time','Interpreter','Latex');xlim([1,20]) 
grid on
box on 
xticks([1 6 11 16 20])
xticklabels({'0','5','10','15','20'})
title('$y^{gap}_{t}$','Interpreter','Latex','FontSize',20)


fig_r = figure(4);
set(fig_r,'DefaultAxesFontSize',15); 
set(fig_r,'DefaultLineLineWidth',2);  
hold on  
plot(1:1:nperiods, epi_irf(1:nperiods,1),'--o','MarkerSize',4.5,'MarkerFaceColor',[0, 0.4470, 0.7410],'Color',[0, 0.4470, 0.7410]);hold on
plot(1:1:nperiods,epire_irf(1:nperiods,1),'k-.o','MarkerSize',4.5,'MarkerFaceColor','k');hold on
yline(0,'k-','LineWidth',1)   
hold off
xticks([1 6 11 16 20])
xticklabels({'0','5','10','15','20'})
title('$\pi^e_{t+1|t}$','Interpreter','Latex','FontSize',20)
ylabel('annualized $\%$','Interpreter','Latex')
xlabel('Time','Interpreter','Latex');xlim([1,20]) 
grid on
box on 

