close all
clear all
clc

% The following results are obtained by running main_baseline.m from the
% replication package for the main paper.
pi_baseline = [2.8488, 1.8190, 1.2049, 1.0635];
loss_baseline = [-0.0239,   -0.0106,   -0.0060,   -0.0055];

% The following results are obtained by running main.m in the folder
% Ramsey_Optimal_rho095.
pi0 =[3.1933, 2.0127, 1.9800, 1.1131];

loss0 =[-0.0459, -0.0153, -0.0138, -0.0058];

% The following results are obtained by running main.m in the folder
% Ramsey_Optimal_rho095_pi2.         
pi2 =[3.5677, 2.1408, 1.8415, 1.0958];

loss2 =[ -0.0407, -0.0139, -0.0114, -0.0056];

  % The following results are obtained by running main.m in the folder
% Ramsey_Optimal_rho095_pi4.             
pi4 =[3.9803, 2.5877, 1.6347, 1.0860];


loss4 =[-0.0453, -0.0212, -0.0109, -0.0066];

vec_gamma = [0.05, 0.1, 0.2, 0.3];

% Figure E9 (a) Optimal Inflation Target
fig_r = figure(1);
set(fig_r,'DefaultAxesFontSize',20); 
set(fig_r,'DefaultLineLineWidth',2);  
hold on  
plot(vec_gamma,pi_baseline,'--o','MarkerSize',4.5,'MarkerFaceColor',[0, 0.4470, 0.7410],'Color',[0, 0.4470, 0.7410]);
hold on
plot(vec_gamma,pi0,'-o','MarkerSize',4.5,'MarkerFaceColor',[0.6, 0.6, 0.6],'Color',[0.6, 0.6, 0.6]);
hold on
plot(vec_gamma,pi2,'k-o','MarkerSize',4.5,'MarkerFaceColor','k');
hold on
plot(vec_gamma,pi4,':o','MarkerSize',4.5,'MarkerFaceColor',[0.6350 0.0780 0.1840],'Color',[0.6350 0.0780 0.1840]);
hold on
legend boxoff 
legend('Baseline','$\bar{\pi} = 0\%$','$\bar{\pi} = 2\%$','$\bar{\pi} = 4\%$','Interpreter','Latex','Location','East')
hold off
xlabel('Attention $\gamma$','Interpreter','Latex')
xticks([vec_gamma]); 
xlim([0.045 0.305]) 
grid on
box on 
ax = gca;



% Figure E9 (b) Welfare
fig_r = figure(2);
set(fig_r,'DefaultAxesFontSize',20); 
set(fig_r,'DefaultLineLineWidth',2);  
hold on  
plot(vec_gamma,loss_baseline,'--o','MarkerSize',4.5,'MarkerFaceColor',[0, 0.4470, 0.7410],'Color',[0, 0.4470, 0.7410]);
hold on
plot(vec_gamma,loss0,'-o','MarkerSize',4.5,'MarkerFaceColor',[0.6, 0.6, 0.6],'Color',[0.6, 0.6, 0.6]);
hold on
plot(vec_gamma,loss2,'k-o','MarkerSize',4.5,'MarkerFaceColor','k');
hold on
plot(vec_gamma,loss4,':o','MarkerSize',4.5,'MarkerFaceColor',[0.6350 0.0780 0.1840],'Color',[0.6350 0.0780 0.1840]);
hold on
legend boxoff 
legend('Baseline','$\bar{\pi} = 0\%$','$\bar{\pi} = 2\%$','$\bar{\pi} = 4\%$','Interpreter','Latex','Location','East')
hold off
xlabel('Attention $\gamma$','Interpreter','Latex')
xticks([vec_gamma]); 
xlim([0.045 0.305]) 
grid on
box on 
ax = gca;